/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.LeadUtil;
import com.codename1.ui.ReleasableComponent;
import com.codename1.ui.SelectableIconHolder;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.ActionSource;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.plaf.Border;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.EventDispatcher;
import java.util.Collection;
import java.util.Vector;

public class Button
extends Label
implements ReleasableComponent,
ActionSource,
SelectableIconHolder {
    private static boolean buttonRippleEffectDefault;
    private static boolean capsTextDefault;
    private Boolean capsText;
    public static final int STATE_ROLLOVER = 0;
    public static final int STATE_PRESSED = 1;
    public static final int STATE_DEFAULT = 2;
    private EventDispatcher dispatcher = new EventDispatcher();
    private EventDispatcher stateChangeListeners;
    private int state = 2;
    private Image pressedIcon;
    private Image rolloverIcon;
    private Image rolloverPressedIcon;
    private Image disabledIcon;
    private Command cmd;
    private boolean toggle;
    private int releaseRadius;
    private boolean autoRelease;
    private ActionListener bindListener;
    private int pressedX;
    private int pressedY;

    public static boolean isCapsTextDefault() {
        return capsTextDefault;
    }

    public static void setCapsTextDefault(boolean aCapsTextDefault) {
        capsTextDefault = aCapsTextDefault;
    }

    public static boolean isButtonRippleEffectDefault() {
        return buttonRippleEffectDefault;
    }

    public static void setButtonRippleEffectDefault(boolean aButtonRippleEffectDefault) {
        buttonRippleEffectDefault = aButtonRippleEffectDefault;
    }

    public Button() {
        this("");
    }

    public Button(String text) {
        this(text, null, "Button");
    }

    public Button(Command cmd) {
        this(cmd.getCommandName(), cmd.getIcon());
        this.addActionListener((ActionListener)cmd);
        this.cmd = cmd;
        this.setEnabled(cmd.isEnabled());
        this.updateCommand();
    }

    private void updateCommand() {
        if (this.cmd.getMaterialIcon() == '\u0000') {
            this.setRolloverIcon(this.cmd.getRolloverIcon());
            this.setDisabledIcon(this.cmd.getDisabledIcon());
            this.setPressedIcon(this.cmd.getPressedIcon());
        } else if (this.cmd.getIconFont() != null) {
            this.setFontIcon(this.cmd.getIconFont(), this.cmd.getMaterialIcon(), this.cmd.getMaterialIconSize());
        } else {
            this.setMaterialIcon(this.cmd.getMaterialIcon(), this.cmd.getMaterialIconSize());
        }
        if (this.cmd.getIconGapMM() > -1.0f) {
            this.setGap(Display.INSTANCE.convertToPixels(this.cmd.getIconGapMM()));
        }
    }

    public void setCommand(Command cmd) {
        if (this.cmd != null) {
            this.removeActionListener((ActionListener)this.cmd);
        }
        this.cmd = cmd;
        if (cmd != null) {
            this.setText(cmd.getCommandName());
            if (cmd.getIcon() == null) {
                if (cmd.getMaterialIcon() != '\u0000') {
                    if (cmd.getIconFont() != null) {
                        this.setFontIcon(cmd.getIconFont(), cmd.getMaterialIcon(), cmd.getMaterialIconSize());
                    } else {
                        this.setMaterialIcon(cmd.getMaterialIcon(), cmd.getMaterialIconSize());
                    }
                }
            } else {
                this.setIcon(cmd.getIcon());
            }
            this.setEnabled(cmd.isEnabled());
            this.updateCommand();
            this.addActionListener((ActionListener)cmd);
        }
    }

    public Button(Image icon) {
        this("", icon);
    }

    public Button(char icon) {
        this("");
        this.setMaterialIcon(icon);
    }

    public Button(String text, char icon, String id) {
        this(text, null, id);
        this.setMaterialIcon(icon);
    }

    public Button(String text, char icon, float iconSize, String id) {
        this(text, null, id);
        this.setMaterialIcon(icon, iconSize);
    }

    public Button(String text, Image icon, String id) {
        super(text);
        this.setUIID(id);
        this.setFocusable(true);
        this.setIcon(icon);
        this.pressedIcon = icon;
        this.rolloverIcon = icon;
        this.releaseRadius = UIManager.getInstance().getThemeConstant("releaseRadiusInt", 0);
        this.setRippleEffect(buttonRippleEffectDefault);
        if (this.isCapsText() && text != null) {
            this.putClientProperty("cn1$origText", text);
            super.setText(UIManager.getInstance().localize(text, text).toUpperCase());
        }
        this.setCursor(12);
    }

    public Button(String text, Image icon) {
        this(text, icon, "Button");
    }

    public Button(Image icon, String id) {
        this("", icon, id);
    }

    public Button(char icon, String id) {
        this("", id);
        this.setMaterialIcon(icon);
    }

    public Button(char icon, float iconSize, String id) {
        this("", id);
        this.setMaterialIcon(icon, iconSize);
    }

    public Button(String text, String id) {
        this(text, null, id);
    }

    private ActionListener bindListener() {
        if (this.bindListener == null) {
            this.bindListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() instanceof Button) {
                        Button b = (Button)e.getSource();
                        if (Button.this.state != b.getState()) {
                            Button.this.setState(b.getState());
                            Button.this.repaint();
                        }
                    }
                }
            };
        }
        return this.bindListener;
    }

    public void bindStateTo(Button button) {
        button.addStateChangeListener(this.bindListener());
    }

    public void unbindStateFrom(Button button) {
        if (this.bindListener != null) {
            button.removeStateChangeListener(this.bindListener);
        }
    }

    protected void resetFocusable() {
        this.setFocusable(true);
    }

    void focusGainedInternal() {
        super.focusGainedInternal();
        if (this.state != 1) {
            this.state = 0;
            this.fireStateChange();
        }
    }

    void focusLostInternal() {
        super.focusLostInternal();
        if (this.state != 2) {
            this.state = 2;
            this.fireStateChange();
        }
    }

    public int getState() {
        return this.state;
    }

    void setState(int state) {
        if (state != this.state) {
            this.state = state;
            this.fireStateChange();
        }
    }

    public void setReleased() {
        this.setState(2);
        this.repaint();
    }

    public Image getPressedIcon() {
        return this.pressedIcon;
    }

    public Image getRolloverPressedIcon() {
        return this.rolloverPressedIcon;
    }

    public void setRolloverPressedIcon(Image rolloverPressedIcon) {
        this.rolloverPressedIcon = rolloverPressedIcon;
    }

    public Image getDisabledIcon() {
        return this.disabledIcon;
    }

    public Image getRolloverIcon() {
        return this.rolloverIcon;
    }

    public void setRolloverIcon(Image rolloverIcon) {
        this.rolloverIcon = rolloverIcon;
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
        this.repaint();
    }

    public void setPressedIcon(Image pressedIcon) {
        this.pressedIcon = pressedIcon;
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
        this.repaint();
    }

    public void setDisabledIcon(Image disabledIcon) {
        this.disabledIcon = disabledIcon;
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
        this.repaint();
    }

    void checkAnimation() {
        Form parent;
        super.checkAnimation();
        if ((this.pressedIcon != null && this.pressedIcon.isAnimation() || this.rolloverIcon != null && this.rolloverIcon.isAnimation() || this.disabledIcon != null && this.disabledIcon.isAnimation()) && (parent = this.getComponentForm()) != null) {
            parent.registerAnimated(this);
        }
    }

    public void addStateChangeListener(ActionListener l) {
        if (this.stateChangeListeners == null) {
            this.stateChangeListeners = new EventDispatcher();
        }
        this.stateChangeListeners.addListener(l);
    }

    public void removeStateChangeListener(ActionListener l) {
        if (this.stateChangeListeners != null) {
            this.stateChangeListeners.removeListener(l);
        }
    }

    private void fireStateChange() {
        if (this.stateChangeListeners != null && this.stateChangeListeners.hasListeners()) {
            this.stateChangeListeners.fireActionEvent(new ActionEvent(this));
        }
    }

    public void addActionListener(ActionListener l) {
        this.dispatcher.addListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.dispatcher.removeListener(l);
    }

    public Vector getActionListeners() {
        return this.dispatcher.getListenerVector();
    }

    public Collection getListeners() {
        return this.dispatcher.getListenerCollection();
    }

    public Image getIconFromState() {
        Image icon = this.getMaskedIcon();
        if (!this.isEnabled() && this.getDisabledIcon() != null) {
            return this.getDisabledIcon();
        }
        if (this.isToggle() && this.isSelected()) {
            icon = this.rolloverPressedIcon;
            if (icon == null && (icon = this.getPressedIcon()) == null) {
                icon = this.getMaskedIcon();
            }
            return icon;
        }
        switch (this.getState()) {
            case 2: {
                break;
            }
            case 1: {
                icon = this.getPressedIcon();
                if (icon != null) break;
                icon = this.getMaskedIcon();
                break;
            }
            case 0: {
                if (!Display.getInstance().shouldRenderSelection(this) || (icon = this.getRolloverIcon()) != null) break;
                icon = this.getMaskedIcon();
            }
        }
        return icon;
    }

    protected void fireActionEvent(int x, int y) {
        super.fireActionEvent();
        if (this.cmd != null) {
            Form f;
            ActionEvent ev = new ActionEvent(this.cmd, (Component)this, x, y);
            this.dispatcher.fireActionEvent(ev);
            if (!ev.isConsumed() && (f = this.getComponentForm()) != null) {
                f.actionCommandImplNoRecurseComponent(this.cmd, ev);
            }
        } else {
            this.dispatcher.fireActionEvent(new ActionEvent((Object)this, ActionEvent.Type.PointerPressed, x, y));
        }
        Display d = Display.getInstance();
        if (d.isBuiltinSoundsEnabled()) {
            d.playBuiltinSound("press");
        }
    }

    public void pressed() {
        if (!Display.impl.isScrollWheeling()) {
            if (this.state != 1) {
                this.state = 1;
                this.fireStateChange();
            }
            this.repaint();
        }
    }

    public void released() {
        this.released(-1, -1);
    }

    public void released(int x, int y) {
        if (!Display.impl.isScrollWheeling()) {
            if (this.state != 0) {
                this.state = 0;
                this.fireStateChange();
            }
            this.fireActionEvent(x, y);
            this.repaint();
        }
    }

    public void keyPressed(int keyCode) {
        if (Display.getInstance().getGameAction(keyCode) == 8) {
            this.pressedX = -1;
            this.pressedY = -1;
            this.pressed();
        }
    }

    public void keyReleased(int keyCode) {
        if (Display.getInstance().getGameAction(keyCode) == 8) {
            this.released();
        }
    }

    public void keyRepeated(int keyCode) {
    }

    protected void fireClicked() {
        this.pressed();
        this.released();
    }

    protected boolean isSelectableInteraction() {
        return true;
    }

    public void pointerHover(int[] x, int[] y) {
        if (!Display.getInstance().isDesktop()) {
            this.requestFocus();
        }
    }

    public void pointerHoverReleased(int[] x, int[] y) {
        if (!Display.getInstance().isDesktop()) {
            this.requestFocus();
        }
    }

    public void pointerPressed(int x, int y) {
        Component leadParent = LeadUtil.leadParentImpl(this);
        leadParent.clearDrag();
        leadParent.setDragActivated(false);
        if (this.pointerPressedListeners != null && this.pointerPressedListeners.hasListeners()) {
            this.pointerPressedListeners.fireActionEvent(new ActionEvent((Object)this, ActionEvent.Type.PointerPressed, x, y));
        }
        this.pressedX = x;
        this.pressedY = y;
        this.pressed();
        Form f = this.getComponentForm();
        if (f != null) {
            f.addComponentAwaitingRelease(this);
        }
    }

    public void pointerReleased(int x, int y) {
        Form f;
        if (this.pointerReleasedListeners != null && this.pointerReleasedListeners.hasListeners()) {
            ActionEvent ev = new ActionEvent((Object)this, ActionEvent.Type.PointerReleased, x, y);
            this.pointerReleasedListeners.fireActionEvent(ev);
            if (ev.isConsumed()) {
                return;
            }
        }
        if ((f = this.getComponentForm()) != null) {
            f.removeComponentAwaitingRelease(this);
        }
        if (this.state == 1) {
            this.released(x, y);
        }
        if (restoreDragPercentage > -1) {
            Display.getInstance().setDragStartPercentage(restoreDragPercentage);
        }
    }

    protected void dragInitiated() {
        if (Display.getInstance().shouldRenderSelection(this)) {
            if (this.state != 0) {
                this.state = 0;
                this.fireStateChange();
            }
        } else if (this.state != 2) {
            this.state = 2;
            this.fireStateChange();
        }
        this.repaint();
    }

    void initComponentImpl() {
        super.initComponentImpl();
        if (this.pressedIcon != null) {
            this.pressedIcon.lock();
        }
        if (this.rolloverIcon != null) {
            this.rolloverIcon.lock();
        }
        if (this.rolloverPressedIcon != null) {
            this.rolloverPressedIcon.lock();
        }
        if (this.disabledIcon != null) {
            this.disabledIcon.lock();
        }
    }

    void deinitializeImpl() {
        super.deinitializeImpl();
        if (this.pressedIcon != null) {
            this.pressedIcon.unlock();
        }
        if (this.rolloverIcon != null) {
            this.rolloverIcon.unlock();
        }
        if (this.rolloverPressedIcon != null) {
            this.rolloverPressedIcon.unlock();
        }
        if (this.disabledIcon != null) {
            this.disabledIcon.unlock();
        }
    }

    protected Dimension calcPreferredSize() {
        return this.getUIManager().getLookAndFeel().getButtonPreferredSize(this);
    }

    protected Border getBorder() {
        return this.getStyle().getBorder();
    }

    boolean isPressedStyle() {
        if (this.toggle && this.isSelected()) {
            if (this.hasFocus()) {
                return !Display.getInstance().shouldRenderSelection(this);
            }
            return true;
        }
        return this.state == 1;
    }

    public Command getCommand() {
        return this.cmd;
    }

    public boolean isSelected() {
        return false;
    }

    public void setAlignment(int align) {
        super.setAlignment(align);
        this.getPressedStyle().setAlignment(align);
    }

    public boolean isToggle() {
        return this.toggle;
    }

    public void setToggle(boolean toggle) {
        this.toggle = toggle;
        if (toggle && this.getUIID().equals("CheckBox") || this.getUIID().equals("RadioButton")) {
            this.setUIID("ToggleButton");
        }
    }

    public void setUIID(String id) {
        super.setUIID(id);
        String t = (String)this.getClientProperty("cn1$origText");
        if (t != null) {
            if (this.isCapsText()) {
                super.setText(UIManager.getInstance().localize(t, t).toUpperCase());
            } else {
                super.setText(UIManager.getInstance().localize(t, t));
                this.putClientProperty("cn1$origText", null);
            }
        }
    }

    public boolean animate() {
        boolean a = super.animate();
        if (!this.isEnabled() && this.disabledIcon != null) {
            a |= this.disabledIcon.isAnimation() && this.disabledIcon.animate();
        } else {
            switch (this.state) {
                case 0: {
                    a |= this.rolloverIcon != null && this.rolloverIcon.isAnimation() && this.rolloverIcon.animate();
                    break;
                }
                case 1: {
                    a |= this.pressedIcon != null && this.pressedIcon.isAnimation() && this.pressedIcon.animate();
                }
            }
        }
        return a;
    }

    public boolean isOppositeSide() {
        return false;
    }

    public int getReleaseRadius() {
        return this.releaseRadius;
    }

    public void setReleaseRadius(int releaseRadius) {
        this.releaseRadius = releaseRadius;
    }

    public boolean isAutoRelease() {
        return this.autoRelease;
    }

    public void setAutoRelease(boolean autoRelease) {
        this.autoRelease = autoRelease;
    }

    public void paint(Graphics g) {
        if (this.isLegacyRenderer()) {
            this.initAutoResize();
            this.getUIManager().getLookAndFeel().drawButton(g, this);
            return;
        }
        super.paintImpl(g);
    }

    public final boolean isCapsText() {
        if (this.capsText == null) {
            if (capsTextDefault) {
                String uiid = this.getUIID();
                return uiid.equals("Button") || uiid.equals("RaisedButton") || this.getUIManager().getThemeConstant("capsButtonUiids", "").indexOf(uiid) > -1;
            }
            return false;
        }
        return this.capsText;
    }

    public void setCapsText(boolean capsText) {
        this.capsText = capsText;
    }

    public void setText(String t) {
        if (this.isCapsText()) {
            this.putClientProperty("cn1$origText", t);
            if (t != null) {
                super.setText(this.getUIManager().localize(t, t).toUpperCase());
                return;
            }
        }
        super.setText(t);
    }
}

