/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.ui.Button;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.FontImage;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.EventDispatcher;

public class Accordion
extends Container {
    private Image closeIcon;
    private Image openIcon;
    private boolean autoClose = true;
    private String uiidBackGroundItem = "AccordionItem";
    private String uiidHeader = "AccordionArrow";
    private String uiidOpenCloseIcon = "AccordionArrow";
    private final EventDispatcher listeners = new EventDispatcher();

    public Accordion() {
        super.setLayout(BoxLayout.y());
        this.closeIcon = this.isRTL() ? FontImage.createMaterial('\ue314', UIManager.getInstance().getComponentStyle(this.uiidOpenCloseIcon)) : FontImage.createMaterial('\ue315', UIManager.getInstance().getComponentStyle(this.uiidOpenCloseIcon));
        this.openIcon = FontImage.createMaterial('\ue313', UIManager.getInstance().getComponentStyle(this.uiidOpenCloseIcon));
        this.setScrollableY(true);
    }

    public Accordion(Image openIcon, Image closeIcon) {
        super.setLayout(BoxLayout.y());
        this.closeIcon = openIcon;
        this.openIcon = closeIcon;
        this.setScrollableY(true);
    }

    public Accordion(char openIcon, char closeIcon) {
        super.setLayout(BoxLayout.y());
        this.closeIcon = FontImage.createMaterial(openIcon, UIManager.getInstance().getComponentStyle(this.uiidOpenCloseIcon));
        this.openIcon = FontImage.createMaterial(closeIcon, UIManager.getInstance().getComponentStyle(this.uiidOpenCloseIcon));
        this.setScrollableY(true);
    }

    public Accordion(char openIcon, char closeIcon, String openCloseUIID) {
        super.setLayout(BoxLayout.y());
        this.uiidOpenCloseIcon = openCloseUIID;
        this.closeIcon = FontImage.createMaterial(openIcon, UIManager.getInstance().getComponentStyle(openCloseUIID));
        this.openIcon = FontImage.createMaterial(closeIcon, UIManager.getInstance().getComponentStyle(openCloseUIID));
        this.setScrollableY(true);
    }

    public void addContent(String header, Component body) {
        this.addContent(new Label(header, this.uiidHeader), body);
    }

    public void setHeader(String header, Component body) {
        AccordionContent ac = (AccordionContent)body.getParent();
        ((Label)ac.header).setText(header);
    }

    public void setHeader(Component header, Component body) {
        AccordionContent ac = (AccordionContent)body.getParent();
        ac.header.getParent().replace(ac.header, header, null);
    }

    public void removeContent(Component body) {
        body.getParent().remove();
        body.remove();
    }

    public void addContent(Component header, Component body) {
        this.add(new AccordionContent(header, body));
    }

    public void setHeaderUIID(Component body, String uiid) {
        AccordionContent ac = (AccordionContent)body.getParent();
        if (ac == null) {
            body.putClientProperty("cn1$setHeaderUIID", uiid);
        } else if (ac.top != null) {
            ac.top.setUIID(uiid);
        } else {
            ac.topUiid = uiid;
        }
    }

    public Component getCurrentlyExpanded() {
        for (Component cc : this) {
            AccordionContent c = (AccordionContent)cc;
            if (c.isClosed()) continue;
            return c.body;
        }
        return null;
    }

    public void expand(Component body) {
        if (this.autoClose) {
            for (Component cc : this) {
                AccordionContent c;
                c.openClose(body != (c = (AccordionContent)cc).body);
            }
        } else {
            for (Component cc : this) {
                AccordionContent c = (AccordionContent)cc;
                if (body != c.body) continue;
                c.openClose(false);
            }
        }
    }

    public void collapse(Component body) {
        for (Component cc : this) {
            AccordionContent c = (AccordionContent)cc;
            if (body != c.body) continue;
            c.openClose(true);
        }
    }

    public void setCloseIcon(Image closeIcon) {
        this.closeIcon = closeIcon;
    }

    public void setOpenIcon(Image openIcon) {
        this.openIcon = openIcon;
    }

    public void setCloseIcon(char closeIcon) {
        this.closeIcon = FontImage.createMaterial(closeIcon, UIManager.getInstance().getComponentStyle(this.uiidOpenCloseIcon));
    }

    public void setOpenIcon(char openIcon) {
        this.openIcon = FontImage.createMaterial(openIcon, UIManager.getInstance().getComponentStyle(this.uiidOpenCloseIcon));
    }

    public void setCloseIcon(char closeIcon, float size) {
        this.closeIcon = FontImage.createMaterial(closeIcon, UIManager.getInstance().getComponentStyle(this.uiidOpenCloseIcon), size);
    }

    public void setOpenIcon(char openIcon, float size) {
        this.openIcon = FontImage.createMaterial(openIcon, UIManager.getInstance().getComponentStyle(this.uiidOpenCloseIcon), size);
    }

    public void setCloseIcon(char closeIcon, String uiid) {
        this.closeIcon = FontImage.createMaterial(closeIcon, UIManager.getInstance().getComponentStyle(uiid));
    }

    public void setOpenIcon(char openIcon, String uiid) {
        this.openIcon = FontImage.createMaterial(openIcon, UIManager.getInstance().getComponentStyle(uiid));
    }

    public void setAutoClose(boolean autoClose) {
        this.autoClose = autoClose;
    }

    public void addOnClickItemListener(ActionListener a) {
        this.listeners.addListener(a);
    }

    public void removeOnClickItemListener(ActionListener a) {
        this.listeners.removeListener(a);
    }

    private void fireEvent(ActionEvent ev) {
        this.listeners.fireActionEvent(ev);
    }

    public void setBackgroundItemUIID(String uiidBackGroundItem) {
        this.uiidBackGroundItem = uiidBackGroundItem;
    }

    public String getBackgroundItemUIID() {
        return this.uiidBackGroundItem;
    }

    public void setHeaderUIID(String uiidHeader) {
        this.uiidHeader = uiidHeader;
    }

    public String getHeaderUIID() {
        return this.uiidHeader;
    }

    public void setOpenCloseIconUIID(String uiidOpenCloseIcon) {
        this.uiidOpenCloseIcon = uiidOpenCloseIcon;
    }

    public String getOpenCloseIconUIID() {
        return this.uiidOpenCloseIcon;
    }

    static /* synthetic */ String access$400(Accordion x0) {
        return x0.uiidHeader;
    }

    class AccordionContent
    extends Container {
        private boolean closed = true;
        private final Button arrow = new Button();
        private Component body;
        private Component header;
        private Container top;
        private String topUiid = Accordion.access$400(Accordion.this);

        public AccordionContent(Component header, Component body) {
            this.setUIID(Accordion.this.uiidBackGroundItem);
            this.setLayout(new BorderLayout());
            this.body = body;
            this.header = header;
            header.setSelectedStyle(header.getUnselectedStyle());
            header.setPressedStyle(header.getUnselectedStyle());
            String t = (String)body.getClientProperty("cn1$setHeaderUIID");
            if (t != null) {
                this.topUiid = t;
            }
            this.top = new Container(new BorderLayout(), this.topUiid);
            this.top.add((Object)"Center", header);
            this.arrow.setUIID(Accordion.this.uiidOpenCloseIcon);
            this.arrow.setIcon(Accordion.this.closeIcon);
            this.arrow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    AccordionContent.this.openClose(!AccordionContent.this.isClosed());
                    if (Accordion.this.autoClose) {
                        for (int i = 0; i < Accordion.this.getComponentCount(); ++i) {
                            AccordionContent c = (AccordionContent)Accordion.this.getComponentAt(i);
                            if (c == AccordionContent.this || c.isClosed()) continue;
                            c.openClose(true);
                        }
                    }
                    Accordion.this.animateLayout(250);
                    Accordion.this.fireEvent(evt);
                }
            });
            this.top.add((Object)"East", this.arrow);
            this.top.setLeadComponent(this.arrow);
            this.add((Object)"North", this.top);
            body.setHidden(true);
            this.add((Object)"Center", body);
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void openClose(boolean close) {
            this.closed = close;
            if (this.closed) {
                this.arrow.setIcon(Accordion.this.closeIcon);
            } else {
                this.arrow.setIcon(Accordion.this.openIcon);
            }
            this.body.setHidden(this.closed);
        }
    }
}

