/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.io.Log;
import com.codename1.ui.Button;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.MenuBar;
import com.codename1.ui.Painter;
import com.codename1.ui.TextArea;
import com.codename1.ui.animations.Transition;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.FlowLayout;
import com.codename1.ui.layouts.GridLayout;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.plaf.Border;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import java.util.Map;

public class Dialog
extends Form {
    private boolean disposed;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_ALARM = 1;
    public static final int TYPE_CONFIRMATION = 2;
    public static final int TYPE_ERROR = 3;
    public static final int TYPE_INFO = 4;
    public static final int TYPE_WARNING = 5;
    private long time;
    private Command lastCommandPressed;
    private boolean menu;
    private int dialogType;
    private int top = -1;
    private int bottom;
    private int left;
    private int right;
    private boolean includeTitle;
    private String position;
    private static boolean autoAdjustDialogSize = true;
    private static String defaultDialogPosition;
    private String dialogPosition = defaultDialogPosition;
    private static boolean disableStaticDialogScrolling;
    private boolean autoDispose = true;
    private boolean modal = true;
    private Command[] buttonCommands;
    private boolean disposeOnRotation;
    private static int defaultDialogType;
    private static boolean commandsAsButtons;
    private static boolean defaultDisposeWhenPointerOutOfBounds;
    private boolean disposeWhenPointerOutOfBounds = defaultDisposeWhenPointerOutOfBounds;
    private boolean pressedOutOfBounds;
    private boolean disposedDueToRotation;
    private Label dialogTitle;
    private Container dialogContentPane;
    private Boolean popupDirectionBiasPortrait;
    private static float defaultBlurBackgroundRadius;
    private float blurBackgroundRadius = defaultBlurBackgroundRadius;
    private boolean isUIIDByPopupPosition;

    public static boolean isDefaultDisposeWhenPointerOutOfBounds() {
        return defaultDisposeWhenPointerOutOfBounds;
    }

    public static void setDefaultDisposeWhenPointerOutOfBounds(boolean aDefaultDisposeWhenPointerOutOfBounds) {
        defaultDisposeWhenPointerOutOfBounds = aDefaultDisposeWhenPointerOutOfBounds;
    }

    public Dialog(String title) {
        this();
        this.setTitle(title);
    }

    public Dialog(String title, Layout lm) {
        this(lm);
        this.setTitle(title);
    }

    void initAdPadding(Display d) {
    }

    public Dialog() {
        this("Dialog", "DialogTitle");
    }

    public Dialog(Layout lm) {
        this("Dialog", "DialogTitle", lm);
    }

    Dialog(String dialogUIID, String dialogTitleUIID) {
        this.initImpl(dialogUIID, dialogTitleUIID, null);
    }

    Dialog(String dialogUIID, String dialogTitleUIID, Layout lm) {
        this.initImpl(dialogUIID, dialogTitleUIID, lm);
    }

    private void initImpl(String dialogUIID, String dialogTitleUIID, Layout lm) {
        super.getContentPane().setUIID(dialogUIID);
        super.getTitleComponent().setText("");
        super.getTitleComponent().setVisible(false);
        super.getTitleArea().setVisible(false);
        super.getTitleArea().setUIID("Container");
        this.lockStyleImages(this.getUnselectedStyle());
        this.titleArea.setVisible(false);
        this.dialogContentPane = lm != null ? new Container(lm) : new Container();
        this.dialogContentPane.setUIID("DialogContentPane");
        this.dialogTitle = new Label("", dialogTitleUIID);
        super.getContentPane().setLayout(new BorderLayout());
        super.getContentPane().addComponent("North", (Component)this.dialogTitle);
        super.getContentPane().addComponent("Center", (Component)this.dialogContentPane);
        super.getContentPane().setScrollable(false);
        super.getContentPane().setAlwaysTensile(false);
        super.getStyle().setBgTransparency(0);
        super.getStyle().setBgImage(null);
        super.getStyle().setBorder(null);
        this.setSmoothScrolling(false);
        this.deregisterAnimated(this);
    }

    public void setPreviousForm(Form previousForm) {
        super.setPreviousForm(previousForm);
    }

    protected final void initGlobalToolbar() {
    }

    public Container getContentPane() {
        return this.dialogContentPane;
    }

    public Layout getLayout() {
        return this.dialogContentPane.getLayout();
    }

    public String getTitle() {
        return this.dialogTitle.getText();
    }

    public void addComponent(Component cmp) {
        this.dialogContentPane.addComponent(cmp);
    }

    public void addComponent(Object constraints, Component cmp) {
        this.dialogContentPane.addComponent(constraints, cmp);
    }

    public void addComponent(int index, Object constraints, Component cmp) {
        this.dialogContentPane.addComponent(index, constraints, cmp);
    }

    public void addComponent(int index, Component cmp) {
        this.dialogContentPane.addComponent(index, cmp);
    }

    public void removeAll() {
        this.dialogContentPane.removeAll();
    }

    public void removeComponent(Component cmp) {
        this.dialogContentPane.removeComponent(cmp);
    }

    public Label getTitleComponent() {
        return this.dialogTitle;
    }

    public Style getTitleStyle() {
        return this.dialogTitle.getStyle();
    }

    public void setLayout(Layout layout) {
        this.dialogContentPane.setLayout(layout);
    }

    void updateIcsIconCommandBehavior() {
    }

    public void setTitle(String title) {
        this.dialogTitle.setText(title);
    }

    public void setTitleComponent(Label title) {
        super.getContentPane().removeComponent(this.dialogTitle);
        this.dialogTitle = title;
        super.getContentPane().addComponent("North", (Component)this.dialogTitle);
    }

    public Container getDialogComponent() {
        return super.getContentPane();
    }

    public void setTitleComponent(Label title, Transition t) {
        super.getContentPane().replace((Component)this.dialogTitle, (Component)title, t);
        this.dialogTitle = title;
    }

    public void setDialogStyle(Style style) {
        super.getContentPane().setUnselectedStyle(style);
    }

    public void setDialogUIID(String uiid) {
        super.getContentPane().setUIID(uiid);
    }

    public String getDialogUIID() {
        return super.getContentPane().getUIID();
    }

    public Style getDialogStyle() {
        return super.getContentPane().getUnselectedStyle();
    }

    protected void initLaf(UIManager uim) {
        super.initLaf(uim);
        this.setTransitionOutAnimator(uim.getLookAndFeel().getDefaultDialogTransitionOut());
        this.setTransitionInAnimator(uim.getLookAndFeel().getDefaultDialogTransitionIn());
    }

    public Command show(int top, int bottom, int left, int right, boolean includeTitle) {
        return this.show(top, bottom, left, right, includeTitle, true);
    }

    public Command show(int top, int bottom, int left, int right) {
        return this.show(top, bottom, left, right, false, true);
    }

    public Command show(int top, int bottom, int left, int right, boolean includeTitle, boolean modal) {
        this.top = top;
        this.bottom = bottom;
        if (this.isRTL()) {
            this.left = right;
            this.right = left;
        } else {
            this.left = left;
            this.right = right;
        }
        this.setDisposed(false);
        this.modal = modal;
        this.lastCommandPressed = null;
        this.showModal(this.top, this.bottom, this.left, this.right, includeTitle, modal, false);
        return this.lastCommandPressed;
    }

    public Command showAtPosition(int top, int bottom, int left, int right, boolean modal) {
        this.top = top;
        this.bottom = bottom;
        if (this.isRTL()) {
            this.left = right;
            this.right = left;
        } else {
            this.left = left;
            this.right = right;
        }
        this.setDisposed(false);
        this.modal = modal;
        this.lastCommandPressed = null;
        this.showModal(this.top, this.bottom, this.left, this.right, false, modal, false);
        return this.lastCommandPressed;
    }

    void initTitleBarStatus() {
    }

    public void setTimeout(long time) {
        this.time = System.currentTimeMillis() + time;
        super.registerAnimatedInternal(this);
    }

    public static boolean show(String title, String text, int type, Image icon, String okText, String cancelText) {
        return Dialog.show(title, text, type, icon, okText, cancelText, 0L);
    }

    void sizeChangedInternal(int w, int h) {
        if (this.disposeOnRotation) {
            this.disposedDueToRotation = true;
            this.dispose();
            Form frm = this.getPreviousForm();
            if (frm != null) {
                frm.sizeChangedInternal(w, h);
            }
            return;
        }
        this.autoAdjust(w, h);
        super.sizeChangedInternal(w, h);
        Form frm = this.getPreviousForm();
        if (frm != null) {
            frm.sizeChangedInternal(w, h);
        }
    }

    protected void autoAdjust(int w, int h) {
        if (autoAdjustDialogSize) {
            this.growOrShrinkImpl(w, h);
        }
    }

    public static boolean show(String title, String text, int type, Image icon, String okText, String cancelText, long timeout) {
        Command okCommand = new Command(okText);
        Command[] cmds = cancelText != null ? new Command[]{new Command(cancelText), okCommand} : new Command[]{okCommand};
        return Dialog.show(title, text, okCommand, cmds, type, icon, timeout) == okCommand;
    }

    public static Command show(String title, String text, Command[] cmds, int type, Image icon, long timeout) {
        return Dialog.show(title, text, null, cmds, type, icon, timeout);
    }

    public static Command show(String title, String text, Command defaultCommand, Command[] cmds, int type, Image icon, long timeout) {
        return Dialog.show(title, text, defaultCommand, cmds, type, icon, timeout, null);
    }

    public static Command show(String title, String text, Command[] cmds, int type, Image icon, long timeout, Transition transition) {
        return Dialog.show(title, text, null, cmds, type, icon, timeout, transition);
    }

    public static Command show(String title, String text, Command defaultCommand, Command[] cmds, int type, Image icon, long timeout, Transition transition) {
        String o;
        Map<String, String> h = UIManager.getInstance().getBundle();
        if (h != null && text != null && (o = h.get(text)) != null) {
            text = o;
        }
        TextArea t = new TextArea(text, 3, 30);
        t.setUIID("DialogBody");
        t.setEditable(false);
        return Dialog.show(title, (Component)t, defaultCommand, cmds, type, icon, timeout, transition);
    }

    public static boolean show(String title, String text, String okText, String cancelText) {
        return Dialog.show(title, text, defaultDialogType, null, okText, cancelText);
    }

    public static Command show(String title, Component body, Command ... cmds) {
        return Dialog.show(title, body, cmds, defaultDialogType, null);
    }

    public static Command show(String title, String body, Command ... cmds) {
        TextArea t = new TextArea(body, 3, 30);
        t.setUIID("DialogBody");
        t.setEditable(false);
        return Dialog.show(title, (Component)t, cmds);
    }

    public static Command show(String title, Component body, Command[] cmds, int type, Image icon) {
        return Dialog.show(title, body, cmds, type, icon, 0L);
    }

    public static Command show(String title, Component body, Command[] cmds, int type, Image icon, long timeout) {
        return Dialog.show(title, body, cmds, type, icon, timeout, null);
    }

    public static Command show(String title, Component body, Command[] cmds, int type, Image icon, long timeout, Transition transition) {
        return Dialog.show(title, body, null, cmds, type, icon, timeout, transition);
    }

    private void addButtonBar(Container c) {
        super.getContentPane().addComponent("South", (Component)c);
    }

    public void placeButtonCommands(Command[] cmds) {
        this.buttonCommands = cmds;
        Container buttonArea = this.getUIManager().isThemeConstant("dlgCommandGridBool", false) ? new Container(new GridLayout(1, cmds.length)) : new Container(new FlowLayout(4));
        buttonArea.setUIID("DialogCommandArea");
        String uiid = this.getUIManager().getThemeConstant("dlgButtonCommandUIID", null);
        this.addButtonBar(buttonArea);
        if (cmds.length > 0) {
            int iter;
            String lineColor = this.getUIManager().getThemeConstant("dlgInvisibleButtons", null);
            if (cmds.length > 3) {
                lineColor = null;
            }
            int largest = Integer.parseInt(this.getUIManager().getThemeConstant("dlgCommandButtonSizeInt", "0"));
            for (iter = 0; iter < cmds.length; ++iter) {
                Button b = new Button(cmds[iter]);
                if (uiid != null) {
                    b.setUIID(uiid);
                }
                if (Button.isCapsTextDefault()) {
                    b.setCapsText(true);
                }
                largest = Math.max(b.getPreferredW(), largest);
                if (lineColor != null && lineColor.length() > 0) {
                    int color = Integer.parseInt(lineColor, 16);
                    Border brd = null;
                    brd = iter < cmds.length - 1 ? Border.createCompoundBorder(Border.createLineBorder(1, color), null, null, Border.createLineBorder(1, color)) : Border.createCompoundBorder(Border.createLineBorder(1, color), null, null, null);
                    b.getUnselectedStyle().setBorder(brd);
                    b.getSelectedStyle().setBorder(brd);
                    b.getPressedStyle().setBorder(brd);
                }
                buttonArea.addComponent(b);
            }
            for (iter = 0; iter < cmds.length; ++iter) {
                buttonArea.getComponentAt(iter).setPreferredW(largest);
            }
            buttonArea.getComponentAt(0).requestFocus();
        }
    }

    public void keyReleased(int keyCode) {
        if (commandsAsButtons) {
            if (MenuBar.isLSK(keyCode) && this.buttonCommands != null && this.buttonCommands.length > 0) {
                this.dispatchCommand(this.buttonCommands[0], new ActionEvent((Object)this.buttonCommands[0], ActionEvent.Type.KeyRelease));
                return;
            }
            if (MenuBar.isRSK(keyCode) && this.buttonCommands != null && this.buttonCommands.length > 1) {
                this.dispatchCommand(this.buttonCommands[1], new ActionEvent((Object)this.buttonCommands[1], ActionEvent.Type.KeyRelease));
                return;
            }
        }
        super.keyReleased(keyCode);
    }

    public static Command show(String title, Component body, Command defaultCommand, Command[] cmds, int type, Image icon, long timeout, Transition transition) {
        Dialog dialog = new Dialog(title);
        dialog.dialogType = type;
        dialog.setTransitionInAnimator(transition);
        dialog.setTransitionOutAnimator(transition);
        dialog.lastCommandPressed = null;
        dialog.setLayout(new BorderLayout());
        if (cmds != null) {
            if (commandsAsButtons) {
                dialog.placeButtonCommands(cmds);
            } else {
                for (int iter = 0; iter < cmds.length; ++iter) {
                    dialog.addCommand(cmds[iter]);
                }
            }
            if (cmds.length == 1 || cmds.length == 2) {
                dialog.setBackCommand(cmds[0]);
            }
        }
        if (defaultCommand != null) {
            dialog.setDefaultCommand(defaultCommand);
        }
        dialog.addComponent("Center", body);
        if (icon != null) {
            dialog.addComponent("East", (Component)new Label(icon));
        }
        if (timeout != 0L) {
            dialog.setTimeout(timeout);
        }
        if (body.isScrollable() || disableStaticDialogScrolling) {
            dialog.setScrollable(false);
        }
        dialog.show();
        return dialog.lastCommandPressed;
    }

    protected void onShow() {
        if (this.dialogType > 0) {
            Display.getInstance().playDialogSound(this.dialogType);
        }
    }

    void onShowCompletedImpl() {
        this.pressedOutOfBounds = false;
        this.disposedDueToRotation = false;
        this.setLightweightMode(false);
        this.onShowCompleted();
        if (this.isDisposed()) {
            this.disposeImpl();
        }
        if (this.showListener != null) {
            this.showListener.fireActionEvent(new ActionEvent((Object)this, ActionEvent.Type.Show));
        }
    }

    public void showBack() {
        this.showImpl(true);
    }

    public void setScrollable(boolean scrollable) {
        this.getContentPane().setScrollable(scrollable);
    }

    public void show() {
        this.showImpl(false);
    }

    private void showImpl(boolean reverse) {
        if (this.modal && Display.isInitialized() && Display.getInstance().isMinimized()) {
            Log.p("Modal dialogs cannot be displayed on a minimized app");
            return;
        }
        this.setDisposed(false);
        if (this.top > -1) {
            this.show(this.top, this.bottom, this.left, this.right, this.includeTitle, this.modal);
        } else if (this.modal) {
            if (this.getDialogPosition() == null) {
                super.showModal(reverse);
            } else {
                this.showPacked(this.getDialogPosition(), true);
            }
        } else {
            this.showModeless();
        }
    }

    public void showModeless() {
        this.modal = false;
        this.setDisposed(false);
        if (this.top > -1) {
            this.show(this.top, this.bottom, this.left, this.right, this.includeTitle, false);
        } else if (this.getDialogPosition() == null) {
            this.showDialog(false, false);
        } else {
            this.showPacked(this.getDialogPosition(), false);
        }
    }

    void showModal(int top, int bottom, int left, int right, boolean includeTitle, boolean modal, boolean reverse) {
        if (Display.isInitialized() && Display.getInstance().isMinimized()) {
            Log.p("Modal dialogs cannot be displayed on a minimized app");
            return;
        }
        this.top = top;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
        if (this.dialogTitle != null && this.getUIManager().isThemeConstant("hideEmptyTitleBool", false)) {
            boolean b = this.dialogTitle.getText().length() > 0;
            this.getTitleArea().setVisible(b);
            this.getTitleComponent().setVisible(b);
        }
        super.showModal(top, bottom, left, right, includeTitle, modal, reverse);
    }

    public Command showPopupDialog(Component c) {
        Rectangle componentPos = c.getSelectedRect();
        componentPos.setX(componentPos.getX() - c.getScrollX());
        componentPos.setY(componentPos.getY() - c.getScrollY());
        return this.showPopupDialog(componentPos);
    }

    public Command showPopupDialog(Rectangle rect) {
        Command result;
        if (this.getDialogUIID().equals("Dialog")) {
            this.setDialogUIID("PopupDialog");
            if (this.getTitleComponent().getUIID().equals("DialogTitle")) {
                this.getTitleComponent().setUIID("PopupDialogTitle");
            }
            this.getContentPane().setUIID("PopupContentPane");
        }
        this.disposeOnRotation = true;
        this.disposeWhenPointerOutOfBounds = true;
        Command backCommand = null;
        if (this.getBackCommand() == null) {
            backCommand = new Command("Back");
            this.setBackCommand(backCommand);
        }
        Container contentPane = super.getContentPane();
        Label title = super.getTitleComponent();
        int menuHeight = this.calcMenuHeight();
        UIManager manager = this.getUIManager();
        if (this.dialogTitle != null && manager.isThemeConstant("hideEmptyTitleBool", false)) {
            boolean b = this.getTitle().length() > 0;
            this.getTitleArea().setVisible(b);
            this.getTitleComponent().setVisible(b);
            if (!b && manager.isThemeConstant("shrinkPopupTitleBool", true)) {
                this.getTitleComponent().setPreferredSize(new Dimension(0, 0));
                this.getTitleComponent().getStyle().setBorder(null);
                this.getTitleArea().setPreferredSize(new Dimension(0, 0));
                if (this.getContentPane().getClientProperty("$ENLARGED_POP") == null) {
                    this.getContentPane().putClientProperty("$ENLARGED_POP", Boolean.TRUE);
                    int cpPaddingTop = this.getContentPane().getStyle().getPaddingTop();
                    int titlePT = this.getTitleComponent().getStyle().getPaddingTop();
                    byte[] pu = this.getContentPane().getStyle().getPaddingUnit();
                    if (pu == null) {
                        pu = new byte[4];
                    }
                    pu[0] = 0;
                    this.getContentPane().getStyle().setPaddingUnit(pu);
                    int pop = Display.getInstance().convertToPixels(manager.getThemeConstant("popupNoTitleAddPaddingInt", 1), false);
                    this.getContentPane().getStyle().setPadding(0, pop + cpPaddingTop + titlePT);
                }
            }
        }
        this.revalidate();
        Style contentPaneStyle = this.getDialogStyle();
        boolean restoreArrow = false;
        if (manager.isThemeConstant(this.getDialogUIID() + "ArrowBool", false)) {
            Image t = manager.getThemeImageConstant(this.getDialogUIID() + "ArrowTopImage");
            Image b = manager.getThemeImageConstant(this.getDialogUIID() + "ArrowBottomImage");
            Image l = manager.getThemeImageConstant(this.getDialogUIID() + "ArrowLeftImage");
            Image r = manager.getThemeImageConstant(this.getDialogUIID() + "ArrowRightImage");
            Border border = contentPaneStyle.getBorder();
            if (border != null) {
                border.setImageBorderSpecialTile(t, b, l, r, rect);
                restoreArrow = true;
            }
        } else {
            Border border = contentPaneStyle.getBorder();
            if (border != null) {
                border.setTrackComponent(rect);
            }
        }
        int prefHeight = contentPane.getPreferredH();
        int prefWidth = contentPane.getPreferredW();
        if (contentPaneStyle.getBorder() != null) {
            prefWidth = Math.max(contentPaneStyle.getBorder().getMinimumWidth(), prefWidth);
            prefHeight = Math.max(contentPaneStyle.getBorder().getMinimumHeight(), prefHeight);
        }
        int availableHeight = Display.getInstance().getDisplayHeight() - menuHeight - title.getPreferredH();
        int availableWidth = Display.getInstance().getDisplayWidth();
        int width = Math.min(availableWidth, prefWidth += this.getUIManager().getLookAndFeel().getVerticalScrollWidth());
        int x = 0;
        int y = 0;
        boolean showPortrait = this.popupDirectionBiasPortrait != null ? this.popupDirectionBiasPortrait.booleanValue() : Display.getInstance().isPortrait();
        if (showPortrait) {
            if (availableHeight < (availableWidth - rect.getWidth()) / 2) {
                showPortrait = false;
            }
        } else if (availableHeight / 2 > availableWidth - rect.getWidth()) {
            showPortrait = true;
        }
        if (showPortrait) {
            int height;
            int idealX;
            if (width < availableWidth && (idealX = rect.getX() - width / 2 + rect.getSize().getWidth() / 2) > 0) {
                x = idealX + width > availableWidth ? availableWidth - width : idealX;
            }
            if (rect.getY() < availableHeight / 2) {
                if (this.getDialogUIID().equals("PopupDialog") && this.isUIIDByPopupPosition) {
                    this.getContentPane().setUIID("PopupContentPaneDownwards");
                }
                y = rect.getY() + rect.getSize().getHeight();
                height = Math.min(prefHeight, availableHeight - y);
                result = this.show(y, availableHeight - height - y, x, availableWidth - width - x, true, true);
            } else {
                if (this.getDialogUIID().equals("PopupDialog") && this.isUIIDByPopupPosition) {
                    this.getContentPane().setUIID("PopupContentPaneUpwards");
                }
                height = Math.min(prefHeight, availableHeight - (availableHeight - rect.getY()));
                y = rect.getY() - height;
                result = this.show(y, availableHeight - height - y, x, availableWidth - width - x, true, true);
            }
        } else {
            int idealY;
            int height = Math.min(prefHeight, availableHeight);
            if (height < availableHeight && (idealY = rect.getY() - height / 2 + rect.getSize().getHeight() / 2) > 0) {
                y = idealY + height > availableHeight ? availableHeight - height : idealY;
            }
            if (prefWidth > rect.getX()) {
                if (this.getDialogUIID().equals("PopupDialog") && this.isUIIDByPopupPosition) {
                    this.getContentPane().setUIID("PopupContentPaneRight");
                }
                if ((x = rect.getX() + rect.getSize().getWidth()) + prefWidth > availableWidth) {
                    x = availableWidth - prefWidth;
                }
                width = Math.min(prefWidth, availableWidth - x);
                result = this.show(y, availableHeight - height - y, Math.max(0, x), Math.max(0, availableWidth - width - x), true, true);
            } else {
                if (this.getDialogUIID().equals("PopupDialog") && this.isUIIDByPopupPosition) {
                    this.getContentPane().setUIID("PopupContentPaneLeft");
                }
                width = Math.min(prefWidth, availableWidth - (availableWidth - rect.getX()));
                x = rect.getX() - width;
                result = this.show(y, availableHeight - height - y, Math.max(0, x), Math.max(0, availableWidth - width - x), true, true);
            }
        }
        if (restoreArrow) {
            contentPaneStyle.getBorder().clearImageBorderSpecialTile();
        }
        if (result == backCommand) {
            return null;
        }
        return result;
    }

    private int calcMenuHeight() {
        if (this.getSoftButtonCount() > 1) {
            Container menuBar = this.getSoftButton(0).getParent();
            Style menuStyle = menuBar.getStyle();
            return menuBar.getPreferredH() + menuStyle.getVerticalMargins();
        }
        return 0;
    }

    public Command showPacked(String position, boolean modal) {
        return this.showPackedImpl(position, modal, false);
    }

    public Command showStretched(String position, boolean modal) {
        return this.showPackedImpl(position, modal, true);
    }

    public Command showStetched(String position, boolean modal) {
        return this.showPackedImpl(position, modal, true);
    }

    public Dimension getDialogPreferredSize() {
        Container contentPane = super.getContentPane();
        Style contentPaneStyle = this.getDialogStyle();
        int width = Display.getInstance().getDisplayWidth();
        int prefHeight = contentPane.getPreferredH();
        int prefWidth = contentPane.getPreferredW();
        prefWidth = Math.min(prefWidth, width);
        if (contentPaneStyle.getBorder() != null) {
            prefWidth = Math.max(contentPaneStyle.getBorder().getMinimumWidth(), prefWidth);
            prefHeight = Math.max(contentPaneStyle.getBorder().getMinimumHeight(), prefHeight);
        }
        return new Dimension(prefWidth, prefHeight);
    }

    private Command showPackedImpl(String position, boolean modal, boolean stretch) {
        if (this.getTitle() == null) {
            this.setTitle("");
        }
        this.position = position;
        int height = Display.getInstance().getDisplayHeight();
        int width = Display.getInstance().getDisplayWidth();
        if (this.top > -1) {
            this.refreshTheme();
        }
        Container contentPane = super.getContentPane();
        if (this.dialogTitle != null && this.getUIManager().isThemeConstant("hideEmptyTitleBool", false)) {
            boolean b = this.getTitle().length() > 0;
            this.getTitleArea().setVisible(b);
            this.getTitleComponent().setVisible(b);
        }
        Style contentPaneStyle = contentPane.getStyle();
        this.revalidate();
        int prefHeight = contentPane.getPreferredH();
        int prefWidth = contentPane.getPreferredW();
        prefWidth = Math.min(prefWidth, width);
        if (contentPaneStyle.getBorder() != null) {
            prefWidth = Math.max(contentPaneStyle.getBorder().getMinimumWidth(), prefWidth);
            prefHeight = Math.max(contentPaneStyle.getBorder().getMinimumHeight(), prefHeight);
        }
        int topBottom = Math.max(0, (height - prefHeight) / 2);
        int leftRight = Math.max(0, (width - prefWidth) / 2);
        if (position.equals("Center")) {
            this.show(topBottom, topBottom, leftRight, leftRight, true, modal);
            return this.lastCommandPressed;
        }
        if (position.equals("East")) {
            if (stretch) {
                this.show(0, 0, Math.max(0, width - prefWidth), 0, true, modal);
            } else {
                this.show(topBottom, topBottom, Math.max(0, width - prefWidth), 0, true, modal);
            }
            return this.lastCommandPressed;
        }
        if (position.equals("West")) {
            if (stretch) {
                this.show(0, 0, 0, Math.max(0, width - prefWidth), true, modal);
            } else {
                this.show(topBottom, topBottom, 0, Math.max(0, width - prefWidth), true, modal);
            }
            return this.lastCommandPressed;
        }
        if (position.equals("North")) {
            if (stretch) {
                this.show(0, Math.max(0, height - prefHeight), 0, 0, true, modal);
            } else {
                this.show(0, Math.max(0, height - prefHeight), leftRight, leftRight, true, modal);
            }
            return this.lastCommandPressed;
        }
        if (position.equals("South")) {
            if (stretch) {
                this.show(Math.max(0, height - prefHeight), 0, 0, 0, true, modal);
            } else {
                this.show(Math.max(0, height - prefHeight), 0, leftRight, leftRight, true, modal);
            }
            return this.lastCommandPressed;
        }
        throw new IllegalArgumentException("Unknown position: " + position);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.setDisposed(true);
        if (!this.menu) {
            super.dispose();
        }
    }

    public Command showDialog() {
        this.lastCommandPressed = null;
        this.show();
        return this.lastCommandPressed;
    }

    protected void actionCommand(Command cmd) {
        if (!this.autoDispose || this.lastCommandPressed == null) {
            this.lastCommandPressed = cmd;
        }
        if (this.menu || this.autoDispose && cmd.isDisposesDialog()) {
            this.dispose();
        }
    }

    public boolean animate() {
        this.isTimedOut();
        return false;
    }

    private boolean isTimedOut() {
        if (this.time != 0L && System.currentTimeMillis() >= this.time) {
            this.time = 0L;
            this.dispose();
            this.deregisterAnimatedInternal(this);
            return true;
        }
        return false;
    }

    boolean isMenu() {
        return this.menu;
    }

    void setMenu(boolean menu) {
        this.menu = menu;
    }

    void addSelectCommand() {
        if (!this.menu) {
            this.getMenuBar().addSelectCommand(this.getSelectCommandText());
        }
    }

    boolean isDisposed() {
        return this.disposed || this.isTimedOut();
    }

    void setDisposed(boolean disposed) {
        this.disposed = disposed;
    }

    public boolean isAutoDispose() {
        return this.autoDispose;
    }

    public void setAutoDispose(boolean autoDispose) {
        this.autoDispose = autoDispose;
    }

    public static void setDefaultDialogPosition(String p) {
        defaultDialogPosition = p;
    }

    public static String getDefaultDialogPosition() {
        return defaultDialogPosition;
    }

    public int getDialogType() {
        return this.dialogType;
    }

    public void setDialogType(int dialogType) {
        this.dialogType = dialogType;
    }

    public static void setDefaultDialogType(int d) {
        defaultDialogType = d;
    }

    public static int getDefaultDialogType() {
        return defaultDialogType;
    }

    public static void setAutoAdjustDialogSize(boolean a) {
        autoAdjustDialogSize = a;
    }

    public static boolean isAutoAdjustDialogSize() {
        return autoAdjustDialogSize;
    }

    public static void setDisableStaticDialogScrolling(boolean d) {
        disableStaticDialogScrolling = d;
    }

    public static boolean isDisableStaticDialogScrolling() {
        return disableStaticDialogScrolling;
    }

    public static void setCommandsAsButtons(boolean c) {
        commandsAsButtons = c;
    }

    public static boolean isCommandsAsButtons() {
        return commandsAsButtons;
    }

    public void setDisposeWhenPointerOutOfBounds(boolean disposeWhenPointerOutOfBounds) {
        this.disposeWhenPointerOutOfBounds = disposeWhenPointerOutOfBounds;
    }

    public boolean isDisposeWhenPointerOutOfBounds() {
        return this.disposeWhenPointerOutOfBounds;
    }

    public void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
        if (this.disposeWhenPointerOutOfBounds && this.pressedOutOfBounds && !this.getTitleComponent().containsOrOwns(x, y) && !this.getContentPane().containsOrOwns(x, y) && !this.getMenuBar().containsOrOwns(x, y)) {
            this.dispose();
        }
    }

    public void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        this.pressedOutOfBounds = !this.getTitleComponent().containsOrOwns(x, y) && !this.getContentPane().containsOrOwns(x, y) && !this.getMenuBar().containsOrOwns(x, y);
    }

    public boolean wasDisposedDueToOutOfBoundsTouch() {
        return this.pressedOutOfBounds;
    }

    public String getDialogPosition() {
        return this.dialogPosition;
    }

    public void setDialogPosition(String dialogPosition) {
        this.dialogPosition = dialogPosition;
    }

    void repaint(Component cmp) {
        if (this.getParent() != null) {
            super.repaint(cmp);
            return;
        }
        if (this.isVisible() && !this.disposed) {
            Display.getInstance().repaint(cmp);
        }
    }

    public void growOrShrink() {
        this.getDialogComponent().setShouldCalcPreferredSize(true);
        this.growOrShrinkImpl(Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight());
        this.forceRevalidate();
    }

    private void growOrShrinkImpl(int w, int h) {
        Container contentPane = super.getContentPane();
        Label title = super.getTitleComponent();
        int prefHeight = contentPane.getPreferredH();
        int prefWidth = contentPane.getPreferredW();
        Style contentPaneStyle = contentPane.getStyle();
        Style titleStyle = title.getStyle();
        if (this.position != null) {
            int menuHeight = 0;
            if (this.getSoftButtonCount() > 1) {
                Container menuBar = this.getSoftButton(0).getParent();
                Style menuStyle = menuBar.getStyle();
                menuHeight = menuBar.getPreferredH() + menuStyle.getVerticalMargins();
            }
            prefWidth = Math.min(prefWidth, w);
            h = h - menuHeight - title.getPreferredH();
            int topBottom = Math.max(0, (h - prefHeight) / 2);
            int leftRight = Math.max(0, (w - prefWidth) / 2);
            int top = topBottom;
            int bottom = topBottom;
            int left = leftRight;
            int right = leftRight;
            if (this.position.equals("East")) {
                left = Math.max(0, w - prefWidth);
                right = 0;
            } else if (this.position.equals("West")) {
                right = 0;
                left = Math.max(0, w - prefWidth);
            } else if (this.position.equals("North")) {
                top = 0;
                bottom = Math.max(0, h - prefHeight);
            } else if (this.position.equals("South")) {
                top = Math.max(0, h - prefHeight);
                bottom = 0;
            }
            titleStyle.setMargin(0, 0, true);
            titleStyle.setMargin(2, 0, true);
            titleStyle.setMargin(1, 0, true);
            titleStyle.setMargin(3, 0, true);
            contentPaneStyle.setMargin(0, top, true);
            contentPaneStyle.setMargin(2, bottom, true);
            contentPaneStyle.setMargin(1, left, true);
            contentPaneStyle.setMargin(3, right, true);
            return;
        }
        int oldW = this.getWidth();
        int oldH = this.getHeight();
        if (oldW != w || oldH != h) {
            if (prefWidth <= w && prefHeight <= h) {
                float oldLeftRightDistRatio = 1.0f;
                if (this.left + this.right != 0) {
                    oldLeftRightDistRatio = (float)this.left / ((float)this.left + (float)this.right);
                }
                float oldTopBottomDistRatio = 1.0f;
                if (this.left + this.right != 0) {
                    oldTopBottomDistRatio = (float)this.top / ((float)this.top + (float)this.bottom);
                }
                this.top = Math.max(0, (int)((float)(h - prefHeight) * oldTopBottomDistRatio));
                this.left = Math.max(0, (int)((float)(w - prefWidth) * oldLeftRightDistRatio));
                this.bottom = Math.max(0, h - prefHeight - this.top);
                this.right = Math.max(0, w - prefWidth - this.left);
                titleStyle.setMargin(0, 0, true);
                titleStyle.setMargin(2, 0, true);
                titleStyle.setMargin(1, 0, true);
                titleStyle.setMargin(3, 0, true);
                contentPaneStyle.setMargin(0, this.top, true);
                contentPaneStyle.setMargin(2, this.bottom, true);
                contentPaneStyle.setMargin(1, this.left, true);
                contentPaneStyle.setMargin(3, this.right, true);
                return;
            }
            float ratioW = (float)w / (float)oldW;
            float ratioH = (float)h / (float)oldH;
            Style s = this.getDialogStyle();
            s.setMargin(0, (int)((float)s.getMarginTop() * ratioH));
            s.setMargin(2, (int)((float)s.getMarginBottom() * ratioH));
            s.setMargin(1, (int)((float)s.getMarginLeft(this.isRTL()) * ratioW));
            s.setMargin(3, (int)((float)s.getMarginRight(this.isRTL()) * ratioW));
            titleStyle.setMargin(0, (int)((float)titleStyle.getMarginTop() * ratioH));
            titleStyle.setMargin(1, (int)((float)titleStyle.getMarginLeft(this.isRTL()) * ratioW));
            titleStyle.setMargin(3, (int)((float)titleStyle.getMarginRight(this.isRTL()) * ratioW));
            return;
        }
    }

    public Boolean getPopupDirectionBiasPortrait() {
        return this.popupDirectionBiasPortrait;
    }

    public void setPopupDirectionBiasPortrait(Boolean popupDirectionBiasPortrait) {
        this.popupDirectionBiasPortrait = popupDirectionBiasPortrait;
    }

    public boolean wasDisposedDueToRotation() {
        return this.disposedDueToRotation;
    }

    public float getBlurBackgroundRadius() {
        return this.blurBackgroundRadius;
    }

    public void setBlurBackgroundRadius(float blurBackgroundRadius) {
        this.blurBackgroundRadius = blurBackgroundRadius;
    }

    public static float getDefaultBlurBackgroundRadius() {
        return defaultBlurBackgroundRadius;
    }

    public static void setDefaultBlurBackgroundRadius(float aDefaultBlurBackgroundRadius) {
        defaultBlurBackgroundRadius = aDefaultBlurBackgroundRadius;
    }

    void initDialogBgPainter(Painter p, Form previousForm) {
        if (this.getBlurBackgroundRadius() > 0.0f && Display.impl.isGaussianBlurSupported()) {
            Image img = Image.createImage(previousForm.getWidth(), previousForm.getHeight());
            Graphics g = img.getGraphics();
            previousForm.paintComponent(g, true);
            img = Display.getInstance().gaussianBlurImage(img, this.blurBackgroundRadius);
            this.getUnselectedStyle().setBgImage(img);
            this.getUnselectedStyle().setBackgroundType((byte)33);
        } else {
            super.initDialogBgPainter(p, previousForm);
        }
    }

    public void setUIIDByPopupPosition(boolean b) {
        this.isUIIDByPopupPosition = b;
    }

    static {
        defaultDialogType = 4;
        commandsAsButtons = true;
        defaultDisposeWhenPointerOutOfBounds = false;
        defaultBlurBackgroundRadius = -1.0f;
    }
}

