/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.cloud;

import com.codename1.io.ConnectionRequest;
import com.codename1.io.NetworkManager;
import com.codename1.io.Preferences;
import com.codename1.io.Util;
import com.codename1.ui.Display;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class CloudPersona {
    private String persona;
    private static CloudPersona instance;

    private CloudPersona() {
    }

    public static CloudPersona getCurrentPersona() {
        if (instance == null) {
            instance = new CloudPersona();
            CloudPersona.instance.persona = Preferences.get("CN1Persona", null);
        }
        return instance;
    }

    public String getToken() {
        return this.persona;
    }

    public static void createFromToken(String token) {
        if (instance == null) {
            instance = new CloudPersona();
        }
        CloudPersona.instance.persona = token;
        Preferences.set("CN1Persona", token);
    }

    public static boolean createAnonymous() {
        if (instance == null) {
            CloudPersona.getCurrentPersona();
        }
        ConnectionRequest login = new ConnectionRequest();
        login.setPost(true);
        login.setUrl("https://codename-one.appspot.com/objStoreUser");
        login.addArgument("pk", Display.getInstance().getProperty("package_name", null));
        login.addArgument("bb", Display.getInstance().getProperty("built_by_user", null));
        NetworkManager.getInstance().addToQueueAndWait(login);
        if (login.getResposeCode() != 200) {
            return false;
        }
        ByteArrayInputStream bi = new ByteArrayInputStream(login.getResponseData());
        DataInputStream di = new DataInputStream(bi);
        if (instance == null) {
            instance = new CloudPersona();
        }
        try {
            CloudPersona.instance.persona = di.readUTF();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Preferences.set("CN1Persona", CloudPersona.instance.persona);
        Preferences.set("CN1PersonaAnonymous", true);
        Util.cleanup(di);
        return true;
    }

    public static boolean createOrLogin(String login, String password) {
        if (instance == null) {
            CloudPersona.getCurrentPersona();
            if (CloudPersona.instance.persona != null) {
                return true;
            }
        }
        ConnectionRequest loginRequest = new ConnectionRequest();
        loginRequest.setPost(true);
        loginRequest.setUrl("https://codename-one.appspot.com/objStoreUser");
        loginRequest.addArgument("l", login);
        loginRequest.addArgument("p", password);
        loginRequest.addArgument("pk", Display.getInstance().getProperty("package_name", null));
        loginRequest.addArgument("bb", Display.getInstance().getProperty("built_by_user", null));
        NetworkManager.getInstance().addToQueueAndWait(loginRequest);
        if (loginRequest.getResposeCode() != 200) {
            return false;
        }
        ByteArrayInputStream bi = new ByteArrayInputStream(loginRequest.getResponseData());
        DataInputStream di = new DataInputStream(bi);
        try {
            if (di.readBoolean()) {
                if (instance == null) {
                    instance = new CloudPersona();
                }
            } else {
                Util.cleanup(di);
                return false;
            }
            CloudPersona.instance.persona = di.readUTF();
            Preferences.set("CN1Persona", CloudPersona.instance.persona);
            Util.cleanup(di);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public void logout() {
        if (Preferences.get("CN1PersonaAnonymous", false)) {
            throw new RuntimeException("Anonymous personas can't be logged out!");
        }
        Preferences.delete("CN1Persona");
    }
}

