/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.components.Progress;
import com.codename1.components.WebBrowser;
import com.codename1.io.NetworkEvent;
import com.codename1.io.NetworkManager;
import com.codename1.io.services.ImageDownloadService;
import com.codename1.io.services.RSSService;
import com.codename1.ui.Button;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.List;
import com.codename1.ui.Tabs;
import com.codename1.ui.TextArea;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.list.DefaultListModel;
import com.codename1.ui.list.GenericListCellRenderer;
import java.util.Hashtable;
import java.util.Vector;

public class RSSReader
extends List {
    private Vector existingData;
    private String url = "https://codenameone.blogspot.com/feeds/posts/default?alt=rss";
    private RSSService service;
    private int limit = 20;
    private boolean waitingForResponseLock;
    private boolean blockList;
    private String progressTitle = "Fetching RSS";
    private boolean displayProgressPercentage = true;
    private Image iconPlaceholder;
    private static final Hashtable MORE = new Hashtable();
    private boolean designMode;
    private Container targetContainer;
    private boolean addBackToTaget = true;

    public RSSReader() {
        this.setUIID("RSSReader");
        this.setRenderer(new GenericListCellRenderer(this.createRendererContainer(), this.createRendererContainer()));
        this.addActionListener((ActionListener)new EventHandler());
    }

    public static void setMoreDescription(String d) {
        MORE.put("description", d);
    }

    public static void setMoreTitle(String t) {
        MORE.put("title", t);
    }

    private Container createRendererContainer() {
        Container entries = new Container(new BoxLayout(2));
        entries.setUIID("RSSEntry");
        Label title = new Label();
        title.setName("title");
        title.setUIID("RSSTitle");
        entries.addComponent(title);
        TextArea description = new TextArea(2, 30);
        description.setGrowByContent(false);
        description.setName("details");
        description.setUIID("RSSDescription");
        description.setScrollVisible(false);
        entries.addComponent(description);
        if (this.iconPlaceholder != null) {
            Container wrap = new Container(new BorderLayout());
            wrap.addComponent("Center", (Component)entries);
            Label icon = new Label();
            icon.setIcon(this.iconPlaceholder);
            icon.setUIID("RSSIcon");
            icon.setName("icon");
            wrap.addComponent("West", (Component)icon);
            entries = wrap;
        }
        return entries;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void sendRequest() {
        if (this.service == null) {
            this.service = new RSSService(this.url, this.limit);
            if (this.iconPlaceholder != null) {
                this.service.setIconPlaceholder(this.iconPlaceholder);
            }
            this.service.addResponseListener(new EventHandler());
            if (this.blockList) {
                Progress p = new Progress(this.progressTitle, this.service, this.displayProgressPercentage);
                p.setAutoShow(true);
                p.setDisposeOnCompletion(true);
            }
            this.setHint(this.progressTitle);
            NetworkManager.getInstance().addToQueue(this.service);
        }
    }

    protected void initComponent() {
        super.initComponent();
        if (this.designMode) {
            this.setHint("RSS Data Will Show Here");
        } else {
            this.sendRequest();
        }
    }

    public String getURL() {
        return this.url;
    }

    public Image getIconPlaceholder() {
        return this.iconPlaceholder;
    }

    public void setIconPlaceholder(Image iconPlaceholder) {
        this.iconPlaceholder = iconPlaceholder;
        if (this.service != null) {
            this.service.setIconPlaceholder(iconPlaceholder);
        }
        this.setRenderer(new GenericListCellRenderer(this.createRendererContainer(), this.createRendererContainer()));
    }

    void updateComponentValues(Container root, Hashtable h) {
        int c = root.getComponentCount();
        for (int iter = 0; iter < c; ++iter) {
            String val;
            Component current = root.getComponentAt(iter);
            if (current.getClass() == Container.class || current.getClass() == Tabs.class) {
                this.updateComponentValues((Container)current, h);
                continue;
            }
            String n = current.getName();
            if (n == null || (val = (String)h.get(n)) == null) continue;
            if (current instanceof Button) {
                String url = val;
                ((Button)current).addActionListener((ActionListener)new Listener(url));
                continue;
            }
            if (current instanceof Label) {
                ((Label)current).setText(val);
                continue;
            }
            if (current instanceof TextArea) {
                ((TextArea)current).setText(val);
                continue;
            }
            if (!(current instanceof WebBrowser)) continue;
            ((WebBrowser)current).setPage(val, null);
        }
    }

    protected void showRSSEntry(Hashtable h) {
        Form newForm = null;
        if (this.targetContainer != null) {
            if (this.targetContainer instanceof Form) {
                newForm = (Form)this.targetContainer;
            } else {
                newForm = new Form((String)h.get("title"));
                newForm.setLayout(new BorderLayout());
                newForm.addComponent("Center", (Component)this.targetContainer);
            }
            this.updateComponentValues(newForm, h);
        } else {
            newForm = new Form((String)h.get("title"));
            newForm.setScrollable(false);
            WebBrowser c = new WebBrowser();
            String s = (String)h.get("description");
            s = "<html><body>" + s + "</body></html>";
            c.setPage(s, null);
            newForm.setLayout(new BorderLayout());
            newForm.addComponent("Center", (Component)c);
        }
        if (this.addBackToTaget) {
            Form sourceForm = Display.getInstance().getCurrent();
            BackCommand back = new BackCommand(sourceForm);
            newForm.addCommand(back);
            newForm.setBackCommand(back);
        }
        newForm.show();
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String[] getPropertyNames() {
        return new String[]{"limit", "url", "blockList", "progressTitle", "displayProgressPercentage", "target"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{Integer.class, String.class, Boolean.class, String.class, Boolean.class, Container.class};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("limit")) {
            return new Integer(this.limit);
        }
        if (name.equals("url")) {
            return this.url;
        }
        if (name.equals("blockList")) {
            if (this.blockList) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (name.equals("progressTitle")) {
            return this.progressTitle;
        }
        if (name.equals("displayProgressPercentage")) {
            if (this.displayProgressPercentage) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (name.equals("target")) {
            return this.targetContainer;
        }
        if (name.equals("$designMode")) {
            if (this.designMode) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("limit")) {
            this.limit = (Integer)value;
            return null;
        }
        if (name.equals("url")) {
            this.url = (String)value;
            return null;
        }
        if (name.equals("blockList")) {
            this.blockList = (Boolean)value;
            return null;
        }
        if (name.equals("progressTitle")) {
            this.progressTitle = (String)value;
            return null;
        }
        if (name.equals("displayProgressPercentage")) {
            this.displayProgressPercentage = (Boolean)value;
            return null;
        }
        if (name.equals("target")) {
            this.targetContainer = (Container)value;
            return null;
        }
        if (name.equals("$designMode")) {
            this.designMode = (Boolean)value;
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public boolean isBlockList() {
        return this.blockList;
    }

    public void setBlockList(boolean blockList) {
        this.blockList = blockList;
    }

    public String getProgressTitle() {
        return this.progressTitle;
    }

    public void setProgressTitle(String progressTitle) {
        this.progressTitle = progressTitle;
    }

    public Container getTargetContainer() {
        return this.targetContainer;
    }

    public void setTargetContainer(Container targetContainer) {
        this.targetContainer = targetContainer;
    }

    public boolean isAddBackToTaget() {
        return this.addBackToTaget;
    }

    public void setAddBackToTaget(boolean addBackToTaget) {
        this.addBackToTaget = addBackToTaget;
    }

    static {
        MORE.put("title", "More");
        MORE.put("details", "Fetch More Elements");
    }

    class EventHandler
    implements ActionListener {
        EventHandler() {
        }

        private void downloadImage(Hashtable h, int offset) {
            String url;
            if (RSSReader.this.iconPlaceholder != null && (url = (String)h.get("thumb")) != null) {
                ImageDownloadService.createImageToStorage(url, RSSReader.this, RSSReader.this.getModel(), offset, "icon", url.replace('/', '_').replace(':', '_'), RSSReader.this.iconPlaceholder, (byte)0);
            }
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt instanceof NetworkEvent) {
                Hashtable h;
                int iter;
                RSSReader.this.waitingForResponseLock = false;
                NetworkEvent e = (NetworkEvent)evt;
                Vector v = (Vector)e.getMetaData();
                RSSService s = (RSSService)e.getConnectionRequest();
                if (RSSReader.this.existingData != null) {
                    RSSReader.this.existingData.removeElement(MORE);
                    for (iter = 0; iter < v.size(); ++iter) {
                        h = (Hashtable)v.elementAt(iter);
                        RSSReader.this.existingData.addElement(h);
                    }
                } else {
                    RSSReader.this.existingData = v;
                }
                if (s.hasMore()) {
                    v.addElement(MORE);
                }
                RSSReader.this.setModel(new DefaultListModel(RSSReader.this.existingData));
                for (iter = 0; iter < RSSReader.this.existingData.size(); ++iter) {
                    h = (Hashtable)RSSReader.this.existingData.elementAt(iter);
                    Object icn = h.get("icon");
                    if (icn == null || icn != RSSReader.this.iconPlaceholder) continue;
                    this.downloadImage(h, iter);
                }
                return;
            }
            Hashtable sel = (Hashtable)RSSReader.this.getSelectedItem();
            if (sel == MORE) {
                if (RSSReader.this.waitingForResponseLock) {
                    return;
                }
                RSSReader.this.waitingForResponseLock = true;
                RSSReader.this.service = new RSSService(RSSReader.this.url, RSSReader.this.limit, RSSReader.this.existingData.size() - 1);
                if (RSSReader.this.iconPlaceholder != null) {
                    RSSReader.this.service.setIconPlaceholder(RSSReader.this.iconPlaceholder);
                }
                RSSReader.this.service.addResponseListener(new EventHandler());
                Progress p = new Progress("Fetching RSS", RSSReader.this.service, RSSReader.this.displayProgressPercentage);
                p.setAutoShow(true);
                p.setDisposeOnCompletion(true);
                NetworkManager.getInstance().addToQueue(RSSReader.this.service);
            } else {
                RSSReader.this.showRSSEntry(sel);
            }
        }
    }

    class BackCommand
    extends Command {
        private Form sourceForm;

        public BackCommand(Form sourceForm) {
            super("Back");
            this.sourceForm = sourceForm;
        }

        public void actionPerformed(ActionEvent ev) {
            this.sourceForm.showBack();
        }
    }

    class Listener
    implements ActionListener {
        private String url;

        public Listener(String url) {
            this.url = url;
        }

        public void actionPerformed(ActionEvent evt) {
            Display.getInstance().execute(this.url);
        }
    }
}

