/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.ui.Component;
import com.codename1.ui.ComponentSelector;
import com.codename1.ui.Container;
import com.codename1.ui.Font;
import com.codename1.ui.IconHolder;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.TextArea;
import com.codename1.ui.TextHolder;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.FlowLayout;
import com.codename1.ui.plaf.Style;

public class SpanLabel
extends Container
implements IconHolder,
TextHolder {
    private Label icon;
    private int gap;
    private Container iconWrapper;
    private TextArea text;
    private boolean shouldLocalize = true;
    private int preferredW = -1;

    public SpanLabel() {
        this("");
    }

    public SpanLabel(String txt, String textUiid) {
        this(txt);
        this.text.setUIID(textUiid);
        this.updateGap();
    }

    public SpanLabel(String txt) {
        this.setUIID("Container");
        this.setLayout(new BorderLayout());
        this.text = new TextArea(this.getUIManager().localize(txt, txt));
        this.text.setActAsLabel(true);
        this.text.setColumns(this.text.getText().length() + 1);
        this.text.setGrowByContent(true);
        this.text.setUIID("Label");
        this.text.setEditable(false);
        this.text.setFocusable(false);
        this.icon = new Label();
        this.icon.setUIID("icon");
        this.iconWrapper = new Container(new FlowLayout(4, 4));
        this.iconWrapper.getAllStyles().stripMarginAndPadding();
        this.iconWrapper.add(this.icon);
        this.addComponent("West", (Component)this.iconWrapper);
        this.addComponent("Center", (Component)BoxLayout.encloseYCenter(this.text));
        this.updateGap();
    }

    public void setPreferredW(int preferredW) {
        this.preferredW = preferredW;
    }

    public int getPreferredW() {
        if (this.preferredW != -1) {
            return this.preferredW;
        }
        return super.getPreferredW();
    }

    public Component getIconStyleComponent() {
        return this.icon.getIconStyleComponent();
    }

    public TextArea getTextComponent() {
        return this.text;
    }

    public void setTextUIID(String uiid) {
        this.text.setUIID(uiid);
    }

    public String getTextUIID() {
        return this.text.getUIID();
    }

    public Style getTextAllStyles() {
        return this.text.getAllStyles();
    }

    public Style getTextUnselectedStyle() {
        return this.text.getUnselectedStyle();
    }

    public void setTextUnselectedStyle(Style t) {
        this.text.setUnselectedStyle(t);
    }

    public Style getTextSelectedStyle() {
        return this.text.getSelectedStyle();
    }

    public void setTextSelectedStyle(Style t) {
        this.text.setSelectedStyle(t);
    }

    public void setIconUIID(String uiid) {
        this.icon.setUIID(uiid);
        this.updateGap();
    }

    public String getIconUIID() {
        return this.icon.getUIID();
    }

    public void setText(String t) {
        t = this.shouldLocalize ? this.getUIManager().localize(t, t) : t;
        this.text.setText(t);
        this.text.setColumns(this.text.getText().length() + 1);
    }

    public void setIcon(Image i) {
        this.icon.setIcon(i);
        this.updateGap();
    }

    public void setIconValign(int align) {
        ((FlowLayout)this.iconWrapper.getLayout()).setValign(align);
    }

    public int getIconValign() {
        return ((FlowLayout)this.iconWrapper.getLayout()).getValign();
    }

    public String getText() {
        return this.text.getText();
    }

    public void setTextBlockAlign(int align) {
        switch (align) {
            case 1: 
            case 3: 
            case 4: {
                this.wrapText(align);
                return;
            }
        }
        if (this.text.getParent() != this) {
            this.removeComponent(this.text.getParent());
            this.text.getParent().removeAll();
            this.addComponent("Center", (Component)BoxLayout.encloseYCenter(this.text));
        }
    }

    public int getTextBlockAlign() {
        if (this.text.getParent() == this) {
            return -1;
        }
        return ((FlowLayout)this.text.getParent().getLayout()).getAlign();
    }

    private void wrapText(int alignment) {
        Container parent = this.text.getParent();
        if (parent == this) {
            parent.removeComponent(this.text);
            parent = new Container(new FlowLayout(alignment, 4));
            parent.getAllStyles().stripMarginAndPadding();
            parent.addComponent(this.text);
            this.addComponent("Center", (Component)parent);
        } else if (parent.getLayout() instanceof BoxLayout) {
            this.removeComponent(parent);
            parent.removeComponent(this.text);
            parent = new Container(new FlowLayout(alignment, 4));
            parent.getAllStyles().stripMarginAndPadding();
            parent.addComponent(this.text);
            this.addComponent("Center", (Component)parent);
        } else {
            ((FlowLayout)parent.getLayout()).setAlign(alignment);
        }
    }

    public Image getIcon() {
        return this.icon.getIcon();
    }

    public void setIconPosition(String t) {
        this.removeComponent(this.iconWrapper);
        this.addComponent(t, (Component)this.iconWrapper);
        this.updateGap();
        this.revalidateLater();
    }

    public String getIconPosition() {
        return (String)this.getLayout().getComponentConstraint(this.iconWrapper);
    }

    public String[] getPropertyNames() {
        return new String[]{"text", "icon", "iconPosition", "textUiid", "iconUiid"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{String.class, Image.class, String.class, String.class, String.class};
    }

    public String[] getPropertyTypeNames() {
        return new String[]{"String", "Image", "String", "String", "String"};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("text")) {
            return this.getText();
        }
        if (name.equals("icon")) {
            return this.getIcon();
        }
        if (name.equals("iconPosition")) {
            return this.getIconPosition();
        }
        if (name.equals("textUiid")) {
            return this.getTextUIID();
        }
        if (name.equals("iconUiid")) {
            return this.getIconUIID();
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("text")) {
            this.setText((String)value);
            return null;
        }
        if (name.equals("icon")) {
            this.setIcon((Image)value);
            return null;
        }
        if (name.equals("iconPosition")) {
            this.setIconPosition((String)value);
            return null;
        }
        if (name.equals("textUiid")) {
            this.setTextUIID((String)value);
            return null;
        }
        if (name.equals("iconUiid")) {
            this.setIconUIID((String)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public boolean isShouldLocalize() {
        return this.shouldLocalize;
    }

    public void setShouldLocalize(boolean shouldLocalize) {
        this.shouldLocalize = shouldLocalize;
    }

    public void setTextSelectionEnabled(boolean enabled) {
        this.text.setTextSelectionEnabled(enabled);
    }

    public boolean isTextSelectionEnabled() {
        return this.text.isTextSelectionEnabled();
    }

    public void setWidth(int width) {
        int w = this.getWidth();
        if (w != width) {
            int newTextW = width;
            String iconPos = this.getIconPosition();
            if (this.getIcon() != null && "East".equals(iconPos) || "West".equals(iconPos)) {
                newTextW -= this.iconWrapper.getOuterWidth();
            }
            newTextW -= this.getStyle().getHorizontalPadding();
            this.text.setWidth(newTextW -= this.text.getStyle().getHorizontalMargins());
            super.setWidth(width);
            this.setShouldCalcPreferredSize(true);
        }
    }

    public void setGap(int gap) {
        if (gap != this.gap) {
            this.gap = gap;
            this.updateGap();
        }
    }

    public int getGap() {
        return this.gap;
    }

    public void setTextPosition(int textPosition) {
        switch (textPosition) {
            case 0: {
                this.setIconPosition("South");
                break;
            }
            case 2: {
                this.setIconPosition("North");
                break;
            }
            case 1: {
                this.setIconPosition("East");
                break;
            }
            case 3: {
                this.setIconPosition("West");
                break;
            }
            default: {
                this.setIconPosition("East");
            }
        }
    }

    public int getTextPosition() {
        String iconPosition = this.getIconPosition();
        if ("North".equals(iconPosition)) {
            return 2;
        }
        if ("South".equals(iconPosition)) {
            return 0;
        }
        if ("East".equals(iconPosition)) {
            return 1;
        }
        if ("West".equals(iconPosition)) {
            return 3;
        }
        return 1;
    }

    private void updateGap() {
        if (this.getIcon() == null) {
            ComponentSelector.$(this.icon).setMargin(0);
        } else if ("North".equals(this.getIconPosition())) {
            ComponentSelector.$(this.icon).selectAllStyles().setMargin(0, 0, this.gap, 0);
        } else if ("South".equals(this.getIconPosition())) {
            ComponentSelector.$(this.icon).selectAllStyles().setMargin(this.gap, 0, 0, 0);
        } else if ("East".equals(this.getIconPosition())) {
            ComponentSelector.$(this.icon).selectAllStyles().setMargin(0, 0, 0, this.gap);
        } else if ("West".equals(this.getIconPosition())) {
            ComponentSelector.$(this.icon).selectAllStyles().setMargin(0, this.gap, 0, 0);
        }
    }

    public void setMaterialIcon(char c) {
        this.icon.setMaterialIcon(c);
    }

    public void setFontIcon(Font font, char c) {
        this.icon.setFontIcon(font, c);
    }

    public void setMaterialIcon(char c, float size) {
        this.icon.setMaterialIcon(c, size);
    }

    public void setFontIcon(Font font, char c, float size) {
        this.icon.setFontIcon(font, c, size);
    }

    public char getMaterialIcon() {
        return this.icon.getMaterialIcon();
    }

    public char getFontIcon() {
        return this.icon.getFontIcon();
    }

    public float getMaterialIconSize() {
        return this.icon.getMaterialIconSize();
    }

    public float getFontIconSize() {
        return this.icon.getFontIconSize();
    }

    public Font getIconFont() {
        return this.icon.getIconFont();
    }
}

