/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.io.Storage;
import com.codename1.ui.Display;
import com.codename1.ui.EncodedImage;
import java.io.IOException;
import java.io.InputStream;

public class StorageImage
extends EncodedImage {
    private String fileName;
    private boolean keep;
    private byte[] data;
    private Object weak;

    private StorageImage(String fileName, int w, int h, boolean keep) {
        super(w, h);
        this.fileName = fileName;
        this.keep = keep;
    }

    public byte[] getImageData() {
        byte[] d;
        if (this.data != null) {
            return this.data;
        }
        if (this.weak != null && (d = (byte[])Display.getInstance().extractHardRef(this.weak)) != null) {
            return d;
        }
        byte[] imageData = (byte[])Storage.getInstance().readObject(this.fileName);
        if (this.keep) {
            this.data = imageData;
        } else {
            this.weak = Display.getInstance().createSoftWeakRef(imageData);
        }
        return imageData;
    }

    public static StorageImage create(String fileName, byte[] data, int width, int height) {
        if (Storage.getInstance().writeObject(fileName, data)) {
            return new StorageImage(fileName, width, height, true);
        }
        return null;
    }

    public static StorageImage create(String fileName, byte[] data, int width, int height, boolean keep) {
        if (Storage.getInstance().writeObject(fileName, data)) {
            return new StorageImage(fileName, width, height, keep);
        }
        return null;
    }

    public static StorageImage create(String fileName, InputStream data, int width, int height) throws IOException {
        EncodedImage e = EncodedImage.create(data);
        return StorageImage.create(fileName, e.getImageData(), width, height);
    }

    public static StorageImage create(String fileName, int width, int height) {
        return new StorageImage(fileName, width, height, true);
    }

    public static StorageImage create(String fileName, int width, int height, boolean keep) {
        return new StorageImage(fileName, width, height, keep);
    }
}

