/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.io.CharArrayReader;
import com.codename1.io.JSONParseCallback;
import com.codename1.io.JSONSanitizer;
import com.codename1.io.Log;
import com.codename1.io.Util;
import com.codename1.processing.Result;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONParser
implements JSONParseCallback {
    private static boolean useLongsDefault;
    private boolean useLongs = useLongsDefault;
    private static boolean useBooleanDefault;
    private boolean useBoolean = useBooleanDefault;
    private static boolean includeNullsDefault;
    private boolean includeNulls = includeNullsDefault;
    private boolean modern;
    private Map<String, Object> state;
    private List<Object> parseStack;
    private String currentKey;
    private boolean strict = true;

    public static boolean isUseLongs() {
        return useLongsDefault;
    }

    public boolean isUseLongsInstance() {
        return this.useLongs;
    }

    public static void setUseLongs(boolean aUseLongsDefault) {
        useLongsDefault = aUseLongsDefault;
    }

    public void setUseLongsInstance(boolean longs) {
        this.useLongs = longs;
    }

    public static boolean isIncludeNulls() {
        return includeNullsDefault;
    }

    public static void setIncludeNulls(boolean aIncludeNullsDefault) {
        includeNullsDefault = aIncludeNullsDefault;
    }

    public void setIncludeNullsInstance(boolean include) {
        this.includeNulls = include;
    }

    public boolean isIncludeNullsInstance() {
        return this.includeNulls;
    }

    public static boolean isUseBoolean() {
        return useBooleanDefault;
    }

    public boolean isUseBooleanInstance() {
        return this.useBoolean;
    }

    public void setUseBooleanInstance(boolean useBoolean) {
        this.useBoolean = useBoolean;
    }

    public static void setUseBoolean(boolean aUseBooleanDefault) {
        useBooleanDefault = aUseBooleanDefault;
    }

    private static boolean useLongs(JSONParseCallback callback) {
        if (callback instanceof JSONParser) {
            return ((JSONParser)callback).isUseLongsInstance();
        }
        return useLongsDefault;
    }

    private static boolean useBoolean(JSONParseCallback callback) {
        if (callback instanceof JSONParser) {
            return ((JSONParser)callback).isUseBooleanInstance();
        }
        return useBooleanDefault;
    }

    public static void parse(Reader i, JSONParseCallback callback) throws IOException {
        boolean quoteMode = false;
        ReaderClass rc = new ReaderClass();
        rc.buffOffset = 0;
        rc.buffSize = -1;
        int row = 1;
        int column = 1;
        StringBuilder currentToken = new StringBuilder();
        KeyStack blocks = new KeyStack();
        String currentBlock = "";
        String lastKey = null;
        try {
            block32: while (callback.isAlive()) {
                int currentChar = rc.read(i);
                if (currentChar < 0) {
                    return;
                }
                char c = (char)currentChar;
                if (c == '\n') {
                    ++row;
                    column = 0;
                } else {
                    ++column;
                }
                if (quoteMode) {
                    switch (c) {
                        case '\"': {
                            String v = currentToken.toString();
                            callback.stringToken(v);
                            if (lastKey != null) {
                                callback.keyValue(lastKey, v);
                                lastKey = null;
                            } else {
                                lastKey = v;
                            }
                            currentToken.setLength(0);
                            quoteMode = false;
                            continue block32;
                        }
                        case '\\': {
                            c = (char)rc.read(i);
                            if (c == 'u') {
                                String unicode = "" + (char)rc.read(i) + (char)rc.read(i) + (char)rc.read(i) + (char)rc.read(i);
                                try {
                                    c = (char)Integer.parseInt(unicode, 16);
                                }
                                catch (NumberFormatException err) {
                                    Log.e(err);
                                    System.out.println("Error in parsing \\u" + unicode);
                                }
                            } else {
                                switch (c) {
                                    case 'n': {
                                        currentToken.append('\n');
                                        continue block32;
                                    }
                                    case 't': {
                                        currentToken.append('\t');
                                        continue block32;
                                    }
                                    case 'r': {
                                        currentToken.append('\r');
                                        continue block32;
                                    }
                                }
                            }
                            currentToken.append(c);
                            continue block32;
                        }
                    }
                    currentToken.append(c);
                    continue;
                }
                switch (c) {
                    case 'n': {
                        char u = (char)rc.read(i);
                        char l = (char)rc.read(i);
                        char l2 = (char)rc.read(i);
                        if (u == 'u' && l == 'l' && l2 == 'l') {
                            callback.stringToken(null);
                            if (lastKey == null) continue block32;
                            callback.keyValue(lastKey, null);
                            lastKey = null;
                            continue block32;
                        }
                        Log.p("Expected null for key value while parsing JSON token at row: " + row + " column: " + column + " buffer: " + currentToken.toString());
                        continue block32;
                    }
                    case 't': {
                        char a1 = (char)rc.read(i);
                        char a2 = (char)rc.read(i);
                        char a3 = (char)rc.read(i);
                        if (a1 == 'r' && a2 == 'u' && a3 == 'e') {
                            if (JSONParser.useBoolean(callback)) {
                                callback.booleanToken(true);
                            } else {
                                callback.stringToken("true");
                            }
                            if (lastKey == null) continue block32;
                            callback.keyValue(lastKey, "true");
                            lastKey = null;
                            continue block32;
                        }
                        Log.p("Expected true for key value while parsing JSON token at row: " + row + " column: " + column + " buffer: " + currentToken.toString());
                        continue block32;
                    }
                    case 'f': {
                        if (currentToken.length() > 0) {
                            currentToken.append('f');
                            continue block32;
                        }
                        char b1 = (char)rc.read(i);
                        char b2 = (char)rc.read(i);
                        char b3 = (char)rc.read(i);
                        char b4 = (char)rc.read(i);
                        if (b1 == 'a' && b2 == 'l' && b3 == 's' && b4 == 'e') {
                            if (JSONParser.useBoolean(callback)) {
                                callback.booleanToken(false);
                            } else {
                                callback.stringToken("false");
                            }
                            if (lastKey == null) continue block32;
                            callback.keyValue(lastKey, "false");
                            lastKey = null;
                            continue block32;
                        }
                        Log.p("Expected false for key value while parsing JSON token at row: " + row + " column: " + column + " buffer: " + currentToken.toString());
                        continue block32;
                    }
                    case '{': {
                        if (lastKey == null) {
                            lastKey = blocks.size() == 0 ? "root" : blocks.peek();
                        }
                        blocks.push(lastKey);
                        callback.startBlock(lastKey);
                        lastKey = null;
                        continue block32;
                    }
                    case '}': {
                        String ct;
                        if (currentToken.length() > 0) {
                            try {
                                ct = currentToken.toString();
                                if (JSONParser.useLongs(callback)) {
                                    if (ct.indexOf(46) > -1) {
                                        callback.numericToken(Double.parseDouble(ct));
                                    } else {
                                        callback.longToken(Long.parseLong(ct));
                                    }
                                } else {
                                    callback.numericToken(Double.parseDouble(ct));
                                }
                                if (lastKey != null) {
                                    callback.keyValue(lastKey, currentToken.toString());
                                    lastKey = null;
                                    currentToken.setLength(0);
                                }
                            }
                            catch (NumberFormatException err) {
                                Log.e(err);
                            }
                        }
                        currentBlock = blocks.pop();
                        callback.endBlock(currentBlock);
                        lastKey = null;
                        continue block32;
                    }
                    case '[': {
                        blocks.push(lastKey);
                        callback.startArray(lastKey);
                        lastKey = null;
                        continue block32;
                    }
                    case ']': {
                        String ct;
                        if (currentToken.length() > 0) {
                            try {
                                ct = currentToken.toString();
                                if (JSONParser.useLongs(callback)) {
                                    if (ct.indexOf(46) > -1) {
                                        callback.numericToken(Double.parseDouble(ct));
                                    } else {
                                        callback.longToken(Long.parseLong(ct));
                                    }
                                } else {
                                    callback.numericToken(Double.parseDouble(ct));
                                }
                                if (lastKey != null) {
                                    callback.keyValue(lastKey, currentToken.toString());
                                    lastKey = null;
                                }
                            }
                            catch (NumberFormatException ct2) {
                                // empty catch block
                            }
                        }
                        currentToken.setLength(0);
                        currentBlock = blocks.pop();
                        callback.endArray(currentBlock);
                        lastKey = null;
                        continue block32;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block32;
                    }
                    case '\"': {
                        quoteMode = true;
                        continue block32;
                    }
                    case ',': 
                    case ':': {
                        String ct;
                        if (currentToken.length() > 0) {
                            try {
                                ct = currentToken.toString();
                                if (JSONParser.useLongs(callback)) {
                                    if (ct.indexOf(46) > -1) {
                                        callback.numericToken(Double.parseDouble(ct));
                                    } else {
                                        callback.longToken(Long.parseLong(ct));
                                    }
                                } else {
                                    callback.numericToken(Double.parseDouble(ct));
                                }
                                if (lastKey != null) {
                                    callback.keyValue(lastKey, currentToken.toString());
                                    lastKey = null;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        currentToken.setLength(0);
                        continue block32;
                    }
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'E': 
                    case 'd': 
                    case 'e': 
                    case 'l': 
                    case 'x': {
                        currentToken.append(c);
                        continue block32;
                    }
                }
            }
        }
        catch (Exception err) {
            Log.e(err);
            Log.p("Exception during JSON parsing at row: " + row + " column: " + column + " buffer: " + currentToken.toString());
            i.close();
        }
    }

    public Map<String, Object> parseJSON(Reader i) throws IOException {
        this.modern = true;
        this.state = new LinkedHashMap<String, Object>();
        this.parseStack = new ArrayList<Object>();
        this.currentKey = null;
        if (!this.strict) {
            i = new CharArrayReader(JSONSanitizer.sanitize(Util.readToString(i)).toCharArray());
        }
        JSONParser.parse(i, this);
        return this.state;
    }

    public Hashtable<String, Object> parse(Reader i) throws IOException {
        this.modern = false;
        this.state = new Hashtable<String, Object>();
        this.parseStack = new Vector<Object>();
        this.currentKey = null;
        if (!this.strict) {
            String cleaned = JSONSanitizer.sanitize(Util.readToString(i));
            i = new CharArrayReader(cleaned.toCharArray());
        }
        JSONParser.parse(i, this);
        return (Hashtable)this.state;
    }

    private boolean isStackHash() {
        return this.parseStack.size() > 0 && this.parseStack.get(this.parseStack.size() - 1) instanceof Map;
    }

    private Map getStackHash() {
        return (Map)this.parseStack.get(this.parseStack.size() - 1);
    }

    private List<Object> getStackVec() {
        return (List)this.parseStack.get(this.parseStack.size() - 1);
    }

    @Override
    public void startBlock(String blockName) {
        if (this.parseStack.size() == 0) {
            this.parseStack.add(this.state);
        } else {
            Map newOne = this.modern ? new LinkedHashMap() : new Hashtable();
            if (this.isStackHash()) {
                this.getStackHash().put(this.currentKey, newOne);
                this.currentKey = null;
            } else {
                this.getStackVec().add(newOne);
            }
            this.parseStack.add(newOne);
        }
    }

    @Override
    public void endBlock(String blockName) {
        this.parseStack.remove(this.parseStack.size() - 1);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    @Override
    public void startArray(String arrayName) {
        AbstractList currentVector = this.modern ? new ArrayList() : new Vector();
        if (this.parseStack.size() == 0) {
            this.parseStack.add(this.state);
            this.currentKey = "root";
        }
        if (this.isStackHash()) {
            this.getStackHash().put(this.currentKey, currentVector);
            this.currentKey = null;
        } else {
            this.getStackVec().add(currentVector);
        }
        this.parseStack.add(currentVector);
    }

    @Override
    public void endArray(String arrayName) {
        this.parseStack.remove(this.parseStack.size() - 1);
    }

    @Override
    public void stringToken(String tok) {
        if (this.isStackHash()) {
            if (this.currentKey == null) {
                this.currentKey = tok;
            } else {
                if (tok != null || this.isIncludeNullsInstance()) {
                    this.getStackHash().put(this.currentKey, tok);
                }
                this.currentKey = null;
            }
        } else {
            this.getStackVec().add(tok);
        }
    }

    @Override
    public void numericToken(double tok) {
        if (this.isStackHash()) {
            this.getStackHash().put(this.currentKey, new Double(tok));
            this.currentKey = null;
        } else {
            this.getStackVec().add(new Double(tok));
        }
    }

    @Override
    public void longToken(long tok) {
        if (this.isStackHash()) {
            this.getStackHash().put(this.currentKey, new Long(tok));
            this.currentKey = null;
        } else {
            this.getStackVec().add(new Long(tok));
        }
    }

    @Override
    public void booleanToken(boolean tok) {
        if (this.isStackHash()) {
            this.getStackHash().put(this.currentKey, tok);
            this.currentKey = null;
        } else {
            this.getStackVec().add(tok);
        }
    }

    @Override
    public void keyValue(String key, String value) {
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    public static String mapToJson(Map<String, ?> map) {
        return Result.fromContent(map).toString();
    }

    static class KeyStack
    extends Vector {
        KeyStack() {
        }

        protected String peek() {
            return (String)this.elementAt(0);
        }

        protected void push(String key) {
            this.insertElementAt(key, 0);
        }

        protected String pop() {
            if (this.isEmpty()) {
                return null;
            }
            String key = this.peek();
            this.removeElementAt(0);
            return key;
        }
    }

    static class ReaderClass {
        char[] buffer;
        int buffOffset;
        int buffSize = -1;

        ReaderClass() {
        }

        int read(Reader is) throws IOException {
            int c = -1;
            if (this.buffer == null) {
                this.buffer = new char[8192];
            }
            if (this.buffSize < 0 || this.buffOffset >= this.buffSize) {
                this.buffSize = is.read(this.buffer, 0, this.buffer.length);
                if (this.buffSize < 0) {
                    return -1;
                }
                this.buffOffset = 0;
            }
            c = this.buffer[this.buffOffset];
            ++this.buffOffset;
            return c;
        }
    }
}

