/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.properties;

import com.codename1.properties.PropertyBase;
import com.codename1.properties.PropertyBusinessObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapProperty<T1, T2, K>
extends PropertyBase<Map.Entry<T1, T2>, K>
implements Iterable<Map.Entry<T1, T2>> {
    private LinkedHashMap<T1, T2> value = new LinkedHashMap();
    private Class keyType;
    private Class valueType;

    public MapProperty(String name) {
        super(name);
    }

    public MapProperty(String name, Class genericTypeKey, Class genericTypeValue) {
        super(name);
        this.validateCollectionType(genericTypeKey);
        this.validateCollectionType(genericTypeValue);
        this.keyType = genericTypeKey;
        this.valueType = genericTypeValue;
    }

    public Class getKeyType() {
        return this.keyType;
    }

    public Class getValueType() {
        return this.valueType;
    }

    public T2 get(T1 key) {
        this.internalGet();
        return this.value.get(key);
    }

    public int size() {
        this.internalGet();
        return this.value.size();
    }

    public K set(T1 key, T2 v) {
        this.value.put(key, v);
        this.firePropertyChanged();
        this.internalSet();
        return (K)this.parent.parent;
    }

    public K put(T1 key, T2 v) {
        return this.set(key, v);
    }

    public K remove(T1 key) {
        this.value.remove(key);
        this.internalSet();
        return (K)this.parent.parent;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        MapProperty other = (MapProperty)obj;
        return other.value.equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public Iterator<Map.Entry<T1, T2>> iterator() {
        this.internalGet();
        return this.value.entrySet().iterator();
    }

    public Set<T1> keySet() {
        return this.value.keySet();
    }

    public Collection<T2> valueSet() {
        return this.value.values();
    }

    public Map<T1, T2> asMap() {
        this.internalGet();
        return new LinkedHashMap<T1, T2>(this.value);
    }

    public Map<T1, Object> asExplodedMap() {
        LinkedHashMap<T1, Map<String, Object>> m = new LinkedHashMap<T1, Map<String, Object>>();
        for (T1 k : this.value.keySet()) {
            T2 v = this.value.get(k);
            if (v instanceof PropertyBusinessObject) {
                m.put(k, ((PropertyBusinessObject)v).getPropertyIndex().toMapRepresentation());
                continue;
            }
            m.put(k, (Map<String, Object>)v);
        }
        this.internalGet();
        return m;
    }

    public K setMap(Map<T1, T2> t) {
        this.value.clear();
        this.value.putAll(t);
        this.firePropertyChanged();
        this.internalSet();
        return (K)this.parent.parent;
    }

    public void clear() {
        this.internalSet();
        this.value.clear();
    }
}

