/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.impl.CodenameOneImplementation;
import com.codename1.ui.CN;
import com.codename1.ui.CustomFont;
import com.codename1.ui.Display;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import java.util.HashMap;
import java.util.Hashtable;

public class Font
extends CN {
    private static Font defaultFont = new Font(null);
    private static Hashtable bitmapCache = new Hashtable();
    private static boolean enableBitmapFont = true;
    private Object font;
    private boolean ttf;
    private float pixelSize = -1.0f;
    private String fontUniqueId;
    private static HashMap<String, Font> derivedFontCache = new HashMap();
    private static float fontReturnedHeight;

    Font() {
    }

    Font(Object nativeFont) {
        this.font = nativeFont;
    }

    Font(int face, int style, int size) {
        Display d = Display.getInstance();
        CodenameOneImplementation i = d.getImplementation();
        this.font = i.createFont(face, style, size);
    }

    public static Font getBitmapFont(String fontName) {
        return (Font)bitmapCache.get(fontName);
    }

    public static void clearBitmapCache() {
        bitmapCache.clear();
    }

    public static boolean isTrueTypeFileSupported() {
        return Display.impl.isTrueTypeSupported();
    }

    public static boolean isCreationByStringSupported() {
        return Display.impl.isLookupFontSupported();
    }

    public static boolean isNativeFontSchemeSupported() {
        return Display.impl.isNativeFontSchemeSupported();
    }

    public static Font createTrueTypeFont(String fontName) {
        if (Display.getInstance().isSimulator() && !fontName.startsWith("native:")) {
            throw new IllegalArgumentException("Only native: fonts are supported by this method. To load a TTF use createTrueTypeFont(String, String)");
        }
        return Font.createTrueTypeFont(fontName, fontName);
    }

    public static Font createTrueTypeFont(String fontName, float sizeMm) {
        return Font.createTrueTypeFont(fontName, fontName).derive(Display.getInstance().convertToPixels(sizeMm), 0);
    }

    public static Font createTrueTypeFont(String fontName, float size, byte sizeUnit) {
        return Font.createTrueTypeFont(fontName, fontName).derive(Display.getInstance().convertToPixels(size, sizeUnit), 0);
    }

    public static Font createTrueTypeFont(String fontName, String fileName) {
        float h;
        Object font;
        String alreadyLoaded = fileName + "_" + fontReturnedHeight + "_" + 0;
        Font f = derivedFontCache.get(alreadyLoaded);
        if (f != null) {
            return f;
        }
        if (fontName.startsWith("native:")) {
            if (!Display.impl.isNativeFontSchemeSupported()) {
                return null;
            }
        } else if (!(fileName == null || fileName.indexOf(47) <= -1 && fileName.indexOf(92) <= -1 && fileName.endsWith(".ttf"))) {
            throw new IllegalArgumentException("The font file name must be relative to the root and end with ttf: " + fileName);
        }
        if ((font = Display.impl.loadTrueTypeFont(fontName, fileName)) == null) {
            return null;
        }
        f = new Font(font);
        f.ttf = true;
        f.fontUniqueId = fontName;
        fontReturnedHeight = h = (float)f.getHeight();
        derivedFontCache.put(fileName + "_" + h + "_" + 0, f);
        return f;
    }

    public Font derive(float size, int weight, byte unitType) {
        return this.derive(Display.getInstance().convertToPixels(size, unitType), weight);
    }

    public Font derive(float sizePixels, int weight) {
        if (this.fontUniqueId != null) {
            String key = this.fontUniqueId + "_" + sizePixels + "_" + weight;
            Font f = derivedFontCache.get(key);
            if (f != null) {
                return f;
            }
            f = new Font(Display.impl.deriveTrueTypeFont(this.font, sizePixels, weight));
            f.pixelSize = sizePixels;
            f.ttf = true;
            derivedFontCache.put(key, f);
            return f;
        }
        Font f = new Font(Display.impl.deriveTrueTypeFont(this.font, sizePixels, weight));
        f.pixelSize = sizePixels;
        f.ttf = true;
        return f;
    }

    public boolean isTTFNativeFont() {
        return this.ttf;
    }

    public static Font create(String lookup) {
        if (lookup.startsWith("native:")) {
            return Font.createTrueTypeFont(lookup, lookup);
        }
        Object n = Display.impl.loadNativeFont(lookup);
        if (n == null) {
            return null;
        }
        return new Font(n);
    }

    public void addContrast(byte value) {
    }

    public static Font createBitmapFont(String name, Image bitmap, int[] cutOffsets, int[] charWidth, String charsets) {
        Font f = Font.createBitmapFont(bitmap, cutOffsets, charWidth, charsets);
        bitmapCache.put(name, f);
        return f;
    }

    public static Font createBitmapFont(Image bitmap, int[] cutOffsets, int[] charWidth, String charsets) {
        return new CustomFont(bitmap, cutOffsets, charWidth, charsets);
    }

    public static Font createSystemFont(int face, int style, int size) {
        return new Font(face, style, size);
    }

    public int charsWidth(char[] ch, int offset, int length) {
        return Display.impl.charsWidth(this.font, ch, offset, length);
    }

    public int substringWidth(String str, int offset, int len) {
        return Display.impl.stringWidth(this.font, str.substring(offset, offset + len));
    }

    public int stringWidth(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        if (str == " ") {
            return 5;
        }
        return Display.impl.stringWidth(this.font, str);
    }

    public int charWidth(char ch) {
        return Display.impl.charWidth(this.font, ch);
    }

    public int getHeight() {
        return Display.impl.getHeight(this.font);
    }

    void drawChar(Graphics g, char character, int x, int y) {
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public static void setDefaultFont(Font f) {
        if (f != null) {
            defaultFont = f;
        }
    }

    void drawString(Graphics g, String str, int x, int y) {
    }

    void drawChars(Graphics g, char[] data, int offset, int length, int x, int y) {
    }

    public int getFace() {
        return Display.impl.getFace(this.font);
    }

    public int getSize() {
        return Display.impl.getSize(this.font);
    }

    public int getStyle() {
        return Display.impl.getStyle(this.font);
    }

    public String getCharset() {
        return null;
    }

    public static void setBitmapFontEnabled(boolean enabled) {
        enableBitmapFont = enabled;
    }

    public static boolean isBitmapFontEnabled() {
        return enableBitmapFont;
    }

    public Object getNativeFont() {
        return this.font;
    }

    public boolean equals(Object o) {
        if (this.ttf && o != null) {
            return ((Font)o).font != null && ((Font)o).ttf && ((Font)o).font.equals(this.font);
        }
        if (o != null && o.getClass() == this.getClass()) {
            Font f = (Font)o;
            return !f.ttf && f.getFace() == this.getFace() && f.getSize() == this.getSize() && f.getStyle() == this.getStyle();
        }
        return false;
    }

    public int getAscent() {
        return Display.impl.getFontAscent(this.font);
    }

    public int getDescent() {
        return Display.impl.getFontDescent(this.font);
    }

    public float getPixelSize() {
        return this.pixelSize;
    }
}

