/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.list;

import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.events.SelectionListener;
import com.codename1.ui.list.MultipleSelectionListModel;
import com.codename1.ui.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListModel<T>
implements MultipleSelectionListModel<T> {
    private boolean multiSelectionMode;
    private List items;
    private EventDispatcher dataListener = new EventDispatcher();
    private EventDispatcher selectionListener = new EventDispatcher();
    private int selectedIndex = 0;
    private Set<Integer> selectedIndices;
    private boolean firstSetSelectedIndex = true;

    public DefaultListModel() {
        this.items = new ArrayList();
    }

    public DefaultListModel(Vector<T> items) {
        this.items = new ArrayList<T>(items);
    }

    public DefaultListModel(Collection<T> items) {
        this.items = new ArrayList<T>(items);
    }

    public DefaultListModel(T ... items) {
        this.items = DefaultListModel.createList(items);
    }

    private static List createList(Object[] items) {
        if (items == null) {
            items = new Object[]{};
        }
        ArrayList<Object> vec = new ArrayList<Object>(items.length);
        int ilen = items.length;
        for (int iter = 0; iter < ilen; ++iter) {
            vec.add(items[iter]);
        }
        return vec;
    }

    @Override
    public T getItemAt(int index) {
        if (index < this.getSize() && index >= 0) {
            return (T)this.items.get(index);
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    @Override
    public int getSelectedIndex() {
        if (this.isMultiSelectionMode()) {
            int[] selected = this.getSelectedIndices();
            if (selected.length == 0) {
                return -1;
            }
            return selected[0];
        }
        return this.selectedIndex;
    }

    @Override
    public void addItem(T item) {
        this.items.add(item);
        this.fireDataChangedEvent(1, this.items.size() - 1);
    }

    public void setItem(int index, T item) {
        this.items.set(index, item);
        this.fireDataChangedEvent(2, index);
    }

    public void addItemAtIndex(T item, int index) {
        if (index <= this.items.size()) {
            this.items.add(index, item);
            this.fireDataChangedEvent(1, index);
        }
    }

    @Override
    public void removeItem(int index) {
        if (index < this.getSize() && index >= 0) {
            this.items.remove(index);
            if (index != 0) {
                this.setSelectedIndex(index - 1);
            }
            this.fireDataChangedEvent(0, index);
        }
    }

    public void removeAll() {
        while (this.getSize() > 0) {
            this.removeItem(0);
        }
    }

    @Override
    public void setSelectedIndex(int index) {
        if (this.isMultiSelectionMode()) {
            this.setSelectedIndices(index);
        } else if (index != this.selectedIndex || this.firstSetSelectedIndex) {
            this.firstSetSelectedIndex = false;
            int oldIndex = this.selectedIndex;
            this.selectedIndex = index;
            this.selectionListener.fireSelectionEvent(oldIndex, this.selectedIndex);
        }
    }

    @Override
    public void addDataChangedListener(DataChangedListener l) {
        this.dataListener.addListener(l);
    }

    @Override
    public void removeDataChangedListener(DataChangedListener l) {
        this.dataListener.removeListener(l);
    }

    protected void fireDataChangedEvent(int status, int index) {
        this.dataListener.fireDataChangeEvent(index, status);
    }

    @Override
    public void addSelectionListener(SelectionListener l) {
        this.selectionListener.addListener(l);
    }

    @Override
    public void removeSelectionListener(SelectionListener l) {
        this.selectionListener.removeListener(l);
    }

    public List<T> getList() {
        return this.items;
    }

    private List<Integer> toList(int[] ints) {
        int len = ints.length;
        ArrayList<Integer> out = new ArrayList<Integer>(len);
        for (int i = 0; i < len; ++i) {
            out.add(ints[i]);
        }
        return out;
    }

    @Override
    public void setSelectedIndices(int ... indices) {
        if (this.isMultiSelectionMode()) {
            if (this.selectedIndices == null) {
                this.selectedIndices = new HashSet<Integer>();
            }
            HashSet<Integer> newSelections = new HashSet<Integer>(this.toList(indices));
            if (this.selectedIndices.size() != indices.length || !this.selectedIndices.containsAll(newSelections)) {
                HashSet<Integer> toRemove = new HashSet<Integer>(this.selectedIndices);
                toRemove.removeAll(newSelections);
                HashSet<Integer> toAdd = new HashSet<Integer>(newSelections);
                toAdd.removeAll(this.selectedIndices);
                this.selectedIndices.clear();
                this.selectedIndices.addAll(newSelections);
                for (Integer i : toRemove) {
                    this.selectionListener.fireSelectionEvent(i, -1);
                }
                for (Integer i : toAdd) {
                    this.selectionListener.fireSelectionEvent(-1, i);
                }
            }
        } else if (indices.length == 1) {
            this.setSelectedIndex(indices[0]);
        } else if (indices.length == 0) {
            this.setSelectedIndex(-1);
        } else {
            throw new IllegalArgumentException("setSelectedIndices can only include 0 or 1 index in multiselection mode, but received " + indices.length);
        }
    }

    @Override
    public void addSelectedIndices(int ... indices) {
        if (this.isMultiSelectionMode()) {
            if (this.selectedIndices == null) {
                this.selectedIndices = new HashSet<Integer>();
            }
            for (int index : indices) {
                if (this.selectedIndices.contains(index)) continue;
                this.selectedIndices.add(index);
                this.selectionListener.fireSelectionEvent(-1, index);
            }
        } else {
            throw new IllegalArgumentException("addSelectedIndices only supported if isMultiSelectionMode() is on");
        }
    }

    @Override
    public void removeSelectedIndices(int ... indices) {
        if (this.isMultiSelectionMode()) {
            if (this.selectedIndices == null) {
                return;
            }
            for (int index : indices) {
                if (!this.selectedIndices.contains(index)) continue;
                this.selectedIndices.remove(index);
                this.selectionListener.fireSelectionEvent(index, -1);
            }
        } else {
            throw new IllegalArgumentException("removeSelectedIndices only supported if isMultiSelectionMode() is on");
        }
    }

    @Override
    public int[] getSelectedIndices() {
        if (this.isMultiSelectionMode()) {
            if (this.selectedIndices == null) {
                return new int[0];
            }
            int[] out = new int[this.selectedIndices.size()];
            int index = 0;
            for (Integer i : this.selectedIndices) {
                out[index++] = i;
            }
            Arrays.sort(out);
            return out;
        }
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex >= 0) {
            return new int[]{selectedIndex};
        }
        return new int[0];
    }

    public boolean isMultiSelectionMode() {
        return this.multiSelectionMode;
    }

    public void setMultiSelectionMode(boolean multiSelectionMode) {
        this.multiSelectionMode = multiSelectionMode;
    }
}

