/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.spinner;

import com.codename1.ui.CN;
import com.codename1.ui.Container;
import com.codename1.ui.Graphics;
import com.codename1.ui.Label;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.spinner.InternalPickerWidget;
import com.codename1.ui.spinner.Spinner3D;
import com.codename1.ui.spinner.SpinnerDateModel;
import com.codename1.ui.spinner.TimeSpinner3D;
import java.util.Calendar;
import java.util.Date;

class DateTimeSpinner3D
extends Container
implements InternalPickerWidget {
    private Spinner3D date;
    private TimeSpinner3D time;
    private Date today;
    private Date currentDate;
    private Date startDate;
    private Date endDate;
    private boolean markToday;
    private boolean includeYear;
    private int off;
    private Container wrapper;

    public DateTimeSpinner3D() {
        this.currentDate = this.today = new Date();
        this.startDate = new Date(0L);
        this.endDate = new Date(System.currentTimeMillis() + 864000000000L);
        this.markToday = true;
        this.wrapper = new Container(BoxLayout.x());
        this.off = 0;
        this.initSpinner();
    }

    void initSpinner() {
        if (this.date == null) {
            this.date = Spinner3D.createDate(this.startDate.getTime() + (long)this.off, this.endDate.getTime() + (long)this.off, this.currentDate.getTime());
            this.date.setPreferredW((int)((float)new Label("Thu Dec 27", "Spinner3DRow").getPreferredW() * 1.5f));
            Style dateStyle = Style.createProxyStyle(this.date.getRowStyle(), this.date.getSelectedRowStyle());
            dateStyle.setAlignment(3);
            dateStyle.setPaddingRight(3.0f);
            this.setCurrentDate(this.currentDate);
            this.setStartDate(this.startDate);
            this.setEndDate(this.endDate);
            this.time = new TimeSpinner3D();
            this.addComponents();
        }
    }

    protected Dimension calcPreferredSize() {
        Dimension size = super.calcPreferredSize();
        Label l = new Label("Thu Dec 27    55  55  AM", "Spinner3DRow");
        size.setWidth((int)((float)l.getPreferredW() * 1.5f + (float)CN.convertToPixels(10.0f)));
        return size;
    }

    void addComponents() {
        if (this.date != null) {
            this.setLayout(new BorderLayout(2));
            this.add((Object)"Center", this.wrapper);
            this.wrapper.addComponent(this.date);
            this.wrapper.addComponent(this.time);
        }
    }

    public Date getCurrentDate() {
        if (this.date != null) {
            Date dt = (Date)this.date.getValue();
            Calendar cld = Calendar.getInstance();
            cld.setTime(dt);
            cld.set(11, 0);
            cld.set(12, 0);
            cld.set(13, 0);
            cld.set(14, 0);
            Integer minutesInDay = (Integer)this.time.getValue();
            if (minutesInDay == null) {
                minutesInDay = 0;
            }
            cld.setTime(new Date(cld.getTime().getTime() + (long)minutesInDay.intValue() * 60L * 1000L));
            return cld.getTime();
        }
        return this.currentDate;
    }

    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
        if (this.date != null) {
            this.date.setValue(currentDate);
        }
        if (this.time != null) {
            Calendar cld = Calendar.getInstance();
            cld.setTime(currentDate);
            Calendar zero = Calendar.getInstance();
            zero.setTime(currentDate);
            zero.set(11, 0);
            zero.set(12, 0);
            zero.set(13, 0);
            zero.set(14, 0);
            int minutesInDay = (int)((cld.getTime().getTime() - zero.getTime().getTime()) / 60L / 1000L);
            this.time.setValue(minutesInDay);
        }
    }

    public Date getStartDate() {
        return this.startDate;
    }

    private void rebuildDate() {
        if (this.date != null) {
            long currTime = Math.max(this.startDate.getTime() + (long)this.off, Math.min(this.endDate.getTime() + (long)this.off, this.currentDate.getTime() + (long)this.off));
            this.date.setModel(new SpinnerDateModel(this.startDate.getTime() + (long)this.off, this.endDate.getTime() + (long)this.off, currTime));
        }
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
        this.rebuildDate();
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
        this.rebuildDate();
    }

    public boolean isMarkToday() {
        return this.markToday;
    }

    public void setMarkToday(boolean markToday) {
        this.markToday = markToday;
        if (this.date != null) {
            // empty if block
        }
    }

    public boolean isIncludeYear() {
        return this.includeYear;
    }

    public void setIncludeYear(boolean includeYear) {
        this.includeYear = includeYear;
        if (this.date == null || includeYear) {
            // empty if block
        }
    }

    public void setShowMeridiem(boolean showMeridiem) {
        if (this.time == null) {
            return;
        }
        this.time.setShowMeridiem(showMeridiem);
    }

    public boolean isShowMeridiem() {
        if (this.time == null) {
            return false;
        }
        return this.time.isShowMeridiem();
    }

    public void setHourRange(int min, int max) {
        if (this.time == null) {
            return;
        }
        if (min >= 0 && max > min && this.isShowMeridiem()) {
            this.time.setShowMeridiem(false);
        }
        this.time.setHourRange(min, max);
    }

    public int getMinHour() {
        if (this.time == null) {
            return -1;
        }
        return this.time.getMinHour();
    }

    public int getMaxHour() {
        if (this.time == null) {
            return -1;
        }
        return this.time.getMaxHour();
    }

    public String[] getPropertyNames() {
        return new String[]{"currentHour", "currentMinute", "minuteStep", "currentMeridiem", "showMeridiem", "currentDate", "startDate", "endDate", "markToday", "includeYear"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{Integer.class, Integer.class, Integer.class, Boolean.class, Boolean.class, Date.class, Date.class, Date.class, Boolean.class, Boolean.class};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("currentDate")) {
            return this.currentDate;
        }
        if (name.equals("startDate")) {
            return this.startDate;
        }
        if (name.equals("endDate")) {
            return this.endDate;
        }
        if (name.equals("markToday")) {
            return new Boolean(this.markToday);
        }
        if (name.equals("includeYear")) {
            return new Boolean(this.includeYear);
        }
        return super.getPropertyValue(name);
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("currentDate")) {
            this.setCurrentDate((Date)value);
            return null;
        }
        if (name.equals("startDate")) {
            this.setStartDate((Date)value);
            return null;
        }
        if (name.equals("endDate")) {
            this.setEndDate((Date)value);
            return null;
        }
        if (name.equals("markToday")) {
            this.setMarkToday((Boolean)value);
            return null;
        }
        if (name.equals("includeYear")) {
            this.setIncludeYear((Boolean)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public Object getValue() {
        return this.getCurrentDate();
    }

    public void setValue(Object value) {
        this.setCurrentDate((Date)value);
    }

    public void paint(Graphics g) {
        int alpha = g.getAlpha();
        g.setColor(this.date.getSelectedOverlayStyle().getBgColor());
        g.setAlpha(255);
        g.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        g.setAlpha(alpha);
        super.paint(g);
    }
}

