/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.util;

import com.codename1.ui.Component;
import com.codename1.ui.Display;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.RGBImage;
import com.codename1.ui.animations.Motion;

public class Effects {
    private Effects() {
    }

    public static Image reflectionImage(Image source) {
        return Effects.reflectionImage(source, 0.5f, 120);
    }

    public static Image reflectionImage(Image source, float mirrorRatio, int alphaRatio) {
        return Effects.reflectionImage(source, mirrorRatio, alphaRatio, 0);
    }

    public static Image reflectionImage(Image source, float mirrorRatio, int alphaRatio, int spacing) {
        int w = source.getWidth();
        int h = source.getHeight();
        int mirrorHeight = (int)((float)h * mirrorRatio) * w;
        RGBImage rgbImg = new RGBImage(new int[w * (h + spacing) + mirrorHeight], w, h + ((int)((float)h * mirrorRatio) + spacing));
        source.toRGB(rgbImg, 0, 0, 0, 0, w, h);
        int[] imageData = rgbImg.getRGB();
        int ilen = imageData.length;
        for (int iter = 0; iter < mirrorHeight; ++iter) {
            int sourcePos = w * h - iter - 1;
            int off = iter % w;
            off = w - off + iter - off;
            int mirrorPos = ilen - (mirrorHeight - off) + spacing * w;
            int color = imageData[sourcePos];
            if ((color & 0xFF000000) == 0 || mirrorPos >= ilen) continue;
            int alpha = (int)((float)alphaRatio * ((float)mirrorHeight - (float)iter) / (float)mirrorHeight);
            imageData[mirrorPos] = imageData[sourcePos] & 0xFFFFFF | alpha << 24 & 0xFF000000;
        }
        return rgbImg;
    }

    public static void growShrink(Component c, int duration) {
        c.growShrink(duration);
    }

    public static Image verticalPerspective(Image i, float topScaleRatio, float bottomScaleRatio, float verticalShrink) {
        float positionY;
        float diff;
        int[] imageData = i.getRGB();
        int sourceWidth = i.getWidth();
        int sourceHeight = i.getHeight();
        int destinationWidth = (int)(Math.max(topScaleRatio, bottomScaleRatio) * (float)sourceWidth);
        int destinationHeight = (int)(verticalShrink * (float)sourceHeight);
        int[] destinationArray = new int[destinationWidth * destinationHeight];
        if (bottomScaleRatio < topScaleRatio) {
            float smaller = bottomScaleRatio;
            float larger = topScaleRatio;
            diff = smaller - larger;
        } else {
            float larger = bottomScaleRatio;
            float smaller = topScaleRatio;
            diff = larger - smaller;
        }
        if (destinationWidth > sourceWidth) {
            for (int y = 0; y < destinationHeight; ++y) {
                positionY = (float)y / ((float)destinationHeight - 1.0f);
                int sourceY = (int)((float)(sourceHeight - 1) * positionY);
                float currentRowRatio = (topScaleRatio + diff * positionY) / bottomScaleRatio;
                int minX = (int)((float)destinationWidth * (1.0f - currentRowRatio));
                int maxX = destinationWidth - minX;
                float distance = maxX - minX;
                for (int x = minX; x < maxX; ++x) {
                    int sourceX = (int)((float)sourceWidth * (((float)x - (float)minX) / distance));
                    destinationArray[x + y * destinationWidth] = imageData[sourceY * sourceWidth + sourceX];
                }
            }
        } else {
            for (int y = 0; y < destinationHeight; ++y) {
                positionY = (float)y / (float)destinationHeight;
                int sourceY = (int)((float)sourceHeight * positionY);
                float currentRowRatio = topScaleRatio + diff * positionY;
                int minX = (int)((float)destinationWidth * (1.0f - currentRowRatio));
                int maxX = destinationWidth - minX;
                float distance = maxX - minX;
                for (int x = minX; x < maxX; ++x) {
                    int sourceX = (int)((float)sourceWidth * (((float)x - (float)minX) / distance));
                    destinationArray[x + y * destinationWidth] = imageData[sourceY * sourceWidth + sourceX];
                }
            }
        }
        return Image.createImage(destinationArray, destinationWidth, destinationHeight);
    }

    public static Image gaussianBlurImage(Image image, float radius) {
        return Display.getInstance().gaussianBlurImage(image, radius);
    }

    public static boolean isGaussianBlurSupported() {
        return Display.getInstance().isGaussianBlurSupported();
    }

    public static Image dropshadow(Image source, int blurRadius, float opacity, int xDistance, int yDistance) {
        Image s = Effects.dropshadow(source, blurRadius, opacity);
        Image n = Image.createImage(source.getWidth() + Math.abs(xDistance), source.getHeight() + Math.abs(yDistance), 0);
        Graphics g = n.getGraphics();
        int shadowX = 0;
        int imageX = 0;
        int shadowY = 0;
        int imageY = 0;
        if (xDistance < 0) {
            imageX = xDistance * -1;
        } else {
            shadowX = xDistance;
        }
        if (yDistance < 0) {
            imageY = yDistance * -1;
        } else {
            shadowY = yDistance;
        }
        g.drawImage(s, shadowX, shadowY);
        g.drawImage(source, imageX, imageY);
        return n;
    }

    public static Image dropshadow(Image source, int blurRadius, float opacity) {
        int[] rgb = source.getRGB();
        for (int iter = 0; iter < rgb.length; ++iter) {
            float f = rgb[iter] & 0xFF000000;
            rgb[iter] = (int)(f *= opacity);
        }
        Image shadow = Image.createImage(rgb, source.getWidth(), source.getHeight());
        if (Display.getInstance().isGaussianBlurSupported()) {
            shadow = Display.getInstance().gaussianBlurImage(shadow, blurRadius);
        }
        return shadow;
    }

    public static Image squareShadow(int width, int height, int blurRadius, float opacity) {
        Image img = Image.createImage(width + blurRadius * 2, height + blurRadius * 2, 0);
        Graphics g = img.getGraphics();
        int destAlpha = (int)((double)opacity * 255.0);
        g.setColor(0);
        if (Display.getInstance().isGaussianBlurSupported()) {
            g.setAlpha(Math.min(destAlpha * 2, 255));
            g.fillRect(blurRadius - 1, blurRadius - 1, width + 2, height + 2);
            img = Display.getInstance().gaussianBlurImage(img, blurRadius);
        } else {
            Motion lin = Motion.createLinearMotion(0, destAlpha, blurRadius);
            for (int iter = blurRadius - 1; iter >= 0; --iter) {
                lin.setCurrentMotionTime(iter);
                g.setAlpha(Math.max(0, (int)((float)(lin.getValue() * iter) / ((float)blurRadius - 1.0f))));
                g.drawRect(iter, iter, width + (blurRadius - iter) * 2, height + (blurRadius - iter) * 2);
            }
        }
        return img;
    }
}

