/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.impl.CodenameOneImplementation;
import com.codename1.ui.CustomFont;
import com.codename1.ui.Display;
import com.codename1.ui.Font;
import com.codename1.ui.Image;
import com.codename1.ui.Paint;
import com.codename1.ui.PeerComponent;
import com.codename1.ui.Stroke;
import com.codename1.ui.Transform;
import com.codename1.ui.geom.GeneralPath;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.geom.Shape;

public final class Graphics {
    boolean paintPeersBehind;
    private int xTranslate;
    private int yTranslate;
    private Transform translation;
    private GeneralPath tmpClipShape;
    private int color;
    private Paint paint;
    private Font current = Font.getDefaultFont();
    private CodenameOneImplementation impl;
    private Object nativeGraphics;
    private Object[] nativeGraphicsState;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    public static final int RENDERING_HINT_FAST = 1;

    Graphics(Object nativeGraphics) {
        this.setGraphics(nativeGraphics);
        this.impl = Display.impl;
    }

    protected void finalize() {
        if (this.nativeGraphics != null) {
            this.impl.disposeGraphics(this.nativeGraphics);
        }
    }

    private Transform translation() {
        if (this.translation == null) {
            this.translation = Transform.makeTranslation(this.xTranslate, this.yTranslate);
        } else {
            this.translation.setTranslation(this.xTranslate, this.yTranslate);
        }
        return this.translation;
    }

    private GeneralPath tmpClipShape() {
        if (this.tmpClipShape == null) {
            this.tmpClipShape = new GeneralPath();
        }
        return this.tmpClipShape;
    }

    void setGraphics(Object g) {
        this.nativeGraphics = g;
    }

    Object getGraphics() {
        return this.nativeGraphics;
    }

    public void translate(int x, int y) {
        if (this.impl.isTranslationSupported()) {
            this.impl.translate(this.nativeGraphics, x, y);
        } else {
            this.xTranslate += x;
            this.yTranslate += y;
        }
    }

    public int getTranslateX() {
        if (this.impl.isTranslationSupported()) {
            return this.impl.getTranslateX(this.nativeGraphics);
        }
        return this.xTranslate;
    }

    public int getTranslateY() {
        if (this.impl.isTranslationSupported()) {
            return this.impl.getTranslateY(this.nativeGraphics);
        }
        return this.yTranslate;
    }

    public int getColor() {
        return this.color;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setColor(int RGB) {
        this.paint = null;
        this.color = 0xFFFFFF & RGB;
        this.impl.setColor(this.nativeGraphics, this.color);
    }

    public void setColor(Paint paint) {
        this.paint = paint;
    }

    public Font getFont() {
        return this.current;
    }

    public void setFont(Font font) {
        this.current = font;
        if (!(font instanceof CustomFont)) {
            this.impl.setNativeFont(this.nativeGraphics, font.getNativeFont());
        }
    }

    public int getClipX() {
        return this.impl.getClipX(this.nativeGraphics) - this.xTranslate;
    }

    public int[] getClip() {
        return new int[]{this.getClipX(), this.getClipY(), this.getClipWidth(), this.getClipHeight()};
    }

    public void setClip(int[] clip) {
        this.setClip(clip[0], clip[1], clip[2], clip[3]);
    }

    public int getClipY() {
        return this.impl.getClipY(this.nativeGraphics) - this.yTranslate;
    }

    public int getClipWidth() {
        return this.impl.getClipWidth(this.nativeGraphics);
    }

    public int getClipHeight() {
        return this.impl.getClipHeight(this.nativeGraphics);
    }

    public void clipRect(int x, int y, int width, int height) {
        this.impl.clipRect(this.nativeGraphics, this.xTranslate + x, this.yTranslate + y, width, height);
    }

    public void setClip(int x, int y, int width, int height) {
        this.impl.setClip(this.nativeGraphics, this.xTranslate + x, this.yTranslate + y, width, height);
    }

    public void setClip(Shape shape) {
        if (this.xTranslate != 0 || this.yTranslate != 0) {
            GeneralPath p = this.tmpClipShape();
            p.setShape(shape, this.translation());
            shape = p;
        }
        this.impl.setClip(this.nativeGraphics, shape);
    }

    public void pushClip() {
        this.impl.pushClip(this.nativeGraphics);
    }

    public void popClip() {
        this.impl.popClip(this.nativeGraphics);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.impl.drawLine(this.nativeGraphics, this.xTranslate + x1, this.yTranslate + y1, this.xTranslate + x2, this.yTranslate + y2);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.impl.fillRect(this.nativeGraphics, this.xTranslate + x, this.yTranslate + y, width, height);
    }

    public void clearRect(int x, int y, int width, int height) {
        this.clearRectImpl(this.xTranslate + x, this.yTranslate + y, width, height);
    }

    private void clearRectImpl(int x, int y, int width, int height) {
        this.impl.clearRect(this.nativeGraphics, x, y, width, height);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.impl.drawRect(this.nativeGraphics, this.xTranslate + x, this.yTranslate + y, width, height);
    }

    public void drawRect(int x, int y, int width, int height, int thickness) {
        this.impl.drawRect(this.nativeGraphics, this.xTranslate + x, this.yTranslate + y, width, height, thickness);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.impl.drawRoundRect(this.nativeGraphics, this.xTranslate + x, this.yTranslate + y, width, height, arcWidth, arcHeight);
    }

    public void lighterColor(int factor) {
        int color = this.getColor();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = Math.min(255, r + factor);
        g = Math.min(255, g + factor);
        b = Math.min(255, b + factor);
        this.setColor(r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF);
    }

    public void darkerColor(int factor) {
        int color = this.getColor();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = Math.max(0, r - factor);
        g = Math.max(0, g - factor);
        b = Math.max(0, b - factor);
        this.setColor(r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.impl.fillRoundRect(this.nativeGraphics, this.xTranslate + x, this.yTranslate + y, width, height, arcWidth, arcHeight);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Width & Height of fillAsrc must be greater than 0");
        }
        this.impl.fillArc(this.nativeGraphics, this.xTranslate + x, this.yTranslate + y, width, height, startAngle, arcAngle);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.impl.drawArc(this.nativeGraphics, this.xTranslate + x, this.yTranslate + y, width, height, startAngle, arcAngle);
    }

    private void drawStringImpl(String str, int x, int y) {
        if (str.length() == 0 || str.length() == 1 && str.charAt(0) == ' ') {
            return;
        }
        if (!(this.current instanceof CustomFont)) {
            this.impl.drawString(this.nativeGraphics, str, x + this.xTranslate, y + this.yTranslate);
        } else {
            this.current.drawString(this, str, x, y);
        }
    }

    public void drawString(String str, int x, int y, int textDecoration) {
        if (str.length() == 0 || str.length() == 1 && str.charAt(0) == ' ') {
            return;
        }
        Object nativeFont = null;
        if (this.current != null) {
            nativeFont = this.current.getNativeFont();
        }
        if (this.current instanceof CustomFont) {
            this.current.drawString(this, str, x, y);
        } else {
            this.impl.drawString(this.nativeGraphics, nativeFont, str, x + this.xTranslate, y + this.yTranslate, textDecoration);
        }
    }

    public void drawStringBaseline(String str, int x, int y) {
        this.drawString(str, x, y - this.current.getAscent());
    }

    public void drawStringBaseline(String str, int x, int y, int textDecoration) {
        this.drawString(str, x, y - this.current.getAscent(), textDecoration);
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, x, y, 0);
    }

    public void drawChar(char character, int x, int y) {
        this.drawString("" + character, x, y);
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        if (!(this.current instanceof CustomFont)) {
            this.drawString(new String(data, offset, length), x, y);
        } else {
            CustomFont f = (CustomFont)this.current;
            f.drawChars(this, data, offset, length, x, y);
        }
    }

    public void drawImage(Image img, int x, int y) {
        img.drawImage(this, this.nativeGraphics, x, y);
    }

    public void drawImage(Image img, int x, int y, int w, int h) {
        if (this.impl.isScaledImageDrawingSupported()) {
            img.drawImage(this, this.nativeGraphics, x, y, w, h);
        } else {
            this.drawImage(img.scaled(w, h), x, y);
        }
    }

    void drawImageWH(Object nativeImage, int x, int y, int w, int h) {
        this.impl.drawImage(this.nativeGraphics, nativeImage, x + this.xTranslate, y + this.yTranslate, w, h);
    }

    void drawImage(Object img, int x, int y) {
        this.impl.drawImage(this.nativeGraphics, img, x + this.xTranslate, y + this.yTranslate);
    }

    void drawImage(Object img, int x, int y, int transform) {
        if (transform != 0) {
            this.impl.drawImageRotated(this.nativeGraphics, img, x + this.xTranslate, y + this.yTranslate, transform);
        } else {
            this.drawImage(img, x, y);
        }
    }

    public void drawShape(Shape shape, Stroke stroke) {
        if (this.isShapeSupported()) {
            if (this.xTranslate != 0 || this.yTranslate != 0) {
                GeneralPath p = this.tmpClipShape();
                p.setShape(shape, this.translation());
                shape = p;
            }
            this.impl.drawShape(this.nativeGraphics, shape, stroke);
        }
    }

    public void fillShape(Shape shape) {
        if (this.isShapeSupported()) {
            if (this.paint != null) {
                int clipX = this.getClipX();
                int clipY = this.getClipY();
                int clipW = this.getClipWidth();
                int clipH = this.getClipHeight();
                this.setClip(shape);
                this.clipRect(clipX, clipY, clipW, clipH);
                if (this.xTranslate != 0 || this.yTranslate != 0) {
                    GeneralPath p = this.tmpClipShape();
                    p.setShape(shape, this.translation());
                    shape = p;
                }
                Rectangle bounds = shape.getBounds();
                this.paint.paint(this, bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
                this.setClip(clipX, clipY, clipW, clipH);
                return;
            }
            if (this.xTranslate != 0 || this.yTranslate != 0) {
                GeneralPath p = this.tmpClipShape();
                p.setShape(shape, this.translation());
                shape = p;
            }
            this.impl.fillShape(this.nativeGraphics, shape);
        }
    }

    public boolean isTransformSupported() {
        return this.impl.isTransformSupported(this.nativeGraphics);
    }

    public boolean isPerspectiveTransformSupported() {
        return this.impl.isPerspectiveTransformSupported(this.nativeGraphics);
    }

    public boolean isShapeSupported() {
        return this.impl.isShapeSupported(this.nativeGraphics);
    }

    public boolean isShapeClipSupported() {
        return this.impl.isShapeClipSupported(this.nativeGraphics);
    }

    public void setTransform(Transform transform) {
        this.impl.setTransform(this.nativeGraphics, transform);
    }

    public void transform(Transform transform) {
        Transform existing = this.getTransform();
        existing.concatenate(transform);
        this.setTransform(existing);
    }

    public Transform getTransform() {
        return this.impl.getTransform(this.nativeGraphics);
    }

    public void getTransform(Transform t) {
        this.impl.getTransform(this.nativeGraphics, t);
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.impl.fillTriangle(this.nativeGraphics, this.xTranslate + x1, this.yTranslate + y1, this.xTranslate + x2, this.yTranslate + y2, this.xTranslate + x3, this.yTranslate + y3);
    }

    void drawRGB(int[] rgbData, int offset, int x, int y, int w, int h, boolean processAlpha) {
        this.impl.drawRGB(this.nativeGraphics, rgbData, offset, x + this.xTranslate, y + this.yTranslate, w, h, processAlpha);
    }

    public void fillRadialGradient(int startColor, int endColor, int x, int y, int width, int height) {
        this.impl.fillRadialGradient(this.nativeGraphics, startColor, endColor, x + this.xTranslate, y + this.yTranslate, width, height);
    }

    public void fillRadialGradient(int startColor, int endColor, int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.impl.fillRadialGradient(this.nativeGraphics, startColor, endColor, x + this.xTranslate, y + this.yTranslate, width, height, startAngle, arcAngle);
    }

    public void fillRectRadialGradient(int startColor, int endColor, int x, int y, int width, int height, float relativeX, float relativeY, float relativeSize) {
        if (startColor == endColor) {
            this.setColor(startColor);
            this.fillRect(x, y, width, height, (byte)-1);
            return;
        }
        this.impl.fillRectRadialGradient(this.nativeGraphics, startColor, endColor, x + this.xTranslate, y + this.yTranslate, width, height, relativeX, relativeY, relativeSize);
    }

    public void fillLinearGradient(int startColor, int endColor, int x, int y, int width, int height, boolean horizontal) {
        if (startColor == endColor) {
            this.setColor(startColor);
            this.fillRect(x, y, width, height, (byte)-1);
            return;
        }
        this.impl.fillLinearGradient(this.nativeGraphics, startColor, endColor, x + this.xTranslate, y + this.yTranslate, width, height, horizontal);
    }

    public void fillRect(int x, int y, int w, int h, byte alpha) {
        this.impl.fillRect(this.nativeGraphics, x + this.xTranslate, y + this.yTranslate, w, h, alpha);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        int[] cX = xPoints;
        int[] cY = yPoints;
        if (!(this.impl.isTranslationSupported() || this.xTranslate == 0 && this.yTranslate == 0)) {
            cX = new int[nPoints];
            cY = new int[nPoints];
            System.arraycopy(xPoints, 0, cX, 0, nPoints);
            System.arraycopy(yPoints, 0, cY, 0, nPoints);
            int iter = 0;
            while (iter < nPoints) {
                int n = iter;
                cX[n] = cX[n] + this.xTranslate;
                int n2 = iter++;
                cY[n2] = cY[n2] + this.yTranslate;
            }
        }
        this.impl.fillPolygon(this.nativeGraphics, cX, cY, nPoints);
    }

    void drawImageArea(Image img, int x, int y, int imageX, int imageY, int imageWidth, int imageHeight) {
        img.drawImageArea(this, this.nativeGraphics, x, y, imageX, imageY, imageWidth, imageHeight);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        int[] cX = xPoints;
        int[] cY = yPoints;
        if (!(this.impl.isTranslationSupported() || this.xTranslate == 0 && this.yTranslate == 0)) {
            cX = new int[nPoints];
            cY = new int[nPoints];
            System.arraycopy(xPoints, 0, cX, 0, nPoints);
            System.arraycopy(yPoints, 0, cY, 0, nPoints);
            int iter = 0;
            while (iter < nPoints) {
                int n = iter;
                cX[n] = cX[n] + this.xTranslate;
                int n2 = iter++;
                cY[n2] = cY[n2] + this.yTranslate;
            }
        }
        this.impl.drawPolygon(this.nativeGraphics, cX, cY, nPoints);
    }

    public boolean isAlphaSupported() {
        return this.impl.isAlphaGlobal();
    }

    public void setAlpha(int a) {
        this.impl.setAlpha(this.nativeGraphics, a);
    }

    public int getAlpha() {
        return this.impl.getAlpha(this.nativeGraphics);
    }

    public boolean isAntiAliasingSupported() {
        return this.impl.isAntiAliasingSupported(this.nativeGraphics);
    }

    public boolean isAntiAliasedTextSupported() {
        return this.impl.isAntiAliasedTextSupported(this.nativeGraphics);
    }

    public boolean isAntiAliased() {
        return this.impl.isAntiAliased(this.nativeGraphics);
    }

    public void setAntiAliased(boolean a) {
        this.impl.setAntiAliased(this.nativeGraphics, a);
    }

    public void setAntiAliasedText(boolean a) {
        this.impl.setAntiAliasedText(this.nativeGraphics, a);
    }

    public boolean isAntiAliasedText() {
        return this.impl.isAntiAliasedText(this.nativeGraphics);
    }

    public boolean isAffineSupported() {
        return this.impl.isAffineSupported();
    }

    public void resetAffine() {
        this.impl.resetAffine(this.nativeGraphics);
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
    }

    public void scale(float x, float y) {
        this.impl.scale(this.nativeGraphics, x, y);
        this.scaleX = x;
        this.scaleY = y;
    }

    public void rotate(float angle) {
        this.impl.rotate(this.nativeGraphics, angle);
    }

    public void rotateRadians(float angle) {
        this.rotateRadians(angle, 0, 0);
    }

    public void rotate(float angle, int pivotX, int pivotY) {
        this.impl.rotate(this.nativeGraphics, angle, pivotX, pivotY);
    }

    public void rotateRadians(float angle, int pivotX, int pivotY) {
        this.impl.rotate(this.nativeGraphics, angle, pivotX + this.xTranslate, pivotY + this.yTranslate);
    }

    public void shear(float x, float y) {
        this.impl.shear(this.nativeGraphics, x, y);
    }

    public Object beginNativeGraphicsAccess() {
        if (this.nativeGraphicsState != null) {
            throw new IllegalStateException("beginNativeGraphicsAccess invoked twice in a row");
        }
        Boolean a = Boolean.FALSE;
        Boolean b = Boolean.FALSE;
        if (this.isAntiAliasedText()) {
            b = Boolean.TRUE;
        }
        if (this.isAntiAliased()) {
            a = Boolean.TRUE;
        }
        this.nativeGraphicsState = new Object[]{new Integer(this.getTranslateX()), new Integer(this.getTranslateY()), new Integer(this.getColor()), new Integer(this.getAlpha()), new Integer(this.getClipX()), new Integer(this.getClipY()), new Integer(this.getClipWidth()), new Integer(this.getClipHeight()), a, b};
        this.translate(-this.getTranslateX(), -this.getTranslateY());
        this.setAlpha(255);
        this.setClip(0, 0, Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight());
        return this.nativeGraphics;
    }

    public void endNativeGraphicsAccess() {
        this.translate((Integer)this.nativeGraphicsState[0], (Integer)this.nativeGraphicsState[1]);
        this.setColor((Integer)this.nativeGraphicsState[2]);
        this.setAlpha((Integer)this.nativeGraphicsState[3]);
        this.setClip((Integer)this.nativeGraphicsState[4], (Integer)this.nativeGraphicsState[5], (Integer)this.nativeGraphicsState[6], (Integer)this.nativeGraphicsState[7]);
        this.setAntiAliased((Boolean)this.nativeGraphicsState[8]);
        this.setAntiAliasedText((Boolean)this.nativeGraphicsState[9]);
        this.nativeGraphicsState = null;
    }

    public void tileImage(Image img, int x, int y, int w, int h) {
        if (img.requiresDrawImage()) {
            int iW = img.getWidth();
            int iH = img.getHeight();
            int clipX = this.getClipX();
            int clipW = this.getClipWidth();
            int clipY = this.getClipY();
            int clipH = this.getClipHeight();
            this.clipRect(x, y, w, h);
            for (int xPos = 0; xPos <= w; xPos += iW) {
                for (int yPos = 0; yPos < h; yPos += iH) {
                    int actualX = xPos + x;
                    int actualY = yPos + y;
                    if (actualX > clipX + clipW || actualX + iW < clipX || actualY > clipY + clipH || actualY + iH < clipY) continue;
                    this.drawImage(img, actualX, actualY);
                }
            }
            this.setClip(clipX, clipY, clipW, clipH);
        } else {
            this.impl.tileImage(this.nativeGraphics, img.getImage(), x + this.xTranslate, y + this.yTranslate, w, h);
        }
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    void drawPeerComponent(PeerComponent peer) {
        if (this.paintPeersBehind) {
            this.clearRectImpl(peer.getAbsoluteX(), peer.getAbsoluteY(), peer.getWidth(), peer.getHeight());
        }
    }

    public void setRenderingHints(int hints) {
        this.impl.setRenderingHints(this.nativeGraphics, hints);
    }

    public int getRenderingHints() {
        return this.impl.getRenderingHints(this.nativeGraphics);
    }
}

