/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.util;

import com.codename1.ui.Component;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Label;
import com.codename1.ui.Painter;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.Rectangle;
import java.util.Vector;

public class GlassTutorial
implements Painter {
    private static final String DEST = "$$GLSDESTHINT$$";
    private static final String POS = "$$GLSDESTPOS$$";
    private Vector vec = new Vector();
    private Component internal;

    public void addHint(Component hintComponent, Component destinationComponent, String position) {
        hintComponent.putClientProperty(POS, position);
        hintComponent.putClientProperty(DEST, destinationComponent);
        this.vec.addElement(hintComponent);
    }

    public void showOn(Form f) {
        Painter oldPane = f.getGlassPane();
        f.setGlassPane(this);
        Dialog dummy = new Dialog(){

            public void keyReleased(int i) {
                this.dispose();
            }
        };
        int oldTint = f.getTintColor();
        f.setTintColor(0);
        dummy.getDialogStyle().setBgTransparency(0);
        dummy.setDisposeWhenPointerOutOfBounds(true);
        dummy.show(0, Display.getInstance().getDisplayHeight() - 2, 0, Display.getInstance().getDisplayWidth() - 2, true, true);
        f.setTintColor(oldTint);
        f.setGlassPane(oldPane);
    }

    public void paint(Graphics g, Rectangle rect) {
        if (this.internal == null) {
            this.internal = new Label(" ");
            this.internal.setUIID("GlassTutorial");
        }
        this.internal.setSize(rect.getSize());
        this.internal.paintComponent(g);
        int componentCount = this.vec.size();
        for (int iter = 0; iter < componentCount; ++iter) {
            Component current = (Component)this.vec.elementAt(iter);
            String pos = (String)current.getClientProperty(POS);
            Component dest = (Component)current.getClientProperty(DEST);
            int xpos = dest.getAbsoluteX();
            int ypos = dest.getAbsoluteY();
            int w = dest.getWidth();
            int h = dest.getHeight();
            if (pos.equals("Center")) {
                current.setX(xpos);
                current.setY(ypos);
                current.setWidth(w);
                current.setHeight(h);
                current.paintComponent(g);
                continue;
            }
            Dimension d = current.getPreferredSize();
            current.setWidth(d.getWidth());
            current.setHeight(d.getHeight());
            if (pos.equals("South")) {
                current.setX(xpos + w / 2 - d.getWidth() / 2);
                current.setY(ypos + h);
                current.paintComponent(g);
                continue;
            }
            if (pos.equals("North")) {
                current.setX(xpos + w / 2 - d.getWidth() / 2);
                current.setY(ypos - d.getHeight());
                current.paintComponent(g);
                continue;
            }
            if (pos.equals("East")) {
                current.setX(xpos + w);
                current.setY(ypos + h / 2 - d.getHeight() / 2);
                current.paintComponent(g);
                continue;
            }
            if (!pos.equals("West")) continue;
            current.setX(xpos - d.getWidth());
            current.setY(ypos + h / 2 - d.getHeight() / 2);
            current.paintComponent(g);
        }
    }
}

