/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.components.MediaPlayer;
import com.codename1.components.SpanLabel;
import com.codename1.io.Log;
import com.codename1.media.Media;
import com.codename1.media.MediaManager;
import com.codename1.media.MediaRecorderBuilder;
import com.codename1.ui.Button;
import com.codename1.ui.CN;
import com.codename1.ui.ComponentSelector;
import com.codename1.ui.Container;
import com.codename1.ui.FontImage;
import com.codename1.ui.Graphics;
import com.codename1.ui.Label;
import com.codename1.ui.Sheet;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.ActionSource;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.FlowLayout;
import com.codename1.ui.layouts.LayeredLayout;
import com.codename1.ui.util.EventDispatcher;
import java.io.IOException;

public class AudioRecorderComponent
extends Container
implements ActionSource {
    private Media media;
    private Button record;
    private Button pause;
    private Button done;
    private Label recordingInProgress;
    private Label recordingOff;
    private EventDispatcher actionListeners = new EventDispatcher();
    private RecorderState state;
    private double recordAlpha = 1.0;
    private long recordingLength;
    private long lastRecordingStartTime;
    private Label recordingTime;
    private int counter = 0;

    protected void initComponent() {
        super.initComponent();
        this.getComponentForm().registerAnimated(this);
    }

    protected void deinitialize() {
        this.getComponentForm().deregisterAnimated(this);
        super.deinitialize();
    }

    public boolean animate() {
        if (this.state == RecorderState.Recording) {
            this.recordAlpha = 0.6 + 0.4 * Math.sin((double)this.counter * Math.PI / 180.0);
            this.counter += 2;
            this.counter %= 360;
            if (this.recordingTime != null) {
                int milli = this.recordingLength();
                int sec = milli / 1000;
                int seconds = sec % 60;
                int minutes = sec / 60;
                String secStr = seconds < 10 ? "0" + seconds : "" + seconds;
                String minStr = minutes < 10 ? "0" + minutes : "" + minutes;
                String txt = minStr + ":" + secStr + "." + milli % 1000;
                this.recordingTime.setText(txt);
            }
            return true;
        }
        this.recordAlpha = 1.0;
        return super.animate();
    }

    private int recordingLength() {
        if (this.lastRecordingStartTime > 0L) {
            return (int)(System.currentTimeMillis() - this.lastRecordingStartTime + this.recordingLength);
        }
        return (int)this.recordingLength;
    }

    public AudioRecorderComponent(final MediaRecorderBuilder builder) {
        super(new BorderLayout());
        CN.callSerially(new Runnable(){

            public void run() {
                try {
                    AudioRecorderComponent.this.media = MediaManager.createMediaRecorder(builder);
                    AudioRecorderComponent.this.setState(RecorderState.Initialized);
                    AudioRecorderComponent.this.setState(RecorderState.Paused);
                }
                catch (IOException ex) {
                    Log.e(ex);
                    AudioRecorderComponent.this.setState(RecorderState.NotInitialized);
                }
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                switch (AudioRecorderComponent.this.state) {
                    case Accepted: 
                    case Canceled: {
                        break;
                    }
                    default: {
                        evt.consume();
                    }
                }
                switch (AudioRecorderComponent.this.state) {
                    case NotInitialized: {
                        evt.consume();
                        AudioRecorderComponent.this.removeAll();
                        AudioRecorderComponent.this.add((Object)"Center", new SpanLabel("Failed to initialize media recorder."));
                        AudioRecorderComponent.this.revalidateLater();
                        break;
                    }
                    case Initializing: {
                        AudioRecorderComponent.this.recordingLength = 0L;
                        AudioRecorderComponent.this.done.setEnabled(false);
                        AudioRecorderComponent.this.recordingInProgress.setVisible(false);
                        evt.consume();
                        AudioRecorderComponent.this.removeAll();
                        AudioRecorderComponent.this.add((Object)"Center", new SpanLabel("Preparing media.  Please wait..."));
                        AudioRecorderComponent.this.revalidateLater();
                        break;
                    }
                    case Initialized: {
                        evt.consume();
                        AudioRecorderComponent.this.removeAll();
                        AudioRecorderComponent.this.add((Object)"Center", AudioRecorderComponent.this.buildUI());
                        AudioRecorderComponent.this.revalidateLater();
                        break;
                    }
                    case Accepted: {
                        AudioRecorderComponent.this.removeAll();
                        AudioRecorderComponent.this.revalidateLater();
                        break;
                    }
                    case Canceled: {
                        AudioRecorderComponent.this.removeAll();
                        AudioRecorderComponent.this.revalidateLater();
                        break;
                    }
                    case Paused: {
                        if (AudioRecorderComponent.this.lastRecordingStartTime > 0L) {
                            AudioRecorderComponent.this.recordingLength = AudioRecorderComponent.this.recordingLength + (System.currentTimeMillis() - AudioRecorderComponent.this.lastRecordingStartTime);
                            AudioRecorderComponent.this.lastRecordingStartTime = 0L;
                        }
                        AudioRecorderComponent.this.recordingInProgress.setVisible(false);
                        AudioRecorderComponent.this.recordingOff.setVisible(true);
                        AudioRecorderComponent.this.record.setHidden(false);
                        AudioRecorderComponent.this.record.setEnabled(true);
                        AudioRecorderComponent.this.record.setVisible(true);
                        AudioRecorderComponent.this.pause.setHidden(true);
                        AudioRecorderComponent.this.pause.setVisible(false);
                        AudioRecorderComponent.this.pause.setEnabled(false);
                        AudioRecorderComponent.this.revalidateLater();
                        break;
                    }
                    case Recording: {
                        AudioRecorderComponent.this.recordingTime.setVisible(true);
                        AudioRecorderComponent.this.lastRecordingStartTime = System.currentTimeMillis();
                        AudioRecorderComponent.this.recordingInProgress.setVisible(true);
                        AudioRecorderComponent.this.recordingOff.setVisible(false);
                        AudioRecorderComponent.this.done.setEnabled(true);
                        AudioRecorderComponent.this.record.setHidden(true);
                        AudioRecorderComponent.this.record.setEnabled(false);
                        AudioRecorderComponent.this.record.setVisible(false);
                        AudioRecorderComponent.this.pause.setHidden(false);
                        AudioRecorderComponent.this.pause.setVisible(true);
                        AudioRecorderComponent.this.pause.setEnabled(true);
                        AudioRecorderComponent.this.revalidateLater();
                    }
                }
            }
        });
        this.recordingInProgress = new Label("Recording"){

            public void paint(Graphics g) {
                int opacity = g.getAlpha();
                double alpha = (double)opacity * AudioRecorderComponent.this.recordAlpha;
                g.setAlpha((int)Math.round(alpha));
                super.paint(g);
                g.setAlpha(opacity);
            }
        };
        ComponentSelector.$(this.recordingInProgress).selectAllStyles().setFgColor(0xFF0000);
        FontImage.setMaterialIcon(this.recordingInProgress, '\ue029');
        this.recordingOff = new Label("");
        ComponentSelector.$(this.recordingOff).selectAllStyles().setFgColor(0x666666);
        FontImage.setMaterialIcon(this.recordingOff, '\ue02b');
        this.recordingTime = new Label();
        this.record = new Button('\ue061');
        this.record.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent t) {
                AudioRecorderComponent.this.media.play();
                AudioRecorderComponent.this.setState(RecorderState.Recording);
            }
        });
        this.pause = new Button('\ue034');
        this.pause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent t) {
                AudioRecorderComponent.this.media.pause();
                AudioRecorderComponent.this.setState(RecorderState.Paused);
            }
        });
        ComponentSelector.$(this.record).selectAllStyles().setFgColor(0xFF0000).setMaterialIcon('\ue061', 10.0f);
        ComponentSelector.$(this.pause).selectAllStyles().setFgColor(0x666666).setMaterialIcon('\ue036', 10.0f);
        this.done = new Button("Done");
        this.done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent t) {
                if (builder.isRedirectToAudioBuffer()) {
                    AudioRecorderComponent.this.media.cleanup();
                    AudioRecorderComponent.this.setState(RecorderState.Paused);
                    AudioRecorderComponent.this.setState(RecorderState.Accepted);
                    return;
                }
                final boolean[] closeHandled = new boolean[1];
                AudioRecorderComponent.this.media.pause();
                AudioRecorderComponent.this.setState(RecorderState.Paused);
                AudioRecorderComponent.this.setState(RecorderState.Pending);
                Sheet processingSheet = new Sheet(Sheet.findContainingSheet(AudioRecorderComponent.this.done), "Preview");
                processingSheet.getContentPane().setLayout(new BorderLayout());
                Container center = BorderLayout.center(new SpanLabel("Processing... please wait"));
                processingSheet.getContentPane().add((Object)"Center", center);
                processingSheet.show();
                final Sheet sheet = new Sheet(Sheet.findContainingSheet(AudioRecorderComponent.this.done), "Preview");
                Button cancel = new Button("Cancel");
                cancel.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        closeHandled[0] = true;
                        sheet.back();
                        AudioRecorderComponent.this.setState(RecorderState.Canceled);
                    }
                });
                Button startOver = new Button("Start over");
                startOver.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        closeHandled[0] = true;
                        sheet.back();
                        AudioRecorderComponent.this.setState(RecorderState.Initializing);
                        try {
                            AudioRecorderComponent.this.media = MediaManager.createMediaRecorder(builder);
                            AudioRecorderComponent.this.setState(RecorderState.Initialized);
                            AudioRecorderComponent.this.setState(RecorderState.Paused);
                        }
                        catch (IOException ex) {
                            AudioRecorderComponent.this.setState(RecorderState.NotInitialized);
                        }
                    }
                });
                Button accept = new Button("Accept");
                accept.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        closeHandled[0] = true;
                        sheet.back();
                        AudioRecorderComponent.this.setState(RecorderState.Accepted);
                    }
                });
                sheet.getContentPane().setLayout(new BorderLayout());
                Container mpContainer = new Container(BoxLayout.y());
                sheet.getContentPane().add((Object)"Center", BoxLayout.encloseY(mpContainer, accept, startOver, cancel));
                AudioRecorderComponent.this.media.cleanup();
                try {
                    MediaPlayer mp = new MediaPlayer(MediaManager.createMedia(builder.getPath(), false));
                    mp.setOnTopMode(false);
                    mpContainer.add(mp);
                }
                catch (IOException ex) {
                    mpContainer.add(new Label("No Audio Received"));
                    accept.setEnabled(false);
                }
                sheet.addBackListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        if (!closeHandled[0]) {
                            closeHandled[0] = true;
                            AudioRecorderComponent.this.setState(RecorderState.Initializing);
                            try {
                                AudioRecorderComponent.this.media = MediaManager.createMediaRecorder(builder);
                                AudioRecorderComponent.this.setState(RecorderState.Initialized);
                                AudioRecorderComponent.this.setState(RecorderState.Paused);
                            }
                            catch (IOException ex) {
                                AudioRecorderComponent.this.setState(RecorderState.NotInitialized);
                            }
                        }
                    }
                });
                sheet.addCloseListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        if (!closeHandled[0]) {
                            closeHandled[0] = true;
                            AudioRecorderComponent.this.setState(RecorderState.Canceled);
                        }
                    }
                });
                sheet.show();
            }
        });
    }

    public RecorderState getState() {
        return this.state;
    }

    private Container buildUI() {
        Container out = new Container(new BorderLayout());
        this.done.remove();
        this.recordingOff.remove();
        this.recordingInProgress.remove();
        out.add((Object)"North", BorderLayout.centerEastWest(null, this.done, LayeredLayout.encloseIn(this.recordingOff, this.recordingInProgress)));
        this.record.remove();
        Container center = new Container(new LayeredLayout());
        center.add(this.record);
        this.pause.remove();
        center.add(this.pause);
        out.add((Object)"Center", BorderLayout.centerAbsolute(center));
        this.recordingTime.remove();
        out.add((Object)"South", FlowLayout.encloseCenter(this.recordingTime));
        return out;
    }

    private void setState(RecorderState state) {
        if (this.state != state) {
            System.out.println("State is now " + (Object)((Object)state));
            this.state = state;
            this.actionListeners.fireActionEvent(new ActionEvent(this));
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.addListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.removeListener(l);
    }

    protected Dimension calcPreferredSize() {
        return new Dimension(CN.convertToPixels(100.0f), CN.convertToPixels(50.0f));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecorderState {
        Initializing,
        Recording,
        Paused,
        Pending,
        Canceled,
        Accepted,
        Initialized,
        NotInitialized;

    }
}

