/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.impl.CodenameOneImplementation;
import com.codename1.ui.Button;
import com.codename1.ui.ButtonGroup;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Font;
import com.codename1.ui.FontImage;
import com.codename1.ui.Form;
import com.codename1.ui.IconHolder;
import com.codename1.ui.Image;
import com.codename1.ui.RadioButton;
import com.codename1.ui.animations.Motion;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.FocusListener;
import com.codename1.ui.events.SelectionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.FlowLayout;
import com.codename1.ui.layouts.GridLayout;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.EventDispatcher;

public class Tabs
extends Container {
    private Container contentPane = new Container(new TabsLayout());
    private boolean eagerSwipeMode;
    private int tabPlacement;
    private Container tabsContainer;
    private ButtonGroup radioGroup = new ButtonGroup();
    private Component selectedTab;
    private boolean swipeActivated = true;
    private ActionListener press;
    private ActionListener drag;
    private ActionListener release;
    private Motion slideToDestMotion;
    private int initialX = -1;
    private int initialY = -1;
    private int lastX = -1;
    private boolean dragStarted = false;
    private int activeComponent = 0;
    private int active = 0;
    private EventDispatcher focusListeners;
    private EventDispatcher selectionListener;
    private TabFocusListener focusListener = new TabFocusListener();
    private boolean tabsFillRows;
    private boolean tabsGridLayout;
    private int textPosition = -1;
    private boolean changeTabOnFocus;
    private boolean changeTabContainerStyleOnFocus;
    private int tabsGap = 0;
    private Style originalTabsContainerUnselected;
    private Style originalTabsContainerSelected;
    private String tabUIID = "Tab";
    private boolean animateTabSelection = true;
    private boolean doNotBlockSideSwipe;
    private boolean blockSwipe;
    private boolean riskySwipe;

    public Tabs() {
        this(-1);
    }

    public Tabs(int tabP) {
        super(new BorderLayout());
        this.contentPane.setUIID("TabbedPane");
        super.addComponent("Center", (Component)this.contentPane);
        this.tabsContainer = new Container();
        this.tabsContainer.setSafeArea(true);
        this.tabsContainer.setUIID("TabsContainer");
        this.tabsContainer.setScrollVisible(false);
        this.tabsContainer.getStyle().setMargin(0, 0, 0, 0);
        if (tabP == -1) {
            this.setTabPlacement(this.tabPlacement);
        } else {
            this.setTabPlacement(tabP);
        }
        this.press = new SwipeListener(0);
        this.drag = new SwipeListener(1);
        this.release = new SwipeListener(2);
        this.setUIID("Tabs");
        BorderLayout bd = (BorderLayout)super.getLayout();
        if (bd != null) {
            if (UIManager.getInstance().isThemeConstant("tabsOnTopBool", false)) {
                bd.setCenterBehavior(3);
            } else {
                bd.setCenterBehavior(0);
            }
        }
    }

    protected boolean shouldBlockSideSwipe() {
        if (this.doNotBlockSideSwipe) {
            return false;
        }
        return this.isSwipeActivated();
    }

    private void checkTabsCanBeSeen() {
        if (UIManager.getInstance().isThemeConstant("tabsOnTopBool", false)) {
            for (int iter = 0; iter < this.getTabCount(); ++iter) {
                Component c = this.getTabComponentAt(iter);
                if (!c.isScrollableY() || c.getStyle().getPaddingBottom() >= this.tabsContainer.getPreferredH()) continue;
                c.getStyle().setPadding(2, this.tabsContainer.getPreferredH());
            }
        }
    }

    protected void initLaf(UIManager manager) {
        super.initLaf(manager);
        int tabPlace = manager.getThemeConstant("tabPlacementInt", -1);
        this.tabsFillRows = manager.isThemeConstant("tabsFillRowsBool", false);
        this.tabsGridLayout = manager.isThemeConstant("tabsGridBool", false);
        this.changeTabOnFocus = manager.isThemeConstant("changeTabOnFocusBool", false);
        BorderLayout bd = (BorderLayout)super.getLayout();
        if (bd != null) {
            if (manager.isThemeConstant("tabsOnTopBool", false)) {
                if (bd.getCenterBehavior() != 3) {
                    bd.setCenterBehavior(3);
                    this.checkTabsCanBeSeen();
                }
            } else {
                bd.setCenterBehavior(0);
            }
        }
        this.changeTabContainerStyleOnFocus = manager.isThemeConstant("changeTabContainerStyleOnFocusBool", false);
        if (tabPlace != -1) {
            this.tabPlacement = tabPlace;
        }
    }

    void initComponentImpl() {
        super.initComponentImpl();
        Form frm = this.getComponentForm();
        if (frm != null) {
            Component f;
            frm.registerAnimatedInternal(this);
            if (this.changeTabContainerStyleOnFocus && Display.getInstance().shouldRenderSelection() && (f = this.getComponentForm().getFocused()) != null && f.getParent() == this.tabsContainer) {
                this.initTabsContainerStyle();
                this.tabsContainer.setUnselectedStyle(this.originalTabsContainerSelected);
                this.tabsContainer.repaint();
            }
        }
    }

    public void refreshTheme(boolean merge) {
        super.refreshTheme(merge);
        this.originalTabsContainerSelected = null;
        this.originalTabsContainerUnselected = null;
    }

    protected void deinitialize() {
        Form form = this.getComponentForm();
        if (form != null) {
            form.removePointerPressedListener(this.press);
            form.removePointerReleasedListener(this.release);
            form.removePointerDraggedListener(this.drag);
        }
        super.deinitialize();
    }

    protected void initComponent() {
        super.initComponent();
        Form form = this.getComponentForm();
        if (form != null && this.swipeActivated) {
            form.addPointerPressedListener(this.press);
            form.addPointerReleasedListener(this.release);
            form.addPointerDraggedListener(this.drag);
        }
    }

    public boolean animate() {
        boolean b = super.animate();
        if (this.slideToDestMotion != null) {
            int i;
            int motionX = this.slideToDestMotion.getValue();
            int size = this.contentPane.getComponentCount();
            int tabWidth = this.contentPane.getWidth() - this.tabsGap * 2;
            for (i = 0; i < size; ++i) {
                int xOffset;
                if (this.isRTL()) {
                    xOffset = (size - i) * tabWidth;
                    xOffset -= (size - this.active) * tabWidth;
                } else {
                    xOffset = i * tabWidth;
                    xOffset -= this.active * tabWidth;
                }
                Component component = this.contentPane.getComponentAt(i);
                component.setX(xOffset += motionX);
            }
            if (this.slideToDestMotion.isFinished()) {
                for (i = 0; i < this.contentPane.getComponentCount(); ++i) {
                    Component component = this.contentPane.getComponentAt(i);
                    component.paintLockRelease();
                }
                this.slideToDestMotion = null;
                enableLayoutOnPaint = true;
                this.deregisterAnimatedInternal();
                this.setSelectedIndex(this.active);
            }
            return true;
        }
        return b;
    }

    void deregisterAnimatedInternal() {
        Form f;
        if ((this.slideToDestMotion == null || this.slideToDestMotion.isFinished()) && (f = this.getComponentForm()) != null) {
            f.deregisterAnimatedInternal(this);
        }
    }

    public void setTabTextPosition(int textPosition) {
        if (textPosition != 1 && textPosition != 3 && textPosition != 2 && textPosition != 0) {
            throw new IllegalArgumentException("Text position can't be set to " + textPosition);
        }
        this.textPosition = textPosition;
        for (int iter = 0; iter < this.getTabCount(); ++iter) {
            this.setTextPosition(this.tabsContainer.getComponentAt(iter), textPosition);
        }
    }

    protected void setTextPosition(Component tabComponent, int textPosition) {
        ((Button)tabComponent).setTextPosition(textPosition);
    }

    public int getTabTextPosition() {
        return this.textPosition;
    }

    public void setTabPlacement(int tabPlacement) {
        if (tabPlacement != 0 && tabPlacement != 1 && tabPlacement != 2 && tabPlacement != 3) {
            throw new IllegalArgumentException("illegal tab placement: must be TOP, BOTTOM, LEFT, or RIGHT");
        }
        if (this.tabPlacement == tabPlacement && this.tabsContainer.getParent() == null && this.isInitialized()) {
            return;
        }
        this.tabPlacement = tabPlacement;
        this.removeComponent(this.tabsContainer);
        this.setTabsLayout(tabPlacement);
        if (tabPlacement == 0) {
            super.addComponent("North", (Component)this.tabsContainer);
        } else if (tabPlacement == 2) {
            super.addComponent("South", (Component)this.tabsContainer);
        } else if (tabPlacement == 1) {
            super.addComponent("West", (Component)this.tabsContainer);
        } else {
            super.addComponent("East", (Component)this.tabsContainer);
        }
        this.initTabsFocus();
        this.tabsContainer.setShouldCalcPreferredSize(true);
        this.contentPane.setShouldCalcPreferredSize(true);
        this.revalidateLater();
    }

    public void addTab(String title, Image icon, Component component) {
        this.insertTab(title, icon, component, this.tabsContainer.getComponentCount());
    }

    public Tabs addTab(String title, Image icon, Image pressedIcon, Component component) {
        int index = this.tabsContainer.getComponentCount();
        this.insertTab(title, icon, component, index);
        this.setTabSelectedIcon(index, pressedIcon);
        return this;
    }

    public Tabs addTab(String title, char materialIcon, float iconSize, Component component) {
        int index = this.tabsContainer.getComponentCount();
        FontImage i = FontImage.createMaterial(materialIcon, "Tab", iconSize);
        this.insertTab(title, i, component, index);
        Style sel = this.getUIManager().getComponentCustomStyle("Tab", "press");
        i = FontImage.createMaterial(materialIcon, sel, iconSize);
        this.setTabSelectedIcon(index, (Image)i);
        return this;
    }

    public Tabs addTab(String title, char icon, Font font, float iconSize, Component component) {
        int index = this.tabsContainer.getComponentCount();
        this.insertTab(title, icon, font, iconSize, component, index);
        return this;
    }

    public void addTab(String title, Component component) {
        this.insertTab(title, null, component, this.tabsContainer.getComponentCount());
    }

    public void addTab(Button tab, Component component) {
        this.insertTab(tab, component, this.tabsContainer.getComponentCount());
    }

    private Component createTabImpl(RadioButton b) {
        Image d;
        this.radioGroup.add(b);
        b.setToggle(true);
        b.setTextPosition(2);
        if (this.radioGroup.getButtonCount() == 1) {
            b.setSelected(true);
        }
        if (this.textPosition != -1) {
            b.setTextPosition(this.textPosition);
        }
        if (b.getIcon() == null && !this.getUIManager().isThemeConstant("TabEnableAutoImageBool", true) && (d = this.getUIManager().getThemeImageConstant("TabUnselectedImage")) != null) {
            b.setIcon(d);
            d = this.getUIManager().getThemeImageConstant("TabSelectedImage");
            if (d != null) {
                b.setRolloverIcon(d);
                b.setPressedIcon(d);
            }
        }
        return b;
    }

    protected Component createTab(String title, Font font, char icon, float size) {
        RadioButton b = new RadioButton(title != null ? title : "");
        FontImage.setIcon((IconHolder)b, font, icon, size);
        this.createTabImpl(b);
        return b;
    }

    protected Component createTab(String title, Image icon) {
        RadioButton b = new RadioButton(title != null ? title : "", icon);
        this.createTabImpl(b);
        return b;
    }

    public void insertTab(String title, Image icon, Component component, int index) {
        Component b = this.createTab(title != null ? title : "", icon);
        this.insertTab(b, component, index);
    }

    public void insertTab(String title, char icon, Font font, float iconSize, Component component, int index) {
        Component b = this.createTab(title != null ? title : "", font, icon, iconSize);
        this.insertTab(b, component, index);
    }

    public void insertTab(Component tab, Component component, int index) {
        this.checkIndex(index);
        if (component == null) {
            return;
        }
        final Component b = tab;
        if (this.tabUIID != null) {
            b.setUIID(this.tabUIID);
        }
        b.addFocusListener(this.focusListener);
        this.bindTabActionListener(b, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (Tabs.this.selectedTab != null) {
                    Component previousContent;
                    int previousSelectedIndex;
                    if (Tabs.this.tabUIID != null) {
                        Tabs.this.selectedTab.setUIID(Tabs.this.tabUIID);
                    }
                    if (!Tabs.this.animateTabSelection) {
                        Tabs.this.selectedTab.setShouldCalcPreferredSize(true);
                        Tabs.this.selectedTab.repaint();
                    }
                    if ((previousSelectedIndex = Tabs.this.tabsContainer.getComponentIndex(Tabs.this.selectedTab)) != -1 && (previousContent = Tabs.this.contentPane.getComponentAt(previousSelectedIndex)) instanceof Container) {
                        ((Container)previousContent).setBlockFocus(true);
                    }
                }
                if (Tabs.this.active != Tabs.this.tabsContainer.getComponentIndex(b)) {
                    Tabs.this.active = Tabs.this.tabsContainer.getComponentIndex(b);
                    Component content = Tabs.this.contentPane.getComponentAt(Tabs.this.active);
                    if (content instanceof Container) {
                        ((Container)content).setBlockFocus(false);
                    }
                    Tabs.this.setSelectedIndex(Tabs.this.active, Tabs.this.animateTabSelection);
                    Tabs.this.initTabsFocus();
                    Tabs.this.selectedTab = b;
                    if (!Tabs.this.animateTabSelection) {
                        Tabs.this.selectedTab.setShouldCalcPreferredSize(true);
                        Tabs.this.tabsContainer.revalidateLater();
                    }
                    Tabs.this.tabsContainer.scrollComponentToVisible(Tabs.this.selectedTab);
                }
            }
        });
        if (component instanceof Container) {
            ((Container)component).setBlockFocus(true);
        }
        this.tabsContainer.addComponent(index, b);
        this.contentPane.addComponent(index, component);
        this.setTabsLayout(this.tabPlacement);
        if (this.tabsContainer.getComponentCount() == 1) {
            this.selectedTab = this.tabsContainer.getComponentAt(0);
            if (component instanceof Container) {
                ((Container)component).setBlockFocus(false);
            }
            this.initTabsFocus();
        }
        this.checkTabsCanBeSeen();
    }

    protected void bindTabActionListener(Component tab, ActionListener l) {
        ((Button)tab).addActionListener(l);
    }

    public void setTabTitle(String title, Image icon, int index) {
        this.checkIndex(index);
        this.setTabTitle(this.tabsContainer.getComponentAt(index), title, icon);
    }

    protected void setTabTitle(Component tab, String title, Image icon) {
        Button b = (Button)tab;
        b.setText(title);
        b.setIcon(icon);
    }

    public String getTabTitle(int index) {
        this.checkIndex(index);
        return this.getTabTitle(this.tabsContainer.getComponentAt(index));
    }

    protected String getTabTitle(Component tab) {
        return ((Button)tab).getText();
    }

    protected Image getTabIcon(Component tab) {
        return ((Button)tab).getIcon();
    }

    public Image getTabIcon(int index) {
        this.checkIndex(index);
        return this.getTabIcon(this.tabsContainer.getComponentAt(index));
    }

    protected Image getTabSelectedIcon(Component tab) {
        return ((Button)tab).getPressedIcon();
    }

    public Image getTabSelectedIcon(int index) {
        this.checkIndex(index);
        return this.getTabSelectedIcon(this.tabsContainer.getComponentAt(index));
    }

    public void setTabSelectedIcon(int index, Image icon) {
        this.checkIndex(index);
        this.setTabSelectedIcon(this.tabsContainer.getComponentAt(index), icon);
    }

    protected void setTabSelectedIcon(Component tab, Image icon) {
        ((Button)tab).setPressedIcon(icon);
    }

    public void removeTabAt(int index) {
        this.checkIndex(index);
        int act = this.activeComponent - 1;
        act = Math.max(act, 0);
        this.setSelectedIndex(act);
        Component key = this.tabsContainer.getComponentAt(index);
        this.tabsContainer.removeComponent(key);
        Component content = this.contentPane.getComponentAt(index);
        this.contentPane.removeComponent(content);
        this.setTabsLayout(this.tabPlacement);
    }

    public Component getTabComponentAt(int index) {
        this.checkIndex(index);
        return this.contentPane.getComponentAt(index);
    }

    private void checkIndex(int index) {
        if (index < 0 || index > this.tabsContainer.getComponentCount()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
    }

    public int indexOfComponent(Component component) {
        return this.contentPane.getComponentIndex(component);
    }

    public int getTabCount() {
        return this.tabsContainer.getComponentCount();
    }

    public int getSelectedIndex() {
        if (this.tabsContainer != null) {
            return this.activeComponent;
        }
        return -1;
    }

    public Component getSelectedComponent() {
        int i = this.getSelectedIndex();
        if (i == -1) {
            return null;
        }
        return this.getTabComponentAt(i);
    }

    public void addTabsFocusListener(FocusListener listener) {
        if (this.focusListeners == null) {
            this.focusListeners = new EventDispatcher();
        }
        this.focusListeners.addListener(listener);
    }

    public void removeTabsFocusListener(FocusListener listener) {
        if (this.focusListeners != null) {
            this.focusListeners.removeListener(listener);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.selectionListener == null) {
            this.selectionListener = new EventDispatcher();
        }
        this.selectionListener.addListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.selectionListener != null) {
            this.selectionListener.removeListener(listener);
        }
    }

    public String toString() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        return className + "[x=" + this.getX() + " y=" + this.getY() + " width=" + this.getWidth() + " height=" + this.getHeight() + ", tab placement = " + this.tabPlacement + ", tab count = " + this.getTabCount() + ", selected index = " + this.getSelectedIndex() + "]";
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public Container getTabsContainer() {
        return this.tabsContainer;
    }

    public void setSelectedIndex(int index, boolean slideToSelected) {
        if (index < 0 || index >= this.tabsContainer.getComponentCount()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Tab count: " + this.tabsContainer.getComponentCount());
        }
        if (index == this.activeComponent) {
            return;
        }
        Form form = this.getComponentForm();
        if (slideToSelected && form != null) {
            int end = this.contentPane.getComponentAt(this.activeComponent).getX();
            int start = this.contentPane.getComponentAt(index).getX();
            this.slideToDestMotion = this.createTabSlideMotion(start, end);
            this.slideToDestMotion.start();
            form.registerAnimatedInternal(this);
            this.active = index;
        } else {
            if (this.selectionListener != null) {
                this.selectionListener.fireSelectionEvent(this.activeComponent, index);
            }
            this.activeComponent = index;
            this.selectTab(this.tabsContainer.getComponentAt(index));
            int offset = 0;
            for (Component c : this.contentPane) {
                c.setLightweightMode(offset != index);
                ++offset;
            }
            this.revalidateLater();
        }
    }

    protected void selectTab(Component tab) {
        Button b = (Button)tab;
        b.fireClicked();
        b.requestFocus();
    }

    public void setSelectedIndex(int index) {
        this.setSelectedIndex(index, false);
    }

    public void hideTabs() {
        this.removeComponent(this.tabsContainer);
        this.revalidateLater();
    }

    public void showTabs() {
        int tp = this.tabPlacement;
        this.tabPlacement = -1;
        this.setTabPlacement(tp);
        this.revalidateLater();
    }

    public boolean isSwipeActivated() {
        return this.swipeActivated;
    }

    public void setSwipeActivated(boolean swipeActivated) {
        if (this.swipeActivated != swipeActivated) {
            Form form;
            this.swipeActivated = swipeActivated;
            if (this.isInitialized() && (form = this.getComponentForm()) != null) {
                if (swipeActivated) {
                    form.addPointerPressedListener(this.press);
                    form.addPointerReleasedListener(this.release);
                    form.addPointerDraggedListener(this.drag);
                } else {
                    form.removePointerPressedListener(this.press);
                    form.removePointerReleasedListener(this.release);
                    form.removePointerDraggedListener(this.drag);
                }
            }
        }
    }

    private void initTabsFocus() {
        for (int i = 0; i < this.tabsContainer.getComponentCount(); ++i) {
            this.initTabFocus(this.tabsContainer.getComponentAt(i), this.contentPane.getComponentAt(this.activeComponent));
        }
    }

    private void initTabFocus(Component tab, Component content) {
        Component focus = null;
        if (content.isFocusable()) {
            focus = content;
        }
        if (content instanceof Container) {
            focus = ((Container)content).findFirstFocusable();
        }
    }

    public boolean isChangeTabOnFocus() {
        return this.changeTabOnFocus;
    }

    public void setChangeTabOnFocus(boolean changeTabOnFocus) {
        this.changeTabOnFocus = changeTabOnFocus;
    }

    public boolean isChangeTabContainerStyleOnFocus() {
        return this.changeTabContainerStyleOnFocus;
    }

    public void setChangeTabContainerStyleOnFocus(boolean changeTabContainerStyleOnFocus) {
        this.changeTabContainerStyleOnFocus = changeTabContainerStyleOnFocus;
    }

    public void setTabsContentGap(int tabsGap) {
        if (tabsGap < 0) {
            throw new IllegalArgumentException("gap must be positive");
        }
        this.tabsGap = tabsGap;
    }

    private void setTabsLayout(int tabPlacement) {
        if (tabPlacement == 0 || tabPlacement == 2) {
            if (this.tabsFillRows) {
                FlowLayout f = new FlowLayout();
                f.setFillRows(true);
                this.tabsContainer.setLayout(f);
            } else if (this.tabsGridLayout) {
                this.tabsContainer.setLayout(new GridLayout(1, Math.max(1, this.getTabCount())));
            } else {
                this.tabsContainer.setLayout(new BoxLayout(1));
            }
            this.tabsContainer.setScrollableX(true);
            this.tabsContainer.setScrollableY(false);
        } else {
            if (this.tabsGridLayout) {
                this.tabsContainer.setLayout(new GridLayout(Math.max(1, this.getTabCount()), 1));
            } else {
                this.tabsContainer.setLayout(new BoxLayout(2));
            }
            this.tabsContainer.setScrollableX(false);
            this.tabsContainer.setScrollableY(true);
        }
    }

    public String getTabUIID() {
        return this.tabUIID;
    }

    public void setTabUIID(String tabUIID) {
        this.tabUIID = tabUIID;
    }

    public boolean isEagerSwipeMode() {
        return this.eagerSwipeMode;
    }

    public void setEagerSwipeMode(boolean eagerSwipeMode) {
        this.eagerSwipeMode = eagerSwipeMode;
    }

    public boolean isAnimateTabSelection() {
        return this.animateTabSelection;
    }

    public void setAnimateTabSelection(boolean animateTabSelection) {
        this.animateTabSelection = animateTabSelection;
    }

    void initTabsContainerStyle() {
        if (this.originalTabsContainerSelected == null) {
            this.originalTabsContainerSelected = this.tabsContainer.getSelectedStyle();
            this.originalTabsContainerUnselected = this.tabsContainer.getUnselectedStyle();
        }
    }

    protected Motion createTabSlideMotion(int start, int end) {
        return Motion.createSplineMotion(start, end, this.getUIManager().getThemeConstant("tabsSlideSpeedInt", 200));
    }

    public String[] getPropertyNames() {
        return new String[]{"titles", "icons", "selectedIcons"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{CodenameOneImplementation.getStringArrayClass(), CodenameOneImplementation.getImageArrayClass(), CodenameOneImplementation.getImageArrayClass()};
    }

    public String[] getPropertyTypeNames() {
        return new String[]{"String[]", "Image[]", "Image[]"};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("titles")) {
            String[] t = new String[this.getTabCount()];
            for (int iter = 0; iter < t.length; ++iter) {
                t[iter] = this.getTabTitle(iter);
            }
            return t;
        }
        if (name.equals("icons")) {
            Image[] t = new Image[this.getTabCount()];
            for (int iter = 0; iter < t.length; ++iter) {
                t[iter] = this.getTabIcon(iter);
            }
            return t;
        }
        if (name.equals("selectedIcons")) {
            Image[] t = new Image[this.getTabCount()];
            for (int iter = 0; iter < t.length; ++iter) {
                t[iter] = this.getTabSelectedIcon(iter);
            }
            return t;
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("titles")) {
            String[] t = (String[])value;
            for (int iter = 0; iter < Math.min(this.getTabCount(), t.length); ++iter) {
                this.setTabTitle(t[iter], this.getTabIcon(iter), iter);
            }
            return null;
        }
        if (name.equals("icons")) {
            Image[] t = (Image[])value;
            if (t == null) {
                for (int iter = 0; iter < this.getTabCount(); ++iter) {
                    this.setTabTitle(this.getTabTitle(iter), null, iter);
                }
            } else {
                for (int iter = 0; iter < Math.min(this.getTabCount(), t.length); ++iter) {
                    this.setTabTitle(this.getTabTitle(iter), t[iter], iter);
                }
            }
            return null;
        }
        if (name.equals("selectedIcons")) {
            Image[] t = (Image[])value;
            for (int iter = 0; iter < Math.min(this.getTabCount(), t.length); ++iter) {
                this.setTabSelectedIcon(iter, t[iter]);
            }
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    static /* synthetic */ boolean access$1300(Tabs x0) {
        return x0.swipeActivated;
    }

    static /* synthetic */ Motion access$1400(Tabs x0) {
        return x0.slideToDestMotion;
    }

    static /* synthetic */ boolean access$1502(Tabs x0, boolean x1) {
        x0.blockSwipe = x1;
        return x0.blockSwipe;
    }

    static /* synthetic */ boolean access$1602(Tabs x0, boolean x1) {
        x0.riskySwipe = x1;
        return x0.riskySwipe;
    }

    static /* synthetic */ boolean access$1702(Tabs x0, boolean x1) {
        x0.doNotBlockSideSwipe = x1;
        return x0.doNotBlockSideSwipe;
    }

    static /* synthetic */ int access$1802(Tabs x0, int x1) {
        x0.lastX = x1;
        return x0.lastX;
    }

    static /* synthetic */ int access$1902(Tabs x0, int x1) {
        x0.initialX = x1;
        return x0.initialX;
    }

    static /* synthetic */ int access$2002(Tabs x0, int x1) {
        x0.initialY = x1;
        return x0.initialY;
    }

    static /* synthetic */ boolean access$2102(Tabs x0, boolean x1) {
        x0.dragStarted = x1;
        return x0.dragStarted;
    }

    static /* synthetic */ boolean access$1500(Tabs x0) {
        return x0.blockSwipe;
    }

    static /* synthetic */ boolean access$2100(Tabs x0) {
        return x0.dragStarted;
    }

    static /* synthetic */ boolean access$1600(Tabs x0) {
        return x0.riskySwipe;
    }

    static /* synthetic */ int access$1900(Tabs x0) {
        return x0.initialX;
    }

    static /* synthetic */ int access$2000(Tabs x0) {
        return x0.initialY;
    }

    static /* synthetic */ int access$1800(Tabs x0) {
        return x0.lastX;
    }

    static /* synthetic */ Motion access$1402(Tabs x0, Motion x1) {
        x0.slideToDestMotion = x1;
        return x0.slideToDestMotion;
    }

    class SwipeListener
    implements ActionListener {
        private static final int PRESS = 0;
        private static final int DRAG = 1;
        private static final int RELEASE = 2;
        private final int type;

        public SwipeListener(int type) {
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void actionPerformed(ActionEvent evt) {
            if (Tabs.this.getComponentCount() == 0 || !Tabs.access$1300(Tabs.this) || Tabs.access$1400(Tabs.this) != null) {
                return;
            }
            x = evt.getX();
            y = evt.getY();
            switch (this.type) {
                case 0: {
                    Tabs.access$1502(Tabs.this, false);
                    Tabs.access$1602(Tabs.this, false);
                    if (!Tabs.access$400(Tabs.this).visibleBoundsContains(x, y)) ** GOTO lbl52
                    testCmp = Tabs.access$400(Tabs.this).getComponentAt(x, y);
                    if (testCmp == null || testCmp == Tabs.access$400(Tabs.this)) ** GOTO lbl45
                    Tabs.access$1702(Tabs.this, true);
                    try {
                        while (testCmp != null && testCmp != Tabs.access$400(Tabs.this)) {
                            if (testCmp.shouldBlockSideSwipe()) {
                                Tabs.access$1802(Tabs.this, -1);
                                Tabs.access$1902(Tabs.this, -1);
                                Tabs.access$1502(Tabs.this, true);
                                return;
                            }
                            if (!testCmp.isScrollable()) ** GOTO lbl38
                            if (testCmp.isScrollableX()) {
                                Tabs.access$1802(Tabs.this, -1);
                                Tabs.access$1902(Tabs.this, -1);
                                Tabs.access$1502(Tabs.this, true);
                                return;
                            }
                            Tabs.access$1602(Tabs.this, true);
                            break;
lbl38:
                            // 1 sources

                            testCmp = testCmp.getParent();
                        }
                    }
                    finally {
                        Tabs.access$1702(Tabs.this, false);
                    }
lbl45:
                    // 3 sources

                    Tabs.access$1802(Tabs.this, x);
                    Tabs.access$1902(Tabs.this, x);
                    Tabs.access$2002(Tabs.this, y);
                    ** GOTO lbl60
lbl52:
                    // 1 sources

                    Tabs.access$1802(Tabs.this, -1);
                    Tabs.access$1902(Tabs.this, -1);
                    Tabs.access$2002(Tabs.this, -1);
                    Tabs.access$1502(Tabs.this, true);
lbl60:
                    // 2 sources

                    Tabs.access$2102(Tabs.this, false);
                    break;
                }
                case 1: {
                    if (Tabs.access$1500(Tabs.this)) {
                        return;
                    }
                    if (!Tabs.access$2100(Tabs.this)) {
                        if (Tabs.this.isEagerSwipeMode()) {
                            Tabs.access$2102(Tabs.this, true);
                        } else if (Tabs.access$1600(Tabs.this)) {
                            if (Math.abs(x - Tabs.access$1900(Tabs.this)) < Math.abs(y - Tabs.access$2000(Tabs.this))) {
                                return;
                            }
                            Tabs.access$2102(Tabs.this, Math.abs(x - Tabs.access$1900(Tabs.this)) > Tabs.access$400(Tabs.this).getWidth() / 5);
                        } else {
                            Tabs.access$2102(Tabs.this, Math.abs(x - Tabs.access$1900(Tabs.this)) > Tabs.access$400(Tabs.this).getWidth() / 8);
                            if (Tabs.access$2100(Tabs.this)) {
                                diff = x - Tabs.access$1900(Tabs.this);
                                if (Tabs.this.shouldBlockSideSwipeLeft() && diff < 0 || Tabs.this.shouldBlockSideSwipeRight() && diff > 0) {
                                    Tabs.access$1802(Tabs.this, -1);
                                    Tabs.access$1902(Tabs.this, -1);
                                    Tabs.access$2002(Tabs.this, -1);
                                    Tabs.access$1502(Tabs.this, true);
                                    Tabs.access$2102(Tabs.this, false);
                                    return;
                                }
                            }
                            parent = Tabs.this.getComponentForm();
                            parent.clearComponentsAwaitingRelease();
                        }
                    }
                    if (Tabs.access$1900(Tabs.this) == -1 || !Tabs.access$400(Tabs.this).contains(x, y) || (diffX = x - Tabs.access$1800(Tabs.this)) == 0 || !Tabs.access$2100(Tabs.this)) break;
                    Tabs.access$1802(Tabs.this, Tabs.access$1800(Tabs.this) + diffX);
                    size = Tabs.access$400(Tabs.this).getComponentCount();
                    for (i = 0; i < size; ++i) {
                        component = Tabs.access$400(Tabs.this).getComponentAt(i);
                        component.setX(component.getX() + diffX);
                        component.paintLock(false);
                    }
                    Container.enableLayoutOnPaint = false;
                    Tabs.this.repaint();
                    break;
                }
                case 2: {
                    if (Tabs.access$1000(Tabs.this)) {
                        Tabs.this.initTabsContainerStyle();
                        Tabs.access$300(Tabs.this).setUnselectedStyle(Tabs.access$1200(Tabs.this));
                        Tabs.access$300(Tabs.this).repaint();
                    }
                    if (Tabs.access$1500(Tabs.this)) {
                        return;
                    }
                    if (Tabs.access$1900(Tabs.this) != -1 && (diff = x - Tabs.access$1900(Tabs.this)) != 0 && Tabs.access$2100(Tabs.this)) {
                        if (Math.abs(diff) > Tabs.access$400(Tabs.this).getWidth() / 6) {
                            if (Tabs.this.isRTL()) {
                                diff *= -1;
                            }
                            if (diff > 0) {
                                Tabs.access$502(Tabs.this, Tabs.access$800(Tabs.this) - 1);
                                if (Tabs.access$500(Tabs.this) < 0) {
                                    Tabs.access$502(Tabs.this, 0);
                                }
                            } else {
                                Tabs.access$502(Tabs.this, Tabs.access$800(Tabs.this) + 1);
                                if (Tabs.access$500(Tabs.this) >= Tabs.access$400(Tabs.this).getComponentCount()) {
                                    Tabs.access$502(Tabs.this, Tabs.access$400(Tabs.this).getComponentCount() - 1);
                                }
                            }
                        }
                        start = Tabs.access$400(Tabs.this).getComponentAt(Tabs.access$500(Tabs.this)).getX();
                        end = Tabs.access$700(Tabs.this);
                        Tabs.access$1402(Tabs.this, Tabs.this.createTabSlideMotion(start, end));
                        Tabs.access$1400(Tabs.this).start();
                        form = Tabs.this.getComponentForm();
                        if (form != null) {
                            form.registerAnimatedInternal(Tabs.this);
                        }
                        evt.consume();
                    }
                    Tabs.access$1802(Tabs.this, -1);
                    Tabs.access$1902(Tabs.this, -1);
                    Tabs.access$2102(Tabs.this, false);
                }
            }
        }
    }

    class TabFocusListener
    implements FocusListener {
        TabFocusListener() {
        }

        public void focusGained(Component cmp) {
            if (Tabs.this.focusListeners != null) {
                Tabs.this.focusListeners.fireFocus(cmp);
            }
            if (Display.getInstance().shouldRenderSelection()) {
                if (Tabs.this.isChangeTabOnFocus() && !((Button)cmp).isSelected()) {
                    ((Button)cmp).fireClicked();
                }
                if (Tabs.this.changeTabContainerStyleOnFocus) {
                    Tabs.this.initTabsContainerStyle();
                    Tabs.this.tabsContainer.setUnselectedStyle(Tabs.this.originalTabsContainerSelected);
                    Tabs.this.tabsContainer.repaint();
                }
            }
        }

        public void focusLost(Component cmp) {
            if (Tabs.this.focusListeners != null) {
                Tabs.this.focusListeners.fireFocus(cmp);
            }
            if (Tabs.this.changeTabContainerStyleOnFocus) {
                Tabs.this.initTabsContainerStyle();
                Tabs.this.tabsContainer.setUnselectedStyle(Tabs.this.originalTabsContainerUnselected);
                Tabs.this.tabsContainer.repaint();
            }
        }
    }

    class TabsLayout
    extends Layout {
        TabsLayout() {
        }

        public void layoutContainer(Container parent) {
            int size = parent.getComponentCount();
            int tabWidth = parent.getWidth() - Tabs.this.tabsGap * 2;
            for (int i = 0; i < size; ++i) {
                int xOffset;
                if (parent.isRTL()) {
                    xOffset = (size - i) * tabWidth + Tabs.this.tabsGap;
                    xOffset -= (size - Tabs.this.activeComponent) * tabWidth;
                } else {
                    xOffset = i * tabWidth + Tabs.this.tabsGap;
                    xOffset -= Tabs.this.activeComponent * tabWidth;
                }
                Component component = parent.getComponentAt(i);
                component.setX(component.getStyle().getMarginLeftNoRTL() + xOffset);
                component.setY(component.getStyle().getMarginTop());
                component.setWidth(tabWidth - component.getStyle().getHorizontalMargins());
                component.setHeight(parent.getHeight() - component.getStyle().getVerticalMargins());
            }
        }

        public Dimension getPreferredSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.setWidth(parent.getWidth() + parent.getStyle().getPaddingLeftNoRTL() + parent.getStyle().getPaddingRightNoRTL());
            dim.setHeight(parent.getHeight() + parent.getStyle().getPaddingTop() + parent.getStyle().getPaddingBottom());
            int compCount = Tabs.this.contentPane.getComponentCount();
            for (int iter = 0; iter < compCount; ++iter) {
                Dimension d = Tabs.this.contentPane.getComponentAt(iter).getPreferredSizeWithMargin();
                dim.setWidth(Math.max(d.getWidth(), dim.getWidth()));
                dim.setHeight(Math.max(d.getHeight(), dim.getHeight()));
            }
            return dim;
        }
    }
}

