/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.scene;

import com.codename1.ui.Font;
import com.codename1.ui.Graphics;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.scene.Node;
import com.codename1.ui.scene.NodePainter;

public class TextPainter
implements NodePainter {
    private String text;
    private int vAlign = 4;

    public TextPainter(String text, int valign) {
        this.text = text;
        this.vAlign = valign;
    }

    public void paint(Graphics g, Rectangle bounds, Node node) {
        Style style = node.getStyle();
        if (style == null) {
            return;
        }
        Font font = style.getFont();
        if (font == null) {
            font = Font.getDefaultFont();
        }
        int textWidth = font.stringWidth(this.text);
        int textHeight = font.getHeight();
        int innerX = bounds.getX() + style.getPaddingLeft(false);
        int innerY = bounds.getY() + style.getPaddingTop();
        int innerW = bounds.getWidth() - style.getHorizontalPadding();
        int innerH = bounds.getHeight() - style.getVerticalPadding();
        int x = innerX;
        int y = innerY;
        switch (style.getAlignment()) {
            case 4: {
                x = innerX + innerW / 2 - textWidth / 2;
                break;
            }
            case 3: {
                x = innerX + innerW - textWidth;
            }
        }
        switch (this.vAlign) {
            case 4: {
                y = innerY + innerH / 2 - textHeight / 2;
                break;
            }
            case 2: {
                y = innerY + innerH - textHeight;
            }
        }
        g.setFont(font);
        g.setColor(style.getFgColor());
        g.drawString(this.text, x, y);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getvAlign() {
        return this.vAlign;
    }

    public void setvAlign(int vAlign) {
        this.vAlign = vAlign;
    }
}

