/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.impl.CodenameOneImplementation;
import com.codename1.ui.AnimationManager;
import com.codename1.ui.CN;
import com.codename1.ui.Component;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.LeadUtil;
import com.codename1.ui.animations.ComponentAnimation;
import com.codename1.ui.animations.Motion;
import com.codename1.ui.animations.Transition;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.FlowLayout;
import com.codename1.ui.layouts.LayeredLayout;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.plaf.LookAndFeel;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container
extends Component
implements Iterable<Component> {
    static boolean enableLayoutOnPaint = true;
    private boolean allowEnableLayoutOnPaint = false;
    private Component leadComponent;
    private Layout layout;
    private ArrayList<Component> components = new ArrayList();
    private ArrayList<QueuedChange> changeQueue = new ArrayList();
    private boolean shouldLayout = true;
    boolean scrollableX;
    boolean scrollableY;
    private Vector cmpTransitions;
    private int scrollIncrement = 20;
    private boolean blockFocus = false;
    private boolean dontRecurseContainer;
    private UIManager uiManager;
    private boolean surface;
    static int sidemenuBarTranslation;
    private boolean revalidatePending;
    static boolean blockOverdraw;
    private HashSet<Component> elevatedComponents;
    ArrayList<Component> _tmpRenderingElevatedComponents;
    private int nextElevationComponentIndex;
    private boolean safeArea;
    private boolean safeAreaRoot;
    private TmpInsets tmpInsets;
    private int doLayoutDepth;
    private TmpInsets calcTmpInsets;
    private int calcPreferredSizeDepth;

    public Container(Layout layout, String uiid) {
        this.setUIID(uiid);
        this.layout = layout;
        this.setFocusable(false);
    }

    public Container(Layout layout) {
        this(layout, "Container");
    }

    public Container() {
        this(new FlowLayout());
    }

    public static Container encloseIn(Layout l, Component cmp, Object cons) {
        Container cnt = new Container(l);
        if (cons instanceof Component) {
            return cnt.add(cmp).add((Component)cons);
        }
        if (cons != null) {
            cnt.addComponent(cons, cmp);
        } else {
            cnt.addComponent(cmp);
        }
        return cnt;
    }

    public static Container encloseIn(Layout l, Component ... cmp) {
        Container cnt = new Container(l);
        for (Component c : cmp) {
            cnt.addComponent(c);
        }
        return cnt;
    }

    @Override
    protected void initLaf(UIManager uim) {
        if (uim == this.getUIManager() && this.isInitialized()) {
            return;
        }
        super.initLaf(uim);
        LookAndFeel laf = uim.getLookAndFeel();
        this.setSmoothScrolling(laf.isDefaultSmoothScrolling());
        if (this.components != null) {
            int count = this.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component c = this.getComponentAt(i);
                c.initLaf(uim);
            }
        }
    }

    @Override
    public UIManager getUIManager() {
        if (this.uiManager != null) {
            return this.uiManager;
        }
        return super.getUIManager();
    }

    Container wrapInLayeredPane() {
        final Container oldParent = this.getParent();
        final Container newParent = new Container(new LayeredLayout());
        final Layout parentLayout = oldParent != null && oldParent.layout != null ? oldParent.layout : null;
        final Object constraint = parentLayout != null ? parentLayout.getComponentConstraint(this) : null;
        newParent.setParent(oldParent);
        newParent.components.add(this);
        final Runnable r = new Runnable(){

            public void run() {
                if (parentLayout != null) {
                    parentLayout.removeLayoutComponent(Container.this);
                    parentLayout.addLayoutComponent(constraint, newParent, oldParent);
                }
                newParent.initComponentImpl();
                if (oldParent != null) {
                    int cmpIndex = -1;
                    for (int i = 0; i < oldParent.getComponentCount(); ++i) {
                        Component c = oldParent.getComponentAt(i);
                        if (!c.equals(Container.this)) continue;
                        cmpIndex = i;
                        break;
                    }
                    if (cmpIndex == -1) {
                        throw new RuntimeException("WTF we have parent but no index!!!!");
                    }
                    oldParent.components.set(cmpIndex, newParent);
                }
                Container.this.setParent(newParent);
                newParent.revalidate();
            }
        };
        AnimationManager a = this.getAnimationManager();
        if (a != null && a.isAnimating()) {
            a.addAnimation(new ComponentAnimation(){

                public boolean isInProgress() {
                    return false;
                }

                protected void updateState() {
                    r.run();
                }
            });
            return newParent;
        }
        r.run();
        return newParent;
    }

    public boolean isSurface() {
        return this.surface;
    }

    @Override
    void setSurface(boolean surface) {
        block3: {
            block4: {
                if (surface == this.surface) break block3;
                this.surface = surface;
                if (surface) break block4;
                if (this.elevatedComponents == null || this.elevatedComponents.isEmpty()) break block3;
                ArrayList<Component> toProcess = new ArrayList<Component>(this.elevatedComponents);
                this.elevatedComponents.clear();
                for (Component elevated : toProcess) {
                    elevated.registerElevatedInternal(elevated);
                }
                break block3;
            }
            Container parentSurface = this.findSurface();
            if (parentSurface != null && parentSurface.elevatedComponents != null && !parentSurface.elevatedComponents.isEmpty()) {
                ArrayList<Component> toProcess = new ArrayList<Component>(parentSurface.elevatedComponents);
                for (Component elevated : toProcess) {
                    if (!this.contains(elevated)) continue;
                    elevated.registerElevatedInternal(elevated);
                }
            }
        }
    }

    public Container add(Component cmp) {
        this.addComponent(cmp);
        return this;
    }

    public Container addAll(Component ... cmps) {
        for (Component c : cmps) {
            this.addComponent(c);
        }
        return this;
    }

    public Container add(Object constraint, Component cmp) {
        this.addComponent(constraint, cmp);
        return this;
    }

    public Container add(String label) {
        return this.add(new Label(label));
    }

    public Container add(Image img) {
        return this.add(new Label(img));
    }

    public Container add(Object constraint, String label) {
        return this.add(constraint, new Label(label));
    }

    public Container add(Object constraint, Image img) {
        return this.add(constraint, new Label(img));
    }

    public void setUIManager(UIManager uiManager) {
        this.uiManager = uiManager;
    }

    public void setLeadComponent(Component lead) {
        if (lead == this.leadComponent) {
            return;
        }
        this.leadComponent = lead;
        if (lead == null) {
            if (this.isBlockLead() || this.getParent() == null || !this.getParent().hasLead) {
                this.setFocusable(false);
                this.hasLead = false;
                if (this.isInitialized()) {
                    this.enableFocusAndDeinitLead(this);
                }
            }
        } else if (this.isInitialized()) {
            this.initLead();
        }
    }

    @Override
    void focusGainedInternal() {
        super.focusGainedInternal();
        if (this.leadComponent != null) {
            this.setFocusLead(true);
        }
    }

    @Override
    void focusLostInternal() {
        super.focusLostInternal();
        if (this.leadComponent != null) {
            this.setFocusLead(false);
        }
    }

    @Override
    public Component getLeadComponent() {
        if (this.leadComponent != null) {
            return this.leadComponent;
        }
        if (this.isBlockLead()) {
            return null;
        }
        if (this.hasLead) {
            return super.getLeadComponent();
        }
        return null;
    }

    public Container getLeadParent() {
        if (this.leadComponent != null) {
            return this;
        }
        if (this.isBlockLead()) {
            return null;
        }
        if (this.hasLead) {
            return this.getParent().getLeadParent();
        }
        return null;
    }

    private void initLead() {
        this.disableFocusAndInitLead(this);
        this.setFocusable(true);
        this.hasLead = this.leadComponent != null || !this.isBlockLead();
    }

    @Override
    public void keyPressed(int k) {
        if (this.leadComponent != null) {
            this.leadComponent.keyPressed(k);
            this.repaint();
        }
    }

    @Override
    public void keyReleased(int k) {
        if (this.leadComponent != null) {
            this.leadComponent.keyReleased(k);
            this.repaint();
        }
    }

    private void disableFocusAndInitLead(Container c) {
        for (int iter = 0; iter < c.getComponentCount(); ++iter) {
            Component cu = c.getComponentAt(iter);
            boolean isContainer = cu instanceof Container;
            if (!cu.isBlockLead()) {
                cu.setFocusable(false);
            }
            if (isContainer) {
                cu.hasLead = ((Container)cu).leadComponent != null || !cu.isBlockLead();
            } else {
                boolean bl = cu.hasLead = !cu.isBlockLead();
            }
            if (!isContainer || !cu.hasLead) continue;
            this.disableFocusAndInitLead((Container)cu);
            if (((Container)cu).leadComponent == null) continue;
            ((Container)cu).setFocusable(true);
        }
    }

    private void enableFocusAndDeinitLead(Container c) {
        for (int iter = 0; iter < c.getComponentCount(); ++iter) {
            Component cu = c.getComponentAt(iter);
            boolean isContainer = cu instanceof Container;
            cu.hasLead = isContainer ? ((Container)cu).leadComponent != null : false;
            if (isContainer && !cu.hasLead) {
                this.enableFocusAndDeinitLead((Container)cu);
            }
            if (cu.hasLead) continue;
            cu.resetFocusable();
        }
    }

    public Layout getLayout() {
        return this.layout;
    }

    final Layout getActualLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        if (layout.isConstraintTracking()) {
            for (int iter = 0; iter < this.getComponentCount(); ++iter) {
                Component c = this.getComponentAt(iter);
                Object cons = this.layout.getComponentConstraint(c);
                if (cons == null) continue;
                layout.addLayoutComponent(cons, c, this);
            }
        }
        this.layout = layout;
        if (layout instanceof BorderLayout && this.isScrollable()) {
            this.setScrollable(false);
        }
    }

    public void invalidate() {
        this.setShouldCalcPreferredSize(true);
    }

    protected void setShouldLayout(boolean layout) {
        if (!this.shouldCalcScrollSize) {
            this.shouldCalcScrollSize = layout;
        }
        if (this.shouldLayout != layout) {
            this.shouldLayout = layout;
            this.shouldCalcPreferredSize = layout;
            this.shouldCalcScrollSize = layout;
            int componentCount = this.components.size();
            for (int iter = 0; iter < componentCount; ++iter) {
                Component cmp = this.components.get(iter);
                if (!(cmp instanceof Container)) continue;
                cmp.setShouldCalcPreferredSize(this.shouldCalcPreferredSize);
            }
            Container parent = this.getParent();
            if (parent != null) {
                parent.setShouldLayout(layout);
            }
        }
    }

    @Override
    public void setShouldCalcPreferredSize(boolean shouldCalcPreferredSize) {
        Container p;
        if (shouldCalcPreferredSize && this.shouldLayout && this.shouldCalcPreferredSize && !this.isInitialized() && (p = this.getParent()) != null && p.shouldLayout && p.shouldCalcPreferredSize) {
            return;
        }
        super.setShouldCalcPreferredSize(shouldCalcPreferredSize);
        this.shouldLayout = shouldCalcPreferredSize;
        if (this.shouldLayout) {
            int componentCount = this.components.size();
            for (int iter = 0; iter < componentCount; ++iter) {
                Component cmp = this.components.get(iter);
                if (!(cmp instanceof Container)) continue;
                ((Container)cmp).setShouldCalcPreferredSize(shouldCalcPreferredSize);
            }
        }
    }

    public int getLayoutWidth() {
        if (this.scrollableX) {
            return Math.max(this.getWidth(), this.getPreferredW());
        }
        Container parent = this.getScrollableParentX();
        if (parent != null && parent.scrollableX) {
            return Math.max(this.getWidth(), this.getPreferredW());
        }
        int width = this.getWidth();
        if (width <= 0) {
            return this.getPreferredW();
        }
        return width;
    }

    public int getLayoutHeight() {
        if (this.scrollableY) {
            return Math.max(this.getHeight(), this.getPreferredH());
        }
        Container parent = this.getScrollableParentY();
        if (parent != null && parent.scrollableY) {
            return Math.max(this.getHeight(), this.getPreferredH());
        }
        int height = this.getHeight();
        if (height <= 1) {
            return this.getPreferredH();
        }
        return height;
    }

    public void applyRTL(boolean rtl) {
        this.setRTL(rtl);
        int c = this.getComponentCount();
        for (int iter = 0; iter < c; ++iter) {
            Component current = this.getComponentAt(iter);
            if (current instanceof Container) {
                ((Container)current).applyRTL(rtl);
                continue;
            }
            current.setRTL(rtl);
        }
    }

    private Container getScrollableParentX() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.scrollableX && !parent.constrainWidthWhenScrollable()) {
                return parent;
            }
            if (!parent.hasFixedPreferredSize()) continue;
            return parent;
        }
        return null;
    }

    private Container getScrollableParentY() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.scrollableY && !parent.constrainHeightWhenScrollable()) {
                return parent;
            }
            if (!parent.hasFixedPreferredSize()) continue;
            return parent;
        }
        return null;
    }

    protected boolean constrainWidthWhenScrollable() {
        return false;
    }

    protected boolean constrainHeightWhenScrollable() {
        return false;
    }

    public void addComponent(Component cmp) {
        this.layout.addLayoutComponent(null, cmp, this);
        this.insertComponentAt(Integer.MAX_VALUE, null, cmp);
    }

    public void addComponent(Object constraints, Component cmp) {
        this.layout.addLayoutComponent(constraints, cmp, this);
        this.insertComponentAt(Integer.MAX_VALUE, null, cmp);
    }

    public void addComponent(int index, Object constraints, Component cmp) {
        this.insertComponentAt(index, constraints, cmp);
    }

    void insertComponentAt(final int index, final Object constraint, final Component cmp) {
        AnimationManager a = this.getAnimationManager();
        if (a != null && a.isAnimating()) {
            if (cmp.getParent() != null) {
                throw new IllegalArgumentException("Component is already contained in Container: " + cmp.getParent());
            }
            cmp.setParent(this);
            final QueuedInsertion insertion = new QueuedInsertion(index, constraint, cmp);
            this.changeQueue.add(insertion);
            a.addAnimation(new ComponentAnimation(){
                private boolean alreadyAdded;

                public boolean isInProgress() {
                    return false;
                }

                protected void updateState() {
                    if (!this.alreadyAdded) {
                        try {
                            this.alreadyAdded = true;
                            cmp.setParent(null);
                            if (constraint != null) {
                                Container.this.layout.addLayoutComponent(constraint, cmp, Container.this);
                            }
                            Container.this.insertComponentAtImpl(index, cmp);
                        }
                        finally {
                            Container.this.changeQueue.remove(insertion);
                        }
                        Container.this.revalidateLater();
                    }
                }

                public void flush() {
                    this.updateState();
                }
            });
        } else {
            if (constraint != null) {
                this.layout.addLayoutComponent(constraint, cmp, this);
            }
            this.insertComponentAtImpl(index, cmp);
        }
    }

    void insertComponentAtImpl(int index, final Component cmp) {
        Component overlay;
        UIManager manager;
        if (index == Integer.MAX_VALUE) {
            index = this.components.size();
        }
        if (cmp.getParent() != null) {
            throw new IllegalArgumentException("Component is already contained in Container: " + cmp.getParent());
        }
        if (cmp instanceof Form) {
            cmp.setVisible(true);
            cmp.setPreferredSize(null);
        }
        boolean refreshLaf = (manager = this.getUIManager()) != cmp.getUIManager();
        cmp.setParent(this);
        if (refreshLaf) {
            Display.getInstance().callSerially(new Runnable(){

                public void run() {
                    cmp.refreshTheme(false);
                }
            });
        }
        this.components.add(index, cmp);
        if (this.layout instanceof BorderLayout && !"Overlay".equals(this.layout.getComponentConstraint(cmp)) && (overlay = ((BorderLayout)this.layout).getOverlay()) != null) {
            this.components.remove(overlay);
            this.components.add(index, overlay);
        }
        this.setShouldCalcPreferredSize(true);
        if (this.isInitialized()) {
            cmp.initComponentImpl();
        }
    }

    public void addComponent(int index, Component cmp) {
        this.insertComponentAt(index, null, cmp);
    }

    public void replaceAndWait(Component current, Component next, Transition t) {
        this.replaceComponents(current, next, t, true, false, null, 0, 0, true);
    }

    public void replaceAndWait(Component current, Component next, Transition t, int layoutAnimationSpeed) {
        enableLayoutOnPaint = false;
        this.replaceComponents(current, next, t, true, false, null, 0, layoutAnimationSpeed, true);
        if (layoutAnimationSpeed > 0) {
            this.animateLayoutAndWait(layoutAnimationSpeed);
        }
        this.dontRecurseContainer = false;
        enableLayoutOnPaint = true;
    }

    public void replace(Component current, Component next, Transition t, Runnable onFinish, int growSpeed) {
        this.replaceComponents(current, next, t, false, false, onFinish, growSpeed, 0, true);
    }

    public void replaceAndWait(Component current, Component next, Transition t, boolean dropEvents) {
        this.replaceComponents(current, next, t, true, dropEvents, null, 0, 0, true);
    }

    public void replace(Component current, Component next, Transition t) {
        this.replaceComponents(current, next, t, false, false, null, 0, 0, true);
    }

    public ComponentAnimation createReplaceTransition(Component current, Component next, Transition t) {
        return this.replaceComponents(current, next, t, false, false, null, 0, 0, false);
    }

    private ComponentAnimation replaceComponents(Component current, Component next, Transition t, boolean wait, boolean dropEvents, Runnable onFinish, int growSpeed, int layoutAnimationSpeed, boolean addAnimtion) {
        if (!this.contains(current)) {
            throw new IllegalArgumentException("Component " + current + " is not contained in this Container");
        }
        if (t == null || !this.isVisible() || this.getComponentForm() == null) {
            next.setX(current.getX());
            next.setY(current.getY());
            next.setWidth(current.getWidth());
            next.setHeight(current.getHeight());
            this.replace(current, next, false);
            return null;
        }
        this.setScrollX(0);
        this.setScrollY(0);
        next.setX(current.getX());
        next.setY(current.getY());
        next.setWidth(current.getWidth());
        next.setHeight(current.getHeight());
        next.setParent(this);
        if (next instanceof Container) {
            ((Container)next).layoutContainer();
        }
        TransitionAnimation anim = new TransitionAnimation(this, current, next, t);
        anim.growSpeed = growSpeed;
        anim.layoutAnimationSpeed = layoutAnimationSpeed;
        if (addAnimtion) {
            if (wait) {
                this.getAnimationManager().addAnimationAndBlock(anim);
            } else if (onFinish != null) {
                this.getAnimationManager().addUIMutation(this, anim, onFinish);
            } else {
                this.getAnimationManager().addUIMutation(this, anim);
            }
        }
        return anim;
    }

    private boolean isParentOf(Component c) {
        if ((c = c.getParent()) == null || c instanceof Form) {
            return false;
        }
        return c == this || this.isParentOf(c);
    }

    @Override
    void onParentPositionChange() {
        int cmpCount = this.getComponentCount();
        for (int iter = 0; iter < cmpCount; ++iter) {
            Component c = this.getComponentAt(iter);
            c.onParentPositionChange();
        }
    }

    @Override
    boolean onOrientationChange() {
        boolean v = super.onOrientationChange();
        int cmpCount = this.getComponentCount();
        for (int iter = 0; iter < cmpCount; ++iter) {
            Component c = this.getComponentAt(iter);
            v = c.onOrientationChange() || v;
        }
        return v;
    }

    private boolean requestFocusChild(boolean avoidRepaint) {
        int cmpCount = this.getComponentCount();
        for (int iter = 0; iter < cmpCount; ++iter) {
            Component c = this.getComponentAt(iter);
            if (c.isFocusable()) {
                if (avoidRepaint) {
                    this.getComponentForm().setFocusedInternal(c);
                } else {
                    c.requestFocus();
                }
                return true;
            }
            if (!(c instanceof Container) || !((Container)c).requestFocusChild(avoidRepaint)) continue;
            return true;
        }
        return false;
    }

    private void cancelRepaintsRecursively(Component c, CodenameOneImplementation l) {
        if (c instanceof Container) {
            Container cnt = (Container)c;
            int count = cnt.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this.cancelRepaintsRecursively(cnt.getComponentAt(i), l);
            }
        }
        l.cancelRepaint(c);
    }

    private void cancelRepaintsRecursively(Component c) {
        this.cancelRepaintsRecursively(c, Display.impl);
    }

    void replace(Component current, Component next, boolean avoidRepaint) {
        Object constraint;
        int index = this.components.indexOf(current);
        boolean currentFocused = false;
        if (current.getComponentForm() != null) {
            Component currentF = current.getComponentForm().getFocused();
            boolean bl = currentFocused = currentF == current;
            if (!currentFocused && current instanceof Container && currentF != null && ((Container)current).isParentOf(currentF)) {
                currentFocused = true;
            }
        }
        if ((constraint = this.layout.getComponentConstraint(current)) != null) {
            this.removeComponentImplNoAnimationSafety(current);
            this.layout.addLayoutComponent(constraint, next, this);
        } else {
            this.removeComponentImplNoAnimationSafety(current);
        }
        this.cancelRepaintsRecursively(current);
        next.setParent(null);
        if (index < 0) {
            index = 0;
        }
        this.insertComponentAtImpl(index, next);
        if (currentFocused) {
            if (next.isFocusable()) {
                if (avoidRepaint) {
                    this.getComponentForm().setFocusedInternal(next);
                } else {
                    next.requestFocus();
                }
            } else if (next instanceof Container) {
                ((Container)next).requestFocusChild(avoidRepaint);
            }
        }
    }

    @Override
    void initComponentImpl() {
        Container p;
        if (!this.isInitialized()) {
            super.initComponentImpl();
        }
        if ((p = this.getParent()) != null) {
            this.allowEnableLayoutOnPaint = p.allowEnableLayoutOnPaint;
        }
        int componentCount = this.components.size();
        for (int iter = 0; iter < componentCount; ++iter) {
            Component cmp = this.components.get(iter);
            cmp.initComponentImpl();
        }
        if (this.leadComponent != null) {
            this.initLead();
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.leadComponent != null && this.leadComponent != this) {
            return this.leadComponent.isEnabled();
        }
        return super.isEnabled();
    }

    public void removeComponent(Component cmp) {
        this.removeComponentImpl(cmp);
    }

    void setComponentIndex(Component cmp, int location) {
        if (location < this.components.size()) {
            this.components.remove(cmp);
            this.components.add(location, cmp);
        }
    }

    void removeComponentImpl(final Component cmp) {
        AnimationManager a = this.getAnimationManager();
        if (a != null && a.isAnimating()) {
            this.layout.removeLayoutComponent(cmp);
            cmp.setParent(null);
            final QueuedRemoval removed = new QueuedRemoval(cmp);
            this.changeQueue.add(removed);
            a.addAnimation(new ComponentAnimation(){
                private boolean alreadyRemoved;

                public boolean isInProgress() {
                    return false;
                }

                protected void updateState() {
                    if (!this.alreadyRemoved) {
                        try {
                            this.alreadyRemoved = true;
                            Container.this.removeComponentImplNoAnimationSafety(cmp);
                        }
                        finally {
                            Container.this.changeQueue.remove(removed);
                        }
                        Container.this.revalidateLater();
                    }
                }

                public void flush() {
                    this.updateAnimationState();
                }
            });
        } else {
            this.removeComponentImplNoAnimationSafety(cmp);
        }
    }

    void removeComponentImplNoAnimationSafety(Component cmp) {
        Form parentForm = this.getComponentForm();
        this.layout.removeLayoutComponent(cmp);
        cmp.setParent(this);
        cmp.deinitializeImpl();
        this.components.remove(cmp);
        cmp.setParent(null);
        if (parentForm != null) {
            Component dragged;
            if (parentForm.getFocused() == cmp || cmp instanceof Container && ((Container)cmp).contains(parentForm.getFocused())) {
                parentForm.setFocusedInternal(null);
            }
            if ((dragged = parentForm.getDraggedComponent()) == cmp) {
                parentForm.setDraggedComponent(null);
            }
            if (cmp.isSmoothScrolling()) {
                parentForm.deregisterAnimatedInternal(cmp);
            }
        }
        cmp.cancelRepaints();
        if (cmp instanceof Form) {
            cmp.setVisible(false);
        }
        this.setShouldCalcPreferredSize(true);
        Display.impl.componentRemoved(cmp);
    }

    @Override
    protected void cancelRepaints() {
        super.cancelRepaints();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponentAt(i);
            c.cancelRepaints();
        }
    }

    @Override
    void deinitializeImpl() {
        super.deinitializeImpl();
        int componentCount = this.components.size();
        for (int iter = 0; iter < componentCount; ++iter) {
            Component cmp = this.components.get(iter);
            cmp.deinitializeImpl();
        }
        this.flushReplace();
    }

    public void flushReplace() {
    }

    public void removeAll() {
        Component[] arr;
        boolean includeQueued;
        Component focus;
        Form parentForm = this.getComponentForm();
        if (parentForm != null && (focus = parentForm.getFocused()) != null && this.contains(focus)) {
            parentForm.setFocused(null);
        }
        if (includeQueued = true) {
            List<Component> l = this.getChildrenAsList(includeQueued);
            arr = new Component[l.size()];
            l.toArray(arr);
        } else {
            arr = new Component[this.components.size()];
            this.components.toArray(arr);
        }
        for (Component cmp : arr) {
            this.removeComponent(cmp);
        }
        this.resetScroll();
    }

    public void revalidateWithAnimationSafety() {
        if (this.revalidatePending) {
            return;
        }
        this.revalidatePending = true;
        AnimationManager mgr = this.getAnimationManager();
        if (mgr == null) {
            this.revalidatePending = false;
            this.revalidate();
            return;
        }
        if (mgr.isAnimating()) {
            mgr.flushAnimation(new Runnable(){

                public void run() {
                    Container.this.revalidatePending = false;
                    Container.this.revalidate();
                }
            });
        } else {
            this.revalidatePending = false;
            this.revalidate();
        }
    }

    void revalidateWithAnimationSafetyInternal(final boolean fromRoot) {
        if (this.revalidatePending) {
            return;
        }
        this.revalidatePending = true;
        AnimationManager mgr = this.getAnimationManager();
        if (mgr == null) {
            this.revalidatePending = false;
            this.revalidateInternal(fromRoot);
            return;
        }
        if (mgr.isAnimating()) {
            mgr.flushAnimation(new Runnable(){

                public void run() {
                    Container.this.revalidatePending = false;
                    Container.this.revalidateInternal(fromRoot);
                }
            });
        } else {
            this.revalidatePending = false;
            this.revalidateInternal(fromRoot);
        }
    }

    public void revalidate() {
        this.revalidateInternal(true);
    }

    void revalidateInternal(boolean fromRoot) {
        this.setShouldCalcPreferredSize(true);
        Form root = this.getComponentForm();
        if (root != null && root != this) {
            root.removeFromRevalidateQueue(this);
            if (fromRoot && root.revalidateFromRoot) {
                root.layoutContainer();
                root.repaint();
                if (this.getParent() != null) {
                    this.getParent().shouldLayout = true;
                    this.getParent().layoutContainer();
                } else {
                    this.layoutContainer();
                }
            } else {
                this.layoutContainer();
                this.repaint();
            }
        } else {
            this.layoutContainer();
            this.repaint();
        }
    }

    public void revalidateLater() {
        Form root = this.getComponentForm();
        if (root != null) {
            root.revalidateLater(this);
        }
    }

    public void forceRevalidate() {
        this.forceRevalidateImpl();
        this.revalidate();
    }

    private void forceRevalidateImpl() {
        this.setShouldCalcPreferredSize(true);
        int c = this.getComponentCount();
        for (int iter = 0; iter < c; ++iter) {
            Component cmp = this.getComponentAt(iter);
            if (cmp instanceof Container) {
                ((Container)cmp).forceRevalidateImpl();
                continue;
            }
            cmp.setShouldCalcPreferredSize(true);
        }
    }

    @Override
    public void clearClientProperties() {
        super.clearClientProperties();
        int c = this.getComponentCount();
        for (int iter = 0; iter < c; ++iter) {
            Component cmp = this.getComponentAt(iter);
            cmp.clearClientProperties();
        }
    }

    private void paintContainerChildrenForAnimation(Container cnt, Graphics g) {
        int ourX = this.getAbsoluteX();
        int ourY = this.getAbsoluteY();
        int cc = cnt.getComponentCount();
        for (int iter = 0; iter < cc; ++iter) {
            Component cmp = cnt.getComponentAt(iter);
            if (cmp.getClass() == Container.class) {
                this.paintContainerChildrenForAnimation((Container)cmp, g);
                continue;
            }
            int abx = cmp.getAbsoluteX();
            int aby = cmp.getAbsoluteY();
            int oldX = cmp.getX();
            int oldY = cmp.getY();
            cmp.setParent(this);
            cmp.setX(abx - ourX);
            cmp.setY(aby - ourY);
            cmp.paintInternal(g, false);
            cmp.setParent(cnt);
            cmp.setX(oldX);
            cmp.setY(oldY);
        }
    }

    boolean isObscuredByChildren() {
        if (!blockOverdraw) {
            return false;
        }
        if (!this.getLayout().obscuresPotential(this)) {
            return false;
        }
        Style s = this.getStyle();
        if (s.getPaddingTop() != 0 || s.getPaddingLeftNoRTL() != 0 || s.getPaddingRightNoRTL() != 0 || s.getPaddingBottom() != 0) {
            return false;
        }
        int size = this.components.size();
        for (int iter = 0; iter < size; ++iter) {
            Component cmp = this.components.get(iter);
            s = cmp.getStyle();
            if (cmp.getWidth() == 0 || cmp.getHeight() == 0) continue;
            if (cmp instanceof Container) {
                if (!((Container)cmp).getLayout().obscuresPotential(this)) {
                    return false;
                }
                if (s.getOpacity() != 255 || s.getMarginTop() != 0 || s.getMarginLeftNoRTL() != 0 || s.getMarginRightNoRTL() != 0 || s.getMarginBottom() != 0) {
                    return false;
                }
                if ((s.getBgTransparency() & 0xFF) == 255 || ((Container)cmp).isObscuredByChildren()) continue;
                return false;
            }
            if ((s.getBgTransparency() & 0xFF) == 255 && s.getOpacity() == 255 && s.getMarginTop() == 0 && s.getMarginLeftNoRTL() == 0 && s.getMarginRightNoRTL() == 0 && s.getMarginBottom() == 0) continue;
            return false;
        }
        return true;
    }

    private int calculateFirstPaintableOffset(int clipX1, int clipY1, int clipX2, int clipY2) {
        int len = this.components.size();
        Layout l = this.getLayout();
        if (l.getClass() == BoxLayout.class && ((BoxLayout)l).getAxis() == 2) {
            int startPos = this.binarySearchFirstIntersectionY(clipY1, clipY2, 0, len);
            if (startPos >= 0) {
                return startPos;
            }
            return len;
        }
        return -1;
    }

    private int calculateLastPaintableOffset(int pos, int clipX1, int clipY1, int clipX2, int clipY2) {
        int len = this.components.size();
        if (pos >= len - 1) {
            return len - 1;
        }
        Layout l = this.getLayout();
        if (l.getClass() == BoxLayout.class && ((BoxLayout)l).getAxis() == 2) {
            Component c = null;
            int cy1 = -1;
            int end = len - 1;
            ++pos;
            do {
                c = this.components.get(pos);
                cy1 = c.getBounds().getY();
            } while (++pos <= end && cy1 <= clipY2);
            return pos - 1;
        }
        return len - 1;
    }

    private int binarySearchFirstIntersectionY(int y1, int y2, int start, int end) {
        if (start >= end) {
            return -1;
        }
        int pos = (start + end) / 2;
        Component c = this.components.get(pos);
        Rectangle bounds = c.getBounds();
        int cy1 = bounds.getY();
        int cy2 = bounds.getY() + bounds.getHeight();
        if (cy1 >= y1 && cy1 <= y2 || cy2 >= y1 && cy2 <= y2 || cy1 <= y1 && cy2 >= y2) {
            while (pos > start && cy1 > y1) {
                c = this.components.get(--pos);
                cy1 = c.getBounds().getY();
            }
            return pos;
        }
        if (cy1 > y2) {
            return this.binarySearchFirstIntersectionY(y1, y2, start, pos);
        }
        return this.binarySearchFirstIntersectionY(y1, y2, pos + 1, end);
    }

    void setAllowEnableLayoutOnPaint(boolean allow) {
        this.allowEnableLayoutOnPaint = allow;
    }

    void addElevatedComponent(Component cmp) {
        if (this.elevatedComponents == null) {
            this.elevatedComponents = new HashSet();
        }
        this.elevatedComponents.add(cmp);
    }

    void removeElevatedComponent(Component cmp) {
        if (this.elevatedComponents == null) {
            return;
        }
        this.elevatedComponents.remove(cmp);
    }

    void paintElevatedPane(Graphics g) {
        this.nextElevationComponentIndex = 0;
        this.paintElevatedPane(g, false, -1, -1, -1, -1, -1, -1, false);
    }

    void paintElevatedPane(Graphics g, boolean useIntersection, int intersectionX, int intersectionY, int intersectionWidth, int intersectionHeight, int elevationThreshold, int elevationComponentIndexThreshold, boolean above) {
        CodenameOneImplementation impl = Display.impl;
        int absX = this.getAbsoluteX();
        int absY = this.getAbsoluteY();
        g.translate(-absX, -absY);
        if (this.elevatedComponents != null && !this.elevatedComponents.isEmpty()) {
            if (this._tmpRenderingElevatedComponents == null) {
                this._tmpRenderingElevatedComponents = new ArrayList<Component>(this.elevatedComponents);
            } else {
                this._tmpRenderingElevatedComponents.clear();
                this._tmpRenderingElevatedComponents.addAll(this.elevatedComponents);
            }
            Collections.sort(this._tmpRenderingElevatedComponents, new Comparator<Component>(){

                @Override
                public int compare(Component o1, Component o2) {
                    int e2;
                    int e1 = o1.getStyle().getElevation();
                    if (e1 < (e2 = o2.getStyle().getElevation())) {
                        return -1;
                    }
                    if (e1 > e2) {
                        return 1;
                    }
                    return o1.renderedElevationComponentIndex - o2.renderedElevationComponentIndex;
                }
            });
            block0: for (Component child : this._tmpRenderingElevatedComponents) {
                int shadowH;
                int shadowW;
                int relativeX = child.getRelativeX(this) + child.getScrollX();
                int relativeY = child.getRelativeY(this) + child.getScrollY();
                int clipX = g.getClipX();
                int clipW = g.getClipWidth();
                int shadowX = relativeX + child.calculateShadowOffsetX();
                if (shadowX + (shadowW = child.calculateShadowWidth()) <= clipX || shadowX >= clipX + clipW) continue;
                int clipY = g.getClipY();
                int clipH = g.getClipHeight();
                int shadowY = relativeY + child.calculateShadowOffsetY();
                if (shadowY + (shadowH = child.calculateShadowHeight()) <= clipY || shadowY >= clipY + clipH) continue;
                if (!useIntersection || Rectangle.intersects(child.getAbsoluteX() + child.getScrollX() + child.calculateShadowOffsetX(), child.getAbsoluteY() + child.getScrollY() + child.calculateShadowOffsetY(), child.calculateShadowWidth(), child.calculateShadowHeight(), intersectionX, intersectionY, intersectionWidth, intersectionHeight)) {
                    if (!useIntersection) {
                        child.renderedElevation = child.getStyle().getElevation();
                        ++this.nextElevationComponentIndex;
                        child.renderedElevationComponentIndex = child.renderedElevationComponentIndex;
                    }
                    if (!useIntersection || elevationThreshold < 0 || above && (elevationThreshold < child.renderedElevation || elevationThreshold == child.renderedElevation && elevationComponentIndexThreshold < child.renderedElevationComponentIndex) || !above && (elevationThreshold > child.renderedElevation || elevationThreshold == child.renderedElevation && elevationComponentIndexThreshold > child.renderedElevationComponentIndex)) {
                        g.translate(absX, absY);
                        child.paintShadows(impl.getComponentScreenGraphics(this, g), child.getRelativeX(this), child.getRelativeY(this));
                        g.translate(-absX, -absY);
                        int tx = child.getParent().getRelativeX(this) + child.getScrollX();
                        int ty = child.getParent().getRelativeY(this) + child.getScrollY();
                        g.translate(tx, ty);
                        child.paintInternal(impl.getComponentScreenGraphics(this, g), false);
                        g.translate(-tx, -ty);
                    }
                }
                Component currCmp = child;
                boolean foundOverlap = false;
                for (Container cnt = child.getParent(); cnt != this && cnt != null; cnt = cnt.getParent()) {
                    int currCmpIndex;
                    Layout cntLayout = cnt.getLayout();
                    if (!foundOverlap && cntLayout.isOverlapSupported()) {
                        foundOverlap = true;
                    }
                    if (foundOverlap && (currCmpIndex = cnt.getComponentIndex(currCmp)) >= 0) {
                        int count = cnt.getComponentCount();
                        for (int i = currCmpIndex + 1; i < count; ++i) {
                            Component cntChild = cnt.getComponentAt(i);
                            if (this.elevatedComponents.contains(cntChild)) continue block0;
                            if (useIntersection && !Rectangle.intersects(cntChild.getAbsoluteX() + cntChild.getScrollX(), cntChild.getAbsoluteY() + cntChild.getScrollY(), cntChild.getWidth(), cntChild.getHeight(), intersectionX, intersectionY, intersectionWidth, intersectionHeight)) continue;
                            if (!useIntersection) {
                                cntChild.renderedElevation = child.renderedElevation;
                                ++this.nextElevationComponentIndex;
                                cntChild.renderedElevationComponentIndex = cntChild.renderedElevationComponentIndex;
                            }
                            if (useIntersection && elevationThreshold >= 0 && (!above || elevationThreshold >= cntChild.renderedElevation && (elevationThreshold != cntChild.renderedElevation || elevationComponentIndexThreshold >= cntChild.renderedElevationComponentIndex)) && (above || elevationThreshold <= cntChild.renderedElevation && (elevationThreshold != cntChild.renderedElevation || elevationComponentIndexThreshold <= cntChild.renderedElevationComponentIndex))) continue;
                            int tx = cntChild.getParent().getRelativeX(this) + cntChild.getParent().getScrollX();
                            int ty = cntChild.getParent().getRelativeY(this) + cntChild.getParent().getScrollY();
                            g.translate(tx, ty);
                            cntChild.paintInternal(impl.getComponentScreenGraphics(this, g), false);
                            g.translate(-tx, -ty);
                        }
                    }
                    currCmp = cnt;
                }
            }
        }
        g.translate(absX, absY);
    }

    void markComponentsToBePaintedInElevatedPane(boolean shouldPaintInElevatedPane) {
        if (this.elevatedComponents != null && !this.elevatedComponents.isEmpty()) {
            block0: for (Component child : this.elevatedComponents) {
                child.doNotPaint = shouldPaintInElevatedPane;
                Component currCmp = child;
                boolean foundOverlap = false;
                for (Container cnt = child.getParent(); cnt != this && cnt != null; cnt = cnt.getParent()) {
                    int currCmpIndex;
                    Layout cntLayout = cnt.getLayout();
                    if (!foundOverlap && cntLayout.isOverlapSupported()) {
                        foundOverlap = true;
                    }
                    if (foundOverlap && (currCmpIndex = cnt.getComponentIndex(currCmp)) >= 0) {
                        int count = cnt.getComponentCount();
                        for (int i = currCmpIndex + 1; i < count; ++i) {
                            Component cntChild = cnt.getComponentAt(i);
                            if (this.elevatedComponents.contains(cntChild)) continue block0;
                            child.doNotPaint = shouldPaintInElevatedPane;
                        }
                    }
                    currCmp = cnt;
                }
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        int iter;
        if (this.allowEnableLayoutOnPaint && enableLayoutOnPaint) {
            this.layoutContainer();
        }
        g.translate(this.getX(), this.getY());
        int size = this.components.size();
        int startIter = 0;
        if (size >= 30) {
            int clipY2;
            int clipX1 = g.getClipX();
            int clipX2 = g.getClipX() + g.getClipWidth();
            int clipY1 = g.getClipY();
            startIter = this.calculateFirstPaintableOffset(clipX1, clipY1, clipX2, clipY2 = g.getClipY() + g.getClipHeight());
            if (startIter < 0) {
                startIter = 0;
            } else if (startIter < size) {
                size = this.calculateLastPaintableOffset(startIter, clipX1, clipY1, clipX2, clipY2) + 1;
            }
        }
        if (this.isSurface() && this.elevatedComponents != null && !this.elevatedComponents.isEmpty()) {
            this.markComponentsToBePaintedInElevatedPane(true);
        }
        CodenameOneImplementation impl = Display.impl;
        if (this.dontRecurseContainer) {
            for (iter = startIter; iter < size; ++iter) {
                Component cmp = this.components.get(iter);
                if (cmp.getClass() == Container.class) {
                    this.paintContainerChildrenForAnimation((Container)cmp, g);
                    continue;
                }
                cmp.paintInternal(impl.getComponentScreenGraphics(this, g), false);
            }
        } else {
            for (iter = startIter; iter < size; ++iter) {
                Component cmp = this.components.get(iter);
                cmp.paintInternal(impl.getComponentScreenGraphics(this, g), false);
            }
        }
        if (this.isSurface() && this.elevatedComponents != null && !this.elevatedComponents.isEmpty()) {
            this.markComponentsToBePaintedInElevatedPane(false);
            this.paintElevatedPane(g);
        }
        int tx = g.getTranslateX();
        int ty = g.getTranslateY();
        g.translate(-tx, -ty);
        if (sidemenuBarTranslation > 0) {
            g.translate(sidemenuBarTranslation, 0);
            this.paintGlass(g);
            this.paintTensile(g);
            g.translate(-sidemenuBarTranslation, 0);
        } else {
            this.paintGlass(g);
            this.paintTensile(g);
        }
        g.translate(tx, ty);
        g.translate(-this.getX(), -this.getY());
    }

    protected void paintGlass(Graphics g) {
    }

    @Override
    void paintGlassImpl(Graphics g) {
        super.paintGlassImpl(g);
        this.paintGlass(g);
    }

    void paintIntersecting(Graphics g, Component cmp, int x, int y, int w, int h, boolean above, int elevation) {
        if (this.layout.isOverlapSupported() && cmp.getParent() == this) {
            int endIndex;
            int startIndex;
            int indexOfComponent = this.components.indexOf(cmp);
            if (above) {
                startIndex = indexOfComponent + 1;
                endIndex = this.components.size();
            } else {
                startIndex = 0;
                endIndex = indexOfComponent;
            }
            for (int i = startIndex; i < endIndex; ++i) {
                Component cmp2 = this.components.get(i);
                if (cmp2.renderedElevation != elevation || !Rectangle.intersects(x, y, w, h, cmp2.getAbsoluteX() + cmp2.getScrollX(), cmp2.getAbsoluteY() + cmp2.getScrollY(), cmp2.getBounds().getSize().getWidth(), cmp2.getBounds().getSize().getHeight())) continue;
                cmp2.paintInternal(g, false);
            }
        }
    }

    public void layoutContainer() {
        if (this.shouldLayout) {
            this.shouldLayout = false;
            this.doLayout();
        }
    }

    private boolean hasScrollableYParentInternal() {
        if (this.getParent() == null) {
            return false;
        }
        if (this.getParent().scrollableYFlag()) {
            return true;
        }
        return this.getParent().hasScrollableYParentInternal();
    }

    private boolean hasScrollableXParentInternal() {
        if (this.getParent() == null) {
            return false;
        }
        if (this.getParent().scrollableXFlag()) {
            return true;
        }
        return this.getParent().hasScrollableXParentInternal();
    }

    public void setSafeArea(boolean safeArea) {
        this.safeArea = safeArea;
    }

    public boolean isSafeArea() {
        return this.safeArea;
    }

    public void setSafeAreaRoot(boolean root) {
        this.safeAreaRoot = root;
    }

    public boolean isSafeAreaRoot() {
        return this.safeAreaRoot;
    }

    public Container getSafeAreaRoot() {
        if (this.safeAreaRoot) {
            return this;
        }
        Container parent = this.getParent();
        if (parent != null) {
            return parent.getSafeAreaRoot();
        }
        return null;
    }

    private boolean isSafeAreaInternal(boolean checkParents) {
        Container parent;
        if (this.safeArea) {
            return true;
        }
        if (checkParents && (parent = this.getParent()) != null) {
            return parent.isSafeAreaInternal(true);
        }
        return false;
    }

    private boolean snapToSafeAreaInternal() {
        if (this.isHidden()) {
            return false;
        }
        Container safeAreaRoot = this.getSafeAreaRoot();
        if (safeAreaRoot == null) {
            return false;
        }
        Rectangle rect = Display.impl.getDisplaySafeArea(new Rectangle());
        int safeLeftMargin = rect.getX();
        int safeRightMargin = CN.getDisplayWidth() - rect.getWidth() - rect.getX();
        int safeTopMargin = rect.getY();
        int safeBottomMargin = CN.getDisplayHeight() - rect.getHeight() - rect.getY();
        if (safeLeftMargin == 0 && safeRightMargin == 0 && safeBottomMargin == 0 && safeTopMargin == 0) {
            return false;
        }
        rect.setWidth(Math.max(0, safeAreaRoot.getWidth() - safeLeftMargin - safeRightMargin));
        rect.setHeight(Math.max(0, safeAreaRoot.getHeight() - safeTopMargin - safeBottomMargin));
        if (rect.getWidth() == 0 || rect.getHeight() == 0) {
            return false;
        }
        Rectangle safeArea = rect;
        Style style = this.getStyle();
        int safeX1 = safeArea.getX();
        int safeX2 = safeArea.getWidth() + safeX1;
        int safeY1 = safeArea.getY();
        int safeY2 = safeArea.getHeight() + safeY1;
        int paddingLeft = style.getPaddingLeftNoRTL();
        int paddingRight = style.getPaddingRightNoRTL();
        int paddingTop = style.getPaddingTop();
        int paddingBottom = style.getPaddingBottom();
        int newPaddingTop = paddingTop;
        int newPaddingBottom = paddingBottom;
        int newPaddingLeft = paddingLeft;
        int newPaddingRight = paddingRight;
        int absX = this.getAbsoluteX() - safeAreaRoot.getAbsoluteX();
        int w = this.getWidth();
        int absX2 = absX + w;
        if (absX >= 0 && absX + paddingLeft < safeX1) {
            newPaddingLeft = safeX1 - absX;
        }
        if (absX2 <= safeAreaRoot.getWidth() && absX2 - paddingRight > safeX2) {
            newPaddingRight = absX2 - safeX2;
        }
        int absY = this.getAbsoluteY() - safeAreaRoot.getAbsoluteY();
        int h = this.getHeight();
        int absY2 = absY + h;
        if (absY >= 0 && absY + paddingTop < safeY1) {
            newPaddingTop = safeY1 - absY;
        }
        if (absY2 <= safeAreaRoot.getHeight() && absY2 - paddingBottom > safeY2) {
            newPaddingBottom = absY2 - safeY2;
        }
        boolean changed = false;
        if (!(newPaddingTop == paddingTop && newPaddingBottom == paddingBottom || this.hasScrollableYParentInternal())) {
            changed = true;
            if (newPaddingTop != paddingTop) {
                style.setPaddingUnitTop((byte)0);
                style.setPaddingTop(newPaddingTop);
            }
            if (newPaddingBottom != paddingBottom) {
                style.setPaddingUnitBottom((byte)0);
                style.setPaddingBottom(newPaddingBottom);
            }
        }
        if (!(newPaddingLeft == paddingLeft && newPaddingRight == paddingRight || this.hasScrollableXParentInternal())) {
            changed = true;
            if (newPaddingLeft != paddingLeft) {
                style.setPaddingUnitLeft((byte)0);
                style.setPaddingLeft(newPaddingLeft);
            }
            if (newPaddingRight != paddingRight) {
                style.setPaddingUnitRight((byte)0);
                style.setPaddingRight(newPaddingRight);
            }
        }
        return changed;
    }

    void doLayout() {
        Container parent;
        ++this.doLayoutDepth;
        boolean restoreBounds = false;
        if (this.safeArea && this.doLayoutDepth == 1 && ((parent = this.getParent()) == null || !parent.isSafeAreaInternal(true))) {
            if (this.tmpInsets == null) {
                this.tmpInsets = new TmpInsets();
            }
            Style s = this.getStyle();
            this.tmpInsets.set(s);
            restoreBounds = this.snapToSafeAreaInternal();
        }
        this.layout.layoutContainer(this);
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.getComponentAt(i);
            if (c instanceof Container) {
                ((Container)c).layoutContainer();
                continue;
            }
            c.laidOut();
        }
        if (restoreBounds && this.tmpInsets != null) {
            this.tmpInsets.restore(this.getStyle());
        }
        this.laidOut();
        if (Form.activePeerCount > 0) {
            this.onParentPositionChange();
        }
        --this.doLayoutDepth;
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public Component getComponentAt(int index) {
        return this.components.get(index);
    }

    public int getComponentIndex(Component cmp) {
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.getComponentAt(i);
            if (!c.equals(cmp)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(Component cmp) {
        if (cmp == null) {
            return false;
        }
        for (cmp = cmp.getParent(); cmp != null; cmp = cmp.getParent()) {
            if (cmp != this) continue;
            return true;
        }
        return false;
    }

    public void scrollComponentToVisible(Component c) {
        if (this.isScrollable() && c != null) {
            boolean large;
            Form f;
            Rectangle r = c.getVisibleBounds();
            if (c.getParent() != null && (f = this.getComponentForm()) != null && f.getInvisibleAreaUnderVKB() == 0 && f.findFirstFocusable() == c && r == c.getBounds() && !Display.getInstance().isTouchScreenDevice()) {
                this.scrollRectToVisible(new Rectangle(0, 0, c.getX() + Math.min(c.getWidth(), this.getWidth()), c.getY() + Math.min(c.getHeight(), this.getHeight())), this);
                return;
            }
            boolean moveToVisible = true;
            Dimension size = r.getSize();
            boolean bl = large = size.getHeight() > this.getHeight() || size.getWidth() > this.getWidth();
            if (large) {
                int x = this.getScrollX();
                int y = this.getScrollY();
                int w = this.getWidth();
                int h = this.getHeight();
                boolean visible = this.contains(c) && Rectangle.intersects(c.getAbsoluteX(), c.getAbsoluteY(), c.getWidth(), c.getHeight(), this.getAbsoluteX() + x, this.getAbsoluteY() + y, w, h);
                boolean bl2 = moveToVisible = !visible;
            }
            if (moveToVisible) {
                this.scrollRectToVisible(r.getX(), r.getY(), Math.min(r.getSize().getWidth(), this.getWidth()), Math.min(r.getSize().getHeight(), this.getHeight()), c);
            }
        }
    }

    boolean moveScrollTowards(int direction, Component next) {
        if (this.isScrollable()) {
            boolean nextIntersects;
            Component current = null;
            Form f = this.getComponentForm();
            current = f.getFocused();
            boolean cyclic = f.isCyclicFocus();
            f.setCyclicFocus(false);
            boolean edge = false;
            boolean currentLarge = false;
            boolean scrollOutOfBounds = false;
            int x = this.getScrollX();
            int y = this.getScrollY();
            int w = this.getWidth();
            int h = this.getHeight();
            switch (direction) {
                case 1: {
                    if (!cyclic && this.getScrollY() == 0) {
                        return true;
                    }
                    y = this.getScrollY() - this.scrollIncrement;
                    edge = f.findNextFocusUp() == null;
                    currentLarge = current != null && current.getVisibleBounds().getSize().getHeight() > this.getHeight();
                    boolean bl = scrollOutOfBounds = y < 0;
                    if (!scrollOutOfBounds) break;
                    y = 0;
                    break;
                }
                case 6: {
                    y = this.getScrollY() + this.scrollIncrement;
                    edge = f.findNextFocusDown() == null;
                    currentLarge = current != null && current.getVisibleBounds().getSize().getHeight() > this.getHeight();
                    boolean bl = scrollOutOfBounds = y > this.getScrollDimension().getHeight() - this.getHeight();
                    if (!scrollOutOfBounds) break;
                    y = this.getScrollDimension().getHeight() - this.getHeight();
                    break;
                }
                case 5: {
                    x = this.getScrollX() + this.scrollIncrement;
                    edge = f.findNextFocusRight() == null;
                    currentLarge = current != null && current.getVisibleBounds().getSize().getWidth() > this.getWidth();
                    boolean bl = scrollOutOfBounds = x > this.getScrollDimension().getWidth() - this.getWidth();
                    if (!scrollOutOfBounds) break;
                    x = this.getScrollDimension().getWidth() - this.getWidth();
                    break;
                }
                case 2: {
                    x = this.getScrollX() - this.scrollIncrement;
                    edge = f.findNextFocusLeft() == null;
                    currentLarge = current != null && current.getVisibleBounds().getSize().getWidth() > this.getWidth();
                    boolean bl = scrollOutOfBounds = x < 0;
                    if (!scrollOutOfBounds) break;
                    x = 0;
                }
            }
            f.setCyclicFocus(cyclic);
            if (next == null || next == this) {
                this.scrollRectToVisible(x, y, w, h, this);
                return false;
            }
            if (!cyclic && direction == 6 && edge) {
                this.scrollRectToVisible(x, y, w, h, this);
                return false;
            }
            boolean bl = nextIntersects = this.contains(next) && Rectangle.intersects(next.getAbsoluteX(), next.getAbsoluteY(), next.getWidth(), next.getHeight(), this.getAbsoluteX() + x, this.getAbsoluteY() + y, w, h);
            if (nextIntersects && !currentLarge && !edge || Rectangle.contains(this.getAbsoluteX() + this.getScrollX(), this.getAbsoluteY() + this.getScrollY(), w, h, next.getAbsoluteX(), next.getAbsoluteY(), next.getWidth(), next.getHeight())) {
                return true;
            }
            if (!scrollOutOfBounds) {
                this.scrollRectToVisible(x, y, w, h, this);
                return nextIntersects && !Rectangle.intersects(current.getAbsoluteX(), current.getAbsoluteY(), current.getWidth(), current.getHeight(), this.getAbsoluteX() + x, this.getAbsoluteY() + y, w, h);
            }
            return true;
        }
        return true;
    }

    private int distanceToComponent(Component c, int x, int y) {
        int cy;
        int cx = c.getX();
        if (x > cx && (cx += c.getWidth()) > x) {
            cx = x;
        }
        if (y > (cy = c.getY()) && (cy += c.getHeight()) > y) {
            cy = y;
        }
        x = Math.abs(cx - x);
        y = Math.abs(cy - y);
        return (int)Math.sqrt(x * x + y * y);
    }

    public Component getClosestComponentTo(int x, int y) {
        int count = this.getComponentCount();
        if (count == 0) {
            return null;
        }
        Component closest = this.getComponentAt(0);
        if (closest.contains(x, y)) {
            return closest;
        }
        int distance = this.distanceToComponent(closest, x, y);
        for (int iter = 1; iter < count; ++iter) {
            Component current = this.getComponentAt(iter);
            if (current.contains(x, y)) {
                return current;
            }
            int cd = this.distanceToComponent(current, x, y);
            if (cd >= distance) continue;
            closest = current;
            distance = cd;
        }
        return closest;
    }

    public Component getResponderAt(int x, int y) {
        if (!this.isVisible() || !this.contains(x, y)) {
            return null;
        }
        int startIter = 0;
        int count = this.getComponentCount();
        if (count > 30) {
            int rely;
            int relx = x - this.getAbsoluteX();
            startIter = this.calculateFirstPaintableOffset(relx, rely = y - this.getAbsoluteY(), relx, rely);
            if (startIter < 0) {
                startIter = 0;
            } else if (startIter < count) {
                count = this.calculateLastPaintableOffset(startIter, relx, rely, relx, rely) + 1;
            }
        }
        for (int i = count - 1; i >= startIter; --i) {
            Component cmp = this.getComponentAt(i);
            if (!cmp.contains(x, y)) continue;
            if (!cmp.isBlockLead() && cmp instanceof Container) {
                cmp = ((Container)cmp).getResponderAt(x, y);
            }
            if (cmp == null || !cmp.respondsToPointerEvents()) continue;
            return cmp;
        }
        if (this.respondsToPointerEvents()) {
            return this;
        }
        return null;
    }

    public Component getComponentAt(int x, int y) {
        if (!this.contains(x, y) || !this.isVisible()) {
            return this;
        }
        int startIter = 0;
        int count = this.getComponentCount();
        if (count > 30) {
            int rely;
            int relx = x - this.getAbsoluteX();
            startIter = this.calculateFirstPaintableOffset(relx, rely = y - this.getAbsoluteY(), relx, rely);
            if (startIter < 0) {
                startIter = 0;
            } else if (startIter < count) {
                count = this.calculateLastPaintableOffset(startIter, relx, rely, relx, rely) + 1;
            }
        }
        boolean overlaps = this.getActualLayout().isOverlapSupported();
        Component component = null;
        Component top = null;
        for (int i = count - 1; i >= startIter; --i) {
            Component cmp = this.getComponentAt(i);
            if (!cmp.contains(x, y) || !cmp.isVisible()) continue;
            component = cmp;
            boolean isPotentialCandidate = cmp.respondsToPointerEvents();
            if (cmp instanceof Container) {
                Component c = ((Container)cmp).getComponentAt(x, y);
                if (c != null) {
                    if (top == null && (c.respondsToPointerEvents() || !(c instanceof Container))) {
                        top = c;
                    }
                    if (c != cmp) {
                        Component tmp;
                        if (cmp.isFocusable()) {
                            isPotentialCandidate = true;
                            boolean found = false;
                            for (tmp = c; tmp != cmp && tmp != null; tmp = tmp.getParent()) {
                                if (!tmp.isFocusable()) continue;
                                c = tmp;
                                found = true;
                                break;
                            }
                            if (!found) {
                                c = cmp;
                            }
                        } else if (cmp.respondsToPointerEvents()) {
                            isPotentialCandidate = true;
                            while (tmp != cmp && tmp != null) {
                                if (tmp.respondsToPointerEvents()) {
                                    c = tmp;
                                    break;
                                }
                                tmp = tmp.getParent();
                            }
                        } else {
                            while (tmp != cmp && tmp != null) {
                                if (tmp.respondsToPointerEvents()) {
                                    isPotentialCandidate = true;
                                    break;
                                }
                                tmp = tmp.getParent();
                            }
                        }
                        component = c;
                    }
                } else if (top == null && (cmp.respondsToPointerEvents() || !(cmp instanceof Container))) {
                    top = cmp;
                }
            } else if (top == null && (cmp.respondsToPointerEvents() || !(cmp instanceof Container))) {
                top = cmp;
            }
            if (!overlaps) {
                return component;
            }
            if (!isPotentialCandidate) continue;
            return component;
        }
        if ((component == null || !component.respondsToPointerEvents() && top != null) && top != null) {
            return top;
        }
        if (component != null) {
            return component;
        }
        return this;
    }

    public Component findDropTargetAt(int x, int y) {
        int count = this.getComponentCount();
        for (int i = count - 1; i >= 0; --i) {
            Component component;
            Component cmp = this.getComponentAt(i);
            if (!cmp.contains(x, y)) continue;
            if (cmp.isDropTarget()) {
                return cmp;
            }
            if (!(cmp instanceof Container) || (component = ((Container)cmp).findDropTargetAt(x, y)) == null) continue;
            return component;
        }
        return null;
    }

    @Override
    public void pointerPressed(int x, int y) {
        Component leadParent = LeadUtil.leadParentImpl(this);
        leadParent.clearDrag();
        leadParent.setDragActivated(false);
        Component cmp = this.getComponentAt(x, y);
        if (cmp == this) {
            super.pointerPressed(x, y);
            return;
        }
        if (cmp != null) {
            if (cmp.isFocusable() || cmp.isGrabsPointerEvents()) {
                cmp.pointerPressed(x, y);
                return;
            }
            if (this.isFocusable() || this.isGrabsPointerEvents()) {
                super.pointerPressed(x, y);
                return;
            }
            cmp.pointerPressed(x, y);
        }
    }

    @Override
    protected Dimension calcPreferredSize() {
        Container parent;
        ++this.calcPreferredSizeDepth;
        boolean restoreBounds = false;
        if (this.safeArea && this.getWidth() > 0 && this.getHeight() > 0 && this.calcPreferredSizeDepth == 1 && ((parent = this.getParent()) == null || !parent.isSafeAreaInternal(true))) {
            if (this.calcTmpInsets == null) {
                this.calcTmpInsets = new TmpInsets();
            }
            Style s = this.getStyle();
            this.calcTmpInsets.set(s);
            restoreBounds = this.snapToSafeAreaInternal();
        }
        Dimension d = this.layout.getPreferredSize(this);
        Style style = this.getStyle();
        if (style.getBorder() != null && d.getWidth() != 0 && d.getHeight() != 0) {
            d.setWidth(Math.max(style.getBorder().getMinimumWidth(), d.getWidth()));
            d.setHeight(Math.max(style.getBorder().getMinimumHeight(), d.getHeight()));
        }
        if (UIManager.getInstance().getLookAndFeel().isBackgroundImageDetermineSize() && style.getBgImage() != null) {
            d.setWidth(Math.max(style.getBgImage().getWidth(), d.getWidth()));
            d.setHeight(Math.max(style.getBgImage().getHeight(), d.getHeight()));
        }
        if (restoreBounds && this.calcTmpInsets != null) {
            this.calcTmpInsets.restore(this.getStyle());
        }
        --this.calcPreferredSizeDepth;
        return d;
    }

    @Override
    protected String paramString() {
        String className = this.layout.getClass().getName();
        String layoutStr = className.substring(className.lastIndexOf(46) + 1);
        return super.paramString() + ", layout = " + layoutStr + ", scrollableX = " + this.scrollableX + ", scrollableY = " + this.scrollableY + ", components = " + this.getComponentsNames();
    }

    private String getComponentsNames() {
        String ret = "[";
        int componentCount = this.components.size();
        for (int iter = 0; iter < componentCount; ++iter) {
            Component cmp = this.components.get(iter);
            String className = cmp.getClass().getName();
            ret = ret + className.substring(className.lastIndexOf(46) + 1) + ", ";
        }
        if (ret.length() > 1) {
            ret = ret.substring(0, ret.length() - 2);
        }
        ret = ret + "]";
        return ret;
    }

    @Override
    public void refreshTheme(boolean merge) {
        super.refreshTheme(merge);
        int componentCount = this.components.size();
        for (int iter = 0; iter < componentCount; ++iter) {
            Component cmp = this.components.get(iter);
            cmp.refreshTheme(merge);
        }
    }

    @Override
    boolean scrollableXFlag() {
        return this.scrollableX;
    }

    @Override
    boolean scrollableYFlag() {
        return this.scrollableY;
    }

    @Override
    public boolean isScrollableX() {
        return this.scrollableX && this.getScrollDimension().getWidth() + this.getStyle().getHorizontalPadding() > this.getWidth();
    }

    @Override
    public boolean isScrollableY() {
        Form f = this.getComponentForm();
        int v = 0;
        if (f != null) {
            v = f.getInvisibleAreaUnderVKB();
        }
        return this.scrollableY && (this.getScrollDimension().getHeight() + this.getStyle().getVerticalPadding() > this.getHeight() - v || this.isAlwaysTensile());
    }

    @Override
    public int getSideGap() {
        if (this.scrollSize == null) {
            if (this.scrollableY && this.isScrollVisible()) {
                return this.getUIManager().getLookAndFeel().getVerticalScrollWidth();
            }
        } else {
            return super.getSideGap();
        }
        return 0;
    }

    @Override
    public int getBottomGap() {
        if (this.scrollableX && this.isScrollVisible()) {
            return this.getUIManager().getLookAndFeel().getHorizontalScrollHeight();
        }
        return 0;
    }

    public void setScrollableX(boolean scrollableX) {
        this.scrollableX = this.layout instanceof BorderLayout ? false : scrollableX;
    }

    public void setScrollableY(boolean scrollableY) {
        this.scrollableY = this.layout instanceof BorderLayout ? false : scrollableY;
    }

    public void setScrollable(boolean scrollable) {
        this.setScrollableX(scrollable);
        this.setScrollableY(scrollable);
    }

    @Override
    public void setCellRenderer(boolean cellRenderer) {
        if (this.isCellRenderer() != cellRenderer) {
            super.setCellRenderer(cellRenderer);
            int size = this.getComponentCount();
            for (int iter = 0; iter < size; ++iter) {
                this.getComponentAt(iter).setCellRenderer(cellRenderer);
            }
        }
    }

    public void setScrollIncrement(int scrollIncrement) {
        this.scrollIncrement = scrollIncrement;
    }

    public int getScrollIncrement() {
        return this.scrollIncrement;
    }

    public Component findFirstFocusable() {
        int size = this.getComponentCount();
        for (int iter = 0; iter < size; ++iter) {
            Component cmp;
            Component current = this.getComponentAt(iter);
            if (!current.isVisible()) continue;
            if (current.isFocusable()) {
                return current;
            }
            if (!(current instanceof Container) || ((Container)current).isBlockFocus() || ((Container)current).getLeadComponent() != null || (cmp = ((Container)current).findFirstFocusable()) == null) continue;
            return cmp;
        }
        return null;
    }

    private void setFocusLead(boolean f) {
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.getComponentAt(i);
            if (c instanceof Container) {
                ((Container)c).setFocusLead(f);
            }
            c.setFocus(f);
            if (f) {
                c.fireFocusGained();
                continue;
            }
            c.fireFocusLost();
        }
    }

    @Override
    protected void dragInitiated() {
        super.dragInitiated();
        if (this.leadComponent != null) {
            this.leadComponent.dragInitiated();
        }
    }

    @Override
    protected void fireClicked() {
        if (this.leadComponent != null) {
            this.leadComponent.fireClicked();
        } else {
            super.fireClicked();
        }
    }

    @Override
    protected boolean isSelectableInteraction() {
        if (this.leadComponent != null) {
            return this.leadComponent.isSelectableInteraction();
        }
        return super.isSelectableInteraction();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.getComponentAt(i);
            c.setEnabled(enabled);
        }
    }

    @Override
    void setLightweightMode(boolean l) {
        int size = this.getComponentCount();
        for (int iter = 0; iter < size; ++iter) {
            this.getComponentAt(iter).setLightweightMode(l);
        }
    }

    @Override
    protected int getGridPosY() {
        int scroll = this.getScrollY();
        int size = this.getComponentCount();
        int bestRow = 0;
        for (int iter = 0; iter < size; ++iter) {
            Component c = this.getComponentAt(iter);
            int y = c.getY();
            if (Math.abs(scroll - y) >= Math.abs(scroll - bestRow)) continue;
            bestRow = y;
        }
        if (Math.abs(scroll - bestRow) > 2) {
            return bestRow;
        }
        return scroll;
    }

    private boolean shouldPaintContainerBackground() {
        return !this.isObscuredByChildren();
    }

    @Override
    public void paintComponentBackground(Graphics g) {
        if (this.isFlatten()) {
            super.paintBackgrounds(g);
            return;
        }
        if (this.shouldPaintContainerBackground()) {
            super.paintComponentBackground(g);
        }
    }

    @Override
    protected void paintBackground(Graphics g) {
        super.paintBackground(g);
    }

    @Override
    protected void paintBorderBackground(Graphics g) {
        super.paintBorderBackground(g);
    }

    @Override
    protected int getGridPosX() {
        int scroll = this.getScrollX();
        int size = this.getComponentCount();
        int bestCol = 0;
        for (int iter = 0; iter < size; ++iter) {
            Component c = this.getComponentAt(iter);
            int x = c.getX();
            if (Math.abs(scroll - x) >= Math.abs(scroll - bestCol)) continue;
            bestCol = x;
        }
        if (Math.abs(scroll - bestCol) > 2) {
            return bestCol;
        }
        return scroll;
    }

    void setBlockFocus(boolean blockFocus) {
        this.blockFocus = blockFocus;
    }

    boolean isBlockFocus() {
        return this.blockFocus;
    }

    public void animateHierarchyAndWait(int duration) {
        this.animateHierarchy(duration, true, 255, true);
    }

    public ComponentAnimation createAnimateHierarchy(int duration) {
        return this.animateHierarchy(duration, false, 255, false);
    }

    public void animateHierarchy(int duration) {
        this.animateHierarchy(duration, false, 255, true);
    }

    public void animateHierarchyFadeAndWait(int duration, int startingOpacity) {
        this.animateHierarchy(duration, true, startingOpacity, true);
    }

    public ComponentAnimation createAnimateHierarchyFade(int duration, int startingOpacity) {
        return this.animateHierarchy(duration, false, startingOpacity, false);
    }

    public void animateHierarchyFade(int duration, int startingOpacity) {
        this.animateHierarchy(duration, false, startingOpacity, true);
    }

    public void animateLayoutFadeAndWait(int duration, int startingOpacity) {
        this.animateLayout(duration, true, startingOpacity, true);
    }

    public ComponentAnimation createAnimateLayoutFadeAndWait(int duration, int startingOpacity) {
        return null;
    }

    public void animateLayoutFade(int duration, int startingOpacity) {
        this.animateLayout(duration, false, startingOpacity, true);
    }

    public ComponentAnimation createAnimateLayoutFade(int duration, int startingOpacity) {
        return this.animateLayout(duration, false, startingOpacity, false);
    }

    public void animateLayoutAndWait(int duration) {
        this.animateLayout(duration, true, 255, true);
    }

    public void animateLayout(int duration) {
        this.animateLayout(duration, false, 255, true);
    }

    public int updateTabIndices(int offset) {
        Container parent = this;
        Layout l = parent.getActualLayout();
        if (l.overridesTabIndices(parent)) {
            return l.updateTabIndices(parent, offset);
        }
        int len = parent.getComponentCount();
        int idx = offset;
        for (int i = 0; i < len; ++i) {
            Component c = parent.getComponentAt(i);
            int prefIdx = c.getPreferredTabIndex();
            if (prefIdx == 0) {
                c.setTabIndex(idx++);
            } else {
                c.setTabIndex(prefIdx);
            }
            if (!(c instanceof Container)) continue;
            idx = ((Container)c).updateTabIndices(idx);
        }
        return idx;
    }

    public ComponentAnimation createAnimateLayout(int duration) {
        return this.animateLayout(duration, false, 255, false);
    }

    @Override
    public void drop(Component dragged, int x, int y) {
        int i = this.getComponentIndex(dragged);
        if (i > -1) {
            int destIndex;
            Component dest = this.getComponentAt(x, y);
            if (dest != dragged && (destIndex = this.getComponentIndex(dest)) > -1 && destIndex != i) {
                this.setComponentIndex(dragged, destIndex);
            }
            this.animateLayout(400);
        } else {
            Component pos;
            Container oldParent = dragged.getParent();
            if (oldParent != null) {
                oldParent.removeComponent(dragged);
            }
            if ((i = this.getComponentIndex(pos = this.getComponentAt(x, y))) > -1) {
                this.addComponent(i, dragged);
            } else {
                this.addComponent(dragged);
            }
            this.getComponentForm().animateHierarchy(400);
        }
    }

    protected Motion createAnimateMotion(int start, int destination, int duration) {
        return Motion.createEaseInMotion(start, destination, duration);
    }

    private Motion createAndStartAnimateMotion(int start, int destination, int duration) {
        Motion m = this.createAnimateMotion(start, destination, duration);
        m.start();
        return m;
    }

    private void findComponentsInHierachy(Vector vec) {
        int cc = this.getComponentCount();
        for (int iter = 0; iter < cc; ++iter) {
            Component c = this.getComponentAt(iter);
            vec.addElement(c);
            if (c.getClass() != Container.class) continue;
            ((Container)c).findComponentsInHierachy(vec);
        }
    }

    public void morph(Component source, Component destination, int duration, Runnable onCompletion) {
        this.morph(source, destination, duration, false, onCompletion);
    }

    public void morphAndWait(Component source, Component destination, int duration) {
        this.morph(source, destination, duration, true, null);
    }

    private void morph(Component source, Component destination, int duration, boolean wait, Runnable onCompletion) {
        this.setShouldCalcPreferredSize(true);
        enableLayoutOnPaint = false;
        this.dontRecurseContainer = true;
        int deltaX = this.getAbsoluteX();
        int deltaY = this.getAbsoluteY();
        int sourceX = source.getAbsoluteX() - deltaX;
        int destX = destination.getAbsoluteX() - deltaX;
        int sourceY = source.getAbsoluteY() - deltaY;
        int destY = destination.getAbsoluteY() - deltaY;
        Motion[] xMotions = new Motion[]{this.createAndStartAnimateMotion(sourceX, destX, duration), this.createAndStartAnimateMotion(sourceX, destX, duration)};
        Motion[] yMotions = new Motion[]{this.createAndStartAnimateMotion(sourceY, destY, duration), this.createAndStartAnimateMotion(sourceY, destY, duration)};
        Motion[] wMotions = new Motion[]{this.createAndStartAnimateMotion(source.getWidth(), destination.getWidth(), duration), this.createAndStartAnimateMotion(source.getWidth(), destination.getWidth(), duration)};
        Motion[] hMotions = new Motion[]{this.createAndStartAnimateMotion(source.getHeight(), destination.getHeight(), duration), this.createAndStartAnimateMotion(source.getHeight(), destination.getHeight(), duration)};
        MorphAnimation a = new MorphAnimation(this, duration, new Motion[][]{xMotions, yMotions, wMotions, hMotions});
        a.opacity = new Motion[]{this.createAndStartAnimateMotion(255, 0, duration), this.createAndStartAnimateMotion(0, 255, duration)};
        a.animatedComponents = new Vector();
        a.animatedComponents.addElement(source);
        a.animatedComponents.addElement(destination);
        a.dontRevalidate = true;
        a.scrollTo = destination;
        if (wait) {
            this.getAnimationManager().addAnimationAndBlock(a);
        } else if (onCompletion != null) {
            this.getAnimationManager().addAnimation(a, onCompletion);
        } else {
            this.getAnimationManager().addAnimation(a);
        }
    }

    private ComponentAnimation animateHierarchy(int duration, boolean wait, int opacity, boolean add) {
        Component current;
        int iter;
        this.setShouldCalcPreferredSize(true);
        enableLayoutOnPaint = false;
        this.dontRecurseContainer = true;
        Vector comps = new Vector();
        this.findComponentsInHierachy(comps);
        int componentCount = comps.size();
        int[] beforeX = new int[componentCount];
        int[] beforeY = new int[componentCount];
        int[] beforeW = new int[componentCount];
        int[] beforeH = new int[componentCount];
        Motion[] xMotions = new Motion[componentCount];
        Motion[] yMotions = new Motion[componentCount];
        Motion[] wMotions = new Motion[componentCount];
        Motion[] hMotions = new Motion[componentCount];
        for (iter = 0; iter < componentCount; ++iter) {
            current = (Component)comps.elementAt(iter);
            beforeX[iter] = current.getX();
            beforeY[iter] = current.getY();
            beforeW[iter] = current.getWidth();
            beforeH[iter] = current.getHeight();
        }
        this.layoutContainer();
        for (iter = 0; iter < componentCount; ++iter) {
            current = (Component)comps.elementAt(iter);
            xMotions[iter] = this.createAnimateMotion(beforeX[iter], current.getX(), duration);
            yMotions[iter] = this.createAnimateMotion(beforeY[iter], current.getY(), duration);
            wMotions[iter] = this.createAnimateMotion(beforeW[iter], current.getWidth(), duration);
            hMotions[iter] = this.createAnimateMotion(beforeH[iter], current.getHeight(), duration);
            xMotions[iter].start();
            yMotions[iter].start();
            wMotions[iter].start();
            hMotions[iter].start();
            current.setX(beforeX[iter]);
            current.setY(beforeY[iter]);
            current.setWidth(beforeW[iter]);
            current.setHeight(beforeH[iter]);
        }
        MorphAnimation a = new MorphAnimation(this, duration, new Motion[][]{xMotions, yMotions, wMotions, hMotions});
        this.setAnimOpacity(opacity, 255, a, componentCount, duration);
        a.animatedComponents = comps;
        if (add) {
            if (wait) {
                this.getAnimationManager().addAnimationAndBlock(a);
            } else {
                this.getAnimationManager().addAnimation(a);
            }
        }
        return a;
    }

    public void animateUnlayout(int duration, int opacity, Runnable callback) {
        this.animateUnlayout(duration, false, opacity, callback, true);
    }

    public void animateUnlayoutAndWait(int duration, int opacity) {
        this.animateUnlayout(duration, true, opacity, null, true);
    }

    public ComponentAnimation createAnimateUnlayout(int duration, int opacity, Runnable callback) {
        return this.animateUnlayout(duration, false, opacity, callback, false);
    }

    private ComponentAnimation animateUnlayout(int duration, boolean wait, int opacity, Runnable callback, boolean add) {
        Component current;
        int iter;
        this.setShouldCalcPreferredSize(true);
        enableLayoutOnPaint = false;
        int componentCount = this.getComponentCount();
        int[] beforeX = new int[componentCount];
        int[] beforeY = new int[componentCount];
        int[] beforeW = new int[componentCount];
        int[] beforeH = new int[componentCount];
        Motion[] xMotions = new Motion[componentCount];
        Motion[] yMotions = new Motion[componentCount];
        Motion[] wMotions = new Motion[componentCount];
        Motion[] hMotions = new Motion[componentCount];
        for (iter = 0; iter < componentCount; ++iter) {
            current = this.getComponentAt(iter);
            beforeX[iter] = current.getX();
            beforeY[iter] = current.getY();
            beforeW[iter] = current.getWidth();
            beforeH[iter] = current.getHeight();
        }
        this.layoutContainer();
        for (iter = 0; iter < componentCount; ++iter) {
            current = this.getComponentAt(iter);
            xMotions[iter] = this.createAnimateMotion(current.getX(), beforeX[iter], duration);
            yMotions[iter] = this.createAnimateMotion(current.getY(), beforeY[iter], duration);
            wMotions[iter] = this.createAnimateMotion(current.getWidth(), beforeW[iter], duration);
            hMotions[iter] = this.createAnimateMotion(current.getHeight(), beforeH[iter], duration);
            xMotions[iter].start();
            yMotions[iter].start();
            wMotions[iter].start();
            hMotions[iter].start();
        }
        MorphAnimation a = new MorphAnimation(this, duration, new Motion[][]{xMotions, yMotions, wMotions, hMotions});
        this.setAnimOpacity(255, opacity, a, componentCount, duration);
        a.dontRevalidate = true;
        if (add) {
            if (wait) {
                this.getAnimationManager().addAnimationAndBlock(a);
            } else if (callback != null) {
                this.getAnimationManager().addUIMutation(this, a, callback);
            } else {
                this.getAnimationManager().addUIMutation(this, a);
            }
        }
        return a;
    }

    private ComponentAnimation animateLayout(int duration, boolean wait, int opacity, boolean addAnimation) {
        Component current;
        int iter;
        Form f = this.getComponentForm();
        if (f == null) {
            return null;
        }
        this.setShouldCalcPreferredSize(true);
        enableLayoutOnPaint = false;
        int componentCount = this.getComponentCount();
        int[] beforeX = new int[componentCount];
        int[] beforeY = new int[componentCount];
        int[] beforeW = new int[componentCount];
        int[] beforeH = new int[componentCount];
        Motion[] xMotions = new Motion[componentCount];
        Motion[] yMotions = new Motion[componentCount];
        Motion[] wMotions = new Motion[componentCount];
        Motion[] hMotions = new Motion[componentCount];
        for (iter = 0; iter < componentCount; ++iter) {
            current = this.getComponentAt(iter);
            beforeX[iter] = current.getX();
            beforeY[iter] = current.getY();
            beforeW[iter] = current.getWidth();
            beforeH[iter] = current.getHeight();
        }
        this.layoutContainer();
        for (iter = 0; iter < componentCount; ++iter) {
            current = this.getComponentAt(iter);
            xMotions[iter] = this.createAnimateMotion(beforeX[iter], current.getX(), duration);
            yMotions[iter] = this.createAnimateMotion(beforeY[iter], current.getY(), duration);
            wMotions[iter] = this.createAnimateMotion(beforeW[iter], current.getWidth(), duration);
            hMotions[iter] = this.createAnimateMotion(beforeH[iter], current.getHeight(), duration);
            xMotions[iter].start();
            yMotions[iter].start();
            wMotions[iter].start();
            hMotions[iter].start();
            current.setX(beforeX[iter]);
            current.setY(beforeY[iter]);
            current.setWidth(beforeW[iter]);
            current.setHeight(beforeH[iter]);
        }
        MorphAnimation a = new MorphAnimation(this, duration, new Motion[][]{xMotions, yMotions, wMotions, hMotions});
        this.setAnimOpacity(opacity, 255, a, componentCount, duration);
        if (addAnimation) {
            if (wait) {
                this.getAnimationManager().addAnimationAndBlock(a);
            } else {
                this.getAnimationManager().addUIMutation(this, a);
            }
        } else {
            a.dontRevalidate = true;
        }
        return a;
    }

    private void setAnimOpacity(int source, int dest, MorphAnimation a, int componentCount, int duration) {
        if (source != dest) {
            a.opacity = new Motion[componentCount];
            for (int iter = 0; iter < componentCount; ++iter) {
                a.opacity[iter] = this.createAndStartAnimateMotion(source, dest, duration);
            }
        }
    }

    public List<Component> getChildrenAsList(boolean includeQueued) {
        if (includeQueued) {
            ArrayList<Component> out = new ArrayList<Component>();
            out.addAll(this.components);
            if (this.changeQueue != null) {
                for (QueuedChange change : this.changeQueue) {
                    switch (change.type) {
                        case 0: {
                            QueuedInsertion insert = (QueuedInsertion)change;
                            int index = insert.index;
                            if (insert.index == Integer.MAX_VALUE) {
                                index = out.size();
                            }
                            out.add(index, change.component);
                            break;
                        }
                        case 1: {
                            out.remove(change.component);
                        }
                    }
                }
            }
            return out;
        }
        ArrayList<Component> out = new ArrayList<Component>();
        out.addAll(this.components);
        return out;
    }

    public Iterator<Component> iterator(boolean includeQueued) {
        if (includeQueued) {
            return this.getChildrenAsList(includeQueued).iterator();
        }
        return this.iterator();
    }

    @Override
    public Iterator<Component> iterator() {
        return this.components.iterator();
    }

    static {
        blockOverdraw = false;
    }

    static class MorphAnimation
    extends ComponentAnimation {
        private long startTime = System.currentTimeMillis();
        private int duration;
        private Transition t;
        private Container thisContainer;
        private boolean finished = false;
        private Motion[][] motions;
        Runnable onFinish;
        int growSpeed;
        int layoutAnimationSpeed;
        Vector animatedComponents;
        Motion[] opacity;
        boolean dontRevalidate;
        private Component scrollTo;

        public MorphAnimation(Container thisContainer, int duration, Motion[][] motions) {
            this.duration = duration;
            if (Motion.isSlowMotion()) {
                this.duration *= 50;
            }
            this.thisContainer = thisContainer;
            this.motions = motions;
        }

        public boolean isInProgress() {
            return !this.finished;
        }

        public void flush() {
            Motion[][] motionArray = this.motions;
            int n = motionArray.length;
            for (int i = 0; i < n; ++i) {
                Motion[] mm;
                for (Motion m : mm = motionArray[i]) {
                    if (m == null) continue;
                    m.finish();
                }
            }
            this.updateState();
        }

        protected void updateState() {
            int componentCount;
            if (this.animatedComponents != null) {
                componentCount = this.animatedComponents.size();
                for (int iter = 0; iter < componentCount; ++iter) {
                    Component currentCmp = (Component)this.animatedComponents.elementAt(iter);
                    currentCmp.setX(this.motions[0][iter].getValue());
                    currentCmp.setY(this.motions[1][iter].getValue());
                    currentCmp.setWidth(this.motions[2][iter].getValue());
                    currentCmp.setHeight(this.motions[3][iter].getValue());
                    if (this.opacity == null) continue;
                    currentCmp.getStyle().setOpacity(this.opacity[iter].getValue(), false);
                }
            } else {
                componentCount = this.thisContainer.getComponentCount();
                if (this.motions != null) {
                    componentCount = Math.min(this.motions[0].length, componentCount);
                }
                for (int iter = 0; iter < componentCount; ++iter) {
                    Component currentCmp = this.thisContainer.getComponentAt(iter);
                    if (currentCmp == null) continue;
                    currentCmp.setX(this.motions[0][iter].getValue());
                    currentCmp.setY(this.motions[1][iter].getValue());
                    currentCmp.setWidth(this.motions[2][iter].getValue());
                    currentCmp.setHeight(this.motions[3][iter].getValue());
                    if (this.opacity == null) continue;
                    currentCmp.getStyle().setOpacity(this.opacity[iter].getValue(), false);
                }
            }
            if (this.scrollTo != null) {
                boolean s = this.thisContainer.isSmoothScrolling();
                this.thisContainer.setSmoothScrolling(false);
                this.thisContainer.scrollComponentToVisible(this.scrollTo);
                this.thisContainer.setSmoothScrolling(s);
            }
            this.thisContainer.repaint();
            if (System.currentTimeMillis() - this.startTime >= (long)this.duration) {
                enableLayoutOnPaint = true;
                this.thisContainer.dontRecurseContainer = false;
                Form f = this.thisContainer.getComponentForm();
                this.finished = true;
                if (f == null) {
                    return;
                }
                if (!this.dontRevalidate) {
                    f.revalidate();
                }
            }
        }
    }

    static class TransitionAnimation
    extends ComponentAnimation {
        private Transition t;
        private Container thisContainer;
        int growSpeed;
        int layoutAnimationSpeed;
        Vector animatedComponents;
        Motion[] opacity;
        boolean dontRevalidate;
        private boolean started = false;
        private boolean inProgress = true;
        private Component current;
        private Component next;
        private Form parent;
        private boolean destroyed;

        TransitionAnimation(Container thisContainer, Component current, Component next, Transition t) {
            this.t = t;
            this.next = next;
            this.current = current;
            this.thisContainer = thisContainer;
            this.parent = thisContainer.getComponentForm();
        }

        public boolean isInProgress() {
            return this.inProgress;
        }

        public void updateState() {
            if (this.destroyed) {
                return;
            }
            if (!this.started) {
                this.t.init(this.current, this.next);
                if (this.current != null) {
                    this.current.setLightweightMode(true);
                }
                if (this.next != null) {
                    this.next.setLightweightMode(true);
                }
                this.t.initTransition();
                this.started = true;
                if (this.thisContainer.cmpTransitions == null) {
                    this.thisContainer.cmpTransitions = new Vector();
                }
                this.thisContainer.cmpTransitions.addElement(this);
            }
            this.inProgress = this.t.animate();
            if (!this.inProgress) {
                this.thisContainer.cmpTransitions.removeElement(this);
                this.destroy();
                this.thisContainer.repaint();
            } else {
                Display.getInstance().repaint(this.t);
            }
        }

        public void flush() {
            this.destroy();
        }

        public void destroy() {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            this.next.setParent(null);
            this.thisContainer.replace(this.current, this.next, this.growSpeed > 0 || this.layoutAnimationSpeed > 0);
            this.t.cleanup();
            if (this.current != null) {
                this.current.setLightweightMode(false);
            }
            if (this.next != null) {
                this.next.setLightweightMode(false);
            }
            if (this.thisContainer.cmpTransitions != null && this.thisContainer.cmpTransitions.size() == 0 && this.growSpeed > -1) {
                if (this.growSpeed > 0) {
                    this.current.growShrink(this.growSpeed);
                } else if (this.layoutAnimationSpeed <= 0 && !this.dontRevalidate && this.parent != null) {
                    this.parent.revalidate();
                }
            }
            this.inProgress = false;
        }
    }

    private static class TmpInsets {
        float top;
        float left;
        float bottom;
        float right;
        byte topUnit;
        byte leftUnit;
        byte bottomUnit;
        byte rightUnit;

        private TmpInsets() {
        }

        public String toString() {
            return this.top + "," + this.right + "," + this.bottom + "," + this.left;
        }

        private void set(Style style) {
            this.top = style.getPaddingValue(false, 0);
            this.left = style.getPaddingValue(false, 1);
            this.bottom = style.getPaddingValue(false, 2);
            this.right = style.getPaddingValue(false, 3);
            byte[] units = style.getPaddingUnit();
            if (units != null) {
                this.topUnit = units[0];
                this.leftUnit = units[1];
                this.bottomUnit = units[2];
                this.rightUnit = units[3];
            } else {
                this.rightUnit = 0;
                this.bottomUnit = 0;
                this.leftUnit = 0;
                this.topUnit = 0;
            }
        }

        private void restore(Style style) {
            boolean suppressEvents = style.isSuppressChangeEvents();
            style.setSuppressChangeEvents(true);
            style.setPadding(0, this.top, true);
            style.setPadding(1, this.left, true);
            style.setPadding(2, this.bottom, true);
            style.setPadding(3, this.right, true);
            byte[] units = style.getPaddingUnit();
            if (units != null) {
                units[0] = this.topUnit;
                units[2] = this.bottomUnit;
                units[1] = this.leftUnit;
                units[3] = this.rightUnit;
            } else {
                style.setPaddingUnit(this.topUnit, this.leftUnit, this.bottomUnit, this.rightUnit);
            }
            style.setSuppressChangeEvents(suppressEvents);
        }
    }

    private static class QueuedRemoval
    extends QueuedChange {
        QueuedRemoval(Component cmp) {
            super(1, cmp);
        }
    }

    private static class QueuedInsertion
    extends QueuedChange {
        private Object constraint;
        private int index;

        QueuedInsertion(int index, Object constraint, Component cmp) {
            super(0, cmp);
            this.index = index;
            this.constraint = constraint;
        }
    }

    private static class QueuedChange {
        private final Component component;
        private final int type;
        static final int TYPE_INSERT = 0;
        static final int TYPE_REMOVE = 1;

        QueuedChange(int type, Component cmp) {
            this.type = type;
            this.component = cmp;
        }
    }
}

