/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.impl.CodenameOneImplementation;
import com.codename1.io.File;
import com.codename1.io.FileSystemStorage;
import com.codename1.io.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class URL {
    private URI u;

    public URL(String url) throws URISyntaxException {
        this.u = new URI(url);
    }

    URL(URI u) {
        this.u = u;
    }

    public String getQuery() {
        return this.u.getQuery();
    }

    public String getPath() {
        return this.u.getPath();
    }

    public String getUserInfo() {
        return this.u.getUserInfo();
    }

    public String getAuthority() {
        return this.u.getAuthority();
    }

    public int getPort() {
        return this.u.getPort();
    }

    public int getDefaultPort() {
        if (this.u.toASCIIString().startsWith("https")) {
            return 443;
        }
        return 80;
    }

    public String getProtocol() {
        String s = this.u.toASCIIString();
        if (s.startsWith("https")) {
            return "https";
        }
        if (s.startsWith("file")) {
            return "file";
        }
        return "http";
    }

    public String getHost() {
        return this.u.getHost();
    }

    public String getFile() {
        return this.u.toASCIIString();
    }

    public boolean equals(Object o) {
        return o instanceof URL && ((URL)o).u.equals(o);
    }

    public synchronized int hashCode() {
        return this.u.hashCode();
    }

    public boolean sameFile(URL u) {
        return this.equals(u);
    }

    public String toString() {
        return this.u.toASCIIString();
    }

    public String toExternalForm() {
        return this.u.toASCIIString();
    }

    public URI toURI() throws URISyntaxException {
        return this.u;
    }

    public URLConnection openConnection() throws IOException {
        if ("file".equals(this.getProtocol())) {
            return new FileURLConnection(new File(this.u));
        }
        return new HttpURLConnection(this.u.toASCIIString());
    }

    public final InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HttpURLConnection
    extends URLConnection {
        private String url;
        private Object connection;
        private CodenameOneImplementation impl;
        private String requestMethod;

        HttpURLConnection(String url) {
            this.requestMethod = "GET";
            this.url = url;
            this.impl = Util.getImplementation();
        }

        @Override
        public void connect() throws IOException {
            this.connection = this.impl.connect(this.url, this.doInput, this.doOutput);
            this.impl.setHttpMethod(this.connection, this.requestMethod);
            if (this.properties != null && !this.properties.isEmpty()) {
                for (String key : this.properties.keySet()) {
                    this.impl.setHeader(this.connection, key, (String)this.properties.get(key));
                }
            }
        }

        public void setRequestMethod(String method) {
            this.requestMethod = method;
            if (this.connection != null) {
                try {
                    this.impl.setHttpMethod(this.connection, this.requestMethod);
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Failed to set request method " + method + ". " + ex.getMessage());
                }
            }
        }

        @Override
        public int getContentLength() {
            return this.impl.getContentLength(this.connection);
        }

        @Override
        public String getContentType() {
            return this.getHeaderField("Content-Type");
        }

        @Override
        public String getHeaderField(String s) {
            try {
                return this.impl.getHeaderField(s, this.connection);
            }
            catch (IOException err) {
                return null;
            }
        }

        @Override
        public Map<String, List<String>> getHeaderFields() {
            try {
                String[] dat = this.impl.getHeaderFieldNames(this.connection);
                HashMap<String, List<String>> response = new HashMap<String, List<String>>();
                for (String s : dat) {
                    String[] vals = this.impl.getHeaderFields(s, this.connection);
                    ArrayList<String> a = new ArrayList<String>();
                    response.put(s, a);
                    for (String c : vals) {
                        a.add(c);
                    }
                }
                return response;
            }
            catch (IOException err) {
                return null;
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.connection == null) {
                this.connect();
            }
            return this.impl.openInputStream(this.connection);
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            if (this.connection == null) {
                this.connect();
            }
            return this.impl.openOutputStream(this.connection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileURLConnection
    extends URLConnection {
        private File file;

        private FileURLConnection(File f) {
            this.file = f;
        }

        @Override
        public void connect() throws IOException {
            if (!this.file.exists()) {
                throw new IOException("Failed to connect to file because it doesn't exist");
            }
        }

        @Override
        public int getContentLength() {
            return (int)this.file.length();
        }

        @Override
        public String getContentType() {
            return null;
        }

        @Override
        public String getHeaderField(String s) {
            return null;
        }

        @Override
        public Map<String, List<String>> getHeaderFields() {
            return new HashMap<String, List<String>>();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return FileSystemStorage.getInstance().openInputStream(this.file.getAbsolutePath());
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return FileSystemStorage.getInstance().openOutputStream(this.file.getAbsolutePath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class URLConnection {
        final Map<String, String> properties = new HashMap<String, String>();
        int connectTimeout;
        int readTimeout;
        boolean doInput = true;
        boolean doOutput;

        public abstract void connect() throws IOException;

        public void setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public URL getURL() {
            return URL.this;
        }

        public abstract int getContentLength();

        public long getContentLengthLong() {
            return this.getContentLength();
        }

        public abstract String getContentType();

        public abstract String getHeaderField(String var1);

        public abstract Map<String, List<String>> getHeaderFields();

        public abstract InputStream getInputStream() throws IOException;

        public abstract OutputStream getOutputStream() throws IOException;

        public void setRequestProperty(String key, String value) {
            this.properties.put(key, value);
        }

        public void setDoInput(boolean i) {
            this.doInput = i;
        }

        public boolean getDoInput() {
            return this.doInput;
        }

        public void setDoOutput(boolean i) {
            this.doOutput = i;
        }

        public boolean getDoOutput() {
            return this.doOutput;
        }
    }
}

