/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.cloud.BindTarget;
import com.codename1.ui.Button;
import com.codename1.ui.ButtonGroup;
import com.codename1.ui.Command;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.plaf.DefaultLookAndFeel;
import com.codename1.ui.plaf.LookAndFeel;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.EventDispatcher;

public class RadioButton
extends Button {
    private boolean unselectAllowed;
    private boolean selected;
    private ButtonGroup group;
    private boolean oppositeSide;
    private EventDispatcher bindListeners;
    private EventDispatcher changeListeners;

    public RadioButton(String text) {
        this(text, (Image)null);
    }

    public static RadioButton createToggle(String text, Image icon, ButtonGroup bg) {
        RadioButton rb = new RadioButton(text, icon);
        bg.add(rb);
        rb.setToggle(true);
        return rb;
    }

    public static RadioButton createToggle(String text, ButtonGroup bg) {
        return RadioButton.createToggle(text, null, bg);
    }

    public static RadioButton createToggle(Image icon, ButtonGroup bg) {
        return RadioButton.createToggle(null, icon, bg);
    }

    public static RadioButton createToggle(Command cmd, ButtonGroup bg) {
        RadioButton rb = new RadioButton(cmd.getCommandName(), cmd.getIcon());
        rb.setCommand(cmd);
        bg.add(rb);
        rb.setToggle(true);
        return rb;
    }

    public RadioButton() {
        this("");
    }

    public RadioButton(Image icon) {
        this("", icon);
    }

    public RadioButton(String text, Image icon) {
        super(text, icon);
        this.setUIID("RadioButton");
    }

    protected void initLaf(UIManager uim) {
        super.initLaf(uim);
        Boolean v = this.getUIManager().isThemeConstant("radioOppositeSideBool");
        if (v != null) {
            this.oppositeSide = v;
        }
    }

    protected void fireActionEvent(int x, int y) {
        super.fireActionEvent(x, y);
        if (this.bindListeners != null) {
            if (this.isSelected()) {
                this.bindListeners.fireBindTargetChange(this, "selected", Boolean.TRUE, Boolean.FALSE);
            } else {
                this.bindListeners.fireBindTargetChange(this, "selected", Boolean.FALSE, Boolean.TRUE);
            }
        }
    }

    public String toString() {
        return "Radio Button " + this.getText();
    }

    int getAvaliableSpaceForText() {
        Image[] rButtonImages;
        if (this.isToggle()) {
            return super.getAvaliableSpaceForText();
        }
        LookAndFeel l = this.getUIManager().getLookAndFeel();
        if (l instanceof DefaultLookAndFeel && (rButtonImages = ((DefaultLookAndFeel)l).getRadioButtonImages()) != null) {
            int index = this.isSelected() ? 1 : 0;
            return super.getAvaliableSpaceForText() - rButtonImages[index].getWidth();
        }
        return super.getAvaliableSpaceForText() - (this.getHeight() + this.getGap());
    }

    public boolean isSelected() {
        return this.selected;
    }

    void setSelectedImpl(boolean selected) {
        boolean changed = selected != this.selected;
        this.selected = selected;
        if (changed) {
            this.fireChangeEvent();
        }
        this.repaint();
    }

    public void setSelected(boolean selected) {
        this.setSelectedImpl(selected);
        if (this.group != null && selected) {
            this.group.setSelected(this);
        }
    }

    public boolean isUnselectAllowed() {
        return this.unselectAllowed;
    }

    public void setUnselectAllowed(boolean unselectAllowed) {
        this.unselectAllowed = unselectAllowed;
    }

    public void released(int x, int y) {
        if (!this.isSelected() || this.unselectAllowed) {
            this.setSelected(!this.isSelected());
        }
        super.released(x, y);
    }

    public void paint(Graphics g) {
        if (this.isToggle()) {
            this.getUIManager().getLookAndFeel().drawButton(g, this);
        } else {
            this.getUIManager().getLookAndFeel().drawRadioButton(g, this);
        }
    }

    protected Dimension calcPreferredSize() {
        return this.getUIManager().getLookAndFeel().getRadioButtonPreferredSize(this);
    }

    void setButtonGroup(ButtonGroup group) {
        this.group = group;
    }

    public ButtonGroup getButtonGroup() {
        return this.group;
    }

    void fireActionEvent() {
        if (this.group != null) {
            this.group.setSelected(this);
        }
        super.fireActionEvent();
    }

    public void setGroup(String groupName) {
        this.putClientProperty("$group", groupName);
        this.initNamedGroup();
    }

    void initComponentImpl() {
        super.initComponentImpl();
        this.initNamedGroup();
    }

    private void initNamedGroup() {
        String s;
        if (this.isInitialized() && (s = this.getGroup()) != null) {
            Form f = this.getComponentForm();
            ButtonGroup b = (ButtonGroup)f.getClientProperty("$radio" + s);
            if (b == null) {
                b = new ButtonGroup();
                f.putClientProperty("$radio" + s, b);
            }
            b.add(this);
        }
    }

    public String getGroup() {
        return (String)this.getClientProperty("$group");
    }

    public boolean isOppositeSide() {
        return this.oppositeSide;
    }

    public void setOppositeSide(boolean oppositeSide) {
        this.oppositeSide = oppositeSide;
    }

    public String[] getBindablePropertyNames() {
        return new String[]{"selected"};
    }

    public Class[] getBindablePropertyTypes() {
        return new Class[]{Boolean.class};
    }

    public void bindProperty(String prop, BindTarget target) {
        if (prop.equals("selected")) {
            if (this.bindListeners == null) {
                this.bindListeners = new EventDispatcher();
            }
            this.bindListeners.addListener(target);
            return;
        }
        super.bindProperty(prop, target);
    }

    public void unbindProperty(String prop, BindTarget target) {
        if (prop.equals("selected")) {
            if (this.bindListeners == null) {
                return;
            }
            this.bindListeners.removeListener(target);
            if (!this.bindListeners.hasListeners()) {
                this.bindListeners = null;
            }
            return;
        }
        super.unbindProperty(prop, target);
    }

    public Object getBoundPropertyValue(String prop) {
        if (prop.equals("selected")) {
            if (this.isSelected()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return super.getBoundPropertyValue(prop);
    }

    public void setBoundPropertyValue(String prop, Object value) {
        if (prop.equals("selected")) {
            this.setSelected(value != null && (Boolean)value != false);
            return;
        }
        super.setBoundPropertyValue(prop, value);
    }

    public void addChangeListener(ActionListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new EventDispatcher();
        }
        this.changeListeners.addListener(l);
    }

    public void removeChangeListeners(ActionListener l) {
        if (this.changeListeners != null) {
            this.changeListeners.removeListener(l);
        }
    }

    private void fireChangeEvent() {
        if (this.changeListeners != null) {
            ActionEvent evt = new ActionEvent((Object)this, ActionEvent.Type.Change);
            this.changeListeners.fireActionEvent(evt);
        }
    }
}

