/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.layouts.mig;

import com.codename1.components.InfiniteProgress;
import com.codename1.ui.Button;
import com.codename1.ui.CheckBox;
import com.codename1.ui.ComboBox;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Font;
import com.codename1.ui.Label;
import com.codename1.ui.List;
import com.codename1.ui.RadioButton;
import com.codename1.ui.Slider;
import com.codename1.ui.Tabs;
import com.codename1.ui.TextArea;
import com.codename1.ui.TextField;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.mig.CodenameOneMiGContainerWrapper;
import com.codename1.ui.layouts.mig.ComponentWrapper;
import com.codename1.ui.layouts.mig.ContainerWrapper;
import com.codename1.ui.layouts.mig.PlatformDefaults;
import com.codename1.ui.spinner.BaseSpinner;
import com.codename1.ui.table.Table;

class CodenameOneMiGComponentWrapper
implements ComponentWrapper {
    private static boolean maxSet = false;
    private static boolean vp = true;
    private static final String VISUAL_PADDING_PROPERTY = PlatformDefaults.VISUAL_PADDING_PROPERTY;
    private final Component c;
    private int compType = -1;
    private Boolean bl = null;
    private boolean prefCalled = false;
    private static final Font SUBST_FONT = Font.getDefaultFont();

    public CodenameOneMiGComponentWrapper(Component c) {
        this.c = c;
    }

    public final int getBaseline(int width, int height) {
        int[] visPad;
        int baseLine = this.c.getBaseline(width < 0 ? this.c.getWidth() : width, height < 0 ? this.c.getHeight() : height);
        if (baseLine != -1 && (visPad = this.getVisualPadding()) != null) {
            baseLine += (visPad[2] - visPad[0] + 1) / 2;
        }
        return baseLine;
    }

    public final Object getComponent() {
        return this.c;
    }

    public final float getPixelUnitFactor(boolean isHor) {
        switch (PlatformDefaults.getLogicalPixelBase()) {
            case 100: {
                return isHor ? (float)SUBST_FONT.charWidth('X') / 6.0f : (float)SUBST_FONT.getHeight() / 13.277344f;
            }
            case 101: {
                Float s;
                Float f = s = isHor ? PlatformDefaults.getHorizontalScaleFactor() : PlatformDefaults.getVerticalScaleFactor();
                if (s == null) {
                    s = new Float(1.0f);
                }
                return s.floatValue() * (float)(isHor ? this.getHorizontalScreenDPI() : this.getVerticalScreenDPI()) / (float)PlatformDefaults.getDefaultDPI();
            }
        }
        return 1.0f;
    }

    public final int getX() {
        return this.c.getX();
    }

    public final int getY() {
        return this.c.getY();
    }

    public final int getHeight() {
        return this.c.getHeight();
    }

    public final int getWidth() {
        return this.c.getWidth();
    }

    public final int getScreenLocationX() {
        return 0;
    }

    public final int getScreenLocationY() {
        return 0;
    }

    public final int getMinimumHeight(int sz) {
        return this.c.getPreferredH();
    }

    public final int getMinimumWidth(int sz) {
        return this.c.getPreferredW();
    }

    public final int getPreferredHeight(int sz) {
        return this.c.getPreferredH();
    }

    public final int getPreferredWidth(int sz) {
        return this.c.getPreferredW();
    }

    public final int getMaximumHeight(int sz) {
        int w;
        Container p = this.c.getParent();
        if (p != null && (w = p.getHeight()) > 10) {
            return w;
        }
        return Display.getInstance().getDisplayHeight();
    }

    public final int getMaximumWidth(int sz) {
        int w;
        Container p = this.c.getParent();
        if (p != null && (w = p.getWidth()) > 10) {
            return w;
        }
        return Display.getInstance().getDisplayWidth();
    }

    private boolean isMaxSet(Component c) {
        return false;
    }

    public final ContainerWrapper getParent() {
        Container p = this.c.getParent();
        return p != null ? new CodenameOneMiGContainerWrapper(p) : null;
    }

    public final int getHorizontalScreenDPI() {
        return PlatformDefaults.getDefaultDPI();
    }

    public final int getVerticalScreenDPI() {
        return PlatformDefaults.getDefaultDPI();
    }

    public final int getScreenWidth() {
        return Display.getInstance().getDisplayWidth();
    }

    public final int getScreenHeight() {
        return Display.getInstance().getDisplayHeight();
    }

    public final boolean hasBaseline() {
        return true;
    }

    public final String getLinkId() {
        return this.c.getName();
    }

    public final void setBounds(int x, int y, int width, int height) {
        this.c.setX(x);
        this.c.setY(y);
        this.c.setWidth(width);
        this.c.setHeight(height);
    }

    public boolean isVisible() {
        return this.c.isVisible();
    }

    public final int[] getVisualPadding() {
        int[] padding = new int[]{this.c.getStyle().getMarginTop(), this.c.getStyle().getMarginLeftNoRTL(), this.c.getStyle().getMarginBottom(), this.c.getStyle().getMarginRightNoRTL()};
        return padding;
    }

    public static boolean isMaxSizeSetOn1_4() {
        return maxSet;
    }

    public static void setMaxSizeSetOn1_4(boolean b) {
        maxSet = b;
    }

    public static boolean isVisualPaddingEnabled() {
        return vp;
    }

    public static void setVisualPaddingEnabled(boolean b) {
        vp = b;
    }

    public final void paintDebugOutline(boolean showVisualPadding) {
    }

    public int getComponentType(boolean disregardScrollPane) {
        if (this.compType == -1) {
            this.compType = this.checkType(disregardScrollPane);
        }
        return this.compType;
    }

    public int getLayoutHashCode() {
        String id;
        Dimension d = this.c.getPreferredSize();
        int hash = (d.getWidth() << 10) + (d.getHeight() << 15);
        if (this.c.isVisible()) {
            hash += 1324511;
        }
        if ((id = this.getLinkId()) != null) {
            hash += id.hashCode();
        }
        return hash;
    }

    private int checkType(boolean disregardScrollPane) {
        Component c = this.c;
        if (c instanceof TextField) {
            return 3;
        }
        if (c instanceof Label) {
            return 2;
        }
        if (c instanceof RadioButton || c instanceof CheckBox) {
            return 16;
        }
        if (c instanceof Button) {
            return 5;
        }
        if (c instanceof ComboBox) {
            return 11;
        }
        if (c instanceof TextArea) {
            return 4;
        }
        if (c instanceof Container) {
            return 10;
        }
        if (c instanceof List) {
            return 6;
        }
        if (c instanceof Table) {
            return 7;
        }
        if (c instanceof BaseSpinner) {
            return 13;
        }
        if (c instanceof Tabs) {
            return 19;
        }
        if (c instanceof InfiniteProgress) {
            return 14;
        }
        if (c instanceof Slider) {
            return 12;
        }
        return 0;
    }

    public final int hashCode() {
        return this.getComponent().hashCode();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ComponentWrapper)) {
            return false;
        }
        return this.c.equals(((ComponentWrapper)o).getComponent());
    }

    public int getContentBias() {
        return this.c instanceof TextArea || Boolean.TRUE.equals(this.c.getClientProperty("migLayout.dynamicAspectRatio")) ? 0 : -1;
    }
}

