/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.xml;

import com.codename1.io.Log;
import com.codename1.ui.html.HTMLUtils;
import com.codename1.xml.Element;
import com.codename1.xml.ParserCallback;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;

public class XMLParser {
    private static char[] buffer;
    private static int buffOffset;
    private static int buffSize;
    private static final Element END_TAG;
    private boolean eventParser;
    private boolean caseSensitive;
    ParserCallback parserCallback;
    boolean includeWhitespacesBetweenTags;
    private Hashtable userDefinedCharEntities;
    private static final String CDATA_STR = "DATA[";

    private static int read(Reader is) throws IOException {
        int c = -1;
        if (buffer == null) {
            buffer = new char[8192];
        }
        if (buffSize < 0 || buffOffset >= buffSize) {
            buffSize = is.read(buffer, 0, buffer.length);
            if (buffSize < 0) {
                return -1;
            }
            buffOffset = 0;
        }
        c = buffer[buffOffset];
        ++buffOffset;
        return c;
    }

    protected String getSupportedStandardName() {
        return "XML";
    }

    public void addCharEntity(String symbol, int code) {
        if (this.userDefinedCharEntities == null) {
            this.userDefinedCharEntities = new Hashtable();
        }
        this.userDefinedCharEntities.put(XMLParser.trimCharEntity(symbol), new Integer(code));
    }

    public void addCharEntitiesRange(String[] symbols, int startcode) {
        if (this.userDefinedCharEntities == null) {
            this.userDefinedCharEntities = new Hashtable();
        }
        int slen = symbols.length;
        for (int i = 0; i < slen; ++i) {
            if (symbols[i] == null) continue;
            this.userDefinedCharEntities.put(XMLParser.trimCharEntity(symbols[i]), new Integer(startcode + i));
        }
    }

    private static String trimCharEntity(String symbol) {
        int start = 0;
        int end = symbol.length();
        if (symbol.charAt(0) == '&') {
            start = 1;
        }
        if (symbol.charAt(end - 1) == ';') {
            --end;
        }
        return symbol.substring(start, end);
    }

    protected String convertCharEntity(String charEntity) {
        try {
            return HTMLUtils.convertCharEntity(charEntity, false, this.userDefinedCharEntities);
        }
        catch (IllegalArgumentException iae) {
            this.notifyError(4, null, null, null, "Unrecognized char entity: " + charEntity);
            return '&' + charEntity + ';';
        }
    }

    public Element parse(Reader is) {
        buffOffset = 0;
        buffSize = -1;
        this.eventParser = false;
        Element rootElement = this.createNewElement("ROOT");
        try {
            this.parseTagContent(rootElement, is);
        }
        catch (IOException ioe) {
            Log.e(ioe);
        }
        if (rootElement.getNumChildren() == 0) {
            this.notifyError(8, null, null, null, "XML document contains no root element.");
            return null;
        }
        if (rootElement.getNumChildren() > 1) {
            String roots = "";
            for (int i = 1; i < rootElement.getNumChildren(); ++i) {
                Element elem = rootElement.getChildAt(i);
                roots = elem.isTextElement() ? roots + "Text (" + elem.getText() + ")," : roots + elem.getTagName() + ",";
            }
            if (roots.endsWith(",")) {
                roots = roots.substring(0, roots.length() - 1);
            }
            Element firstRoot = rootElement.getChildAt(0);
            String str = null;
            str = firstRoot.isTextElement() ? "TEXT:" + firstRoot.getText() : firstRoot.getTagName();
            this.notifyError(7, null, null, null, "XML document contains multiple root elements, only the first root (" + str + ") will be used. Excessive roots: " + roots);
        }
        rootElement = rootElement.getChildAt(0);
        return rootElement;
    }

    protected Element createNewElement(String name) {
        Element e = new Element(name);
        e.caseSensitive = this.caseSensitive;
        return e;
    }

    protected Element createNewTextElement(String text) {
        Element e = new Element(text, true);
        e.caseSensitive = this.caseSensitive;
        return e;
    }

    public void setIncludeWhitespacesBetweenTags(boolean include) {
        this.includeWhitespacesBetweenTags = include;
    }

    public void eventParser(Reader r) throws IOException {
        this.eventParser = true;
        this.parseTagContent(null, r);
    }

    protected void textElement(String text) {
    }

    protected boolean startTag(String tag) {
        return true;
    }

    protected void endTag(String tag) {
    }

    protected void attribute(String tag, String attributeName, String value) {
    }

    private boolean isLegalCharEntityCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '#';
    }

    protected void parseTagContent(Element element, Reader is) throws IOException {
        StringBuilder text = null;
        boolean leadingSpace = false;
        int val = XMLParser.read(is);
        char c = (char)val;
        StringBuilder charEntity = null;
        while (val != -1) {
            if (c == '<') {
                Element childElement;
                if (this.includeWhitespacesBetweenTags && leadingSpace && text == null && element != null && element.getNumChildren() > 0) {
                    leadingSpace = false;
                    text = new StringBuilder().append(' ');
                }
                if (text != null) {
                    if (charEntity != null) {
                        text.append('&').append(charEntity.toString());
                        charEntity = null;
                    }
                    if (leadingSpace) {
                        text.insert(0, ' ');
                    }
                    if (element != null) {
                        Element textElement = this.createNewTextElement(text.toString());
                        element.addChild(textElement);
                    } else {
                        this.textElement(text.toString());
                    }
                    text = null;
                    leadingSpace = false;
                }
                if ((childElement = this.parseTag(is)) == END_TAG) {
                    StringBuilder closingTag = new StringBuilder();
                    int i = XMLParser.read(is);
                    if (i == -1) {
                        childElement = END_TAG;
                    } else {
                        c = (char)i;
                        while (c != '>') {
                            closingTag.append(c);
                            i = XMLParser.read(is);
                            c = (char)i;
                            if (i != -1) continue;
                            childElement = END_TAG;
                            break;
                        }
                    }
                    String ct = closingTag.toString();
                    if (this.eventParser) {
                        this.endTag(ct);
                        if (!this.isEmptyTag(ct)) {
                            return;
                        }
                    }
                    if (element != null) {
                        if (ct.equalsIgnoreCase(element.getTagName())) {
                            return;
                        }
                        if (!this.isEmptyTag(ct)) {
                            this.notifyError(3, element.getTagName(), null, null, "Malformed XML - no appropriate closing tag for " + element.getTagName());
                        }
                    }
                } else if (element != null && !childElement.isComment) {
                    element.addChild(childElement);
                }
            } else if (text != null) {
                if (charEntity != null) {
                    if (c == ';') {
                        text.append(this.convertCharEntity(charEntity.toString()));
                        charEntity = null;
                    } else if (this.isLegalCharEntityCharacter(c)) {
                        charEntity.append(c);
                    } else {
                        text.append('&').append((CharSequence)charEntity).append(c);
                        charEntity = null;
                    }
                } else if (c == '&') {
                    charEntity = new StringBuilder();
                } else {
                    text.append(c);
                }
            } else if (!this.isWhiteSpace(c)) {
                if (c == '&') {
                    charEntity = new StringBuilder();
                    text = new StringBuilder();
                } else {
                    text = new StringBuilder().append(c);
                }
            } else {
                leadingSpace = true;
            }
            val = XMLParser.read(is);
            c = (char)val;
        }
    }

    protected boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    protected Element parseTag(Reader is) throws IOException {
        StringBuilder tagName = new StringBuilder();
        StringBuilder curAttribute = new StringBuilder();
        StringBuilder curValue = new StringBuilder();
        char c = (char)XMLParser.read(is);
        if (c == '/') {
            return END_TAG;
        }
        if (c == '!') {
            c = (char)XMLParser.read(is);
            char c2 = (char)XMLParser.read(is);
            if (c == '-' && c2 == '-') {
                return this.parseCommentOrXMLDeclaration(is, "-->");
            }
            if (c == '[' && c2 == 'C') {
                c = (char)XMLParser.read(is);
                int idx = 0;
                int clen = CDATA_STR.length();
                while (idx < clen && c == CDATA_STR.charAt(idx)) {
                    if (++idx >= clen) continue;
                    c = (char)XMLParser.read(is);
                }
                if (idx == clen) {
                    return this.parseCommentOrXMLDeclaration(is, "]]>");
                }
                return this.parseCommentOrXMLDeclaration(is, ">");
            }
            return this.parseCommentOrXMLDeclaration(is, ">");
        }
        if (c == '?') {
            return this.parseCommentOrXMLDeclaration(is, ">");
        }
        while (this.isWhiteSpace(c)) {
            c = (char)XMLParser.read(is);
        }
        while (!this.isWhiteSpace(c) && c != '>' && c != '/') {
            if (!this.eventParser && !this.caseSensitive) {
                c = Character.toLowerCase(c);
            }
            tagName.append(c);
            int i = XMLParser.read(is);
            if (i == -1) {
                return END_TAG;
            }
            c = (char)i;
        }
        while (this.isWhiteSpace(c)) {
            c = (char)XMLParser.read(is);
        }
        boolean processTag = true;
        String tn = tagName.toString();
        if (this.eventParser) {
            processTag = this.startTag(tn);
        }
        Element element = null;
        if (!this.eventParser) {
            element = this.createNewElement(tn);
        }
        if (!processTag || !this.isSupported(element)) {
            this.notifyError(0, tn, null, null, "The tag '" + tn + "' is not supported in " + this.getSupportedStandardName());
            if (!processTag || !this.shouldEvaluate(element)) {
                char lastChar = c;
                while (c != '>') {
                    lastChar = c;
                    int i = XMLParser.read(is);
                    if (i == -1) {
                        return END_TAG;
                    }
                    c = (char)i;
                }
                if (lastChar != '/') {
                    String endTag = "" + '<' + '/' + tagName + '>';
                    int index = 0;
                    int elen = endTag.length();
                    while (index < elen) {
                        int i = XMLParser.read(is);
                        if (i == -1) {
                            return END_TAG;
                        }
                        c = (char)i;
                        if (c >= 'A' && c <= 'Z') {
                            c = (char)(c - 65 + 97);
                        }
                        if (c == endTag.charAt(index)) {
                            ++index;
                            continue;
                        }
                        index = 0;
                    }
                }
                return element;
            }
        }
        if (c == '>') {
            if (!this.isEmptyTag(tn)) {
                this.parseTagContent(element, is);
            }
            return element;
        }
        if (c == '/') {
            c = (char)XMLParser.read(is);
            if (c == '>') {
                if (this.eventParser) {
                    this.endTag(tn);
                }
                return element;
            }
            this.notifyError(6, tn, null, null, "XML malformed - no > after /");
        }
        while (true) {
            int i;
            curAttribute.delete(0, curAttribute.length()).append(c);
            c = (char)XMLParser.read(is);
            while (!this.isWhiteSpace(c) && c != '=' && c != '>') {
                if (!this.eventParser && !this.caseSensitive) {
                    c = Character.toLowerCase(c);
                }
                curAttribute.append(c);
                c = (char)XMLParser.read(is);
            }
            if (c == '>') {
                this.notifyError(5, tn, curAttribute.toString(), null, "Unexpected tag closing in tag " + tagName + ", attribute=" + curAttribute);
                if (!this.isEmptyTag(tn)) {
                    this.parseTagContent(element, is);
                }
                return element;
            }
            while (this.isWhiteSpace(c)) {
                c = (char)XMLParser.read(is);
            }
            if (c != '=') {
                this.notifyError(6, tn, curAttribute.toString(), null, "Unexpected character " + c + ", expected '=' after attribute " + curAttribute.toString() + " in tag " + tagName);
                if (c != '>') continue;
                if (!this.isEmptyTag(tn)) {
                    this.parseTagContent(element, is);
                }
                return element;
            }
            c = (char)XMLParser.read(is);
            while (this.isWhiteSpace(c)) {
                c = (char)XMLParser.read(is);
            }
            char quote = ' ';
            if (c == '\"' || c == '\'') {
                quote = c;
            } else {
                curValue.append(c);
            }
            StringBuilder charEntity = null;
            boolean ended = false;
            while (!ended) {
                i = XMLParser.read(is);
                if (i < 0) {
                    return END_TAG;
                }
                c = (char)i;
                if (c == quote) {
                    ended = true;
                    i = XMLParser.read(is);
                    if (i < 0) {
                        return END_TAG;
                    }
                    c = (char)i;
                    continue;
                }
                if (quote == ' ' && (c == '/' || c == '>' || this.isWhiteSpace(c))) {
                    ended = true;
                    continue;
                }
                if (c == '&') {
                    if (charEntity != null) {
                        curValue.append('&').append((CharSequence)charEntity);
                    }
                    charEntity = new StringBuilder();
                    continue;
                }
                if (charEntity != null) {
                    if (c == ';') {
                        curValue.append(this.convertCharEntity(charEntity.toString()));
                        charEntity = null;
                        continue;
                    }
                    if (this.isLegalCharEntityCharacter(c)) {
                        charEntity.append(c);
                        continue;
                    }
                    curValue.append('&').append((CharSequence)charEntity).append(c);
                    charEntity = null;
                    continue;
                }
                curValue.append(c);
            }
            if (charEntity != null) {
                curValue.append('&').append((CharSequence)charEntity);
                charEntity = null;
            }
            if (this.eventParser) {
                this.attribute(tn, curAttribute.toString(), curValue.toString());
            } else {
                int error = element.setAttribute(curAttribute.toString(), curValue.toString());
                if (error == 1) {
                    this.notifyError(error, tn, curAttribute.toString(), curValue.toString(), "Attribute '" + curAttribute + "' is not supported for tag '" + tagName + "'.");
                } else if (error == 2) {
                    this.notifyError(error, tn, curAttribute.toString(), curValue.toString(), "Attribute '" + curAttribute + "' in tag '" + tn + "' has an invalid value (" + curValue.toString() + ")");
                }
            }
            while (this.isWhiteSpace(c)) {
                i = XMLParser.read(is);
                if (i < 0) {
                    return END_TAG;
                }
                c = (char)i;
            }
            if (c == '>') {
                if (!this.isEmptyTag(tn)) {
                    this.parseTagContent(element, is);
                }
                return element;
            }
            if (c == '/') {
                i = XMLParser.read(is);
                if (i < 0) {
                    return END_TAG;
                }
                c = (char)i;
                if (c == '>') {
                    if (this.eventParser) {
                        this.endTag(tn);
                    }
                    return element;
                }
                this.notifyError(6, tn, curAttribute.toString(), curValue.toString(), "XML malformed - no > after /");
            }
            curValue = curValue.delete(0, curValue.length());
        }
    }

    protected Element parseCommentOrXMLDeclaration(Reader is, String endTag) throws IOException {
        int in;
        char[] endTagChars = endTag.toCharArray();
        int endTagPos = 0;
        StringBuilder text = new StringBuilder();
        boolean ended = false;
        while (!ended && (in = XMLParser.read(is)) != -1) {
            char c = (char)in;
            if (c == endTagChars[endTagPos]) {
                if (++endTagPos != endTagChars.length) continue;
                ended = true;
                continue;
            }
            if (endTagPos != 0) {
                if (c == endTagChars[0] && endTagPos > 1) {
                    text.append(c);
                    continue;
                }
                text.append(endTagChars, 0, endTagPos);
                endTagPos = 0;
            }
            text.append(c);
        }
        String elementName = null;
        if (endTag.equals("-->")) {
            elementName = "comment";
        } else if (endTag.equals(">")) {
            elementName = "XML declaration";
        } else {
            if (this.eventParser) {
                this.textElement(text.toString());
                return null;
            }
            return this.createNewTextElement(text.toString());
        }
        if (this.eventParser) {
            return null;
        }
        Element comment = this.createNewElement(elementName);
        comment.setAttribute("content", text.toString());
        comment.isComment = true;
        return comment;
    }

    protected boolean isEmptyTag(String tagName) {
        return false;
    }

    protected void notifyError(int errorId, String tag, String attribute, String value, String description) {
        boolean cont;
        if (this.parserCallback != null && !(cont = this.parserCallback.parsingError(errorId, tag, attribute, value, description))) {
            throw new IllegalArgumentException(description);
        }
    }

    protected boolean isSupported(Element element) {
        return true;
    }

    protected boolean shouldEvaluate(Element element) {
        return true;
    }

    public void setParserCallback(ParserCallback parserCallback) {
        this.parserCallback = parserCallback;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    static {
        buffSize = -1;
        END_TAG = new Element();
    }
}

