/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.components.InteractionDialog;
import com.codename1.ui.Component;
import com.codename1.ui.Form;
import com.codename1.ui.TextArea;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.util.UITimer;

public class TooltipManager {
    private static TooltipManager instance;
    private int tooltipShowDelay = 500;
    private InteractionDialog currentTooltip;
    private UITimer pendingTooltip;
    private Component currentComponent;
    private String dialogUIID = "TooltipDialog";
    private String textUIID = "Tooltip";

    static TooltipManager getInstance() {
        return instance;
    }

    public static void enableTooltips() {
        instance = new TooltipManager();
    }

    public static void enableTooltips(TooltipManager custom) {
        instance = custom;
    }

    protected TooltipManager() {
    }

    protected void clearTooltip() {
        if (this.currentTooltip != null) {
            this.currentTooltip.dispose();
            this.currentTooltip = null;
        }
        if (this.pendingTooltip != null) {
            this.pendingTooltip.cancel();
            this.pendingTooltip = null;
        }
        this.currentComponent = null;
    }

    protected void prepareTooltip(final String tip, final Component cmp) {
        if (this.currentComponent == cmp) {
            return;
        }
        this.clearTooltip();
        this.currentComponent = cmp;
        this.pendingTooltip = new UITimer(new Runnable(){

            public void run() {
                TooltipManager.this.showTooltip(tip, cmp);
                TooltipManager.this.pendingTooltip = null;
            }
        });
        Form f = cmp.getComponentForm();
        if (f != null) {
            this.pendingTooltip.schedule(this.tooltipShowDelay, false, f);
        }
    }

    protected void showTooltip(String tip, Component cmp) {
        this.currentTooltip = new InteractionDialog(new BorderLayout());
        TextArea text = new TextArea(tip);
        text.setGrowByContent(true);
        text.setEditable(false);
        text.setFocusable(false);
        text.setActAsLabel(true);
        text.setUIID(this.textUIID);
        this.currentTooltip.setUIID(this.dialogUIID);
        this.currentTooltip.setDialogUIID("Container");
        this.currentTooltip.add((Object)"Center", text);
        this.currentTooltip.setAnimateShow(false);
        this.currentTooltip.showPopupDialog(cmp, true);
    }

    public int getTooltipShowDelay() {
        return this.tooltipShowDelay;
    }

    public void setTooltipShowDelay(int tooltipShowDelay) {
        this.tooltipShowDelay = tooltipShowDelay;
    }

    public String getDialogUIID() {
        return this.dialogUIID;
    }

    public void setDialogUIID(String dialogUIID) {
        this.dialogUIID = dialogUIID;
    }

    public String getTextUIID() {
        return this.textUIID;
    }

    public void setTextUIID(String textUIID) {
        this.textUIID = textUIID;
    }
}

