/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.compat;

import com.codename1.ui.Font;
import com.codename1.ui.Graphics;
import com.codename1.ui.geom.Rectangle2D;

public class Paint {
    static Graphics g;
    private boolean antiAlias;
    private Font typeface = Font.createSystemFont(0, 0, 8);
    private int strokeCap = 0;
    private int strokeJoin = 2;
    private float strokeMiter = 1.0f;
    private Style style = Style.STROKE;
    private float strokeWidth = 1.0f;
    private int color;
    private int align;
    private float textSize = 12.0f;

    public void getTextWidths(String text, float[] widths) {
        Font f = this.getTypeface();
        if (f != null) {
            char[] chars = text.toCharArray();
            int clen = chars.length;
            int wlen = widths.length;
            for (int i = 0; i < clen && i < wlen; ++i) {
                widths[i] = f.charWidth(chars[i]);
            }
        } else {
            throw new RuntimeException("Faild to get cn1 font");
        }
    }

    public int breakText(String text, boolean measureForwards, float maxWidth, float[] measuredWidth) {
        char[] chars = text.toCharArray();
        Font f = this.getTypeface();
        float tmp = 0.0f;
        if (f != null) {
            int start = measureForwards ? 0 : chars.length - 1;
            int inc = measureForwards ? 1 : -1;
            float currWidth = 0.0f;
            int clen = chars.length;
            int wlen = measuredWidth != null ? measuredWidth.length : -1;
            for (int i = start; measureForwards && i < clen || !measureForwards && i >= 0; i += inc) {
                tmp = f.charWidth(chars[i]);
                if (currWidth + tmp > maxWidth) {
                    return i;
                }
                if (i < wlen) {
                    measuredWidth[i] = tmp;
                }
                currWidth += tmp;
            }
        } else {
            throw new RuntimeException("Failed to get font");
        }
        return chars.length;
    }

    public void getTextBounds(String string, int start, int count, Rectangle2D rect) {
        Font f = this.getTypeface();
        if (f == null) {
            throw new RuntimeException("Failed to get font");
        }
        this.getCN1TextBounds(string, start, count, rect);
    }

    void getCN1TextBounds(String string, int start, int count, Rectangle2D rect) {
        Font f = this.getTypeface();
        if (f != null) {
            int w = f.substringWidth(string, start, count);
            int h = f.getHeight();
            rect.setBounds(0.0, 0.0, w, h);
        }
    }

    float measureTextHeight(char[] chars, int start, int count) {
        Font f = this.getTypeface();
        float h = 0.0f;
        if (f != null) {
            int clen = chars.length;
            for (int i = start; i < clen && i < start + count; ++i) {
                float nh = f.getHeight();
                h = nh > h ? nh : h;
            }
        } else {
            throw new RuntimeException("Failed to get font");
        }
        return h;
    }

    public float measureText(String newText) {
        return this.measureText(newText.toCharArray(), 0, newText.length());
    }

    public float measureText(char[] chars, int start, int count) {
        float out = 0.0f;
        Font f = this.getTypeface();
        if (f != null) {
            int clen = chars.length;
            for (int i = start; i < clen && i < start + count; ++i) {
                out += (float)f.charWidth(chars[i]);
            }
        } else {
            throw new RuntimeException("Failed to get font");
        }
        return out;
    }

    public void setAntiAlias(boolean antialiasing) {
        this.antiAlias = antialiasing;
    }

    public Font getTypeface() {
        return this.typeface;
    }

    public void setTypeface(Font textTypeface) {
        this.typeface = textTypeface;
    }

    public int getStrokeCap() {
        return this.strokeCap;
    }

    public int getStrokeJoin() {
        return this.strokeJoin;
    }

    public float getStrokeMiter() {
        return this.strokeMiter;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStrokeCap(int cap) {
        this.strokeCap = cap;
    }

    public void setStrokeJoin(int join) {
        this.strokeJoin = join;
    }

    public void setStrokeMiter(float miter) {
        this.strokeMiter = miter;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(float i) {
        this.strokeWidth = i;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public void setTextAlign(int align) {
        this.align = align;
    }

    public int getTextAlign() {
        return this.align;
    }

    public void setTextSize(float size) {
        this.textSize = size;
        if (this.typeface != null) {
            this.typeface = this.typeface.derive(size, 0);
        }
    }

    public float getTextSize() {
        return this.textSize;
    }

    public String toString() {
        return "Paint[ color:" + this.color + ", align:" + this.align + ", textSize:" + this.textSize + ", style:" + (Object)((Object)this.style) + ", strokeWidth:" + this.strokeWidth + ",, strokeMiter:" + this.strokeMiter + ", strokeJoin:" + this.strokeJoin + " strokeCap:" + this.strokeCap + "]";
    }

    public static class Join {
        public static final int BEVEL = 2;
        public static final int MITER = 0;
        public static final int ROUND = 1;
    }

    public static class Cap {
        public static final int BUTT = 0;
        public static final int ROUND = 1;
        public static final int SQUARE = 2;
    }

    public static class Align {
        public static final int CENTER = 4;
        public static final int LEFT = 1;
        public static final int RIGHT = 3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        FILL,
        FILL_AND_STROKE,
        STROKE;

    }
}

