/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.views;

import com.codename1.charts.compat.Canvas;
import com.codename1.charts.compat.Paint;
import com.codename1.charts.models.XYMultipleSeriesDataset;
import com.codename1.charts.models.XYValueSeries;
import com.codename1.charts.renderers.SimpleSeriesRenderer;
import com.codename1.charts.renderers.XYMultipleSeriesRenderer;
import com.codename1.charts.renderers.XYSeriesRenderer;
import com.codename1.charts.views.ClickableArea;
import com.codename1.charts.views.PkgUtils;
import com.codename1.charts.views.XYChart;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BubbleChart
extends XYChart {
    public static final String TYPE = "Bubble";
    private static final int SHAPE_WIDTH = 10;
    private static final int MIN_BUBBLE_SIZE = 2;
    private static final int MAX_BUBBLE_SIZE = 20;

    BubbleChart() {
    }

    public BubbleChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super(dataset, renderer);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, List<Float> points, XYSeriesRenderer renderer, float yAxisValue, int seriesIndex, int startIndex) {
        paint.setColor(renderer.getColor());
        paint.setStyle(Paint.Style.FILL);
        int length = points.size();
        XYValueSeries series = (XYValueSeries)this.mDataset.getSeriesAt(seriesIndex);
        double max = series.getMaxValue();
        double coef = 20.0 / max;
        for (int i = 0; i < length; i += 2) {
            double size = series.getValue(startIndex + i / 2) * coef + 2.0;
            this.drawCircle(canvas, paint, points.get(i).floatValue(), points.get(i + 1).floatValue(), (float)size);
        }
    }

    @Override
    protected ClickableArea[] clickableAreasForPoints(List<Float> points, List<Double> values, float yAxisValue, int seriesIndex, int startIndex) {
        int length = points.size();
        XYValueSeries series = (XYValueSeries)this.mDataset.getSeriesAt(seriesIndex);
        double max = series.getMaxValue();
        double coef = 20.0 / max;
        ClickableArea[] ret = new ClickableArea[length / 2];
        for (int i = 0; i < length; i += 2) {
            double size = series.getValue(startIndex + i / 2) * coef + 2.0;
            ret[i / 2] = new ClickableArea(PkgUtils.makeRect(points.get(i).floatValue() - (float)size, points.get(i + 1).floatValue() - (float)size, points.get(i).floatValue() + (float)size, points.get(i + 1).floatValue() + (float)size), values.get(i), values.get(i + 1));
        }
        return ret;
    }

    @Override
    public int getLegendShapeWidth(int seriesIndex) {
        return 10;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer renderer, float x, float y, int seriesIndex, Paint paint) {
        paint.setStyle(Paint.Style.FILL);
        this.drawCircle(canvas, paint, x + 10.0f, y, 3.0f);
    }

    private void drawCircle(Canvas canvas, Paint paint, float x, float y, float radius) {
        canvas.drawCircle(x, y, radius, paint);
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

