/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.ui.ButtonGroup;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.RadioButton;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.ActionSource;
import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.events.SelectionListener;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.list.DefaultListModel;
import com.codename1.ui.list.ListModel;
import com.codename1.ui.list.MultipleSelectionListModel;
import com.codename1.ui.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class ButtonList
extends Container
implements DataChangedListener,
SelectionListener,
ActionListener,
ActionSource {
    private ButtonGroup group;
    private ListModel model;
    private EventDispatcher actionListeners = new EventDispatcher();
    protected boolean ready;
    private List<Runnable> onReady = new ArrayList<Runnable>();
    private String cellUIID;
    private List<Decorator> decorators;

    protected void onReady(Runnable r) {
        if (this.ready) {
            r.run();
        } else {
            this.onReady.add(r);
        }
    }

    protected void fireReady() {
        for (Runnable r : this.onReady) {
            r.run();
        }
        this.onReady.clear();
    }

    public ButtonList(ListModel model) {
        if (model instanceof DefaultListModel && this.isAllowMultipleSelection()) {
            ((DefaultListModel)model).setMultiSelectionMode(true);
        }
        this.setModel(model);
    }

    public MultipleSelectionListModel getMultiListModel() {
        if (this.model instanceof MultipleSelectionListModel) {
            return (MultipleSelectionListModel)this.model;
        }
        return null;
    }

    public ListModel getModel() {
        return this.model;
    }

    public abstract boolean isAllowMultipleSelection();

    protected abstract Component createButton(Object var1);

    protected abstract void setSelected(Component var1, boolean var2);

    public void setModel(ListModel model) {
        if (model != this.model) {
            if (this.model != null) {
                this.model.removeDataChangedListener(this);
                this.model.removeSelectionListener(this);
            }
            this.model = model;
            if (this.model != null) {
                this.model.addDataChangedListener(this);
                this.model.addSelectionListener(this);
            }
            if (this.ready) {
                this.refresh();
            } else {
                this.onReady(new Runnable(){

                    public void run() {
                        ButtonList.this.refresh();
                    }
                });
            }
        }
    }

    public void setLayout(Layout layout) {
        if (layout != this.getLayout()) {
            super.setLayout(layout);
            this.refresh();
        }
    }

    public void refresh() {
        this.group = new ButtonGroup();
        this.removeAll();
        int selectedIndex = this.getModel().getSelectedIndex();
        int[] selectedIndices = new int[]{};
        if (this.getModel() instanceof MultipleSelectionListModel) {
            selectedIndices = this.getMultiListModel().getSelectedIndices();
        }
        int len = this.model.getSize();
        for (int i = 0; i < len; ++i) {
            Component b = this.createComponent(this.model.getItemAt(i));
            if (this.isAllowMultipleSelection()) {
                if (Arrays.binarySearch(selectedIndices, i) >= 0) {
                    this.setSelected(b, true);
                }
            } else if (i == selectedIndex) {
                this.setSelected(b, true);
            }
            this.add(b);
        }
    }

    private Component createComponent(Object model) {
        Component b = this.createButton(model);
        b = this.decorateComponent(model, b);
        return b;
    }

    protected Component decorateComponent(Object modelItem, Component b) {
        if (this.cellUIID != null) {
            this.setUIID(this.cellUIID);
        }
        if (b instanceof RadioButton) {
            this.group.add((RadioButton)b);
        }
        if (this.decorators != null) {
            for (Decorator d : this.decorators) {
                d.decorate(modelItem, b);
            }
        }
        return b;
    }

    protected Component undecorateComponent(Component b) {
        if (this.decorators != null) {
            for (Decorator d : this.decorators) {
                d.undecorate(b);
            }
        }
        if (b instanceof RadioButton) {
            this.group.remove((RadioButton)b);
        }
        return b;
    }

    public void dataChanged(int status, int index) {
        switch (status) {
            case 1: {
                this.addComponent(index, this.createComponent(this.model.getItemAt(index)));
                break;
            }
            case 2: {
                Component cmp = this.undecorateComponent(this.getComponentAt(index));
                this.removeComponent(cmp);
                this.addComponent(index, this.createComponent(this.model.getItemAt(index)));
                break;
            }
            case 0: {
                Component cmp = this.undecorateComponent(this.getComponentAt(index));
                this.removeComponent(cmp);
                break;
            }
        }
    }

    public void selectionChanged(int oldSelected, int newSelected) {
        if (this.isAllowMultipleSelection()) {
            if (oldSelected < 0 && newSelected >= 0) {
                Component cmp;
                Component component = cmp = newSelected < this.getComponentCount() ? this.getComponentAt(newSelected) : null;
                if (cmp != null) {
                    this.setSelected(cmp, true);
                }
            } else if (oldSelected >= 0 && newSelected < 0) {
                Component cmp;
                Component component = cmp = oldSelected < this.getComponentCount() ? this.getComponentAt(oldSelected) : null;
                if (cmp != null) {
                    this.setSelected(cmp, false);
                }
            } else {
                Component cmp;
                Component old = this.getComponentAt(oldSelected);
                if (old != null) {
                    this.setSelected(old, false);
                }
                Component component = cmp = newSelected < this.getComponentCount() ? this.getComponentAt(newSelected) : null;
                if (cmp != null) {
                    this.setSelected(cmp, true);
                }
            }
        } else {
            Component cmp;
            if (newSelected >= 0) {
                Component component = cmp = newSelected < this.getComponentCount() ? this.getComponentAt(newSelected) : null;
                if (cmp != null) {
                    this.setSelected(cmp, true);
                }
            }
            if (oldSelected >= 0) {
                cmp = oldSelected < this.getComponentCount() ? this.getComponentAt(oldSelected) : null;
                this.setSelected(cmp, false);
            }
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof Component && this.contains((Component)evt.getSource())) {
            ActionEvent nevt = new ActionEvent(this, evt.getEventType(), evt.getActualComponent(), evt.getX(), evt.getY());
            this.actionListeners.fireActionEvent(nevt);
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.addListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.removeListener(l);
    }

    public void setCellUIID(String uiid) {
        this.cellUIID = uiid;
        for (Component c : this) {
            c.setUIID(this.cellUIID);
        }
    }

    public void addDecorator(Decorator decorator) {
        if (this.decorators == null) {
            this.decorators = new ArrayList<Decorator>();
        }
        this.decorators.add(decorator);
    }

    public void removeDecorator(Decorator decorator) {
        if (this.decorators != null) {
            this.decorators.remove(decorator);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Decorator<M, V extends Component> {
        public void decorate(M var1, V var2);

        public void undecorate(V var1);
    }
}

