/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.util;

abstract class AbstractStringBuilder {
    static final int INITIAL_CAPACITY = 16;
    private char[] value;
    private int count;

    final char[] getValue() {
        return this.value;
    }

    final void set(char[] val, int len) {
        if (val == null) {
            val = new char[]{};
        }
        if (val.length < len) {
            throw new RuntimeException();
        }
        this.value = val;
        this.count = len;
    }

    AbstractStringBuilder() {
        this.value = new char[16];
    }

    AbstractStringBuilder(int capacity) {
        if (capacity < 0) {
            throw new NegativeArraySizeException();
        }
        this.value = new char[capacity];
    }

    AbstractStringBuilder(String string) {
        this.count = string.length();
        this.value = new char[this.count + 16];
        string.getChars(0, this.count, this.value, 0);
    }

    private void enlargeBuffer(int min) {
        int newSize = (this.value.length >> 1) + this.value.length + 2;
        char[] newData = new char[min > newSize ? min : newSize];
        System.arraycopy(this.value, 0, newData, 0, this.count);
        this.value = newData;
    }

    final void appendNull() {
        int newSize = this.count + 4;
        if (newSize > this.value.length) {
            this.enlargeBuffer(newSize);
        }
        this.value[this.count++] = 110;
        this.value[this.count++] = 117;
        this.value[this.count++] = 108;
        this.value[this.count++] = 108;
    }

    final void append0(char[] chars) {
        int newSize = this.count + chars.length;
        if (newSize > this.value.length) {
            this.enlargeBuffer(newSize);
        }
        System.arraycopy(chars, 0, this.value, this.count, chars.length);
        this.count = newSize;
    }

    final void append0(char[] chars, int offset, int length) {
        if (offset > chars.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (length < 0 || chars.length - offset < length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int newSize = this.count + length;
        if (newSize > this.value.length) {
            this.enlargeBuffer(newSize);
        }
        System.arraycopy(chars, offset, this.value, this.count, length);
        this.count = newSize;
    }

    final void append0(char ch) {
        if (this.count == this.value.length) {
            this.enlargeBuffer(this.count + 1);
        }
        this.value[this.count++] = ch;
    }

    final void append0(String string) {
        if (string == null) {
            this.appendNull();
            return;
        }
        int adding = string.length();
        int newSize = this.count + adding;
        if (newSize > this.value.length) {
            this.enlargeBuffer(newSize);
        }
        string.getChars(0, adding, this.value, this.count);
        this.count = newSize;
    }

    public int capacity() {
        return this.value.length;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    final void delete0(int start, int end) {
        if (start >= 0) {
            if (end > this.count) {
                end = this.count;
            }
            if (end == start) {
                return;
            }
            if (end > start) {
                int length = this.count - end;
                if (length >= 0) {
                    System.arraycopy(this.value, end, this.value, start, length);
                }
                this.count -= end - start;
                return;
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    final void deleteCharAt0(int location) {
        if (0 > location || location >= this.count) {
            throw new StringIndexOutOfBoundsException(location);
        }
        int length = this.count - location - 1;
        if (length > 0) {
            System.arraycopy(this.value, location + 1, this.value, location, length);
        }
        --this.count;
    }

    public void ensureCapacity(int min) {
        if (min > this.value.length) {
            int twice = (this.value.length << 1) + 2;
            this.enlargeBuffer(twice > min ? twice : min);
        }
    }

    public void getChars(int start, int end, char[] dest, int destStart) {
        if (start > this.count || end > this.count || start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.value, start, dest, destStart, end - start);
    }

    final void insert0(int index, char[] chars) {
        if (0 > index || index > this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (chars.length != 0) {
            this.move(chars.length, index);
            System.arraycopy(chars, 0, this.value, index, chars.length);
            this.count += chars.length;
        }
    }

    final void insert0(int index, char[] chars, int start, int length) {
        if (0 <= index && index <= this.count) {
            if (start >= 0 && 0 <= length && length <= chars.length - start) {
                if (length != 0) {
                    this.move(length, index);
                    System.arraycopy(chars, start, this.value, index, length);
                    this.count += length;
                }
                return;
            }
            throw new StringIndexOutOfBoundsException("offset " + start + ", length " + length + ", char[].length " + chars.length);
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    final void insert0(int index, char ch) {
        if (0 > index || index > this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.move(1, index);
        this.value[index] = ch;
        ++this.count;
    }

    final void insert0(int index, String string) {
        if (0 <= index && index <= this.count) {
            int min;
            if (string == null) {
                string = "null";
            }
            if ((min = string.length()) != 0) {
                this.move(min, index);
                string.getChars(0, min, this.value, index);
                this.count += min;
            }
        } else {
            throw new StringIndexOutOfBoundsException(index);
        }
    }

    public int length() {
        return this.count;
    }

    private void move(int size, int index) {
        if (this.value.length - this.count >= size) {
            System.arraycopy(this.value, index, this.value, index + size, this.count - index);
            return;
        }
        int a = this.count + size;
        int b = (this.value.length << 1) + 2;
        int newSize = a > b ? a : b;
        char[] newData = new char[newSize];
        System.arraycopy(this.value, 0, newData, 0, index);
        System.arraycopy(this.value, index, newData, index + size, this.count - index);
        this.value = newData;
    }

    final void replace0(int start, int end, String string) {
        if (start >= 0) {
            if (end > this.count) {
                end = this.count;
            }
            if (end > start) {
                int stringLength = string.length();
                int diff = end - start - stringLength;
                if (diff > 0) {
                    System.arraycopy(this.value, end, this.value, start + stringLength, this.count - end);
                } else if (diff < 0) {
                    this.move(-diff, end);
                }
                string.getChars(0, stringLength, this.value, start);
                this.count -= diff;
                return;
            }
            if (start == end) {
                if (string == null) {
                    throw new NullPointerException();
                }
                this.insert0(start, string);
                return;
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    final void reverse0() {
        if (this.count < 2) {
            return;
        }
        int end = this.count - 1;
        char frontHigh = this.value[0];
        char endLow = this.value[end];
        boolean allowFrontSur = true;
        boolean allowEndSur = true;
        int i = 0;
        int mid = this.count / 2;
        while (i < mid) {
            boolean surAtFront;
            char frontLow = this.value[i + 1];
            char endHigh = this.value[end - 1];
            boolean bl = surAtFront = allowFrontSur && frontLow >= '\udc00' && frontLow <= '\udfff' && frontHigh >= '\ud800' && frontHigh <= '\udbff';
            if (surAtFront && this.count < 3) {
                return;
            }
            boolean surAtEnd = allowEndSur && endHigh >= '\ud800' && endHigh <= '\udbff' && endLow >= '\udc00' && endLow <= '\udfff';
            allowEndSur = true;
            allowFrontSur = true;
            if (surAtFront == surAtEnd) {
                if (surAtFront) {
                    this.value[end] = frontLow;
                    this.value[end - 1] = frontHigh;
                    this.value[i] = endHigh;
                    this.value[i + 1] = endLow;
                    frontHigh = this.value[i + 2];
                    endLow = this.value[end - 2];
                    ++i;
                    --end;
                } else {
                    this.value[end] = frontHigh;
                    this.value[i] = endLow;
                    frontHigh = frontLow;
                    endLow = endHigh;
                }
            } else if (surAtFront) {
                this.value[end] = frontLow;
                this.value[i] = endLow;
                endLow = endHigh;
                allowFrontSur = false;
            } else {
                this.value[end] = frontHigh;
                this.value[i] = endHigh;
                frontHigh = frontLow;
                allowEndSur = false;
            }
            ++i;
            --end;
        }
        if (!((this.count & 1) != 1 || allowFrontSur && allowEndSur)) {
            this.value[end] = allowFrontSur ? endLow : frontHigh;
        }
    }

    public void setCharAt(int index, char ch) {
        if (0 > index || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    public void setLength(int length) {
        if (length < 0) {
            throw new StringIndexOutOfBoundsException(length);
        }
        if (length > this.value.length) {
            this.enlargeBuffer(length);
        } else if (this.count < length) {
            for (int iter = this.count; iter < this.count + length; ++iter) {
                this.value[iter] = '\u0000';
            }
        }
        this.count = length;
    }

    public String substring(int start) {
        if (0 <= start && start <= this.count) {
            if (start == this.count) {
                return "";
            }
            return new String(this.value, start, this.count - start);
        }
        throw new StringIndexOutOfBoundsException(start);
    }

    public String substring(int start, int end) {
        if (0 <= start && start <= end && end <= this.count) {
            if (start == end) {
                return "";
            }
            return new String(this.value, start, end - start);
        }
        throw new StringIndexOutOfBoundsException();
    }

    public String toString() {
        if (this.count == 0) {
            return "";
        }
        return new String(this.value, 0, this.count);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String subString, int start) {
        int subCount;
        if (start < 0) {
            start = 0;
        }
        if ((subCount = subString.length()) > 0) {
            if (subCount + start > this.count) {
                return -1;
            }
            char firstChar = subString.charAt(0);
            while (true) {
                int i;
                boolean found = false;
                for (i = start; i < this.count; ++i) {
                    if (this.value[i] != firstChar) continue;
                    found = true;
                    break;
                }
                if (!found || subCount + i > this.count) {
                    return -1;
                }
                int o1 = i;
                int o2 = 0;
                while (++o2 < subCount && this.value[++o1] == subString.charAt(o2)) {
                }
                if (o2 == subCount) {
                    return i;
                }
                start = i + 1;
            }
        }
        return start < this.count || start == 0 ? start : this.count;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String subString, int start) {
        int subCount = subString.length();
        if (subCount <= this.count && start >= 0) {
            if (subCount > 0) {
                if (start > this.count - subCount) {
                    start = this.count - subCount;
                }
                char firstChar = subString.charAt(0);
                while (true) {
                    int i;
                    boolean found = false;
                    for (i = start; i >= 0; --i) {
                        if (this.value[i] != firstChar) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        return -1;
                    }
                    int o1 = i;
                    int o2 = 0;
                    while (++o2 < subCount && this.value[++o1] == subString.charAt(o2)) {
                    }
                    if (o2 == subCount) {
                        return i;
                    }
                    start = i - 1;
                }
            }
            return start < this.count ? start : this.count;
        }
        return -1;
    }

    public void trimToSize() {
        if (this.count < this.value.length) {
            char[] newValue = new char[this.count];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
    }

    public int codePointAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return Character.codePointAt(this.value, index, this.count);
    }

    public int codePointBefore(int index) {
        if (index < 1 || index > this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return Character.codePointBefore(this.value, index);
    }

    public int codePointCount(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.count || beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException();
        }
        return Character.codePointCount(this.value, beginIndex, endIndex - beginIndex);
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        return Character.offsetByCodePoints(this.value, 0, this.count, index, codePointOffset);
    }
}

