/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.util;

public class ColorUtil {
    public static int LTGRAY = IColor.LightGray.argb;
    public static int BLUE = IColor.Blue.argb;
    public static int BLACK = IColor.Black.argb;
    public static int WHITE = IColor.White.argb;
    public static int CYAN = IColor.Cyan.argb;
    public static int GREEN = IColor.Green.argb;
    public static int YELLOW = IColor.Yellow.argb;
    public static int MAGENTA = IColor.Magenta.argb;
    public static int GRAY = IColor.Gray.argb;

    public static int argb(int a, int r, int g, int b) {
        IColor c = new IColor(a, r, g, b);
        return c.argb;
    }

    public static int alpha(int c) {
        IColor pc = new IColor(c);
        return pc.alpha;
    }

    public static int red(int c) {
        IColor pc = new IColor(c);
        return pc.red;
    }

    public static int green(int c) {
        IColor pc = new IColor(c);
        return pc.green;
    }

    public static int blue(int c) {
        IColor pc = new IColor(c);
        return pc.blue;
    }

    public static int rgb(int r, int g, int b) {
        IColor c = new IColor(r, g, b);
        return c.argb;
    }

    private static class IColor
    implements Cloneable {
        public static final IColor White = new IColor(255, 255, 255);
        public static final IColor LightGray = new IColor(192, 192, 192);
        public static final IColor Gray = new IColor(128, 128, 128);
        public static final IColor DarkGray = new IColor(64, 64, 64);
        public static final IColor Black = new IColor(0, 0, 0);
        public static final IColor Red = new IColor(255, 0, 0);
        public static final IColor Pink = new IColor(255, 175, 175);
        public static final IColor Orange = new IColor(255, 200, 0);
        public static final IColor Yellow = new IColor(255, 255, 0);
        public static final IColor Green = new IColor(0, 255, 0);
        public static final IColor Magenta = new IColor(255, 0, 255);
        public static final IColor Cyan = new IColor(0, 255, 255);
        public static final IColor Blue = new IColor(0, 0, 255);
        public final int alpha;
        public final int red;
        public final int green;
        public final int blue;
        public final int argb;

        public IColor(int argb) {
            int a = argb >>> 24 & 0xFF;
            this.alpha = 0 == a ? 255 : a;
            this.red = argb >>> 16 & 0xFF;
            this.green = argb >>> 8 & 0xFF;
            this.blue = argb & 0xFF;
            this.argb = IColor.ToARGB(this);
        }

        public IColor(int r, int g, int b) {
            this(255, r, g, b);
        }

        public IColor(int a, int r, int g, int b) {
            this.alpha = a & 0xFF;
            this.red = r & 0xFF;
            this.green = g & 0xFF;
            this.blue = b & 0xFF;
            this.argb = IColor.ToARGB(this);
        }

        public IColor clone() {
            throw new RuntimeException();
        }

        public int hashCode() {
            return this.argb;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (null == that) {
                return false;
            }
            if (that instanceof IColor) {
                return this.hashCode() == that.hashCode();
            }
            return false;
        }

        private static final int ToARGB(IColor c) {
            return c.alpha << 24 | c.red << 16 | c.green << 8 | c.blue & 0xFF;
        }

        public String toString() {
            return "{Red:" + this.red + " Green:" + this.green + " Blue:" + this.blue + " Alpha:" + this.alpha + "}";
        }

        public static class Transparent
        extends IColor {
            public static final Transparent White = new Transparent(255, 255, 255);
            public static final Transparent LightGray = new Transparent(192, 192, 192);
            public static final Transparent Gray = new Transparent(128, 128, 128);
            public static final Transparent DarkGray = new Transparent(64, 64, 64);
            public static final Transparent Black = new Transparent(0, 0, 0);
            public static final Transparent Red = new Transparent(255, 0, 0);
            public static final Transparent Pink = new Transparent(255, 175, 175);
            public static final Transparent Orange = new Transparent(255, 200, 0);
            public static final Transparent Yellow = new Transparent(255, 255, 0);
            public static final Transparent Green = new Transparent(0, 255, 0);
            public static final Transparent Magenta = new Transparent(255, 0, 255);
            public static final Transparent Cyan = new Transparent(0, 255, 255);
            public static final Transparent Blue = new Transparent(0, 0, 255);

            public Transparent(int r, int g, int b) {
                super(0, r, g, b);
            }
        }
    }
}

