/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.views;

import com.codename1.charts.compat.Canvas;
import com.codename1.charts.compat.Paint;
import com.codename1.charts.models.XYMultipleSeriesDataset;
import com.codename1.charts.renderers.SimpleSeriesRenderer;
import com.codename1.charts.renderers.XYMultipleSeriesRenderer;
import com.codename1.charts.renderers.XYSeriesRenderer;
import com.codename1.charts.views.ClickableArea;
import com.codename1.charts.views.PkgUtils;
import com.codename1.charts.views.PointStyle;
import com.codename1.charts.views.ScatterChart;
import com.codename1.charts.views.XYChart;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineChart
extends XYChart {
    public static final String TYPE = "Line";
    private static final int SHAPE_WIDTH = 30;
    private ScatterChart pointsChart;

    LineChart() {
    }

    public LineChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super(dataset, renderer);
        this.pointsChart = new ScatterChart(dataset, renderer);
    }

    @Override
    protected void setDatasetRenderer(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super.setDatasetRenderer(dataset, renderer);
        this.pointsChart = new ScatterChart(dataset, renderer);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, List<Float> points, XYSeriesRenderer renderer, float yAxisValue, int seriesIndex, int startIndex) {
        XYSeriesRenderer.FillOutsideLine[] fillOutsideLine;
        float lineWidth = paint.getStrokeWidth();
        paint.setStrokeWidth(renderer.getLineWidth());
        for (XYSeriesRenderer.FillOutsideLine fill : fillOutsideLine = renderer.getFillOutsideLine()) {
            int length;
            float referencePoint;
            if (fill.getType() == XYSeriesRenderer.FillOutsideLine.Type.NONE) continue;
            paint.setColor(fill.getColor());
            ArrayList<Float> fillPoints = new ArrayList<Float>();
            int[] range = fill.getFillRange();
            if (range == null) {
                fillPoints.addAll(points);
            } else if (points.size() > range[0] * 2 && points.size() > range[1] * 2) {
                fillPoints.addAll(points.subList(range[0] * 2, range[1] * 2));
            }
            XYSeriesRenderer.FillOutsideLine.Type tt = fill.getType();
            if (tt == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_ALL || tt == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_BELOW || tt == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_ABOVE) {
                referencePoint = yAxisValue;
            } else if (tt == XYSeriesRenderer.FillOutsideLine.Type.BELOW) {
                referencePoint = canvas.getHeight();
            } else if (tt == XYSeriesRenderer.FillOutsideLine.Type.ABOVE) {
                referencePoint = 0.0f;
            } else {
                throw new RuntimeException("You have added a new type of filling but have not implemented.");
            }
            if (fill.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_ABOVE || fill.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_BELOW) {
                ArrayList boundsPoints = new ArrayList();
                boolean add = false;
                int length2 = fillPoints.size();
                if (length2 > 0 && fill.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_ABOVE && ((Float)fillPoints.get(1)).floatValue() < referencePoint || fill.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_BELOW && ((Float)fillPoints.get(1)).floatValue() > referencePoint) {
                    boundsPoints.add(fillPoints.get(0));
                    boundsPoints.add(fillPoints.get(1));
                    add = true;
                }
                for (int i = 3; i < length2; i += 2) {
                    float prevValue = ((Float)fillPoints.get(i - 2)).floatValue();
                    float value = ((Float)fillPoints.get(i)).floatValue();
                    if (prevValue < referencePoint && value > referencePoint || prevValue > referencePoint && value < referencePoint) {
                        float prevX = ((Float)fillPoints.get(i - 3)).floatValue();
                        float x = ((Float)fillPoints.get(i - 1)).floatValue();
                        boundsPoints.add(Float.valueOf(prevX + (x - prevX) * (referencePoint - prevValue) / (value - prevValue)));
                        boundsPoints.add(Float.valueOf(referencePoint));
                        if (fill.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_ABOVE && value > referencePoint || fill.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_BELOW && value < referencePoint) {
                            i += 2;
                            add = false;
                            continue;
                        }
                        boundsPoints.add(Float.valueOf(x));
                        boundsPoints.add(Float.valueOf(value));
                        add = true;
                        continue;
                    }
                    if (!(add || fill.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_ABOVE && value < referencePoint) && (fill.getType() != XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_BELOW || !(value > referencePoint))) continue;
                    boundsPoints.add(fillPoints.get(i - 1));
                    boundsPoints.add(Float.valueOf(value));
                }
                fillPoints.clear();
                fillPoints.addAll(boundsPoints);
            }
            if ((length = fillPoints.size()) <= 0) continue;
            fillPoints.set(0, Float.valueOf(((Float)fillPoints.get(0)).floatValue() + 1.0f));
            fillPoints.add((Float)fillPoints.get(length - 2));
            fillPoints.add(Float.valueOf(referencePoint));
            fillPoints.add((Float)fillPoints.get(0));
            fillPoints.add((Float)fillPoints.get(length + 1));
            for (int i = 0; i < length + 4; i += 2) {
                if (!(((Float)fillPoints.get(i + 1)).floatValue() < 0.0f)) continue;
                fillPoints.set(i + 1, Float.valueOf(0.0f));
            }
            paint.setStyle(Paint.Style.FILL);
            this.drawPath(canvas, fillPoints, paint, true);
        }
        paint.setColor(renderer.getColor());
        paint.setStyle(Paint.Style.STROKE);
        this.drawPath(canvas, points, paint, false);
        paint.setStrokeWidth(lineWidth);
    }

    @Override
    protected ClickableArea[] clickableAreasForPoints(List<Float> points, List<Double> values, float yAxisValue, int seriesIndex, int startIndex) {
        int length = points.size();
        ClickableArea[] ret = new ClickableArea[length / 2];
        for (int i = 0; i < length; i += 2) {
            int selectableBuffer = this.mRenderer.getSelectableBuffer();
            ret[i / 2] = new ClickableArea(PkgUtils.makeRect(points.get(i).floatValue() - (float)selectableBuffer, points.get(i + 1).floatValue() - (float)selectableBuffer, points.get(i).floatValue() + (float)selectableBuffer, points.get(i + 1).floatValue() + (float)selectableBuffer), values.get(i), values.get(i + 1));
        }
        return ret;
    }

    @Override
    public int getLegendShapeWidth(int seriesIndex) {
        return 30;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer renderer, float x, float y, int seriesIndex, Paint paint) {
        canvas.drawLine(x, y, x + 30.0f, y, paint);
        if (this.isRenderPoints(renderer)) {
            this.pointsChart.drawLegendShape(canvas, renderer, x + 5.0f, y, seriesIndex, paint);
        }
    }

    @Override
    public boolean isRenderPoints(SimpleSeriesRenderer renderer) {
        return ((XYSeriesRenderer)renderer).getPointStyle() != PointStyle.POINT;
    }

    @Override
    public ScatterChart getPointsChart() {
        return this.pointsChart;
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

