/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.spinner;

import com.codename1.l10n.L10NManager;
import com.codename1.l10n.SimpleDateFormat;
import com.codename1.ui.CN;
import com.codename1.ui.Container;
import com.codename1.ui.Graphics;
import com.codename1.ui.Label;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.spinner.InternalPickerWidget;
import com.codename1.ui.spinner.Spinner3D;
import com.codename1.ui.spinner.SpinnerNode;
import com.codename1.ui.spinner.SpinnerNumberModel;
import java.util.Calendar;
import java.util.Date;

class DateSpinner3D
extends Container
implements InternalPickerWidget {
    private Spinner3D month;
    private Spinner3D day;
    private Spinner3D year;
    private boolean explicitStartYear;
    private boolean explicitEndYear;
    private boolean explicitStartMonth;
    private boolean explicitEndMonth;
    private boolean explicitStartDay;
    private boolean explicitEndDay;
    private boolean explicitCurrentYear;
    private int startYear = 1970;
    private int endYear = 2100;
    private int startMonth = 1;
    private int endMonth = 13;
    private int startDay = 1;
    private int endDay = 32;
    private int currentYear;
    private int currentDay;
    private int currentMonth;
    private int hourOfDay;
    private int minuteOfDay;
    private int secondsOfDay;
    private int millisOfDay;
    private boolean monthDayYear = true;
    private boolean numericMonths = false;
    private String monthRenderingPrototype = "WWW";
    private SimpleDateFormat monthFormat = new SimpleDateFormat("MMMM");
    private Container wrapper = new Container(BoxLayout.x());
    private Calendar tmpCal = Calendar.getInstance();

    public DateSpinner3D() {
        this.setLayout(new BorderLayout(2));
        this.add((Object)"Center", this.wrapper);
        Calendar c = Calendar.getInstance();
        this.currentDay = c.get(5);
        this.currentMonth = c.get(2) + 1;
        this.currentYear = c.get(1);
        String firstChar = L10NManager.getInstance().formatDateLongStyle(new Date()).substring(0, 1);
        this.monthDayYear = !firstChar.toLowerCase().equals(firstChar.toUpperCase());
        this.initSpinner();
    }

    protected void initComponent() {
        super.initComponent();
        this.monthFormat.getDateFormatSymbols().setResourceBundle(this.getUIManager().getResourceBundle());
    }

    void initSpinner() {
        if (this.month == null) {
            this.day = Spinner3D.create(1, 32, this.currentDay, 1);
            this.day.setRowFormatter(new SpinnerNode.RowFormatter(){

                public String format(String input) {
                    if (input != null) {
                        return String.valueOf(new Double(Double.parseDouble(input)).intValue());
                    }
                    return null;
                }
            });
            this.month = Spinner3D.create(1, 13, this.currentMonth, 1);
            this.month.setRowFormatter(new SpinnerNode.RowFormatter(){

                public String format(String input) {
                    if (input != null) {
                        Calendar c = Calendar.getInstance();
                        c.set(2, new Double(Double.parseDouble(input)).intValue() - 1);
                        c.set(5, 15);
                        return DateSpinner3D.this.monthFormat.format(c.getTime());
                    }
                    return null;
                }
            });
            this.year = Spinner3D.create(this.startYear, this.endYear, this.currentYear, 1);
            this.year.setRowFormatter(new SpinnerNode.RowFormatter(){

                public String format(String input) {
                    if (input != null) {
                        return String.valueOf(new Double(Double.parseDouble(input)).intValue());
                    }
                    return null;
                }
            });
            this.addComponents();
        }
    }

    private void addComponents() {
        if (this.year != null) {
            Label l = new Label("December", "Spinner3DRow");
            if (this.monthDayYear) {
                this.wrapper.addComponent(this.month);
                this.month.setPreferredW((int)((float)l.getPreferredW() * 1.5f));
                Style monthStyle = Style.createProxyStyle(this.month.getRowStyle(), this.month.getSelectedRowStyle());
                monthStyle.setAlignment(1);
                monthStyle.setPaddingLeft(3.0f);
                l.setText("00");
                this.day.setPreferredW((int)((float)l.getPreferredW() * 1.5f) + CN.convertToPixels(3.0f));
                this.wrapper.addComponent(this.day);
                Style dayStyle = Style.createProxyStyle(this.day.getRowStyle(), this.day.getSelectedRowStyle());
                dayStyle.setAlignment(3);
                dayStyle.setPaddingRight(3.0f);
                l.setText("0000");
                this.year.setPreferredW((int)((float)l.getPreferredW() * 1.5f) + CN.convertToPixels(3.0f));
                this.wrapper.addComponent(this.year);
                Style yearStyle = Style.createProxyStyle(this.year.getRowStyle(), this.year.getSelectedRowStyle());
                yearStyle.setAlignment(3);
                yearStyle.setPaddingRight(3.0f);
            } else {
                this.month.setPreferredW((int)((float)l.getPreferredW() * 1.5f));
                l.setText("00");
                this.day.setPreferredW((int)((float)l.getPreferredW() * 1.5f) + CN.convertToPixels(3.0f));
                l.setText("0000");
                this.year.setPreferredW((int)((float)l.getPreferredW() * 1.5f) + CN.convertToPixels(3.0f));
                this.wrapper.addComponent(this.day);
                Style dayStyle = Style.createProxyStyle(this.day.getRowStyle(), this.day.getSelectedRowStyle());
                dayStyle.setAlignment(3);
                dayStyle.setPaddingRight(3.0f);
                this.wrapper.addComponent(this.month);
                Style monthStyle = Style.createProxyStyle(this.month.getRowStyle(), this.month.getSelectedRowStyle());
                monthStyle.setAlignment(1);
                monthStyle.setPaddingLeft(3.0f);
                Style yearStyle = Style.createProxyStyle(this.year.getRowStyle(), this.year.getSelectedRowStyle());
                yearStyle.setAlignment(3);
                yearStyle.setPaddingRight(3.0f);
                this.wrapper.addComponent(this.year);
            }
        }
    }

    private void rebuildMonth() {
        this.month.setModel(new SpinnerNumberModel(this.startMonth, this.endMonth, Math.max(this.startMonth, Math.min(this.endMonth, this.currentMonth)), 1));
    }

    private void rebuildDay() {
        this.day.setModel(new SpinnerNumberModel(this.startDay, this.endDay, Math.max(this.startDay, Math.min(this.endDay, this.currentDay)), 1));
    }

    public void setDateRange(Date start, Date end) {
        int setStartYear;
        int setEndYear;
        this.explicitStartMonth = true;
        this.explicitEndMonth = true;
        this.explicitStartDay = true;
        this.explicitEndDay = true;
        this.explicitStartYear = true;
        this.explicitEndYear = true;
        int n = setEndYear = end == null ? 2100 : this.getYear(end) + 1900 + 1;
        if (!this.explicitCurrentYear && this.currentYear > setEndYear - 1) {
            this.currentYear = setEndYear - 1;
        }
        this.setEndYear(setEndYear);
        int n2 = setStartYear = start == null ? 1970 : this.getYear(start) + 1900;
        if (!this.explicitCurrentYear && this.currentYear < setStartYear) {
            this.currentYear = setStartYear;
        }
        this.setStartYear(setStartYear);
        if (start != null && end != null && this.getYear(start) == this.getYear(end)) {
            this.startMonth = this.getMonth(start) + 1;
            this.endMonth = this.getMonth(end) + 2;
        } else {
            this.startMonth = 1;
            this.endMonth = 13;
        }
        this.rebuildMonth();
        if (start != null && end != null && this.getYear(start) == this.getYear(end) && this.getMonth(start) == this.getMonth(end)) {
            this.startDay = this.getDate(start);
            this.endDay = this.getDate(end) + 1;
        } else {
            this.startDay = 1;
            this.endDay = 32;
        }
        this.rebuildDay();
    }

    private int getDate(Date dt) {
        this.tmpCal.setTime(dt);
        return this.tmpCal.get(5);
    }

    private int getMonth(Date dt) {
        this.tmpCal.setTime(dt);
        return this.tmpCal.get(2);
    }

    private int getYear(Date dt) {
        this.tmpCal.setTime(dt);
        return this.tmpCal.get(1) - 1900;
    }

    public int getStartMonth() {
        return this.startMonth;
    }

    public int getEndMonth() {
        return this.endMonth;
    }

    public int getStartDay() {
        return this.startDay;
    }

    public int getEndDay() {
        return this.endDay;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
        this.explicitStartYear = true;
        if (this.year != null) {
            this.year.setModel(new SpinnerNumberModel(startYear, this.endYear, this.currentYear, 1));
        }
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
        this.explicitEndYear = true;
        if (this.year != null) {
            this.year.setModel(new SpinnerNumberModel(this.startYear, endYear, this.currentYear, 1));
        }
    }

    public int getCurrentYear() {
        if (this.year != null) {
            return (Integer)this.year.getValue();
        }
        return this.currentYear;
    }

    public void setCurrentYear(int currentYear) {
        this.currentYear = currentYear;
        this.explicitCurrentYear = true;
        if (!this.explicitStartYear && this.startYear > currentYear) {
            this.startYear = currentYear;
        }
        if (!this.explicitEndYear && this.endYear - 1 < currentYear) {
            this.endYear = currentYear + 1;
        }
        if (currentYear < this.startYear) {
            throw new IllegalArgumentException("Current year " + currentYear + " before start year " + this.startYear);
        }
        if (currentYear > this.endYear - 1) {
            throw new IllegalArgumentException("Current year " + currentYear + " after end year " + this.endYear);
        }
        if (this.year != null) {
            this.year.setModel(new SpinnerNumberModel(this.startYear, this.endYear, currentYear, 1));
        }
    }

    public int getCurrentDay() {
        Integer i = (Integer)this.day.getValue();
        return i;
    }

    public void setCurrentDay(int currentDay) {
        this.currentDay = currentDay;
        if (!this.explicitStartDay && this.startDay > currentDay) {
            this.startDay = currentDay;
        }
        if (!this.explicitEndDay && this.endDay - 1 < currentDay) {
            this.endDay = currentDay + 1;
        }
        if (this.startDay > currentDay) {
            throw new IllegalArgumentException("Start day " + this.startDay + " after current day " + currentDay);
        }
        if (this.endDay - 1 < currentDay) {
            throw new IllegalArgumentException("End day " + this.endDay + " before current day " + currentDay);
        }
        if (this.day != null) {
            this.rebuildDay();
        }
    }

    public int getCurrentMonth() {
        if (this.month != null) {
            Integer i = ((Integer)this.month.getValue() - 1) % 12 + 1;
            return i;
        }
        return this.currentMonth;
    }

    public void setCurrentMonth(int currentMonth) {
        this.currentMonth = currentMonth;
        if (!this.explicitStartMonth && this.startMonth > currentMonth) {
            this.startMonth = currentMonth;
        }
        if (!this.explicitEndMonth && this.endMonth - 1 < currentMonth) {
            this.endMonth = currentMonth + 1;
        }
        if (this.startMonth > currentMonth) {
            throw new IllegalArgumentException("Start month " + this.startMonth + " after current month " + currentMonth);
        }
        if (this.endMonth - 1 < currentMonth) {
            throw new IllegalArgumentException("End month " + this.endMonth + " before current month " + currentMonth);
        }
        if (this.month != null) {
            this.rebuildMonth();
        }
    }

    public boolean isMonthDayYear() {
        return this.monthDayYear;
    }

    public void setMonthDayYear(boolean monthDayYear) {
        this.monthDayYear = monthDayYear;
        this.wrapper.removeAll();
        this.addComponents();
    }

    public boolean isNumericMonths() {
        return this.numericMonths;
    }

    public void setNumericMonths(boolean numericMonths) {
        this.numericMonths = numericMonths;
        if (this.month != null) {
            this.month.repaint();
        }
    }

    public String[] getPropertyNames() {
        return new String[]{"startYear", "endYear", "currentYear", "currentDay", "currentMonth", "monthDayYear", "numericMonths"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Boolean.class, Boolean.class};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("startYear")) {
            return new Integer(this.startYear);
        }
        if (name.equals("endYear")) {
            return new Integer(this.endYear);
        }
        if (name.equals("currentYear")) {
            return new Integer(this.currentYear);
        }
        if (name.equals("currentDay")) {
            return new Integer(this.currentDay);
        }
        if (name.equals("currentMonth")) {
            return new Integer(this.currentMonth);
        }
        if (name.equals("monthDayYear")) {
            return new Boolean(this.monthDayYear);
        }
        if (name.equals("numericMonths")) {
            return new Boolean(this.numericMonths);
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("startYear")) {
            this.setStartYear(Integer.parseInt(value.toString()));
            return null;
        }
        if (name.equals("endYear")) {
            this.setEndYear(Integer.parseInt(value.toString()));
            return null;
        }
        if (name.equals("currentYear")) {
            this.setCurrentYear(Integer.parseInt(value.toString()));
            return null;
        }
        if (name.equals("currentDay")) {
            this.setCurrentDay(Integer.parseInt(value.toString()));
            return null;
        }
        if (name.equals("currentMonth")) {
            this.setCurrentMonth(Integer.parseInt(value.toString()));
            return null;
        }
        if (name.equals("monthDayYear")) {
            this.setMonthDayYear((Boolean)value);
            return null;
        }
        if (name.equals("numericMonths")) {
            this.setNumericMonths((Boolean)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public Object getValue() {
        Calendar cld = Calendar.getInstance();
        cld.setTime(new Date());
        cld.set(5, this.getCurrentDay());
        cld.set(2, this.getCurrentMonth() - 1);
        cld.set(1, this.getCurrentYear());
        cld.set(11, this.hourOfDay);
        cld.set(12, this.minuteOfDay);
        cld.set(13, this.secondsOfDay);
        cld.set(14, this.millisOfDay);
        return cld.getTime();
    }

    public void setValue(Object value) {
        Date dt = (Date)value;
        Calendar cld = Calendar.getInstance();
        cld.setTime(dt);
        this.setCurrentDay(cld.get(5));
        this.setCurrentMonth(cld.get(2) + 1);
        this.setCurrentYear(cld.get(1));
        this.hourOfDay = cld.get(11);
        this.minuteOfDay = cld.get(12);
        this.secondsOfDay = cld.get(13);
        this.millisOfDay = cld.get(14);
    }

    public void paint(Graphics g) {
        int alpha = g.getAlpha();
        g.setColor(this.year.getSelectedOverlayStyle().getBgColor());
        g.setAlpha(255);
        g.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        g.setAlpha(alpha);
        super.paint(g);
    }
}

