/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.spinner;

import com.codename1.ui.CN;
import com.codename1.ui.Container;
import com.codename1.ui.Graphics;
import com.codename1.ui.Label;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.LayeredLayout;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.spinner.InternalPickerWidget;
import com.codename1.ui.spinner.Spinner3D;
import com.codename1.ui.spinner.SpinnerNode;
import com.codename1.ui.spinner.SpinnerNumberModel;
import java.util.Calendar;
import java.util.Date;

class TimeSpinner3D
extends Container
implements InternalPickerWidget {
    private Spinner3D hour;
    private Spinner3D minute;
    private Spinner3D amPM;
    private int minHour = -1;
    private int maxHour = -1;
    private int startHour = 1;
    private int endHour = 13;
    private int minuteStep = 5;
    private boolean durationMode;
    private boolean showHours = true;
    private boolean showMinutes = true;
    private boolean showMeridiem = true;
    private int currentHour = 8;
    private int currentMinute = 0;
    private boolean currentMeridiem;

    public TimeSpinner3D() {
        this.initSpinner();
    }

    void initSpinner() {
        if (this.hour == null) {
            this.hour = Spinner3D.create(this.startHour, this.endHour, this.currentHour, 1);
            this.hour.setRowFormatter(new SpinnerNode.RowFormatter(){

                public String format(String input) {
                    if (input != null) {
                        return "" + new Double(Double.parseDouble(input)).intValue();
                    }
                    return null;
                }
            });
            Style hourStyle = Style.createProxyStyle(this.hour.getRowStyle(), this.hour.getSelectedRowStyle());
            hourStyle.setAlignment(3);
            hourStyle.setPaddingRight(3.0f);
            this.minute = Spinner3D.create(0, 60, this.currentMinute, this.minuteStep);
            this.minute.setRowFormatter(new SpinnerNode.RowFormatter(){

                public String format(String input) {
                    if (input != null) {
                        Integer value = null;
                        try {
                            value = new Integer(new Double(Double.parseDouble(input)).intValue());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (value != null && value instanceof Integer) {
                            int i = value;
                            if (i < 10) {
                                return "0" + i;
                            }
                            return "" + i;
                        }
                    }
                    return null;
                }
            });
            Style minuteStyle = Style.createProxyStyle(this.minute.getRowStyle(), this.minute.getSelectedRowStyle());
            minuteStyle.setAlignment(3);
            minuteStyle.setPaddingRight(3.0f);
            this.amPM = this.currentMeridiem ? Spinner3D.create(0, 2, 1, 1) : Spinner3D.create(0, 2, 0, 1);
            this.amPM.setRowFormatter(new SpinnerNode.RowFormatter(){

                public String format(String input) {
                    if (Double.parseDouble(input) < 1.0) {
                        return "AM";
                    }
                    return "PM";
                }
            });
            this.addComponents();
        }
    }

    void addComponents() {
        if (this.amPM != null) {
            this.setLayout(new LayeredLayout());
            this.addComponent(this.hour);
            this.addComponent(this.minute);
            LayeredLayout ll = (LayeredLayout)this.getLayout();
            if (this.showMeridiem) {
                this.addComponent(this.amPM);
                ll.setInsets(this.hour, "0 67% 0 0").setInsets(this.minute, "0 33% 0 33%").setInsets(this.amPM, "0 0 0 67%");
            } else {
                ll.setInsets(this.hour, "0 50% 0 0").setInsets(this.minute, "0 0 0 50%");
            }
        }
        this.setHoursVisible(this.showHours);
        this.setMinutesVisible(this.showMinutes);
    }

    protected Dimension calcPreferredSize() {
        Dimension size = super.calcPreferredSize();
        Label l = new Label("00  00  AM", "Spinner3DRow");
        float w = (float)l.getPreferredW() * 1.5f + (float)CN.convertToPixels(10.0f);
        size.setWidth((int)w);
        return size;
    }

    public String[] getPropertyNames() {
        return new String[]{"currentHour", "currentMinute", "minuteStep", "currentMeridiem", "showMeridiem", "durationMode"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{Integer.class, Integer.class, Integer.class, Boolean.class, Boolean.class, Boolean.class};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("durationMode")) {
            if (this.durationMode) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (name.equals("currentHour")) {
            return new Integer(this.currentHour);
        }
        if (name.equals("currentMinute")) {
            return new Integer(this.currentMinute);
        }
        if (name.equals("minuteStep")) {
            return new Integer(this.minuteStep);
        }
        if (name.equals("currentMeridiem")) {
            if (this.currentMeridiem) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (name.equals("showMeridiem")) {
            if (this.showMeridiem) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("currentHour")) {
            this.setCurrentHour(Integer.parseInt(value.toString()));
            return null;
        }
        if (name.equals("currentMinute")) {
            this.setCurrentMinute(Integer.parseInt(value.toString()));
            return null;
        }
        if (name.equals("minuteStep")) {
            this.setMinuteStep(Integer.parseInt(value.toString()));
            return null;
        }
        if (name.equals("currentMeridiem")) {
            this.setCurrentMeridiem((Boolean)value);
            return null;
        }
        if (name.equals("showMeridiem")) {
            this.setShowMeridiem((Boolean)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public int getMinuteStep() {
        return this.minuteStep;
    }

    public void setMinuteStep(int minuteStep) {
        if (minuteStep < 1 || minuteStep > 60) {
            throw new IllegalArgumentException("Minute step must be between 1 and 60");
        }
        this.minuteStep = minuteStep;
        if (this.minute != null) {
            this.minute.setModel(new SpinnerNumberModel(0, 60, this.currentMinute, minuteStep));
        }
    }

    public void setHourRange(int min, int max) {
        if (min >= 0 && max >= min && (this.showMeridiem || this.durationMode)) {
            throw new IllegalStateException("TimeSpinner hour range only applies when isShowMeridiem() is false and durationMode is false.");
        }
        this.minHour = min;
        this.maxHour = max;
        this.rebuildHours();
    }

    public int getMinHour() {
        return this.minHour;
    }

    public int getMaxHour() {
        return this.maxHour;
    }

    public boolean isShowMeridiem() {
        return this.showMeridiem && !this.durationMode;
    }

    private void rebuildHours() {
        if (this.showMeridiem) {
            this.startHour = 1;
            this.endHour = 13;
        } else {
            this.startHour = 0;
            this.endHour = 24;
            if (this.minHour >= 0 && this.minHour <= 24) {
                this.startHour = this.minHour;
            }
            if (this.maxHour >= 0 && this.maxHour <= 24 && this.maxHour > this.startHour) {
                this.endHour = this.maxHour;
            }
        }
        if (this.hour != null) {
            this.hour.setModel(new SpinnerNumberModel(this.startHour, this.endHour, this.currentHour, 1));
        }
        this.removeAll();
        this.addComponents();
        if (this.isInitialized()) {
            this.getParent().revalidate();
        }
    }

    public void setShowMeridiem(boolean showMeridiem) {
        if (this.durationMode) {
            return;
        }
        this.showMeridiem = showMeridiem;
        this.rebuildHours();
    }

    public int getCurrentHour() {
        if (this.hour != null) {
            return (Integer)this.hour.getValue();
        }
        return this.currentHour;
    }

    public void setCurrentHour(int currentHour) {
        this.currentHour = currentHour;
        if (this.hour != null) {
            this.hour.setValue(new Integer(currentHour));
        }
    }

    public int getCurrentMinute() {
        if (this.minute != null) {
            return (Integer)this.minute.getValue();
        }
        return this.currentMinute;
    }

    public void setCurrentMinute(int currentMinute) {
        this.currentMinute = currentMinute;
        if (this.minute != null) {
            this.minute.setValue(new Integer(currentMinute));
        }
    }

    public boolean isCurrentMeridiem() {
        if (this.durationMode) {
            return false;
        }
        if (this.amPM != null) {
            return (Integer)this.amPM.getValue() != 0;
        }
        return this.currentMeridiem;
    }

    public void setCurrentMeridiem(boolean currentMeridiem) {
        if (this.durationMode) {
            return;
        }
        this.currentMeridiem = currentMeridiem;
        if (this.amPM != null) {
            if (currentMeridiem) {
                this.amPM.setValue(new Integer(1));
            } else {
                this.amPM.setValue(new Integer(0));
            }
        }
    }

    public void setHoursVisible(boolean visible) {
        this.showHours = visible;
        this.hour.setVisible(visible);
        this.hour.setHidden(!visible);
    }

    public void setMinutesVisible(boolean visible) {
        this.showMinutes = visible;
        this.minute.setVisible(visible);
        this.minute.setHidden(!visible);
    }

    public Object getValue() {
        Calendar cld = Calendar.getInstance();
        cld.setTime(new Date());
        cld.set(12, this.getCurrentMinute());
        cld.set(13, 0);
        cld.set(14, 0);
        int hour = this.getCurrentHour();
        if (this.showMeridiem && hour == 12) {
            hour = 0;
        }
        cld.set(this.showMeridiem ? 10 : 11, hour);
        if (this.showMeridiem) {
            cld.set(9, this.isCurrentMeridiem() ? 1 : 0);
        }
        Calendar zero = Calendar.getInstance();
        zero.setTime(new Date());
        zero.set(11, 0);
        zero.set(12, 0);
        zero.set(13, 0);
        zero.set(14, 0);
        return (int)((cld.getTime().getTime() - zero.getTime().getTime()) / 1000L / 60L);
    }

    public void setValue(Object value) {
        if (value == null) {
            value = 0;
        }
        Integer dt = (Integer)value;
        Calendar cld = Calendar.getInstance();
        cld.setTime(new Date());
        cld.set(11, 0);
        cld.set(12, 0);
        cld.set(13, 0);
        cld.set(14, 0);
        cld.setTime(new Date(cld.getTime().getTime() + (long)dt.intValue() * 60L * 1000L));
        this.setCurrentMinute(cld.get(12));
        int hour = cld.get(this.showMeridiem ? 10 : 11);
        if (this.showMeridiem && hour == 0) {
            hour = 12;
        }
        this.setCurrentHour(hour);
        this.setCurrentMeridiem(cld.get(9) != 0);
    }

    public void paint(Graphics g) {
        int alpha = g.getAlpha();
        g.setColor(this.hour.getSelectedOverlayStyle().getBgColor());
        g.setAlpha(255);
        g.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        super.paint(g);
    }
}

