/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.table;

import com.codename1.impl.CodenameOneImplementation;
import com.codename1.io.Util;
import com.codename1.ui.Button;
import com.codename1.ui.CheckBox;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.FontImage;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Label;
import com.codename1.ui.TextArea;
import com.codename1.ui.TextField;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.spinner.Picker;
import com.codename1.ui.table.AbstractTableModel;
import com.codename1.ui.table.DefaultTableModel;
import com.codename1.ui.table.SortableTableModel;
import com.codename1.ui.table.TableLayout;
import com.codename1.ui.table.TableModel;
import com.codename1.ui.validation.Constraint;
import com.codename1.ui.validation.Validator;
import com.codename1.util.CaseInsensitiveOrder;
import java.util.Comparator;
import java.util.Date;

public class Table
extends Container {
    public static final int INNER_BORDERS_NONE = 0;
    public static final int INNER_BORDERS_ROWS = 1;
    public static final int INNER_BORDERS_COLS = 2;
    public static final int INNER_BORDERS_ALL = 3;
    private TableModel model;
    private Listener listener = new Listener();
    private boolean drawBorder = true;
    private boolean collapseBorder = true;
    private boolean drawEmptyCellsBorder = true;
    private int horizontalBorderSpacing = 0;
    private int verticalBorderSpacing = 0;
    private boolean includeHeader = true;
    private int innerBorder = 3;
    private int titleAlignment = 4;
    private int cellAlignment = 1;
    private boolean potentiallyDirtyModel;
    private boolean sortSupported;
    private int sortedColumn = -1;
    private boolean ascending;

    public Table() {
        this(new DefaultTableModel(new String[]{"Col1", "Col2"}, new String[][]{{"1", "2"}, {"3", "4"}}));
    }

    public Table(TableModel model) {
        this.setUIID("Table");
        this.model = model;
        this.updateModel();
    }

    public Table(TableModel model, boolean includeHeader) {
        this.setUIID("Table");
        this.includeHeader = includeHeader;
        this.model = model;
        this.updateModel();
    }

    public int getSelectedRow() {
        Component c;
        Form f = this.getComponentForm();
        if (f != null && (c = f.getFocused()) != null) {
            return this.getCellRow(c);
        }
        return -1;
    }

    protected boolean includeNullValues() {
        return false;
    }

    public int getSelectedColumn() {
        Component c;
        Form f = this.getComponentForm();
        if (f != null && (c = f.getFocused()) != null) {
            return this.getCellColumn(c);
        }
        return -1;
    }

    private void updateModel() {
        Component c;
        int selectionRow = -1;
        int selectionColumn = -1;
        Form f = this.getComponentForm();
        if (f != null && (c = f.getFocused()) != null) {
            selectionRow = this.getCellRow(c);
            selectionColumn = this.getCellColumn(c);
        }
        this.removeAll();
        int columnCount = this.model.getColumnCount();
        if (this.includeHeader) {
            this.setLayout(new TableLayout(this.model.getRowCount() + 1, columnCount));
            for (int iter = 0; iter < columnCount; ++iter) {
                String name = this.model.getColumnName(iter);
                Component header = this.createCellImpl(name, -1, iter, false);
                TableLayout.Constraint con = this.createCellConstraint(name, -1, iter);
                this.addComponent(con, header);
            }
        } else {
            this.setLayout(new TableLayout(this.model.getRowCount(), columnCount));
        }
        for (int r = 0; r < this.model.getRowCount(); ++r) {
            for (int c2 = 0; c2 < columnCount; ++c2) {
                boolean e;
                Component cell;
                Object value = this.model.getValueAt(r, c2);
                if (value == null && !this.includeNullValues() || (cell = this.createCellImpl(value, r, c2, e = this.model.isCellEditable(r, c2))) == null) continue;
                TableLayout.Constraint con = this.createCellConstraint(value, r, c2);
                int currentRow = ((TableLayout)this.getLayout()).getNextRow();
                if (r > this.model.getRowCount()) {
                    return;
                }
                this.addComponent(con, cell);
                if (r != selectionRow || c2 != selectionColumn) continue;
                cell.requestFocus();
            }
        }
    }

    protected void paintGlass(Graphics g) {
        if (this.drawBorder && this.innerBorder != 0) {
            int xPos = this.getAbsoluteX();
            int yPos = this.getAbsoluteY();
            g.translate(xPos, yPos);
            int rows = this.model.getRowCount();
            int cols = this.model.getColumnCount();
            if (this.includeHeader) {
                ++rows;
            }
            g.setColor(this.getStyle().getFgColor());
            int alpha = g.concatenateAlpha(this.getStyle().getFgAlpha());
            TableLayout t = (TableLayout)this.getLayout();
            int actualWidth = Math.max(this.getWidth(), this.getScrollDimension().getWidth());
            int actualHeight = Math.max(this.getHeight(), this.getScrollDimension().getHeight());
            if (this.collapseBorder || this.innerBorder != 3 || t.hasHorizontalSpanning() || t.hasVerticalSpanning()) {
                int columnWidth;
                int rowHeight;
                int y;
                int x;
                int cellColumn;
                int cellRow;
                if (this.innerBorder == 3 || this.innerBorder == 1) {
                    if (t.hasVerticalSpanning()) {
                        for (cellRow = 0; cellRow < rows - 1; ++cellRow) {
                            for (cellColumn = 0; cellColumn < cols; ++cellColumn) {
                                if (cellRow + t.getCellVerticalSpan(cellRow, cellColumn) - 1 == rows - 1 || t.isCellSpannedThroughHorizontally(cellRow, cellColumn)) continue;
                                x = t.getColumnPosition(cellColumn);
                                y = t.getRowPosition(cellRow);
                                rowHeight = t.getRowPosition(cellRow + t.getCellVerticalSpan(cellRow, cellColumn)) - y;
                                columnWidth = cellColumn < this.getModel().getColumnCount() - 1 ? t.getColumnPosition(cellColumn + 1) - x : this.getWidth() - y;
                                if (this.innerBorder == 1 && !this.shouldDrawInnerBorderAfterRow(cellRow)) continue;
                                g.drawLine(x, y + rowHeight, x + columnWidth, y + rowHeight);
                            }
                        }
                    } else {
                        for (int row = 1; row < rows; ++row) {
                            int y2 = t.getRowPosition(row);
                            if (this.innerBorder == 1 && !this.shouldDrawInnerBorderAfterRow(row - 1)) continue;
                            g.drawLine(0, y2, actualWidth, y2);
                        }
                    }
                }
                if (this.innerBorder == 3 || this.innerBorder == 2) {
                    if (t.hasHorizontalSpanning()) {
                        for (cellRow = 0; cellRow < rows; ++cellRow) {
                            for (cellColumn = 0; cellColumn < cols - 1; ++cellColumn) {
                                if (cellColumn + t.getCellHorizontalSpan(cellRow, cellColumn) - 1 != cols - 1) {
                                    if (t.isCellSpannedThroughVertically(cellRow, cellColumn)) continue;
                                    x = t.getColumnPosition(cellColumn);
                                    y = t.getRowPosition(cellRow);
                                    columnWidth = t.getColumnPosition(cellColumn + t.getCellHorizontalSpan(cellRow, cellColumn)) - x;
                                    rowHeight = cellRow < this.getModel().getRowCount() - 1 ? t.getRowPosition(cellRow + 1) - y : this.getHeight() - y;
                                    g.drawLine(x + columnWidth, y, x + columnWidth, y + rowHeight);
                                }
                                if (t.getCellHorizontalSpan(cellRow, cellColumn) <= 1) continue;
                                cellColumn += t.getCellHorizontalSpan(cellRow, cellColumn) - 1;
                            }
                        }
                    } else {
                        for (int col = 1; col < cols; ++col) {
                            int x2 = t.getColumnPosition(col);
                            g.drawLine(x2, 0, x2, actualHeight);
                        }
                    }
                }
            } else {
                for (int row = 0; row < rows; ++row) {
                    int y = t.getRowPosition(row);
                    int h = row + 1 < rows ? t.getRowPosition(row + 1) - y : this.getY() + actualHeight - y - 2;
                    for (int col = 0; col < cols; ++col) {
                        int x = t.getColumnPosition(col);
                        int w = col + 1 < cols ? t.getColumnPosition(col + 1) - x : this.getX() + actualWidth - x - 2;
                        Component comp = t.getComponentAt(row, col);
                        if (!comp.isVisible() || !this.drawEmptyCellsBorder && (comp.getWidth() - comp.getStyle().getPaddingRightNoRTL() - comp.getStyle().getPaddingLeftNoRTL() <= 0 || comp.getHeight() - comp.getStyle().getPaddingTop() - comp.getStyle().getPaddingBottom() <= 0)) continue;
                        int rightMargin = comp.getStyle().getMarginRightNoRTL();
                        int bottomMargin = comp.getStyle().getMarginBottom();
                        if (col == 0) {
                            rightMargin *= 2;
                        }
                        if (row == 0) {
                            bottomMargin *= 2;
                        }
                        g.drawRect(x + comp.getStyle().getMarginLeftNoRTL(), y + comp.getStyle().getMarginTop(), w - 2 - rightMargin, h - 2 - bottomMargin);
                    }
                }
            }
            g.translate(-xPos, -yPos);
            g.setAlpha(alpha);
        }
    }

    private Component createCellImpl(Object value, int row, int column, boolean editable) {
        Component c = this.createCell(value, row, column, editable);
        c.putClientProperty("row", new Integer(row));
        c.putClientProperty("column", new Integer(column));
        if (c instanceof TextArea) {
            ((TextArea)c).addActionListener((ActionListener)this.listener);
        } else if (c instanceof Button) {
            ((Button)c).addActionListener((ActionListener)this.listener);
        }
        Style s = c.getSelectedStyle();
        s.setMargin(this.verticalBorderSpacing, this.verticalBorderSpacing, this.horizontalBorderSpacing, this.horizontalBorderSpacing);
        if (this.drawBorder && this.innerBorder != 0) {
            s.setBorder(null);
            s = c.getUnselectedStyle();
            s.setBorder(null);
        } else {
            s = c.getUnselectedStyle();
        }
        s.setMargin(this.verticalBorderSpacing, this.verticalBorderSpacing, this.horizontalBorderSpacing, this.horizontalBorderSpacing);
        return c;
    }

    protected Comparator createColumnSortComparator(int column) {
        final CaseInsensitiveOrder ccmp = new CaseInsensitiveOrder();
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1 instanceof String && o2 instanceof String) {
                    return ccmp.compare((String)o1, (String)o2);
                }
                try {
                    double d = Util.toDoubleValue(o1) - Util.toDoubleValue(o2);
                    if (d > 0.0) {
                        return 1;
                    }
                    if (d < 0.0) {
                        return -1;
                    }
                }
                catch (IllegalArgumentException err) {
                    long dd = Util.toDateValue(o1).getTime() - Util.toDateValue(o2).getTime();
                    return (int)dd;
                }
                return 0;
            }
        };
    }

    public void sort(int column, boolean ascending) {
        this.sortedColumn = column;
        Comparator cmp = this.createColumnSortComparator(column);
        if (this.model instanceof SortableTableModel) {
            this.model = ((SortableTableModel)this.model).getUnderlying();
        }
        this.setModel(new SortableTableModel(this.sortedColumn, ascending, this.model, cmp));
    }

    protected Component createCell(Object value, int row, final int column, boolean editable) {
        Component cell;
        if (row == -1) {
            Button header = new Button((String)value, this.getUIID() + "Header");
            header.getAllStyles().setAlignment(this.titleAlignment);
            header.setTextPosition(1);
            if (this.isSortSupported()) {
                header.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        Comparator cmp = Table.this.createColumnSortComparator(column);
                        if (cmp == null) {
                            return;
                        }
                        if (column == Table.this.sortedColumn) {
                            Table.this.ascending = !Table.this.ascending;
                        } else {
                            Table.this.sortedColumn = column;
                            Table.this.ascending = false;
                        }
                        if (Table.this.model instanceof SortableTableModel) {
                            Table.this.model = ((SortableTableModel)Table.this.model).getUnderlying();
                        }
                        Table.this.setModel(new SortableTableModel(Table.this.sortedColumn, Table.this.ascending, Table.this.model, cmp));
                    }
                });
                if (this.sortedColumn == column) {
                    if (this.ascending) {
                        FontImage.setMaterialIcon(header, '\ue5c7');
                    } else {
                        FontImage.setMaterialIcon(header, '\ue5c5');
                    }
                }
            }
            return header;
        }
        int constraint = 0;
        Constraint validation = null;
        if (this.isAbstractTableModel()) {
            String[] multiChoice;
            Class type = ((AbstractTableModel)this.model).getCellType(row, column);
            if (type == Boolean.class) {
                CheckBox cell2 = new CheckBox();
                cell2.setSelected(Util.toBooleanValue(value));
                cell2.setUIID(this.getUIID() + "Cell");
                cell2.setEnabled(editable);
                return cell2;
            }
            if (editable && (type == null || type == String.class) && (multiChoice = ((AbstractTableModel)this.model).getMultipleChoiceOptions(row, column)) != null) {
                Picker cell3 = new Picker();
                cell3.setStrings(multiChoice);
                if (value != null) {
                    cell3.setSelectedString((String)value);
                }
                cell3.setUIID(this.getUIID() + "Cell");
                return cell3;
            }
            if (editable && type == Date.class) {
                Picker cell4 = new Picker();
                cell4.setType(1);
                if (value != null) {
                    cell4.setDate((Date)value);
                }
                cell4.setUIID(this.getUIID() + "Cell");
                return cell4;
            }
            if (type == Integer.class || type == Long.class || type == Short.class || type == Byte.class) {
                constraint = 2;
            } else if (type == Float.class || type == Double.class) {
                constraint = 5;
            }
            if (((AbstractTableModel)this.model).getValidator() != null) {
                validation = ((AbstractTableModel)this.model).getValidationConstraint(row, column);
            }
        }
        if (editable) {
            cell = new TextField(value == null ? "" : "" + value, -1);
            ((TextArea)cell).setConstraint(constraint);
            ((TextField)cell).setLeftAndRightEditingTrigger(false);
            cell.setUIID(this.getUIID() + "Cell");
            if (validation != null) {
                Validator v = ((AbstractTableModel)this.model).getValidator();
                v.addConstraint(cell, validation);
            }
            return cell;
        }
        cell = new Label(value == null ? "" : "" + value);
        ((Label)cell).setUIID(this.getUIID() + "Cell");
        cell.getUnselectedStyle().setAlignment(this.cellAlignment);
        cell.getSelectedStyle().setAlignment(this.cellAlignment);
        cell.setFocusable(true);
        return cell;
    }

    public void initComponent() {
        if (this.potentiallyDirtyModel) {
            this.updateModel();
            this.potentiallyDirtyModel = false;
        }
        this.model.addDataChangeListener(this.listener);
    }

    public void deinitialize() {
        if (!Display.getInstance().isVirtualKeyboardShowing()) {
            this.potentiallyDirtyModel = true;
            this.model.removeDataChangeListener(this.listener);
        } else {
            this.potentiallyDirtyModel = false;
        }
    }

    public void setModel(TableModel model) {
        this.model = model;
        this.updateModel();
        this.revalidate();
    }

    public TableModel getModel() {
        if (this.sortedColumn > -1) {
            return ((SortableTableModel)this.model).getUnderlying();
        }
        return this.model;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        if (this.drawBorder != drawBorder) {
            this.drawBorder = drawBorder;
            this.updateModel();
            this.revalidate();
        }
    }

    public void setInnerBorderMode(int innerBorder) {
        if (innerBorder < 0 || innerBorder > 3) {
            throw new IllegalArgumentException("Inner border mode must be one of the INNER_BORDER_* constants");
        }
        if (this.innerBorder != innerBorder) {
            this.innerBorder = innerBorder;
            this.updateModel();
            this.revalidate();
        }
    }

    public int getInnerBorderMode() {
        return this.innerBorder;
    }

    protected boolean shouldDrawInnerBorderAfterRow(int row) {
        return true;
    }

    public void setCollapseBorder(boolean collapseBorder) {
        if (this.collapseBorder != collapseBorder) {
            this.collapseBorder = collapseBorder;
            if (this.horizontalBorderSpacing != 0 || this.verticalBorderSpacing != 0) {
                this.updateMargins();
            }
            this.repaint();
        }
    }

    public void setDrawEmptyCellsBorder(boolean drawEmptyCellsBorder) {
        this.drawEmptyCellsBorder = drawEmptyCellsBorder;
        this.repaint();
    }

    public void setBorderSpacing(int horizontal, int vertical) {
        this.horizontalBorderSpacing = horizontal;
        this.verticalBorderSpacing = vertical;
        this.updateMargins();
    }

    private void updateMargins() {
        TableLayout t = (TableLayout)this.getLayout();
        int hSpace = this.horizontalBorderSpacing;
        int vSpace = this.verticalBorderSpacing;
        if (this.collapseBorder) {
            hSpace = 0;
            vSpace = 0;
        }
        if (!t.hasHorizontalSpanning() && !t.hasVerticalSpanning()) {
            for (int row = 0; row < t.getRows(); ++row) {
                for (int col = 0; col < t.getColumns(); ++col) {
                    Component cmp = null;
                    try {
                        cmp = t.getComponentAt(row, col);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (cmp == null) continue;
                    int leftMargin = col == 0 ? hSpace : 0;
                    int topMargin = row == 0 ? vSpace : 0;
                    cmp.getUnselectedStyle().setMargin(topMargin, vSpace, leftMargin, hSpace);
                    cmp.getSelectedStyle().setMargin(topMargin, vSpace, leftMargin, hSpace);
                }
            }
        }
        this.repaint();
    }

    public int getTitleAlignment() {
        return this.titleAlignment;
    }

    public void setTitleAlignment(int titleAlignment) {
        this.titleAlignment = titleAlignment;
        for (int iter = 0; iter < this.model.getColumnCount(); ++iter) {
            this.listener.dataChanged(-1, iter);
        }
    }

    public int getCellColumn(Component cell) {
        Integer i = (Integer)cell.getClientProperty("column");
        if (i != null) {
            return i;
        }
        return -1;
    }

    public int getCellRow(Component cell) {
        Integer i = (Integer)cell.getClientProperty("row");
        if (i != null) {
            return i;
        }
        return -1;
    }

    public int getCellAlignment() {
        return this.cellAlignment;
    }

    public void setCellAlignment(int cellAlignment) {
        this.cellAlignment = cellAlignment;
        this.repaint();
    }

    public boolean isIncludeHeader() {
        return this.includeHeader;
    }

    public void setIncludeHeader(boolean includeHeader) {
        this.includeHeader = includeHeader;
        this.updateModel();
    }

    protected TableLayout.Constraint createCellConstraint(Object value, int row, int column) {
        if (this.includeHeader) {
            ++row;
        }
        TableLayout t = (TableLayout)this.getLayout();
        return t.createConstraint(row, column);
    }

    public String[] getPropertyNames() {
        return new String[]{"data", "header"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{CodenameOneImplementation.getStringArray2DClass(), CodenameOneImplementation.getStringArrayClass()};
    }

    public String[] getPropertyTypeNames() {
        return new String[]{"String[][]", "String[]"};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("data")) {
            String[][] result = new String[((DefaultTableModel)this.model).data.size()][];
            for (int iter = 0; iter < result.length; ++iter) {
                Object[] o = ((DefaultTableModel)this.model).data.get(iter);
                String[] arr = new String[o.length];
                result[iter] = arr;
                for (int ai = 0; ai < arr.length; ++ai) {
                    Object current = o[ai];
                    if (current instanceof String) {
                        arr[ai] = (String)current;
                        continue;
                    }
                    if (current == null) continue;
                    arr[iter] = current.toString();
                }
            }
            return result;
        }
        if (name.equals("header")) {
            return ((DefaultTableModel)this.model).columnNames;
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("data")) {
            this.setModel(new DefaultTableModel(((DefaultTableModel)this.model).columnNames, (Object[][])value));
            return null;
        }
        if (name.equals("header")) {
            this.setModel(new DefaultTableModel((String[])value, ((DefaultTableModel)this.model).data, ((DefaultTableModel)this.model).editable));
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public int translateSortedRowToModelRow(int row) {
        if (this.model instanceof SortableTableModel) {
            return ((SortableTableModel)this.model).getSortedPosition(row);
        }
        return row;
    }

    public boolean isSortSupported() {
        return this.sortSupported;
    }

    public void setSortSupported(boolean sortSupported) {
        if (this.sortSupported != sortSupported) {
            this.sortSupported = sortSupported;
            this.setModel(this.getModel());
        }
    }

    private boolean isAbstractTableModel() {
        if (this.model instanceof SortableTableModel) {
            return ((SortableTableModel)this.model).getUnderlying() instanceof AbstractTableModel;
        }
        return this.model instanceof AbstractTableModel;
    }

    class Listener
    implements DataChangedListener,
    ActionListener {
        private int editingColumn = -1;
        private int editingRow = -1;

        Listener() {
        }

        public final void dataChanged(int row, int column) {
            Component c;
            Object value;
            boolean e;
            if (row == Integer.MIN_VALUE) {
                Table.this.updateModel();
                Table.this.revalidate();
                return;
            }
            if (this.editingColumn == column && this.editingRow == row) {
                this.editingColumn = -1;
                this.editingRow = -1;
                return;
            }
            if (row < 0) {
                e = false;
                value = Table.this.model.getColumnName(column);
            } else {
                value = Table.this.model.getValueAt(row, column);
                e = Table.this.model.isCellEditable(row, column);
            }
            Component cell = Table.this.createCellImpl(value, row, column, e);
            TableLayout t = (TableLayout)Table.this.getLayout();
            TableLayout.Constraint con = Table.this.createCellConstraint(value, row, column);
            if (Table.this.includeHeader) {
                ++row;
            }
            if ((c = t.getComponentAt(row, column)) != null) {
                Table.this.removeComponent(c);
                c.setVisible(false);
            }
            Table.this.addComponent(con, cell);
            Table.this.layoutContainer();
            cell.requestFocus();
            Table.this.revalidate();
        }

        public void actionPerformed(ActionEvent evt) {
            Component c = (Component)evt.getSource();
            int row = Table.this.getCellRow(c);
            int column = Table.this.getCellColumn(c);
            if (c instanceof TextArea) {
                TextArea t = (TextArea)c;
                this.editingColumn = column;
                this.editingRow = row;
                if (Table.this.isAbstractTableModel()) {
                    Class type = ((AbstractTableModel)Table.this.model).getCellType(row, column);
                    if (type == Integer.class) {
                        Table.this.model.setValueAt(row, column, t.getAsInt(0));
                        return;
                    }
                    if (type == Long.class) {
                        Table.this.model.setValueAt(row, column, t.getAsLong(0L));
                        return;
                    }
                    if (type == Short.class) {
                        Table.this.model.setValueAt(row, column, (short)t.getAsInt(0));
                        return;
                    }
                    if (type == Byte.class) {
                        Table.this.model.setValueAt(row, column, (byte)t.getAsInt(0));
                        return;
                    }
                    if (type == Float.class) {
                        Table.this.model.setValueAt(row, column, Float.valueOf((float)t.getAsDouble(0.0)));
                        return;
                    }
                    if (type == Double.class) {
                        Table.this.model.setValueAt(row, column, t.getAsDouble(0.0));
                        return;
                    }
                    if (type == Character.class) {
                        if (t.getText().length() > 0) {
                            Table.this.model.setValueAt(row, column, Character.valueOf(t.getText().charAt(0)));
                        }
                        return;
                    }
                }
                Table.this.model.setValueAt(row, column, t.getText());
            } else if (c instanceof Picker) {
                switch (((Picker)c).getType()) {
                    case 1: {
                        Table.this.model.setValueAt(row, column, ((Picker)c).getDate());
                        break;
                    }
                    case 4: {
                        Table.this.model.setValueAt(row, column, ((Picker)c).getSelectedString());
                    }
                }
            } else if (c instanceof CheckBox) {
                Table.this.model.setValueAt(row, column, ((CheckBox)c).isSelected());
            }
        }
    }
}

