/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.spinner;

import com.codename1.ui.spinner.DateTimeRenderer;
import com.codename1.ui.spinner.Spinner;
import com.codename1.ui.spinner.SpinnerDateModel;
import com.codename1.ui.spinner.TimeSpinner;
import java.util.Date;

public class DateTimeSpinner
extends TimeSpinner {
    private Spinner date;
    private Date today;
    private Date currentDate;
    private Date startDate;
    private Date endDate;
    private boolean markToday;
    private boolean includeYear;
    private int off;

    public DateTimeSpinner() {
        this.currentDate = this.today = new Date();
        this.startDate = new Date(0L);
        this.endDate = new Date(System.currentTimeMillis() + 864000000000L);
        this.markToday = true;
        this.off = 0;
    }

    void initSpinner() {
        if (this.date == null) {
            this.date = Spinner.createDate(this.startDate.getTime() + (long)this.off, this.endDate.getTime() + (long)this.off, this.currentDate.getTime(), ' ', 13);
            if (this.includeYear) {
                this.date.setRenderingPrototype("XXX XXX 99 9999");
                ((DateTimeRenderer)this.date.getRenderer()).setType(14);
            } else {
                this.date.setRenderingPrototype("XXX XXX 99");
                ((DateTimeRenderer)this.date.getRenderer()).setType(13);
            }
            if (this.markToday) {
                ((DateTimeRenderer)this.date.getRenderer()).setMarkToday(this.markToday, this.today.getTime());
            }
            this.setCurrentDate(this.currentDate);
            this.setStartDate(this.startDate);
            this.setEndDate(this.endDate);
        }
        super.initSpinner();
    }

    void addComponents() {
        if (this.date != null) {
            this.addComponent(this.date);
            this.addComponent(this.createSeparator());
            super.addComponents();
        }
    }

    public Date getCurrentDate() {
        if (this.date != null) {
            return (Date)this.date.getValue();
        }
        return this.currentDate;
    }

    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
        if (this.date != null) {
            this.date.setValue(currentDate);
        }
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
        if (this.date != null) {
            this.date.setModel(new SpinnerDateModel(startDate.getTime() + (long)this.off, this.endDate.getTime() + (long)this.off, this.currentDate.getTime() + (long)this.off));
        }
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
        if (this.date != null) {
            this.date.setModel(new SpinnerDateModel(this.startDate.getTime() + (long)this.off, endDate.getTime() + (long)this.off, this.currentDate.getTime() + (long)this.off));
        }
    }

    public boolean isMarkToday() {
        return this.markToday;
    }

    public void setMarkToday(boolean markToday) {
        this.markToday = markToday;
        if (this.date != null) {
            ((DateTimeRenderer)this.date.getRenderer()).setMarkToday(markToday, this.today.getTime() + (long)this.off);
        }
    }

    public boolean isIncludeYear() {
        return this.includeYear;
    }

    public void setIncludeYear(boolean includeYear) {
        this.includeYear = includeYear;
        if (this.date != null) {
            if (includeYear) {
                ((DateTimeRenderer)this.date.getRenderer()).setType(14);
                this.date.setRenderingPrototype("XXX XXX 99 9999");
            } else {
                ((DateTimeRenderer)this.date.getRenderer()).setType(13);
                this.date.setRenderingPrototype("XXX XXX 99");
            }
        }
    }

    public String[] getPropertyNames() {
        return new String[]{"currentHour", "currentMinute", "minuteStep", "currentMeridiem", "showMeridiem", "currentDate", "startDate", "endDate", "markToday", "includeYear"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{Integer.class, Integer.class, Integer.class, Boolean.class, Boolean.class, Date.class, Date.class, Date.class, Boolean.class, Boolean.class};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("currentDate")) {
            return this.currentDate;
        }
        if (name.equals("startDate")) {
            return this.startDate;
        }
        if (name.equals("endDate")) {
            return this.endDate;
        }
        if (name.equals("markToday")) {
            return new Boolean(this.markToday);
        }
        if (name.equals("includeYear")) {
            return new Boolean(this.includeYear);
        }
        return super.getPropertyValue(name);
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("currentDate")) {
            this.setCurrentDate((Date)value);
            return null;
        }
        if (name.equals("startDate")) {
            this.setStartDate((Date)value);
            return null;
        }
        if (name.equals("endDate")) {
            this.setEndDate((Date)value);
            return null;
        }
        if (name.equals("markToday")) {
            this.setMarkToday((Boolean)value);
            return null;
        }
        if (name.equals("includeYear")) {
            this.setIncludeYear((Boolean)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }
}

