/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ant;

import java.io.File;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class AntExecutor {
    public static boolean executeAntTask(String buildXmlFileFullPath) {
        return AntExecutor.executeAntTask(buildXmlFileFullPath, null, null);
    }

    public static boolean executeAntTask(String buildXmlFileFullPath, String target, Properties properties) {
        boolean success = false;
        DefaultLogger consoleLogger = AntExecutor.getConsoleLogger();
        Project project = new Project();
        File buildFile = new File(buildXmlFileFullPath);
        project.setBasedir(buildFile.getParentFile().getAbsolutePath());
        project.setBaseDir(buildFile.getParentFile());
        project.setUserProperty("ant.file", buildFile.getAbsolutePath());
        if (properties != null) {
            for (String k : properties.stringPropertyNames()) {
                project.setProperty(k, properties.getProperty(k));
            }
        }
        project.addBuildListener((BuildListener)consoleLogger);
        try {
            project.fireBuildStarted();
            project.init();
            ProjectHelper projectHelper = ProjectHelper.getProjectHelper();
            project.addReference("ant.projectHelper", (Object)projectHelper);
            projectHelper.parse(project, (Object)buildFile);
            String targetToExecute = target != null && target.trim().length() > 0 ? target.trim() : project.getDefaultTarget();
            project.executeTarget(targetToExecute);
            project.fireBuildFinished(null);
            success = true;
        }
        catch (BuildException buildException) {
            project.fireBuildFinished((Throwable)buildException);
            throw new RuntimeException("!!! Unable to restart the IEHS App !!!", buildException);
        }
        return success;
    }

    private static DefaultLogger getConsoleLogger() {
        DefaultLogger consoleLogger = new DefaultLogger();
        consoleLogger.setErrorPrintStream(System.err);
        consoleLogger.setOutputPrintStream(System.out);
        consoleLogger.setMessageOutputLevel(2);
        return consoleLogger;
    }
}

