/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.builders;

import com.codename1.builders.BuildException;
import com.codename1.builders.BuildRequest;
import com.codename1.builders.Executor;
import com.codename1.builders.util.JSONParser;
import com.codename1.maven.PathUtil;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xeustechnologies.jtar.TarEntry;
import org.xeustechnologies.jtar.TarOutputStream;

public class AndroidGradleBuilder
extends Executor {
    private float MIN_GRADLE_VERSION = 6.0f;
    private float MIN_JDK_VERSION = 8.0f;
    private String gradleDistributionUrl = "https://services.gradle.org/distributions/gradle-6.8.3-bin.zip";
    private String gradle8DistributionUrl = "https://services.gradle.org/distributions/gradle-8.1-bin.zip";
    public boolean PREFER_MANAGED_GRADLE = true;
    private boolean rootCheck = false;
    private boolean fridaDetection = false;
    private boolean useGradle8 = true;
    private boolean stripKotlinFromUserClasses = true;
    private boolean extendAppCompatActivity = false;
    private boolean useJava8SourceLevel = true;
    private File gradleProjectDirectory;
    private boolean playServicesVersionSetInBuildHint = false;
    private String facebookSdkVersion;
    private boolean decouplePlayServiceVersions = false;
    private boolean newFirebaseMessaging = false;
    private boolean useArrImplementation = false;
    private boolean disableR8FullMode = true;
    private boolean disableR8 = false;
    public static final String[] ANDROID_PERMISSIONS = new String[]{"android.permission.ACCESS_BACKGROUND_LOCATION", "android.permission.ACCESS_CHECKIN_PROPERTIES", "android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_LOCATION_EXTRA_COMMANDS", "android.permission.ACCESS_NETWORK_STATE", "android.permission.ACCESS_NOTIFICATION_POLICY", "android.permission.ACCESS_WIFI_STATE", "android.permission.ACCOUNT_MANAGER", "com.android.voicemail.permission.ADD_VOICEMAIL", "android.permission.BATTERY_STATS", "android.permission.BIND_ACCESSIBILITY_SERVICE", "android.permission.BIND_APPWIDGET", "android.permission.BIND_CARRIER_MESSAGING_SERVICE", "android.permission.BIND_CARRIER_SERVICES", "android.permission.BIND_CHOOSER_TARGET_SERVICE", "android.permission.BIND_DEVICE_ADMIN", "android.permission.BIND_DREAM_SERVICE", "android.permission.BIND_INCALL_SERVICE", "android.permission.BIND_INPUT_METHOD", "android.permission.BIND_MIDI_DEVICE_SERVICE", "android.permission.BIND_NFC_SERVICE", "android.permission.BIND_NOTIFICATION_LISTENER_SERVICE", "android.permission.BIND_PRINT_SERVICE", "android.permission.BIND_REMOTEVIEWS", "android.permission.BIND_TELECOM_CONNECTION_SERVICE", "android.permission.BIND_TEXT_SERVICE", "android.permission.BIND_TV_INPUT", "android.permission.BIND_VOICE_INTERACTION", "android.permission.BIND_VPN_SERVICE", "android.permission.BIND_WALLPAPER", "android.permission.BLUETOOTH", "android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.BODY_SENSORS", "android.permission.BROADCAST_PACKAGE_REMOVED", "android.permission.BROADCAST_SMS", "android.permission.BROADCAST_STICKY", "android.permission.BROADCAST_WAP_PUSH", "android.permission.CALL_PHONE", "android.permission.CALL_PRIVILEGED", "android.permission.CAMERA", "android.permission.CAPTURE_AUDIO_OUTPUT", "android.permission.CAPTURE_SECURE_VIDEO_OUTPUT", "android.permission.CAPTURE_VIDEO_OUTPUT", "android.permission.CHANGE_COMPONENT_ENABLED_STATE", "android.permission.CHANGE_CONFIGURATION", "android.permission.CHANGE_NETWORK_STATE", "android.permission.CHANGE_WIFI_MULTICAST_STATE", "android.permission.CHANGE_WIFI_STATE", "android.permission.CLEAR_APP_CACHE", "android.permission.CONTROL_LOCATION_UPDATES", "android.permission.DELETE_CACHE_FILES", "android.permission.DELETE_PACKAGES", "android.permission.DIAGNOSTIC", "android.permission.DISABLE_KEYGUARD", "android.permission.DUMP", "android.permission.EXPAND_STATUS_BAR", "android.permission.FACTORY_TEST", "android.permission.FLASHLIGHT", "android.permission.GET_ACCOUNTS", "android.permission.GET_ACCOUNTS_PRIVILEGED", "android.permission.GET_PACKAGE_SIZE", "android.permission.GET_TASKS", "android.permission.GLOBAL_SEARCH", "android.permission.INSTALL_LOCATION_PROVIDER", "android.permission.INSTALL_PACKAGES", "com.android.launcher.permission.INSTALL_SHORTCUT", "android.permission.INTERNET", "android.permission.KILL_BACKGROUND_PROCESSES", "android.permission.LOCATION_HARDWARE", "android.permission.MANAGE_DOCUMENTS", "android.permission.MASTER_CLEAR", "android.permission.MEDIA_CONTENT_CONTROL", "android.permission.MODIFY_AUDIO_SETTINGS", "android.permission.MODIFY_PHONE_STATE", "android.permission.MOUNT_FORMAT_FILESYSTEMS", "android.permission.MOUNT_UNMOUNT_FILESYSTEMS", "android.permission.NFC", "android.permission.PACKAGE_USAGE_STATS", "android.permission.PERSISTENT_ACTIVITY", "android.permission.PROCESS_OUTGOING_CALLS", "android.permission.QUERY_ALL_PACKAGES", "android.permission.READ_CALENDAR", "android.permission.READ_CALL_LOG", "android.permission.READ_CONTACTS", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.READ_FRAME_BUFFER", "android.permission.READ_INPUT_STATE", "android.permission.READ_LOGS", "android.permission.READ_PHONE_STATE", "android.permission.READ_SMS", "android.permission.READ_SYNC_SETTINGS", "android.permission.READ_SYNC_STATS", "com.android.voicemail.permission.READ_VOICEMAIL", "android.permission.REBOOT", "android.permission.RECEIVE_BOOT_COMPLETED", "android.permission.RECEIVE_MMS", "android.permission.RECEIVE_SMS", "android.permission.RECEIVE_WAP_PUSH", "android.permission.RECORD_AUDIO", "android.permission.REORDER_TASKS", "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS", "android.permission.REQUEST_INSTALL_PACKAGES", "android.permission.RESTART_PACKAGES", "android.permission.SEND_RESPOND_VIA_MESSAGE", "android.permission.SEND_SMS", "com.android.alarm.permission.SET_ALARM", "android.permission.SET_ALWAYS_FINISH", "android.permission.SET_ANIMATION_SCALE", "android.permission.SET_DEBUG_APP", "android.permission.SET_PREFERRED_APPLICATIONS", "android.permission.SET_PROCESS_LIMIT", "android.permission.SET_TIME", "android.permission.SET_TIME_ZONE", "android.permission.SET_WALLPAPER", "android.permission.SET_WALLPAPER_HINTS", "android.permission.SIGNAL_PERSISTENT_PROCESSES", "android.permission.STATUS_BAR", "android.permission.SYSTEM_ALERT_WINDOW", "android.permission.TRANSMIT_IR", "com.android.launcher.permission.UNINSTALL_SHORTCUT", "android.permission.UPDATE_DEVICE_STATS", "android.permission.USE_FINGERPRINT", "android.permission.USE_BIOMETRIC", "android.permission.USE_SIP", "android.permission.VIBRATE", "android.permission.WAKE_LOCK", "android.permission.WRITE_APN_SETTINGS", "android.permission.WRITE_CALENDAR", "android.permission.WRITE_CALL_LOG", "android.permission.WRITE_CONTACTS", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.WRITE_GSERVICES", "android.permission.WRITE_SECURE_SETTINGS", "android.permission.WRITE_SETTINGS", "android.permission.WRITE_SYNC_SETTINGS", "com.android.voicemail.permission.WRITE_VOICEMAIL", "android.permission.FOREGROUND_SERVICE"};
    private File androidPortSrcJar;
    private String playFlag;
    private boolean capturePermission;
    private boolean vibratePermission;
    private boolean smsPermission;
    private boolean gpsPermission;
    private boolean pushPermission;
    private boolean foregroundServicePermission;
    private boolean contactsReadPermission;
    private boolean contactsWritePermission;
    private boolean addRemoteControlService;
    private boolean contactsPermission;
    private boolean wakeLock;
    private boolean recordAudio;
    private boolean mediaPlaybackPermission;
    private boolean phonePermission;
    private boolean purchasePermissions;
    private boolean accessNetworkStatePermission;
    private boolean recieveBootCompletedPermission;
    private boolean postNotificationsPermission;
    private boolean getAccountsPermission;
    private boolean credentialsPermission;
    private boolean backgroundLocationPermission;
    private boolean accessWifiStatePermissions;
    private boolean browserBookmarksPermissions;
    private boolean launcherPermissions;
    private boolean integrateMoPub = false;
    private static final boolean isMac;
    private String playServicesVersion = "12.0.1";
    private static final Map<String, String> defaultPlayServiceVersions;
    private Map<String, String> playServiceVersions = new HashMap<String, String>();
    private boolean playServicesPlus;
    private boolean playServicesAuth;
    private boolean playServicesBase;
    private boolean playServicesIdentity;
    private boolean playServicesIndexing;
    private boolean playServicesInvite;
    private boolean playServicesAnalytics;
    private boolean playServicesCast;
    private boolean playServicesGcm;
    private boolean playServicesDrive;
    private boolean playServicesFit;
    private boolean playServicesLocation;
    private boolean playServicesMaps;
    private boolean playServicesAds;
    private boolean playServicesVision;
    private boolean playServicesNearBy;
    private boolean playServicesSafetyPanorama;
    private boolean playServicesGames;
    private boolean playServicesSafetyNet;
    private boolean playServicesWallet;
    private boolean playServicesWear;
    private String xPermissions;
    private String xQueries;
    private int buildToolsVersionInt;
    private String buildToolsVersion;
    private boolean useAndroidX;
    private boolean migrateToAndroidX;
    private boolean shouldIncludeGoogleImpl;
    private Map<String, String> androidXArtifactMapping;
    private Map<String, String> androidXClassMapping;

    public File getGradleProjectDirectory() {
        return this.gradleProjectDirectory;
    }

    public void setAndroidPortSrcJar(File androidPortSrcJar) {
        this.androidPortSrcJar = androidPortSrcJar;
    }

    public File getAndroidPortSrcJar() {
        return this.androidPortSrcJar;
    }

    @Override
    protected String getDeviceIdCode() {
        return "\"\"";
    }

    @Override
    protected boolean deriveGlobalInstrumentClasspath() {
        return true;
    }

    @Override
    protected long getTimeoutValue() {
        return 28800000L;
    }

    private String getGradleVersion(String gradleExe) throws Exception {
        Map env = this.defaultEnvironment;
        env.put("JAVA_HOME", this.getGradleJavaHome());
        String result = this.execString(new File(System.getProperty("user.dir")), gradleExe, "--version");
        Scanner scanner = new Scanner(result);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            this.log("Gradle version line: " + line);
            if (!line.startsWith("Gradle ")) continue;
            return line.substring(line.indexOf(" ") + 1).trim();
        }
        throw new RuntimeException("Failed to get gradle version for " + gradleExe);
    }

    private String getGradleJavaHome() throws BuildException {
        if (this.useGradle8) {
            String home = System.getenv("JAVA17_HOME");
            if (home == null && (home = this.getLocalBuilderProperties().getProperty("java17.home", null)) != null && !new File(home).isDirectory()) {
                throw new BuildException("The java17.home property is not set to a valid directory.  You have defined it in your ~/.codenameone/local.properties file, but it is not a valid directory.");
            }
            if (home == null) {
                throw new BuildException("When using gradle 8, you must set the JAVA17_HOME environment variable to the location of a Java 17 JDK");
            }
            if (!new File(home).isDirectory()) {
                throw new BuildException("The JAVA17_HOME environment variable is not set to a valid directory");
            }
            return home;
        }
        return System.getProperty("java.home");
    }

    private int parseVersionStringAsInt(String versionString) {
        if (versionString.indexOf(".") > 0) {
            try {
                return Integer.parseInt(versionString.substring(0, versionString.indexOf(".")).trim());
            }
            catch (Exception ex) {
                return 0;
            }
        }
        try {
            return Integer.parseInt(versionString);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private static String escape(String str, String chars) {
        char[] charArray;
        if (str == null) {
            return null;
        }
        for (char c : charArray = chars.toCharArray()) {
            str = str.replace(String.valueOf(c), "\\" + c);
        }
        return str;
    }

    @Override
    public boolean build(File sourceZip, final BuildRequest request) throws BuildException {
        String supportV4Default;
        String stubSourceCode;
        String streamMode;
        String licenseKey;
        String androidLicenseKey;
        String sharedUserLabel;
        String sharedUserId;
        String gcmSenderId;
        File billingSupport;
        String moPubAdUnitId;
        File fb;
        File androidLocationPlayServicesManager;
        boolean useFCM;
        String targetSDKVersion;
        int targetSDKVersionInt;
        File projectDir;
        String gradleVersion;
        String gradleExe;
        String addString;
        String sdkListStr;
        File sdkmanager;
        File androidSDKDir;
        boolean facebookSupported = request.getArg("facebook.appId", null) != null;
        this.newFirebaseMessaging = request.getArg("android.newFirebaseMessaging", "true").equals("true");
        this.useGradle8 = request.getArg("android.useGradle8", "" + (this.useGradle8 || this.newFirebaseMessaging || facebookSupported)).equals("true");
        this.rootCheck = request.getArg("android.rootCheck", "false").equals("true");
        this.fridaDetection = request.getArg("android.fridaDetection", "false").equals("true");
        this.extendAppCompatActivity = request.getArg("android.extendAppCompatActivity", "false").equals("true");
        this.stripKotlinFromUserClasses = this.useGradle8;
        this.useJava8SourceLevel = request.getArg("android.java8", "" + this.useJava8SourceLevel).equals("true");
        this.disableR8 = request.getArg("android.disableR8", "false").equals("true");
        this.disableR8FullMode = request.getArg("android.disableR8FullMode", "true").equals("true");
        if (this.useGradle8) {
            this.getGradleJavaHome();
            this.MIN_GRADLE_VERSION = 8.0f;
            this.gradleDistributionUrl = this.gradle8DistributionUrl;
            if (!this.useJava8SourceLevel) {
                this.log("NOTICE: Enabling Java 8 source level for Gradle 8 build because RetroLambda is not supported on Java 17, which is required for gradle 8.");
                this.useJava8SourceLevel = true;
            }
        }
        if (this.newFirebaseMessaging && !this.useGradle8) {
            throw new BuildException("android.newFirebaseMessaging requires gradle version 8.1 or higher.  Please remove the android.gradleVersion build hint");
        }
        this.debug("Request Args: ");
        this.debug("-----------------");
        for (String arg : request.getArgs()) {
            this.debug(arg + "=" + request.getArg(arg, null));
        }
        this.debug("-------------------");
        this.facebookSdkVersion = request.getArg("android.facebookSdkVersion", "16.2.0");
        String facebookSupport = "";
        String facebookProguard = "";
        String facebookActivityMetaData = "";
        String facebookActivity = "";
        String facebookHashCode = "";
        String facebookClientToken = null;
        if (facebookSupported && AndroidGradleBuilder.compareVersions(this.facebookSdkVersion, "16.0.0") >= 0 && (facebookClientToken = request.getArg("facebook.clientToken", null)) == null) {
            throw new BuildException("You must specify a facebook.clientToken when using facebookSdkVersion " + this.facebookSdkVersion);
        }
        this.decouplePlayServiceVersions = request.getArg("android.decouplePlayServiceVersions", this.newFirebaseMessaging ? "true" : "false").equals("true");
        if (!this.decouplePlayServiceVersions && this.newFirebaseMessaging) {
            throw new BuildException("android.newFirebaseMessaging=true is not compatible with android.decouplePlayServiceVersions=false.  Please remove one of these build hints.");
        }
        String defaultAndroidHome = isMac ? PathUtil.path(System.getProperty("user.home"), "Library", "Android", "sdk") : (is_windows ? PathUtil.path(System.getProperty("user.home"), "AppData", "Local", "Android", "Sdk") : PathUtil.path(System.getProperty("user.home"), "Android", "Sdk"));
        String androidHome = System.getenv("ANDROID_HOME");
        if (androidHome == null) {
            this.log("Using default ANDROID_HOME of " + defaultAndroidHome);
            androidHome = defaultAndroidHome;
        } else {
            this.log("Using ANDROID_HOME of " + androidHome);
        }
        String bat = "";
        if (is_windows) {
            bat = ".bat";
        }
        if (!(androidSDKDir = new File(androidHome)).exists()) {
            throw new BuildException("Cannot find Android SDK at " + androidHome + ".  Please install Android studio, or set the ANDROID_HOME environment variable to point to your android sdk directory.");
        }
        if (!androidSDKDir.getName().equalsIgnoreCase("sdk") && !(androidSDKDir = new File(androidSDKDir, "Sdk")).isDirectory()) {
            androidSDKDir = new File(androidSDKDir.getParentFile(), "sdk");
        }
        if (!(sdkmanager = new File(androidSDKDir, PathUtil.path("tools", "bin", "sdkmanager" + bat))).canExecute()) {
            sdkmanager = new File(androidSDKDir, PathUtil.path("cmdline-tools", "latest", "bin", "sdkmanager" + bat));
        }
        if (!sdkmanager.canExecute()) {
            RuntimeException ex = new RuntimeException("Android SDK Command-Line Tools not found at " + sdkmanager.getAbsolutePath() + ".  Please install the Android SDK Command-Line Tools from the Android Studio SDK Manager.Note: Set the ANDROID_HOME environment variable to the location of your Android SDK, or set the android.sdk.path build hint to the location of your Android SDK.");
            this.error("Cannot find executable sdkmanager" + bat + " in " + androidSDKDir + "; tried tools and cmdline-tools/latest", ex);
            throw new BuildException("Cannot find executable sdkmanager" + bat + " in " + androidSDKDir + "; tried tools and cmdline-tools/latest", ex);
        }
        try {
            sdkListStr = this.execString(this.tmpDir, sdkmanager.getAbsolutePath(), "--list");
        }
        catch (Exception ex) {
            this.error("Failed to get SDK list using " + sdkmanager + ".  " + ex.getMessage(), ex);
            throw new BuildException("Failed to get SDK list using " + sdkmanager, ex);
        }
        Scanner sdkScanner = new Scanner(sdkListStr);
        ArrayList<String> installedPlatforms = new ArrayList<String>();
        ArrayList<String> installedBuildToolsVersions = new ArrayList<String>();
        while (sdkScanner.hasNextLine()) {
            String[] col1Parts;
            String[] columns;
            String line = sdkScanner.nextLine().trim();
            if (line.startsWith("build-tools;")) {
                columns = line.split("\\|");
                if (columns.length < 4 || (col1Parts = columns[0].split(";")).length <= 1) continue;
                installedBuildToolsVersions.add(col1Parts[1].trim());
                continue;
            }
            if (!line.startsWith("platforms;") || (columns = line.split("\\|")).length <= 1) continue;
            col1Parts = columns[0].split(";");
            String platform = col1Parts[1].trim();
            if (platform.contains("-")) {
                platform = platform.substring(platform.indexOf("-") + 1);
            }
            installedPlatforms.add(platform);
        }
        this.debug("Installed platforms: " + installedPlatforms);
        int maxBuildToolsVersionInt = 0;
        String maxBuildToolsVersion = "0";
        for (String ver : installedBuildToolsVersions) {
            int verInt = this.parseVersionStringAsInt(ver);
            if (verInt <= maxBuildToolsVersionInt) continue;
            maxBuildToolsVersion = ver;
            maxBuildToolsVersionInt = verInt;
        }
        int maxPlatformVersionInt = 0;
        String maxPlatformVersion = "0";
        for (String string : installedPlatforms) {
            int verInt = this.parseVersionStringAsInt(string);
            if (verInt <= maxPlatformVersionInt) continue;
            maxPlatformVersionInt = verInt;
            maxPlatformVersion = string;
        }
        if (maxPlatformVersionInt == 0) {
            maxPlatformVersionInt = 31;
            maxPlatformVersion = "31";
        }
        if (maxBuildToolsVersionInt == 0) {
            maxBuildToolsVersionInt = 31;
            maxBuildToolsVersion = "31";
        }
        if (this.useGradle8) {
            maxBuildToolsVersionInt = Math.max(33, maxBuildToolsVersionInt);
            maxBuildToolsVersion = "" + maxBuildToolsVersionInt;
            maxPlatformVersionInt = Math.max(33, maxPlatformVersionInt);
            maxPlatformVersion = "" + maxPlatformVersionInt;
        }
        this.useAndroidX = request.getArg("android.useAndroidX", this.newFirebaseMessaging || this.decouplePlayServiceVersions || this.useGradle8 || facebookSupported && AndroidGradleBuilder.compareVersions(this.facebookSdkVersion, "16.0.0") >= 0 ? "true" : "false").equals("true");
        if (!this.useAndroidX && this.newFirebaseMessaging) {
            throw new BuildException("android.newFirebaseMessaging requires useAndroidX to be true.  Please remove the android.useAndroidX build hint");
        }
        this.log("useAndroidX: " + this.useAndroidX);
        this.log("Compare facebookSdkVersion to 16.0.0: " + (AndroidGradleBuilder.compareVersions(this.facebookSdkVersion, "16.0.0") >= 0));
        this.log("Facebook supported: " + facebookSupported);
        this.migrateToAndroidX = this.useAndroidX && request.getArg("android.migrateToAndroidX", "true").equals("true");
        this.buildToolsVersionInt = maxBuildToolsVersionInt;
        String buildToolsVersionIntStr = this.buildToolsVersion = request.getArg("android.buildToolsVersion", "" + maxBuildToolsVersion);
        if (buildToolsVersionIntStr.indexOf(".") > 1) {
            buildToolsVersionIntStr = buildToolsVersionIntStr.substring(0, buildToolsVersionIntStr.indexOf("."));
        }
        this.buildToolsVersionInt = Integer.parseInt(buildToolsVersionIntStr.replaceAll("[^0-9]", ""));
        if (this.newFirebaseMessaging) {
            this.buildToolsVersionInt = 33;
        }
        if (this.useAndroidX && this.buildToolsVersionInt < 29) {
            this.buildToolsVersionInt = 29;
            this.buildToolsVersion = "29";
        } else if (this.buildToolsVersionInt > 28 && !this.useAndroidX) {
            this.useAndroidX = true;
            this.migrateToAndroidX = this.useAndroidX && request.getArg("android.migrateToAndroidX", "true").equals("true");
        }
        this.debug("Effective build tools version = " + this.buildToolsVersion);
        this.xPermissions = request.getArg("android.xpermissions", "");
        this.debug("Adding android permissions...");
        for (String xPerm : ANDROID_PERMISSIONS) {
            String permName = xPerm.substring(xPerm.lastIndexOf(".") + 1);
            if (!request.getArg("android.permission." + permName, "false").equals("true")) continue;
            this.debug("Found permission " + permName);
            String maxSdk = request.getArg("android.permission." + permName + ".maxSdkVersion", "");
            String required = request.getArg("android.permission." + permName + ".required", "");
            addString = "    <uses-permission android:name=\"" + xPerm + "\" ";
            if (!"".equals(required)) {
                addString = addString + "android:required=\"" + required + "\" ";
            }
            if (!"".equals(maxSdk)) {
                addString = addString + "android:maxSdkVersion=\"" + maxSdk + "\" ";
            }
            addString = addString + "/>\n";
            this.xPermissions = this.xPermissions + this.permissionAdd(request, xPerm, addString);
        }
        String string = "android.uses_feature.";
        int usesFeaturePrefixLen = "android.uses_feature.".length();
        for (String arg : request.getArgs()) {
            if (!arg.startsWith("android.uses_feature.")) continue;
            String featureName = arg.substring(usesFeaturePrefixLen);
            String rawArgValue = request.getArg(arg, "false");
            if (rawArgValue.equals("false")) continue;
            boolean requiredFlag = rawArgValue.equals("required");
            addString = "    <uses-feature android:name=\"" + featureName + "\" ";
            if (requiredFlag) {
                addString = addString + "android:required=\"true\" ";
            }
            addString = addString + "/>\n";
            this.xPermissions = this.xPermissions + this.permissionAdd(request, featureName, addString);
        }
        String usesPermissionPrefix = "android.uses_permission.";
        int usesPermissionPrefixLen = "android.uses_permission.".length();
        String maxSdkVersionPrefix = "maxSdkVersion:";
        int maxSdkVersionPrefixLen = "maxSdkVersion:".length();
        for (String arg : request.getArgs()) {
            String maxSdkVersion;
            if (!arg.startsWith("android.uses_permission.")) continue;
            String permissionName = arg.substring(usesPermissionPrefixLen);
            String rawArgValue = request.getArg(arg, "false");
            if (rawArgValue.equals("false")) continue;
            boolean requiredFlag = rawArgValue.contains("required");
            int maxSdkVersionPos = rawArgValue.indexOf("maxSdkVersion:");
            String string2 = maxSdkVersion = maxSdkVersionPos >= 0 ? rawArgValue.substring(maxSdkVersionPos + maxSdkVersionPrefixLen) : "";
            if (!maxSdkVersion.isEmpty() && maxSdkVersion.contains(" ")) {
                maxSdkVersion = maxSdkVersion.substring(0, maxSdkVersion.indexOf(" "));
            }
            String addString2 = "    <uses-permission android:name=\"" + permissionName + "\" ";
            if (requiredFlag) {
                addString2 = addString2 + "android:required=\"true\" ";
            }
            if (!"".equals(maxSdkVersion)) {
                addString2 = addString2 + "android:maxSdkVersion=\"" + maxSdkVersion + "\" ";
            }
            addString2 = addString2 + "/>\n";
            this.xPermissions = this.xPermissions + this.permissionAdd(request, permissionName, addString2);
        }
        File tmpFile = this.getBuildDirectory();
        if (tmpFile == null) {
            throw new IllegalStateException("Build directory must be set before running build.");
        }
        if (tmpFile.exists()) {
            AndroidGradleBuilder.delTree(tmpFile);
        }
        tmpFile.mkdirs();
        String gradleHomeVersion = this.useGradle8 ? "8" : "6_5";
        File managedGradleHome = new File(PathUtil.path(System.getProperty("user.home"), ".codenameone", "gradle" + gradleHomeVersion));
        String gradleHome = System.getenv("GRADLE_HOME");
        if (gradleHome == null && managedGradleHome.exists()) {
            gradleHome = managedGradleHome.getAbsolutePath();
        }
        if ((gradleExe = System.getenv("GRADLE_PATH")) == null) {
            gradleExe = gradleHome != null ? new File(gradleHome + File.separator + "bin" + File.separator + "gradle" + bat).getAbsolutePath() : "gradle";
        }
        if (this.PREFER_MANAGED_GRADLE) {
            this.debug("PREFER_MANAGED_GRADLE flag is set.  Ignoring GRADLE_HOME and GRADLE_PATH environment variables.  Using managed gradle at " + managedGradleHome + " instead");
            gradleHome = managedGradleHome.getAbsolutePath();
            gradleExe = new File(managedGradleHome, PathUtil.path("bin", "gradle" + bat)).getAbsolutePath();
        }
        try {
            gradleVersion = this.getGradleVersion(gradleExe);
        }
        catch (Exception ex) {
            gradleVersion = "0";
        }
        this.debug("FOUND gradleVersion " + gradleVersion);
        int gradleVersionInt = this.parseVersionStringAsInt(gradleVersion);
        this.debug("Found gradleVersionInt=" + gradleVersionInt);
        if ((float)gradleVersionInt < this.MIN_GRADLE_VERSION) {
            if (managedGradleHome.exists()) {
                gradleExe = new File(managedGradleHome, PathUtil.path("bin", "gradle" + bat)).getAbsolutePath();
                try {
                    gradleVersion = this.getGradleVersion(gradleExe);
                }
                catch (Exception ex) {
                    gradleVersion = "0";
                }
                gradleVersionInt = this.parseVersionStringAsInt(gradleVersion);
            }
            if ((float)gradleVersionInt < this.MIN_GRADLE_VERSION) {
                File gradleZip;
                if (managedGradleHome.exists()) {
                    AndroidGradleBuilder.delTree(managedGradleHome);
                }
                if ((gradleZip = new File(managedGradleHome + ".zip")).exists()) {
                    gradleZip.delete();
                }
                try {
                    this.log("Downloading gradle distribution from " + this.gradleDistributionUrl);
                    FileUtils.copyURLToFile((URL)new URL(this.gradleDistributionUrl), (File)gradleZip);
                }
                catch (Exception ex) {
                    throw new BuildException("Failed to download gradle distribution from URL " + this.gradleDistributionUrl, ex);
                }
                try {
                    ZipFile gradleZipFile = new ZipFile(gradleZip);
                    File extracted = new File(PathUtil.path(gradleZip.getAbsolutePath() + "-extracted"));
                    extracted.mkdir();
                    gradleZipFile.extractAll(extracted.getAbsolutePath());
                    gradleZip.delete();
                    for (File extractedChild : extracted.listFiles()) {
                        if (!extractedChild.getName().startsWith("gradle") || !extractedChild.isDirectory()) continue;
                        try {
                            if (managedGradleHome.exists()) {
                                if (managedGradleHome.isDirectory()) {
                                    FileUtils.deleteDirectory((File)managedGradleHome);
                                } else {
                                    managedGradleHome.delete();
                                }
                            }
                            FileUtils.moveDirectory((File)extractedChild, (File)managedGradleHome);
                            break;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                catch (ZipException zex) {
                    throw new BuildException("Failed to unzip gradle distribution after downloading it", zex);
                }
                if (!managedGradleHome.exists()) {
                    throw new BuildException("There was a problem extracting the gradle distribution. Expected it to be extracted at " + managedGradleHome + ", but was not found");
                }
                File managedGradleExe = new File(managedGradleHome, PathUtil.path("bin", "gradle" + bat));
                if (!managedGradleExe.exists()) {
                    throw new BuildException("Expected to find gradle executable at " + managedGradleExe + " after download and extraction, but it wasn't there.  Something about the gradle install must have failed.  Try again.");
                }
                gradleExe = managedGradleExe.getAbsolutePath();
                try {
                    gradleVersion = this.getGradleVersion(gradleExe);
                }
                catch (Exception ex) {
                    throw new BuildException("Failed to get gradle version even after downloading it from " + this.gradleDistributionUrl + ".  Something must have gone wrong with the gradle installation.");
                }
                gradleVersionInt = this.parseVersionStringAsInt(gradleVersion);
                if ((float)gradleVersionInt < this.MIN_GRADLE_VERSION) {
                    throw new BuildException("Required gradle version is " + this.MIN_GRADLE_VERSION + " but found version " + gradleVersion);
                }
            }
        }
        File androidToolsDir = new File(androidSDKDir, "tools");
        File androidCommand = new File(androidToolsDir, "android" + bat);
        this.gradleProjectDirectory = projectDir = new File(tmpFile, request.getMainClass());
        String androidVersion = "android-14";
        String defaultVersion = maxPlatformVersion;
        String usesLibrary = "        <uses-library android:name=\"org.apache.http.legacy\" android:required=\"false\" />\n";
        String targetNumber = request.getArg("android.targetSDKVersion", defaultVersion);
        if (!targetNumber.equals(defaultVersion)) {
            try {
                if (Integer.parseInt(targetNumber) < 28) {
                    usesLibrary = "";
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((targetSDKVersionInt = Integer.parseInt(targetSDKVersion = targetNumber)) > 14) {
            androidVersion = "android-" + targetSDKVersion;
        }
        targetSDKVersion = " android:targetSdkVersion=\"" + targetSDKVersion + "\" ";
        this.log("TargetSDKVersion=" + targetSDKVersion);
        String gradlePluginVersion = "1.3.1";
        if (gradleVersionInt < 3) {
            gradlePluginVersion = "2.0.0";
        } else if (gradleVersionInt < 6) {
            gradlePluginVersion = this.useAndroidX ? "3.2.0" : "3.0.1";
        } else {
            this.useArrImplementation = true;
            gradlePluginVersion = "4.1.1";
        }
        boolean androidAppBundle = request.getArg("android.appBundle", gradleVersionInt >= 5 ? "true" : "false").equals("true");
        this.debug("gradlePluginVersion=" + gradlePluginVersion);
        projectDir = new File(projectDir, "app");
        File studioProjectDir = projectDir.getParentFile();
        if (this.isUnitTestMode()) {
            throw new BuildException("Unit Test mode not currently supported for local android builds.");
        }
        try {
            this.log("Creating AndroidStudioProject from template");
            if (studioProjectDir.exists()) {
                AndroidGradleBuilder.delTree(studioProjectDir);
            }
            this.createAndroidStudioProject(studioProjectDir);
        }
        catch (Exception ex) {
            this.error("Failed to create AndroidStudioProject: " + ex.getMessage(), ex);
            throw new BuildException("Failed to create android project", ex);
        }
        File assetsDir = new File(projectDir + "/src/main", "assets");
        assetsDir.mkdirs();
        File resDir = new File(projectDir + "/src/main", "res");
        resDir.mkdirs();
        File valsDir = new File(resDir, "values");
        valsDir.mkdirs();
        File vals11Dir = null;
        vals11Dir = new File(resDir, "values-v11");
        vals11Dir.mkdirs();
        File vals21Dir = null;
        vals21Dir = new File(resDir, "values-v21");
        vals21Dir.mkdirs();
        File layoutDir = new File(resDir, "layout");
        layoutDir.mkdirs();
        File xmlDir = new File(resDir, "xml");
        xmlDir.mkdirs();
        File srcDir = new File(projectDir, "src/main/java");
        srcDir.mkdirs();
        File dummyClassesDir = new File(tmpFile, "Classes");
        dummyClassesDir.mkdirs();
        File libsDir = new File(projectDir, "libs");
        libsDir.mkdirs();
        try {
            this.debug("Extracting " + sourceZip);
            this.unzip(sourceZip, dummyClassesDir, assetsDir, srcDir, libsDir, xmlDir);
        }
        catch (Exception ex) {
            throw new BuildException("Failed to extract source zip " + sourceZip, ex);
        }
        if (this.stripKotlinFromUserClasses) {
            this.stripKotlin(dummyClassesDir);
        }
        File appDir = this.buildToolsVersionInt >= 27 ? new File(srcDir.getParentFile(), "app") : new File(libsDir.getParentFile(), "app");
        File googleServicesJson = new File(appDir, "google-services.json");
        googleServicesJson = new File(libsDir.getParentFile(), "google-services.json");
        if (!this.useJava8SourceLevel) {
            this.log("Running retrolambda on classes to support Java 6 source level.  Use the android.java8=true build hint to use Java 8 source level directly on Android, and avoid this step.");
            try {
                if (!this.retrolambda(new File(System.getProperty("user.dir")), request, dummyClassesDir)) {
                    return false;
                }
            }
            catch (Exception ex) {
                throw new BuildException("Failed to run retrolambda on classes", ex);
            }
        }
        String additionalImports = request.getArg("android.activityClassImports", "");
        String additionalMembers = request.getArg("android.activityClassBody", "");
        String additionalKeyVals = "";
        String mopubActivities = "";
        String mopubBannerXML = "";
        String permissions = "";
        String telephonyRequired = "false";
        String aarDependencies = "";
        File[] childs = libsDir.listFiles();
        for (int i = 0; i < childs.length; ++i) {
            File file = childs[i];
            if (file.getName().endsWith(".andlib")) {
                throw new BuildException("andlib format is not supported anymore, use aar instead");
            }
            if (!file.getName().endsWith(".aar")) continue;
            String name = file.getName().substring(0, file.getName().lastIndexOf("."));
            boolean arrCompileLib = request.getArg("android.arrcompile", "").contains(name);
            boolean arrImplementationLib = request.getArg("android.arrimplementation", "").contains(name);
            aarDependencies = !arrCompileLib && (this.useArrImplementation || arrImplementationLib) ? aarDependencies + "    implementation(name:'" + name + "', ext:'aar')\n" : aarDependencies + "    compile(name:'" + name + "', ext:'aar')\n";
        }
        String minSDK = request.getArg("android.min_sdk_version", "19");
        if (facebookSupported) {
            facebookHashCode = "        try {\n            android.content.pm.PackageInfo info = getPackageManager().getPackageInfo(\n                  \"" + request.getPackageName() + "\", android.content.pm.PackageManager.GET_SIGNATURES);\n            for (android.content.pm.Signature signature : info.signatures){\n                   java.security.MessageDigest md = java.security.MessageDigest.getInstance(\"SHA\");\n                   md.update(signature.toByteArray());\n                   android.util.Log.d(\"KeyHash:\", android.util.Base64.encodeToString(md.digest(), android.util.Base64.DEFAULT));\n                   Display.getInstance().setProperty(\"facebook_hash\", android.util.Base64.encodeToString(md.digest(), android.util.Base64.DEFAULT));\n            }\n        } catch (android.content.pm.PackageManager.NameNotFoundException e) {\n            e.printStackTrace();\n        } catch (java.security.NoSuchAlgorithmException e) {\n            e.printStackTrace();\n        }\n\n";
            String permissionsStr = request.getArg("android.facebook_permissions", "\"public_profile\",\"email\",\"user_friends\"");
            permissionsStr = request.getArg("and.facebook_permissions", permissionsStr);
            permissionsStr = permissionsStr.replace('\"', ' ');
            facebookSupport = "Display.getInstance().setProperty(\"facebook_app_id\", \"" + request.getArg("facebook.appId", "706695982682332") + "\");\n        Display.getInstance().setProperty(\"facebook_permissions\", \"" + permissionsStr + "\");\n com.codename1.social.FacebookImpl.init();\n";
            facebookProguard = "-keep class com.facebook.** { *; }\n-keepattributes Signature\n-dontwarn bolts.**\n-dontnote android.support.**\n-dontnote androidx.**\n";
            facebookActivityMetaData = " <meta-data android:name=\"com.facebook.sdk.ApplicationId\" android:value=\"@string/facebook_app_id\"/>\n";
            if (facebookClientToken != null) {
                facebookActivityMetaData = facebookActivityMetaData + " <meta-data android:name=\"com.facebook.sdk.ClientToken\" android:value=\"" + facebookClientToken + "\"/>\n";
            }
            facebookActivity = " <activity android:name=\"com.facebook.FacebookActivity\" android:exported=\"true\"/>\n";
            additionalKeyVals = additionalKeyVals + "<string name=\"facebook_app_id\">" + request.getArg("facebook.appId", "706695982682332") + "</string>";
        }
        String googlePlayAdsMetaData = "";
        String googlePlayAdsActivity = "";
        String googlePlayObfuscation = "";
        String googleAdUnitId = request.getArg("android.googleAdUnitId", request.getArg("google.adUnitId", null));
        String googlePlayAdViewCode = "";
        String userXapplication = request.getArg("android.xapplication", "");
        if (this.playServicesAds) {
            minSDK = AndroidGradleBuilder.maxInt("21", minSDK);
        }
        if (googleAdUnitId != null && googleAdUnitId.length() > 0) {
            minSDK = AndroidGradleBuilder.maxInt("9", minSDK);
            if (!userXapplication.contains("com.google.android.gms.version")) {
                googlePlayAdsMetaData = "<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\"/>";
            }
            if (!userXapplication.contains("com.google.android.gms.ads.AdActivity")) {
                googlePlayAdsActivity = "<activity android:name=\"com.google.android.gms.ads.AdActivity\" android:configChanges=\"keyboard|keyboardHidden|orientation|screenLayout|uiMode|screenSize|smallestScreenSize\"/>";
            }
            this.accessNetworkStatePermission = true;
            String testDevice = request.getArg("android.googleAdUnitTestDevice", "C6783E2486F0931D9D09FABC65094FDF");
            googlePlayAdViewCode = "            com.google.android.gms.ads.AdView adView = new com.google.android.gms.ads.AdView(this);\n            adView.setAdUnitId(\"" + googleAdUnitId + "\");\n            adView.setId(2002);\n            adView.setAdSize(com.google.android.gms.ads.AdSize.SMART_BANNER);\n            AndroidImplementation.setViewAboveBelow(null, adView, 0, com.google.android.gms.ads.AdSize.SMART_BANNER.getHeightInPixels(this));\n            com.google.android.gms.ads.AdRequest adRequest = new com.google.android.gms.ads.AdRequest.Builder().addTestDevice(\"" + testDevice + "\").build();\n            adView.loadAd(adRequest);\n";
            googlePlayObfuscation = "-keep class * extends java.util.ListResourceBundle {\n    protected Object[][] getContents();\n}\n\n-keep public class com.google.android.gms.common.internal.safeparcel.SafeParcelable {\n    public static final *** NULL;\n}\n\n-keepnames @com.google.android.gms.common.annotation.KeepName class *\n-keepclassmembernames class * {\n    @com.google.android.gms.common.annotation.KeepName *;\n}\n\n-keepnames class * implements android.os.Parcelable {\n    public static final ** CREATOR;\n}\n";
        }
        this.playServicesVersion = request.getArg("android.playServicesVersion", this.playServicesVersion);
        this.playServicesVersionSetInBuildHint = request.getArg("android.playServicesVersion", null) != null;
        final String playServicesValue = request.getArg("android.includeGPlayServices", null);
        this.playFlag = "true";
        this.gpsPermission = request.getArg("android.gpsPermission", "false").equals("true");
        this.mediaPlaybackPermission = false;
        try {
            this.scanClassesForPermissions(dummyClassesDir, new Executor.ClassScanner(){

                @Override
                public void usesClass(String cls) {
                    if (cls.indexOf("com/codename1/notifications") == 0) {
                        AndroidGradleBuilder.this.recieveBootCompletedPermission = true;
                        if (targetSDKVersionInt >= 33) {
                            AndroidGradleBuilder.this.postNotificationsPermission = true;
                        }
                    }
                    if (cls.indexOf("com/codename1/capture") == 0) {
                        AndroidGradleBuilder.this.capturePermission = true;
                    }
                    if (cls.indexOf("com/codename1/ads") == 0) {
                        AndroidGradleBuilder.this.debug("Adding phone permission because of class " + cls);
                        AndroidGradleBuilder.this.phonePermission = true;
                    }
                    if (cls.indexOf("com/codename1/components/Ads") == 0) {
                        AndroidGradleBuilder.this.debug("Adding phone permission because of class " + cls);
                        AndroidGradleBuilder.this.phonePermission = true;
                    }
                    if (cls.indexOf("com/codename1/maps") == 0 || cls.indexOf("com/codename1/location") == 0) {
                        AndroidGradleBuilder.this.gpsPermission = true;
                    }
                    if (cls.indexOf("com/codename1/push") > -1) {
                        AndroidGradleBuilder.this.pushPermission = true;
                        if (targetSDKVersionInt >= 28) {
                            AndroidGradleBuilder.this.foregroundServicePermission = true;
                        }
                    }
                    if (cls.indexOf("com/codename1/contacts") > -1) {
                        AndroidGradleBuilder.this.contactsReadPermission = true;
                    }
                    if (cls.indexOf("com/codename1/payment") > -1) {
                        AndroidGradleBuilder.this.purchasePermissions = true;
                    }
                    if (cls.indexOf("com/codename1/location/Geofence") > -1 && !"true".equals(playServicesValue)) {
                        AndroidGradleBuilder.this.debug("Adding location playservice");
                        request.putArgument("android.location.minPlayServicesVersion", "12.0.1");
                        AndroidGradleBuilder.this.playServicesLocation = true;
                        AndroidGradleBuilder.this.playFlag = "false";
                        if (targetSDKVersionInt >= 29) {
                            AndroidGradleBuilder.this.backgroundLocationPermission = true;
                        }
                    }
                    if (cls.indexOf("com/codename1/social") > -1) {
                        AndroidGradleBuilder.this.credentialsPermission = true;
                        AndroidGradleBuilder.this.getAccountsPermission = true;
                    }
                }

                @Override
                public void usesClassMethod(String cls, String method) {
                    if (cls.indexOf("com/codename1/ui/Display") == 0 && (method.indexOf("vibrate") > -1 || method.indexOf("notifyStatusBar") > -1)) {
                        AndroidGradleBuilder.this.vibratePermission = true;
                    }
                    if (cls.indexOf("com/codename1/media/MediaManager") == 0 && method.indexOf("createBackgroundMedia") > -1 && targetSDKVersionInt >= 28) {
                        AndroidGradleBuilder.this.foregroundServicePermission = true;
                    }
                    if (cls.indexOf("com/codename1/ui/Display") == 0 && method.indexOf("createBackgroundMedia") > -1 && targetSDKVersionInt >= 28) {
                        AndroidGradleBuilder.this.foregroundServicePermission = true;
                    }
                    if (!(cls.indexOf("com/codename1/location/LocationManager") != 0 || method.indexOf("addGeoFencing") <= -1 && method.indexOf("setBackgroundLocationListener") <= -1 || "true".equals(playServicesValue) || targetSDKVersionInt < 29)) {
                        AndroidGradleBuilder.this.backgroundLocationPermission = true;
                    }
                    if (!(cls.indexOf("com/codename1/location/LocationManager") != 0 || method.indexOf("addGeoFencing") <= -1 && method.indexOf("getLocationManager") <= -1 || "true".equals(playServicesValue))) {
                        AndroidGradleBuilder.this.debug("Adding location playservice");
                        request.putArgument("android.location.minPlayServicesVersion", "12.0.1");
                        AndroidGradleBuilder.this.playServicesLocation = true;
                        AndroidGradleBuilder.this.playFlag = "false";
                    }
                    if (cls.indexOf("com/codename1/media/MediaManager") == 0 && method.indexOf("setRemoteControlListener") > -1) {
                        AndroidGradleBuilder.this.debug("Adding wake lock permission due to use of MediaManager.setRemoteControlListener");
                        AndroidGradleBuilder.this.wakeLock = true;
                        AndroidGradleBuilder.this.addRemoteControlService = true;
                    }
                    if (cls.indexOf("com/codename1/ui/Display") == 0 && method.indexOf("getUdid") > -1) {
                        AndroidGradleBuilder.this.debug("Adding phone permission because of Display.getUdid method");
                        AndroidGradleBuilder.this.phonePermission = true;
                    }
                    if (cls.indexOf("com/codename1/ui/Display") == 0 && method.indexOf("getMsisdn") > -1) {
                        AndroidGradleBuilder.this.phonePermission = true;
                    }
                    if (cls.indexOf("com/codename1/ui/Display") == 0 && method.indexOf("getAllContacts") > -1) {
                        AndroidGradleBuilder.this.contactsReadPermission = true;
                    }
                    if (cls.indexOf("com/codename1/ui/Display") == 0 && method.indexOf("lockScreen") > -1) {
                        AndroidGradleBuilder.this.wakeLock = true;
                    }
                    if (cls.indexOf("com/codename1/ui/Display") == 0 && method.indexOf("setScreenSaverEnabled") > -1) {
                        AndroidGradleBuilder.this.wakeLock = true;
                    }
                    if (cls.indexOf("com/codename1/media/MediaManager") == 0 && method.indexOf("createMediaRecorder") > -1) {
                        AndroidGradleBuilder.this.recordAudio = true;
                    }
                    if (cls.indexOf("com/codename1/ui/Display") == 0 && method.indexOf("createMediaRecorder") > -1) {
                        AndroidGradleBuilder.this.recordAudio = true;
                    }
                    if (cls.indexOf("com/codename1/media/MediaManager") == 0 && method.indexOf("createMedia") > -1 && method.indexOf("createMediaRecorder") < 0) {
                        AndroidGradleBuilder.this.mediaPlaybackPermission = true;
                    }
                    if (cls.indexOf("com/codename1/ui/Display") == 0 && method.indexOf("createMedia") > -1 && method.indexOf("createMediaRecorder") < 0) {
                        AndroidGradleBuilder.this.mediaPlaybackPermission = true;
                    }
                    if (cls.indexOf("com/codename1/ui/Display") == 0 && method.indexOf("createContact") > -1) {
                        AndroidGradleBuilder.this.contactsWritePermission = true;
                    }
                    if (cls.indexOf("com/codename1/ui/Display") == 0 && method.indexOf("deleteContact") > -1) {
                        AndroidGradleBuilder.this.contactsWritePermission = true;
                    }
                    if (cls.indexOf("com/codename1/contacts/ContactsManager") == 0 && method.indexOf("createContact") > -1) {
                        AndroidGradleBuilder.this.contactsWritePermission = true;
                    }
                    if (cls.indexOf("com/codename1/contacts/ContactsManager") == 0 && method.indexOf("deleteContact") > -1) {
                        AndroidGradleBuilder.this.contactsWritePermission = true;
                    }
                }
            });
        }
        catch (IOException ex) {
            throw new BuildException("An error occurred while trying to scan the classes for API usage.", ex);
        }
        boolean bl = useFCM = this.pushPermission && "fcm".equalsIgnoreCase(request.getArg("android.messagingService", "fcm"));
        if (useFCM) {
            request.putArgument("android.fcm.minPlayServicesVersion", "12.0.1");
        }
        this.debug("Starting playServicesVersion " + this.playServicesVersion);
        for (String arg : request.getArgs()) {
            if (!arg.endsWith(".minPlayServicesVersion") || AndroidGradleBuilder.compareVersions(request.getArg(arg, null), this.playServicesVersion) <= 0) continue;
            this.playServicesVersion = request.getArg(arg, null);
            this.debug("playServicesVersion increased to " + this.playServicesVersion + " due to " + arg);
        }
        request.putArgument("android.playServicesVersion", this.playServicesVersion);
        request.putArgument("android.firebaseCoreVersion", request.getArg("android.firebaseCoreVersion", this.newFirebaseMessaging ? "21.1.1" : this.getDefaultPlayServiceVersion("firebase-core")));
        request.putArgument("android.firebaseMessagingVersion", request.getArg("android.firebaseMessagingVersion", this.newFirebaseMessaging ? "23.2.1" : this.getDefaultPlayServiceVersion("firebase-messaging")));
        this.debug("-----USING PLAY SERVICES VERSION " + this.playServicesVersion + "----");
        String compile = "compile";
        if (this.useAndroidX || this.useArrImplementation) {
            compile = "implementation";
        }
        if (useFCM) {
            if (!googleServicesJson.exists()) {
                this.error("google-services.json not found.  When using FCM for push notifications (i.e. android.messagingService=fcm), you must include valid google-services.json file.  Use the Firebase console to add Firebase messaging to your app.  https://console.firebase.google.com/u/0/ Then download the google-services.json file and place it in the native/android directory of your project. If you still want to use GCM (which no longer works) define the build hint android.messagingService=gcm", new RuntimeException());
                return false;
            }
            if (this.buildToolsVersionInt < 27) {
                this.error("FCM push notifications require build tools version 27 or higher.  Please set the android.buildToolsVersion to 27.0.0 or higher or remove the android.messagingService=fcm build hint.", new RuntimeException());
                return false;
            }
            if (!request.getArg("android.topDependency", "").contains("com.google.gms:google-services")) {
                if (gradleVersionInt >= 8) {
                    request.putArgument("android.topDependency", request.getArg("android.topDependency", "") + "\n    classpath 'com.google.gms:google-services:4.3.15'\n");
                } else {
                    request.putArgument("android.topDependency", request.getArg("android.topDependency", "") + "\n    classpath 'com.google.gms:google-services:4.0.1'\n");
                }
            }
            if (!request.getArg("android.xgradle", "").contains("apply plugin: 'com.google.gms.google-services'")) {
                request.putArgument("android.xgradle", request.getArg("android.xgradle", "") + "\napply plugin: 'com.google.gms.google-services'\n");
            }
            if (!request.getArg("gradleDependencies", "").contains("com.google.firebase:firebase-messaging")) {
                request.putArgument("gradleDependencies", request.getArg("gradleDependencies", "") + "\n" + compile + " \"com.google.firebase:firebase-messaging:" + request.getArg("android.firebaseMessagingVersion", this.playServicesVersion) + "\"\n");
            }
        }
        if (this.useGradle8 || request.getArg("android.playService.plus", null) != null || request.getArg("android.playService.auth", googleServicesJson.exists() ? "true" : null) != null || request.getArg("android.playService.base", null) != null || request.getArg("android.playService.identity", null) != null || request.getArg("android.playService.indexing", null) != null || request.getArg("android.playService.appInvite", null) != null || request.getArg("android.playService.analytics", null) != null || request.getArg("android.playService.cast", null) != null || request.getArg("android.playService.gcm", null) != null || request.getArg("android.playService.drive", null) != null || request.getArg("android.playService.fitness", null) != null || request.getArg("android.playService.location", null) != null || request.getArg("android.playService.maps", null) != null || request.getArg("android.playService.ads", null) != null || request.getArg("android.playService.vision", null) != null || request.getArg("android.playService.nearby", null) != null || request.getArg("android.playService.panorama", null) != null || request.getArg("android.playService.games", null) != null || request.getArg("android.playService.safetynet", null) != null || request.getArg("android.playService.wallet", null) != null || request.getArg("android.playService.wearable", null) != null || request.getArg("android.playService.ads", null) != null) {
            this.playFlag = "false";
        }
        this.initPlayServiceVersions(request);
        boolean legacyGplayServicesMode = false;
        if (playServicesValue != null) {
            if (playServicesValue.equals("true")) {
                legacyGplayServicesMode = true;
                if (this.playFlag.equals("false")) {
                    if (googleServicesJson.exists()) {
                        this.debug("The android.playService.auth flag was automatically enabled because the project includes the google-services.json file");
                    }
                    this.error("Error: you can't use the build hint android.includeGPlayServices together with android.playService.* build hints. They are exclusive of one another. Please remove the old android.includeGPlayServices hint from your code or from the cn1lib that might have injected it", new RuntimeException());
                    return false;
                }
                this.playFlag = "true";
            } else {
                this.playFlag = "false";
            }
        }
        this.playServicesPlus = !request.getArg("android.playService.plus", "false").equals("false");
        this.playServicesAuth = !request.getArg("android.playService.auth", Boolean.valueOf(this.playFlag) != false || googleServicesJson.exists() ? "true" : "false").equals("false");
        this.playServicesBase = !request.getArg("android.playService.base", this.playFlag).equals("false");
        this.playServicesIdentity = !request.getArg("android.playService.identity", "false").equals("false");
        this.playServicesIndexing = !request.getArg("android.playService.indexing", "false").equals("false");
        this.playServicesInvite = !request.getArg("android.playService.appInvite", "false").equals("false");
        this.playServicesAnalytics = !request.getArg("android.playService.analytics", this.playFlag).equals("false");
        this.playServicesCast = !request.getArg("android.playService.cast", "false").equals("false");
        this.playServicesGcm = !request.getArg("android.playService.gcm", this.playFlag).equals("false") || request.getArg("gcm.sender_id", null) != null;
        this.playServicesDrive = !request.getArg("android.playService.drive", "false").equals("false");
        this.playServicesFit = !request.getArg("android.playService.fitness", "false").equals("false");
        this.playServicesLocation = this.playServicesLocation || !request.getArg("android.playService.location", this.playFlag).equals("false");
        this.playServicesMaps = !request.getArg("android.playService.maps", this.playFlag).equals("false");
        boolean bl2 = this.playServicesAds = !request.getArg("android.playService.ads", "false").equals("false");
        if (request.getArg("android.googleAdUnitId", request.getArg("google.adUnitId", null)) != null) {
            this.playServicesAds = true;
        }
        this.playServicesVision = !request.getArg("android.playService.vision", "false").equals("false");
        this.playServicesNearBy = !request.getArg("android.playService.nearby", "false").equals("false");
        this.playServicesSafetyPanorama = !request.getArg("android.playService.panorama", "false").equals("false");
        this.playServicesGames = !request.getArg("android.playService.games", "false").equals("false");
        this.playServicesSafetyNet = !request.getArg("android.playService.safetynet", "false").equals("false");
        this.playServicesWallet = !request.getArg("android.playService.wallet", "false").equals("false");
        boolean bl3 = this.playServicesWear = !request.getArg("android.playService.wearable", "false").equals("false");
        if (googleAdUnitId == null && this.playServicesAds) {
            minSDK = AndroidGradleBuilder.maxInt("9", minSDK);
            if (!userXapplication.contains("com.google.android.gms.version")) {
                googlePlayAdsMetaData = "<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\"/>";
            }
        }
        if (this.playServicesLocation) {
            this.debug("Play Services Location Enabled");
            googlePlayObfuscation = googlePlayObfuscation + "-keep class com.codename1.location.AndroidLocationPlayServiceManager {\n*;\n}\n\n";
            googlePlayObfuscation = googlePlayObfuscation + "-keep class com.codename1.location.BackgroundLocationHandler {\n*;\n}\n\n";
            googlePlayObfuscation = googlePlayObfuscation + "-keep class com.codename1.location.BackgroundLocationBroadcastReceiver {\n*;\n}\n\n";
            googlePlayObfuscation = googlePlayObfuscation + "-keep class com.codename1.impl.android.BackgroundFetchHandler {\n*;\n}\n\n";
            googlePlayObfuscation = googlePlayObfuscation + "-keep class com.codename1.location.GeofenceHandler {\n*;\n}\n\n";
            googlePlayObfuscation = googlePlayObfuscation + "-keep class com.codename1.location.CodenameOneBackgroundLocationActivity {\n*;\n}\n\n";
        } else {
            this.debug("Play services location disabled");
        }
        this.shouldIncludeGoogleImpl = this.playServicesAuth;
        if (this.shouldIncludeGoogleImpl) {
            googlePlayObfuscation = googlePlayObfuscation + "-keep class com.codename1.social.GoogleImpl {\n*;\n}\n\n";
        }
        File stubFileSourceDir = new File(srcDir, request.getPackageName().replace('.', File.separatorChar));
        stubFileSourceDir.mkdirs();
        String headphonesVars = "";
        String headphonesOnResume = "";
        if (request.getArg("android.headphoneCallback", "false").equals("true")) {
            headphonesVars = "    HeadSetReceiver myHeadphoneReceiver;\n\n    public static void headphonesConnected() {\n        i.headphonesConnected();    }    public static void headphonesDisconnected() {\n        i.headphonesDisconnected();    }";
            headphonesOnResume = "        HeadSetReceiver myReceiver = new HeadSetReceiver();\n        IntentFilter filter = new IntentFilter(Intent.ACTION_HEADSET_PLUG);\n        registerReceiver(myReceiver, filter);\n";
            File headphonesFile = new File(stubFileSourceDir, "HeadSetReceiver.java");
            String stubSourceCode2 = "package " + request.getPackageName() + ";\n\nimport android.content.Context;\nimport android.content.Intent;\nimport android.content.IntentFilter;\nimport android.content.BroadcastReceiver;\n\npublic class HeadSetReceiver extends BroadcastReceiver {\n    @Override public void onReceive(Context context, Intent intent) {\n        if (intent.getAction().equals(Intent.ACTION_HEADSET_PLUG)) {\n            int state = intent.getIntExtra(\"state\", -1);\n            switch (state) {\n            case 0:\n                " + request.getMainClass() + "Stub.headphonesDisconnected();\n                break;\n            case 1:\n                " + request.getMainClass() + "Stub.headphonesConnected();\n                break;\n            }\n        }\n    }\n}";
            try {
                this.createFile(headphonesFile, stubSourceCode2.getBytes());
            }
            catch (IOException ex) {
                throw new BuildException("Failed to create HeadSetReceiver class", ex);
            }
        }
        if (request.getArg("noExtraResources", "false").equals("true")) {
            new File(assetsDir, "CN1Resource.res").delete();
            new File(assetsDir, "androidTheme.res").delete();
            new File(assetsDir, "android_holo_light.res").delete();
        }
        if (this.getAndroidPortSrcJar() == null) {
            try {
                this.setAndroidPortSrcJar(this.getResourceAsFile("/com/codename1/android/android_port_sources.jar", ".jar"));
            }
            catch (IOException ex) {
                throw new BuildException("Failed to find android_port_sources.jar");
            }
        }
        if (!this.getAndroidPortSrcJar().exists()) {
            throw new IllegalStateException("Configuration error.  Cannot find androidPortSrcJar at " + this.getAndroidPortSrcJar());
        }
        try {
            this.unzip(this.androidPortSrcJar, srcDir, assetsDir, srcDir);
        }
        catch (IOException ex) {
            throw new BuildException("Failed to extract android port sources from " + this.androidPortSrcJar, ex);
        }
        File androidImpl = new File(srcDir, "com/codename1/impl/android");
        File playServicesClassFile = this.getPlayServicesJavaSourceFile(srcDir, this.playServicesVersion);
        String playServicesClassName = playServicesClassFile.getName().substring(0, playServicesClassFile.getName().indexOf("."));
        for (File f : androidImpl.listFiles()) {
            if (!f.getName().startsWith("PlayServices_") || !f.getName().endsWith(".java") || f.equals(playServicesClassFile)) continue;
            f.delete();
        }
        if (!playServicesClassFile.getName().equals("PlayServices.java")) {
            File androidImplementation = new File(androidImpl, "AndroidImplementation.java");
            try {
                if (this.playServicesLocation) {
                    this.replaceInFile(androidImplementation, "new PlayServices()", "new com.codename1.impl.android." + playServicesClassName + "()");
                    this.replaceInFile(androidImplementation, "new com.codename1.impl.android.PlayServices()", "new com.codename1.impl.android." + playServicesClassName + "()");
                } else {
                    this.replaceInFile(androidImplementation, "PlayServices.setInstance(", "//PlayServices.setInstance(");
                }
            }
            catch (IOException ex) {
                throw new BuildException("Failed to inject settings into PlayServices class.", ex);
            }
        }
        if (targetSDKVersionInt >= 29 && (androidLocationPlayServicesManager = new File(srcDir, "com/codename1/location/AndroidLocationPlayServicesManager.java")).exists()) {
            try {
                this.replaceInFile(androidLocationPlayServicesManager, "//29+", "");
            }
            catch (IOException ex) {
                throw new BuildException("Failed to activate lines in " + androidLocationPlayServicesManager + " for API 29+");
            }
        }
        this.xQueries = "";
        if (targetSDKVersionInt >= 30) {
            this.xQueries = "<queries>\n" + request.getArg("android.manifest.queries", "") + "</queries>\n";
        }
        if (!facebookSupported) {
            fb = new File(srcDir, "com/codename1/social/FacebookImpl.java");
            fb.delete();
        } else {
            File json = new File(dummyClassesDir, "org/json");
            if (json.exists()) {
                AndroidGradleBuilder.delTree(json);
            }
        }
        if (this.extendAppCompatActivity) {
            try {
                this.replaceInFile(new File(srcDir, "com/codename1/impl/android/CodenameOneActivity.java"), "extends Activity", "extends AppCompatActivity");
                this.replaceInFile(new File(srcDir, "com/codename1/impl/android/CodenameOneActivity.java"), "import android.app.Activity;", "import android.support.v7.app.AppCompatActivity;");
            }
            catch (IOException ex) {
                throw new BuildException("Failed to extend AppCompatActivity", ex);
            }
        }
        if (!this.playServicesLocation) {
            fb = new File(srcDir, "com/codename1/location/AndroidLocationPlayServiceManager.java");
            fb.delete();
            fb = new File(srcDir, "com/codename1/location/BackgroundLocationHandler.java");
            fb.delete();
            fb = new File(srcDir, "com/codename1/location/BackgroundLocationBroadcastReceiver.java");
            fb.delete();
            fb = new File(srcDir, "com/codename1/location/GeofenceHandler.java");
            fb.delete();
            fb = new File(srcDir, "com/codename1/location/CodenameOneBackgroundLocationActivity.java");
            fb.delete();
            for (File f : androidImpl.listFiles()) {
                if (f.getName().startsWith("PlayServices_") && f.getName().endsWith(".java")) {
                    f.delete();
                    continue;
                }
                if (!f.getName().equals("PlayServices.java")) continue;
                f.delete();
            }
        }
        if (!this.shouldIncludeGoogleImpl) {
            fb = new File(srcDir, "com/codename1/social/GoogleImpl.java");
            fb.delete();
        }
        if ((moPubAdUnitId = request.getArg("android.mopubId", null)) != null && moPubAdUnitId.length() > 0) {
            this.integrateMoPub = true;
        }
        if (request.getArg("android.textureView", "false").equals("true")) {
            File impl = new File(srcDir, "com" + File.separator + "codename1" + File.separator + "impl" + File.separator + "android" + File.separator + "AndroidImplementation.java");
            try {
                this.replaceInFile(impl, "public static boolean textureView = false;", "public static boolean textureView = true;");
            }
            catch (IOException ex) {
                throw new BuildException("Failed to process android.textureView build hint", ex);
            }
        }
        if (request.getArg("android.hideStatusBar", "false").equals("true")) {
            File impl = new File(srcDir, "com" + File.separator + "codename1" + File.separator + "impl" + File.separator + "android" + File.separator + "AndroidImplementation.java");
            try {
                this.replaceInFile(impl, "statusBarHidden;", "statusBarHidden = true;");
            }
            catch (IOException ex) {
                throw new BuildException("Failed to process android.hideStatusBar build hint", ex);
            }
        }
        if (request.getArg("android.asyncPaint", "true").equals("true")) {
            File impl = new File(srcDir, "com" + File.separator + "codename1" + File.separator + "impl" + File.separator + "android" + File.separator + "AndroidImplementation.java");
            try {
                this.replaceInFile(impl, "public static boolean asyncView = false;", "public static boolean asyncView = true;");
            }
            catch (IOException ex) {
                throw new BuildException("Failed to process android.asyncPaint build hint", ex);
            }
        }
        if (request.getArg("android.keyboardOpen", "true").equals("true")) {
            File impl = new File(srcDir, "com" + File.separator + "codename1" + File.separator + "impl" + File.separator + "android" + File.separator + "AndroidImplementation.java");
            try {
                this.replaceInFile(impl, "private boolean asyncEditMode = false;", "private boolean asyncEditMode = true;");
            }
            catch (IOException ex) {
                throw new BuildException("Failed to process android.keyboardOpen build hint", ex);
            }
        }
        if (targetNumber != null && Integer.parseInt(targetNumber) >= 17) {
            try {
                File androidBrowserComponentCallback = new File(srcDir, "com" + File.separator + "codename1" + File.separator + "impl" + File.separator + "android" + File.separator + "AndroidBrowserComponentCallback.java");
                this.replaceInFile(androidBrowserComponentCallback, "//import android.webkit.JavascriptInterface;", "import android.webkit.JavascriptInterface;");
                this.replaceInFile(androidBrowserComponentCallback, "//@JavascriptInterface", "@JavascriptInterface");
            }
            catch (Exception androidBrowserComponentCallback) {
                // empty catch block
            }
        }
        File drawableDir = new File(resDir, "drawable");
        drawableDir.mkdirs();
        File drawableHdpiDir = new File(resDir, "drawable-hdpi");
        drawableHdpiDir.mkdirs();
        File drawableLdpiDir = new File(resDir, "drawable-ldpi");
        drawableLdpiDir.mkdirs();
        File drawableMdpiDir = new File(resDir, "drawable-mdpi");
        drawableMdpiDir.mkdirs();
        File drawableXhdpiDir = new File(resDir, "drawable-xhdpi");
        drawableXhdpiDir.mkdirs();
        File drawableXXhdpiDir = new File(resDir, "drawable-xxhdpi");
        drawableXXhdpiDir.mkdirs();
        File drawableXXXhdpiDir = new File(resDir, "drawable-xxxhdpi");
        drawableXXXhdpiDir.mkdirs();
        try {
            BufferedImage iconImage = ImageIO.read(new ByteArrayInputStream(request.getIcon()));
            this.createIconFile(new File(drawableDir, "icon.png"), iconImage, 128, 128);
            this.createIconFile(new File(drawableHdpiDir, "icon.png"), iconImage, 72, 72);
            this.createIconFile(new File(drawableLdpiDir, "icon.png"), iconImage, 36, 36);
            this.createIconFile(new File(drawableMdpiDir, "icon.png"), iconImage, 48, 48);
            this.createIconFile(new File(drawableXhdpiDir, "icon.png"), iconImage, 96, 96);
            this.createIconFile(new File(drawableXXhdpiDir, "icon.png"), iconImage, 144, 144);
            this.createIconFile(new File(drawableXXXhdpiDir, "icon.png"), iconImage, 192, 192);
            File notifFile = new File(assetsDir, "ic_stat_notify.png");
            if (notifFile.exists()) {
                BufferedImage bi = ImageIO.read(notifFile);
                this.createIconFile(new File(drawableDir, "ic_stat_notify.png"), bi, 24, 24);
                notifFile.delete();
            } else {
                if (Integer.parseInt(targetNumber) >= 21) {
                    Image img = this.makeColorTransparent(iconImage, new Color(iconImage.getRGB(2, 2)));
                    BufferedImage notifSmallIcon = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
                    String[] bGr = notifSmallIcon.createGraphics();
                    bGr.drawImage(img, 0, 0, null);
                    bGr.dispose();
                    iconImage = notifSmallIcon;
                }
                this.createIconFile(new File(drawableDir, "ic_stat_notify.png"), iconImage, 24, 24);
            }
        }
        catch (IOException ex) {
            throw new BuildException("Failed to generate icon files", ex);
        }
        if (!this.purchasePermissions && (billingSupport = new File(srcDir, PathUtil.path("com", "codename1", "impl", "android", "BillingSupport.java"))).exists()) {
            billingSupport.delete();
        }
        try {
            AndroidGradleBuilder.zipDir(new File(libsDir, "userClasses.jar").getAbsolutePath(), dummyClassesDir.getAbsolutePath());
        }
        catch (Exception ex) {
            throw new BuildException("Failed to create userClasses.jar", ex);
        }
        File stringsFile = new File(valsDir, "strings.xml");
        String stringsFileContent = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<resources>\n    <string name=\"app_name\">" + AndroidGradleBuilder.xmlize(request.getDisplayName()).replace("'", "\\'") + "</string>\n" + additionalKeyVals + request.getArg("android.stringsXml", "") + "</resources>";
        try {
            FileOutputStream stringsSourceStream = new FileOutputStream(stringsFile);
            ((OutputStream)stringsSourceStream).write(stringsFileContent.getBytes());
            ((OutputStream)stringsSourceStream).close();
            String locales = request.getArg("android.locales", null);
            if (locales != null && locales.length() > 0) {
                for (String loc : locales.split(";")) {
                    File currentValuesDir = new File(valsDir.getParent(), "values-" + loc);
                    currentValuesDir.mkdirs();
                    File currentStringsFile = new File(currentValuesDir, "strings.xml");
                    stringsSourceStream = new FileOutputStream(currentStringsFile);
                    ((OutputStream)stringsSourceStream).write(stringsFileContent.getBytes());
                    ((OutputStream)stringsSourceStream).close();
                }
            }
        }
        catch (IOException ex) {
            this.error("Failed to generate strings file", ex);
            throw new BuildException("Failed to generate strings file " + stringsFile, ex);
        }
        File stylesFile = new File(valsDir, "styles.xml");
        File colors = new File(valsDir, "colors.xml");
        String colorsStr = "";
        if (colors.exists()) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(colors);
                NodeList nl = dom.getElementsByTagName("color");
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node color = nl.item(i);
                    NamedNodeMap attr = color.getAttributes();
                    Node key = attr.getNamedItem("name");
                    String k = key.getNodeValue();
                    colorsStr = colorsStr + "<item name=\"android:" + k + "\">@color/" + k + "</item>\n";
                }
            }
            catch (Exception e) {
                this.error("Failed to create DocumentBuilder", e);
            }
        }
        String themeName = "android:Theme.Black";
        String itemName = androidAppBundle ? "cn1Style" : "attr/cn1Style";
        String stylesFileContent = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<resources>\n    <style name=\"CustomTheme\" parent=\"" + themeName + "\">\n        <item name=\"" + itemName + "\">@style/CN1.EditText.Style</item>\n    </style>\n    <attr name=\"cn1Style\" format=\"reference\" />\n    <style name=\"CN1.EditText.Style\" parent=\"@android:style/Widget.EditText\">\n        <item name=\"android:textCursorDrawable\">@null</item>\n    </style>\n" + request.getArg("android.style", "") + "</resources>";
        try {
            FileOutputStream stylesSourceStream = new FileOutputStream(stylesFile);
            ((OutputStream)stylesSourceStream).write(stylesFileContent.getBytes());
            ((OutputStream)stylesSourceStream).close();
            String theme = request.getArg("android.theme", "Light");
            theme = theme.length() > 0 && theme.equalsIgnoreCase("Dark") ? "" : "." + theme;
            File styles11File = new File(vals11Dir, "styles.xml");
            String styles11FileContent = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<resources>\n    <style name=\"CustomTheme\" parent=\"@android:style/Theme.Holo" + theme + "\">\n        <item name=\"" + itemName + "\">@style/CN1.EditText.Style</item>\n        <item name=\"android:windowActionBar\">false</item>\n        <item name=\"android:windowTitleSize\">0dp</item>\n    </style>\n    <style name=\"CN1.EditText.Style\" parent=\"@android:style/Widget.EditText\">\n        <item name=\"android:textCursorDrawable\">@null</item>\n    </style>\n</resources>\n";
            FileOutputStream styles11SourceStream = new FileOutputStream(styles11File);
            ((OutputStream)styles11SourceStream).write(styles11FileContent.getBytes());
            ((OutputStream)styles11SourceStream).close();
            File styles21File = new File(vals21Dir, "styles.xml");
            String styles21FileContent = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<resources>\n    <style name=\"CustomTheme\" parent=\"@android:style/Theme.Material" + theme + "\">\n        <item name=\"" + itemName + "\">@style/CN1.EditText.Style</item>\n        <item name=\"android:windowActionBar\">false</item>\n        <item name=\"android:windowTitleSize\">0dp</item>\n" + colorsStr + "   </style>\n    <style name=\"CN1.EditText.Style\" parent=\"@android:style/Widget.EditText\">\n        <item name=\"android:textCursorDrawable\">@null</item>\n    </style>\n</resources>\n";
            FileOutputStream styles21SourceStream = new FileOutputStream(styles21File);
            ((OutputStream)styles21SourceStream).write(styles21FileContent.getBytes());
            ((OutputStream)styles21SourceStream).close();
        }
        catch (IOException ex) {
            this.error("Failed to generate style files", ex);
            throw new BuildException("Failed to generate styles files", ex);
        }
        try {
            File layoutFile = new File(layoutDir, "main.xml");
            String layoutFileContent = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<RelativeLayout xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    android:layout_width=\"fill_parent\"\n    android:layout_height=\"fill_parent\"\n" + request.getArg("android.xlayout_attr", "") + "    android:background=\"#ff000000\" >\n" + mopubBannerXML + "</RelativeLayout>\n";
            Object layoutSourceStream = new FileOutputStream(layoutFile);
            ((OutputStream)layoutSourceStream).write(layoutFileContent.getBytes());
            ((OutputStream)layoutSourceStream).close();
            String customLayout = request.getArg("android.cusom_layout1", null);
            int counter = 1;
            while (customLayout != null) {
                File customFile = new File(layoutDir, "cusom_layout" + counter + ".xml");
                layoutSourceStream = new FileOutputStream(customFile);
                ((OutputStream)layoutSourceStream).write(customLayout.getBytes());
                ((OutputStream)layoutSourceStream).close();
                customLayout = request.getArg("android.cusom_layout" + ++counter, null);
            }
        }
        catch (IOException ex) {
            throw new BuildException("Failed to generate layout XML file", ex);
        }
        String storeIds = request.getArg("android.store_ids", null);
        if (storeIds != null) {
            String[] sp = storeIds.split(";");
            storeIds = "";
            for (String s : sp) {
                storeIds = storeIds + "        Display.getInstance().setProperty(\"" + (String)s + "\", \"\" + " + (String)s + ");\n";
            }
        } else {
            storeIds = "";
        }
        if ((gcmSenderId = request.getArg("gcm.sender_id", null)) != null) {
            gcmSenderId = "        Display.getInstance().setProperty(\"gcm.sender_id\", \"" + gcmSenderId + "\");\n";
        } else if (googleServicesJson != null && googleServicesJson.exists()) {
            try {
                JSONParser parser = new JSONParser();
                Map<String, Object> parsedJson = parser.parseJSON(new FileReader(googleServicesJson));
                Map projectInfo = (Map)parsedJson.get("project_info");
                gcmSenderId = (String)projectInfo.get("project_number");
                if (gcmSenderId != null) {
                    gcmSenderId = "        Display.getInstance().setProperty(\"gcm.sender_id\", \"" + gcmSenderId + "\");\n";
                }
                gcmSenderId = "";
            }
            catch (IOException ex) {
                throw new BuildException("Failed to parse the google services JSON file " + googleServicesJson);
            }
        } else {
            gcmSenderId = "";
        }
        File manifestFile = new File(projectDir + "/src/main", "AndroidManifest.xml");
        float version = 1.0f;
        int intVersion = 1;
        try {
            version = Float.parseFloat(request.getVersion());
            String vcOverride = request.getArg("android.versionCode", null);
            intVersion = vcOverride != null && vcOverride.length() > 0 ? Integer.parseInt(vcOverride) : Math.round(100.0f * version);
        }
        catch (Throwable vcOverride) {
            // empty catch block
        }
        String locationServices = "<activity android:name=\"com.codename1.location.CodenameOneBackgroundLocationActivity\" android:theme=\"@android:style/Theme.NoDisplay\" android:exported=\"true\"/>\n<service android:name=\"com.codename1.location.BackgroundLocationHandler\" android:exported=\"false\" />\n<service android:name=\"com.codename1.location.GeofenceHandler\" android:exported=\"false\" />\n";
        String mediaService = "<service android:name=\"com.codename1.media.AudioService\" android:exported=\"false\" />";
        String remoteControlService = "<service android:name=\"com.codename1.media.BackgroundAudioService\"  android:exported=\"true\">\n            <intent-filter>\n                <action android:name=\"android.intent.action.MEDIA_BUTTON\" />\n                <action android:name=\"android.media.AUDIO_BECOMING_NOISY\" />\n                <action android:name=\"android.media.browse.MediaBrowserService\" />\n            </intent-filter>\n        </service>";
        String mediabuttonReceiver = "<receiver android:name=\"" + this.xclass("android.support.v4.media.session.MediaButtonReceiver") + "\" android:exported=\"true\">\n            <intent-filter>\n                <action android:name=\"android.intent.action.MEDIA_BUTTON\" />\n                <action android:name=\"android.media.AUDIO_BECOMING_NOISY\" />\n            </intent-filter>\n        </receiver>";
        if (!this.addRemoteControlService) {
            remoteControlService = "";
            mediabuttonReceiver = "";
        }
        String alarmRecevier = "<receiver android:name=\"com.codename1.impl.android.LocalNotificationPublisher\" android:exported=\"false\"></receiver>\n";
        String backgroundLocationReceiver = "<receiver android:name=\"com.codename1.location.BackgroundLocationBroadcastReceiver\" android:exported=\"true\"></receiver>\n";
        if (!this.playServicesLocation) {
            backgroundLocationReceiver = "";
        }
        String backgroundFetchService = "<service android:name=\"com.codename1.impl.android.BackgroundFetchHandler\" android:exported=\"false\" />\n<activity android:name=\"com.codename1.impl.android.CodenameOneBackgroundFetchActivity\" android:theme=\"@android:style/Theme.NoDisplay\" android:exported=\"true\"/>\n";
        if (this.foregroundServicePermission) {
            permissions = permissions + this.permissionAdd(request, "\"android.permission.FOREGROUND_SERVICE\"", "    <uses-permission android:name=\"android.permission.FOREGROUND_SERVICE\" />\n");
        }
        if (this.postNotificationsPermission) {
            permissions = permissions + this.permissionAdd(request, "\"android.permission.POST_NOTIFICATIONS\"", "    <uses-permission android:name=\"android.permission.POST_NOTIFICATIONS\" />\n");
        }
        if (this.capturePermission) {
            String andc = request.getArg("android.captureRecord", "enabled");
            permissions = request.getArg("and.captureRecord", andc).equals("enabled") ? permissions + this.permissionAdd(request, "\"android.hardware.camera\"", "<uses-feature android:name=\"android.hardware.camera\" android:required=\"false\" />\n") + this.permissionAdd(request, "RECORD_AUDIO", "    <uses-permission android:name=\"android.permission.RECORD_AUDIO\" android:required=\"false\" />\n") : permissions + this.permissionAdd(request, "\"android.hardware.camera\"", "<uses-feature android:name=\"android.hardware.camera\" android:required=\"false\" />\n");
        }
        if (this.vibratePermission) {
            permissions = permissions + this.permissionAdd(request, "VIBRATE", "    <uses-permission android:name=\"android.permission.VIBRATE\" android:required=\"false\" />\n");
        }
        if (this.smsPermission) {
            permissions = permissions + this.permissionAdd(request, "SEND_SMS", "<uses-permission android:name=\"android.permission.SEND_SMS\" android:required=\"false\" />\n");
        }
        if (this.gpsPermission) {
            permissions = permissions + "    <uses-feature android:name=\"android.hardware.location\" android:required=\"false\" />\n    <uses-feature android:name=\"android.hardware.location.gps\" android:required=\"false\" />\n" + this.permissionAdd(request, "ACCESS_FINE_LOCATION", "    <uses-permission android:name=\"android.permission.ACCESS_FINE_LOCATION\" android:required=\"false\" />\n") + this.permissionAdd(request, "ACCESS_COARSE_LOCATION", "    <uses-permission android:name=\"android.permission.ACCESS_COARSE_LOCATION\"  android:required=\"false\" />\n");
            if (request.getArg("android.mockLocation", "true").equals("true")) {
                permissions = permissions + this.permissionAdd(request, "ACCESS_MOCK_LOCATION", "    <uses-permission android:name=\"android.permission.ACCESS_MOCK_LOCATION\"  android:required=\"false\" />\n");
            }
        }
        if (this.pushPermission && !useFCM) {
            permissions = permissions + "<permission android:name=\"" + request.getPackageName() + ".permission.C2D_MESSAGE\" android:protectionLevel=\"signature\" />\n    <uses-permission android:name=\"" + request.getPackageName() + ".permission.C2D_MESSAGE\" />\n    <uses-permission android:name=\"com.google.android.c2dm.permission.RECEIVE\" />\n";
        }
        if (this.contactsReadPermission) {
            permissions = permissions + this.permissionAdd(request, "READ_CONTACTS", "    <uses-permission android:name=\"android.permission.READ_CONTACTS\" android:required=\"false\" />\n");
        }
        if (this.contactsWritePermission) {
            permissions = permissions + this.permissionAdd(request, "WRITE_CONTACTS", "    <uses-permission android:name=\"android.permission.WRITE_CONTACTS\" android:required=\"false\" />\n");
        }
        if (this.accessWifiStatePermissions) {
            permissions = permissions + this.permissionAdd(request, "ACCESS_WIFI_STATE", "<uses-permission android:name=\"android.permission.ACCESS_WIFI_STATE\" android:required=\"false\" />\n");
        }
        if (this.browserBookmarksPermissions) {
            permissions = permissions + "<uses-permission android:name=\"com.android.browser.permission.WRITE_HISTORY_BOOKMARKS\" android:required=\"false\"/>\n<uses-permission android:name=\"com.android.browser.permission.READ_HISTORY_BOOKMARKS\" android:required=\"false\"/>\n";
        }
        if (this.launcherPermissions) {
            permissions = permissions + "<uses-permission android:name=\"com.android.launcher.permission.INSTALL_SHORTCUT\"/>\n<uses-permission android:name=\"com.android.launcher.permission.UNINSTALL_SHORTCUT\"/>\n<uses-permission android:name=\"com.android.launcher.permission.READ_SETTINGS\"/>\n<!--device specific permissions -->\n<uses-permission android:name=\"com.htc.launcher.permission.READ_SETTINGS\"/>\n<uses-permission android:name=\"com.motorola.launcher.permission.READ_SETTINGS\"/>\n<uses-permission android:name=\"com.motorola.dlauncher.permission.READ_SETTINGS\"/>\n<uses-permission android:name=\"com.fede.launcher.permission.READ_SETTINGS\"/>\n<uses-permission android:name=\"com.lge.launcher.permission.READ_SETTINGS\"/>\n<uses-permission android:name=\"org.adw.launcher.permission.READ_SETTINGS\"/>\n<uses-permission android:name=\"com.motorola.launcher.permission.INSTALL_SHORTCUT\"/>\n<uses-permission android:name=\"com.motorola.dlauncher.permission.INSTALL_SHORTCUT\"/>\n<uses-permission android:name=\"com.lge.launcher.permission.INSTALL_SHORTCUT\"/>\n";
        }
        if (this.recordAudio) {
            permissions = permissions + this.permissionAdd(request, "RECORD_AUDIO", "<uses-permission android:name=\"android.permission.RECORD_AUDIO\" android:required=\"false\" />\n");
        }
        if (this.wakeLock) {
            permissions = permissions + this.permissionAdd(request, "WAKE_LOCK", "<uses-permission android:name=\"android.permission.WAKE_LOCK\" android:required=\"false\" />\n");
        }
        if (this.phonePermission) {
            permissions = permissions + this.permissionAdd(request, "READ_PHONE_STATE", "<uses-permission android:name=\"android.permission.READ_PHONE_STATE\" android:required=\"false\" />\n");
        }
        if (this.accessNetworkStatePermission) {
            permissions = permissions + this.permissionAdd(request, "ACCESS_NETWORK_STATE", "<uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\" android:required=\"false\" />\n");
        }
        if (this.recieveBootCompletedPermission) {
            permissions = permissions + this.permissionAdd(request, "RECEIVE_BOOT_COMPLETED", "<uses-permission android:name=\"android.permission.RECEIVE_BOOT_COMPLETED\" android:required=\"false\" />\n");
        }
        if (this.getAccountsPermission) {
            permissions = permissions + this.permissionAdd(request, "GET_ACCOUNTS", "<uses-permission android:name=\"android.permission.GET_ACCOUNTS\" android:required=\"false\" />\n");
        }
        if (this.credentialsPermission) {
            permissions = permissions + this.permissionAdd(request, "USE_CREDENTIALS", "<uses-permission android:name=\"android.permission.USE_CREDENTIALS\" />\n");
        }
        if (this.backgroundLocationPermission && !this.xPermissions.contains("android.permission.ACCESS_BACKGROUND_LOCATION")) {
            permissions = permissions + "<uses-permission android:name=\"android.permission.ACCESS_BACKGROUND_LOCATION\"  android:required=\"false\" />\n";
        }
        String billingServiceData = "";
        String activityBillingSource = "";
        String consumable = "";
        if (this.purchasePermissions) {
            String k = request.getArg("android.licenseKey", null);
            if (k == null) {
                throw new BuildException("android.licenseKey must be defined in the build hints, grab the key from the \"Monetization setup\" section in the android dev portal, then paste the Base64-encoded RSA public key into the android.licenseKey build hint.\n\n");
            }
            String cons = request.getArg("android.nonconsumable", null);
            if (cons != null) {
                if ((cons = cons.trim()).contains(",")) {
                    StringTokenizer token = new StringTokenizer(cons, ",");
                    if (token.countTokens() > 0) {
                        try {
                            while (token.hasMoreElements()) {
                                String t = token.nextToken();
                                t = t.trim();
                                consumable = consumable + "\"" + t + "\",";
                            }
                            consumable = consumable.substring(0, consumable.length() - 1);
                        }
                        catch (Exception t) {}
                    }
                } else {
                    consumable = "\"" + cons + "\"";
                }
            }
            permissions = permissions + "    <uses-permission android:name=\"com.android.vending.BILLING\" android:required=\"false\" />\n";
            activityBillingSource = "    protected boolean isBillingEnabled() {\n        return true;\n    }\n\n    protected com.codename1.impl.android.IBillingSupport createBillingSupport() {\n        return new com.codename1.impl.android.BillingSupport(this);\n    }\n\n";
        }
        if ((sharedUserId = request.getArg("android.sharedUserId", "")).length() > 0) {
            sharedUserId = "      android:sharedUserId=\"" + sharedUserId + "\"\n";
        }
        if ((sharedUserLabel = request.getArg("android.sharedUserLabel", "")).length() > 0) {
            sharedUserLabel = "      android:sharedUserLabel=\"" + sharedUserLabel + "\"\n";
        }
        String basePermissions = "    <uses-feature android:name=\"android.hardware.telephony\" android:required=\"" + telephonyRequired + "\" />\n    <uses-permission android:name=\"android.permission.INTERNET\" android:required=\"false\" />\n";
        if (request.getArg("android.removeBasePermissions", "false").equals("true")) {
            basePermissions = "";
        }
        boolean blockExternalStoragePermission = request.getArg("android.blockExternalStoragePermission", "false").equals("true");
        String externalStoragePermission = "";
        if (!blockExternalStoragePermission) {
            externalStoragePermission = "    <uses-permission android:name=\"android.permission.WRITE_EXTERNAL_STORAGE\" android:required=\"false\" android:maxSdkVersion=\"32\" />\n";
        }
        boolean blockReadMediaPermissions = request.getArg("android.blockReadMediaPermissions", blockExternalStoragePermission ? "true" : "false").equals("true");
        boolean requestReadMediaPermissions = request.getArg("android.requestReadMediaPermissions", "false").equals("true");
        String readMediaPermissions = "";
        if (!blockReadMediaPermissions && targetSDKVersionInt >= 33 && (this.mediaPlaybackPermission || requestReadMediaPermissions)) {
            readMediaPermissions = readMediaPermissions + this.permissionAdd(request, "\"android.permission.READ_MEDIA_IMAGES\"", "    <uses-permission android:name=\"android.permission.READ_MEDIA_IMAGES\" android:required=\"false\" />\n");
            readMediaPermissions = readMediaPermissions + this.permissionAdd(request, "\"android.permission.READ_MEDIA_VIDEO\"", "    <uses-permission android:name=\"android.permission.READ_MEDIA_VIDEO\" android:required=\"false\" />\n");
            readMediaPermissions = readMediaPermissions + this.permissionAdd(request, "\"android.permission.READ_MEDIA_AUDIO\"", "    <uses-permission android:name=\"android.permission.READ_MEDIA_AUDIO\" android:required=\"false\" />\n");
        }
        String xmlizedDisplayName = AndroidGradleBuilder.xmlize(request.getDisplayName());
        String applicationAttr = request.getArg("android.xapplication_attr", "");
        String allowBackup = " android:allowBackup=\"" + request.getArg("android.allowBackup", "true") + "\" ";
        if (applicationAttr.contains("allowBackup")) {
            allowBackup = "";
        }
        String applicationNode = "  <application ";
        if (!applicationAttr.contains("android:label")) {
            applicationNode = applicationNode + " android:label=\"" + xmlizedDisplayName + "\" ";
        }
        if (!applicationAttr.contains("android:icon")) {
            applicationNode = applicationNode + " android:icon=\"@drawable/icon\" ";
        }
        if (request.getArg("android.multidex", "true").equals("true") && Integer.parseInt(minSDK) < 21) {
            this.debug("Setting Application node to MultiDexApplication because minSDK=" + minSDK + " < 21");
            applicationNode = applicationNode + " android:name=\"" + this.xclass("android.support.multidex.MultiDexApplication") + "\" ";
        }
        applicationNode = applicationNode + applicationAttr;
        applicationNode = applicationNode + allowBackup;
        applicationNode = applicationNode + ">\n";
        String providerTag = "<provider\n          android:name=\"" + this.xclass("android.support.v4.content.FileProvider") + "\"\n          android:authorities=\"${applicationId}.provider\"\n          android:exported=\"false\"\n          android:grantUriPermissions=\"true\">\n          <meta-data\n              android:name=\"android.support.FILE_PROVIDER_PATHS\"\n              android:resource=\"@xml/file_paths\">\n          </meta-data>\n      </provider>";
        if (!providerTag.isEmpty()) {
            File filePathsFile = new File(xmlDir, "file_paths.xml");
            String filePathsContent = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<paths xmlns:android=\"http://schemas.android.com/apk/res/android\">\n    <cache-path name=\"intent_files\" path=\"intent_files/\" />\n" + request.getArg("android.file_paths", "    <files-path name=\"app_files\" path=\".\" />") + "</paths>";
            try {
                FileOutputStream filePathsStream = new FileOutputStream(filePathsFile);
                ((OutputStream)filePathsStream).write(filePathsContent.getBytes());
                ((OutputStream)filePathsStream).close();
            }
            catch (IOException ex) {
                throw new BuildException("Failed to write file path providers file", ex);
            }
        }
        String pushManifestEntries = "        <service android:name=\"PushNotificationService\" android:exported=\"true\">\n            <intent-filter>\n                <action android:name=\"" + request.getPackageName() + ".PushNotificationService\" />\n            </intent-filter>\n        </service>\n        <receiver android:name=\".PushReceiver\" android:permission=\"com.google.android.c2dm.permission.SEND\" android:exported=\"true\">\n            <intent-filter>\n                <action android:name=\"com.google.android.c2dm.intent.RECEIVE\" />\n                <category android:name=\"" + request.getPackageName() + "\" />\n            </intent-filter>\n            <intent-filter>\n                <action android:name=\"com.google.android.c2dm.intent.REGISTRATION\" />\n                <category android:name=\"" + request.getPackageName() + "\" />\n            </intent-filter>\n        </receiver>\n";
        if (!this.pushPermission) {
            pushManifestEntries = "";
        } else if (useFCM) {
            pushManifestEntries = "<service\n          android:name=\"com.codename1.impl.android.CN1FirebaseMessagingService\" android:exported=\"true\">\n          <intent-filter>\n              <action android:name=\"com.google.firebase.MESSAGING_EVENT\" />\n          </intent-filter>\n      </service>\n";
        }
        String launchMode = request.getArg("android.activity.launchMode", "singleTop");
        String xActivity = request.getArg("android.xactivity", "");
        if (!xActivity.contains("android:exported")) {
            xActivity = xActivity + " android:exported=\"true\"";
        }
        String activityTheme = "@style/CustomTheme";
        if (this.extendAppCompatActivity) {
            activityTheme = "@@style/Theme.AppCompat.NoActionBar";
        }
        String manifestSource = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n      package=\"" + request.getPackageName() + "\"\n      android:versionCode=\"" + intVersion + "\"\n      android:versionName=\"" + request.getVersion() + "\"\n      xmlns:tools=\"http://schemas.android.com/tools\"\n" + sharedUserLabel + sharedUserId + "      android:minSdkVersion=\"" + minSDK + "\"\n      android:installLocation=\"" + request.getArg("android.installLocation", "auto") + "\">\n    <uses-sdk android:minSdkVersion=\"" + minSDK + "\"" + targetSDKVersion + request.getArg("android.xmanifest", "") + " />\n    <supports-screens android:smallScreens=\"" + request.getArg("android.smallScreens", "true") + "\"\n          android:normalScreens=\"" + request.getArg("android.normalScreens", "true") + "\"\n          android:largeScreens=\"" + request.getArg("android.largeScreens", "true") + "\"\n          android:xlargeScreens=\"" + request.getArg("android.xlargeScreens", "true") + "\"\n" + request.getArg("android.supportScreens", "") + "          android:anyDensity=\"" + request.getArg("android.anyDensity", "true") + "\" />\n" + applicationNode + providerTag + usesLibrary + googlePlayAdsMetaData + "        <activity android:name=\"" + request.getMainClass() + "Stub\"\n" + xActivity + "                  android:theme=\"" + activityTheme + "\"\n                  android:configChanges=\"orientation|keyboardHidden|screenSize|smallestScreenSize|screenLayout\"\n                  android:launchMode=\"" + launchMode + "\"\n                  android:label=\"" + xmlizedDisplayName + "\" >\n            <intent-filter>\n                <action android:name=\"android.intent.action.MAIN\" />\n                <category android:name=\"android.intent.category.LAUNCHER\" />\n            </intent-filter>\n" + request.getArg("android.xintent_filter", "") + "        </activity>\n" + facebookActivityMetaData + facebookActivity + googlePlayAdsActivity + pushManifestEntries + billingServiceData + "  " + request.getArg("android.xapplication", "") + mopubActivities + alarmRecevier + backgroundLocationReceiver + mediabuttonReceiver + backgroundFetchService + locationServices + mediaService + remoteControlService + "    </application>\n    <uses-feature android:name=\"android.hardware.touchscreen\" android:required=\"false\" />\n" + basePermissions + externalStoragePermission + readMediaPermissions + permissions + "  " + this.xPermissions + "  " + this.xQueries + "</manifest>\n";
        try {
            FileOutputStream manifestSourceStream = new FileOutputStream(manifestFile);
            ((OutputStream)manifestSourceStream).write(manifestSource.getBytes());
            ((OutputStream)manifestSourceStream).close();
        }
        catch (IOException ex) {
            throw new BuildException("Failed to write manifest file", ex);
        }
        this.debug("Generated manifest file: " + manifestSource);
        String oncreate = request.getArg("android.onCreate", "");
        String initStackSize = "";
        String stackSize = request.getArg("android.stack_size", null);
        if (stackSize != null) {
            initStackSize = "        com.codename1.impl.CodenameOneThread.STACK_FRAME_SIZE = " + stackSize + ";\n";
        }
        androidLicenseKey = (androidLicenseKey = (licenseKey = request.getArg("android.licenseKey", null))) != null ? "Display.getInstance().setProperty(\"android.licenseKey\", \"" + androidLicenseKey + "\");\n" : "";
        String useBackgroundPermissionSnippet = "";
        if (this.backgroundLocationPermission) {
            useBackgroundPermissionSnippet = "Display.getInstance().setProperty(\"android.requiresBackgroundLocationPermissionForAPI29\", \"true\");\n";
        }
        streamMode = (streamMode = request.getArg("android.streamMode", null)) != null ? (streamMode.equals("music") ? "        setVolumeControlStream(android.media.AudioManager.STREAM_MUSIC);\n" : "") : "";
        String localNotificationCode = "";
        localNotificationCode = "        if(i instanceof com.codename1.notifications.LocalNotificationCallback){\n            Intent intent = getIntent();\n            if(intent != null && intent.getExtras() != null && intent.getExtras().containsKey(\"LocalNotificationID\")){\n                String id = intent.getExtras().getString(\"LocalNotificationID\");\n                intent.removeExtra(\"LocalNotificationID\");\n                ((com.codename1.notifications.LocalNotificationCallback)i).localNotificationReceived(id);\n            }\n        }\n";
        String reinitCode0 = "Display.init(this);\n";
        reinitCode0 = "AndroidImplementation.startContext(this);\n";
        String reinitCode = "Display.init(this);\n";
        reinitCode = "AndroidImplementation.startContext(this);\n";
        String waitingForPermissionsRequestOnStop = "        if (isWaitingForPermissionResult()) {\n            return;\n        }\n";
        String onStopCode = "protected void onStop() {\n        super.onStop();\n" + waitingForPermissionsRequestOnStop + "        if(isWaitingForResult()){\n             return;\n        }\n        synchronized(LOCK) {\n             currentForm = null;\n        }\n        Display.getInstance().callSerially(new Runnable() { public void run() {i.stop();} });\n        running = false;\n    }\n\n";
        onStopCode = "protected void onStop() {\n";
        onStopCode = onStopCode + "        com.codename1.impl.android.AndroidImplementation.writeServiceProperties(this);\n";
        onStopCode = onStopCode + "        super.onStop();\n        if(isWaitingForResult()){\n             return;\n        }\n        synchronized(LOCK) {\n             currentForm = null;\n        }\n        final boolean[] complete = new boolean[1];\n\n        Display.getInstance().callSerially(new Runnable() {\n            public void run() {\n                i.stop();\n                synchronized(complete) {\n                    try {\n                        complete[0] = true;\n                        complete.notify();\n                    } catch (Exception ex) {\n                    }\n                }\n            }\n        });\n        while (!complete[0]) {\n            synchronized(complete) {\n                try {\n                    complete.wait(500);\n                } catch (Exception ex){}\n            }\n        }\n        running = false;\n    }\n\n";
        String onDestroyCode = "    protected void onDestroy() {\n" + this.createOnDestroyCode(request) + "        super.onDestroy();\n        Display.getInstance().callSerially(new Runnable() { public void run() {i.destroy(); Display.deinitialize();} });\n        running = false;\n    }\n";
        onDestroyCode = "protected void onDestroy() {\n" + this.createOnDestroyCode(request) + "        super.onDestroy();\n\n        Display.getInstance().callSerially(new Runnable() { public void run() {i.destroy();} });\n        AndroidImplementation.stopContext(this);\n        running = false;\n    }";
        File stubFileSourceFile = new File(stubFileSourceDir, request.getMainClass() + "Stub.java");
        String consumableCode = "public boolean isConsumable(String sku) {\n  boolean retVal = super.isConsumable(sku);\n  java.util.List l = new java.util.ArrayList();\n  java.util.Collections.addAll(l, consumable);\n  return retVal || l.contains(sku);\n}\n";
        String firstTimeStatic = "";
        firstTimeStatic = " static";
        String notificationChannelId = request.getArg("android.NotificationChannel.id", "cn1-channel");
        String notificationChannelName = request.getArg("android.NotificationChannel.name", "Notifications");
        String notificationChannelDescription = request.getArg("android.NotificationChannel.description", "Remote notifications");
        String notificationChannelImportance = request.getArg("android.NotificationChannel.importance", "2");
        String notificationChannelEnableLights = request.getArg("android.NotificationChannel.enableLights", "true");
        String notificationChannelLightColor = request.getArg("android.NotificationChannel.lightColor", "-65536");
        String notificationChannelEnableVibration = request.getArg("android.NotificationChannel.enableVibration", "false");
        String notificationChannelVibrationPattern = request.getArg("android.NotificationChannel.vibrationPattern", request.getArg("android.pushVibratePattern", null));
        if (notificationChannelVibrationPattern != null) {
            notificationChannelVibrationPattern = "\"" + notificationChannelVibrationPattern + "\"";
        }
        String pushInitDisplayProperties = "";
        if (this.buildToolsVersionInt >= 26 && Integer.parseInt(targetNumber) >= 26) {
            pushInitDisplayProperties = "        Display.getInstance().setProperty(\"android.NotificationChannel.id\", \"" + notificationChannelId + "\");\n        Display.getInstance().setProperty(\"android.NotificationChannel.name\", \"" + notificationChannelName + "\");\n        Display.getInstance().setProperty(\"android.NotificationChannel.description\", \"" + notificationChannelDescription + "\");\n        Display.getInstance().setProperty(\"android.NotificationChannel.importance\", \"" + notificationChannelImportance + "\");\n        Display.getInstance().setProperty(\"android.NotificationChannel.enableLights\", \"" + notificationChannelEnableLights + "\");\n        Display.getInstance().setProperty(\"android.NotificationChannel.lightColor\", \"" + notificationChannelLightColor + "\");\n        Display.getInstance().setProperty(\"android.NotificationChannel.enableVibration\", \"" + notificationChannelEnableVibration + "\");\n        Display.getInstance().setProperty(\"android.NotificationChannel.vibrationPattern\", " + notificationChannelVibrationPattern + ");\n        try {\n            Display.getInstance().setProperty(\"android.NotificationChannel.soundUri\", android.media.RingtoneManager.getDefaultUri(android.media.RingtoneManager.TYPE_NOTIFICATION).toString());\n        } catch (Exception ex){}\n";
            if (request.getArg("android.pushSound", null) != null) {
                pushInitDisplayProperties = pushInitDisplayProperties + "        try {\n            Display.getInstance().setProperty(\"android.NotificationChannel.soundUri\", \"android.resource://" + request.getPackageName() + "/raw/" + request.getArg("android.pushSound", null) + "\");\n        } catch (Exception ex){}\n";
            }
        }
        String rootCheckCall = "";
        if (this.rootCheck) {
            if (!request.getArg("gradleDependencies", "").contains("com.scottyab:rootbeer-lib")) {
                String rootbeerVersion = request.getArg("android.rootbeerVersion", "0.1.0");
                request.putArgument("gradleDependencies", request.getArg("gradleDependencies", "") + "\n" + compile + " \"com.scottyab:rootbeer-lib:" + rootbeerVersion + "\"\n");
            }
            rootCheckCall = "        com.scottyab.rootbeer.RootBeer rootBeer = new com.scottyab.rootbeer.RootBeer(this);\n        if (rootBeer.isRooted()) {\n            android.util.Log.e(\"Codename One\", \"Device is rooted. Exiting app.\");\n            System.exit(0);\n        }\n";
        }
        String fridaDetectionCall = "";
        if (this.fridaDetection) {
            fridaDetectionCall = "        com.codename1.impl.android.FridaDetectionUtil.runFridaDetection(this);\n";
        }
        String waitingForPermissionsRequest = "        if (isWaitingForPermissionResult()) {\n            setWaitingForPermissionResult(false);\n            return;\n        }\n";
        try {
            stubSourceCode = "package " + request.getPackageName() + ";\n\nimport com.codename1.ui.*;\nimport android.os.Bundle;\nimport android.content.Intent;\nimport android.view.KeyEvent;\nimport com.codename1.system.*;\nimport com.codename1.impl.android.CodenameOneActivity;\nimport com.codename1.impl.android.AndroidImplementation;\nimport com.codename1.system.NativeLookup;\nimport com.codename1.push.*;\nimport com.codename1.ui.*;\nimport android.content.IntentFilter;\n" + additionalImports + "\n\npublic class " + request.getMainClass() + "Stub extends " + request.getArg("android.customActivity", "CodenameOneActivity") + "{\n";
            stubSourceCode = stubSourceCode + this.decodeFunction();
            stubSourceCode = stubSourceCode + "    public static final String BUILD_KEY = \"" + this.xorEncode(this.getBuildKey()) + "\";\n    public static final String PACKAGE_NAME = \"" + request.getPackageName() + "\";\n    public static final String BUILT_BY_USER = \"" + this.xorEncode(request.getUserName()) + "\";\n    public static final String LICENSE_KEY = \"" + this.xorEncode(licenseKey) + "\";\n    String [] consumable = new String[]{" + consumable + "};\n    private static " + request.getMainClass() + "Stub stubInstance;\n    private static " + request.getMainClass() + " i;\n    private boolean running;\n    private" + firstTimeStatic + " boolean firstTime = true;\n    private Form currentForm;\n    private static final Object LOCK = new Object();\n" + additionalMembers + headphonesVars + "    public static " + request.getMainClass() + " getAppInstance() {\n        return i;\n    }\n\n" + activityBillingSource + "    protected Object getApp() {\n        return i;\n    }\n\n    public static " + request.getMainClass() + "Stub getInstance() {\n        return stubInstance;\n    }\n\n    public " + request.getMainClass() + "Stub() {\n        stubInstance = this;\n    }\n\n    public static boolean isRunning() {\n        return stubInstance != null && stubInstance.running;\n    }\n\n    public void onCreate(Bundle savedInstanceState) {\n        super.onCreate(savedInstanceState);\n" + fridaDetectionCall + rootCheckCall + facebookHashCode + facebookSupport + streamMode + this.registerNativeImplementationsAndCreateStubs(new URLClassLoader(new URL[]{dummyClassesDir.toURI().toURL(), this.codenameOneJar.toURI().toURL()}), srcDir, dummyClassesDir) + oncreate + "\n" + this.createOnCreateCode(request) + "    }\n    protected void onResume() {\n        running = true;\n        super.onResume();\n" + waitingForPermissionsRequest + "        if(!Display.isInitialized()) {\n" + initStackSize + headphonesOnResume + googlePlayAdViewCode + reinitCode0 + storeIds + gcmSenderId + "        Display.getInstance().setProperty(\"build_key\", d(BUILD_KEY));\n        Display.getInstance().setProperty(\"package_name\", PACKAGE_NAME);\n        Display.getInstance().setProperty(\"built_by_user\", d(BUILT_BY_USER));\n" + useBackgroundPermissionSnippet + pushInitDisplayProperties + androidLicenseKey + "        " + this.createPostInitCode(request) + "        }else{\n" + reinitCode + "        }\n        if (i == null) {\n          i = new " + request.getMainClass() + "();\n          if(i instanceof PushCallback) {\n                com.codename1.impl.CodenameOneImplementation.setPushCallback((PushCallback)i);\n          }\n";
            stubSourceCode = stubSourceCode + "           if (i instanceof com.codename1.push.PushActionsProvider) {\n                try{AndroidImplementation.installNotificationActionCategories((com.codename1.push.PushActionsProvider)i);}catch(java.io.IOException ex){ex.printStackTrace();}\n           }\n";
        }
        catch (Exception ex) {
            throw new BuildException("Failed to generate stub source code", ex);
        }
        String fcmRegisterPushCode = "";
        if (useFCM) {
            fcmRegisterPushCode = this.newFirebaseMessaging ? "com.google.firebase.messaging.FirebaseMessaging.getInstance().getToken()\n                    .addOnCompleteListener(new com.google.android.gms.tasks.OnCompleteListener<String>() {\n                        @Override\n                        public void onComplete(com.google.android.gms.tasks.Task<String> task) {\n                            if (!task.isSuccessful()) {\n                                if (i instanceof PushCallback) {\n                                    ((PushCallback)i).pushRegistrationError(\"Failed to register push: \"+task.getException().getMessage(), 0);\n                                }\n                                return;\n                            }\n                            // Get the token\n                            String token = task.getResult();\n                            try {\n                                com.codename1.io.Preferences.set(\"push_key\", \"cn1-fcm-\"+token);\n                                if (i instanceof PushCallback) {\n                                    ((PushCallback)i).registeredForPush(\"cn1-fcm-\"+token);\n                                }\n\n                            } catch (Exception ex) {\n                                if (i instanceof PushCallback) {\n                                    ((PushCallback)i).pushRegistrationError(\"Failed to register push: \"+ex.getMessage(), 0);\n                                }\n                                System.out.println(\"Failed to get fcm token.\");\n                                ex.printStackTrace();\n                            }\n                        }\n                    });" : "try {\n\n                String token = com.google.firebase.iid.FirebaseInstanceId.getInstance().getToken();\n                if (token != null) {\n                    com.codename1.io.Preferences.set(\"push_key\", \"cn1-fcm-\"+token);\n                    if (i instanceof PushCallback) {\n                        ((PushCallback)i).registeredForPush(\"cn1-fcm-\"+token);\n                    }\n                } else {\n                    java.util.Timer timer = new java.util.Timer();\n                    timer.schedule(new java.util.TimerTask() {\n                        public void run() {\n                            runOnUiThread(new Runnable() {\n                                public void run() {\n                                    String token = com.google.firebase.iid.FirebaseInstanceId.getInstance().getToken();\n                                    if (token != null) {\n                                        com.codename1.io.Preferences.set(\"push_key\", \"cn1-fcm-\" + token);\n                                        if (i instanceof PushCallback) {\n                                            ((PushCallback) i).registeredForPush(\"cn1-fcm-\" + token);\n                                        }\n                                    }\n                                }\n                            });\n                        }\n                    }, 2000);\n                }\n            } catch (Exception ex) {\n                if (i instanceof PushCallback) {\n                    ((PushCallback)i).pushRegistrationError(\"Failed to register push: \"+ex.getMessage(), 0);\n                }\n                System.out.println(\"Failed to get fcm token.\");\n                ex.printStackTrace();\n            }";
        }
        try {
            stubSourceCode = stubSourceCode + "        }\n        if(i instanceof PushCallback) {\n            AndroidImplementation.firePendingPushes((PushCallback)i, this);\n        }\n" + localNotificationCode + "        Display.getInstance().callSerially(new Runnable(){\n            boolean wasStopped = (currentForm == null);\n            Form currForm = currentForm;\n            public void run() {\n                Form displayForm = Display.getInstance().getCurrent();\n                " + request.getMainClass() + "Stub.this.run(displayForm == null ? currForm : displayForm, wasStopped);\n            }\n        });\n        synchronized(LOCK) {\n            currentForm = null;\n        }\n    }\n\n    protected void onPause() {\n        super.onPause();\n        synchronized(LOCK) {\n            currentForm = Display.getInstance().getCurrent();\n        }\n        running = false;\n    }\n\n    public void run(Form currentForm, boolean wasStopped) {\n        if(firstTime) {\n            firstTime = false;\n            i.init(this);\n" + fcmRegisterPushCode + "         } else {\n             synchronized(LOCK) {\n                 if(!wasStopped) {\n                     if(currentForm instanceof Dialog) {\n                         ((Dialog)currentForm).showModeless();\n                     }else{\n                         currentForm.show();\n                     }\n                     fireIntentResult();\n                     setWaitingForResult(false);\n                     return;\n                 }\n             }\n         }\n" + this.createStartInvocation(request, "i") + "    }\n" + onStopCode + onDestroyCode + " public boolean onKeyDown(int keyCode, KeyEvent event){\n return super.onKeyDown(keyCode, event);\n }\n public String getBase64EncodedPublicKey() {\n     return d(LICENSE_KEY);\n }\n" + consumableCode + "}\n";
        }
        catch (Exception ex) {
            throw new BuildException("Failure while generating stub source code", ex);
        }
        File androidImplDir = new File(srcDir, "com" + File.separator + "codename1" + File.separator + "impl" + File.separator + "android");
        File stubUtilFile = new File(androidImplDir, "StubUtil.java");
        if (stubUtilFile.exists()) {
            try {
                this.replaceInFile(stubUtilFile, "//!", "");
                this.replaceInFile(stubUtilFile, "{{Stub}}", request.getPackageName() + "." + request.getMainClass() + "Stub");
            }
            catch (IOException ex) {
                throw new BuildException("Failed to update stub Util file", ex);
            }
        }
        boolean backgroundPushHandling = "true".equals(request.getArg("android.background_push_handling", "false"));
        if (!useFCM) {
            String handlePushImmediatelyCheck;
            File pushServiceFileSourceFile = new File(stubFileSourceDir, "PushNotificationService.java");
            String pushServiceOnCreate = "";
            if (this.buildToolsVersionInt >= 26 && Integer.parseInt(targetNumber) >= 26) {
                pushServiceOnCreate = "\n    @Override\n    public void onCreate() {\n        super.onCreate();\n        setProperty(\"android.NotificationChannel.id\", \"" + notificationChannelId + "\");\n        setProperty(\"android.NotificationChannel.name\", \"" + notificationChannelName + "\");\n        setProperty(\"android.NotificationChannel.description\", \"" + notificationChannelDescription + "\");\n        setProperty(\"android.NotificationChannel.importance\", \"" + notificationChannelImportance + "\");\n        setProperty(\"android.NotificationChannel.enableLights\", \"" + notificationChannelEnableLights + "\");\n        setProperty(\"android.NotificationChannel.lightColor\", \"" + notificationChannelLightColor + "\");\n        setProperty(\"android.NotificationChannel.enableVibration\", \"" + notificationChannelEnableVibration + "\");\n        setProperty(\"android.NotificationChannel.vibrationPattern\", " + notificationChannelVibrationPattern + ");\n    }\n\n";
            }
            String stubIsRunningCheck = handlePushImmediatelyCheck = request.getMainClass() + "Stub.isRunning()";
            if (backgroundPushHandling) {
                handlePushImmediatelyCheck = handlePushImmediatelyCheck + " || Display.isInitialized()";
            }
            String pushServiceSourceCode = "package " + request.getPackageName() + ";\n\nimport com.codename1.ui.*;\nimport com.codename1.push.PushCallback;\n\npublic class PushNotificationService extends com.codename1.impl.android.PushNotificationService {\n    public PushCallback getPushCallbackInstance() {\n         if(" + handlePushImmediatelyCheck + ") {\n             " + request.getMainClass() + "Stub stub = " + request.getMainClass() + "Stub.getInstance();\n             final " + request.getMainClass() + " main = stub.getAppInstance();\n             if(main instanceof PushCallback) {\n                 return (PushCallback)main;\n             }\n         }\n         return null;\n    }\n\n    public Class getStubClass() {\n        return " + request.getMainClass() + "Stub.class;\n    }\n" + pushServiceOnCreate + "}\n";
            File pushFileSourceFile = new File(stubFileSourceDir, "PushReceiver.java");
            String vibrateCode = "";
            if (request.getArg("android.pushVibratePattern", null) != null) {
                String pattern = request.getArg("android.pushVibratePattern", null);
                StringTokenizer token = new StringTokenizer(pattern = pattern.trim(), ",");
                if (token.countTokens() > 0) {
                    try {
                        while (token.hasMoreElements()) {
                            String t = token.nextToken();
                            t = t.trim();
                            Long.parseLong(t);
                        }
                        vibrateCode = "mNotifyBuilder.setVibrate(new long[]{" + pattern + "});";
                    }
                    catch (Exception t) {
                        // empty catch block
                    }
                }
            }
            String pushSound = "";
            if (request.getArg("android.pushSound", null) != null) {
                String soundPath = request.getArg("android.pushSound", null).toLowerCase();
                pushSound = "mNotifyBuilder.setSound(android.net.Uri.parse(\"android.resource://" + request.getPackageName() + "/raw/" + soundPath + "\"));";
            }
            String pushReceiverSourceCode = "package " + request.getPackageName() + ";\n\nimport com.codename1.ui.*;\n\nimport android.os.Bundle;\n\nimport com.codename1.system.*;\nimport com.codename1.impl.android.CodenameOneActivity;\n\nimport com.codename1.impl.android.AndroidImplementation;\n\nimport com.codename1.system.NativeLookup;\n\nimport com.codename1.io.ConnectionRequest;\n\nimport com.codename1.io.Preferences;\n\nimport com.codename1.io.NetworkManager;\n\nimport com.codename1.push.PushCallback;\n\nimport java.io.InputStream;\nimport java.io.DataInputStream;\nimport java.io.IOException;\nimport android.app.Notification;\nimport android.app.NotificationManager;\nimport android.app.PendingIntent;\nimport android.content.BroadcastReceiver;\nimport android.content.Context;\nimport android.content.Intent;\nimport android.telephony.TelephonyManager;\nimport android.content.SharedPreferences.Editor;\nimport android.app.NotificationManager\n;import android.app.Activity;\nimport com.codename1.impl.android.PushNotificationService;\nimport com.codename1.ui.*;\nimport android.graphics.Bitmap;\nimport android.graphics.drawable.BitmapDrawable;\nimport android.graphics.drawable.Drawable;\nimport " + this.xclass("android.support.v4.app.NotificationCompat") + ".Builder;\nimport " + this.xclass("android.support.v4.app.NotificationCompat") + ";\nimport android.media.RingtoneManager;\nimport android.net.Uri;\n\npublic class PushReceiver extends BroadcastReceiver {\n     public static final String C2DM_MESSAGE_TYPE_EXTRA = \"messageType\";\n     public static final String C2DM_MESSAGE_EXTRA = \"message\";\n     public static final String C2DM_MESSAGE_IMAGE = \"image\";\n     public static final String C2DM_MESSAGE_CATEGORY = \"category\";\n     public static final String BUILD_KEY = \"" + this.xorEncode(this.getBuildKey()) + "\"\n;     public static final String PACKAGE_NAME = \"" + request.getPackageName() + "\"\n;     public static final String BUILT_BY_USER = \"" + this.xorEncode(request.getUserName()) + "\"\n;\tprivate static String KEY = \"c2dmPref\";\n     private static String REGISTRATION_KEY = \"registrationKey\";     private Context context;\n\n";
            pushReceiverSourceCode = pushReceiverSourceCode + this.decodeFunction();
            boolean includePushContent = true;
            pushReceiverSourceCode = pushReceiverSourceCode + "     @Override\n     public void onReceive(Context context, Intent intent) {\n         this.context = context;\n         if (intent.getAction().equals(\"com.google.android.c2dm.intent.REGISTRATION\")) {\n             handleRegistration(context, intent);\n             return;\n         }\n         if (intent.getAction().equals(\"com.google.android.c2dm.intent.RECEIVE\")) {\n             handleMessage(context, intent);\n             return;\n         }\n         if (intent.getAction().equals(Intent.ACTION_BOOT_COMPLETED)) {\n             if(!com.codename1.impl.android.AndroidImplementation.hasAndroidMarket(context)) {\n                 PushNotificationService.startServiceIfRequired(" + request.getPackageName() + ".PushNotificationService.class, context);\n             }\n             return;\n         }\n     }\n\n     private void handleRegistration(Context context, Intent intent) {\n         final String registration = intent.getStringExtra(\"registration_id\");\n         System.out.println(\"Push handleRegistration() received: \" + registration);\n         " + request.getMainClass() + "Stub stub = " + request.getMainClass() + "Stub.getInstance();\n         if (intent.getStringExtra(\"error\") != null) {\n             final String error = intent.getStringExtra(\"error\");\n             System.out.println(\"Push handleRegistration() error: \" + error);\n             final " + request.getMainClass() + " main = stub.getAppInstance();\n             if(main instanceof PushCallback) {\n                 Display.getInstance().callSerially(new Runnable() {\n                     public void run() {\n                         ((PushCallback)main).pushRegistrationError(error, 0);\n                     }\n                 });\n             }\n         } else if (intent.getStringExtra(\"unregistered\") != null) {\n // do something??? \n             System.out.println(\"Push deregistered!\");\n         } else if (registration != null) {\n             System.out.println(\"Push handleRegistration() Sending registration to server!\");\n             Editor editor = context.getSharedPreferences(KEY, Context.MODE_PRIVATE).edit();\n             editor.putString(REGISTRATION_KEY, registration);\n             Preferences.set(\"push_key\", registration);\n             editor.commit();\n             com.codename1.impl.android.AndroidImplementation.registerPushOnServer(registration, d(BUILT_BY_USER) + '/' + PACKAGE_NAME, (byte)1, \"\", \"" + request.getPackageName() + "\");\n             final " + request.getMainClass() + " main = stub.getAppInstance();\n             if(main instanceof PushCallback) {\n                 Display.getInstance().callSerially(new Runnable() {\n                     public void run() {\n                         ((PushCallback)main).registeredForPush(registration);\n                     }\n                 });\n             }\n         }\n     }\n\n     private android.graphics.Bitmap getBitmapfromUrl(String imageUrl) {\n        try {\n            java.net.URL url = new java.net.URL(imageUrl);\n            java.net.HttpURLConnection connection = (java.net.HttpURLConnection) url.openConnection();\n            connection.setDoInput(true);\n            connection.connect();\n            InputStream input = connection.getInputStream();\n            Bitmap bitmap = android.graphics.BitmapFactory.decodeStream(input);\n            return bitmap;\n\n        } catch (Exception e) {\n            // TODO Auto-generated catch block\n            e.printStackTrace();\n            return null;\n\n        }\n    }\n\n     private void handleMessage(final Context context, Intent intent) {\n         final String messageType = intent.getExtras().getString(C2DM_MESSAGE_TYPE_EXTRA);\n         final String message = intent.getExtras().getString(C2DM_MESSAGE_EXTRA);\n         final String image = intent.getExtras().getString(C2DM_MESSAGE_IMAGE);\n         final String category = intent.getExtras().getString(C2DM_MESSAGE_CATEGORY);\n         System.out.println(\"Push message received: \" + message);\n         System.out.println(\"Push type: \" + messageType);\n         System.out.println(\"Is running: \" + " + request.getMainClass() + "Stub.isRunning());\n         if(" + handlePushImmediatelyCheck + ") {\n             " + request.getMainClass() + "Stub stub = " + request.getMainClass() + "Stub.getInstance();\n             final " + request.getMainClass() + " main = stub.getAppInstance();\n             if(main instanceof PushCallback) {\n                 Display.getInstance().setProperty(\"pushType\", messageType);\n";
            pushReceiverSourceCode = pushReceiverSourceCode + "                 Display.getInstance().callSerially(new Runnable() {\n                     public void run() {\n";
            if (includePushContent) {
                pushReceiverSourceCode = pushReceiverSourceCode + "                         com.codename1.impl.android.AndroidImplementation.initPushContent(message, image, messageType, category, context);\n";
            }
            pushReceiverSourceCode = pushReceiverSourceCode + "                         if(messageType != null && (Integer.parseInt(messageType) == 3 || Integer.parseInt(messageType) == 6) ) {\n                             String[] a = message.split(\";\");\n";
            pushReceiverSourceCode = pushReceiverSourceCode + "                             ((PushCallback)main).push(a[0]);\n                             ((PushCallback)main).push(a[1]);\n                             return;\n                         } else if (\"101\".equals(messageType)) {\n                            ((PushCallback) main).push(message.substring(message.indexOf(\" \")+1));\n                            return;\n                        }\n";
            pushReceiverSourceCode = pushReceiverSourceCode + "                         ((PushCallback)main).push(message);\n                     }\n                 });\n             }\n         }         if (!" + stubIsRunningCheck + ") {\n             ";
            pushReceiverSourceCode = pushReceiverSourceCode + "             com.codename1.impl.android.AndroidImplementation.appendNotification(messageType, message, image, category, context);\n";
            pushReceiverSourceCode = pushReceiverSourceCode + "             int badgeNumber = -1;\n             if (\"101\".equals(messageType)) {\n                 badgeNumber = Integer.parseInt(message.substring(0, message.indexOf(\" \")));\n\n             }if(messageType == null || messageType.length() == 0 || Integer.parseInt(messageType) < 2 || messageType.equals(\"3\") || messageType.equals(\"4\") || messageType.equals(\"5\") || messageType.equals(\"6\") || messageType.equals(\"101\")) {\n                 String actualMessage = message;\n             if (\"101\".equals(messageType)) {\n                     actualMessage = message.substring(message.indexOf(\" \")+1);\n                 }                 String title = \"" + request.getDisplayName() + "\";\n                 if(messageType != null && (Integer.parseInt(messageType) == 3 || Integer.parseInt(messageType) == 6)) {\n                     String[] a = message.split(\";\");\n                     actualMessage = a[0];\n                 }\n                if (messageType != null && Integer.parseInt(messageType) == 4) {\n                    String[] a = message.split(\";\");\n                    title = a[0];\n                    actualMessage = a[1];\n                }\n                 NotificationManager nm = (NotificationManager)context.getSystemService(Activity.NOTIFICATION_SERVICE);\n                 Intent newIntent = new Intent(context, " + request.getMainClass() + "Stub.class);\n                 PendingIntent contentIntent = PendingIntent.getActivity(context, 0, newIntent, PendingIntent.FLAG_CANCEL_CURRENT);\n                 Drawable myIcon = context.getResources().getDrawable(R.drawable.icon);\n                 Bitmap icon = ((BitmapDrawable) myIcon).getBitmap();\n                 int notifyID = 1;\n                 Builder mNotifyBuilder = new NotificationCompat.Builder(context)\n                         .setContentTitle(title)\n                         .setSmallIcon(R.drawable.ic_stat_notify)\n                         .setLargeIcon(icon)\n                         .setContentIntent(contentIntent)\n                         .setAutoCancel(true)\n                         .setWhen(System.currentTimeMillis())\n                         .setTicker(actualMessage);\n" + vibrateCode + "                 if (messageType == null || (Integer.parseInt(messageType) != 5 && Integer.parseInt(messageType) != 6)) {\n                     Uri alarmSound = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);\n                     mNotifyBuilder.setSound(alarmSound);\n" + pushSound + "                 }\n                 if(android.os.Build.VERSION.SDK_INT >= 21){\n                     mNotifyBuilder.setCategory(\"Notification\");\n                 }\n";
            if (this.buildToolsVersionInt >= 26 && Integer.parseInt(targetNumber) >= 26) {
                pushReceiverSourceCode = pushReceiverSourceCode + "                com.codename1.impl.android.AndroidImplementation.setNotificationChannel(nm, mNotifyBuilder, context);\n";
            }
            pushReceiverSourceCode = pushReceiverSourceCode + "                 String[] messages = com.codename1.impl.android.AndroidImplementation.getPendingPush(messageType, context);\n                 int numMessages = messages.length;\n                 if (numMessages == 1) {\n                     mNotifyBuilder.setContentText(messages[0]);\n                 } else {\n                         NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();\n                         for (int i = 0; i < messages.length; i++) {\n                             inboxStyle.addLine(messages[i]);\n                         }\n                         mNotifyBuilder.setStyle(inboxStyle);\n                 }\n     if(android.os.Build.VERSION.SDK_INT >= 22) {\n         if (badgeNumber >= 0) {\n             mNotifyBuilder.setNumber(badgeNumber);\n         } else {\n                 mNotifyBuilder.setNumber(numMessages);\n         }\n     }\n";
            pushReceiverSourceCode = pushReceiverSourceCode + "                 if (category != null && numMessages == 1) {\n                     try {\n                         AndroidImplementation.addActionsToNotification(null, category, mNotifyBuilder, newIntent, context);\n                     } catch (java.io.IOException ex) {\n                         ex.printStackTrace();\n                     }\n                 }                 if (image != null && numMessages == 1) {\n                     final Builder fNotifyBuilder = mNotifyBuilder;\n                     final int fNotifyID = notifyID;\n                     final NotificationManager fnm = nm;\n                     android.os.AsyncTask.execute(new Runnable() {\n                         public void run() {\n                             fNotifyBuilder.setStyle(new NotificationCompat.BigPictureStyle()\n                                     .bigPicture(getBitmapfromUrl(image)));/*Notification with Image*/\n                             fnm.notify(fNotifyID, fNotifyBuilder.build());\n                         }\n                     });\n\n               } else {\n                     nm.notify(notifyID, mNotifyBuilder.build());\n               }\n";
            pushReceiverSourceCode = pushReceiverSourceCode + "             }\n         }\n    }\n}\n";
            if (this.pushPermission) {
                try {
                    FileOutputStream pushSourceStream = new FileOutputStream(pushFileSourceFile);
                    ((OutputStream)pushSourceStream).write(pushReceiverSourceCode.getBytes());
                    ((OutputStream)pushSourceStream).close();
                    FileOutputStream pushServiceSourceStream = new FileOutputStream(pushServiceFileSourceFile);
                    ((OutputStream)pushServiceSourceStream).write(pushServiceSourceCode.getBytes());
                    ((OutputStream)pushServiceSourceStream).close();
                }
                catch (IOException ex) {
                    throw new BuildException("Failed to generate push file", ex);
                }
            }
        } else {
            InputStream is = null;
            OutputStream os = null;
            this.debug("Generating FirebaseMessagingService...");
            File fcmMessagingServiceFile = new File(androidImplDir, "CN1FirebaseMessagingService.java");
            try {
                String fireBaseMessagingServiceSourcePath = "CN1FirebaseMessagingService.javas";
                fireBaseMessagingServiceSourcePath = "CN1FirebaseMessagingService7.javas";
                is = this.getClass().getResourceAsStream(fireBaseMessagingServiceSourcePath);
                os = new FileOutputStream(fcmMessagingServiceFile);
                AndroidGradleBuilder.copy(is, os);
            }
            catch (IOException ex) {
                this.error("Failed to generate FirebaseMessagingService", ex);
                throw new BuildException("Failed to generate FirebaseMessagingService", ex);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            try {
                this.replaceInFile(fcmMessagingServiceFile, "{{DISPLAY_NAME}}", request.getDisplayName());
                if (backgroundPushHandling) {
                    this.replaceInFile(fcmMessagingServiceFile, "allowBackgroundPush = false;", "allowBackgroundPush = true;");
                }
            }
            catch (IOException ex) {
                throw new BuildException("Failed to update FCM messaging service with app details", ex);
            }
        }
        try {
            FileOutputStream stubSourceStream = new FileOutputStream(stubFileSourceFile);
            ((OutputStream)stubSourceStream).write(stubSourceCode.getBytes());
            ((OutputStream)stubSourceStream).close();
        }
        catch (IOException ex) {
            throw new BuildException("Failed to write stub source file", ex);
        }
        try {
            File projectPropertiesFile = new File(projectDir, "project.properties");
            Properties projectPropertiesObject = new Properties();
            if (projectPropertiesFile.exists()) {
                FileInputStream fi = new FileInputStream(projectPropertiesFile);
                projectPropertiesObject.load(fi);
                fi.close();
            }
            projectPropertiesObject.setProperty("proguard.config", "proguard.cfg");
            if (request.getArg("android.enableProguard", "true").equals("false")) {
                projectPropertiesObject.remove("proguard.config");
            }
            projectPropertiesObject.setProperty("dex.force.jumbo", "true");
            FileOutputStream projectPropertiesOutputStream = new FileOutputStream(projectPropertiesFile);
            projectPropertiesObject.store(projectPropertiesOutputStream, "Project properties for android build generated by Codename One");
            projectPropertiesOutputStream.close();
        }
        catch (IOException ex) {
            throw new BuildException("Failed to write project properties", ex);
        }
        String dontObfuscate = "";
        if (request.getArg("android.enableProguard", "true").equals("false")) {
            dontObfuscate = "-dontobfuscate\n";
        }
        String keepOverride = request.getArg("android.proguardKeepOverride", "Exceptions, InnerClasses, Signature, Deprecated, SourceFile, LineNumberTable, *Annotation*, EnclosingMethod");
        String keepFirebase = "-keep class com.google.android.gms.** { *; }\n\n-keep class com.google.firebase.** { *; }\n\n";
        String proguardConfigOverride = "-dontusemixedcaseclassnames\n-dontskipnonpubliclibraryclasses\n-dontpreverify\n-verbose\n-dontoptimize\n" + dontObfuscate + "\n-dontwarn com.google.android.gms.**\n" + keepFirebase + "-keep class com.codename1.impl.android.AndroidBrowserComponentCallback {\n*;\n}\n\n-keep class com.codename1.impl.android.AndroidNativeUtil {\n*;\n}\n\n-keepclassmembers class **.R$* {\n public static <fields>;\n}\n\n-keep class **.R$*\n-keep public class * extends android.app.Activity\n-keep public class * extends android.app.Application\n-keep public class * extends android.app.Service\n-keep public class * extends android.content.BroadcastReceiver\n-keep public class * extends android.content.ContentProvider\n-keep public class * extends android.app.backup.BackupAgentHelper\n-keep public class * extends android.preference.Preference\n-keep public class com.android.vending.licensing.ILicensingService\n\n-keep public class " + this.xclass("android.support.v4.app.RemoteInput") + " {*;}\n-keep public class " + this.xclass("android.support.v4.app.RemoteInput") + "$Builder {*;}\n-keep public class " + this.xclass("android.support.v4.app.NotificationCompat") + "$Builder {*;}\n-keep public class " + this.xclass("android.support.v4.app.NotificationCompat") + "$Action {*;}\n-keep public class " + this.xclass("android.support.v4.app.NotificationCompat") + "$Action$Builder {*;}\n-keepclasseswithmembernames class * {\n    native <methods>;\n}\n\n-keepclasseswithmembers class * {\n    public <init>(android.content.Context, android.util.AttributeSet);\n}\n\n-keepclasseswithmembers class * {\n    public <init>(android.content.Context, android.util.AttributeSet, int);\n}\n\n-keepclassmembers class * extends android.app.Activity {\n    public void *(android.view.View);\n}\n\n-keepclassmembers enum * {\n    public static **[] values();\n    public static ** valueOf(java.lang.String);\n}\n\n-keep class * implements android.os.Parcelable {\n    public static final android.os.Parcelable$Creator *;\n}\n-keep class com.apperhand.common.** {\n*;\n}\n\n-keep class com.apperhand.device.android.EULAActivity$EulaJsInterface {\n*;\n}\n\n-keepclassmembers public class " + this.xclass("android.support.v4.app.NotificationCompat") + "$Builder {\n    public " + this.xclass("android.support.v4.app.NotificationCompat") + "$Builder setChannelId(java.lang.String);\n}\n\n-keep class **Stub { *; }\n\n" + facebookProguard + " " + request.getArg("android.proguardKeep", "") + "\n" + googlePlayObfuscation + "-keep class com.google.mygson.**{\n*;\n}\n\n-dontwarn android.support.**\n-dontwarn androidx.**\n-dontwarn com.google.ads.**\n-keepattributes " + keepOverride;
        String gradleObfuscate = "";
        File proguardConfigOverrideFile = new File(projectDir, "proguard.cfg");
        proguardConfigOverrideFile.delete();
        if (request.getArg("android.enableProguard", "true").equals("true")) {
            try {
                this.createFile(proguardConfigOverrideFile, proguardConfigOverride.getBytes());
            }
            catch (IOException ex) {
                throw new BuildException("Failed to create proguard config file", ex);
            }
            gradleObfuscate = "            minifyEnabled true\n" + (request.getArg("android.shrinkResources", "false").equals("true") ? "            shrinkResources true\n" : "") + "            proguardFiles getDefaultProguardFile('proguard-android.txt'), 'proguard.cfg'\n";
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("ANDROID_HOME", androidSDKDir.getAbsolutePath());
        env.put("SLAVE_AAPT_TIMEOUT", "20");
        env.put("JAVA_HOME", this.getGradleJavaHome());
        request.putArgument("var.android.playServicesVersion", this.playServicesVersion);
        String additionalDependencies = request.getArg("gradleDependencies", "");
        if (facebookSupported) {
            minSDK = AndroidGradleBuilder.maxInt("15", minSDK);
            additionalDependencies = request.getArg("android.excludeBolts", "false").equals("true") ? additionalDependencies + " " + compile + " ('com.facebook.android:facebook-android-sdk:" + this.facebookSdkVersion + "'){ exclude module: 'bolts-android' }\n" : additionalDependencies + " " + compile + " 'com.facebook.android:facebook-android-sdk:" + this.facebookSdkVersion + "'\n";
        }
        if (legacyGplayServicesMode) {
            additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services:6.5.87'\n";
        } else {
            if (this.playServicesPlus) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-plus:" + this.getDefaultPlayServiceVersion("plus") + "'\n";
            }
            if (this.playServicesAuth) {
                String playServiceAuthVersion = this.newFirebaseMessaging ? "20.6.0" : this.getDefaultPlayServiceVersion("auth");
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-auth:" + playServiceAuthVersion + "'\n";
            }
            if (this.playServicesBase) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-base:" + this.getDefaultPlayServiceVersion("base") + "'\n";
            }
            if (this.playServicesIdentity) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-identity:" + this.getDefaultPlayServiceVersion("identity") + "'\n";
            }
            if (this.playServicesIndexing) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-appindexing:" + this.getDefaultPlayServiceVersion("appindexing") + "'\n";
            }
            if (this.playServicesInvite) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-appinvite:" + this.getDefaultPlayServiceVersion("appinvite") + "'\n";
            }
            if (this.playServicesAnalytics) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-analytics:" + this.getDefaultPlayServiceVersion("analytics") + "'\n";
            }
            if (this.playServicesCast) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-cast:" + this.getDefaultPlayServiceVersion("cast") + "'\n";
            }
            if (this.playServicesGcm) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-gcm:" + this.getDefaultPlayServiceVersion("gcm") + "'\n";
            }
            if (this.playServicesDrive) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-drive:" + this.getDefaultPlayServiceVersion("drive") + "'\n";
            }
            if (this.playServicesFit) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-fitness:" + this.getDefaultPlayServiceVersion("fit") + "'\n";
            }
            if (this.playServicesLocation) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-location:" + this.getDefaultPlayServiceVersion("location") + "'\n";
            }
            if (this.playServicesMaps) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-maps:" + this.getDefaultPlayServiceVersion("maps") + "'\n";
            }
            if (this.playServicesAds) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-ads:" + this.getDefaultPlayServiceVersion("ads") + "'\n";
            }
            if (this.playServicesVision) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-vision:" + this.getDefaultPlayServiceVersion("vision") + "'\n";
            }
            if (this.playServicesNearBy) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-nearby:" + this.getDefaultPlayServiceVersion("nearby") + "'\n";
            }
            if (this.playServicesSafetyPanorama) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-panaroma:" + this.getDefaultPlayServiceVersion("panorama") + "'\n";
            }
            if (this.playServicesGames) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-games:" + this.getDefaultPlayServiceVersion("games") + "'\n";
            }
            if (this.playServicesSafetyNet) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-safenet:" + this.getDefaultPlayServiceVersion("safenet") + "'\n";
            }
            if (this.playServicesWallet) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-wallet:" + this.getDefaultPlayServiceVersion("wallet") + "'\n";
            }
            if (this.playServicesWear) {
                additionalDependencies = additionalDependencies + " " + compile + " 'com.google.android.gms:play-services-wearable:" + this.getDefaultPlayServiceVersion("wearable") + "'\n";
            }
        }
        if (this.purchasePermissions) {
            String billingClientVersion = request.getArg("android.billingclient.version", "4.0.0");
            additionalDependencies = additionalDependencies + " implementation 'com.android.billingclient:billing:" + billingClientVersion + "'\n";
        }
        String useLegacyApache = "";
        if (request.getArg("android.apacheLegacy", "false").equals("true")) {
            useLegacyApache = " useLibrary 'org.apache.http.legacy'\n";
        }
        String multidex = "";
        if (request.getArg("android.multidex", "true").equals("true")) {
            String multidexVersion;
            multidex = "        multiDexEnabled true\n";
            String string3 = multidexVersion = this.newFirebaseMessaging || this.useGradle8 ? "2.0.1" : "1.0.3";
            if (Integer.parseInt(minSDK) < 21) {
                if (this.useAndroidX) {
                    if (!additionalDependencies.contains("androidx.multidex:multidex") && !request.getArg("android.gradleDep", "").contains("androidx.multidex:multidex")) {
                        additionalDependencies = additionalDependencies + " implementation 'androidx.multidex:multidex:" + multidexVersion + "'\n";
                    }
                } else if (!additionalDependencies.contains("com.android.support:multidex") && !request.getArg("android.gradleDep", "").contains("com.android.support:multidex")) {
                    additionalDependencies = additionalDependencies + " implementation 'com.android.support:multidex:" + multidexVersion + "'\n";
                }
            }
        }
        String gradleDependency = "classpath 'com.android.tools.build:gradle:1.3.1'\n";
        gradleDependency = gradleVersionInt < 3 ? "classpath 'com.android.tools.build:gradle:2.1.2'\n" : (gradleVersionInt < 6 ? (this.useAndroidX ? "classpath 'com.android.tools.build:gradle:3.2.0'\n" : "classpath 'com.android.tools.build:gradle:3.0.1'\n") : (gradleVersionInt < 8 ? "classpath 'com.android.tools.build:gradle:4.1.1'\n" : "classpath 'com.android.tools.build:gradle:8.1.0'\n"));
        gradleDependency = gradleDependency + request.getArg("android.topDependency", "");
        String compileSdkVersion = "'android-21'";
        String java8P2 = "";
        if (this.useJava8SourceLevel) {
            java8P2 = "    compileOptions {\n        sourceCompatibility JavaVersion.VERSION_1_8\n        targetCompatibility JavaVersion.VERSION_1_8\n    }\n";
        }
        String mavenCentral = "";
        if (request.getArg("android.includeMavenCentral", "false").equals("true")) {
            mavenCentral = "    mavenCentral()\n";
        }
        String jcenter = "        jcenter()\n";
        String injectRepo = request.getArg("android.repositories", "");
        if (injectRepo.length() > 0) {
            String[] repos = injectRepo.split(";");
            injectRepo = "";
            for (String s : repos) {
                injectRepo = injectRepo + "    " + s + "\n";
            }
        }
        Properties gradlePropertiesObject = new Properties();
        File gradlePropertiesFile = new File(projectDir.getParentFile(), "gradle.properties");
        if (gradlePropertiesFile.exists()) {
            try {
                FileInputStream fi = new FileInputStream(gradlePropertiesFile);
                gradlePropertiesObject.load(fi);
                fi.close();
            }
            catch (IOException ex) {
                throw new BuildException("Failed to load gradle properties from properties file " + gradlePropertiesFile, ex);
            }
        }
        Properties gradleWrapperPropertiesObject = new Properties();
        File gradleWrapperPropertiesFile = new File(projectDir.getParentFile(), "gradle/wrapper/gradle-wrapper.properties");
        if (gradleWrapperPropertiesFile.exists()) {
            try {
                FileInputStream fi = new FileInputStream(gradleWrapperPropertiesFile);
                gradleWrapperPropertiesObject.load(fi);
                fi.close();
            }
            catch (IOException ex) {
                throw new BuildException("Failed to load gradle properties from properties file " + gradleWrapperPropertiesFile, ex);
            }
        }
        compileSdkVersion = maxPlatformVersion;
        String supportLibVersion = maxPlatformVersion;
        if (this.buildToolsVersion.startsWith("28")) {
            compileSdkVersion = "28";
            supportLibVersion = "28";
        }
        if (this.buildToolsVersion.startsWith("29")) {
            compileSdkVersion = "29";
            supportLibVersion = "28";
        }
        if (this.buildToolsVersion.startsWith("30")) {
            compileSdkVersion = "30";
            supportLibVersion = "28";
        }
        if (this.buildToolsVersion.startsWith("31")) {
            compileSdkVersion = "31";
            supportLibVersion = "28";
        }
        if (this.buildToolsVersion.startsWith("32")) {
            compileSdkVersion = "32";
            supportLibVersion = "28";
        }
        if (this.buildToolsVersion.startsWith("33")) {
            compileSdkVersion = "33";
            supportLibVersion = "28";
        }
        if (this.buildToolsVersion.startsWith("34")) {
            compileSdkVersion = "34";
            supportLibVersion = "28";
        }
        jcenter = "      google()\n     jcenter()\n     mavenLocal()\n      mavenCentral()\n";
        injectRepo = injectRepo + "      google()\n     mavenLocal()\n      mavenCentral()\n";
        if (!androidAppBundle && gradleVersionInt < 6 && this.buildToolsVersionInt < 30) {
            gradlePropertiesObject.put("android.enableAapt2", "false");
        }
        if (!this.useAndroidX) {
            supportV4Default = "    " + compile + " 'com.android.support:support-v4:" + supportLibVersion + ".+'\n     implementation 'com.android.support:appcompat-v7:" + supportLibVersion + ".+'\n";
        } else {
            String appCompatVersionDefault = "1.0.0";
            if (this.useGradle8) {
                appCompatVersionDefault = "1.6.1";
            }
            supportV4Default = "    implementation 'androidx.legacy:legacy-support-v4:1.0.0'\n     implementation 'androidx.appcompat:appcompat:" + request.getArg("androidx.appcompat.version", appCompatVersionDefault) + "'\n";
        }
        String buildFeatures = "";
        if (this.useGradle8) {
            buildFeatures = "buildFeatures {\n        aidl true\n    }\n";
        }
        String namespace = "";
        if (this.useGradle8) {
            namespace = "namespace '" + request.getPackageName() + "'\n";
        }
        String gradleProps = "apply plugin: 'com.android.application'\n" + request.getArg("android.gradlePlugin", "") + "\nbuildscript {\n    repositories {\n" + jcenter + injectRepo + "    }\n    dependencies {\n" + gradleDependency + "    }\n}\n\nandroid {\n" + request.getArg("android.gradle.androidx", "") + "\n    compileSdkVersion " + compileSdkVersion + "\n" + useLegacyApache + "\n    dexOptions {\n        preDexLibraries = false\n        incremental false\n        jumboMode = true\n        javaMaxHeapSize \"3g\"\n    }\n    defaultConfig {\n        applicationId \"" + request.getPackageName() + "\"\n        minSdkVersion " + minSDK + "\n        targetSdkVersion " + targetNumber + "\n        versionCode " + intVersion + "\n        versionName \"" + version + "\"\n" + multidex + request.getArg("android.xgradle_default_config", "") + "    }\n" + java8P2 + "    sourceSets {\n        main {\n            aidl.srcDirs = ['src/main/java']\n        }\n    }\n\n    lintOptions {\n        lintOptions {\n        checkReleaseBuilds false\n        abortOnError false\n        }\n    }\n    signingConfigs {\n        release {\n            storeFile file(\"keyStore\")\n            storePassword \"" + AndroidGradleBuilder.escape(request.getCertificatePassword(), "$\"") + "\"\n            keyAlias \"" + AndroidGradleBuilder.escape(request.getKeystoreAlias(), "$\"") + "\"\n            keyPassword \"" + AndroidGradleBuilder.escape(request.getCertificatePassword(), "$\"") + "\"\n        }\n    }\n    buildTypes {\n        release {\n" + gradleObfuscate + "            signingConfig signingConfigs.release\n        }\n" + (request.getCertificate() != null ? "        debug {\n            signingConfig signingConfigs.release\n        }\n" : "") + "    }\n" + buildFeatures + namespace + "}\n\nrepositories {\n    google()\n    jcenter()\n" + injectRepo + "    flatDir{\n              dirs 'libs'\n       }\n" + mavenCentral + "}\n\ndependencies {\n    " + compile + " fileTree(dir: 'libs', include: ['*.jar'])\n" + request.getArg("android.supportv4Dep", supportV4Default) + "\n" + this.addNewlineIfMissing(additionalDependencies) + this.addNewlineIfMissing(request.getArg("android.gradleDep", "")) + this.addNewlineIfMissing(aarDependencies) + "}\n" + request.getArg("android.xgradle", "");
        this.debug("Gradle File start\n-------\n");
        this.debug(gradleProps);
        this.debug("-------\nGradle File end \n");
        File gradleFile = new File(projectDir, "build.gradle");
        try {
            FileOutputStream gradleStream = new FileOutputStream(gradleFile);
            ((OutputStream)gradleStream).write(gradleProps.getBytes());
            ((OutputStream)gradleStream).close();
        }
        catch (IOException ex) {
            throw new BuildException("Failed to write gradle properties to " + gradleFile, ex);
        }
        String rootGradleProps = "// Top-level build file where you can add configuration options common to all sub-projects/modules.\nbuildscript {\n    repositories {\n        google()\n        jcenter()\n    }\n    dependencies {\n        " + gradleDependency + "\n        // NOTE: Do not place your application dependencies here; they belong\n        // in the individual module build.gradle files\n    }\n}\n\nallprojects {\n    repositories {\n        google()\n        jcenter()\n    }\n}\n\ntask clean(type: Delete) {\n    delete rootProject.buildDir\n}";
        File rootGradleFile = new File(studioProjectDir, "build.gradle");
        try {
            FileOutputStream gradleStream = new FileOutputStream(rootGradleFile);
            ((OutputStream)gradleStream).write(rootGradleProps.getBytes());
            ((OutputStream)gradleStream).close();
        }
        catch (IOException ex) {
            throw new BuildException("Failed to write root gradle properties to " + rootGradleFile, ex);
        }
        File settingsGradle = new File(studioProjectDir, "settings.gradle");
        try {
            this.replaceInFile(settingsGradle, "My Application2", request.getDisplayName());
        }
        catch (Exception ex) {
            throw new BuildException("Failed to update settingsGradle with display name", ex);
        }
        gradlePropertiesObject.setProperty("org.gradle.daemon", "true");
        if (this.useGradle8 || request.getArg("android.forceJava8Builder", "false").equals("true")) {
            gradlePropertiesObject.setProperty("org.gradle.java.home", this.getGradleJavaHome());
        }
        if (this.useGradle8) {
            gradlePropertiesObject.setProperty("org.gradle.jvmargs", "-Xmx2048m -XX:+HeapDumpOnOutOfMemoryError -Dfile.encoding=UTF-8");
            gradleWrapperPropertiesObject.setProperty("distributionUrl", this.gradle8DistributionUrl);
        } else {
            gradlePropertiesObject.setProperty("org.gradle.jvmargs", "-Xmx2048m -XX:MaxPermSize=512m -XX:+HeapDumpOnOutOfMemoryError -Dfile.encoding=UTF-8");
            gradleWrapperPropertiesObject.setProperty("distributionUrl", this.gradleDistributionUrl);
        }
        if (this.useAndroidX) {
            gradlePropertiesObject.setProperty("android.useAndroidX", "true");
            gradlePropertiesObject.setProperty("android.enableJetifier", "true");
        }
        if (this.disableR8) {
            gradlePropertiesObject.setProperty("android.enableR8", "false");
            gradlePropertiesObject.setProperty("android.enableR8.libraries", "false");
        } else if (this.disableR8FullMode) {
            gradlePropertiesObject.setProperty("android.enableR8.fullMode", "false");
        }
        try {
            FileOutputStream antPropertiesOutputStream = new FileOutputStream(gradlePropertiesFile);
            gradlePropertiesObject.store(antPropertiesOutputStream, "Gradle properties for android build generated by Codename One");
            antPropertiesOutputStream.close();
        }
        catch (IOException ex) {
            throw new BuildException("Failed to output gradle properties file " + gradlePropertiesFile);
        }
        try {
            FileOutputStream fos = new FileOutputStream(gradleWrapperPropertiesFile);
            gradleWrapperPropertiesObject.store(fos, "Gradle Wrapper properties for android build generated by Codename One");
            fos.close();
        }
        catch (IOException ex) {
            throw new BuildException("Failed to output gradle-wrapper properties file " + gradlePropertiesFile);
        }
        try {
            this.migrateSourcesToAndroidX(projectDir);
        }
        catch (Exception ex) {
            throw new BuildException("Failed to migrate sources to AndroidX", ex);
        }
        if (request.getCertificate() != null) {
            try {
                this.createFile(new File(projectDir, "keyStore"), request.getCertificate());
            }
            catch (IOException ex) {
                throw new BuildException("Failed to create keyStore file", ex);
            }
        }
        return true;
    }

    static String xmlize(String s) {
        s = s.replace("&", "&amp;");
        s = s.replace("<", "&lt;");
        s = s.replace(">", "&gt;");
        int charCount = s.length();
        for (int iter = 0; iter < charCount; ++iter) {
            char c = s.charAt(iter);
            if (c <= '\u007f') continue;
            StringBuilder b = new StringBuilder();
            for (int counter = 0; counter < charCount; ++counter) {
                c = s.charAt(counter);
                if (c > '\u007f') {
                    b.append("&#x");
                    b.append(Integer.toHexString(c));
                    b.append(";");
                    continue;
                }
                b.append(c);
            }
            return b.toString();
        }
        return s;
    }

    @Override
    protected String generatePeerComponentCreationCode(String methodCallString) {
        return "PeerComponent.create(" + methodCallString + ")";
    }

    @Override
    protected String convertPeerComponentToNative(String param) {
        return "(android.view.View)" + param + ".getNativePeer()";
    }

    private String createOnDestroyCode(BuildRequest request) {
        String retVal = "";
        if (this.integrateMoPub) {
            retVal = retVal + "moPubView.destroy();\n";
        }
        if (this.playServicesLocation) {
            retVal = retVal + "    com.codename1.impl.android.AndroidNativeUtil.removeLifecycleListener(com.codename1.location.AndroidLocationPlayServiceManager.getInstance());\n";
        }
        if (this.shouldIncludeGoogleImpl) {
            retVal = retVal + "    com.codename1.impl.android.AndroidNativeUtil.removeLifecycleListener((com.codename1.impl.android.LifecycleListener) com.codename1.social.GoogleConnect.getInstance());\n";
        }
        return retVal;
    }

    private String createPostInitCode(BuildRequest request) {
        String retVal = "";
        return retVal;
    }

    private String createOnCreateCode(BuildRequest request) {
        String retVal = "";
        if (request.getArg("android.includeGPlayServices", "true").equals("true") || this.playServicesLocation) {
            retVal = retVal + "Display.getInstance().setProperty(\"IncludeGPlayServices\", \"true\");\n";
        }
        if (this.playServicesLocation) {
            retVal = retVal + "com.codename1.impl.android.AndroidNativeUtil.addLifecycleListener(com.codename1.location.AndroidLocationPlayServiceManager.getInstance());\n";
        }
        if (this.shouldIncludeGoogleImpl) {
            retVal = retVal + "com.codename1.social.GoogleImpl.init();\n";
            retVal = retVal + "com.codename1.impl.android.AndroidNativeUtil.addLifecycleListener((com.codename1.impl.android.LifecycleListener) com.codename1.social.GoogleConnect.getInstance());\n";
        }
        if (request.getArg("android.web_loading_hidden", "false").equalsIgnoreCase("true")) {
            retVal = retVal + "Display.getInstance().setProperty(\"WebLoadingHidden\", \"true\");\n";
        }
        if (request.getArg("android.statusbar_hidden", "false").equalsIgnoreCase("true")) {
            retVal = retVal + "Display.getInstance().setProperty(\"StatusbarHidden\", \"true\");\n";
        }
        if (request.getArg("KeepScreenOn", "false").equalsIgnoreCase("true")) {
            retVal = retVal + "Display.getInstance().setProperty(\"KeepScreenOn\", \"true\");\n";
        }
        if (request.getArg("android.disableScreenshots", "false").equalsIgnoreCase("true")) {
            retVal = retVal + "Display.getInstance().setProperty(\"DisableScreenshots\", \"true\");\n";
        }
        return retVal;
    }

    @Override
    protected String createStartInvocation(BuildRequest request, String mainObject) {
        String retVal = super.createStartInvocation(request, mainObject);
        if (this.integrateMoPub) {
            retVal = retVal + "moPubView = (MoPubView) findViewById(R.id.adview);\nmoPubView.setAdUnitId(\"" + request.getArg("android.mopubId", null) + "\");\nmoPubView.loadAd();\n";
        }
        return retVal;
    }

    public void extract(InputStream source, File dir, String sdkPath) throws IOException {
        try {
            ZipEntry entry;
            BufferedOutputStream dest = null;
            ZipInputStream zis = new ZipInputStream(source);
            boolean addedSDKDir = false;
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                FileOutputStream fos;
                File destFile;
                this.debug("Extracting: " + entry);
                if (entry.isDirectory()) {
                    File d = new File(dir, entry.getName());
                    d.mkdirs();
                    if (addedSDKDir || sdkPath == null) continue;
                    if (is_windows) {
                        sdkPath = sdkPath.replace("" + File.separatorChar, "\\\\");
                    }
                    String sdkPathProperties = "sdk.dir=" + sdkPath;
                    destFile = new File(d, "local.properties");
                    destFile.getParentFile().mkdirs();
                    fos = new FileOutputStream(destFile);
                    fos.write(sdkPathProperties.getBytes());
                    fos.close();
                    addedSDKDir = true;
                    continue;
                }
                if (entry.getName().contains("local.properties") && sdkPath != null) {
                    if (is_windows) {
                        sdkPath = sdkPath.replace("" + File.separatorChar, "\\\\");
                    }
                    String sdkPathProperties = "sdk.dir=" + sdkPath + "\n";
                    File destFile2 = new File(dir, entry.getName());
                    destFile2.getParentFile().mkdirs();
                    FileOutputStream fos2 = new FileOutputStream(destFile2);
                    fos2.write(sdkPathProperties.getBytes());
                    fos2.close();
                    continue;
                }
                byte[] data = new byte[8192];
                destFile = new File(dir, entry.getName());
                destFile.getParentFile().mkdirs();
                fos = new FileOutputStream(destFile);
                dest = new BufferedOutputStream(fos, data.length);
                while ((count = zis.read(data, 0, data.length)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
            source.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractAAR(InputStream source, File dir, String sdkPath) throws IOException {
        File libs = new File(dir, "libs");
        libs.mkdirs();
        File srcLib = new File(dir, "src");
        srcLib.mkdirs();
        this.extract(source, dir, null);
        File classes1 = null;
        AbstractInterruptibleChannel src = null;
        AbstractInterruptibleChannel dest = null;
        try {
            classes1 = new File(dir, "classes.jar");
            File classes2 = new File(libs, "classes.jar");
            classes2.createNewFile();
            AndroidGradleBuilder.copyFile(classes1, classes2);
            File jni = new File(dir, "jni");
            if (jni.exists()) {
                AndroidGradleBuilder.copyDirectory(jni, libs);
                this.delete(jni);
            }
            FileOutputStream projectProps = new FileOutputStream(new File(dir, "project.properties"));
            String props = "android.library=true\ntarget=android-14";
            projectProps.write(props.getBytes());
            projectProps.close();
        }
        catch (Exception exception) {
        }
        finally {
            if (src != null) {
                src.close();
            }
            if (dest != null) {
                dest.close();
            }
            if (classes1 != null) {
                classes1.delete();
            }
        }
    }

    @Override
    protected File placeXMLFile(ZipEntry entry, File xmlDir, File resDir) {
        String name = entry.getName();
        if (name.endsWith("colors.xml")) {
            File parent = resDir.getParentFile();
            resDir = new File(parent, "res");
            File valsDir = new File(resDir, "values");
            return new File(valsDir, entry.getName());
        }
        if (name.endsWith("layout.xml")) {
            File parent = resDir.getParentFile();
            resDir = new File(parent, "res");
            File layDir = new File(resDir, "layout");
            return new File(layDir, entry.getName());
        }
        return super.placeXMLFile(entry, xmlDir, resDir);
    }

    public Image makeColorTransparent(BufferedImage im, final Color color) {
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() & 0xFFFFFF;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                int tmp = rgb & 0xFFFFFF;
                if (tmp == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    @Override
    protected boolean useXMLDir() {
        return true;
    }

    public static final void copy(File source, File destination) throws IOException {
        if (source.isDirectory()) {
            AndroidGradleBuilder.copyDirectory(source, destination);
        } else {
            AndroidGradleBuilder.copyFile(source, destination);
        }
    }

    public static final void copyDirectory(File source, File destination) throws IOException {
        File[] files;
        destination.mkdirs();
        for (File file : files = source.listFiles()) {
            if (file.isDirectory()) {
                AndroidGradleBuilder.copyDirectory(file, new File(destination, file.getName()));
                continue;
            }
            AndroidGradleBuilder.copyFile(file, new File(destination, file.getName()));
        }
    }

    public static final void copyFile(File source, File destination) throws IOException {
        FileChannel sourceChannel = new FileInputStream(source).getChannel();
        FileChannel targetChannel = new FileOutputStream(destination).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), targetChannel);
        sourceChannel.close();
        targetChannel.close();
    }

    void delete(File f) throws IOException {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                this.delete(c);
            }
        }
        f.delete();
    }

    @Override
    public void unzip(InputStream source, File classesDir, File resDir, File sourceDir, File libsDir, File xmlDir) throws IOException {
        try {
            ZipEntry entry;
            File appDir = new File(libsDir.getParentFile(), "app");
            if (!appDir.exists()) {
                appDir.mkdir();
            }
            BufferedOutputStream dest = null;
            ZipInputStream zis = new ZipInputStream(source);
            TarOutputStream tos = null;
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                String entryName = entry.getName();
                if (entryName.startsWith("html") || entryName.startsWith("/html")) {
                    int count2;
                    if (entry.isDirectory()) continue;
                    if (tos == null) {
                        tos = new TarOutputStream(new FileOutputStream(new File(resDir, "html.tar")));
                    }
                    entryName = entryName.substring(5);
                    TarEntry tEntry = new TarEntry(new File(entryName), entryName);
                    tEntry.setSize(entry.getSize());
                    this.debug("Packaging entry " + entryName + " size: " + entry.getSize());
                    tos.putNextEntry(tEntry);
                    byte[] data = new byte[8192];
                    while ((count2 = zis.read(data, 0, data.length)) != -1) {
                        tos.write(data, 0, count2);
                    }
                    continue;
                }
                if (entry.isDirectory()) {
                    if (entryName.startsWith("raw")) continue;
                    File dir = new File(classesDir, entryName);
                    dir.mkdirs();
                    dir = new File(resDir, entryName);
                    dir.mkdirs();
                    dir = new File(sourceDir, entryName);
                    dir.mkdirs();
                    continue;
                }
                byte[] data = new byte[8192];
                File destFile = entryName.endsWith(".class") ? new File(classesDir, entryName) : (entryName.endsWith(".java") || entryName.endsWith(".m") || entryName.endsWith(".h") ? new File(sourceDir, entryName) : (entryName.endsWith(".jar") || entryName.endsWith(".a") || entryName.endsWith(".dylib") || entryName.endsWith(".andlib") || entryName.endsWith(".aar") ? new File(libsDir, entryName) : (this.useXMLDir() && entryName.endsWith(".xml") ? this.placeXMLFile(entry, xmlDir, resDir) : (entryName.startsWith("raw") ? new File(xmlDir.getParentFile(), entryName.toLowerCase()) : (entryName.contains("notification_sound") ? new File(xmlDir.getParentFile(), "raw/" + entryName.toLowerCase()) : ("google-services.json".equals(entryName) ? new File(libsDir.getParentFile(), entryName) : new File(resDir, entryName)))))));
                destFile.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(destFile);
                dest = new BufferedOutputStream(fos, data.length);
                while ((count = zis.read(data, 0, data.length)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            if (tos != null) {
                tos.close();
            }
            zis.close();
            source.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String permissionAdd(BuildRequest request, String permission, String text) {
        if (this.xPermissions.contains(permission)) {
            return "";
        }
        return text;
    }

    private static String maxInt(String a, String b) {
        return String.valueOf(Math.max(Integer.parseInt(a), Integer.parseInt(b)));
    }

    private static int compareVersions(String v1, String v2) {
        int i2;
        String v1p1 = v1.indexOf(".") == -1 ? v1 : v1.substring(0, v1.indexOf("."));
        String v2p1 = v2.indexOf(".") == -1 ? v2 : v2.substring(0, v2.indexOf("."));
        int i1 = Integer.parseInt(v1p1);
        if (i1 < (i2 = Integer.parseInt(v2p1))) {
            return -1;
        }
        if (i1 > i2) {
            return 1;
        }
        v1 = v1.indexOf(".") == -1 ? "" : v1.substring(v1.indexOf(".") + 1);
        String string = v2 = v2.indexOf(".") == -1 ? "" : v2.substring(v2.indexOf(".") + 1);
        if (v2.length() == 0 && v1.length() == 0) {
            return 0;
        }
        if (v2.length() == 0) {
            return 1;
        }
        if (v1.length() == 0) {
            return -1;
        }
        return AndroidGradleBuilder.compareVersions(v1, v2);
    }

    @Override
    protected String getDebugCertificateFile() {
        return "android.ks";
    }

    @Override
    protected String getReleaseCertificateFile() {
        return "android.ks";
    }

    private String addNewlineIfMissing(String s) {
        if (s != null && s.length() > 0 && !s.endsWith("\n")) {
            return s + "\n";
        }
        return s;
    }

    private File getPlayServicesJavaSourceFile(File srcDir, String playServicesVersion) {
        File androidImpl = new File(srcDir, "com/codename1/impl/android");
        String currentMaxVersion = "8.3.0";
        File currentMaxVersionFile = new File(androidImpl, "PlayServices.java");
        for (File f : androidImpl.listFiles()) {
            String versionStr;
            if (!f.getName().startsWith("PlayServices_") || !f.getName().endsWith(".java") || AndroidGradleBuilder.compareVersions(playServicesVersion, versionStr = f.getName().substring("PlayServices_".length()).replace(".java", "").replace('_', '.')) < 0 || AndroidGradleBuilder.compareVersions(currentMaxVersion, versionStr) >= 0) continue;
            currentMaxVersion = versionStr;
            currentMaxVersionFile = f;
        }
        return currentMaxVersionFile;
    }

    private String getPlayServicesVersion(File playServicesSourceFile) {
        String fname = playServicesSourceFile.getName();
        if (!fname.startsWith("PlayServices")) {
            throw new IllegalArgumentException("Only PlayServices class files can be checked for play services versions.");
        }
        if (!fname.startsWith("PlayServices_")) {
            return "8.3.0";
        }
        return fname.substring("PlayServices_".length()).replace(".java", "").replace('_', '.');
    }

    private String xartifact(String artifact) {
        if (!this.useAndroidX) {
            return artifact;
        }
        try {
            Map<String, String> map = this.loadAndroidXArtifactMapping();
            if (map.containsKey(artifact)) {
                return map.get(artifact);
            }
            return artifact;
        }
        catch (IOException ex) {
            return artifact;
        }
    }

    private String xclass(String cls) {
        if (!this.useAndroidX) {
            return cls;
        }
        try {
            Map<String, String> map = this.loadAndroidXClassMapping();
            if (map.containsKey(cls)) {
                return map.get(cls);
            }
            return cls;
        }
        catch (IOException ex) {
            return cls;
        }
    }

    private void migrateSourcesToAndroidX(File root) throws IOException {
        if (!this.migrateToAndroidX) {
            return;
        }
        this.replaceAndroidXArtifactsInTree(root);
        this.replaceAndroidXClassesInTree(root);
    }

    private void replaceAndroidXArtifactsInTree(File root) throws IOException {
        this.replaceInTree(root, this.loadAndroidXArtifactMapping(), new FilenameFilter(){

            @Override
            public boolean accept(File parent, String dir) {
                return dir.endsWith(".gradle");
            }
        });
    }

    private void replaceAndroidXClassesInTree(File root) throws IOException {
        this.debug("Replacing Android Support classes with AndroidX classes in " + root);
        this.replaceInTree(root, this.loadAndroidXClassMapping(), new FilenameFilter(){

            @Override
            public boolean accept(File parent, String dir) {
                return dir.endsWith(".xml") || dir.endsWith(".kt") || dir.endsWith(".java");
            }
        });
    }

    private static String replace(String content, Map<String, String> replacements) {
        for (Map.Entry<String, String> e : replacements.entrySet()) {
            content = content.replace(e.getKey(), e.getValue());
        }
        return content;
    }

    private void replaceInTree(File root, Map<String, String> replacements, FilenameFilter filter) throws IOException {
        if (root.isDirectory()) {
            for (File child : root.listFiles()) {
                this.replaceInTree(child, replacements, filter);
            }
        } else if (filter.accept(root.getParentFile(), root.getName())) {
            this.replaceInFile(root, replacements);
        }
    }

    private void replaceInFile(File file, Map<String, String> replacements) throws IOException {
        String contents = this.readFileToString(file);
        contents = AndroidGradleBuilder.replace(contents, replacements);
        FileWriter fios = new FileWriter(file);
        fios.write(contents);
        fios.close();
    }

    private Map<String, String> loadAndroidXArtifactMapping() throws IOException {
        if (this.androidXArtifactMapping == null) {
            this.androidXArtifactMapping = this.loadCSVMapping(this.androidXArtifactMapping, "androidx-artifact-mapping.csv");
        }
        return this.androidXArtifactMapping;
    }

    private Map<String, String> loadAndroidXClassMapping() throws IOException {
        if (this.androidXClassMapping == null) {
            this.androidXClassMapping = this.loadCSVMapping(this.androidXClassMapping, "androidx-class-mapping.csv");
            LinkedHashMap<String, String> packages = new LinkedHashMap<String, String>();
            for (String supportClass : this.androidXClassMapping.keySet()) {
                String xClass = this.androidXClassMapping.get(supportClass);
                supportClass = supportClass.substring(0, supportClass.lastIndexOf(".") + 1);
                xClass = xClass.substring(0, xClass.lastIndexOf(".") + 1);
                packages.put(supportClass, xClass);
            }
        }
        return this.androidXClassMapping;
    }

    private Map<String, String> loadCSVMapping(Map<String, String> out, String csvResourcePath) throws IOException {
        if (out == null) {
            out = new LinkedHashMap<String, String>();
        }
        this.debug("Loading CSV mapping for android X from " + csvResourcePath);
        InputStream csvMappingStream = AndroidGradleBuilder.class.getResourceAsStream(csvResourcePath);
        if (csvMappingStream == null) {
            throw new IOException("Cannot find android X CSV mapping at " + csvResourcePath);
        }
        Scanner scanner = new Scanner(csvMappingStream, "UTF-8");
        boolean firstLine = true;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine().trim();
            if (firstLine) {
                firstLine = false;
                continue;
            }
            int pos = line.indexOf(",");
            if (pos == -1) continue;
            out.put(line.substring(0, pos).trim(), line.substring(pos + 1).trim());
        }
        return out;
    }

    private void createAndroidStudioProject(File dest) throws IOException {
        if (dest.exists()) {
            throw new IOException("Cannot create AndroidStudio project at " + dest + " because it already exists");
        }
        File destZip = new File(dest.getAbsolutePath() + ".zip");
        if (destZip.exists()) {
            throw new IOException("Cannot extract AndroidStudioTemplate at " + destZip + " because it already exists");
        }
        FileUtils.copyInputStreamToFile((InputStream)this.getClass().getResourceAsStream("AndroidStudioProjectTemplate.zip"), (File)destZip);
        ZipFile zipFile = new ZipFile(destZip);
        File destZipExtracted = new File(destZip.getAbsolutePath() + "-extracted");
        destZipExtracted.mkdir();
        zipFile.extractAll(destZipExtracted.getAbsolutePath());
        for (File child : destZipExtracted.listFiles()) {
            if (!child.isDirectory() || !"AndroidStudioProjectTemplate".equals(child.getName())) continue;
            child.renameTo(dest);
            break;
        }
        AndroidGradleBuilder.delTree(destZipExtracted);
        this.delete(destZip);
        if (!dest.exists()) {
            throw new IOException("Failed to create Android Studio Project at " + dest + ".  Not sure what went wrong.  Did all the steps, but just wasn't there when we were done");
        }
    }

    private String getDefaultPlayServiceVersion(String playService) {
        if (this.playServiceVersions.containsKey(playService)) {
            return this.playServiceVersions.get(playService);
        }
        if (this.decouplePlayServiceVersions && defaultPlayServiceVersions.containsKey(playService)) {
            return defaultPlayServiceVersions.get(playService);
        }
        return this.playServicesVersion;
    }

    private void initPlayServiceVersions(BuildRequest request) {
        for (String arg : request.getArgs()) {
            String playServiceValue;
            if (!arg.startsWith("android.playService.")) continue;
            String playServiceKey = arg.substring("android.playService.".length());
            if (playServiceKey.equals("appInvite")) {
                playServiceKey = "app-invite";
            } else if (playServiceKey.equals("firebaseCore")) {
                playServiceKey = "firebase-core";
            } else if (playServiceKey.equals("firebaseMessaging")) {
                playServiceKey = "firebase-messaging";
            }
            if ((playServiceValue = request.getArg(arg, null)) == null || "true".equals(playServiceValue) || "false".equals(playServiceValue)) continue;
            this.playServiceVersions.put(playServiceKey, playServiceValue);
        }
    }

    private void stripKotlin(File dummyClassesDir) {
        String[] skipDirectories;
        for (String path : skipDirectories = new String[]{"org" + File.separator + "jetbrains" + File.separator + "annotations", "org" + File.separator + "intellij" + File.separator + "lang" + File.separator + "annotations", "kotlin"}) {
            File directory = new File(dummyClassesDir, path);
            if (!directory.isDirectory()) continue;
            this.log("Deleting directory " + directory);
            AndroidGradleBuilder.delTree(directory, true);
        }
    }

    static {
        defaultPlayServiceVersions = new HashMap<String, String>();
        defaultPlayServiceVersions.put("ads", "22.6.0");
        defaultPlayServiceVersions.put("ads-identifier", "18.0.1");
        defaultPlayServiceVersions.put("ads-lite", "21.5.0");
        defaultPlayServiceVersions.put("afs-native", "19.0.3");
        defaultPlayServiceVersions.put("analytics", "18.0.2");
        defaultPlayServiceVersions.put("appindex", "16.1.0");
        defaultPlayServiceVersions.put("appset", "16.0.2");
        defaultPlayServiceVersions.put("auth", "20.4.1");
        defaultPlayServiceVersions.put("auth-api-phone", "18.0.1");
        defaultPlayServiceVersions.put("auth-blockstore", "16.1.0");
        defaultPlayServiceVersions.put("awareness", "19.0.1");
        defaultPlayServiceVersions.put("base", "18.2.0");
        defaultPlayServiceVersions.put("base-testing", "16.0.0");
        defaultPlayServiceVersions.put("basement", "18.1.0");
        defaultPlayServiceVersions.put("cast", "21.2.0");
        defaultPlayServiceVersions.put("cast-framework", "21.2.0");
        defaultPlayServiceVersions.put("code-scanner", "16.0.0-beta3");
        defaultPlayServiceVersions.put("cronet", "18.0.1");
        defaultPlayServiceVersions.put("dtdi", "16.0.0-beta01");
        defaultPlayServiceVersions.put("fido", "19.0.1");
        defaultPlayServiceVersions.put("fitness", "21.1.0");
        defaultPlayServiceVersions.put("games-v2", "17.0.0");
        defaultPlayServiceVersions.put("games-v2-native-c", "17.0.0-beta1");
        defaultPlayServiceVersions.put("games", "23.1.0");
        defaultPlayServiceVersions.put("home", "16.0.0");
        defaultPlayServiceVersions.put("instantapps", "18.0.1");
        defaultPlayServiceVersions.put("location", "21.0.1");
        defaultPlayServiceVersions.put("maps", "18.1.0");
        defaultPlayServiceVersions.put("mlkit-barcode-scanning", "18.1.0");
        defaultPlayServiceVersions.put("mlkit-face-detection", "17.1.0");
        defaultPlayServiceVersions.put("mlkit-image-labeling", "16.0.8");
        defaultPlayServiceVersions.put("mlkit-image-labeling-custom", "16.0.0-beta4");
        defaultPlayServiceVersions.put("mlkit-language-id", "17.0.0");
        defaultPlayServiceVersions.put("mlkit-smart-reply", "16.0.0-beta1");
        defaultPlayServiceVersions.put("mlkit-text-recognition", "18.0.2");
        defaultPlayServiceVersions.put("nearby", "18.4.0");
        defaultPlayServiceVersions.put("oss-licenses", "17.0.0");
        defaultPlayServiceVersions.put("password-complexity", "18.0.1");
        defaultPlayServiceVersions.put("pay", "16.1.0");
        defaultPlayServiceVersions.put("recaptcha", "17.0.1");
        defaultPlayServiceVersions.put("safetynet", "18.0.1");
        defaultPlayServiceVersions.put("tagmanager", "18.0.2");
        defaultPlayServiceVersions.put("tasks", "18.0.2");
        defaultPlayServiceVersions.put("tflite-gpu", "16.1.0");
        defaultPlayServiceVersions.put("tflite-java", "16.0.1");
        defaultPlayServiceVersions.put("tflite-support", "16.0.1");
        defaultPlayServiceVersions.put("threadnetwork", "16.0.0-beta02");
        defaultPlayServiceVersions.put("vision", "20.1.3");
        defaultPlayServiceVersions.put("wallet", "19.1.0");
        defaultPlayServiceVersions.put("wearable", "18.0.0");
        defaultPlayServiceVersions.put("firebase-core", "12.0.1");
        defaultPlayServiceVersions.put("firebase-messaging", "12.0.1");
        defaultPlayServiceVersions.put("gcm", "12.0.1");
        isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") > -1;
    }
}

