/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.builders;

import com.codename1.builders.Base64;
import com.codename1.builders.BuildException;
import com.codename1.builders.BuildRequest;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javax.imageio.ImageIO;
import org.apache.maven.plugin.logging.Log;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;
import org.xeustechnologies.jtar.TarEntry;
import org.xeustechnologies.jtar.TarOutputStream;

public abstract class Executor {
    public static final String BUILD_TARGET_XCODE_PROJECT = "ios-source";
    public static final String BUILD_TARGET_ANDROID_PROJECT = "android-source";
    private String buildTarget;
    private static boolean disableDelete;
    public static final boolean is_windows;
    protected File tmpDir;
    StringBuilder message = new StringBuilder();
    private String buildId;
    private boolean canceled;
    private Class[] nativeInterfaces;
    private String buildKey;
    private boolean unitTestMode;
    private String platform;
    static boolean IS_MAC;
    protected final Map<String, String> defaultEnvironment = new HashMap<String, String>();
    private Properties localBuilderProperties;
    protected File codenameOneJar;
    private File buildDirectory;
    private Log logger;
    protected boolean logToSystemOut;

    public void setCodenameOneJar(File codenameOneJar) {
        this.codenameOneJar = codenameOneJar;
    }

    public File getCodenameOneJar() {
        return this.codenameOneJar;
    }

    public void setBuildDirectory(File buildDirectory) {
        this.buildDirectory = buildDirectory;
    }

    public File getBuildDirectory() {
        return this.buildDirectory;
    }

    public void setId(String buildId) {
        this.buildId = buildId;
    }

    public void setPlatform(String p) {
        this.platform = p;
    }

    public static void disableDelete() {
        disableDelete = true;
    }

    public void cleanup() {
        if (!disableDelete && this.tmpDir != null) {
            Executor.delTree(this.tmpDir);
        }
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix);
    }

    public void setBuildTarget(String target) {
        this.buildTarget = target;
    }

    public String getBuildTarget() {
        return this.buildTarget;
    }

    public void replaceInFile(File sourceFile, String marker, String newValue) throws IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(sourceFile));
        byte[] data = new byte[(int)sourceFile.length()];
        dis.readFully(data);
        dis.close();
        FileWriter fios = new FileWriter(sourceFile);
        String str = new String(data);
        str = str.replace(marker, newValue);
        fios.write(str);
        fios.close();
    }

    public String readFileToString(File sourceFile) throws IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(sourceFile));
        byte[] data = new byte[(int)sourceFile.length()];
        dis.readFully(data);
        dis.close();
        String str = new String(data);
        return str;
    }

    public boolean findInFile(File sourceFile, String marker) throws IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(sourceFile));
        byte[] data = new byte[(int)sourceFile.length()];
        dis.readFully(data);
        dis.close();
        String str = new String(data);
        return str.contains(marker);
    }

    public void replaceAllInFile(File sourceFile, String marker, String newValue) throws IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(sourceFile));
        byte[] data = new byte[(int)sourceFile.length()];
        dis.readFully(data);
        dis.close();
        FileWriter fios = new FileWriter(sourceFile);
        String str = new String(data);
        str = str.replaceAll(marker, newValue);
        fios.write(str);
        fios.close();
    }

    File includeSources(BuildRequest request) throws Exception {
        return null;
    }

    protected File retrolambdaDontRename(File userDir, BuildRequest request, File classDir) throws Exception {
        return this.retrolambda(userDir, request, classDir, false);
    }

    protected String defaultJavaVersion() {
        return "8";
    }

    protected boolean retrolambda(File userDir, BuildRequest request, File classDir) throws Exception {
        return this.retrolambda(userDir, request, classDir, true) != null;
    }

    private File retrolambda(File userDir, BuildRequest request, File classDir, boolean rename) throws Exception {
        File output = new File(classDir.getParentFile(), classDir.getName() + "_retrolamda");
        output.mkdir();
        HashMap<String, String> env = new HashMap<String, String>();
        String retrolambda = System.getProperty("retrolambdaJarPath", null);
        if (retrolambda == null) {
            this.getResourceAsFile("/com/codename1/builder/retrolambda.jar", ".jar").getAbsolutePath();
        }
        if (this.codenameOneJar == null) {
            throw new IllegalStateException("CodenameOne jar is not set");
        }
        if (!this.codenameOneJar.exists()) {
            throw new IOException("Cannot find codename one jar at " + this.codenameOneJar);
        }
        String codenameOneJarPath = this.codenameOneJar.getAbsolutePath();
        File java8Home = new File(System.getProperty("java.home"));
        String java = new File(java8Home, "bin" + File.separator + "java").getAbsolutePath();
        String defaultMethods = "-Dretrolambda.defaultMethods=true";
        if (!this.exec(userDir, env, java, "-Dretrolambda.inputDir=" + classDir.getAbsolutePath(), "-Dretrolambda.classpath=" + classDir.getAbsolutePath() + File.pathSeparator + codenameOneJarPath, "-Dretrolambda.outputDir=" + output.getAbsolutePath(), "-Dretrolambda.bytecodeVersion=49", defaultMethods, "-jar", retrolambda)) {
            return null;
        }
        this.stripInvokeClassConstantsRecursive(output);
        if (rename) {
            Executor.delTree(classDir, true);
            if (is_windows) {
                Files.move(output.toPath(), classDir.toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                output.renameTo(classDir);
            }
            this.remapClasses(classDir, this.getDefaultClassMapping());
        } else {
            this.remapClasses(output, this.getDefaultClassMapping());
        }
        return output;
    }

    private void stripInvokeClassConstantsRecursive(File dir) throws IOException {
        if (dir.isFile() && dir.getName().endsWith(".class")) {
            this.stripInvokeClassConstants(dir);
        } else if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                if (f.getName().startsWith(".")) continue;
                this.stripInvokeClassConstantsRecursive(f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stripInvokeClassConstants(File classFile) throws IOException {
        FileInputStream fis = null;
        try {
            final boolean[] found = new boolean[1];
            fis = new FileInputStream(classFile);
            ClassReader r = new ClassReader(fis){};
            ClassVisitor v = new ClassVisitor(589824){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    super.visit(version, access, name, signature, superName, interfaces);
                }

                public void visitInnerClass(String name, String outerName, String innerName, int access) {
                    if (!name.startsWith("java/lang/invoke")) {
                        super.visitInnerClass(name, outerName, innerName, access);
                    } else {
                        found[0] = true;
                    }
                }
            };
            ClassWriter w = new ClassWriter(r, 1);
            r.accept(v, 0);
            if (!found[0]) {
                return;
            }
            File out = classFile;
            this.createFile(out, w.toByteArray());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected String createStartInvocation(BuildRequest request, String mainObject) {
        return this.createStartInvocation(request, mainObject, true);
    }

    protected String createStartInvocation(BuildRequest request, String mainObject, boolean includeVserv) {
        String zone = request.getArg("vserv.zone", null);
        if (includeVserv && zone != null && zone.length() > 0) {
            String transition = request.getArg("vserv.transition", "300000");
            String countryCode = request.getArg("vserv.countryCode", "null");
            String networkCode = request.getArg("vserv.networkCode", "null");
            String locale = request.getArg("vserv.locale", "en_US");
            String category = request.getArg("vserv.category", "29");
            try {
                URL u = new URL("http://admin.vserv.mobi/partner/zone-add.php?partnerid=1&zoneid=" + zone);
                InputStream i = u.openStream();
                i.read();
                i.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            String scaleMode = request.getArg("vserv.scaleMode", "false");
            String allowSkipping = request.getArg("vserv.allowSkipping", "true");
            return "        com.codename1.impl.VServAds v = new com.codename1.impl.VServAds();\n        v.setCountryCode(\"" + countryCode + "\");\n        v.setNetworkCode(\"" + networkCode + "\");\n        v.setLocale(\"" + locale + "\");\n        v.setZoneId(\"" + zone + "\");\n        v.setCategory(" + category + ");\n        v.setScaleMode(" + scaleMode + ");\n        v.setAllowSkipping(" + allowSkipping + ");\n        v.showWelcomeAd();\n        v.bindTransitionAd(" + transition + ");\n        " + mainObject + ".start();\n";
        }
        return mainObject + ".start();\n";
    }

    public void setLogger(Log log) {
        this.logger = log;
    }

    protected Map<String, String> getDefaultClassMapping() {
        HashMap<String, String> out = new HashMap<String, String>();
        out.put("java/util/Objects", "com/codename1/compat/java/util/Objects");
        return out;
    }

    protected void remapClasses(File directory, Map<String, String> mapping) throws IOException {
        this.remapClasses(directory, new SimpleRemapper(mapping));
    }

    private void remapClasses(File directory, SimpleRemapper remapper) throws IOException {
        File[] list;
        for (File current : list = directory.listFiles()) {
            if (current.isDirectory()) {
                this.remapClasses(current, remapper);
                continue;
            }
            if (!current.getName().endsWith(".class")) continue;
            InputStream is = new FileInputStream(current);
            ClassReader r = null;
            ClassWriter cw = new ClassWriter(0);
            ClassRemapper remappingClassAdapter = new ClassRemapper((ClassVisitor)cw, (Remapper)remapper);
            try {
                r = new ClassReader(is);
            }
            catch (RuntimeException re) {
                this.message.append(Executor.getCustomStackTrace(re));
                this.message.append("Error encountered while parsing the class ");
                this.message.append(current.getName());
                throw re;
            }
            ((InputStream)is).close();
            try {
                r.accept((ClassVisitor)remappingClassAdapter, 8);
                is = new ByteArrayInputStream(cw.toByteArray());
                FileOutputStream fos = new FileOutputStream(current);
                Executor.copy(is, fos);
            }
            catch (RuntimeException re) {
                this.message.append(Executor.getCustomStackTrace(re));
                this.message.append("Error encountered while parsing the class ");
                this.message.append(current.getName());
                throw re;
            }
        }
    }

    protected void scanClassesForPermissions(File directory, final ClassScanner scanner) throws IOException {
        File[] list;
        for (File current : list = directory.listFiles()) {
            if (current.isDirectory()) {
                this.scanClassesForPermissions(current, scanner);
                continue;
            }
            if (!current.getName().endsWith(".class")) continue;
            FileInputStream is = new FileInputStream(current);
            ClassReader r = null;
            try {
                r = new ClassReader((InputStream)is);
            }
            catch (RuntimeException re) {
                this.message.append(Executor.getCustomStackTrace(re));
                this.message.append("Error encountered while parsing the class ");
                this.message.append(current.getName());
                throw re;
            }
            ((InputStream)is).close();
            ClassVisitor classVisitor = new ClassVisitor(589824){

                public void visit(int i, int i1, String string, String string1, String superName, String[] interfaces) {
                    scanner.usesClass(superName);
                    for (String s : interfaces) {
                        scanner.usesClass(s);
                    }
                }

                public void visitSource(String string, String string1) {
                }

                public void visitOuterClass(String string, String string1, String string2) {
                }

                public AnnotationVisitor visitAnnotation(String string, boolean bln) {
                    return null;
                }

                public void visitAttribute(Attribute atrbt) {
                }

                public void visitInnerClass(String string, String string1, String string2, int i) {
                }

                public FieldVisitor visitField(int i, String string, String type, String string2, Object o) {
                    if (type.startsWith("L")) {
                        scanner.usesClass(type.substring(1, type.length() - 2));
                    }
                    return null;
                }

                public MethodVisitor visitMethod(int i, String methodName, String string1, String string2, String[] strings) {
                    return new MethodVisitor(589824){

                        public AnnotationVisitor visitAnnotationDefault() {
                            return null;
                        }

                        public AnnotationVisitor visitAnnotation(String string, boolean bln) {
                            return null;
                        }

                        public AnnotationVisitor visitParameterAnnotation(int i, String string, boolean bln) {
                            return null;
                        }

                        public void visitAttribute(Attribute atrbt) {
                        }

                        public void visitCode() {
                        }

                        public void visitFrame(int i, int i1, Object[] os, int i2, Object[] os1) {
                        }

                        public void visitInsn(int i) {
                        }

                        public void visitIntInsn(int i, int i1) {
                        }

                        public void visitVarInsn(int i, int i1) {
                        }

                        public void visitTypeInsn(int i, String string) {
                            scanner.usesClass(string);
                        }

                        public void visitFieldInsn(int i, String string, String string1, String string2) {
                        }

                        public void visitMethodInsn(int i, String owner, String name, String string2) {
                            scanner.usesClass(owner);
                            if (name != null && !name.equals("<init>")) {
                                scanner.usesClassMethod(owner, name);
                            }
                        }

                        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                            scanner.usesClass(owner);
                            if (name != null && !name.equals("<init>")) {
                                scanner.usesClassMethod(owner, name);
                            }
                        }

                        public void visitJumpInsn(int i, Label label) {
                        }

                        public void visitLabel(Label label) {
                        }

                        public void visitLdcInsn(Object o) {
                            if (o instanceof Type) {
                                scanner.usesClass(((Type)o).getClassName());
                            }
                        }

                        public void visitIincInsn(int i, int i1) {
                        }

                        public void visitTableSwitchInsn(int i, int i1, Label label, Label[] labels) {
                        }

                        public void visitLookupSwitchInsn(Label label, int[] ints, Label[] labels) {
                        }

                        public void visitMultiANewArrayInsn(String string, int i) {
                        }

                        public void visitTryCatchBlock(Label label, Label label1, Label label2, String string) {
                        }

                        public void visitLocalVariable(String string, String classType, String string2, Label label, Label label1, int i) {
                            if (classType.startsWith("L")) {
                                scanner.usesClass(classType.substring(1, classType.length() - 2));
                            }
                        }

                        public void visitLineNumber(int i, Label label) {
                        }

                        public void visitMaxs(int i, int i1) {
                        }

                        public void visitEnd() {
                        }
                    };
                }

                public void visitEnd() {
                }
            };
            try {
                r.accept(classVisitor, 8);
            }
            catch (RuntimeException re) {
                this.message.append(Executor.getCustomStackTrace(re));
                this.message.append("Error encountered while parsing the class ");
                this.message.append(current.getName());
                throw new RuntimeException("Failed to parse class file " + current, re);
            }
        }
    }

    protected abstract String getDeviceIdCode();

    protected void findFiles(List<File> result, File directory, final String filter) {
        File[] files;
        for (File f : files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(filter);
            }
        })) {
            if (f.isDirectory()) {
                this.findFiles(result, f, filter);
                continue;
            }
            result.add(f);
        }
    }

    public Class[] getNativeInterfaces() {
        return this.nativeInterfaces;
    }

    protected String getImplSuffix() {
        return "Impl";
    }

    protected String registerNativeImplementationsAndCreateStubs(ClassLoader parentClassLoader, File stubDir, File ... classesDirectory) throws MalformedURLException, IOException {
        this.nativeInterfaces = this.findNativeInterfaces(parentClassLoader, classesDirectory);
        String registerNativeFunctions = "";
        if (this.nativeInterfaces != null && this.nativeInterfaces.length > 0) {
            for (Class n : this.nativeInterfaces) {
                registerNativeFunctions = registerNativeFunctions + "        NativeLookup.register(" + n.getName() + ".class, " + n.getName() + "Stub.class);\n";
            }
        }
        if (this.nativeInterfaces != null && this.nativeInterfaces.length > 0) {
            for (Class currentNative : this.nativeInterfaces) {
                File folder = new File(stubDir, currentNative.getPackage().getName().replace('.', File.separatorChar));
                folder.mkdirs();
                File javaFile = new File(folder, currentNative.getSimpleName() + "Stub.java");
                String javaImplSourceFile = "package " + currentNative.getPackage().getName() + ";\n\nimport com.codename1.ui.PeerComponent;\n\npublic class " + currentNative.getSimpleName() + "Stub implements " + currentNative.getSimpleName() + "{\n    private " + currentNative.getSimpleName() + this.getImplSuffix() + " impl = new " + currentNative.getSimpleName() + this.getImplSuffix() + "();\n\n";
                for (Method m : currentNative.getMethods()) {
                    String name = m.getName();
                    if (name.equals("hashCode") || name.equals("equals") || name.equals("toString")) continue;
                    Class<?> returnType = m.getReturnType();
                    javaImplSourceFile = javaImplSourceFile + "    public " + returnType.getSimpleName() + " " + name + "(";
                    Class<?>[] params = m.getParameterTypes();
                    String args = "";
                    if (params != null && params.length > 0) {
                        for (int iter = 0; iter < params.length; ++iter) {
                            if (iter > 0) {
                                javaImplSourceFile = javaImplSourceFile + ", ";
                                args = args + ", ";
                            }
                            javaImplSourceFile = javaImplSourceFile + params[iter].getSimpleName() + " param" + iter;
                            args = params[iter].getName().equals("com.codename1.ui.PeerComponent") ? args + this.convertPeerComponentToNative("param" + iter) : args + "param" + iter;
                        }
                    }
                    javaImplSourceFile = javaImplSourceFile + ") {\n";
                    javaImplSourceFile = Void.class == returnType || Void.TYPE == returnType ? javaImplSourceFile + "        impl." + name + "(" + args + ");\n    }\n\n" : (returnType.getName().equals("com.codename1.ui.PeerComponent") ? javaImplSourceFile + "        return " + this.generatePeerComponentCreationCode("impl." + name + "(" + args + ")") + ";\n    }\n\n" : javaImplSourceFile + "        return impl." + name + "(" + args + ");\n    }\n\n");
                }
                javaImplSourceFile = javaImplSourceFile + "}\n";
                FileOutputStream out = new FileOutputStream(javaFile);
                out.write(javaImplSourceFile.getBytes());
                out.close();
            }
        }
        return registerNativeFunctions;
    }

    protected abstract String generatePeerComponentCreationCode(String var1);

    protected abstract String convertPeerComponentToNative(String var1);

    protected boolean execWithFiles(File dir, File filesDir, String filter, String ... varArgs) throws Exception {
        ArrayList<File> fileList = new ArrayList<File>();
        this.findFiles(fileList, filesDir, filter);
        String[] args = new String[fileList.size() + varArgs.length];
        System.arraycopy(varArgs, 0, args, 0, varArgs.length);
        for (int iter = 0; iter < fileList.size(); ++iter) {
            args[varArgs.length + iter] = ((File)fileList.get(iter)).getAbsolutePath();
        }
        return this.exec(dir, args);
    }

    protected Class[] findNativeInterfaces(ClassLoader parentClassLoader, File ... classesDirectories) throws MalformedURLException, IOException {
        URL[] urls = new URL[classesDirectories.length];
        for (int iter = 0; iter < urls.length; ++iter) {
            urls[iter] = classesDirectories[iter].toURI().toURL();
        }
        URLClassLoader cl = new URLClassLoader(urls, parentClassLoader);
        ArrayList<Class> classList = new ArrayList<Class>();
        for (File userClassesDirectory : classesDirectories) {
            this.findNativeClassesInDir(userClassesDirectory.getAbsolutePath(), userClassesDirectory, cl, classList);
        }
        Class[] arr = new Class[classList.size()];
        classList.toArray(arr);
        return arr;
    }

    private void findNativeClassesInDir(String baseDir, File directory, URLClassLoader cl, List<Class> classList) throws IOException {
        File[] files;
        for (File f : files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".class") && file.getName().indexOf(36) < 0 || file.getName().endsWith(".jar");
            }
        })) {
            if (f.isDirectory()) {
                this.findNativeClassesInDir(baseDir, f, cl, classList);
                continue;
            }
            String fileName = f.getAbsolutePath();
            if (fileName.endsWith(".jar")) {
                ZipEntry entry;
                FileInputStream zipFile = new FileInputStream(fileName);
                ZipInputStream zip = new ZipInputStream(zipFile);
                while ((entry = zip.getNextEntry()) != null) {
                    String entryName;
                    if (entry.isDirectory() || !(entryName = entry.getName()).endsWith(".class") || entryName.indexOf(36) >= 0) continue;
                    String className = entryName.substring(baseDir.length() + 1, entryName.length() - 6);
                    className = className.replace('/', '.');
                    this.isNativeInterface(cl, className, classList);
                }
                zip.close();
                continue;
            }
            String className = fileName.substring(baseDir.length() + 1, fileName.length() - 6);
            className = className.replace(File.separatorChar, '.');
            this.isNativeInterface(cl, className, classList);
        }
    }

    private void isNativeInterface(ClassLoader cl, String className, List<Class> classList) {
        block3: {
            try {
                Class<?> cls = cl.loadClass(className);
                if (!cls.isInterface()) break block3;
                for (Class<?> current : cls.getInterfaces()) {
                    if (!current.getName().equals("com.codename1.system.NativeInterface")) continue;
                    this.debug(className + " is a native interface");
                    classList.add(cls);
                    break;
                }
            }
            catch (Throwable t) {
                this.warn("Evaluated " + className + " it is not a native interface " + t, t);
            }
        }
    }

    protected File createTmpDir() throws IOException {
        this.tmpDir = Executor.createTempFile("build", "xxx");
        this.tmpDir.delete();
        this.tmpDir.mkdirs();
        return this.tmpDir;
    }

    public static void delTree(File f) {
        Executor.delTree(f, false);
    }

    public static void delTree(File f, boolean force) {
        if (!force && disableDelete) {
            return;
        }
        if (f != null && f.isDirectory()) {
            for (String current : f.list()) {
                File ff = new File(f, current);
                if (ff.isDirectory()) {
                    Executor.delTree(ff, force);
                }
                ff.setWritable(true);
                ff.delete();
            }
        }
    }

    protected long getTimeoutValue() {
        return 90000000L;
    }

    private static void verifyCN1Install() throws IOException {
        File cn1Home = new File(System.getProperty("user.home"), ".codenameone");
        File UpdateCodenameOneJar = new File(cn1Home, "UpdateCodenameOne.jar");
        if (!cn1Home.exists() || !UpdateCodenameOneJar.exists()) {
            cn1Home.mkdirs();
            URL update = new URL("https://www.codenameone.com/files/updates/UpdateCodenameOne.jar");
            InputStream is = update.openStream();
            FileOutputStream os = new FileOutputStream(UpdateCodenameOneJar);
            Executor.copy(is, os);
        }
    }

    private void updateProjectLibs(BuildRequest r, File path) throws Exception {
        File cn1Home = new File(System.getProperty("user.home"), ".codenameone");
        File updateJar = new File(cn1Home, "UpdateCodenameOne.jar");
        File java8Home = new File(System.getProperty("java.home"));
        String java = new File(java8Home + "bin" + File.separator + "java").getAbsolutePath();
        if (is_windows) {
            java = java + ".exe";
        }
        HashMap<String, String> env = new HashMap<String, String>();
        this.exec(path, env, java, "-jar", updateJar.getAbsolutePath(), path.getAbsolutePath());
    }

    private byte[] fileToByteArray(File certFileO) throws IOException {
        if (certFileO.exists()) {
            DataInputStream dis = new DataInputStream(new FileInputStream(certFileO));
            byte[] data = new byte[(int)certFileO.length()];
            dis.readFully(data);
            dis.close();
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildNoException(final File sourceZip, final BuildRequest request) {
        try {
            if (this.isCanceled()) {
                return false;
            }
            final boolean[] result = new boolean[1];
            final boolean[] alive = new boolean[]{true};
            final Object LOCK = new Object();
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        File s = sourceZip;
                        result[0] = Executor.this.build(s, request);
                    }
                    catch (Throwable err) {
                        err.printStackTrace();
                        if (err.getCause() != null) {
                            err.getCause().printStackTrace();
                            Executor.this.debug(err.getCause().toString());
                            Executor.this.message.append(Executor.getCustomStackTrace(err.getCause()));
                        }
                        Executor.this.message.append(Executor.getCustomStackTrace(err));
                    }
                    Object object = LOCK;
                    synchronized (object) {
                        alive[0] = false;
                        LOCK.notify();
                    }
                }
            };
            t.start();
            long time = System.currentTimeMillis() + this.getTimeoutValue();
            Object object = LOCK;
            synchronized (object) {
                LOCK.wait(3000L);
                while (alive[0]) {
                    if (this.isCanceled()) {
                        t.stop();
                        return false;
                    }
                    LOCK.wait(3000L);
                    if (System.currentTimeMillis() <= time) continue;
                    this.canceled = true;
                    t.stop();
                    return false;
                }
            }
            return result[0];
        }
        catch (Exception err) {
            err.printStackTrace();
            this.message.append(Executor.getCustomStackTrace(err));
            return false;
        }
    }

    protected String getDebugCertificateFile() {
        return "ios_debug.p12";
    }

    protected String getReleaseCertificateFile() {
        return "ios_release.p12";
    }

    protected String getDebugCertificatePasswordKey() {
        return "codename1.android.keystorePassword";
    }

    protected String getReleaseCertificatePasswordKey() {
        return this.getDebugCertificatePasswordKey();
    }

    protected boolean isCanceled() {
        return this.canceled;
    }

    public static String getCustomStackTrace(Throwable aThrowable) {
        StringBuilder result = new StringBuilder("Exception: ");
        result.append(aThrowable.toString());
        String NEW_LINE = System.getProperty("line.separator");
        result.append(NEW_LINE);
        for (StackTraceElement element : aThrowable.getStackTrace()) {
            result.append(element);
            result.append(NEW_LINE);
        }
        return result.toString();
    }

    public abstract boolean build(File var1, BuildRequest var2) throws BuildException;

    public String getErrorMessage() {
        return this.message.toString();
    }

    protected void createIconFile(File f, BufferedImage icon, int w, int h) throws IOException {
        ImageIO.write((RenderedImage)this.getScaledInstance(icon, w, h), "png", f);
    }

    protected void createUnevenIconFile(File f, BufferedImage icon, int w, int h) throws IOException {
        ImageIO.write((RenderedImage)this.getScaledUnevenInstance(icon, w, h), "png", f);
    }

    public String getMimetypeFor(File f) {
        String name = f.getName().toLowerCase();
        if (name.endsWith(".ipa")) {
            return "application/octet-stream";
        }
        if (name.endsWith(".png") || name.equals("iTunesArtwork")) {
            return "image/png";
        }
        if (name.endsWith(".jpg") || name.equals("jpeg")) {
            return "image/jpg";
        }
        if (name.endsWith(".bz2")) {
            return "application/bzip2";
        }
        if (name.endsWith(".zip")) {
            return "application/zip";
        }
        if (name.endsWith(".jad")) {
            return "text/vnd.sun.j2me.app-descriptor";
        }
        if (name.endsWith(".jar")) {
            return "application/java-archive";
        }
        if (name.endsWith(".cod")) {
            return "application/vnd.rim.cod";
        }
        if (name.endsWith(".cod")) {
            return "application/vnd.rim.cod";
        }
        if (name.endsWith(".apk")) {
            return "application/vnd.android.package-archive";
        }
        if (name.endsWith(".txt")) {
            return "plain/text";
        }
        if (name.endsWith(".p12")) {
            return "application/x-pkcs12";
        }
        if (name.endsWith(".xap")) {
            return "application/x-silverlight-app";
        }
        if (name.endsWith(".cer")) {
            return "application/x-x509-ca-cert";
        }
        if (name.endsWith(".dmg")) {
            return "application/x-apple-diskimage";
        }
        if (name.endsWith(".msi")) {
            return "application/x-msi";
        }
        if (name.endsWith(".exe")) {
            return "application/octet-stream";
        }
        if (name.endsWith(".war")) {
            return "application/java-archive";
        }
        if (name.endsWith(".html")) {
            return "text/html";
        }
        return "application/unknown";
    }

    private void copyDir(File dir, File classesDir, File resDir, File sourceDir, File libsDir) throws IOException {
        for (File currentFile : dir.listFiles()) {
            File destFile;
            String fileName = currentFile.getName();
            if (currentFile.isDirectory()) {
                File newClassesDir = new File(classesDir, fileName);
                newClassesDir.mkdirs();
                File newresDir = new File(resDir, fileName);
                newresDir.mkdirs();
                File newsourceDir = new File(sourceDir, fileName);
                newsourceDir.mkdirs();
                File newlibsDir = new File(libsDir, fileName);
                newlibsDir.mkdirs();
                this.copyDir(currentFile, newClassesDir, newresDir, newsourceDir, newlibsDir);
                continue;
            }
            if (fileName.endsWith(".class")) {
                if (fileName.equals("module-info.class")) continue;
                destFile = new File(classesDir, fileName);
            } else {
                destFile = fileName.endsWith(".java") || fileName.endsWith(".m") || fileName.endsWith(".h") || fileName.endsWith(".cs") ? new File(sourceDir, fileName) : (fileName.endsWith(".jar") || fileName.endsWith(".a") || fileName.endsWith(".dylib") ? new File(libsDir, fileName) : new File(resDir, fileName));
            }
            destFile.getParentFile().mkdirs();
            DataInputStream di = new DataInputStream(new FileInputStream(currentFile));
            byte[] data = new byte[(int)currentFile.length()];
            di.readFully(data);
            di.close();
            FileOutputStream fos = new FileOutputStream(destFile);
            fos.write(data);
            fos.close();
        }
    }

    public static void copy(File source, File dest) throws IOException {
        Executor.copy(new FileInputStream(source), new FileOutputStream(dest));
    }

    public static void copyDirectory(File source, File dest) throws IOException {
        if (source.isDirectory()) {
            dest.mkdir();
            for (File child : source.listFiles()) {
                if (child.isDirectory()) {
                    Executor.copyDirectory(child, new File(dest, child.getName()));
                    continue;
                }
                Executor.copy(child, new File(dest, child.getName()));
            }
        } else {
            Executor.copy(source, dest);
        }
    }

    public static void copy(InputStream i, OutputStream o) throws IOException {
        Executor.copy(i, o, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream i, OutputStream o, int bufferSize) throws IOException {
        try {
            byte[] buffer = new byte[bufferSize];
            int size = i.read(buffer);
            while (size > -1) {
                o.write(buffer, 0, size);
                size = i.read(buffer);
            }
        }
        finally {
            Executor.cleanup(o);
            Executor.cleanup(i);
        }
    }

    public static void cleanup(Object o) {
        try {
            if (o instanceof OutputStream) {
                ((OutputStream)o).close();
                return;
            }
            if (o instanceof InputStream) {
                ((InputStream)o).close();
                return;
            }
        }
        catch (IOException err) {
            err.printStackTrace();
        }
    }

    public void unzip(File source, File classesDir, File resDir, File sourceDir) throws IOException {
        this.unzip(source, classesDir, resDir, sourceDir, resDir);
    }

    public void unzip(File source, File classesDir, File resDir, File sourceDir, File libsDir) throws IOException {
        this.unzip(source, classesDir, resDir, sourceDir, libsDir, resDir);
    }

    public void unzip(File source, File classesDir, File resDir, File sourceDir, File libsDir, File xmlDir) throws IOException {
        if (source.isDirectory()) {
            this.copyDir(source, classesDir, resDir, sourceDir, libsDir);
            return;
        }
        FileInputStream fi = new FileInputStream(source);
        this.unzip(fi, classesDir, resDir, sourceDir, libsDir, xmlDir);
    }

    public void unzip(InputStream source, File classesDir, File resDir, File sourceDir) throws IOException {
        this.unzip(source, classesDir, resDir, sourceDir, resDir, resDir);
    }

    public void unzip(InputStream source, File classesDir, File resDir, File sourceDir, File libsDir) throws IOException {
        this.unzip(source, classesDir, resDir, sourceDir, libsDir, resDir);
    }

    protected boolean useXMLDir() {
        return false;
    }

    protected boolean isDllResource() {
        return false;
    }

    public void unzip(InputStream source, File classesDir, File resDir, File sourceDir, File libsDir, File xmlDir) throws IOException {
        try {
            ZipEntry entry;
            BufferedOutputStream dest = null;
            ZipInputStream zis = new ZipInputStream(source);
            TarOutputStream tos = null;
            TarOutputStream podspecTos = null;
            TarOutputStream libTos = null;
            String dll = ".dll";
            if (this.isDllResource()) {
                dll = ".this isn't a valid extension";
            }
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                File destFile;
                byte[] data;
                String entryName = entry.getName();
                if (!"html.tar".equals(entryName) && (entryName.startsWith("html") || entryName.startsWith("/html"))) {
                    int count2;
                    if (entry.isDirectory()) continue;
                    if (tos == null) {
                        tos = new TarOutputStream(new FileOutputStream(new File(resDir, "html.tar")));
                    }
                    entryName = entryName.substring(5);
                    TarEntry tEntry = new TarEntry(new File(entryName), entryName);
                    tEntry.setSize(entry.getSize());
                    this.debug("Packaging entry " + entryName + " size: " + entry.getSize());
                    tos.putNextEntry(tEntry);
                    byte[] data2 = new byte[8192];
                    while ((count2 = zis.read(data2, 0, data2.length)) != -1) {
                        tos.write(data2, 0, count2);
                    }
                    continue;
                }
                if (entryName.startsWith("podspecs/") || entryName.startsWith("/podspecs/")) {
                    int count3;
                    int podSpecsPrefix;
                    if (entry.isDirectory()) continue;
                    int n = podSpecsPrefix = entryName.startsWith("podspecs/") ? "podspecs/".length() : "/podspecs/".length();
                    if (podspecTos == null) {
                        podspecTos = new TarOutputStream(new FileOutputStream(new File(resDir, "podspecs.tar")));
                    }
                    entryName = entryName.substring(podSpecsPrefix);
                    TarEntry tEntry = new TarEntry(new File(entryName), entryName);
                    tEntry.setSize(entry.getSize());
                    this.debug("Packaging entry " + entryName + " size: " + entry.getSize());
                    podspecTos.putNextEntry(tEntry);
                    byte[] byArray = data = entry.getSize() >= 819200L ? new byte[819200] : new byte[8192];
                    while ((count3 = zis.read(data, 0, data.length)) != -1) {
                        podspecTos.write(data, 0, count3);
                    }
                    continue;
                }
                if (entryName.startsWith("javase.lib/") || entryName.startsWith("/javase.lib/")) {
                    int count4;
                    int libPrefix;
                    if (entry.isDirectory()) continue;
                    int n = libPrefix = entryName.startsWith("javase.lib/") ? "javase.lib/".length() : "/javase.lib/".length();
                    if (libTos == null) {
                        libTos = new TarOutputStream(new FileOutputStream(new File(resDir, "javase.lib.tar")));
                    }
                    entryName = entryName.substring(libPrefix);
                    TarEntry tEntry = new TarEntry(new File(entryName), entryName);
                    tEntry.setSize(entry.getSize());
                    this.debug("Packaging entry " + entryName + " size: " + entry.getSize());
                    libTos.putNextEntry(tEntry);
                    byte[] byArray = data = entry.getSize() >= 819200L ? new byte[819200] : new byte[8192];
                    while ((count4 = zis.read(data, 0, data.length)) != -1) {
                        libTos.write(data, 0, count4);
                    }
                    continue;
                }
                if (entry.isDirectory()) {
                    File dir = new File(classesDir, entryName);
                    dir.mkdirs();
                    dir = new File(resDir, entryName);
                    dir.mkdirs();
                    dir = new File(sourceDir, entryName);
                    dir.mkdirs();
                    continue;
                }
                byte[] data3 = new byte[8192];
                if (entryName.endsWith(".class")) {
                    if (entryName.endsWith("module-info.class")) {
                        this.log("!!!!Skipping " + entryName);
                        continue;
                    }
                    destFile = new File(classesDir, entryName);
                } else {
                    destFile = entryName.endsWith(".java") || entryName.endsWith(".m") || entryName.endsWith(".h") || entryName.endsWith(".cs") ? new File(sourceDir, entryName) : (entryName.endsWith(".jar") || entryName.endsWith(".a") || entryName.endsWith(".dylib") || entryName.endsWith(".andlib") || entryName.endsWith(".aar") || entryName.endsWith(dll) ? new File(libsDir, entryName) : (this.useXMLDir() && entryName.endsWith(".xml") ? this.placeXMLFile(entry, xmlDir, resDir) : (entryName.equals("codenameone_settings.properties") ? new File(sourceDir.getParentFile(), entryName) : new File(resDir, entryName))));
                }
                destFile.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(destFile);
                dest = new BufferedOutputStream(fos, data3.length);
                while ((count = zis.read(data3, 0, data3.length)) != -1) {
                    dest.write(data3, 0, count);
                }
                dest.flush();
                dest.close();
            }
            if (tos != null) {
                tos.close();
            }
            if (podspecTos != null) {
                podspecTos.close();
            }
            if (libTos != null) {
                libTos.close();
            }
            zis.close();
            source.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void extractZip(InputStream source, File destDir, ExtractionFilter filter) throws IOException {
        try {
            ZipEntry entry;
            BufferedOutputStream dest = null;
            ZipInputStream zis = new ZipInputStream(source);
            String currentDir = null;
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                String entryName = entry.getName();
                this.debug("Extracting " + entryName);
                if (entry.isDirectory()) {
                    currentDir = entryName;
                    File dir = new File(destDir, entryName);
                    dir.mkdirs();
                    continue;
                }
                byte[] data = new byte[8192];
                File destFile = filter.destFile(currentDir, entryName);
                destFile.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(destFile);
                dest = new BufferedOutputStream(fos, data.length);
                while ((count = zis.read(data, 0, data.length)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
            source.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected File placeXMLFile(ZipEntry entry, File xmlDir, File resDir) {
        boolean putInXMLDir = false;
        String name = entry.getName();
        if (name.contains("/")) {
            if ((name = name.substring(0, name.lastIndexOf("/"))).contains("/")) {
                if ((name = name.substring(name.lastIndexOf("/"))).equalsIgnoreCase("xml")) {
                    putInXMLDir = true;
                }
            } else if (name.equalsIgnoreCase("xml")) {
                putInXMLDir = true;
            }
            name = entry.getName();
            name = name.substring(name.lastIndexOf("/") + 1, name.length());
        }
        if (putInXMLDir) {
            return new File(xmlDir, name);
        }
        return new File(resDir, entry.getName());
    }

    public int executeProcess(ProcessBuilder pb) throws Exception {
        return this.executeProcess(pb, -1);
    }

    public boolean exec(File dir, String ... varArgs) throws Exception {
        return this.exec(dir, -1, varArgs);
    }

    public String execStringWithThrow(boolean withThrow, File dir, String ... varArgs) throws Exception {
        this.message.append("Executing: ");
        for (String s : varArgs) {
            this.message.append(s);
            this.message.append(" ");
        }
        if (is_windows && varArgs[0].indexOf(46) < 0) {
            varArgs[0] = varArgs[0] + ".exe";
        }
        StringBuilder response = new StringBuilder();
        ProcessBuilder p = new ProcessBuilder(varArgs).directory(dir);
        p.environment().putAll(this.defaultEnvironment);
        int val = this.executeProcess(p, -1, response);
        if (val != 0) {
            if (withThrow) {
                throw new IOException("Exec failed with response code " + val);
            }
            return "";
        }
        return response.toString();
    }

    public String execString(File dir, String ... varArgs) throws Exception {
        return this.execStringWithThrow(false, dir, varArgs);
    }

    public boolean exec(File dir, Map<String, String> env, String ... varArgs) throws Exception {
        return this.exec(dir, (File)null, -1, env, varArgs);
    }

    public boolean exec(File dir, Map<String, String> env, int timeout, String ... varArgs) throws Exception {
        return this.exec(dir, (File)null, timeout, env, varArgs);
    }

    public boolean exec(File dir, int timeout, String ... varArgs) throws Exception {
        return this.exec(dir, (File)null, timeout, varArgs);
    }

    protected synchronized void log(String s) {
        this.log(s, true);
    }

    protected synchronized void debug(String s) {
        if (this.logger != null) {
            this.logger.debug((CharSequence)s);
            return;
        }
    }

    protected synchronized void warn(String s) {
        if (this.logger != null) {
            this.logger.warn((CharSequence)s);
            return;
        }
    }

    protected synchronized void warn(String s, Throwable ex) {
        if (this.logger != null) {
            this.logger.warn((CharSequence)s, ex);
            return;
        }
    }

    protected synchronized void error(String s, Throwable ex) {
        if (this.logger != null) {
            this.logger.error((CharSequence)s, ex);
            return;
        }
    }

    protected synchronized void log(String s, boolean ln) {
        if (this.logger != null) {
            this.logger.info((CharSequence)s);
            return;
        }
        if (this.logToSystemOut) {
            if (ln) {
                System.out.println(s);
            } else {
                System.out.print(s);
            }
        }
        this.message.append(s);
        if (ln) {
            this.message.append('\n');
        }
    }

    public boolean exec(File dir, File javaHome, int timeout, String ... varArgs) throws Exception {
        return this.exec(dir, javaHome, timeout, (Map<String, String>)null, varArgs);
    }

    public boolean exec(File dir, File javaHome, int timeout, Map<String, String> env, String ... varArgs) throws Exception {
        int val;
        this.log("Executing: ");
        this.message.append("Executing: ");
        StringBuilder logSb = new StringBuilder();
        for (String s : varArgs) {
            logSb.append(s + " ");
            this.message.append(s);
            this.message.append(" ");
        }
        this.log(logSb.toString());
        if (is_windows && varArgs[0].indexOf(46) < 0) {
            varArgs[0] = varArgs[0] + ".exe";
        }
        ProcessBuilder p = new ProcessBuilder(varArgs).directory(dir);
        p.environment().putAll(this.defaultEnvironment);
        if (env != null) {
            p.environment().putAll(env);
        }
        if (javaHome != null) {
            p.environment().put("JAVA_HOME", javaHome.getAbsolutePath());
            p.environment().put("java.home", javaHome.getAbsolutePath());
        }
        return (val = this.executeProcess(p, timeout)) == 0;
    }

    public int executeProcess(ProcessBuilder pb, int timeout) throws Exception {
        return this.executeProcess(pb, timeout, this.message);
    }

    private boolean hasCloning(String str) {
        Pattern p = Pattern.compile("Cloning spec repo `.*` from `*`");
        Matcher m = p.matcher(str);
        return m.find();
    }

    private boolean hasGitFetch(String str) {
        Pattern p = Pattern.compile("git -C .* fetch origin --progress");
        Matcher m = p.matcher(str);
        return m.find();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeProcess(ProcessBuilder pb, final int timeout, final StringBuilder outputMessage) throws Exception {
        this.log("Executing with timeout " + timeout);
        pb.redirectErrorStream(true);
        final Process p = pb.start();
        final boolean[] destroyed = new boolean[]{false};
        final InputStream stream = p.getInputStream();
        final boolean[] running = new boolean[]{true};
        try {
            new Thread(){

                @Override
                public void run() {
                    try {
                        byte[] buffer = new byte[8192];
                        int i = stream.read(buffer);
                        while (i > -1) {
                            String str = new String(buffer, 0, i);
                            Executor.this.log(str, false);
                            outputMessage.append(str);
                            i = stream.read(buffer);
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        outputMessage.append("Exception on appending to log: " + ex);
                    }
                }
            }.start();
            if (timeout > -1) {
                new Thread(){

                    @Override
                    public void run() {
                        long t = System.currentTimeMillis();
                        while (running[0] && !destroyed[0]) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (System.currentTimeMillis() - t <= (long)timeout) continue;
                            Executor.this.log("Timeout reached.  Destroying process");
                            destroyed[0] = true;
                            p.destroyForcibly();
                        }
                    }
                }.start();
            }
            int val = p.waitFor();
            if (destroyed[0]) {
                this.log("Process timed out");
                int n = 1;
                return n;
            }
            running[0] = false;
            this.log("Process return code is " + val);
            int n = val;
            return n;
        }
        finally {
            running[0] = false;
        }
    }

    public void createFile(File f, byte[] b) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        out.write(b);
        out.close();
    }

    public File findFile(File rootFolder, String filename) {
        for (File f : rootFolder.listFiles()) {
            File c;
            if (f.isDirectory() && (c = this.findFile(f, filename)) != null) {
                return c;
            }
            if (!f.getName().equalsIgnoreCase(filename)) continue;
            return f;
        }
        return null;
    }

    public File findFileType(File rootFolder, String fileExtension) {
        fileExtension = fileExtension.toLowerCase();
        for (File f : rootFolder.listFiles()) {
            if (!f.getName().toLowerCase().endsWith(fileExtension)) continue;
            return f;
        }
        for (File f : rootFolder.listFiles()) {
            File c;
            if (!f.isDirectory() || (c = this.findFileType(f, fileExtension)) == null) continue;
            return c;
        }
        return null;
    }

    public File findFileTypeNoRecursion(File rootFolder, String fileExtension) {
        return this.findFileTypeNoRecursion(rootFolder, fileExtension, false);
    }

    public File findFileTypeNoRecursion(File rootFolder, String fileExtension, boolean allowDirectories) {
        fileExtension = fileExtension.toLowerCase();
        for (File f : rootFolder.listFiles()) {
            if (!allowDirectories && f.isDirectory() || !f.getName().toLowerCase().endsWith(fileExtension)) continue;
            return f;
        }
        return null;
    }

    public void createFile(File f, InputStream i) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        byte[] buffer = new byte[8192];
        int size = i.read(buffer);
        while (size > -1) {
            out.write(buffer, 0, size);
            size = i.read(buffer);
        }
        out.close();
        i.close();
    }

    public static void zipDir(String zipFileName, String dir) throws Exception {
        File dirObj = new File(dir);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFileName));
        Executor.addDir(dirObj, dirObj, out);
        out.close();
    }

    public static void zipDir(String zipFileName, String dir, String ... exclude) throws Exception {
        File dirObj = new File(dir);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFileName));
        Executor.addDir(dirObj, dirObj, out, exclude);
        out.close();
    }

    static void addDir(File baseDir, File dirObj, ZipOutputStream out) throws IOException {
        Executor.addDir(baseDir, dirObj, out, null);
    }

    /*
     * Could not resolve type clashes
     */
    static void addDir(File baseDir, File dirObj, ZipOutputStream out, String ... exclude) throws IOException {
        File[] files = dirObj.listFiles();
        byte[] tmpBuf = new byte[8192];
        for (int i = 0; i < files.length; ++i) {
            int len;
            if (files[i].isDirectory()) {
                boolean found = false;
                if (exclude != null) {
                    ArrayList<Object> excludeNames = new ArrayList<Object>();
                    for (Object ex : exclude) {
                        if (((String)ex).indexOf("/") > -1) continue;
                        excludeNames.add(ex);
                    }
                    for (String ex : excludeNames) {
                        if (!files[i].getName().equalsIgnoreCase(ex)) continue;
                        found = true;
                    }
                }
                if (found) continue;
                ArrayList<String> newExcludes = new ArrayList<String>();
                if (exclude != null) {
                    for (Object ex : exclude) {
                        if (((String)ex).indexOf("/") <= -1) continue;
                        newExcludes.add(((String)ex).substring(((String)ex).indexOf("/") + 1));
                    }
                }
                Executor.addDir(baseDir, files[i], out, newExcludes.toArray(new String[newExcludes.size()]));
                continue;
            }
            FileInputStream in = new FileInputStream(files[i].getAbsolutePath());
            out.putNextEntry(new ZipEntry(files[i].getAbsolutePath().substring(baseDir.getAbsolutePath().length() + 1).replace('\\', '/')));
            while ((len = in.read(tmpBuf)) >= 0) {
                out.write(tmpBuf, 0, len);
            }
            out.closeEntry();
            in.close();
        }
    }

    protected BufferedImage getScaledUnevenInstance(BufferedImage img, int targetWidth, int targetHeight) {
        Rectangle rec2;
        Rectangle rec1;
        int imageY;
        int imageX;
        int ar;
        if (targetWidth < targetHeight) {
            ar = targetWidth;
            imageX = 0;
            imageY = targetHeight / 2 - targetWidth / 2;
            rec1 = new Rectangle(0, 0, targetWidth, imageY);
            rec2 = new Rectangle(0, targetHeight, targetWidth, imageY);
        } else {
            ar = targetHeight;
            imageY = 0;
            imageX = targetWidth / 2 - targetHeight / 2;
            rec1 = new Rectangle(0, 0, imageX, targetHeight);
            rec2 = new Rectangle(imageX + targetWidth, 0, imageX, targetHeight);
        }
        BufferedImage bi = this.getScaledInstance(img, ar, ar);
        BufferedImage b2 = new BufferedImage(targetWidth, targetHeight, 2);
        int array = bi.getRGB(0, 0);
        Graphics2D g2d = b2.createGraphics();
        if ((array & 0xFF000000) != 0) {
            g2d.setColor(new Color(array, true));
            g2d.fill(rec2);
            g2d.fill(rec1);
        }
        g2d.drawImage((Image)bi, imageX, imageY, null);
        g2d.dispose();
        return b2;
    }

    protected BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight) {
        BufferedImage ret = img;
        int w = img.getWidth();
        int h = img.getHeight();
        if (w < targetWidth && h < targetHeight) {
            BufferedImage b = new BufferedImage(targetWidth, targetHeight, img.getType());
            Graphics2D g2d = b.createGraphics();
            g2d.drawImage(img, 0, 0, targetWidth, targetHeight, null);
            g2d.dispose();
            return b;
        }
        do {
            if (w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, 2);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }

    public String getBuildKey() {
        return this.buildKey;
    }

    public void setBuildKey(String buildKey) {
        this.buildKey = buildKey;
    }

    protected boolean deriveGlobalInstrumentClasspath() {
        return false;
    }

    private void instrument(String classpath, File directory, File root, List<String> methodNames) throws Exception {
        for (File f : directory.listFiles()) {
            CtConstructor[] cons;
            CtMethod[] mtds;
            if (f.isDirectory()) {
                this.instrument(classpath, f, root, methodNames);
                continue;
            }
            if (!f.getName().endsWith(".class") || f.getName().endsWith("CodenameOneThread.class")) continue;
            ClassPool pool = new ClassPool(this.deriveGlobalInstrumentClasspath());
            pool.appendClassPath(root.getAbsolutePath());
            if (classpath != null) {
                pool.appendClassPath(classpath);
            }
            String name = f.getAbsolutePath().substring(root.getAbsolutePath().length() + 1);
            name = name.substring(0, name.length() - 6);
            name = name.replace(File.separatorChar, '.');
            DataInputStream fi = new DataInputStream(new FileInputStream(f));
            CtClass cls = pool.makeClass((InputStream)fi);
            fi.close();
            CtClass runtimeException = pool.get("java.lang.RuntimeException");
            methodNames.add(name);
            for (CtMethod mtd : mtds = cls.getDeclaredMethods()) {
                if (mtd.isEmpty() || mtd.getMethodInfo().getCodeAttribute() == null) continue;
                methodNames.add(mtd.getName());
                int mid = methodNames.size();
                mtd.insertBefore("{ com.codename1.impl.CodenameOneThread.push(" + mid + "); }");
                mtd.insertAfter("{ com.codename1.impl.CodenameOneThread.pop(); }", true);
                mtd.addCatch("{ com.codename1.impl.CodenameOneThread.storeStack($e, " + mid + "); throw $e; }", runtimeException);
                for (CtClass ex : mtd.getExceptionTypes()) {
                    mtd.addCatch("{ com.codename1.impl.CodenameOneThread.storeStack($e, " + mid + "); throw $e; }", ex);
                }
            }
            for (CtConstructor con : cons = cls.getDeclaredConstructors()) {
                if (con.isEmpty() || con.getMethodInfo().getCodeAttribute() == null) continue;
                methodNames.add(con.getName());
                int mid = methodNames.size();
                con.insertBefore("{ com.codename1.impl.CodenameOneThread.push(" + mid + "); }");
                con.insertAfter("{ com.codename1.impl.CodenameOneThread.pop(); }", true);
                con.addCatch("{ com.codename1.impl.CodenameOneThread.storeStack($e, " + mid + "); throw $e; }", runtimeException);
                for (CtClass ex : con.getExceptionTypes()) {
                    con.addCatch("{ com.codename1.impl.CodenameOneThread.storeStack($e, " + mid + "); throw $e; }", ex);
                }
            }
            FileOutputStream fo = new FileOutputStream(f);
            fo.write(cls.toBytecode());
            fo.close();
        }
    }

    public File getResourceAsFile(String res, String extension) throws IOException {
        File tmp = File.createTempFile("temp", extension);
        tmp.deleteOnExit();
        InputStream is = this.getResourceAsStream(res);
        if (is == null) {
            throw new IOException("Resource not found: " + res);
        }
        FileOutputStream o = new FileOutputStream(tmp);
        Executor.copy(is, o);
        return tmp;
    }

    public InputStream getResourceAsStream(String res) {
        InputStream s = Executor.class.getResourceAsStream(res);
        if (s != null) {
            return s;
        }
        return null;
    }

    public File getFileObject(File f) {
        return f;
    }

    protected boolean isUnitTestMode() {
        return this.unitTestMode;
    }

    public void setUnitTestMode(boolean unitTestMode) {
        this.unitTestMode = unitTestMode;
    }

    protected void generateUnitTestFiles(BuildRequest req, File stubDir) throws IOException {
        if (this.unitTestMode) {
            String actualMainClass = req.getMainClass();
            req.putArgument("j2me.obfuscation", "false");
            req.setMainClass("CodenameOneUnitTestExecutor");
            String testLogger = req.getArg("build.testReporter", null);
            String testReporter = "";
            if (testLogger != null) {
                testReporter = "        TestReporting.setInstance(new " + testLogger + "());\n";
            }
            File outputFile = new File(stubDir, req.getPackageName().replace('.', File.separatorChar) + File.separatorChar + "CodenameOneUnitTestExecutor.java");
            outputFile.getParentFile().mkdirs();
            FileOutputStream fo = new FileOutputStream(outputFile);
            fo.write(("package " + req.getPackageName() + ";\n\nimport com.codename1.testing.DeviceRunner;\nimport com.codename1.testing.TestReporting;\n\npublic class CodenameOneUnitTestExecutor extends DeviceRunner {\n    private " + actualMainClass + " instance;\n    private Object context;\n\n    protected void startApplicationInstance() {\n        instance = new " + actualMainClass + "();\n        instance.init(context);\n        instance.start();\n    }\n\n\n    protected void stopApplicationInstance() {\n        instance.stop();\n        instance.destroy();\n        instance = null;\n    }\n\n\n    public void init(Object ctx) {\n        context = ctx;\n" + testReporter + "    }\n\n\n    public void start() {\n        runTests();\n    }\n\n\n    public void stop() {\n    }\n\n\n    public void destroy() {\n    }\n\n\n}\n").getBytes());
            fo.close();
        }
    }

    public String decodeFunction() {
        this.debug("Using xorDecode function");
        return "    public String d(String s) {\n        return com.codename1.io.Util.xorDecode(s);\n    }\n\n";
    }

    public String xorEncode(String s) {
        try {
            if (s == null) {
                return null;
            }
            byte[] dat = s.getBytes("UTF-8");
            for (int iter = 0; iter < dat.length; ++iter) {
                dat[iter] = (byte)(dat[iter] ^ iter % 254 + 1);
            }
            return Base64.encodeNoNewline(dat);
        }
        catch (UnsupportedEncodingException err) {
            err.printStackTrace();
            return null;
        }
    }

    private ClassLoader getCodenameOneJarClassLoader() throws IOException {
        if (this.codenameOneJar == null) {
            throw new IllegalStateException("Must set codenameOneJar in Executor");
        }
        return new URLClassLoader(new URL[]{this.codenameOneJar.toURI().toURL()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getLocalBuilderProperties() {
        if (this.localBuilderProperties == null) {
            String sep = File.separator;
            File propertiesFile = new File(System.getProperty("user.home") + sep + ".codenameone" + sep + "local.properties");
            this.localBuilderProperties = new Properties();
            if (!propertiesFile.exists()) {
                return this.localBuilderProperties;
            }
            try (FileInputStream fis = new FileInputStream(propertiesFile);){
                this.localBuilderProperties.load(fis);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to load local properties", ex);
            }
        }
        return this.localBuilderProperties;
    }

    static {
        is_windows = File.separatorChar == '\\';
        IS_MAC = System.getProperty("os.name").toLowerCase().indexOf("mac") > -1;
    }

    public static interface ExtractionFilter {
        public File destFile(String var1, String var2);
    }

    public static interface InternalClassRemapper {
        public String remapClass(String var1);
    }

    public static interface ClassScanner {
        public void usesClass(String var1);

        public void usesClassMethod(String var1, String var2);
    }
}

