/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.builders;

import com.codename1.builders.BuildException;
import com.codename1.builders.BuildRequest;
import com.codename1.builders.Executor;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IPhoneBuilder
extends Executor {
    private boolean useMetal;
    private boolean enableGalleryMultiselect;
    private boolean usePhotoKitForMultigallery;
    private boolean enableWKWebView;
    private boolean disableUIWebView;
    private String pod = "/usr/local/bin/pod";
    private int podTimeout = 300000;
    private int xcodeVersion;
    private static final String GOOGLE_SIGNIN_TUTORIAL_URL = "http://www.codenameone.com/...";
    private File resultDir;
    private boolean includePush;
    private File tmpFile;
    private File icon57;
    private File icon512;
    private static final String DEFAULT_MIN_DEPLOYMENT_VERSION = "12.0";
    private StringBuilder installLocalizedStringsScript = new StringBuilder();
    private boolean detectJailbreak;
    private boolean runPods = false;
    private boolean photoLibraryUsage;
    private String buildVersion;
    private boolean usesLocalNotifications;
    private boolean usesPurchaseAPI;
    private Map<String, String> privacyUsageDescriptions = new HashMap<String, String>();
    static final int majorOSVersion;
    static final int minorOSVersion;
    static final String osVersion;
    private String minDeploymentTargets = "12.0";
    private File xcodeProjectDir;
    private GoogleServicePlist googleServicePlist;

    @Override
    public void cleanup() {
        super.cleanup();
    }

    private static String maxVersionString(String commaDelimitedVersions) {
        String[] versions = commaDelimitedVersions.split(",");
        String currMax = "0.0";
        for (String version : versions) {
            if ((version = version.trim()).length() == 0 || IPhoneBuilder.compareVersionStrings(version, currMax) <= 0) continue;
            currMax = version;
        }
        return currMax;
    }

    private static int compareVersionStrings(String v1, String v2) {
        String[] p1 = v1.split("\\.");
        String[] p2 = v2.split("\\.");
        int len = Math.max(p1.length, p2.length);
        for (int i = 0; i < len; ++i) {
            int iPart2;
            int iPart1 = p1.length > i ? Integer.parseInt(p1[i]) : 0;
            int n = iPart2 = p2.length > i ? Integer.parseInt(p2[i]) : 0;
            if (iPart1 == iPart2) continue;
            return iPart1 < iPart2 ? -1 : 1;
        }
        return 0;
    }

    @Override
    protected String getDeviceIdCode() {
        return "\"\"";
    }

    private boolean validateLC_MIN_VERSION(File file) throws IOException {
        ProcessBuilder pb = new ProcessBuilder("otool", "-lv", file.getAbsolutePath());
        Process p = pb.start();
        InputStream is = p.getInputStream();
        Scanner scanner = new Scanner(is);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (!line.contains("LC_VERSION_MIN_")) continue;
            return true;
        }
        try {
            p.waitFor();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(IPhoneBuilder.class.getName()).log(Level.SEVERE, null, ex);
            this.log(ex.getMessage());
        }
        return false;
    }

    private File getResDir() {
        return new File(this.tmpFile, "res");
    }

    private File getBuildinRes() {
        return new File(this.tmpFile, "btres");
    }

    private void addMinDeploymentTarget(String target) {
        this.minDeploymentTargets = this.minDeploymentTargets + "," + target;
    }

    private String getDeploymentTarget(BuildRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.minDeploymentTargets);
        if (request.getArg("ios.pods.platform", null) != null) {
            sb.append(",");
            sb.append(request.getArg("ios.pods.platform", ""));
        }
        if (request.getArg("ios.deployment_target", null) != null) {
            sb.append(",");
            sb.append(request.getArg("ios.deployment_target", ""));
        }
        if (request.getArg("ios.minDeploymentTarget", null) != null) {
            sb.append(",");
            sb.append(request.getArg("ios.minDeploymentTarget", ""));
        }
        return IPhoneBuilder.maxVersionString(sb.toString());
    }

    private static String append(String str, String separator, String append) {
        if (!str.trim().endsWith(separator)) {
            str = str + separator;
        }
        return str + append;
    }

    private int getDeploymentTargetInt(BuildRequest request) {
        String target = this.getDeploymentTarget(request);
        if (target.indexOf(".") > 0) {
            target = target.substring(0, target.indexOf("."));
        }
        return Integer.parseInt(target);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public boolean build(File sourceZip, BuildRequest request) throws BuildException {
        this.addMinDeploymentTarget("12.0");
        this.detectJailbreak = request.getArg("ios.detectJailbreak", "false").equals("true");
        this.defaultEnvironment.put("LANG", "en_US.UTF-8");
        this.tmpFile = this.tmpDir = this.getBuildDirectory();
        this.useMetal = "true".equals(request.getArg("ios.metal", "false"));
        try {
            this.log("Pods version: " + this.execString(new File("."), new String[]{this.pod, "--version"}));
        }
        catch (Exception ex) {
            this.error("Please install Cocoapods in order to generate Xcode projects.  E.g. 'sudo gem install cocoapods'.  See https://cocoapods.org/", ex);
            throw new BuildException("Please install Cocoapods in order to generate Xcode projects.  E.g. 'sudo gem install cocoapods'.  See https://cocoapods.org/");
        }
        this.log("Request Args: ");
        this.log("-----------------");
        for (String arg : request.getArgs()) {
            this.log(arg + "=" + request.getArg(arg, null));
        }
        this.log("-------------------");
        this.buildVersion = request.getVersion();
        if (request.getArg("ios.twoDigitVersion", "false").equals("true")) {
            try {
                version = Float.parseFloat(this.buildVersion);
                intVersion = Math.round(100.0f * version);
                lsb = intVersion % 100;
                this.buildVersion = "" + intVersion / 100 + ".";
                this.buildVersion = lsb == 0 ? this.buildVersion + "00" : (lsb < 10 ? this.buildVersion + "0" + lsb : this.buildVersion + lsb);
            }
            catch (Exception version) {
                // empty catch block
            }
        }
        for (String arg : request.getArgs()) {
            if (!arg.startsWith("ios.NS") || !arg.endsWith("UsageDescription")) continue;
            if (arg.toUpperCase().contains("PHOTOLIBRARY")) {
                this.photoLibraryUsage = true;
            }
            this.privacyUsageDescriptions.put(arg.substring(arg.lastIndexOf(".") + 1), request.getArg(arg, null));
        }
        iosPods = request.getArg("ios.pods", "");
        this.enableGalleryMultiselect = "true".equals(request.getArg("ios.enableGalleryMultiselect", "false"));
        if (this.enableGalleryMultiselect && !iosPods.contains("QBImagePickerController") && this.photoLibraryUsage) {
            if (!iosPods.endsWith(",")) {
                iosPods = iosPods + ",";
            }
            iosPods = iosPods + "QBImagePickerController ~> 3.4";
            this.addMinDeploymentTarget("8.0");
        }
        this.usePhotoKitForMultigallery = "true".equals(request.getArg("ios.usePhotoKitForMultigallery", "false"));
        this.enableWKWebView = "true".equals(request.getArg("ios.useWKWebView", "true"));
        if (this.enableWKWebView) {
            this.addMinDeploymentTarget("8.0");
        }
        this.disableUIWebView = this.enableWKWebView != false && "true".equals(request.getArg("ios.noUIWebView", "true")) != false;
        bicodeHandle = true;
        xcodebuild = "xcodebuild";
        this.xcodeVersion = this.getXcodeVersion(xcodebuild);
        if (this.xcodeVersion <= 0) {
            this.xcodeVersion = 10;
        }
        facebookAppId = request.getArg("facebook.appId", null);
        if (!new File(this.pod).exists()) {
            this.pod = "/usr/bin/pod";
            if (!new File(this.pod).exists()) {
                this.log("You need to install cocoapods to proceed, to install cocoapods on your mac issue this command in the terminal: sudo gem install cocoapods --pre\nfollowed by: sudo gem install xcodeproj");
                return false;
            }
        }
        v0 = usePodsForFacebook = request.getArg("ios.facebook.usePods", "true").equals("false") == false && facebookAppId != null && facebookAppId.length() > 0;
        if (usePodsForFacebook) {
            fbPodsVersion = request.getArg("ios.facebook.version", "~>5.6.0");
            this.addMinDeploymentTarget("10.0");
            iosPods = iosPods + (iosPods.length() > 0 ? "," : "") + "FBSDKCoreKit " + fbPodsVersion + ",FBSDKLoginKit " + fbPodsVersion + ",FBSDKShareKit " + fbPodsVersion;
        }
        this.runPods = true;
        googleAdUnitId = request.getArg("ios.googleAdUnitId", request.getArg("google.adUnitId", null));
        v1 = usePodsForGoogleAds = this.runPods != false && googleAdUnitId != null && googleAdUnitId.length() > 0;
        if (usePodsForGoogleAds) {
            iosPods = iosPods + (iosPods.length() > 0 ? "," : "") + "Firebase/Core,Firebase/AdMob";
            this.addMinDeploymentTarget("7.0");
        }
        if (this.enableGalleryMultiselect && this.photoLibraryUsage) {
            this.addMinDeploymentTarget("8.0");
        }
        if (this.enableWKWebView) {
            this.addMinDeploymentTarget("8.0");
        }
        this.debug("Xcode version is " + this.xcodeVersion);
        iosMode = request.getArg("ios.themeMode", "auto");
        this.tmpFile = this.getBuildDirectory();
        if (this.tmpFile == null) {
            throw new IllegalStateException("Build directory must be set before running build.");
        }
        if (this.tmpFile.exists()) {
            IPhoneBuilder.delTree(this.tmpFile);
        }
        this.tmpFile.mkdirs();
        classesDir = new File(this.tmpFile, "classes");
        classesDir.mkdirs();
        resDir = new File(this.tmpFile, "res");
        resDir.mkdirs();
        buildinRes = new File(this.tmpFile, "btres");
        buildinRes.mkdirs();
        try {
            this.unzip(sourceZip, classesDir, resDir, resDir, buildinRes);
        }
        catch (IOException ex) {
            throw new BuildException("Failed to unzip source Zip file.", ex);
        }
        variantGroups = new HashSet<String>();
        for (File child : resDir.listFiles()) {
            if (child.getName().endsWith(".lproj.zip")) {
                languageBase = child.getName().substring(0, child.getName().lastIndexOf(".lproj.zip"));
                languageDir = new File(new File(this.tmpDir, "dist"), languageBase + ".lproj");
                if (languageDir.exists()) {
                    IPhoneBuilder.delTree(languageDir, true);
                }
                languageDir.mkdirs();
                this.log("Found native strings directory " + child + ". Attempting extract it and add it to the project");
                try {
                    if (!this.exec(resDir, new String[]{"unzip", child.getName(), "-d", languageDir.getAbsolutePath()})) {
                        this.log("Failed to unzip " + child.getName());
                        return false;
                    }
                }
                catch (Exception ex) {
                    throw new BuildException("Failed to extract bundled strings directory " + child, ex);
                }
                if (languageDir.exists() && (nestedLanguageDir = new File(languageDir, languageDir.getName())).exists() && nestedLanguageDir.isDirectory()) {
                    var22_48 = nestedLanguageDir.listFiles();
                    var23_57 = var22_48.length;
                    for (var24_65 = 0; var24_65 < var23_57; ++var24_65) {
                        nestedStringsFile = var22_48[var24_65];
                        if (!nestedStringsFile.getName().endsWith(".strings")) continue;
                        destStringsFile = new File(languageDir, nestedStringsFile.getName());
                        try {
                            Files.copy(nestedStringsFile.toPath(), destStringsFile.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                            continue;
                        }
                        catch (IOException ex) {
                            this.log("Failed to reparent nested strings file " + nestedStringsFile + " to " + destStringsFile);
                        }
                    }
                    IPhoneBuilder.delTree((File)nestedLanguageDir, true);
                }
                if (!languageDir.exists()) {
                    this.log("Cannot find localization directory " + languageDir + " after extracting " + child + ".  Please ensure that the localization file is located in the top level of the zip file.");
                    return false;
                }
                nestedLanguageDir = languageDir.listFiles();
                var22_49 = ((File[])nestedLanguageDir).length;
                for (var23_57 = 0; var23_57 < var22_49; ++var23_57) {
                    stringsFile = nestedLanguageDir[var23_57];
                    if (!stringsFile.getName().endsWith(".strings")) continue;
                    if (this.installLocalizedStringsScript.length() == 0) {
                        this.installLocalizedStringsScript.append("variant_groups={}\n");
                    }
                    if (!variantGroups.contains(stringsFile.getName())) {
                        variantGroups.add(stringsFile.getName());
                        this.installLocalizedStringsScript.append("variant_group = xcproj.main_group.new_variant_group('").append(stringsFile.getName()).append("')\n");
                        this.installLocalizedStringsScript.append("variant_groups['").append(stringsFile.getName()).append("'] = variant_group\n");
                    }
                    this.installLocalizedStringsScript.append("fileref = variant_groups['").append(stringsFile.getName()).append("'].new_file('").append(languageDir.getName()).append("/").append(stringsFile.getName()).append("')\n");
                    this.installLocalizedStringsScript.append("xcproj.targets.each{|e| e.add_resources([fileref])}\n");
                }
                child.delete();
            }
            if (!child.getName().endsWith(".framework.zip")) continue;
            this.log("Found framework " + child + ". Attempting extract it and generate podspec for it");
            try {
                if (!this.exec(resDir, new String[]{"ditto", "-x", "-k", child.getAbsolutePath(), new File(this.tmpDir, "dist").getAbsolutePath()})) {
                    this.log("Failed to unzip " + child.getName());
                    return false;
                }
            }
            catch (Exception ex) {
                throw new BuildException("Failed to extract bundled framework " + child, ex);
            }
            frameworkBase = child.getName().substring(0, child.getName().lastIndexOf(".framework.zip"));
            frameworkFile = new File(new File(this.tmpDir, "dist"), frameworkBase + ".framework");
            if (!frameworkFile.exists()) {
                this.log("Cannot find framework file " + frameworkFile + " after extracting " + child + ".  Please ensure that the framework is located in the top level of the zip file.");
                return false;
            }
            podspecFile = new File(resDir, frameworkBase + ".podspec");
            podspecContents = new StringBuilder().append("Pod::Spec.new do |s|\n  s.name                    = \"" + frameworkBase + "\"\n  s.version                 = \"1.0.0\"\n  s.summary                 = \"" + frameworkBase + " framework\"\n  s.description             = \"This spec specifies a vendored framework.\"\n  s.platform                = :ios\n  s.homepage                = \"https://www.codenameone.com\"\n  s.source                  = {:path => \".\"}\n  s.author                  = \"Codename One\"\n  s.vendored_frameworks     = \"" + frameworkBase + ".framework\"\nend");
            this.log("Writing podspec " + podspecFile + " with contents:\n" + podspecContents.toString());
            fos = null;
            try {
                fos = new FileOutputStream(podspecFile);
                fos.write(podspecContents.toString().getBytes("UTF-8"));
            }
            catch (IOException ex) {
                throw new BuildException("Failed to write th podxspec file for bundled framework " + child, ex);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable var29_83) {}
                }
            }
            child.delete();
            iosPods = IPhoneBuilder.append(iosPods, ",", frameworkBase);
        }
        podSpecs = new File(this.tmpFile, "podspecs");
        podSpecs.mkdirs();
        try {
            for (File dir : new File[]{classesDir, resDir, buildinRes}) {
                for (File child : dir.listFiles()) {
                    if (child.getName().endsWith(".podspec")) {
                        Files.move(child.toPath(), new File(podSpecs, child.getName()).toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    }
                    if (!"podspecs.tar".equals(child.getName())) continue;
                    if (!this.exec(this.tmpFile, new String[]{"tar", "xvf", child.getAbsolutePath(), "-C", podSpecs.getAbsolutePath()})) {
                        this.log("Failed to extract podspecs tar file " + child.getAbsolutePath() + " to podspecs dir " + podSpecs.getAbsolutePath());
                        return false;
                    }
                    child.delete();
                }
            }
        }
        catch (Exception ex) {
            throw new BuildException("An error occurred while attempting to install bundled podspecs", ex);
        }
        googleServicePlistFile = new File(resDir, "GoogleService-Info.plist");
        googleClientId = null;
        useGoogleSignIn = false;
        if (googleServicePlistFile.exists()) {
            this.googleServicePlist = new GoogleServicePlist();
            dbFactory = DocumentBuilderFactory.newInstance();
            try {
                dBuilder = dbFactory.newDocumentBuilder();
                doc = dBuilder.parse(googleServicePlistFile);
            }
            catch (Exception ex) {
                throw new BuildException("Failed to parse google services Plist File", ex);
            }
            dict = (Element)doc.getElementsByTagName("dict").item(0);
            childNodes = dict.getChildNodes();
            len = childNodes.getLength();
            for (i = 0; i < len; ++i) {
                n = childNodes.item(i);
                if (!(n instanceof Element)) continue;
                e = (Element)n;
                if ("key".equals(e.getTagName()) && "CLIENT_ID".equals(e.getTextContent().trim())) {
                    nextEl = IPhoneBuilder.getNextElement(childNodes, i);
                    if (nextEl == null || !"string".equals(nextEl.getTagName())) continue;
                    this.googleServicePlist.clientId = googleClientId = nextEl.getTextContent().trim();
                    continue;
                }
                if ("key".equals(e.getTagName()) && "BUNDLE_ID".equals(e.getTextContent().trim())) {
                    nextEl = IPhoneBuilder.getNextElement(childNodes, i);
                    if (nextEl == null || !"string".equals(nextEl.getTagName()) || (bid = nextEl.getTextContent().trim()) != null && bid.equals(request.getPackageName())) continue;
                    this.debug("Bundle ID=" + request.getPackageName() + "; GoogleService BUNDLE_ID=" + bid);
                    this.debug("GoogleService-Info.plist file bundle ID does not match the App ID.  See http://www.codenameone.com/... for instructions on setting up GoogleSignIn");
                    this.log("GoogleService-Info.plist file bundle ID does not match the App ID.  See http://www.codenameone.com/... for instructions on setting up GoogleSignIn");
                    return false;
                }
                if ("key".equals(e.getTagName()) && "IS_SIGNIN_ENABLED".equals(e.getTextContent().trim())) {
                    nextEl = IPhoneBuilder.getNextElement(childNodes, i);
                    if (!"true".equals(nextEl.getTagName())) continue;
                    useGoogleSignIn = true;
                    this.googleServicePlist.useSignIn = true;
                    continue;
                }
                if (!"key".equals(e.getTagName()) || !"REVERSED_CLIENT_ID".equals(e.getTextContent().trim()) || (nextEl = IPhoneBuilder.getNextElement(childNodes, i)) == null || !"string".equals(nextEl.getTagName())) continue;
                this.googleServicePlist.reverseClientId = nextEl.getTextContent().trim();
            }
        }
        if (googleClientId == null && useGoogleSignIn) {
            this.log("GoogleService-Info.plist file specifies that GoogleSignIn should be used but it doesn't provide a client ID.  Likely the GoogleService-Info.plist file is not valid.  See http://www.codenameone.com/... for instructions on setting up GoogleSignIn");
            this.error("Fail 2", new RuntimeException("Need to provide GoogleService-Info.plist file"));
            return false;
        }
        if (googleClientId == null && (googleClientId = request.getArg("ios.gplus.clientId", null)) != null) {
            useGoogleSignIn = true;
        }
        if (useGoogleSignIn) {
            iosPods = iosPods + (iosPods.length() > 0 ? "," : "") + "GoogleSignIn ~>5.0.0";
            this.addMinDeploymentTarget("8.0");
        }
        try {
            if (!this.retrolambda(new File(System.getProperty("user.dir")), request, classesDir)) {
                return false;
            }
        }
        catch (Exception ex) {
            throw new BuildException("Error occurred while running retrolambda on project classes", ex);
        }
        try {
            this.scanClassesForPermissions(classesDir, new Executor.ClassScanner(){

                @Override
                public void usesClass(String cls) {
                    if (cls == null) {
                        return;
                    }
                    if (!IPhoneBuilder.this.usesLocalNotifications && cls.indexOf("com/codename1/notifications/LocalNotification") == 0) {
                        IPhoneBuilder.this.usesLocalNotifications = true;
                    }
                    if (!IPhoneBuilder.this.usesPurchaseAPI && cls.indexOf("com/codename1/payment") == 0) {
                        IPhoneBuilder.this.usesPurchaseAPI = true;
                    }
                }

                @Override
                public void usesClassMethod(String cls, String method) {
                }
            });
        }
        catch (Exception ex) {
            throw new BuildException("Failed to scan project classes for permissions.", ex);
        }
        this.debug("Local Notifications " + (this.usesLocalNotifications != false ? "enabled" : "disabled"));
        try {
            this.unzip(this.getResourceAsStream("/iOSPort.jar"), classesDir, buildinRes, buildinRes);
        }
        catch (IOException ex) {
            throw new BuildException("Failed to extract the iOSPort jar", ex);
        }
        foundImproperStaticLibs = false;
        try {
            for (File f : buildinRes.listFiles()) {
                if (!f.getName().endsWith(".a") || this.validateLC_MIN_VERSION(f)) continue;
                this.log("WARNING: The static library " + f.getName() + " is missing the LC_MIN_VERSION_IPHONEOS run command which is required by the Xcode build tools.  This generally means that it was compiled with an older version of Xcode which didn't include this command.  Unfortunately, Xcode 7 now requires this command to be embedded into all static libraries.  Please recompile this library with Xcode 7 or higher.  If this library has been embedded as part of a cn1lib, you will need to update the cn1lib with the newly compiled static library.  You may also want to look at changing the library to use Cocoapods instead of embedding the static lib directly.");
                foundImproperStaticLibs = true;
            }
        }
        catch (Exception ex) {
            throw new BuildException("Exception while trying to verify static libraries", ex);
        }
        if (foundImproperStaticLibs && "true".equals(request.getArg("ios.failOnWarning", "false"))) {
            this.log("Cancelling build due to static library warnings.  Set ios.failOnWarning build hint to 'false' to ignore these warnings.");
            return false;
        }
        try {
            this.unzip(this.getResourceAsStream("/nativeios.jar"), classesDir, buildinRes, buildinRes);
        }
        catch (IOException ex) {
            throw new BuildException("Failed to extract nativeios.jar", ex);
        }
        if (request.getArg("noExtraResources", "false").equals("true")) {
            new File(buildinRes, "CN1Resource.res").delete();
            new File(buildinRes, "IPhoneTheme.res").delete();
            new File(buildinRes, "iOS7Theme.res").delete();
        }
        if (this.useMetal) {
            try {
                CN1ES2compat = new File(buildinRes, "CN1ES2compat.h");
                this.replaceInFile(CN1ES2compat, "//#define CN1_USE_METAL", "#define CN1_USE_METAL");
                IPhoneBuilder.copy(new File(buildinRes, "MainWindowMETAL.xib"), new File(buildinRes, "MainWindow.xib"));
                IPhoneBuilder.copy(new File(buildinRes, "CodenameOne_METALViewController.xib"), new File(buildinRes, "CodenameOne_GLViewController.xib"));
            }
            catch (Exception ex) {
                throw new BuildException("Failed to inject Metal controllers", ex);
            }
        } else {
            new File(buildinRes, "MainWindowMETAL.xib").delete();
            new File(buildinRes, "CodenameOne_METALViewController.xib").delete();
        }
        moPubAdUnitId = request.getArg("ios.mopubId", null);
        moPubTabletAdUnitId = request.getArg("ios.mopubTabletId", moPubAdUnitId);
        if (moPubAdUnitId != null && moPubAdUnitId.length() > 0) {
            try {
                CodenameOne_GLViewController = new File(buildinRes, "CodenameOne_GLViewController.h");
                this.unzip(this.getResourceAsStream("/MoPubSDK_ios.zip"), classesDir, buildinRes, buildinRes);
                this.replaceInFile(CodenameOne_GLViewController, "//#define INCLUDE_MOPUB", "#define INCLUDE_MOPUB");
                this.replaceInFile(CodenameOne_GLViewController, "#define MOPUB_AD_UNIT", "#define MOPUB_AD_UNIT @\"" + moPubAdUnitId + "\"");
                this.replaceInFile(CodenameOne_GLViewController, "#define MOPUB_AD_SIZE", "#define MOPUB_AD_SIZE " + request.getArg("ios.mopubAdSize", "MOPUB_BANNER_SIZE"));
                this.replaceInFile(CodenameOne_GLViewController, "#define MOPUB_TABLET_AD_UNIT", "#define MOPUB_TABLET_AD_UNIT @\"" + moPubTabletAdUnitId + "\"");
                this.replaceInFile(CodenameOne_GLViewController, "#define MOPUB_TABLET_AD_SIZE", "#define MOPUB_TABLET_AD_SIZE " + request.getArg("ios.mopubTabletAdSize", "MOPUB_LEADERBOARD_SIZE"));
            }
            catch (Exception ex) {
                throw new BuildException("Failed to inject MoPubSDK");
            }
        }
        microphoneCallback = "";
        if (request.getArg("ios.headphoneCallback", "false").equals("true")) {
            try {
                headphoneDetectorM = new File(buildinRes, "HeadphonesDetector.m");
                headphoneDetectorH = new File(buildinRes, "HeadphonesDetector.h");
                this.replaceInFile(headphoneDetectorM, "//#define DETECT_HEADPHONE", "#define DETECT_HEADPHONE");
                this.replaceInFile(headphoneDetectorH, "//#define DETECT_HEADPHONE2", "#define DETECT_HEADPHONE2");
                microphoneCallback = "    public void headphonesDisconnected() {\n        i.headphonesDisconnected();\n    }\n\n    public void headphonesConnected() {\n        i.headphonesConnected();\n    }\n\n";
            }
            catch (Exception ex) {
                throw new BuildException("Failed to add microphone callbacks", ex);
            }
        }
        launchStoryboard = new File(buildinRes, "LaunchScreen-Default.storyboard");
        if (this.xcodeVersion < 9) {
            launchStoryboard.delete();
        }
        glAppDelegate = new File(buildinRes, "CodenameOne_GLAppDelegate.m");
        integrateFacebook = "";
        if (facebookAppId != null && facebookAppId.length() > 0) {
            try {
                if (!usePodsForFacebook) {
                    facebookFile = "/facebook-ios-sdk-4.12.zip";
                    this.unzip(this.getResourceAsStream(facebookFile), classesDir, buildinRes, buildinRes);
                }
                integrateFacebook = "        com.codename1.social.FacebookImpl.init(com.codename1.impl.ios.IOSImplementation.nativeInstance);\n        Display.getInstance().setProperty(\"facebook_app_id\", \"" + facebookAppId + "\");\n";
                this.replaceInFile(new File(buildinRes, "CodenameOne_GLViewController.h"), "//#define INCLUDE_FACEBOOK_CONNECT", "#define INCLUDE_FACEBOOK_CONNECT");
                if (usePodsForFacebook) {
                    this.replaceInFile(new File(buildinRes, "CodenameOne_GLViewController.h"), "//#define USE_FACEBOOK_CONNECT_PODS", "#define USE_FACEBOOK_CONNECT_PODS");
                }
                defaultPermissions = "\"public_profile\", \"email\", \"user_friends\"";
                permissions = request.getArg("ios.facebook_permissions", request.getArg("and.facebook_permissions", defaultPermissions));
                t = new StringTokenizer(permissions, " ,\n\r\t");
                permissions = "";
                permissions = permissions + "@" + t.nextToken();
                while (t.hasMoreTokens()) {
                    permissions = permissions + ", @" + t.nextToken();
                }
                this.replaceInFile(new File(buildinRes, "FacebookImpl.m"), "@\"basic_info\"", permissions);
            }
            catch (Exception ex) {
                throw new BuildException("Failed to add facebook api", ex);
            }
        }
        integrateGoogleConnect = "";
        if (useGoogleSignIn) {
            try {
                this.replaceInFile(new File(buildinRes, "CodenameOne_GLViewController.h"), "//#define INCLUDE_GOOGLE_CONNECT", "#define INCLUDE_GOOGLE_CONNECT");
                this.replaceInFile(new File(buildinRes, "CodenameOne_GLViewController.h"), "//#define GOOGLE_SIGNIN", "#define GOOGLE_SIGNIN");
                integrateGoogleConnect = "        com.codename1.social.GoogleImpl.init(com.codename1.impl.ios.IOSImplementation.nativeInstance);\n        Display.getInstance().setProperty(\"ios.gplus.clientId\", \"" + googleClientId + "\");\n";
            }
            catch (IOException ex) {
                throw new BuildException("Failed to inject google signin support", ex);
            }
        }
        if (enableBackgroundFetch = request.getArg("ios.background_modes", "").contains("fetch")) {
            try {
                this.replaceInFile(new File(buildinRes, "CodenameOne_GLViewController.h"), "//#define INCLUDE_CN1_BACKGROUND_FETCH", "#define INCLUDE_CN1_BACKGROUND_FETCH");
            }
            catch (IOException ex) {
                throw new BuildException("Failed to add background fetch support", ex);
            }
        }
        if (request.getArg("ios.usePrintf", "false").equals("true")) {
            try {
                this.replaceInFile(new File(buildinRes, "CodenameOne_GLViewController.h"), "#define CN1Log(str,...) NSLog(str,##__VA_ARGS__)", "#define CN1Log(str,...) printf([[NSString stringWithFormat:str,##__VA_ARGS__] UTF8String])");
            }
            catch (IOException ex) {
                throw new BuildException("Failed to process ios.usePrintf build hint");
            }
        }
        if (disableSignalHandler = request.getArg("ios.convertSignalsToExceptions", "true").equals("false")) {
            try {
                this.replaceInFile(new File(buildinRes, "CodenameOne_GLAppDelegate.m"), "installSignalHandlers();", "//installSignalHandlers();");
            }
            catch (IOException ex) {
                throw new BuildException("Failed to process ios.convertSignalsToExceptions build hint", ex);
            }
        }
        if (enableBackgroundLocation = request.getArg("ios.background_modes", "").contains("location")) {
            try {
                this.replaceInFile(new File(buildinRes, "CodenameOne_GLViewController.h"), "//#define CN1_ENABLE_BACKGROUND_LOCATION", "#define CN1_ENABLE_BACKGROUND_LOCATION");
            }
            catch (IOException ex) {
                throw new BuildException("Failed to process ios.background_modes location build hint", ex);
            }
        }
        if (this.enableGalleryMultiselect) {
            try {
                this.replaceInFile(new File(buildinRes, "CodenameOne_GLViewController.h"), "//#define ENABLE_GALLERY_MULTISELECT", "#define ENABLE_GALLERY_MULTISELECT");
            }
            catch (IOException ex) {
                throw new BuildException("Failed to enabled gallery multiselect support", ex);
            }
        }
        if (this.usePhotoKitForMultigallery) {
            try {
                this.replaceInFile(new File(buildinRes, "CodenameOne_GLViewController.h"), "//#define USE_PHOTOKIT_FOR_MULTIGALLERY", "#define USE_PHOTOKIT_FOR_MULTIGALLERY");
            }
            catch (IOException ex) {
                throw new BuildException("Failed to enabled gallery multiselect support", ex);
            }
        }
        if (this.enableWKWebView) {
            try {
                this.replaceInFile(new File(buildinRes, "CodenameOne_GLViewController.h"), "//#define ENABLE_WKWEBVIEW", "#define ENABLE_WKWEBVIEW");
            }
            catch (IOException ex) {
                throw new BuildException("Failure while enabing WKWebView support", ex);
            }
        }
        if (this.disableUIWebView) {
            try {
                this.replaceInFile(new File(buildinRes, "CodenameOne_GLViewController.h"), "//#define NO_UIWEBVIEW", "#define NO_UIWEBVIEW");
            }
            catch (IOException ex) {
                throw new BuildException("Failure while disabling UIWebView support", ex);
            }
        }
        if (this.xcodeVersion >= 9) {
            try {
                for (String[] privacyKey : this.privacyUsageDescriptions.keySet()) {
                    defKey = "INCLUDE_" + privacyKey.replace("UsageDescription", "_USAGE").substring(2).toUpperCase();
                    this.replaceInFile(new File(buildinRes, "CodenameOne_GLViewController.h"), "//#define " + defKey, "#define " + defKey);
                }
                if (request.getArg("ios.locationUsageDescription", null) == null) ** GOTO lbl444
                this.replaceInFile(new File(buildinRes, "CodenameOne_GLViewController.h"), "//#define INCLUDE_LOCATION_USAGE", "#define INCLUDE_LOCATION_USAGE");
            }
            catch (IOException ex) {
                throw new BuildException("Failed to add privacy usage descriptions", ex);
            }
        } else {
            this.photoLibraryUsage = true;
            defines = new String[]{"INCLUDE_CONTACTS_USAGE", "INCLUDE_CALENDARS_USAGE", "INCLUDE_CAMERA_USAGE", "INCLUDE_FACEID_USAGE", "INCLUDE_LOCATION_USAGE", "INCLUDE_MICROPHONE_USAGE", "INCLUDE_MOTION_USAGE", "INCLUDE_PHOTOLIBRARYADD_USAGE", "INCLUDE_PHOTOLIBRARY_USAGE", "INCLUDE_REMINDERS_USAGE", "INCLUDE_SIRI_USAGE", "INCLUDE_SPEECHRECOGNITION_USAGE", "INCLUDE_NFCREADER_USAGE"};
            try {
                for (String defKey : defines) {
                    this.replaceInFile(new File(buildinRes, "CodenameOne_GLViewController.h"), "//#define " + defKey, "#define " + defKey);
                }
            }
            catch (IOException ex) {
                throw new BuildException("Failed to process usage descriptions", ex);
            }
        }
lbl444:
        // 3 sources

        if ("true".equals(request.getArg("ios.blockScreenshotsOnEnterBackground", "false"))) {
            try {
                this.replaceInFile(new File(buildinRes, "CodenameOne_GLViewController.h"), "//#define CN1_BLOCK_SCREENSHOTS_ON_ENTER_BACKGROUND", "#define CN1_BLOCK_SCREENSHOTS_ON_ENTER_BACKGROUND");
            }
            catch (IOException ex) {
                throw new BuildException("Failure while processing ios.blockScreenshotsOnEnterBackground build hint", ex);
            }
        }
        if ((applicationDidEnterBackground = request.getArg("ios.applicationDidEnterBackground", null)) != null) {
            try {
                this.replaceInFile(glAppDelegate, "//----application_will_resign_active", applicationDidEnterBackground);
            }
            catch (IOException ex) {
                throw new BuildException("Failure while processing ios.applicationDidEnterBackground build hint", ex);
            }
        }
        try {
            if (request.getArg("ios.lowMemCamera", "false").equals("true")) {
                CodenameOne_GLViewController = new File(buildinRes, "CodenameOne_GLViewController.m");
                this.replaceInFile(CodenameOne_GLViewController, "//#define LOW_MEM_CAMERA", "#define LOW_MEM_CAMERA");
            }
            if (request.getArg("ios.enableStatusBar7", "true").equals("false")) {
                CodenameOne_GLViewController = new File(buildinRes, "CodenameOne_GLViewController.m");
                this.replaceInFile(CodenameOne_GLViewController, "int statusbarHeight = 20;", "int statusbarHeight = 0;");
            }
            if (request.getArg("ios.enableAutoplayVideo", "false").equals("false")) {
                iosNative = new File(buildinRes, "IOSNative.m");
                this.replaceInFile(iosNative, "#define AUTO_PLAY_VIDEO", "//#define AUTO_PLAY_VIDEO");
            }
            if (request.getArg("ios.background_modes", "").contains("fetch")) {
                this.replaceInFile(new File(buildinRes, "CodenameOne_GLAppDelegate.m"), "//#define INCLUDE_CN1_BACKGROUND_FETCH", "#define INCLUDE_CN1_BACKGROUND_FETCH");
            }
        }
        catch (IOException ex) {
            throw new BuildException("Failure while trying to inject build hints into sources.", ex);
        }
        viewDidLoad = request.getArg("ios.viewDidLoad", null);
        adPadding = request.getArg("ios.googleAdUnitIdPadding", "");
        if (googleAdUnitId != null && googleAdUnitId.length() > 0) {
            adPadding = adPadding.length() == 0 ? "        Display.getInstance().setProperty(\"adPaddingBottom\", \"9\");\n" : "        Display.getInstance().setProperty(\"adPaddingBottom\", \"" + adPadding + "\");\n";
        }
        stubSource = new File(this.tmpFile, "stub");
        stubSource.mkdirs();
        try {
            this.generateUnitTestFiles(request, stubSource);
        }
        catch (Exception ex) {
            throw new BuildException("Failed to generate Unit Test Files", ex);
        }
        newStorage = "";
        if (request.getArg("ios.newStorageLocation", "true").equals("true")) {
            newStorage = "        Display.getInstance().setProperty(\"iosNewStorage\", \"true\");\n";
        }
        didEnterBackground = "        stopped = true;\n        final long bgTask = com.codename1.impl.ios.IOSImplementation.beginBackgroundTask();\n        Display.getInstance().callSerially(new Runnable() { \n            public void run(){ \n                i.stop();\n                com.codename1.impl.ios.IOSImplementation.endBackgroundTask(bgTask);            }\n        });\n";
        try {
            stubSourceStream = new FileOutputStream(new File(stubSource, request.getMainClass() + "Stub.java"));
            var37_108 = null;
            try {
                stubSourceCode = "package " + request.getPackageName() + ";\n\nimport com.codename1.ui.*;\nimport com.codename1.push.PushCallback;\n\nimport com.codename1.system.*;\n\npublic class " + request.getMainClass() + "Stub extends com.codename1.impl.ios.Lifecycle implements Runnable {\n    public static final String PACKAGE_NAME = \"" + request.getPackageName() + "\";\n    public static final String APPLICATION_VERSION = \"" + this.buildVersion + "\";\n    public static final String APPLICATION_NAME = \"" + request.getDisplayName() + "\";\n    private " + request.getMainClass() + " i = new " + request.getMainClass() + "();\n    private boolean initialized = false;\n    private boolean stopped = false;\n";
                stubSourceCode = stubSourceCode + this.decodeFunction();
                stubSourceCode = stubSourceCode + "    public void run() {\n        Display.getInstance().setProperty(\"package_name\", PACKAGE_NAME);\n        Display.getInstance().setProperty(\"AppVersion\", APPLICATION_VERSION);\n        Display.getInstance().setProperty(\"AppName\", APPLICATION_NAME);\n" + newStorage + adPadding + integrateFacebook + integrateGoogleConnect + "        if(!initialized) {\n            initialized = true;\n            i.init(this);\n" + this.createStartInvocation(request, "i") + "        } else {\n" + this.createStartInvocation(request, "i") + "        }\n    }\n\n    public void applicationDidEnterBackground() {\n" + didEnterBackground + "    }\n\n    public void applicationWillEnterForeground() {\n         if(stopped) {\n             stopped = false;\n             Display.getInstance().callSerially(this);         }\n    }\n\n    public void applicationDidBecomeActive() {\n    }\n\n" + microphoneCallback + "    public boolean shouldApplicationHandleURL(String url, String caller) {\n        if(i instanceof com.codename1.system.URLCallback) {            return ((com.codename1.system.URLCallback)i).shouldApplicationHandleURL(url, caller);\n        }\n        return true;\n    }\n\n    public void applicationWillTerminate() {\n        if(!stopped) {\n            i.stop();\n            stopped = true;\n        }\n        i.destroy();\n    }\n\n    public static void main(String[] argv) {\n        if(!(argv != null && argv.length > 0 && argv[0].equals(\"ignoreNative\"))) {\n" + this.registerNativeImplementationsAndCreateStubs(new URLClassLoader(new URL[]{this.codenameOneJar.toURI().toURL()}), stubSource, new File[]{classesDir}) + "        }\n        " + request.getMainClass() + "Stub stub = new " + request.getMainClass() + "Stub();\n        com.codename1.impl.ios.IOSImplementation.setMainClass(stub.i);\n        com.codename1.impl.ios.IOSImplementation.setIosMode(\"" + iosMode + "\");\n        Display.init(stub);\n    }\n}\n";
                stubSourceStream.write(stubSourceCode.getBytes());
            }
            catch (Throwable stubSourceCode /* !! */ ) {
                var37_108 = stubSourceCode /* !! */ ;
                throw stubSourceCode /* !! */ ;
            }
            finally {
                if (stubSourceStream != null) {
                    if (var37_108 != null) {
                        try {
                            stubSourceStream.close();
                        }
                        catch (Throwable stubSourceCode) {
                            var37_108.addSuppressed(stubSourceCode);
                        }
                    } else {
                        stubSourceStream.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new BuildException("Failed to write stub source", ex);
        }
        nativeInterfaces = this.getNativeInterfaces();
        if (nativeInterfaces != null && nativeInterfaces.length > 0) {
            for (Class currentNative : nativeInterfaces) {
                folder = new File(stubSource, currentNative.getPackage().getName().replace('.', File.separatorChar));
                folder.mkdirs();
                javaFile = new File(folder, currentNative.getSimpleName() + "ImplCodenameOne.java");
                javaImplSourceFile = "package " + currentNative.getPackage().getName() + ";\n\nimport com.codename1.ui.PeerComponent;\n\npublic class " + currentNative.getSimpleName() + "ImplCodenameOne {\n    private long nativePeer;\n\n    public " + currentNative.getSimpleName() + "ImplCodenameOne() {\n        nativePeer = initializeNativePeer();\n    }\n\n    public void finalize() {\n        releaseNativePeerInstance(nativePeer);\n    }\n\n    private static native long initializeNativePeer();\n\n    private static native void releaseNativePeerInstance(long peer);\n\n";
                prefixForNewVM = "";
                postfixForNewVM = "";
                prefix2ForNewVM = "";
                newVMEnterNativeCode = "";
                newVMExitNativeCode = "";
                newVMInclude = "";
                newVMInclude = "\n#include \"cn1_globals.h\"\n";
                newVMEnterNativeCode = "    POOL_BEGIN();\n    enteringNativeAllocations();\n";
                newVMExitNativeCode = "    finishedNativeAllocations();\n    POOL_END();\n";
                prefixForNewVM = "CODENAME_ONE_THREAD_STATE";
                prefix2ForNewVM = "CODENAME_ONE_THREAD_STATE, ";
                postfixForNewVM = "_R_long";
                classNameWithUnderscores = currentNative.getName().replace('.', '_');
                mSourceFile = "#include \"xmlvm.h\"\n#include \"java_lang_String.h\"\n#import \"CodenameOne_GLViewController.h\"\n#import <UIKit/UIKit.h>\n#import \"" + classNameWithUnderscores + "Impl.h\"\n" + newVMInclude + "#include \"" + classNameWithUnderscores + "ImplCodenameOne.h\"\n\nJAVA_LONG " + classNameWithUnderscores + "ImplCodenameOne_initializeNativePeer__" + postfixForNewVM + "(" + prefixForNewVM + ") {\n    " + classNameWithUnderscores + "Impl* i = [[" + classNameWithUnderscores + "Impl alloc] init];\n    return i;\n}\n\nvoid " + classNameWithUnderscores + "ImplCodenameOne_releaseNativePeerInstance___long(" + prefix2ForNewVM + "JAVA_LONG l) {\n    " + classNameWithUnderscores + "Impl* i = (" + classNameWithUnderscores + "Impl*)l;\n    [i release];\n}\n\nextern NSData* arrayToData(JAVA_OBJECT arr);\nextern NSString* toNSString(" + prefix2ForNewVM + "JAVA_OBJECT str);\nextern JAVA_OBJECT nsDataToByteArr(NSData *data);\nextern JAVA_OBJECT nsDataToBooleanArray(NSData *data);\nextern JAVA_OBJECT nsDataToCharArray(NSData *data);\nextern JAVA_OBJECT nsDataToShortArray(NSData *data);\nextern JAVA_OBJECT nsDataToIntArray(NSData *data);\nextern JAVA_OBJECT nsDataToLongArray(NSData *data);\nextern JAVA_OBJECT nsDataToFloatArray(NSData *data);\nextern JAVA_OBJECT nsDataToDoubleArray(NSData *data);\n\nvoid xmlvm_init_native_" + classNameWithUnderscores + "ImplCodenameOne() {}\n\n";
                for (Method m : currentNative.getMethods()) {
                    name = m.getName();
                    if (name.equals("hashCode") || name.equals("equals") || name.equals("toString")) continue;
                    returnType = m.getReturnType();
                    mSourceFile = mSourceFile + this.typeToXMLVMName(returnType) + " " + currentNative.getName().replace('.', '_') + "ImplCodenameOne_" + name + "__";
                    mFileArgs = "(CODENAME_ONE_THREAD_STATE, JAVA_OBJECT me";
                    mFileBody /* !! */  = "    " + classNameWithUnderscores + "Impl* ptr = (" + classNameWithUnderscores + "Impl*)get_field_" + classNameWithUnderscores + "ImplCodenameOne_nativePeer(me);\n";
                    if (!returnType.equals(Void.class) && !returnType.equals(Void.TYPE)) {
                        mFileBody /* !! */  = (String)mFileBody /* !! */  + "    " + this.typeToXMLVMName(returnType) + " returnValue = " + this.convertToJavaMethod(returnType);
                    }
                    mFileBody /* !! */  = (String)mFileBody /* !! */  + "[ptr " + name;
                    javaImplSourceFile = returnType.getName().equals("com.codename1.ui.PeerComponent") != false ? javaImplSourceFile + "    public native long " + name + "(" : javaImplSourceFile + "    public native " + this.getSimpleNameWithJavaLang(returnType) + " " + name + "(";
                    params = m.getParameterTypes();
                    if (params != null && params.length > 0) {
                        for (iter = 0; iter < params.length; ++iter) {
                            if (!params[iter].getName().equals("com.codename1.ui.PeerComponent")) continue;
                            params[iter] = Long.TYPE;
                        }
                        javaImplSourceFile = javaImplSourceFile + this.getSimpleNameWithJavaLang(params[0]) + " param0";
                        for (iter = 1; iter < params.length; ++iter) {
                            javaImplSourceFile = javaImplSourceFile + ", " + this.getSimpleNameWithJavaLang(params[iter]) + " param" + iter;
                        }
                        for (iter = 0; iter < params.length; ++iter) {
                            mSourceFile = mSourceFile + "_" + this.typeToXMLVMJavaName(params[iter]);
                            mFileArgs = mFileArgs + ", " + this.typeToXMLVMName(params[iter]) + " param" + iter;
                            mFileBody /* !! */  = iter == 0 ? (String)mFileBody /* !! */  + ":" + this.convertToObjectiveCMethod(params[iter]) + "param0" + this.convertToClosing(params[iter]) : (String)mFileBody /* !! */  + " param" + iter + ":" + this.convertToObjectiveCMethod(params[iter]) + "param" + iter + this.convertToClosing(params[iter]);
                        }
                    }
                    if (!returnType.equals(Void.class) && !returnType.equals(Void.TYPE)) {
                        mSourceFile = returnType.getName().endsWith("PeerComponent") != false ? mSourceFile + "_R_long" : mSourceFile + "_R_" + this.typeToXMLVMJavaName(returnType);
                    }
                    mSourceFile = returnType.equals(Void.class) == false && returnType.equals(Void.TYPE) == false ? mSourceFile + mFileArgs + ") {\n" + newVMEnterNativeCode + (String)mFileBody /* !! */  + "]" + this.convertToClosing(returnType) + ";\n" + newVMExitNativeCode + "    return returnValue;\n}\n\n" : mSourceFile + mFileArgs + ") {\n" + newVMEnterNativeCode + (String)mFileBody /* !! */  + "]" + this.convertToClosing(returnType) + ";\n" + newVMExitNativeCode + "}\n\n";
                    javaImplSourceFile = javaImplSourceFile + ");\n";
                }
                javaImplSourceFile = javaImplSourceFile + "}\n";
                try {
                    out = new FileOutputStream(javaFile);
                    var53_156 = null;
                    try {
                        out.write(javaImplSourceFile.getBytes());
                        out.close();
                    }
                    catch (Throwable var54_164) {
                        var53_156 = var54_164;
                        throw var54_164;
                    }
                    finally {
                        if (out != null) {
                            if (var53_156 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable var54_163) {
                                    var53_156.addSuppressed(var54_163);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    throw new BuildException("Error while generating native interface stub for " + currentNative, ex);
                }
                mFile = new File(resDir, "native_" + currentNative.getName().replace('.', '_') + "ImplCodenameOne.m");
                try {
                    out = new FileOutputStream(mFile);
                    var54_161 = null;
                    try {
                        out.write(mSourceFile.getBytes());
                        out.close();
                    }
                    catch (Throwable m) {
                        var54_161 = m;
                        throw m;
                    }
                    finally {
                        if (out != null) {
                            if (var54_161 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable m) {
                                    var54_161.addSuppressed(m);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    throw new BuildException("Error while generating native interface stub for " + currentNative, ex);
                }
            }
        }
        if (!new File(javacPath = System.getProperty("java.home") + "/../bin/javac").exists()) {
            javacPath = System.getProperty("java.home") + "/bin/javac";
        }
        if (!new File(javacPath).exists()) {
            javacPath = "javac";
        }
        try {
            if (!this.execWithFiles(stubSource, stubSource, ".java", new String[]{javacPath, "-source", "1.6", "-target", "1.6", "-classpath", classesDir.getAbsolutePath(), "-d", classesDir.getAbsolutePath()})) {
                return false;
            }
        }
        catch (Exception ex) {
            throw new BuildException("Failure occurred while compiling native interface stubs", ex);
        }
        try {
            if (!this.generateIcons(request)) {
                return false;
            }
        }
        catch (Exception ex) {
            throw new BuildException("Failed to generate icons", ex);
        }
        try {
            if (!this.generateLaunchScreen(request)) {
                return false;
            }
        }
        catch (Exception ex) {
            throw new BuildException("Failed to generate launch screen");
        }
        this.resultDir = new File(this.tmpFile, "result");
        this.resultDir.mkdirs();
        this.includePush = request.getArg("ios.includePush", "false").equalsIgnoreCase("true");
        if (request.getPushCertificate() != null || this.includePush || this.usesLocalNotifications) {
            try {
                appDelH = new File(buildinRes, "CodenameOne_GLAppDelegate.h");
                dis = new DataInputStream(new FileInputStream(appDelH));
                data = new byte[(int)appDelH.length()];
                dis.readFully(data);
                dis.close();
                fios = new FileWriter(appDelH);
                str = new String(data);
                str = str.replace("//#define CN1_INCLUDE_NOTIFICATIONS", "#define CN1_INCLUDE_NOTIFICATIONS");
                fios.write(str);
                fios.close();
                iosNative = new File(buildinRes, "IOSNative.m");
                dis = new DataInputStream(new FileInputStream(iosNative));
                data = new byte[(int)iosNative.length()];
                dis.readFully(data);
                dis.close();
                fios = new FileWriter(iosNative);
                str = new String(data);
                str = str.replace("//#define CN1_INCLUDE_NOTIFICATIONS2", "#define CN1_INCLUDE_NOTIFICATIONS2");
                fios.write(str);
                fios.close();
            }
            catch (IOException ex) {
                this.log("Failed to Update Objective-C source files to activate notifications flag");
                throw new BuildException("Failed to update Objective-C source files to activate notifications flag", ex);
            }
        }
        if (request.getPushCertificate() == null && !this.includePush) {
            try {
                dis = new DataInputStream(new FileInputStream(glAppDelegate));
                data = new byte[(int)glAppDelegate.length()];
                dis.readFully(data);
                dis.close();
                fios = new FileWriter(glAppDelegate);
                str = new String(data);
                str = str.replace("#define INCLUDE_CN1_PUSH", "");
                fios.write(str);
                fios.close();
                iosNative = new File(buildinRes, "IOSNative.m");
                dis = new DataInputStream(new FileInputStream(iosNative));
                data = new byte[(int)iosNative.length()];
                dis.readFully(data);
                dis.close();
                fios = new FileWriter(iosNative);
                str = new String(data);
                str = str.replace("#define INCLUDE_CN1_PUSH2", "//#define INCLUDE_CN1_PUSH2");
                fios.write(str);
                fios.close();
            }
            catch (IOException ex) {
                throw new BuildException("Failed to update Objective-C source files to activate push notification flag", ex);
            }
        }
        if (request.getArg("ios.enableBadgeClear", "true").equals("false")) {
            try {
                this.replaceInFile(glAppDelegate, "[UIApplication sharedApplication].applicationIconBadgeNumber = 0;", "//[UIApplication sharedApplication].applicationIconBadgeNumber = 0;");
                this.replaceInFile(glAppDelegate, "[[UIApplication sharedApplication] cancelAllLocalNotifications];", "//[[UIApplication sharedApplication] cancelAllLocalNotifications];");
            }
            catch (IOException ex) {
                throw new BuildException("Failed to remove badge notifications from objective-c soruce files", ex);
            }
        }
        try {
            iosNative = new File(buildinRes, "IOSNative.m");
            glAppDelegeateHeader = request.getArg("ios.glAppDelegateHeader", null);
            if (glAppDelegeateHeader != null && glAppDelegeateHeader.length() > 0) {
                this.replaceInFile(glAppDelegate, "//GL_APP_DELEGATE_INCLUDE", glAppDelegeateHeader);
            }
            if ((jailbreakH = new File(buildinRes, "CN1JailbreakDetector.h")).exists() && this.detectJailbreak) {
                this.replaceInFile(jailbreakH, "//#define CN1_DETECT_JAILBREAK", "#define CN1_DETECT_JAILBREAK");
            }
            if ((glAppDelegeateBody = request.getArg("ios.glAppDelegateBody", null)) != null && glAppDelegeateBody.length() > 0) {
                this.replaceInFile(glAppDelegate, "//GL_APP_DELEGATE_BODY", glAppDelegeateBody);
            }
            if ((openURLInject = request.getArg("ios.openURLInject", null)) != null && openURLInject.length() > 0) {
                this.replaceInFile(glAppDelegate, "//openURLMarkerEntry", openURLInject);
            }
            if ((beforeFinishLaunching = request.getArg("ios.beforeFinishLaunching", null)) != null) {
                this.replaceInFile(glAppDelegate, "//beforeDidFinishLaunchingWithOptionsMarkerEntry", beforeFinishLaunching);
            }
            if ((afterFinishLaunching = request.getArg("ios.afterFinishLaunching", null)) != null) {
                this.replaceInFile(glAppDelegate, "//afterDidFinishLaunchingWithOptionsMarkerEntry", afterFinishLaunching);
            }
            if ((actionSheetStyle = request.getArg("ios.actionSheetStyle", null)) != null) {
                this.replaceInFile(iosNative, "[actionSheet setActionSheetStyle:UIActionSheetStyleBlackTranslucent", "[actionSheet setActionSheetStyle:" + actionSheetStyle);
            }
            if ((zbarFlash = request.getArg("ios.zbar_flash", "true")).equals("false")) {
                this.replaceAllInFile(iosNative, "//ZBAR_CONFIGURATIONS", "reader.readerView.torchMode = AVCaptureTorchModeOff;");
            }
            if (request.getArg("ios.keyboardOpen", "true").equals("true")) {
                CodenameOne_GLViewController_m = new File(buildinRes, "CodenameOne_GLViewController.m");
                this.replaceInFile(CodenameOne_GLViewController_m, "BOOL vkbAlwaysOpen = NO;", "BOOL vkbAlwaysOpen = YES;");
            }
            if (request.getArg("ios.associatedDomains", null) != null) {
                CodenameOne_GLViewController_h = new File(buildinRes, "CodenameOne_GLViewController.h");
                this.replaceInFile(CodenameOne_GLViewController_h, "//#define CN1_HANDLE_UNIVERSAL_LINKS", "#define CN1_HANDLE_UNIVERSAL_LINKS");
            }
            if (request.getArg("ios.locationUsageDescription", null) != null) {
                CodenameOne_GLViewController_h = new File(buildinRes, "CodenameOne_GLViewController.h");
                this.replaceInFile(CodenameOne_GLViewController_h, "#define IOS8_LOCATION_WARNING", "//#define IOS8_LOCATION_WARNING");
            }
            if (request.getArg("ios.background_modes", "").contains("location")) {
                CodenameOne_GLViewController_h = new File(buildinRes, "CodenameOne_GLViewController.h");
                this.replaceInFile(CodenameOne_GLViewController_h, "#define CN1_REQUEST_LOCATION_AUTH requestWhenInUseAuthorization", "#define CN1_REQUEST_LOCATION_AUTH requestAlwaysAuthorization");
            }
            if (this.usesPurchaseAPI) {
                CodenameOne_GLViewController_h = new File(buildinRes, "CodenameOne_GLViewController.h");
                this.replaceInFile(CodenameOne_GLViewController_h, "//#define CN1_USE_STOREKIT", "#define CN1_USE_STOREKIT");
            }
        }
        catch (Exception ex) {
            throw new BuildException("Failure while injecting code from build hints", ex);
        }
        if (googleAdUnitId != null && googleAdUnitId.length() > 0) {
            try {
                CodenameOne_GLViewController_h = new File(buildinRes, "CodenameOne_GLViewController.h");
                this.replaceAllInFile(CodenameOne_GLViewController_h, "//ADD_VARIABLES", "@public\n    GADBannerView *googleBannerView;\n");
                if (usePodsForGoogleAds) {
                    this.replaceAllInFile(CodenameOne_GLViewController_h, "//ADD_INCLUDE", "#import <GoogleMobileAds/GoogleMobileAds.h>\n");
                } else {
                    this.replaceAllInFile(CodenameOne_GLViewController_h, "//ADD_INCLUDE", "#import \"GADBannerView.h\"\n");
                }
                CodenameOne_GLViewController_m = new File(buildinRes, "CodenameOne_GLViewController.m");
                this.replaceAllInFile(CodenameOne_GLViewController_m, "//replaceViewDidAppear", "[self addGoogleAds];\n");
                this.replaceAllInFile(CodenameOne_GLViewController_m, "//WILL_ROTATE_TO_INTERFACE_MARKER", "if(googleBannerView != nil) {\n        [googleBannerView removeFromSuperview];\n        [googleBannerView release];\n        googleBannerView = nil;\n    }\n");
                this.replaceAllInFile(CodenameOne_GLViewController_m, "//DID_ROTATE_FROM_INTERFACE_MARKER", "[self addGoogleAds];\n");
                this.replaceAllInFile(CodenameOne_GLViewController_m, "//INJECT_METHODS_MARKER", "-(void) addGoogleAds {\n    if(googleBannerView != nil) {\n        [googleBannerView removeFromSuperview];\n        [googleBannerView release];\n        googleBannerView = nil;\n    }\n    UIInterfaceOrientation orientation = [[UIApplication sharedApplication] statusBarOrientation];\n    bool isPortrait = (orientation == UIInterfaceOrientationPortrait || orientation == UIInterfaceOrientationPortraitUpsideDown);\n    GADAdSize adSize = kGADAdSizeSmartBannerPortrait;\n    if(!isPortrait) {\n        adSize = kGADAdSizeSmartBannerLandscape;\n    }\n    googleBannerView = [[GADBannerView alloc] initWithAdSize:adSize];\n    googleBannerView.adUnitID = @\"" + googleAdUnitId + "\";\n    googleBannerView.rootViewController = self;\n    [self.view addSubview:googleBannerView];\n    GADRequest *request = [GADRequest request];\n    request.testDevices = [NSArray arrayWithObjects:@\"" + request.getArg("ios.googleAdUnitTestDevice", "97cfc76e5efbc6dfa7eb2e6857b613a0") + "\", nil];\n    [googleBannerView loadRequest:request];\n    CGRect r =CGRectMake([CodenameOne_GLViewController instance].view.bounds.size.width / 2 - googleBannerView.bounds.size.width / 2,\n                         [CodenameOne_GLViewController instance].view.bounds.size.height - googleBannerView.bounds.size.height,\n                         CGSizeFromGADAdSize(adSize).width, CGSizeFromGADAdSize(adSize).height);\n    [googleBannerView setFrame:r];\n}");
            }
            catch (Exception ex) {
                throw new BuildException("Failed to inject google ads", ex);
            }
        }
        try {
            if (viewDidLoad != null) {
                CodenameOne_GLViewController = new File(buildinRes, "CodenameOne_GLViewController.m");
                this.replaceAllInFile(CodenameOne_GLViewController, "//replaceViewDidLoad", viewDidLoad);
            }
            if (request.getArg("ios.viewDidLoadInclude", null) != null) {
                CodenameOne_GLViewController = new File(buildinRes, "CodenameOne_GLViewController.m");
                this.replaceAllInFile(CodenameOne_GLViewController, "#import \"CodenameOne_GLViewController.h\"", "#import \"CodenameOne_GLViewController.h\"\n" + request.getArg("ios.viewDidLoadInclude", ""));
            }
        }
        catch (Exception ex) {
            throw new BuildException("Failed to inject indo vidwDidLoad", ex);
        }
        addLibs = request.getArg("ios.add_libs", null);
        if (addLibs != null && (addLibs = addLibs.replace(',', ';').replace(':', ';')).startsWith(";")) {
            addLibs = addLibs.substring(1);
        }
        try {
            if (!this.runPods && googleAdUnitId != null && googleAdUnitId.length() > 0) {
                this.unzip(this.getResourceAsStream("/google-play-services_lib-ios.zip"), classesDir, buildinRes, buildinRes);
                addLibs = addLibs == null || addLibs.length() == 0 ? "AdSupport.framework;SystemConfiguration.framework;StoreKit.framework;CoreTelephony.framework" : addLibs + ";AdSupport.framework;SystemConfiguration.framework;StoreKit.framework;CoreTelephony.framework";
            }
            if (this.enableGalleryMultiselect && this.photoLibraryUsage && this.usePhotoKitForMultigallery) {
                addLibs = addLibs == null || addLibs.length() == 0 ? "PhotosUI.framework" : addLibs + ";PhotosUI.framework";
            }
            if ((this.includePush || this.usesLocalNotifications) && this.xcodeVersion >= 9) {
                addLibs = addLibs == null ? "UserNotifications.framework" : addLibs + ";UserNotifications.framework";
            }
            if (request.getArg("ios.useJavascriptCore", "false").equalsIgnoreCase("true")) {
                this.replaceInFile(new File(buildinRes, "CodenameOne_GLViewController.h"), "//#define CN1_USE_JAVASCRIPTCORE", "#define CN1_USE_JAVASCRIPTCORE");
                addLibs = addLibs == null ? "JavascriptCore.framework" : addLibs + ";JavascriptCore.framework";
            }
            if (request.getArg("ios.useAVKit", "true").equalsIgnoreCase("true")) {
                this.replaceInFile(new File(buildinRes, "IOSNative.m"), "//#define CN1_USE_AVKIT", "#define CN1_USE_AVKIT");
            }
            if (this.enableWKWebView) {
                addLibs = addLibs == null ? "WebKit.framework" : addLibs + ";WebKit.framework";
            }
            if (addLibs == null || addLibs.length() == 0) {
                addLibs = "CoreImage.framework;QuartzCore.framework";
            } else {
                if (addLibs.indexOf("CoreImage.framework") < 0) {
                    addLibs = addLibs + ";CoreImage.framework";
                }
                if (addLibs.indexOf("QuartzCore.framework") < 0) {
                    addLibs = addLibs + ";QuartzCore.framework";
                }
            }
            if (this.usesPurchaseAPI) {
                addLibs = addLibs + ";StoreKit.framework";
            }
        }
        catch (Exception ex) {
            throw new BuildException("Failed to process build hints", ex);
        }
        userDir = new File(System.getProperty("user.dir"));
        parparVMCompilerJar = null;
        try {
            parparVMCompilerJarFile = this.getResourceAsFile("/parparvm-compiler.jar", ".jar");
            parparVMCompilerJar = parparVMCompilerJarFile.getAbsolutePath();
        }
        catch (IOException ex) {
            throw new BuildException("Failed to extract parparvm-compiler.jar", ex);
        }
        try {
            this.unzip(this.getResourceAsStream("/parparvm-java-api.jar"), classesDir, classesDir, classesDir);
        }
        catch (IOException ex) {
            throw new BuildException("Failed to load JavaAPI.jar");
        }
        optimizerOn = request.getArg("ios.optimizer", "on");
        env = new HashMap<String, String>();
        env.put("optimizer", optimizerOn);
        if (request.getArg("ios.superfastBuild", "false").equals("true")) {
            env.put("concatenateFiles", "true");
        }
        fieldNullChecks = Boolean.valueOf(request.getArg("ios.fieldNullChecks", "false")) != false ? "true" : "false";
        includeNullChecks = Boolean.valueOf(request.getArg("ios.includeNullChecks", "true")) != false ? "true" : "false";
        bundleVersionNumber = request.getArg("ios.bundleVersion", this.buildVersion);
        if (this.enableGalleryMultiselect && this.photoLibraryUsage) {
            this.addMinDeploymentTarget("8.0");
        }
        if (this.enableWKWebView) {
            this.addMinDeploymentTarget("8.0");
        }
        this.debug("iosDeploymentTargetMajorVersionInt=" + this.getDeploymentTargetInt(request));
        this.debug("Building using addLibs=" + addLibs);
        try {
            if (!this.exec(userDir, env, 420000, new String[]{"java", "-DsaveUnitTests=" + this.isUnitTestMode(), "-DfieldNullChecks=" + fieldNullChecks, "-DINCLUDE_NPE_CHECKS=" + includeNullChecks, "-DbundleVersionNumber=" + bundleVersionNumber, "-Xmx384m", "-jar", parparVMCompilerJar, "ios", classesDir.getAbsolutePath() + ";" + resDir.getAbsolutePath() + ";" + buildinRes.getAbsolutePath(), this.tmpFile.getAbsolutePath(), request.getMainClass(), request.getPackageName(), request.getDisplayName(), this.buildVersion, request.getArg("ios.project_type", "ios"), addLibs})) {
                return false;
            }
        }
        catch (Exception ex) {
            throw new BuildException("Failure while trying to run ByteCodeTranslator of ParparVM", ex);
        }
        try {
            orientations = request.getArg("ios.interface_orientation", null);
            if (orientations != null && orientations.split(":").length < 4) {
                orientations = orientations.toLowerCase();
                infoPlist = new File(this.tmpFile, "dist/" + request.getMainClass() + "-src/" + request.getMainClass() + "-Info.plist");
                if (!orientations.contains("uiinterfaceorientationportrait")) {
                    this.replaceInFile(infoPlist, "<string>UIInterfaceOrientationPortrait</string>", "");
                }
                if (!orientations.contains("uiinterfaceorientationportraitupsidedown")) {
                    this.replaceInFile(infoPlist, "<string>UIInterfaceOrientationPortraitUpsideDown</string>", "");
                }
                if (!orientations.contains("uiinterfaceorientationlandscapeleft")) {
                    this.replaceInFile(infoPlist, "<string>UIInterfaceOrientationLandscapeLeft</string>", "");
                }
                if (!orientations.contains("uiinterfaceorientationlandscaperight")) {
                    this.replaceInFile(infoPlist, "<string>UIInterfaceOrientationLandscapeRight</string>", "");
                }
            }
            if ("true".equals(request.getArg("ios.prerendered_icon", "false"))) {
                this.log("Replacing prerendered Icon");
                infoPlist = new File(this.tmpFile, "dist/" + request.getMainClass() + "-src/" + request.getMainClass() + "-Info.plist");
                this.replaceAllInFile(infoPlist, "<key>UIPrerenderedIcon</key>[^<]*<false/>", "<key>UIPrerenderedIcon</key><true/>");
            }
            if (this.runPods || !request.getArg("ios.buildType", "debug").equals("debug") || request.getArg("ios.force64", "false").equals("true")) {
                pbx /* !! */  = new File(this.tmpFile, "dist/" + request.getMainClass() + ".xcodeproj/project.pbxproj");
                if (this.runPods) {
                    this.replaceAllInFile((File)pbx /* !! */ , "ARCHS = [^;]+;", "ARCHS = \"\\$(ARCHS_STANDARD_INCLUDING_64_BIT)\";");
                } else {
                    this.replaceInFile((File)pbx /* !! */ , "ARCHS = armv7;", "ARCHS = \"armv7 arm64\";");
                }
            }
            if (bicodeHandle) {
                minTargetVersion = request.getArg("ios.minDeploymentTarget", "6.0");
                if (minTargetVersion.equals("6.0")) {
                    if (this.xcodeVersion >= 9) {
                        minTargetVersion = "7.0";
                    }
                    if (this.enableGalleryMultiselect && this.photoLibraryUsage) {
                        minTargetVersion = "8.0";
                    }
                    if (this.enableWKWebView) {
                        minTargetVersion = "8.0";
                    }
                }
                this.addMinDeploymentTarget(minTargetVersion);
                pbx = new File(this.tmpFile, "dist/" + request.getMainClass() + ".xcodeproj/project.pbxproj");
                this.replaceInFile(pbx, "IPHONEOS_DEPLOYMENT_TARGET = 5.1.1;", "IPHONEOS_DEPLOYMENT_TARGET = " + this.getDeploymentTarget(request) + ";");
                if (request.getArg("ios.bitcode", "false").equals("true")) {
                    this.replaceInFile(pbx, "ASSETCATALOG_COMPILER_APPICON_NAME = AppIcon;", "ASSETCATALOG_COMPILER_APPICON_NAME = AppIcon;\n");
                } else {
                    this.replaceInFile(pbx, "ASSETCATALOG_COMPILER_APPICON_NAME = AppIcon;", "ASSETCATALOG_COMPILER_APPICON_NAME = AppIcon;\n\t\t\t\tENABLE_BITCODE = NO;\n");
                }
            }
            if (this.useMetal) {
                pbx /* !! */  = new File(this.tmpFile, "dist/" + request.getMainClass() + ".xcodeproj/project.pbxproj");
                this.replaceInFile((File)pbx /* !! */ , "CLANG_ENABLE_MODULES = NO;", "CLANG_ENABLE_MODULES = YES;");
            }
        }
        catch (Exception ex) {
            throw new BuildException("Failed to update infoplist file", ex);
        }
        if (this.runPods) {
            try {
                podSpecFileList = new ArrayList<File[]>();
                for (File podSpec : podSpecs.listFiles()) {
                    if (podSpec.getName().startsWith(".")) continue;
                    distDir = new File(this.tmpFile, "dist");
                    targetF = new File(distDir, podSpec.getName());
                    Files.move(podSpec.toPath(), targetF.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    podSpecFileList.add(targetF);
                }
                deploymentTargetStr = "";
                targetStr = request.getArg("ios.deployment_target", this.xcodeVersion >= 9 ? "7.0" : "6.0");
                if (this.enableGalleryMultiselect && this.photoLibraryUsage && this.getMajorVersionInt(targetStr, 6) < 8) {
                    targetStr = "8.0";
                }
                if (this.enableWKWebView && this.getMajorVersionInt(targetStr, 6) < 8) {
                    targetStr = "8.0";
                }
                this.addMinDeploymentTarget(targetStr);
                deploymentTargetStr = "begin\n  xcproj.targets.find{|e|e.name=='" + request.getMainClass() + "'}.build_configurations.each{|config| \n    config.build_settings['PRODUCT_BUNDLE_IDENTIFIER']='" + request.getPackageName() + "'\n  }\n  xcproj.targets.each do |target|\n    target.build_configurations.each do |config|\n      config.build_settings['IPHONEOS_DEPLOYMENT_TARGET'] = '" + this.getDeploymentTarget(request) + "'\n    end\n  end\n  xcproj.save\nrescue => e\n  puts \"Error during updating deployment target: #{$!}\"\n  puts \"Backtrace:\\n\\t#{e.backtrace.join(\"\\n\\t\")}\"\n  puts 'An error occurred updating deployment target, but the build still might work...'\nend\n";
                appExtensions = this.extractAppExtensions(resDir, new File(this.tmpFile, "dist"));
                sb = appExtensionsBuilder = new StringBuilder();
                for (File appExtension : appExtensions) {
                    buildSettingsStr = "CLANG_ANALYZER_NONNULL = YES;\n\t\t\t\tCLANG_ANALYZER_NUMBER_OBJECT_CONVERSION = YES_AGGRESSIVE;\n\t\t\t\tCLANG_CXX_LANGUAGE_STANDARD = \"gnu++14\";\n\t\t\t\tCLANG_ENABLE_MODULES = YES;\n\t\t\t\tCLANG_ENABLE_OBJC_ARC = YES;\n\t\t\t\tCLANG_ENABLE_OBJC_WEAK = YES;\n\t\t\t\tCLANG_WARN_BLOCK_CAPTURE_AUTORELEASING = YES;\n\t\t\t\tCLANG_WARN_COMMA = YES;\n\t\t\t\tCLANG_WARN_DEPRECATED_OBJC_IMPLEMENTATIONS = YES;\n\t\t\t\tCLANG_WARN_DOCUMENTATION_COMMENTS = YES;\n\t\t\t\tCLANG_WARN_EMPTY_BODY = YES;\n\t\t\t\tCLANG_WARN_ENUM_CONVERSION = YES;\n\t\t\t\tCLANG_WARN_INFINITE_RECURSION = YES;\n\t\t\t\tCLANG_WARN_INT_CONVERSION = YES;\n\t\t\t\tCLANG_WARN_NON_LITERAL_NULL_CONVERSION = YES;\n\t\t\t\tCLANG_WARN_OBJC_IMPLICIT_RETAIN_SELF = YES;\n\t\t\t\tCLANG_WARN_OBJC_LITERAL_CONVERSION = YES;\n\t\t\t\tCLANG_WARN_RANGE_LOOP_ANALYSIS = YES;\n\t\t\t\tCLANG_WARN_STRICT_PROTOTYPES = YES;\n\t\t\t\tCLANG_WARN_SUSPICIOUS_MOVE = YES;\n\t\t\t\tCLANG_WARN_UNGUARDED_AVAILABILITY = YES_AGGRESSIVE;\n\t\t\t\tCLANG_WARN_UNREACHABLE_CODE = YES;\n\t\t\t\tCLANG_WARN__DUPLICATE_METHOD_MATCH = YES;";
                    buildSettingsMap = new HashMap<String, String>();
                    for (String line : lines = buildSettingsStr.split("\n")) {
                        if (line.trim().isEmpty()) continue;
                        key = line.substring(0, line.indexOf("=")).trim();
                        val = line.substring(line.indexOf("=") + 1).trim();
                        if (val.endsWith(";")) {
                            val = val.substring(val.length() - 1);
                        }
                        buildSettingsMap.put(key, val);
                    }
                    extensionName = appExtension.getName();
                    codeSignEntitlements = "$(NS_CODE_SIGN_ENTITLEMENTS)";
                    if (appExtension.isDirectory()) {
                        for (Serializable f : appExtension.listFiles()) {
                            if (!f.getName().endsWith(".entitlements")) continue;
                            codeSignEntitlements = extensionName + "/" + f.getName();
                        }
                    }
                    buildSettingsMap.put("PRODUCT_BUNDLE_IDENTIFIER", request.getPackageName() + "." + extensionName);
                    buildSettingsMap.put("PRODUCT_NAME", "$(TARGET_NAME)");
                    buildSettingsMap.put("PROVISIONING_PROFILE", "$(NS_PROVISIONING_PROFILE)");
                    buildSettingsMap.put("CODE_SIGN_ENTITLEMENTS", codeSignEntitlements);
                    buildSettingsMap.put("LD_RUNPATH_SEARCH_PATHS", "$(inherited) @executable_path/Frameworks @executable_path/../../Frameworks");
                    buildSettingsMap.put("INFOPLIST_FILE", extensionName + "/Info.plist");
                    buildSettingsProps = new File(appExtension, "buildSettings.properties");
                    if (buildSettingsProps.exists()) {
                        _buildSettingsProps = new Properties();
                        fis = new FileInputStream(buildSettingsProps);
                        f = null;
                        try {
                            _buildSettingsProps.load(fis);
                        }
                        catch (Throwable var65_206) {
                            f = var65_206;
                            throw var65_206;
                        }
                        finally {
                            if (fis != null) {
                                if (f != null) {
                                    try {
                                        fis.close();
                                    }
                                    catch (Throwable var65_205) {
                                        f.addSuppressed(var65_205);
                                    }
                                } else {
                                    fis.close();
                                }
                            }
                        }
                        for (E key : _buildSettingsProps.keySet()) {
                            if (!(key instanceof String)) continue;
                            val = _buildSettingsProps.getProperty((String)key);
                            buildSettingsMap.put((String)key, val);
                        }
                        buildSettingsProps.delete();
                    }
                    sb.append("\nservice_target = xcproj.new_target(:app_extension, '" + extensionName + "', :ios, '10.0')\nxcproj.targets.find{|e|e.name=='" + request.getMainClass() + "'}.build_configurations.each{|e| \n  e.build_settings['PROVISIONING_PROFILE']='$(APP_PROVISIONING_PROFILE)'\n  e.build_settings['CODE_SIGN_ENTITLEMENTS']='$(APP_CODE_SIGN_ENTITLEMENTS)'\n}\nservice_group = xcproj.new_group('" + extensionName + "')\n");
                    this.appendFilesToXcodeProjGroup(sb, appExtension, "service_group", "service_target", appExtension.getParentFile());
                    sb.append("xcproj.targets.find{|e|e.name==main_class_name}.add_dependency(service_target)\nfileref = xcproj.groups.find{|e| e.display_name=='Products'}.new_file('" + extensionName + ".appex', \"BUILT_PRODUCTS_DIR\")\nembed_phase=xcproj.targets.find{|e| e.name=='" + request.getMainClass() + "'}.new_copy_files_build_phase('Embed App Extensions')\nembed_phase.build_action_mask = \"2147483647\"\nembed_phase.dst_subfolder_spec = \"13\"\nembed_phase.run_only_for_deployment_postprocessing=\"0\"\nembed_phase.add_file_reference(fileref)\nservice_target.build_configurations.each{|e| \n");
                    for (String buildSettingKey : buildSettingsMap.keySet()) {
                        sb.append("  e.build_settings['" + buildSettingKey + "'] = \"" + (String)buildSettingsMap.get(buildSettingKey) + "\"\n");
                    }
                    sb.append("}\n");
                }
                if (appExtensions.length > 0) {
                    sb.append("xcproj.save(project_file)\n");
                }
                installLocalizedStrings = "";
                if (this.installLocalizedStringsScript.length() > 0) {
                    installLocalizedStrings = "begin\n" + this.installLocalizedStringsScript.toString() + "rescue => e\n  puts \"Error during processing: #{$!}\"\n  puts \"Backtrace:\\n\\t#{e.backtrace.join(\"\\n\\t\")}\"\n  puts 'An error occurred recreating schemes, but the build still might work...'\nend\n";
                }
                createSchemesScript = "#!/usr/bin/env ruby\nrequire 'xcodeproj'\nmain_class_name = \"" + request.getMainClass() + "\"\nproject_file = \"" + this.tmpDir.getAbsolutePath() + "/dist/" + request.getMainClass() + ".xcodeproj\"\nxcproj = Xcodeproj::Project.open(project_file)\n" + installLocalizedStrings + "begin\n  xcproj.recreate_user_schemes\nrescue => e\n  puts \"Error during processing: #{$!}\"\n  puts \"Backtrace:\\n\\t#{e.backtrace.join(\"\\n\\t\")}\"\n  puts 'An error occurred recreating schemes, but the build still might work...'\nend\n" + deploymentTargetStr + appExtensionsBuilder.toString();
                hooksDir = new File(this.tmpFile, "hooks");
                hooksDir.mkdir();
                fixSchemesFile = new File(hooksDir, "fix_xcode_schemes.rb");
                this.createFile(fixSchemesFile, createSchemesScript.getBytes("UTF-8"));
                this.exec(hooksDir, new String[]{"echo", "chmod", "0755", fixSchemesFile.getAbsolutePath()});
                this.exec(hooksDir, new String[]{"chmod", "0755", fixSchemesFile.getAbsolutePath()});
                this.exec(hooksDir, new String[]{"echo", fixSchemesFile.getAbsolutePath()});
                if (!this.exec(hooksDir, new String[]{fixSchemesFile.getAbsolutePath()})) {
                    this.log("Failed to fix xcode project schemes.  Make sure you have Cocoapods installed. ");
                    return false;
                }
                if (!this.exec(new File(this.tmpFile, "dist"), this.podTimeout, new String[]{this.pod, "init"})) {
                    this.log("Failed to run " + this.pod + " init.  Make sure you have Cocoapods installed.");
                    return false;
                }
                podFile = new File(new File(this.tmpFile, "dist"), "Podfile");
                if (!podFile.exists()) {
                    this.log("Failed to create the PodFile at " + podFile);
                    return false;
                }
                podFileContents = "target '" + request.getMainClass() + "' do\n";
                for (String podLib : pods = iosPods.split("[,;]")) {
                    if ((podLib = podLib.trim()).isEmpty()) continue;
                    podLibName = podLib;
                    podLibVersion = "";
                    if (podLibName.contains(" ")) {
                        podLibName = podLib.substring(0, podLib.indexOf(" ")).trim();
                        podLibVersion = podLib.substring(podLib.indexOf(" ") + 1).trim();
                    }
                    podSpecPath = "";
                    for (File f : podSpecFileList) {
                        if (!f.getName().equals(podLibName + ".podspec")) continue;
                        podSpecPath = ", :path => '.'";
                        break;
                    }
                    podFileContents = podFileContents + "    pod  '" + podLibName + "'" + (podLibVersion.equals("") == false ? ", '" + podLibVersion + "'" : "") + podSpecPath + "\n";
                }
                podFileContents = podFileContents + "end\n";
                podFileContents = "platform :ios, '" + this.getDeploymentTarget(request) + "'\n" + podFileContents;
                if (!"false".equals(request.getArg("ios.pods.use_frameworks!", "false"))) {
                    podFileContents = "use_frameworks!\n" + podFileContents;
                }
                if (request.getArg("ios.pods.sources", null) != null) {
                    for (String podSource : podSources = request.getArg("ios.pods.sources", null).split("[;,]")) {
                        if ((podSource = podSource.trim()).length() == 0) continue;
                        podFileContents = "source '" + podSource + "'\n" + podFileContents;
                    }
                }
                buildSettings = "";
                buildSettingsPrefix = "ios.pods.build.";
                for (String key : request.getArgs()) {
                    if (!key.startsWith(buildSettingsPrefix)) continue;
                    if (buildSettings.length() == 0) {
                        buildSettings = buildSettings + "\n";
                    }
                    buildSettings = buildSettings + "      config.build_settings['" + key.substring(buildSettingsPrefix.length()) + "'] = \"" + request.getArg(key, "") + "\"\n";
                }
                if (this.useMetal) {
                    buildSettings = buildSettings + "      config.build_settings['CLANG_ENABLE_MODULES'] = \"YES\"\n";
                }
                podFileContents = podFileContents + "\n\npost_install do |installer|\n  installer.pods_project.targets.each do |target|\n    target.build_configurations.each do |config|\n      config.build_settings['IPHONEOS_DEPLOYMENT_TARGET'] = \"" + this.getDeploymentTarget(request) + "\"\n      config.build_settings['EXPANDED_CODE_SIGN_IDENTITY'] = \"\"\n      config.build_settings['CODE_SIGNING_REQUIRED'] = \"NO\"\n      config.build_settings['CODE_SIGNING_ALLOWED'] = \"NO\"\n      config.build_settings['ENABLE_STRICT_OBJC_MSGSEND'] = \"NO\"\n" + buildSettings + "    end\n  end\nend";
                this.createFile(podFile, podFileContents.getBytes("UTF-8"));
                userHome = new File(System.getProperty("user.home"));
                masterRepo = new File(userHome, ".cocoapods/repos/master");
                if (!masterRepo.exists()) {
                    this.log("Master Repo doesn't exist.  Running pod setup to create it");
                    this.exec(new File(this.tmpFile, "dist"), this.podTimeout * 3, new String[]{this.pod, "setup"});
                    if (!masterRepo.exists()) {
                        this.log("Failed to create master repo.  This might spell trouble...");
                    }
                }
                podEnv = new HashMap<String, String>();
                podEnv.put("LANG", "en_US.UTF-8");
                if (!this.exec(new File(this.tmpFile, "dist"), (File)null, this.podTimeout, podEnv, new String[]{this.pod, "install"})) {
                    this.log("Failed to exec cocoapods.  Trying to update master repo...");
                    if (!this.exec(new File(this.tmpFile, "dist"), this.podTimeout * 3, new String[]{this.pod, "repo", "update"})) {
                        this.log("Failed to update cocoapods master repo.  Trying to clean up spec repos");
                        if (!this.exec(new File(this.tmpFile, "dist"), this.podTimeout * 3, new String[]{this.pod, "repo", "update"})) {
                            this.log("Failed to update cocoapods master repo event after cleaning spec repos.");
                            return false;
                        }
                    }
                    if (!this.exec(new File(this.tmpFile, "dist"), (File)null, this.podTimeout, podEnv, new String[]{this.pod, "install"})) {
                        this.log("Cocoapods failed even after updating master repo");
                        this.log("Trying to cleanup spec repos");
                        if (!this.exec(new File(this.tmpFile, "dist"), (File)null, this.podTimeout, podEnv, new String[]{this.pod, "install"})) {
                            this.log("Cocoapods failed even after cleaning up spec repos.");
                            return false;
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new BuildException("Failed to generate PodFile", ex);
            }
        }
        try {
            if (request.getArg("ios.buildType", "debug").equals("debug") && request.getArg("ios.no_strip", "false").equalsIgnoreCase("true")) {
                pbx = new File(this.tmpFile, "dist/" + request.getMainClass() + ".xcodeproj/project.pbxproj");
                this.replaceAllInFile(pbx, "COPY_PHASE_STRIP = YES;", "COPY_PHASE_STRIP = NO;");
                this.replaceAllInFile(pbx, "STRIP_STYLE = all;", "STRIP_STYLE = debugging;");
                this.replaceAllInFile(pbx, "SEPARATE_STRIP = YES;", "SEPARATE_STRIP = NO;");
            }
            if ("YES".equals(request.getArg("ios.pods.build.CLANG_ENABLE_MODULES", null))) {
                pbx = new File(this.tmpFile, "dist/" + request.getMainClass() + ".xcodeproj/project.pbxproj");
                if ("YES".equals(request.getArg("ios.pods.build.CLANG_ALLOW_NON_MODULAR_INCLUDES_IN_FRAMEWORK_MODULES", null))) {
                    this.replaceAllInFile(pbx, "CLANG_ENABLE_MODULES = NO;", "CLANG_ENABLE_MODULES = YES; CLANG_ALLOW_NON_MODULAR_INCLUDES_IN_FRAMEWORK_MODULES = YES;");
                } else {
                    this.replaceAllInFile(pbx, "CLANG_ENABLE_MODULES = NO;", "CLANG_ENABLE_MODULES = YES;");
                }
            }
            if (googleAdUnitId != null && googleAdUnitId.length() > 0 || moPubAdUnitId != null && moPubAdUnitId.length() > 0) {
                pbx = new File(this.tmpFile, "dist/" + request.getMainClass() + ".xcodeproj/project.pbxproj");
                this.replaceAllInFile(pbx, "SDKROOT = iphoneos;", "OTHER_LDFLAGS = \"-ObjC\";\n\t\t\t\tSDKROOT = iphoneos;");
            } else if (request.getArg("ios.objC", "false").equals("true")) {
                pbx = new File(this.tmpFile, "dist/" + request.getMainClass() + ".xcodeproj/project.pbxproj");
                this.replaceAllInFile(pbx, "SDKROOT = iphoneos;", "OTHER_LDFLAGS = \"-ObjC\";\n\t\t\t\tSDKROOT = iphoneos;");
            }
            this.injectToPlist(this.tmpFile, resDir, request);
        }
        catch (Exception ex) {
            throw new BuildException("Failed to inject into plist");
        }
        if ("xcode".equals(this.getBuildTarget()) || this.getBuildTarget() == null) {
            this.xcodeProjectDir = new File(this.tmpFile, "dist");
            return true;
        }
        return true;
    }

    public File getXcodeProjectDir() {
        return this.xcodeProjectDir;
    }

    private void appendFilesToXcodeProjGroup(StringBuilder sb, File dir, String serviceGroupVarName, String serviceTargetVarName, File baseDir) {
        String basePath = baseDir.getAbsolutePath();
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        int basePathLen = basePath.length();
        for (File f : dir.listFiles()) {
            if (f.isFile()) {
                sb.append("fileref = ").append(serviceGroupVarName).append(".new_file(").append("'").append(f.getAbsolutePath().substring(basePathLen)).append("')\n");
                if (f.getName().endsWith(".m") || f.getName().endsWith(".swift")) {
                    sb.append(serviceTargetVarName).append(".add_file_references([fileref])\n");
                    continue;
                }
                if (f.getName().endsWith("Info.plist") || f.getName().endsWith(".entitlements")) continue;
                sb.append(serviceTargetVarName).append(".add_resources([fileref])\n");
                continue;
            }
            this.appendFilesToXcodeProjGroup(sb, f, serviceGroupVarName, serviceTargetVarName, baseDir);
        }
    }

    private String convertToJavaMethod(Class type) {
        if (type.isArray()) {
            if (Integer.class == (type = type.getComponentType()) || Integer.TYPE == type) {
                return "nsDataToIntArray(";
            }
            if (Long.class == type || Long.TYPE == type) {
                return "nsDataToLongArray(";
            }
            if (Byte.class == type || Byte.TYPE == type) {
                return "nsDataToByteArr(";
            }
            if (Short.class == type || Short.TYPE == type) {
                return "nsDataToShortArray(";
            }
            if (Character.class == type || Character.TYPE == type) {
                return "nsDataToCharArray(";
            }
            if (Boolean.class == type || Boolean.TYPE == type) {
                return "nsDataToBooleanArray(";
            }
            if (Float.class == type || Float.TYPE == type) {
                return "nsDataToFloatArray(";
            }
            if (Double.class == type || Double.TYPE == type) {
                return "nsDataToDoubleArray(";
            }
        }
        if (String.class == type) {
            return "fromNSString(CN1_THREAD_GET_STATE_PASS_ARG ";
        }
        return "";
    }

    private String convertToClosing(Class type) {
        if (type.isArray()) {
            return ")";
        }
        if (String.class == type) {
            return ")";
        }
        return "";
    }

    private String convertToObjectiveCMethod(Class type) {
        if (type.isArray()) {
            return "arrayToData(";
        }
        if (String.class == type) {
            return "toNSString(CN1_THREAD_GET_STATE_PASS_ARG ";
        }
        return "";
    }

    private String getSimpleNameWithJavaLang(Class c) {
        if (c.isPrimitive()) {
            return c.getSimpleName();
        }
        if (c.isArray()) {
            return this.getSimpleNameWithJavaLang(c.getComponentType()) + "[]";
        }
        if (c.getClass().getName().startsWith("java.lang.")) {
            return c.getName();
        }
        return c.getSimpleName();
    }

    private String typeToXMLVMJavaName(Class type) {
        if (type.isArray()) {
            return this.getSimpleNameWithJavaLang(type.getComponentType()).replace('.', '_') + "_1ARRAY";
        }
        return this.getSimpleNameWithJavaLang(type).replace('.', '_');
    }

    private String typeToXMLVMName(Class type) {
        if (type.getName().equals("com.codename1.ui.PeerComponent")) {
            return "JAVA_LONG";
        }
        if (Integer.class == type || Integer.TYPE == type) {
            return "JAVA_INT";
        }
        if (Long.class == type || Long.TYPE == type) {
            return "JAVA_LONG";
        }
        if (Byte.class == type || Byte.TYPE == type) {
            return "JAVA_BYTE";
        }
        if (Short.class == type || Short.TYPE == type) {
            return "JAVA_SHORT";
        }
        if (Character.class == type || Character.TYPE == type) {
            return "JAVA_CHAR";
        }
        if (Boolean.class == type || Boolean.TYPE == type) {
            return "JAVA_BOOLEAN";
        }
        if (Void.class == type || Void.TYPE == type) {
            return "void";
        }
        if (Float.class == type || Float.TYPE == type) {
            return "JAVA_FLOAT";
        }
        if (Double.class == type || Double.TYPE == type) {
            return "JAVA_DOUBLE";
        }
        return "JAVA_OBJECT";
    }

    @Override
    protected String generatePeerComponentCreationCode(String methodCallString) {
        return "PeerComponent.create(new long[] {" + methodCallString + "})";
    }

    @Override
    protected String convertPeerComponentToNative(String param) {
        return "((long[])" + param + ".getNativePeer())[0]";
    }

    @Override
    protected String getImplSuffix() {
        return "ImplCodenameOne";
    }

    @Override
    protected boolean deriveGlobalInstrumentClasspath() {
        return true;
    }

    private File[] extractAppExtensions(File sourceDirectory, File targetDirectory) throws IOException {
        if (sourceDirectory == null || !sourceDirectory.isDirectory()) {
            throw new IllegalArgumentException("extractAppExtensions sourceDirectory must be an existing directory but received " + sourceDirectory);
        }
        ArrayList<File> out = new ArrayList<File>();
        for (File appExtension : sourceDirectory.listFiles()) {
            if (!appExtension.getName().endsWith(".ios.appext")) continue;
            File extractedDir = new File(targetDirectory, appExtension.getName().substring(0, appExtension.getName().lastIndexOf(".ios.appext")));
            if (extractedDir.exists()) {
                IPhoneBuilder.delTree(extractedDir);
            }
            extractedDir.mkdir();
            try {
                boolean result = this.exec(sourceDirectory, "/usr/bin/unzip", appExtension.getName(), "-d", extractedDir.getAbsolutePath());
                if (!result) {
                    throw new IOException("Failed to unzip appExtension " + appExtension);
                }
                out.add(extractedDir);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IOException("Failed to unzip app extension " + appExtension, ex);
            }
            appExtension.delete();
        }
        return out.toArray(new File[out.size()]);
    }

    private void injectToPlist(File tmpFile, File resDir, BuildRequest request) throws IOException {
        String lang;
        File buildinRes = new File(tmpFile, "btres");
        File mat = new File(buildinRes, "material-design-font.ttf");
        if (mat.exists()) {
            IPhoneBuilder.copy(new File(buildinRes, "material-design-font.ttf"), new File(resDir, "material-design-font.ttf"));
        }
        File[] fontFiles = resDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith(".ttf");
            }
        });
        String facebook = request.getArg("facebook.appId", null);
        String googleClientId = request.getArg("ios.gplus.clientId", null);
        boolean includeGooglePlus = (this.googleServicePlist == null || !this.googleServicePlist.useSignIn) && googleClientId != null;
        String statusBarWhite = request.getArg("ios.statusBarFG", null);
        File infoPlist = new File(tmpFile, "build/xcode/sys/" + request.getMainClass() + "-Info.plist");
        if (!infoPlist.exists()) {
            infoPlist = new File(tmpFile, "dist/" + request.getMainClass() + "-src/" + request.getMainClass() + "-Info.plist");
        }
        if ((lang = request.getArg("ios.devLocale", null)) != null) {
            this.replaceAllInFile(infoPlist, "<string>English</string>", "<string>" + lang + "</string>");
        }
        String inject = request.getArg("ios.plistInject", "<key>CFBundleShortVersionString</key> \t<string>" + this.buildVersion + "</string>");
        String applicationQueriesSchemes = request.getArg("ios.applicationQueriesSchemes", null);
        if (applicationQueriesSchemes != null && applicationQueriesSchemes.length() > 0) {
            inject = inject + "<key>LSApplicationQueriesSchemes</key>\n <array>\n";
            for (String s : applicationQueriesSchemes.split(",")) {
                inject = inject + "<string>" + s + "</string>\n";
            }
            if (facebook != null) {
                inject = inject + "  <string>fbauth2</string>\n";
            }
            if (googleClientId != null) {
                inject = inject + "  <string>gplus</string>\n";
            }
            inject = inject + "</array>";
        }
        for (String privacyKey : this.privacyUsageDescriptions.keySet()) {
            String val;
            if (inject.contains(privacyKey) || privacyKey.toLowerCase().contains("location") || "false".equals(val = this.privacyUsageDescriptions.get(privacyKey))) continue;
            inject = inject + "\n<key>" + privacyKey + "</key><string>" + val + "</string>";
        }
        boolean multitasking = "true".equals(request.getArg("ios.multitasking", "true"));
        if (request.getArg("ios.generateSplashScreens", "false").equals("true")) {
            multitasking = false;
        }
        if (!(multitasking && this.xcodeVersion >= 9 || inject.indexOf("UIRequiresFullScreen") >= 0)) {
            inject = inject + "\n<key>UIRequiresFullScreen</key><true/>\n";
        }
        if (!"true".equals(request.getArg("ios.generateSplashScreens", "false")) && !inject.contains("UILaunchStoryboardName")) {
            inject = inject + "\n<key>UILaunchStoryboardName</key><string>" + request.getArg("ios.launchStoryboardName", "LaunchScreen") + "</string>";
        }
        if (request.getArg("ios.fileSharingEnabled", "false").equals("true")) {
            inject = inject + "\n\t<key>UIFileSharingEnabled</key>\n\t<true/>\n";
        }
        if (inject.indexOf("CFBundleShortVersionString") < 0) {
            inject = inject + "\n<key>CFBundleShortVersionString</key> \t<string>" + this.buildVersion + "</string>";
        }
        String locationUsageDescription = null;
        if (this.xcodeVersion >= 9) {
            locationUsageDescription = request.getArg("ios.locationUsageDescription", null);
            if (locationUsageDescription != null) {
                String key = "NSLocationWhenInUseUsageDescription";
                if (!inject.contains(key)) {
                    inject = inject + "\n<key>" + key + "</key> \t<string>" + locationUsageDescription + "</string>";
                }
                if (request.getArg("ios.background_modes", "").contains("location")) {
                    key = "NSLocationAlwaysUsageDescription";
                    locationUsageDescription = request.getArg("ios.NSLocationAlwaysUsageDescription", locationUsageDescription);
                    if (!inject.contains(key)) {
                        inject = inject + "\n<key>" + key + "</key> \t<string>" + locationUsageDescription + "</string>";
                    }
                    key = "NSLocationAlwaysAndWhenInUseUsageDescription";
                    locationUsageDescription = request.getArg("ios.NSLocationAlwaysAndWhenInUseUsageDescription", locationUsageDescription);
                    if (!inject.contains(key)) {
                        inject = inject + "\n<key>" + key + "</key> \t<string>" + locationUsageDescription + "</string>";
                    }
                }
            }
        } else {
            locationUsageDescription = request.getArg("ios.locationUsageDescription", null);
            if (locationUsageDescription != null) {
                String key = "NSLocationWhenInUseUsageDescription";
                if (request.getArg("ios.background_modes", "").contains("location")) {
                    key = "NSLocationAlwaysUsageDescription";
                }
                if (!inject.contains(key)) {
                    inject = inject + "\n<key>" + key + "</key> \t<string>" + locationUsageDescription + "</string>";
                }
            }
        }
        String backgroundModesStr = request.getArg("ios.background_modes", null);
        if (this.includePush && (backgroundModesStr == null || !backgroundModesStr.contains("remote-notification"))) {
            backgroundModesStr = backgroundModesStr == null ? "" : backgroundModesStr + ",";
            backgroundModesStr = backgroundModesStr + "remote-notification";
        }
        if (backgroundModesStr != null) {
            String[] backgroundModes = backgroundModesStr.split(",");
            if (!inject.contains("UIBackgroundModes")) {
                inject = inject + "\n<key>UIBackgroundModes</key><array>";
                for (String mode : backgroundModes) {
                    if (mode.trim().isEmpty()) continue;
                    if (mode.trim().equals("music")) {
                        mode = "audio";
                    }
                    inject = inject + "<string>" + mode.trim() + "</string>\n";
                }
                inject = inject + "</array>";
            } else {
                throw new IOException("You cannot use both ios.background_modes build hint and use UIBackgroundModes in the ios.plistInject build hint.  Choose one or the other");
            }
        }
        BufferedReader infoReader = new BufferedReader(new FileReader(infoPlist));
        StringBuilder b = new StringBuilder();
        String line = infoReader.readLine();
        while (line != null) {
            if (line.indexOf("</dict>") > -1) {
                if (inject != null) {
                    b.append(inject);
                }
                if (facebook != null || includeGooglePlus || this.googleServicePlist != null && this.googleServicePlist.useSignIn) {
                    if (facebook != null) {
                        b.append("\t<key>FacebookAppID</key>\n");
                        b.append("\t<string>");
                        b.append(facebook);
                        b.append("</string>");
                        b.append("\t<key>FacebookDisplayName</key>\n");
                        b.append("\t<string>");
                        b.append(request.getDisplayName());
                        b.append("</string>");
                        if (!inject.contains("LSApplicationQueriesSchemes")) {
                            b.append("<key>LSApplicationQueriesSchemes</key>\n\t<array>\n\t\t<string>fbauth2</string>\n<string>gplus</string>\t</array>");
                        }
                    }
                    b.append("\t<key>CFBundleURLTypes</key>\n");
                    b.append("\t<array><dict>");
                    b.append("\t    <key>CFBundleURLSchemes</key>\n");
                    b.append("\t    <array>");
                    if (facebook != null) {
                        b.append("<string>fb");
                        b.append(facebook);
                        b.append("</string>");
                    }
                    b.append(request.getArg("ios.urlSchemes", request.getArg("ios.urlScheme", "")));
                    b.append("</array>\n");
                    b.append("</dict>");
                    if (includeGooglePlus) {
                        b.append("<dict>\n\t\t\t<key>CFBundleTypeRole</key>\n\t\t\t<string>Editor</string>\n\t\t\t<key>CFBundleURLName</key>\n\t\t\t<string>" + request.getPackageName() + "</string>\n\t\t\t<key>CFBundleURLSchemes</key>\n\t\t\t<array>\n\t\t\t\t<string>" + request.getPackageName() + "</string>\n\t\t\t</array>\n\t\t</dict>");
                    }
                    if (this.googleServicePlist != null && this.googleServicePlist.useSignIn) {
                        b.append("<dict>\n\t\t\t<key>CFBundleTypeRole</key>\n\t\t\t<string>Editor</string>\n\t\t\t<key>CFBundleURLName</key>\n\t\t\t<string>" + request.getPackageName() + "</string>\n\t\t\t<key>CFBundleURLSchemes</key>\n\t\t\t<array>\n\t\t\t\t<string>" + request.getPackageName() + "</string>\n\t\t\t</array>\n\t\t</dict>");
                        b.append("<dict>\n\t\t\t<key>CFBundleTypeRole</key>\n\t\t\t<string>Editor</string>\n\t\t\t<key>CFBundleURLName</key>\n\t\t\t<string>" + request.getPackageName() + "</string>\n\t\t\t<key>CFBundleURLSchemes</key>\n\t\t\t<array>\n\t\t\t\t<string>" + this.googleServicePlist.reverseClientId + "</string>\n\t\t\t</array>\n\t\t</dict>");
                    } else if (googleClientId != null) {
                        b.append("<dict>\n\t\t\t<key>CFBundleTypeRole</key>\n\t\t\t<string>Editor</string>\n\t\t\t<key>CFBundleURLName</key>\n\t\t\t<string>" + request.getPackageName() + "</string>\n\t\t\t<key>CFBundleURLSchemes</key>\n\t\t\t<array>\n\t\t\t\t<string>" + IPhoneBuilder.createReverseGoogleClientId(googleClientId) + "</string>\n\t\t\t</array>\n\t\t</dict>");
                    }
                    b.append("</array>\n");
                } else {
                    String scheme = request.getArg("ios.urlSchemes", request.getArg("ios.urlScheme", null));
                    if (scheme != null && scheme.length() > 0) {
                        b.append("\t<key>CFBundleURLTypes</key>\n");
                        b.append("\t<array><dict><key>CFBundleURLSchemes</key><array>");
                        b.append(request.getArg("ios.urlSchemes", request.getArg("ios.urlScheme", "")));
                        b.append("</array></dict></array>\n");
                    }
                }
                if (statusBarWhite != null) {
                    b.append("\t<key>UIViewControllerBasedStatusBarAppearance</key>\n");
                    b.append("\t<false/>\n");
                    b.append("\t<key>UIStatusBarStyle</key>");
                    b.append("\t<string>");
                    b.append(statusBarWhite);
                    b.append("</string>");
                }
                if (fontFiles != null && fontFiles.length > 0) {
                    b.append("    <key>UIAppFonts</key>\n    <array>\n");
                    for (File f : fontFiles) {
                        b.append("        <string>");
                        b.append(f.getName());
                        b.append("</string>\n");
                    }
                    b.append("    </array>\n");
                }
            }
            b.append(line);
            b.append('\n');
            line = infoReader.readLine();
        }
        infoReader.close();
        FileOutputStream fo = new FileOutputStream(infoPlist);
        fo.write(b.toString().getBytes());
        fo.close();
    }

    private int getXcodeVersion(String xcodeBuild) {
        try {
            String result = this.execString(this.tmpFile, xcodeBuild, "-version");
            this.debug("Result is " + result);
            Scanner scanner = new Scanner(result);
            scanner.useDelimiter("\n");
            while (scanner.hasNext()) {
                String line = scanner.next();
                if (!line.startsWith("Xcode")) continue;
                this.log("Xcode version line matching pattern: " + line);
                String[] parts = line.split(" ");
                if (parts.length < 2) {
                    this.log("Xcode version line did not contain version number.");
                }
                if (parts[1].indexOf(".") >= 0) {
                    parts[1] = parts[1].substring(0, parts[1].indexOf(".")).trim();
                }
                return Integer.parseInt(parts[1]);
            }
        }
        catch (Exception ex) {
            this.log("Problem getting Xcode version: " + ex.getMessage());
            ex.printStackTrace();
            return -1;
        }
        this.log("Did not find any lines in Xcode version that matched the patterns we were looking for.  Returning version -1");
        return -1;
    }

    private int getMajorVersionInt(String versionStr, int defaultVal) {
        int pos = versionStr.indexOf(".");
        if (pos != -1) {
            try {
                return Integer.parseInt(versionStr.substring(0, pos));
            }
            catch (Throwable throwable) {
            }
        } else {
            try {
                return Integer.parseInt(versionStr);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    private static Element getNextElement(NodeList l, int currPos) {
        int len = l.getLength();
        Element nextEl = null;
        for (int j = currPos + 1; j < len; ++j) {
            Node nextN = l.item(j);
            if (!(nextN instanceof Element)) continue;
            nextEl = (Element)nextN;
            break;
        }
        return nextEl;
    }

    private File getIconDirectory(BuildRequest request) {
        File iconDirectory = new File(this.tmpFile, "dist/" + request.getMainClass() + "-src/Images.xcassets/AppIcon.appiconset");
        if (!iconDirectory.exists()) {
            iconDirectory.mkdirs();
        }
        return iconDirectory;
    }

    private void copyIcon(String name, File srcDir, File destDir) throws IOException {
        IPhoneBuilder.copy(new File(srcDir, name), new File(destDir, name));
    }

    private void copyIcons(File srcDir, File destDir, String ... icons) throws IOException {
        for (String icon : icons) {
            this.copyIcon(icon, srcDir, destDir);
        }
    }

    private boolean generateIcons(BuildRequest request) throws Exception {
        File iconDirectory = this.getIconDirectory(request);
        File resDir = this.getResDir();
        BufferedImage iconImage = ImageIO.read(new ByteArrayInputStream(request.getIcon()));
        this.icon512 = new File(iconDirectory, "iTunesArtwork");
        this.createFile(this.icon512, request.getIcon());
        this.icon57 = new File(iconDirectory, "Icon.png");
        this.createIconFile(this.icon57, iconImage, 57, 57);
        this.createIconFile(new File(iconDirectory, "iPhoneNotification@2x.png"), iconImage, 40, 40);
        this.createIconFile(new File(iconDirectory, "iPhoneNotification@3x.png"), iconImage, 60, 60);
        this.createIconFile(new File(iconDirectory, "iPhoneSpotlight.png"), iconImage, 29, 29);
        this.createIconFile(new File(iconDirectory, "iPhoneSpotlight@2x.png"), iconImage, 58, 58);
        this.createIconFile(new File(iconDirectory, "iPhoneSpotlight@3x.png"), iconImage, 87, 87);
        this.createIconFile(new File(iconDirectory, "iPhone7Spotlight@2x.png"), iconImage, 80, 80);
        this.createIconFile(new File(iconDirectory, "iPhone7Spotlight@3x.png"), iconImage, 120, 120);
        this.createIconFile(new File(iconDirectory, "iPhoneApp.png"), iconImage, 57, 57);
        this.createIconFile(new File(iconDirectory, "iPhoneApp@2x.png"), iconImage, 114, 114);
        this.createIconFile(new File(iconDirectory, "iPhone7App@2x.png"), iconImage, 120, 120);
        this.createIconFile(new File(iconDirectory, "iPhone7App@3x.png"), iconImage, 180, 180);
        this.createIconFile(new File(iconDirectory, "iPadNotifications.png"), iconImage, 20, 20);
        this.createIconFile(new File(iconDirectory, "iPadNotification@2x.png"), iconImage, 40, 40);
        this.createIconFile(new File(iconDirectory, "iPadSettings.png"), iconImage, 29, 29);
        this.createIconFile(new File(iconDirectory, "iPadSettings@2x.png"), iconImage, 58, 58);
        this.createIconFile(new File(iconDirectory, "iPadSpotlight7.png"), iconImage, 40, 40);
        this.createIconFile(new File(iconDirectory, "iPadSpotlight7@2x.png"), iconImage, 80, 80);
        this.createIconFile(new File(iconDirectory, "iPadSpotlight.png"), iconImage, 50, 50);
        this.createIconFile(new File(iconDirectory, "iPadSpotlight@2x.png"), iconImage, 100, 100);
        this.createIconFile(new File(iconDirectory, "iPadApp.png"), iconImage, 72, 72);
        this.createIconFile(new File(iconDirectory, "iPadApp@2x.png"), iconImage, 144, 144);
        this.createIconFile(new File(iconDirectory, "iPadApp7.png"), iconImage, 76, 76);
        this.createIconFile(new File(iconDirectory, "iPadApp7@2x.png"), iconImage, 152, 152);
        this.createIconFile(new File(iconDirectory, "iPadPro@2x.png"), iconImage, 167, 167);
        this.createIconFile(new File(iconDirectory, "AppStore.png"), iconImage, 1024, 1024);
        IPhoneBuilder.copy(this.icon512, new File(resDir, this.icon512.getName()));
        IPhoneBuilder.copy(this.icon57, new File(resDir, this.icon57.getName()));
        this.copyIcons(iconDirectory, resDir, "iPhoneNotification@2x.png", "iPhoneNotification@3x.png", "iPhoneSpotlight.png", "iPhoneSpotlight@2x.png", "iPhoneSpotlight@3x.png", "iPhone7Spotlight@2x.png", "iPhone7Spotlight@3x.png", "iPhoneApp.png", "iPhoneApp@2x.png", "iPhone7App@2x.png", "iPhone7App@3x.png", "iPadNotifications.png", "iPadNotification@2x.png", "iPadSettings.png", "iPadSettings@2x.png", "iPadSpotlight7.png", "iPadSpotlight7@2x.png", "iPadSpotlight.png", "iPadSpotlight@2x.png", "iPadApp.png", "iPadApp@2x.png", "iPadApp7.png", "iPadApp7@2x.png", "iPadPro@2x.png", "AppStore.png");
        return true;
    }

    private boolean generateLaunchScreen(BuildRequest request) throws Exception {
        File buildinRes = this.getBuildinRes();
        File resDir = this.getResDir();
        File iconDirectory = this.getIconDirectory(request);
        if (this.xcodeVersion >= 9) {
            File launchFgImage = new File(resDir, "Launch.Foreground.png");
            if (!launchFgImage.exists()) {
                IPhoneBuilder.copy(new File(iconDirectory, "iPadApp7@2x.png"), launchFgImage);
            }
            File defaultLaunchStoryBoard = new File(buildinRes, "LaunchScreen-Default.storyboard");
            File launchStoryBoard = new File(buildinRes, "LaunchScreen.storyboard");
            if (!launchStoryBoard.exists()) {
                IPhoneBuilder.copy(defaultLaunchStoryBoard, launchStoryBoard);
            }
            defaultLaunchStoryBoard.delete();
        }
        return true;
    }

    private static String createReverseGoogleClientId(String clientId) {
        String[] parts = clientId.split("\\.");
        return IPhoneBuilder.join(IPhoneBuilder.reverse(parts), ".");
    }

    private static String[] reverse(String[] input) {
        int len = input.length;
        String[] output = new String[len];
        for (int i = 0; i < len; ++i) {
            output[i] = input[len - i - 1];
        }
        return output;
    }

    private static String join(String[] strs, String sep) {
        StringBuilder out = new StringBuilder();
        boolean first = true;
        for (String str : strs) {
            if (first) {
                first = false;
            } else {
                out.append(sep);
            }
            out.append(str);
        }
        return out.toString();
    }

    static {
        osVersion = System.getProperty("os.version");
        StringTokenizer versionTok = new StringTokenizer(osVersion, ".");
        majorOSVersion = Integer.parseInt(versionTok.nextToken());
        minorOSVersion = Integer.parseInt(versionTok.nextToken());
    }

    private class GoogleServicePlist {
        String reverseClientId;
        String clientId;
        boolean useSignIn;

        private GoogleServicePlist() {
        }
    }
}

