/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.builders.util;

final class JSONSanitizer {
    public static final int DEFAULT_NESTING_DEPTH = 64;
    public static final int MAXIMUM_NESTING_DEPTH = 4096;
    private final int maximumNestingDepth;
    private final String jsonish;
    private int bracketDepth;
    private boolean[] isMap;
    private StringBuilder sanitizedJson;
    private int cleaned;
    private static final boolean SUPER_VERBOSE_AND_SLOW_LOGGING = false;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String sanitize(String jsonish) {
        return JSONSanitizer.sanitize(jsonish, 64);
    }

    public static String sanitize(String jsonish, int maximumNestingDepth) {
        JSONSanitizer s = new JSONSanitizer(jsonish, maximumNestingDepth);
        s.sanitize();
        return s.toString();
    }

    JSONSanitizer(String jsonish) {
        this(jsonish, 64);
    }

    JSONSanitizer(String jsonish, int maximumNestingDepth) {
        this.maximumNestingDepth = Math.min(Math.max(1, maximumNestingDepth), 4096);
        this.jsonish = jsonish != null ? jsonish : "null";
    }

    int getMaximumNestingDepth() {
        return this.maximumNestingDepth;
    }

    void sanitize() {
        this.cleaned = 0;
        this.bracketDepth = 0;
        this.sanitizedJson = null;
        State state = State.START_ARRAY;
        int n = this.jsonish.length();
        block33: for (int i = 0; i < n; ++i) {
            try {
                char ch = this.jsonish.charAt(i);
                block1 : switch (ch) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        state = this.requireValueState(i, state, true);
                        int strEnd = JSONSanitizer.endOfQuotedString(this.jsonish, i);
                        this.sanitizeString(i, strEnd);
                        i = strEnd - 1;
                        break;
                    }
                    case '(': 
                    case ')': {
                        this.elide(i, i + 1);
                        break;
                    }
                    case '[': 
                    case '{': {
                        boolean map;
                        state = this.requireValueState(i, state, false);
                        if (this.isMap == null) {
                            this.isMap = new boolean[this.maximumNestingDepth];
                        }
                        this.isMap[this.bracketDepth] = map = ch == '{';
                        ++this.bracketDepth;
                        state = map ? State.START_MAP : State.START_ARRAY;
                        break;
                    }
                    case ']': 
                    case '}': {
                        char closeBracket;
                        if (this.bracketDepth == 0) {
                            this.elide(i, this.jsonish.length());
                            break block33;
                        }
                        switch (state) {
                            case BEFORE_VALUE: {
                                this.insert(i, "null");
                                break;
                            }
                            case BEFORE_ELEMENT: 
                            case BEFORE_KEY: {
                                this.elideTrailingComma(i);
                                break;
                            }
                            case AFTER_KEY: {
                                this.insert(i, ":null");
                                break;
                            }
                        }
                        --this.bracketDepth;
                        char c = closeBracket = this.isMap[this.bracketDepth] ? (char)'}' : ']';
                        if (ch != closeBracket) {
                            this.replace(i, i + 1, closeBracket);
                        }
                        state = this.bracketDepth == 0 || !this.isMap[this.bracketDepth - 1] ? State.AFTER_ELEMENT : State.AFTER_VALUE;
                        break;
                    }
                    case ',': {
                        if (this.bracketDepth == 0) {
                            throw new RuntimeException("Unbracketed comma");
                        }
                        switch (state) {
                            case AFTER_ELEMENT: {
                                state = State.BEFORE_ELEMENT;
                                break block1;
                            }
                            case AFTER_VALUE: {
                                state = State.BEFORE_KEY;
                                break block1;
                            }
                            case BEFORE_ELEMENT: 
                            case START_ARRAY: {
                                this.insert(i, "null");
                                state = State.BEFORE_ELEMENT;
                                break block1;
                            }
                            case BEFORE_KEY: 
                            case AFTER_KEY: 
                            case START_MAP: {
                                this.elide(i, i + 1);
                                break block1;
                            }
                            case BEFORE_VALUE: {
                                this.insert(i, "null");
                                state = State.BEFORE_KEY;
                            }
                        }
                        break;
                    }
                    case ':': {
                        if (state == State.AFTER_KEY) {
                            state = State.BEFORE_VALUE;
                            break;
                        }
                        this.elide(i, i + 1);
                        break;
                    }
                    case '/': {
                        int end = i + 1;
                        if (i + 1 < n) {
                            block23 : switch (this.jsonish.charAt(i + 1)) {
                                case '/': {
                                    int j;
                                    end = n;
                                    for (j = i + 2; j < n; ++j) {
                                        char cch = this.jsonish.charAt(j);
                                        if (cch != '\n' && cch != '\r' && cch != '\u2028' && cch != '\u2029') continue;
                                        end = j + 1;
                                        break block23;
                                    }
                                    break;
                                }
                                case '*': {
                                    end = n;
                                    if (i + 3 >= n) break;
                                    int j = i + 2;
                                    while ((j = this.jsonish.indexOf(47, j + 1)) >= 0) {
                                        if (this.jsonish.charAt(j - 1) != '*') continue;
                                        end = j + 1;
                                        break block23;
                                    }
                                    break;
                                }
                            }
                        }
                        this.elide(i, end);
                        i = end - 1;
                        break;
                    }
                    default: {
                        boolean isKeyword;
                        char tch;
                        int runEnd;
                        for (runEnd = i; runEnd < n && ('a' <= (tch = this.jsonish.charAt(runEnd)) && tch <= 'z' || '0' <= tch && tch <= '9' || tch == '+' || tch == '-' || tch == '.' || 'A' <= tch && tch <= 'Z' || tch == '_' || tch == '$'); ++runEnd) {
                        }
                        if (runEnd == i) {
                            this.elide(i, i + 1);
                            break;
                        }
                        state = this.requireValueState(i, state, true);
                        boolean isNumber = '0' <= ch && ch <= '9' || ch == '.' || ch == '+' || ch == '-';
                        boolean bl = isKeyword = !isNumber && this.isKeyword(i, runEnd);
                        if (!isNumber && !isKeyword) {
                            while (runEnd < n && !this.isJsonSpecialChar(runEnd)) {
                                ++runEnd;
                            }
                            if (runEnd < n && this.jsonish.charAt(runEnd) == '\"') {
                                ++runEnd;
                            }
                        }
                        if (state == State.AFTER_KEY) {
                            this.insert(i, '\"');
                            if (isNumber) {
                                this.canonicalizeNumber(i, runEnd);
                                this.insert(runEnd, '\"');
                            } else {
                                this.sanitizeString(i, runEnd);
                            }
                        } else if (isNumber) {
                            this.normalizeNumber(i, runEnd);
                        } else if (!isKeyword) {
                            this.insert(i, '\"');
                            this.sanitizeString(i, runEnd);
                        }
                        i = runEnd - 1;
                        break;
                    }
                }
                continue;
            }
            catch (UnbracketedComma e) {
                this.elide(i, this.jsonish.length());
                break;
            }
        }
        if (state == State.START_ARRAY && this.bracketDepth == 0) {
            this.insert(n, "null");
            state = State.AFTER_ELEMENT;
        }
        if (this.sanitizedJson != null && this.sanitizedJson.length() != 0 || this.cleaned != 0 || this.bracketDepth != 0) {
            if (this.sanitizedJson == null) {
                this.sanitizedJson = new StringBuilder(n + this.bracketDepth);
            }
            this.sanitizedJson.append(this.jsonish.substring(this.cleaned, n));
            this.cleaned = n;
            switch (state) {
                case BEFORE_ELEMENT: 
                case BEFORE_KEY: {
                    this.elideTrailingComma(n);
                    break;
                }
                case AFTER_KEY: {
                    this.sanitizedJson.append(":null");
                    break;
                }
                case BEFORE_VALUE: {
                    this.sanitizedJson.append("null");
                    break;
                }
            }
            while (this.bracketDepth != 0) {
                this.sanitizedJson.append(this.isMap[--this.bracketDepth] ? (char)'}' : ']');
            }
        }
    }

    private void sanitizeString(int start, int end) {
        boolean closed = false;
        block17: for (int i = start; i < end; ++i) {
            char ch = this.jsonish.charAt(i);
            switch (ch) {
                case '\n': {
                    this.replace(i, i + 1, "\\n");
                    continue block17;
                }
                case '\r': {
                    this.replace(i, i + 1, "\\r");
                    continue block17;
                }
                case '\u2028': {
                    this.replace(i, i + 1, "\\u2028");
                    continue block17;
                }
                case '\u2029': {
                    this.replace(i, i + 1, "\\u2029");
                    continue block17;
                }
                case '\"': 
                case '\'': {
                    if (i == start) {
                        if (ch != '\'') continue block17;
                        this.replace(i, i + 1, '\"');
                        continue block17;
                    }
                    if (i + 1 == end) {
                        char startDelim = this.jsonish.charAt(start);
                        if (startDelim != '\'') {
                            startDelim = '\"';
                        }
                        boolean bl = closed = startDelim == ch;
                    }
                    if (closed) {
                        if (ch != '\'') continue block17;
                        this.replace(i, i + 1, '\"');
                        continue block17;
                    }
                    if (ch != '\"') continue block17;
                    this.insert(i, '\\');
                    continue block17;
                }
                case '/': {
                    if (i <= start || i + 2 >= end || '<' != this.jsonish.charAt(i - 1) || 115 != (this.jsonish.charAt(i + 1) | 0x20) || 99 != (this.jsonish.charAt(i + 2) | 0x20)) continue block17;
                    this.insert(i, '\\');
                    continue block17;
                }
                case ']': {
                    if (i + 2 >= end || ']' != this.jsonish.charAt(i + 1) || '>' != this.jsonish.charAt(i + 2)) continue block17;
                    this.replace(i, i + 1, "\\u005d");
                    continue block17;
                }
                case '\\': {
                    if (i + 1 == end) {
                        this.elide(i, i + 1);
                        continue block17;
                    }
                    char sch = this.jsonish.charAt(i + 1);
                    switch (sch) {
                        case '\"': 
                        case '/': 
                        case '\\': 
                        case 'b': 
                        case 'f': 
                        case 'n': 
                        case 'r': 
                        case 't': {
                            ++i;
                            continue block17;
                        }
                        case 'v': {
                            this.replace(i, i + 2, "\\u0008");
                            ++i;
                            continue block17;
                        }
                        case 'x': {
                            if (i + 4 < end && this.isHexAt(i + 2) && this.isHexAt(i + 3)) {
                                this.replace(i, i + 2, "\\u00");
                                i += 3;
                                continue block17;
                            }
                            this.elide(i, i + 1);
                            continue block17;
                        }
                        case 'u': {
                            if (i + 6 < end && this.isHexAt(i + 2) && this.isHexAt(i + 3) && this.isHexAt(i + 4) && this.isHexAt(i + 5)) {
                                i += 5;
                                continue block17;
                            }
                            this.elide(i, i + 1);
                            continue block17;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            int octalEnd = i + 1;
                            if (octalEnd + 1 < end && this.isOctAt(octalEnd + 1)) {
                                if (ch <= '3' && ++octalEnd + 1 < end && this.isOctAt(octalEnd + 1)) {
                                    ++octalEnd;
                                }
                                int value = 0;
                                for (int j = i; j < octalEnd; ++j) {
                                    value = value << 3 | this.jsonish.charAt(j) - 48;
                                }
                                this.replace(i + 1, octalEnd, "u00");
                                this.appendHex(value, 2);
                            }
                            i = octalEnd - 1;
                            continue block17;
                        }
                    }
                    this.elide(i, i + 1);
                    continue block17;
                }
                default: {
                    if (ch < ' ') {
                        if (ch == '\t' || ch == '\n' || ch == '\r') {
                            continue block17;
                        }
                    } else {
                        if (ch < '\ud800') continue block17;
                        if (ch < '\ue000') {
                            if (Character.isHighSurrogate(ch) && i + 1 < end && Character.isLowSurrogate(this.jsonish.charAt(i + 1))) {
                                ++i;
                                continue block17;
                            }
                        } else if (ch <= '\ufffd') continue block17;
                    }
                    this.replace(i, i + 1, "\\u");
                    int j = 4;
                    while (--j >= 0) {
                        this.sanitizedJson.append(HEX_DIGITS[ch >>> (j << 2) & 0xF]);
                    }
                    break block0;
                }
            }
        }
        if (!closed) {
            this.insert(end, '\"');
        }
    }

    private State requireValueState(int pos, State state, boolean canBeKey) throws UnbracketedComma {
        switch (state) {
            case BEFORE_KEY: 
            case START_MAP: {
                if (canBeKey) {
                    return State.AFTER_KEY;
                }
                this.insert(pos, "\"\":");
                return State.AFTER_VALUE;
            }
            case AFTER_KEY: {
                this.insert(pos, ':');
                return State.AFTER_VALUE;
            }
            case BEFORE_VALUE: {
                return State.AFTER_VALUE;
            }
            case AFTER_VALUE: {
                if (canBeKey) {
                    this.insert(pos, ',');
                    return State.AFTER_KEY;
                }
                this.insert(pos, ",\"\":");
                return State.AFTER_VALUE;
            }
            case BEFORE_ELEMENT: 
            case START_ARRAY: {
                return State.AFTER_ELEMENT;
            }
            case AFTER_ELEMENT: {
                if (this.bracketDepth == 0) {
                    throw new RuntimeException("Unbracketed comma");
                }
                this.insert(pos, ',');
                return State.AFTER_ELEMENT;
            }
        }
        throw new AssertionError();
    }

    private void insert(int pos, char ch) {
        this.replace(pos, pos, ch);
    }

    private void insert(int pos, String s) {
        this.replace(pos, pos, s);
    }

    private void elide(int start, int end) {
        if (this.sanitizedJson == null) {
            this.sanitizedJson = new StringBuilder(this.jsonish.length() + 16);
        }
        this.sanitizedJson.append(this.jsonish.substring(this.cleaned, start));
        this.cleaned = end;
    }

    private void replace(int start, int end, char ch) {
        this.elide(start, end);
        this.sanitizedJson.append(ch);
    }

    private void replace(int start, int end, String s) {
        this.elide(start, end);
        this.sanitizedJson.append(s);
    }

    private static int endOfQuotedString(String s, int start) {
        char quote = s.charAt(start);
        int i = start;
        while ((i = s.indexOf(quote, i + 1)) >= 0) {
            int slashRunStart;
            for (slashRunStart = i; slashRunStart > start && s.charAt(slashRunStart - 1) == '\\'; --slashRunStart) {
            }
            if ((i - slashRunStart & 1) != 0) continue;
            return i + 1;
        }
        return s.length();
    }

    private void elideTrailingComma(int closeBracketPos) {
        int i = closeBracketPos;
        block8: while (--i >= this.cleaned) {
            switch (this.jsonish.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block8;
                }
                case ',': {
                    this.elide(i, i + 1);
                    return;
                }
            }
            throw new AssertionError((Object)("" + this.jsonish.charAt(i)));
        }
        assert (this.sanitizedJson != null);
        i = this.sanitizedJson.length();
        block9: while (--i >= 0) {
            switch (this.sanitizedJson.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block9;
                }
                case ',': {
                    this.sanitizedJson.setLength(i);
                    return;
                }
            }
            throw new AssertionError((Object)("" + this.sanitizedJson.charAt(i)));
        }
        throw new AssertionError((Object)("Trailing comma not found in " + this.jsonish + " or " + this.sanitizedJson));
    }

    private void normalizeNumber(int start, int end) {
        int intEnd;
        int pos = start;
        if (pos < end) {
            switch (this.jsonish.charAt(pos)) {
                case '+': {
                    this.elide(pos, pos + 1);
                    ++pos;
                    break;
                }
                case '-': {
                    ++pos;
                    break;
                }
            }
        }
        if (pos == (intEnd = this.endOfDigitRun(pos, end))) {
            this.insert(pos, '0');
        } else if ('0' == this.jsonish.charAt(pos)) {
            int digVal;
            boolean reencoded = false;
            long value = 0L;
            if (intEnd - pos == 1 && intEnd < end && 120 == (this.jsonish.charAt(intEnd) | 0x20)) {
                ++intEnd;
                while (intEnd < end) {
                    char ch = this.jsonish.charAt(intEnd);
                    if ('0' <= ch && ch <= '9') {
                        digVal = ch - 48;
                    } else {
                        if ('a' > (ch = (char)(ch | 0x20)) || ch > 'f') break;
                        digVal = ch - 87;
                    }
                    value = value << 4 | (long)digVal;
                    ++intEnd;
                }
                reencoded = true;
            } else if (intEnd - pos > 1) {
                for (int i = pos; i < intEnd && (digVal = this.jsonish.charAt(i) - 48) >= 0; ++i) {
                    value = value << 3 | (long)digVal;
                }
                reencoded = true;
            }
            if (reencoded) {
                char last;
                int lastIndex;
                this.elide(pos, intEnd);
                if (value < 0L && (lastIndex = this.sanitizedJson.length() - 1) >= 0 && ((last = this.sanitizedJson.charAt(lastIndex)) == '-' || last == '+')) {
                    this.elide(lastIndex, lastIndex + 1);
                    if (last == '-') {
                        value = -value;
                    }
                }
                this.sanitizedJson.append(value);
            }
        }
        pos = intEnd;
        if (pos < end && this.jsonish.charAt(pos) == '.') {
            int fractionEnd;
            if ((fractionEnd = this.endOfDigitRun(++pos, end)) == pos) {
                this.insert(pos, '0');
            }
            pos = fractionEnd;
        }
        if (pos < end && 101 == (this.jsonish.charAt(pos) | 0x20)) {
            int expEnd;
            if (++pos < end) {
                switch (this.jsonish.charAt(pos)) {
                    case '+': 
                    case '-': {
                        ++pos;
                        break;
                    }
                }
            }
            if ((expEnd = this.endOfDigitRun(pos, end)) == pos) {
                this.insert(pos, '0');
            }
            pos = expEnd;
        }
        if (pos != end) {
            this.elide(pos, end);
        }
    }

    private boolean canonicalizeNumber(int start, int end) {
        this.elide(start, start);
        int sanStart = this.sanitizedJson.length();
        this.normalizeNumber(start, end);
        this.elide(end, end);
        int sanEnd = this.sanitizedJson.length();
        return JSONSanitizer.canonicalizeNumber(this.sanitizedJson, sanStart, sanEnd);
    }

    private static boolean canonicalizeNumber(StringBuilder sanitizedJson, int sanStart, int sanEnd) {
        int exp;
        int expStart;
        int expEnd;
        int fractionStart;
        int fractionEnd;
        int intStart;
        char ch;
        int intEnd;
        for (intEnd = intStart = sanStart + (sanitizedJson.charAt(sanStart) == '-' ? 1 : 0); intEnd < sanEnd && '0' <= (ch = sanitizedJson.charAt(intEnd)) && ch <= '9'; ++intEnd) {
        }
        if (intEnd == sanEnd || '.' != sanitizedJson.charAt(intEnd)) {
            fractionStart = fractionEnd = intEnd;
        } else {
            for (fractionEnd = fractionStart = intEnd + 1; fractionEnd < sanEnd && '0' <= (ch = sanitizedJson.charAt(fractionEnd)) && ch <= '9'; ++fractionEnd) {
            }
        }
        if (fractionEnd == sanEnd) {
            expStart = expEnd = sanEnd;
        } else {
            assert (101 == (sanitizedJson.charAt(fractionEnd) | 0x20));
            expStart = fractionEnd + 1;
            if (sanitizedJson.charAt(expStart) == '+') {
                ++expStart;
            }
            expEnd = sanEnd;
        }
        assert (intStart <= intEnd && intEnd <= fractionStart && fractionStart <= fractionEnd && fractionEnd <= expStart && expStart <= expEnd);
        if (expEnd == expStart) {
            exp = 0;
        } else {
            try {
                exp = Integer.parseInt(sanitizedJson.toString().substring(expStart, expEnd), 10);
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        int n = exp;
        boolean sawDecimal = false;
        boolean zero = true;
        int digitOutPos = intStart;
        int nZeroesPending = 0;
        for (int i = intStart; i < fractionEnd; ++i) {
            char ch2 = sanitizedJson.charAt(i);
            if (ch2 == '.') {
                sawDecimal = true;
                if (!zero) continue;
                nZeroesPending = 0;
                continue;
            }
            char digit = ch2;
            if (!(zero && digit == '0' || sawDecimal)) {
                ++n;
            }
            if (digit == '0') {
                ++nZeroesPending;
                continue;
            }
            if (zero) {
                if (sawDecimal) {
                    n -= nZeroesPending;
                }
                nZeroesPending = 0;
            }
            zero = false;
            while (nZeroesPending != 0 || digit != '\u0000') {
                char vdigit;
                if (nZeroesPending == 0) {
                    vdigit = digit;
                    digit = '\u0000';
                } else {
                    vdigit = '0';
                    --nZeroesPending;
                }
                sanitizedJson.setCharAt(digitOutPos++, vdigit);
            }
        }
        sanitizedJson.setLength(digitOutPos);
        int k = digitOutPos - intStart;
        if (zero) {
            sanitizedJson.setLength(sanStart);
            sanitizedJson.append('0');
            return true;
        }
        if (k <= n && n <= 21) {
            for (int i = k; i < n; ++i) {
                sanitizedJson.append('0');
            }
        } else if (0 < n && n <= 21) {
            sanitizedJson.insert(intStart + n, '.');
        } else if (-6 < n && n <= 0) {
            sanitizedJson.insert(intStart, "0.000000".substring(0, 2 - n));
        } else {
            if (k != 1) {
                sanitizedJson.insert(intStart + 1, '.');
            }
            int nLess1 = n - 1;
            sanitizedJson.append('e').append(nLess1 < 0 ? (char)'-' : '+').append(Math.abs(nLess1));
        }
        return true;
    }

    private static boolean regionMatches(String s1, int offset, String s2, int ooffset, int len) {
        for (int i = 0; i < len; ++i) {
            if (s1.charAt(offset + i) == s2.charAt(ooffset + i)) continue;
            return false;
        }
        return true;
    }

    private boolean isKeyword(int start, int end) {
        int n = end - start;
        if (n == 5) {
            return JSONSanitizer.regionMatches("false", 0, this.jsonish, start, n);
        }
        if (n == 4) {
            return JSONSanitizer.regionMatches("null", 0, this.jsonish, start, n) || JSONSanitizer.regionMatches("true", 0, this.jsonish, start, n);
        }
        return false;
    }

    private boolean isOctAt(int i) {
        char ch = this.jsonish.charAt(i);
        return '0' <= ch && ch <= '7';
    }

    private boolean isHexAt(int i) {
        char ch = this.jsonish.charAt(i);
        if ('0' <= ch && ch <= '9') {
            return true;
        }
        return 'a' <= (ch = (char)(ch | 0x20)) && ch <= 'f';
    }

    private boolean isJsonSpecialChar(int i) {
        char ch = this.jsonish.charAt(i);
        if (ch <= ' ') {
            return true;
        }
        switch (ch) {
            case '\"': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private void appendHex(int n, int nDigits) {
        int i = 0;
        int x = n;
        while (i < nDigits) {
            int dig;
            this.sanitizedJson.append(dig + ((dig = x & 0xF) < 10 ? 48 : 87));
            ++i;
            x >>>= 4;
        }
    }

    private int endOfDigitRun(int start, int limit) {
        for (int end = start; end < limit; ++end) {
            char ch = this.jsonish.charAt(end);
            if ('0' <= ch && ch <= '9') continue;
            return end;
        }
        return limit;
    }

    public String toString() {
        return this.sanitizedJson != null ? this.sanitizedJson.toString() : this.jsonish;
    }

    private static final class UnbracketedComma
    extends Exception {
        private static final long serialVersionUID = 783239978717247850L;

        private UnbracketedComma() {
        }
    }

    private static enum State {
        START_ARRAY,
        BEFORE_ELEMENT,
        AFTER_ELEMENT,
        START_MAP,
        BEFORE_KEY,
        AFTER_KEY,
        BEFORE_VALUE,
        AFTER_VALUE;

    }
}

