/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.builders.util;

import com.codename1.builders.util.IOProgressListener;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class Util {
    public static void copy(InputStream i, OutputStream o) throws IOException {
        Util.copy(i, o, 8192);
    }

    public static void copyNoClose(InputStream i, OutputStream o, int bufferSize) throws IOException {
        Util.copyNoClose(i, o, bufferSize, null);
    }

    public static void copyNoClose(InputStream i, OutputStream o, int bufferSize, IOProgressListener callback) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int size = i.read(buffer);
        int total = 0;
        while (size > -1) {
            o.write(buffer, 0, size);
            if (callback != null) {
                callback.ioStreamUpdate(i, total += size);
            }
            size = i.read(buffer);
        }
    }

    public static void copy(InputStream i, OutputStream o, int bufferSize) throws IOException {
        try {
            Util.copyNoClose(i, o, bufferSize);
        }
        finally {
            Util.cleanup(o);
            Util.cleanup(i);
        }
    }

    public static void cleanup(Object o) {
        try {
            if (o != null) {
                if (o instanceof InputStream) {
                    ((InputStream)o).close();
                    return;
                }
                if (o instanceof OutputStream) {
                    ((OutputStream)o).close();
                    return;
                }
                if (o instanceof Reader) {
                    ((Reader)o).close();
                    return;
                }
                if (o instanceof Writer) {
                    ((Writer)o).close();
                    return;
                }
                if (o instanceof Closeable) {
                    ((Closeable)o).close();
                    return;
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static String readToString(InputStream i) throws IOException {
        return Util.readToString(i, "UTF-8");
    }

    public static String readToString(InputStream i, String encoding) throws IOException {
        byte[] b = Util.readInputStream(i);
        return new String(b, 0, b.length, encoding);
    }

    public static String readToString(Reader reader) throws IOException {
        int len;
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        while ((len = reader.read(buf)) != -1) {
            sb.append(buf, 0, len);
        }
        return sb.toString();
    }

    public static byte[] readInputStream(InputStream i) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        Util.copy(i, b);
        return b.toByteArray();
    }
}

