/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.ant.SortedProperties;
import com.codename1.maven.Cn1libUtil;
import com.codename1.maven.PathUtil;
import com.codename1.maven.ProjectUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.repository.RepositorySystem;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.Redirector;
import org.apache.tools.ant.types.FileSet;

public abstract class AbstractCN1Mojo
extends AbstractMojo {
    protected static final String GROUP_ID = "com.codenameone";
    protected static final String JAVA_RUNTIME_ARTIFACT_ID = "java-runtime";
    protected static final String ARTIFACT_ID = "codenameone-maven-plugin";
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="project.build.directory", readonly=true)
    protected String outputDirectory;
    @Parameter(property="cn1lib.stubber.excludes", defaultValue="")
    protected String stubberExcludes;
    @Parameter(property="cn1lib.stubber.includes", defaultValue="**")
    protected String stubberIncludes;
    @Parameter(property="project.build.finalName", readonly=true)
    protected String finalName;
    protected Project antProject;
    @Parameter(property="plugin.artifacts", required=true, readonly=true)
    protected List<Artifact> pluginArtifacts;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(required=true, readonly=true, defaultValue="${localRepository}")
    protected MavenArtifactRepository localRepository;
    @Parameter(required=true, readonly=true, defaultValue="${project.remoteArtifactRepositories}")
    protected List<MavenArtifactRepository> remoteRepositories;
    protected Properties properties;
    private File cn1libProjectDir;
    protected static final FilenameFilter ALL_FILES_FILTER = (dir, name) -> true;
    protected static final FilenameFilter NO_FILES_FILTER = (dir, name) -> false;
    private Properties mavenProperties;
    private SortedProperties projectProperties;
    public static final String UPDATE_CODENAMEONE_JAR_URL = "https://www.codenameone.com/files/updates/UpdateCodenameOne.jar";
    public static final String JPDATE_CODENAMEONE_JAR_PATH = System.getProperty("user.home") + File.separator + ".codenameone" + File.separator + "UpdateCodenameOne.jar";
    protected static String OS = System.getProperty("os.name").toLowerCase();
    protected static boolean isWindows = OS.indexOf("win") >= 0;
    protected static boolean isMac = OS.indexOf("mac") >= 0;
    protected static final String ARCH = System.getProperty("os.arch");
    protected static boolean isUnix = OS.indexOf("nux") >= 0;
    protected static final boolean is64Bit = AbstractCN1Mojo.is64Bit();

    protected long getSourcesModificationTime() throws IOException {
        return this.getSourcesModificationTime(false);
    }

    protected long getCSSSourcesModificationTime() throws IOException {
        File pomFile;
        File codenameOneSettings;
        long mTime = 0L;
        File root = this.getCN1ProjectDir().getCanonicalFile().getParentFile();
        File commonSources = new File(root, PathUtil.path("common", "src", "main", "css"));
        if (commonSources.exists()) {
            mTime = Math.max(mTime, AbstractCN1Mojo.lastModifiedRecursive(commonSources, ALL_FILES_FILTER));
        }
        if ((codenameOneSettings = new File(root, "common" + File.separator + "codenameone_settings.properties")).exists()) {
            mTime = Math.max(mTime, codenameOneSettings.lastModified());
        }
        if ((pomFile = new File(root, "common" + File.separator + "pom.xml")).exists()) {
            mTime = Math.max(mTime, pomFile.lastModified());
        }
        return mTime;
    }

    protected long getSourcesModificationTime(boolean commonOnly) throws IOException {
        String platform;
        File pomFile;
        File codenameOneSettings;
        File platformSourcesDir;
        String platform2;
        long mTime = 0L;
        File root = this.getCN1ProjectDir().getCanonicalFile().getParentFile();
        File commonSources = new File(root, "common" + File.separator + "src");
        if (commonSources.exists()) {
            mTime = Math.max(mTime, AbstractCN1Mojo.lastModifiedRecursive(commonSources, ALL_FILES_FILTER));
        }
        if (!commonOnly && (platform2 = this.project.getProperties().getProperty("codename1.platform")) != null && (platformSourcesDir = new File(root, platform2 + File.separator + "src")).exists()) {
            mTime = Math.max(mTime, AbstractCN1Mojo.lastModifiedRecursive(platformSourcesDir, ALL_FILES_FILTER));
        }
        if ((codenameOneSettings = new File(root, "common" + File.separator + "codenameone_settings.properties")).exists()) {
            mTime = Math.max(mTime, codenameOneSettings.lastModified());
        }
        if ((pomFile = new File(root, "common" + File.separator + "pom.xml")).exists()) {
            mTime = Math.max(mTime, pomFile.lastModified());
        }
        if (!commonOnly && (pomFile = new File(root, (platform = this.project.getProperties().getProperty("codename1.platform")) + File.separator + "pom.xml")).exists()) {
            mTime = Math.max(mTime, pomFile.lastModified());
        }
        return mTime;
    }

    private void setupAnt() throws MojoExecutionException, MojoFailureException {
        this.antProject = new Project();
        if (this.project.getBasedir() != null) {
            this.antProject.setBaseDir(this.project.getBasedir());
        } else {
            this.antProject.setBaseDir(new File("."));
        }
        this.antProject.setDefaultInputStream(System.in);
        DefaultInputHandler handler = new DefaultInputHandler();
        this.antProject.setProjectReference((Object)handler);
        this.antProject.setInputHandler((InputHandler)handler);
        this.antProject.init();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getCN1ProjectDir() != null) {
            this.properties = new Properties();
            File cn1Properties = new File(this.getCN1ProjectDir(), "codenameone_settings.properties");
            if (cn1Properties.exists()) {
                try {
                    this.properties.load(new FileInputStream(new File(this.getCN1ProjectDir(), "codenameone_settings.properties")));
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Failed to find codenameone_settings.properties file.", (Exception)ex);
                }
            }
        } else {
            this.getLog().warn((CharSequence)"Failed to find CN1 Project directory.  codenameone_settings.properties will not be loaded");
            if (this.project.getCompileSourceRoots() != null && !this.project.getCompileSourceRoots().isEmpty()) {
                this.getLog().warn((CharSequence)("Checking from project root and source compile root: " + (String)this.project.getCompileSourceRoots().get(0)));
            }
        }
        this.setupAnt();
        this.executeImpl();
    }

    protected abstract void executeImpl() throws MojoExecutionException, MojoFailureException;

    protected static boolean contains(String needle, String ... haystack) {
        for (String s : haystack) {
            if (!s.equals(needle)) continue;
            return true;
        }
        return false;
    }

    protected File getCN1ProjectDir() {
        if (this.project == null || this.project.getBasedir() == null) {
            return null;
        }
        if (AbstractCN1Mojo.contains(this.project.getBasedir().getName(), "javase", "javascript", "android", "ios", "win")) {
            File commonSettings = new File(this.project.getBasedir(), ".." + File.separator + "common" + File.separator + "codenameone_settings.properties");
            if (commonSettings.exists()) {
                return commonSettings.getParentFile();
            }
            commonSettings = new File(this.project.getBasedir(), ".." + File.separator + "common" + File.separator + "codenameone_library_appended.properties");
            if (commonSettings.exists()) {
                return commonSettings.getParentFile();
            }
        }
        File commonSubdir = new File(this.project.getBasedir(), "common");
        if (!new File("codenameone_settings.properties").exists() && commonSubdir.exists() && new File(commonSubdir, "codenameone_settings.properties").exists()) {
            return commonSubdir;
        }
        File f = this.getCN1ProjectDir(this.project.getBasedir());
        if (f != null) {
            return f;
        }
        f = this.getCN1ProjectDir(new File((String)this.project.getCompileSourceRoots().get(0)).getParentFile());
        return f;
    }

    private File getCN1ProjectDir(File start) {
        File f = new File(start, "codenameone_settings.properties");
        while (!f.exists() && f.getParentFile() != null && f.getParentFile().getParentFile() != null) {
            if ((f = new File(f.getParentFile().getParentFile(), "codenameone_settings.properties")).exists()) {
                return f.getParentFile();
            }
            if (!(f = new File(f.getParentFile().getParentFile(), "codenameone_library_appended.properties")).exists()) continue;
            return f.getParentFile();
        }
        return f.exists() ? f.getParentFile() : null;
    }

    public Java createJava() {
        return this.createJava(0);
    }

    public Java createJava(final int logLevel) {
        Java java = new Java(){
            {
                this.redirector = new Redirector((Task)this){

                    protected void handleOutput(String output) {
                        switch (logLevel) {
                            case 0: {
                                AbstractCN1Mojo.this.getLog().debug((CharSequence)output);
                                break;
                            }
                            case 5: {
                                break;
                            }
                            case 3: {
                                AbstractCN1Mojo.this.getLog().error((CharSequence)output);
                                break;
                            }
                            case 1: {
                                AbstractCN1Mojo.this.getLog().info((CharSequence)output);
                                break;
                            }
                            case 2: {
                                AbstractCN1Mojo.this.getLog().warn((CharSequence)output);
                            }
                        }
                    }

                    protected void handleErrorOutput(String output) {
                        AbstractCN1Mojo.this.getLog().error((CharSequence)output);
                    }
                };
            }

            protected void handleOutput(String output) {
                switch (logLevel) {
                    case 0: {
                        AbstractCN1Mojo.this.getLog().debug((CharSequence)output);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 3: {
                        AbstractCN1Mojo.this.getLog().error((CharSequence)output);
                        break;
                    }
                    case 1: {
                        AbstractCN1Mojo.this.getLog().info((CharSequence)output);
                        break;
                    }
                    case 2: {
                        AbstractCN1Mojo.this.getLog().warn((CharSequence)output);
                    }
                }
            }

            protected void handleErrorOutput(String output) {
                AbstractCN1Mojo.this.getLog().error((CharSequence)output);
            }

            protected void handleFlush(String output) {
                switch (logLevel) {
                    case 0: {
                        AbstractCN1Mojo.this.getLog().debug((CharSequence)output);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 3: {
                        AbstractCN1Mojo.this.getLog().error((CharSequence)output);
                        break;
                    }
                    case 1: {
                        AbstractCN1Mojo.this.getLog().info((CharSequence)output);
                        break;
                    }
                    case 2: {
                        AbstractCN1Mojo.this.getLog().warn((CharSequence)output);
                    }
                }
            }

            public void log(String msg) {
                AbstractCN1Mojo.this.getLog().info((CharSequence)msg);
            }

            public void log(String msg, int msgLevel) {
                AbstractCN1Mojo.this.getLog().info((CharSequence)msg);
            }
        };
        java.setProject(this.antProject);
        return java;
    }

    protected File getJar(String groupId, String artifactId) {
        Artifact art = this.getArtifact(groupId, artifactId);
        if (art == null) {
            return null;
        }
        return this.getJar(art);
    }

    protected Artifact getArtifact(String groupId, String artifactId) {
        Artifact out = this.project.getArtifacts().stream().filter(art -> art.getArtifactId().equals(artifactId) && art.getGroupId().equals(groupId)).findFirst().orElse(null);
        if (out != null) {
            return out;
        }
        out = this.pluginArtifacts.stream().filter(art -> art.getArtifactId().equals(artifactId) && art.getGroupId().equals(groupId)).findFirst().orElse(null);
        return out;
    }

    protected File getJar(String groupId, String artifactId, String classifier) {
        Artifact art = this.getArtifact(groupId, artifactId, classifier);
        if (art == null) {
            return null;
        }
        return this.getJar(art);
    }

    protected Artifact getArtifact(String groupId, String artifactId, String classifier) {
        Artifact out = this.project.getArtifacts().stream().filter(art -> art.getArtifactId().equals(artifactId) && art.getGroupId().equals(groupId) && Objects.equals(art.getClassifier(), classifier)).findFirst().orElse(null);
        if (out != null) {
            return out;
        }
        out = this.pluginArtifacts.stream().filter(art -> art.getArtifactId().equals(artifactId) && art.getGroupId().equals(groupId) && Objects.equals(art.getClassifier(), classifier)).findFirst().orElse(null);
        return out;
    }

    protected File getJar(Artifact artifact) {
        File[] out = new File[]{artifact.getFile()};
        if (out[0] != null && !"pom.xml".equals(out[0].getName()) && !out[0].getName().endsWith(".pom")) {
            return out[0];
        }
        ArtifactResolutionResult result = this.repositorySystem.resolve(new ArtifactResolutionRequest().setLocalRepository((ArtifactRepository)this.localRepository).setRemoteRepositories(new ArrayList<MavenArtifactRepository>(this.remoteRepositories)).setResolveTransitively(true).setArtifact(artifact));
        if (result.isSuccess()) {
            out[0] = artifact.getFile().getAbsoluteFile();
        }
        if (out[0] == null || "pom.xml".equals(out[0].getName()) || out[0].getName().endsWith(".pom")) {
            return null;
        }
        return out[0];
    }

    protected File getCN1LibProjectDir() {
        if (this.cn1libProjectDir == null) {
            this.cn1libProjectDir = ProjectUtil.wrap(this.project).getCN1LibProjectDir();
        }
        return this.cn1libProjectDir;
    }

    protected static long lastModifiedRecursive(File file) {
        return AbstractCN1Mojo.lastModifiedRecursive(file, ALL_FILES_FILTER);
    }

    protected static long lastModifiedRecursive(File file, FilenameFilter filter) {
        long lastModified = 0L;
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                lastModified = Math.max(AbstractCN1Mojo.lastModifiedRecursive(child, filter), lastModified);
            }
        }
        if (filter.accept(file.getParentFile(), file.getName())) {
            lastModified = Math.max(file.lastModified(), lastModified);
        }
        return lastModified;
    }

    protected Dependency createSystemScopeDependency(String artifactId, String groupId, String version, File location) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId + "-jar");
        dependency.setVersion(version);
        dependency.setScope("system");
        dependency.setSystemPath(location.getAbsolutePath());
        dependency.setType("jar");
        dependency.setClassifier("jar");
        return dependency;
    }

    protected File getProjectCSSDir() {
        for (String dir : this.project.getCompileSourceRoots()) {
            File dirFile = new File(dir);
            File cssSibling = new File(dirFile.getParentFile(), "css");
            File themeCss = new File(cssSibling, "theme.css");
            if (!themeCss.exists()) continue;
            return cssSibling;
        }
        return new File(this.project.getBasedir() + File.separator + "src" + File.separator + "main" + File.separator + "css");
    }

    protected File getMavenPropertiesFile() {
        return new File(this.getCN1ProjectDir(), "codenameone_maven.properties");
    }

    protected static void delTree(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                AbstractCN1Mojo.delTree(child);
            }
        }
        file.delete();
    }

    protected Properties getMavenProperties() throws IOException {
        if (this.mavenProperties == null) {
            File mavenPropertiesFile = this.getMavenPropertiesFile();
            this.mavenProperties = new Properties();
            if (mavenPropertiesFile.exists()) {
                try (FileInputStream fis = new FileInputStream(mavenPropertiesFile);){
                    this.mavenProperties.load(fis);
                }
            }
        }
        return this.mavenProperties;
    }

    protected void saveMavenProperties() throws IOException {
        try (FileOutputStream fos = new FileOutputStream(this.getMavenPropertiesFile());){
            this.getMavenProperties().store(fos, "Updated dependencies");
        }
    }

    protected void saveProjectProperties() throws IOException {
        if (this.projectProperties != null) {
            try (FileOutputStream fos = new FileOutputStream(this.getProjectPropertiesFile());){
                this.projectProperties.store(fos, "saved project properties from installCn1libsMojo");
            }
        }
    }

    protected File getProjectPropertiesFile() {
        return new File(this.getCN1ProjectDir(), "codenameone_settings.properties");
    }

    protected SortedProperties getProjectProperties() throws IOException {
        if (this.projectProperties == null) {
            this.projectProperties = new SortedProperties();
            File propertiesFile = this.getProjectPropertiesFile();
            if (propertiesFile.exists()) {
                try (FileInputStream fis = new FileInputStream(propertiesFile);){
                    this.projectProperties.load(fis);
                }
            }
        }
        return this.projectProperties;
    }

    protected long getLastModified(Artifact artifact) {
        File f = this.findArtifactFile(artifact);
        if (f != null) {
            return f.lastModified();
        }
        return 0L;
    }

    protected File getLibDirFor(Artifact artifact) {
        File artifactFile = this.findArtifactFile(artifact);
        File artifactDir = new File(artifactFile.getParentFile(), artifactFile.getName() + "-extracted");
        return artifactDir;
    }

    protected File findArtifactFile(Artifact artifact) {
        File[] out = new File[1];
        ArtifactResolutionResult result = this.repositorySystem.resolve(new ArtifactResolutionRequest().setLocalRepository((ArtifactRepository)this.localRepository).setRemoteRepositories(new ArrayList<MavenArtifactRepository>(this.remoteRepositories)).setResolveTransitively(true).setArtifact(artifact));
        if (result.isSuccess()) {
            out[0] = artifact.getFile().getAbsoluteFile();
        }
        return out[0];
    }

    protected List<File> getLibsNativeJarsForPlatform(String platform) {
        this.getLog().debug((CharSequence)"Getting nativese source jars");
        ArrayList<File> out = new ArrayList<File>();
        for (Artifact artifact : this.project.getDependencyArtifacts()) {
            File artifactFile = artifact.getFile();
            this.getLog().debug((CharSequence)("Checking " + artifactFile));
            if (!Cn1libUtil.isCN1Lib(artifactFile)) {
                this.getLog().debug((CharSequence)"Not a cn1lib");
                continue;
            }
            File nativeSejar = Cn1libUtil.getNativeJar(artifact, platform);
            if (nativeSejar == null) continue;
            out.add(nativeSejar);
        }
        return out;
    }

    protected List<File> getLibsNativeSESourceJars() {
        this.getLog().debug((CharSequence)"Getting nativese source jars");
        ArrayList<File> out = new ArrayList<File>();
        for (Artifact artifact : this.project.getDependencyArtifacts()) {
            File artifactFile = artifact.getFile();
            this.getLog().debug((CharSequence)("Checking " + artifactFile));
            if (!Cn1libUtil.isCN1Lib(artifactFile)) {
                this.getLog().debug((CharSequence)"Not a cn1lib");
                continue;
            }
            File nativeSejar = Cn1libUtil.getNativeSEJar(artifact);
            if (nativeSejar == null) continue;
            out.add(nativeSejar);
        }
        return out;
    }

    protected List<File> getLibsNativeSEDependencyJars() {
        ArrayList<File> out = new ArrayList<File>();
        for (Artifact artifact : this.project.getDependencyArtifacts()) {
            File artifactFile = artifact.getFile();
            if (!Cn1libUtil.isCN1Lib(artifactFile)) continue;
            out.addAll(Cn1libUtil.getNativeSEEmbeddedJars(artifact));
        }
        return out;
    }

    protected File getProjectNativeSEDir() {
        return new File(this.getProjectNativeDir(), "javase");
    }

    protected File getProjectInternalTmpJar() {
        return new File(new File(this.project.getBuild().getOutputDirectory()).getParentFile(), "javase-classes.jar");
    }

    protected File getProjectInternalTmpDir() {
        return new File(new File(this.project.getBuild().getOutputDirectory()).getParentFile(), "javase-classes");
    }

    protected File getProjectNativeDir() {
        return new File(this.getCN1ProjectDir(), "native");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installUpdater() throws IOException {
        String destinationPath = JPDATE_CODENAMEONE_JAR_PATH;
        FileOutputStream os = null;
        InputStream is = null;
        try {
            File re = new File(destinationPath);
            if (!re.exists()) {
                this.getLog().info((CharSequence)"Installing Codename One Updater from https://www.codenameone.com/files/updates/UpdateCodenameOne.jar");
                is = new URL(UPDATE_CODENAMEONE_JAR_URL).openStream();
                os = new FileOutputStream(re);
                byte[] buf = new byte[65536];
                int len = 0;
                while ((len = is.read(buf)) > -1) {
                    os.write(buf, 0, len);
                }
            } else {
                this.getLog().debug((CharSequence)"Designer is up to date");
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    this.getLog().error((CharSequence)"Error closing output stream", (Throwable)ex);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    this.getLog().error((CharSequence)"Error closing input stream", (Throwable)ex);
                }
            }
        }
    }

    protected void updateCodenameOne(boolean force, File ... files) throws MojoExecutionException {
        try {
            this.installUpdater();
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"Failed to install Codename One updater");
            throw new MojoExecutionException("Failed to install codenameone updater", ex);
        }
        if (!force) {
            boolean missing = false;
            for (File f : files) {
                if (f.exists()) continue;
                missing = true;
                break;
            }
            if (!missing) {
                return;
            }
        }
        Java java = this.createJava();
        java.setFork(true);
        java.setJar(new File(JPDATE_CODENAMEONE_JAR_PATH));
        File dummyProject = new File(this.project.getBuild().getDirectory(), PathUtil.path("codenameone", "update-dummy"));
        File dummyProjectLib = new File(dummyProject, "lib");
        dummyProjectLib.mkdirs();
        File cn1Properties = new File(this.getCN1ProjectDir(), "codenameone_settings.properties");
        if (cn1Properties.exists()) {
            try {
                FileUtils.copyFile((File)cn1Properties, (File)new File(dummyProject, cn1Properties.getName()));
            }
            catch (IOException ex) {
                this.getLog().warn((CharSequence)("Failed to copy " + cn1Properties + " into dummy project"), (Throwable)ex);
            }
        }
        java.createArg().setFile(dummyProject);
        java.createArg().setValue("force");
        java.executeJava();
    }

    protected void copyKotlinIncrementalCompileOutputToOutputDir() {
        if ("true".equals(this.project.getProperties().getProperty("kotlin.compiler.incremental"))) {
            File kotlinIncrementalOutputDir = new File(this.project.getBuild().getDirectory() + File.separator + "kotlin-ic" + File.separator + "compile" + File.separator + "classes");
            File outputDir = new File(this.project.getBuild().getOutputDirectory());
            if (kotlinIncrementalOutputDir.exists()) {
                Copy copy = (Copy)this.antProject.createTask("copy");
                copy.setTodir(outputDir);
                FileSet files = new FileSet();
                files.setProject(this.antProject);
                files.setDir(kotlinIncrementalOutputDir);
                files.setIncludes("**");
                copy.addFileset(files);
                copy.setOverwrite(true);
                copy.execute();
            }
        }
    }

    protected static final boolean is64Bit() {
        String model = System.getProperty("sun.arch.data.model", System.getProperty("com.ibm.vm.bitmode"));
        if (model != null) {
            return "64".equals(model);
        }
        return "x86-64".equals(ARCH) || "ia64".equals(ARCH) || "ppc64".equals(ARCH) || "ppc64le".equals(ARCH) || "sparcv9".equals(ARCH) || "mips64".equals(ARCH) || "mips64el".equals(ARCH) || "amd64".equals(ARCH) || "aarch64".equals(ARCH);
    }

    protected String getCefPlatform() {
        if (isMac) {
            return "mac";
        }
        if (isWindows) {
            return is64Bit ? "win64" : "win32";
        }
        if (isUnix && is64Bit && "amd64".equals(ARCH)) {
            return "linux64";
        }
        return null;
    }

    protected File getCefDir() {
        String path = System.getProperty("cef.dir", null);
        if (path == null || path.isEmpty()) {
            return null;
        }
        return new File(path);
    }

    protected boolean isCefSetup() {
        File cefDir = this.getCefDir();
        if (cefDir == null) {
            return false;
        }
        return cefDir.exists();
    }

    private void fixCefPermissions(File cefDir) {
        this.getLog().debug((CharSequence)("Checking permissions on " + cefDir + " and fixing if necessary"));
        HashSet<String> patterns = new HashSet<String>();
        patterns.add("*.dylib");
        patterns.add("*.so");
        patterns.add("jcef_helper");
        patterns.add("*.framework");
        patterns.add("jcef Helper*");
        patterns.add("Chromium Embedded Framework");
        this.setExecutableRecursive(cefDir, patterns);
        if ("linux64".equals(this.getCefPlatform())) {
            this.getLog().debug((CharSequence)"On linux platform.  Checking if we need to workaround issue with libjawt.so");
            File dest = new File(this.getCefDir(), PathUtil.path("lib", "linux64", "libjawt.so"));
            File javaHome = new File(System.getProperty("java.home"));
            File src = new File(javaHome, PathUtil.path("lib", "amd64", "libjawt.so"));
            if (!src.exists()) {
                src = new File(javaHome, PathUtil.path("lib", "libjawt.so"));
            }
            if (!dest.exists()) {
                this.getLog().debug((CharSequence)("libjawt.so fix has not been applied yet as " + dest + " does not exist"));
                if (src.exists()) {
                    this.getLog().debug((CharSequence)("We can attempt to apply libjawt.so fix since " + src + " was found"));
                } else {
                    this.getLog().debug((CharSequence)("Cannot attempt to apply libjawt.so fix since " + src + " does not exist"));
                }
            }
            if (!dest.exists() && src.exists()) {
                try {
                    this.getLog().info((CharSequence)("Copying " + src + " to " + dest + " to workaround issue with UnsatisfiedLinkError in CEF related to libjawt.so not being found in LD_LIBRARY_PATH"));
                    FileUtils.copyFile((File)src, (File)dest);
                }
                catch (Exception ex) {
                    this.getLog().warn((CharSequence)("Failed to copy libjawt.so into CEF lib directory.  There may be problems using the BrowserComponent and media.  If you experience problems try copying the file " + src + " into " + dest), (Throwable)ex);
                }
            }
        }
    }

    private boolean match(File file, Collection<String> patterns) {
        for (String pattern : patterns) {
            PathMatcher matcher;
            if (!(pattern.contains("*") ? (matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern)).matches(file.toPath().getFileName()) : pattern.equals(file.getName()))) continue;
            return true;
        }
        return false;
    }

    private void setExecutableRecursive(File root, Collection<String> patterns) {
        if (this.match(root, patterns) && root.exists()) {
            root.setExecutable(true, false);
        }
        if (root.isDirectory()) {
            for (File child : root.listFiles()) {
                this.setExecutableRecursive(child, patterns);
            }
        }
    }

    protected void setupCef() {
        File chromiumEmbeddedFramework;
        if (this.isCefSetup()) {
            this.fixCefPermissions(this.getCefDir());
            return;
        }
        String platform = this.getCefPlatform();
        if (platform == null) {
            this.getLog().warn((CharSequence)"CEF not supported on this platform.  Not adding dependency");
            return;
        }
        File cefZip = this.getJar(GROUP_ID, "codenameone-cef", platform);
        if (cefZip == null || !cefZip.exists()) {
            this.getLog().warn((CharSequence)"codenameone-cef not found in dependencies.  Not adding CEF dependency");
            return;
        }
        File extractedDir = new File(cefZip.getParentFile(), cefZip.getName() + "-extracted");
        boolean missingSymlinks = false;
        if (isMac && !Files.isSymbolicLink((chromiumEmbeddedFramework = new File(extractedDir, "cef/macos64/Chromium Embedded Framework.framework/Chromium Embedded Framework")).toPath())) {
            missingSymlinks = true;
        }
        if (!extractedDir.exists() || extractedDir.lastModified() < cefZip.lastModified() || missingSymlinks) {
            if (isMac) {
                if (extractedDir.exists()) {
                    AbstractCN1Mojo.delTree(extractedDir);
                }
                extractedDir.mkdirs();
                this.getLog().info((CharSequence)"Expanding CEF");
                ExecTask unzip = (ExecTask)this.antProject.createTask("exec");
                unzip.setExecutable("unzip");
                unzip.createArg().setFile(cefZip);
                unzip.createArg().setValue("-d");
                unzip.createArg().setFile(extractedDir);
                unzip.execute();
            } else {
                if (extractedDir.exists()) {
                    AbstractCN1Mojo.delTree(extractedDir);
                }
                this.getLog().info((CharSequence)"Expanding CEF");
                Expand expand = (Expand)this.antProject.createTask("unzip");
                expand.setDest(extractedDir);
                expand.setSrc(cefZip);
                expand.execute();
            }
        }
        if (new File(extractedDir, "cef").exists()) {
            extractedDir = new File(extractedDir, "cef");
        }
        this.project.getProperties().setProperty("cef.dir", extractedDir.getAbsolutePath());
        System.setProperty("cef.dir", extractedDir.getAbsolutePath());
        this.fixCefPermissions(extractedDir);
    }

    protected File getDesignerJar() throws MojoExecutionException {
        Artifact artifact = this.getArtifact(GROUP_ID, "codenameone-designer", "jar-with-dependencies");
        if (artifact == null) {
            throw new MojoExecutionException("Could not find designer jar");
        }
        File file = this.findArtifactFile(artifact);
        if (file == null) {
            throw new MojoExecutionException("Could not find designer jar");
        }
        File extracted = new File(file.getParentFile(), file.getName() + "-extracted");
        File designerJar = new File(extracted, "designer_1.jar");
        if (!designerJar.exists() || designerJar.lastModified() < file.lastModified()) {
            Expand expand = (Expand)this.antProject.createTask("unzip");
            expand.setSrc(file);
            expand.setDest(extracted);
            expand.execute();
        }
        if (!designerJar.exists()) {
            throw new MojoExecutionException("Failed to extract designer_1.jar from artifact " + artifact);
        }
        return designerJar;
    }

    protected boolean isCN1ProjectDir() {
        if (this.getCN1ProjectDir() == null) {
            this.getLog().debug((CharSequence)"Skipping guibuilder because this is not a CN1 project");
            return false;
        }
        try {
            if (!this.getCN1ProjectDir().getCanonicalFile().equals(this.project.getBasedir().getCanonicalFile())) {
                this.getLog().debug((CharSequence)"Skipping guibuilder because this is not a CN1 project");
                return false;
            }
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"Failed to get canonical paths for project dir", (Throwable)ex);
            return false;
        }
        return true;
    }
}

