/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.ant.AntExecutor;
import com.codename1.ant.SortedProperties;
import com.codename1.builders.AndroidGradleBuilder;
import com.codename1.builders.BuildException;
import com.codename1.builders.BuildRequest;
import com.codename1.builders.IPhoneBuilder;
import com.codename1.maven.AbstractCN1Mojo;
import com.codename1.maven.PathUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.PatternFileSelector;
import org.apache.commons.vfs2.VFS;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(phase=LifecyclePhase.PACKAGE)
public class CN1BuildMojo
extends AbstractCN1Mojo {
    public static final String BUILD_TARGET_XCODE_PROJECT = "ios-source";
    public static final String BUILD_TARGET_ANDROID_PROJECT = "android-source";
    private String serverMustProvideKotlinVersion;
    @Parameter(property="codename1.platform", required=true)
    private String platform;
    @Parameter(property="codename1.buildTarget", required=true, defaultValue="${codename1.defaultBuildTarget}")
    private String buildTarget;
    @Parameter(property="automated", defaultValue="false")
    private boolean automated;
    @Parameter(property="open", defaultValue="true")
    private boolean open;
    private String cn1MavenPluginVersion = "";
    private String cn1MavenVersion = "";
    private static String[] BUNDLE_ARTIFACT_SCOPES = new String[]{"compile"};
    private static String[] BUNDLE_ARTIFACT_ID_BLACKLIST = new String[]{"codenameone-core", "java-runtime"};

    @Override
    protected void executeImpl() throws MojoExecutionException, MojoFailureException {
        if ("none".equalsIgnoreCase(this.buildTarget)) {
            this.getLog().info((CharSequence)"BuildTarget is None.  Skipping cn1build goal");
            return;
        }
        this.cn1MavenPluginVersion = this.project.getProperties().getProperty("cn1.plugin.version", "");
        this.cn1MavenVersion = this.project.getProperties().getProperty("cn1.version", "");
        File retrolambdaJar = this.getJar("net.orfjackal.retrolambda", "retrolambda");
        if (retrolambdaJar != null && retrolambdaJar.exists()) {
            System.setProperty("retrolambdaJarPath", retrolambdaJar.getAbsolutePath());
        } else {
            this.getLog().warn((CharSequence)"Could not find retrolambda Jar from dependencies.  Falling back to default version 2.5.1 that may have issues building Android.");
        }
        String projectPlatform = this.project.getProperties().getProperty("codename1.projectPlatform");
        if (projectPlatform == null) {
            this.getLog().debug((CharSequence)"Skipping build because codename1.projectPlatform property is not defined");
            return;
        }
        if (!projectPlatform.equals(this.platform)) {
            this.getLog().debug((CharSequence)"Skipping build because codename1.projectPlatform doesn't match the given platform");
            return;
        }
        if (this.platform.contains("android") && !BUILD_TARGET_ANDROID_PROJECT.equals(this.buildTarget)) {
            String apkName = this.project.getBuild().getFinalName() + ".apk";
            File apkFile = new File(this.project.getBuild().getDirectory() + File.separator + apkName);
            try {
                if (apkFile.exists() && apkFile.lastModified() >= this.getSourcesModificationTime()) {
                    this.getLog().info((CharSequence)("Sources have not been modified since APK at " + apkFile + " was created.  Skipping Android build"));
                    return;
                }
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to check sources modification time", (Exception)ex);
            }
        }
        try {
            this.createAntProject();
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"Failed to create and build ANT project", (Throwable)ex);
            throw new MojoFailureException("Failed to create and build ANT project", (Throwable)ex);
        }
        catch (LibraryPropertiesException ex) {
            this.getLog().error((CharSequence)("Failed to merge properties from library " + ex.libName + ".  " + ex.getMessage()));
            throw new MojoExecutionException("Failed to merge properties from library " + ex.libName + ".  " + ex.getMessage(), (Exception)ex);
        }
    }

    private void mergeJars(File dest, File ... src) {
        Zip task = (Zip)this.antProject.createTask("zip");
        task.setDestFile(dest);
        task.setUpdate(true);
        for (File srcFile : src) {
            if (srcFile.isDirectory()) {
                FileSet fs = new FileSet();
                fs.setExcludes("**/META-INF/versions/**");
                fs.setProject(this.antProject);
                fs.setDir(srcFile);
                task.addFileset(fs);
                continue;
            }
            ZipFileSet fileset = new ZipFileSet();
            fileset.setExcludes("**/META-INF/versions/**");
            fileset.setProject(this.antProject);
            fileset.setSrc(srcFile);
            task.addZipfileset(fileset);
        }
        task.execute();
    }

    private File getAppExtensionsJar() throws IOException {
        if (!this.project.getProperties().getProperty("codename1.platform", "").equalsIgnoreCase("ios")) {
            return null;
        }
        if (!this.project.getBasedir().getName().equalsIgnoreCase("ios")) {
            return null;
        }
        File appExtensionsDir = new File(this.project.getBasedir(), "app_extensions");
        if (!appExtensionsDir.isDirectory()) {
            return null;
        }
        File appExtensionsJar = new File(this.project.getBuild().getDirectory() + File.separator + "codenameone" + File.separator + "app_extensions.jar");
        if (appExtensionsJar.exists() && appExtensionsJar.lastModified() < CN1BuildMojo.lastModifiedRecursive(appExtensionsDir)) {
            appExtensionsJar.delete();
        }
        if (!appExtensionsJar.exists()) {
            File tmpDir = new File(appExtensionsJar.getParentFile(), "app_extensions");
            if (tmpDir.exists()) {
                FileUtils.deleteDirectory((File)tmpDir);
            }
            tmpDir.mkdirs();
            for (File appExtension : appExtensionsDir.listFiles()) {
                Zip task = (Zip)this.antProject.createTask("zip");
                File dest = new File(tmpDir, appExtension.getName() + ".ios.appext");
                task.setDestFile(dest);
                task.setUpdate(false);
                if (appExtension.isDirectory()) {
                    FileSet fs = new FileSet();
                    fs.setProject(this.antProject);
                    fs.setDir(appExtension);
                    task.addFileset(fs);
                    task.execute();
                    continue;
                }
                if (!appExtension.getName().endsWith(".zip")) continue;
                ZipFileSet fileset = new ZipFileSet();
                fileset.setProject(this.antProject);
                fileset.setSrc(appExtension);
                task.addZipfileset(fileset);
                task.execute();
            }
            Zip task = (Zip)this.antProject.createTask("zip");
            task.setDestFile(appExtensionsJar);
            task.setUpdate(false);
            FileSet fs = new FileSet();
            fs.setProject(this.antProject);
            fs.setDir(tmpDir);
            task.addFileset(fs);
            task.execute();
        }
        if (appExtensionsJar.exists()) {
            return appExtensionsJar;
        }
        return null;
    }

    private File getStringsJar() throws IOException {
        if (!this.project.getProperties().getProperty("codename1.platform", "").equalsIgnoreCase("ios")) {
            return null;
        }
        if (!this.project.getBasedir().getName().equalsIgnoreCase("ios")) {
            return null;
        }
        File stringsDir = new File(this.project.getBasedir(), PathUtil.path("src", "main", "strings"));
        if (!stringsDir.isDirectory()) {
            return null;
        }
        File stringsJar = new File(this.project.getBuild().getDirectory() + File.separator + "codenameone" + File.separator + "strings.jar");
        if (stringsJar.exists() && stringsJar.lastModified() < CN1BuildMojo.lastModifiedRecursive(stringsDir)) {
            stringsJar.delete();
        }
        if (!stringsJar.exists()) {
            File tmpDir = new File(stringsJar.getParentFile(), "strings");
            if (tmpDir.exists()) {
                FileUtils.deleteDirectory((File)tmpDir);
            }
            tmpDir.mkdirs();
            for (File lproj : stringsDir.listFiles()) {
                Zip task = (Zip)this.antProject.createTask("zip");
                File dest = new File(tmpDir, lproj.getName() + ".zip");
                task.setDestFile(dest);
                task.setUpdate(false);
                if (lproj.isDirectory()) {
                    FileSet fs = new FileSet();
                    fs.setProject(this.antProject);
                    fs.setDir(lproj);
                    task.addFileset(fs);
                    task.execute();
                    continue;
                }
                if (!lproj.getName().endsWith(".zip")) continue;
                ZipFileSet fileset = new ZipFileSet();
                fileset.setProject(this.antProject);
                fileset.setSrc(lproj);
                task.addZipfileset(fileset);
                task.execute();
            }
            Zip task = (Zip)this.antProject.createTask("zip");
            task.setDestFile(stringsJar);
            task.setUpdate(false);
            FileSet fs = new FileSet();
            fs.setProject(this.antProject);
            fs.setDir(tmpDir);
            task.addFileset(fs);
            task.execute();
        }
        if (stringsJar.exists()) {
            return stringsJar;
        }
        return null;
    }

    private boolean isLocalBuildTarget(String buildTarget) {
        return buildTarget.startsWith("local-") || BUILD_TARGET_XCODE_PROJECT.equals(buildTarget) || BUILD_TARGET_ANDROID_PROJECT.equals(buildTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createAntProject() throws IOException, LibraryPropertiesException, MojoExecutionException {
        Object requiredPropsFiles;
        FileSystemManager fsManager;
        FileObject jarFile;
        File stringsJar;
        List cpElements;
        File cn1dir = new File(this.project.getBuild().getDirectory() + File.separator + "codenameone");
        File antProject = new File(cn1dir, "antProject");
        antProject.mkdirs();
        File codenameOneSettings = new File(this.getCN1ProjectDir(), "codenameone_settings.properties");
        File icon = new File(this.getCN1ProjectDir(), "icon.png");
        if (icon.exists()) {
            FileUtils.copyFile((File)icon, (File)new File(antProject, "icon.png"));
        } else {
            FileUtils.copyInputStreamToFile((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("codenameone-icon.png"), (File)new File(antProject, "icon.png"));
        }
        File codenameOneSettingsCopy = new File(antProject, codenameOneSettings.getName());
        FileUtils.copyFile((File)codenameOneSettings, (File)codenameOneSettingsCopy);
        FileUtils.copyInputStreamToFile((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("buildxml-template.xml"), (File)new File(antProject, "build.xml"));
        File distDir = new File(antProject, "dist");
        distDir.mkdirs();
        File jarWithDependencies = new File(PathUtil.path(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "-" + this.buildTarget + "-jar-with-dependencies.jar"));
        try {
            cpElements = this.project.getCompileClasspathElements();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Failed to get classpath elements", ex);
        }
        File appExtensionsJar = this.getAppExtensionsJar();
        if (appExtensionsJar != null) {
            cpElements.add(appExtensionsJar.getAbsolutePath());
        }
        if ((stringsJar = this.getStringsJar()) != null) {
            cpElements.add(stringsJar.getAbsolutePath());
        }
        this.getLog().debug((CharSequence)("Classpath Elements: " + cpElements));
        if (jarWithDependencies.exists()) {
            this.getLog().debug((CharSequence)("Found jar file with dependencies at " + jarWithDependencies + ". Will use that one unless it is out of date."));
            for (Object artifact : cpElements) {
                File jar = new File((String)artifact);
                if (jar.isDirectory()) {
                    if (jarWithDependencies.lastModified() >= CN1BuildMojo.lastModifiedRecursive(jar)) continue;
                    this.getLog().debug((CharSequence)("Jar file out of date.  Dependencies have changed. " + jarWithDependencies + ". Deleting"));
                    jarWithDependencies.delete();
                    break;
                }
                if (!jar.exists() || jar.lastModified() <= jarWithDependencies.lastModified()) continue;
                this.getLog().debug((CharSequence)("Jar file out of date.  Dependencies have changed. " + jarWithDependencies + ". Deleting"));
                jarWithDependencies.delete();
                break;
            }
        }
        if (!jarWithDependencies.exists()) {
            Object artifact2;
            this.getLog().info((CharSequence)(jarWithDependencies + " not found.  Generating jar with dependencies now"));
            ArrayList<String> blackListJars = new ArrayList<String>();
            this.getLog().info((CharSequence)("Project artifacts: " + this.project.getArtifacts()));
            for (Object artifact2 : this.project.getArtifacts()) {
                File jar;
                boolean addToBlacklist = false;
                if (artifact2.getGroupId().equals("com.codenameone") && CN1BuildMojo.contains(artifact2.getArtifactId(), BUNDLE_ARTIFACT_ID_BLACKLIST)) {
                    addToBlacklist = true;
                }
                if (!addToBlacklist && !this.isLocalBuildTarget(this.buildTarget) && artifact2.getGroupId().equals("org.jetbrains.kotlin") && artifact2.getArtifactId().equals("kotlin-stdlib")) {
                    addToBlacklist = true;
                    this.serverMustProvideKotlinVersion = artifact2.getVersion();
                    this.getLog().debug((CharSequence)("Adding kotlin-stdlib to blacklist.  Server will provide this:" + artifact2));
                }
                if (!addToBlacklist && !"compile".equals(artifact2.getScope())) {
                    addToBlacklist = true;
                }
                if (!addToBlacklist || (jar = this.getJar((Artifact)artifact2)) == null) continue;
                blackListJars.add(jar.getAbsolutePath());
                blackListJars.add(jar.getPath());
                try {
                    blackListJars.add(jar.getCanonicalPath());
                    this.getLog().debug((CharSequence)("Added " + jar + " to blacklist"));
                }
                catch (Exception exception) {}
            }
            this.getLog().debug((CharSequence)("Merging compile classpath elements into jar with dependencies: " + cpElements));
            ArrayList<File> jarsToMerge = new ArrayList<File>();
            artifact2 = cpElements.iterator();
            while (artifact2.hasNext()) {
                String element;
                String canonicalEl = element = (String)artifact2.next();
                try {
                    canonicalEl = new File(canonicalEl).getCanonicalPath();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (blackListJars.contains(element) || blackListJars.contains(canonicalEl)) {
                    this.getLog().debug((CharSequence)("NOT adding jar " + element + " because it is on the blacklist"));
                    continue;
                }
                if (!new File(element).exists()) continue;
                this.getLog().debug((CharSequence)("Adding jar " + element + " to " + jarWithDependencies + " Jar file=" + element));
                jarsToMerge.add(new File(element));
            }
            this.mergeJars(jarWithDependencies, jarsToMerge.toArray(new File[jarsToMerge.size()]));
        }
        try {
            this.updateCodenameOne(false, new File[0]);
        }
        catch (MojoExecutionException ex) {
            this.getLog().error((CharSequence)"Failed to update Codename One");
            throw new IOException("Failed to update Codename One", ex);
        }
        File antDistDir = new File(antProject, "dist");
        File antDistJar = new File(antDistDir, this.project.getBuild().getFinalName() + "-" + this.buildTarget + "-jar-with-dependencies.jar");
        antDistDir.mkdirs();
        FileUtils.copyFile((File)jarWithDependencies, (File)antDistJar);
        Properties p = new Properties();
        p.setProperty("codenameone_settings.properties", codenameOneSettingsCopy.getAbsolutePath());
        p.setProperty("CodeNameOneBuildClient.jar", PathUtil.path(System.getProperty("user.home"), ".codenameone", "CodeNameOneBuildClient.jar"));
        p.setProperty("dist.jar", antDistJar.getAbsolutePath());
        if (this.automated) {
            p.setProperty("automated", "true");
        }
        this.getLog().info((CharSequence)("Running ANT build target " + this.buildTarget));
        String logPasskey = UUID.randomUUID().toString();
        Properties cn1SettingsProps = new Properties();
        try (FileInputStream fis = new FileInputStream(codenameOneSettingsCopy);){
            cn1SettingsProps.load(fis);
        }
        if (this.serverMustProvideKotlinVersion != null) {
            cn1SettingsProps.setProperty("codename1.arg.requireKotlinStdlib", this.serverMustProvideKotlinVersion);
        }
        if ((jarFile = (fsManager = VFS.getManager()).resolveFile("jar:" + jarWithDependencies.getAbsolutePath() + "!/META-INF/codenameone")) != null) {
            Object propVal;
            FileObject[] appendedPropsFiles = jarFile.findFiles((FileSelector)new PatternFileSelector(".*\\/codenameone_library_appended.properties"));
            if (appendedPropsFiles != null) {
                for (FileObject appendedPropsFile : appendedPropsFiles) {
                    SortedProperties appendedProps = new SortedProperties();
                    try (InputStream appendedPropsIn = appendedPropsFile.getContent().getInputStream();){
                        appendedProps.load(appendedPropsIn);
                    }
                    for (String propName : appendedProps.stringPropertyNames()) {
                        propVal = appendedProps.getProperty(propName);
                        if (!cn1SettingsProps.containsKey(propName)) {
                            cn1SettingsProps.put(propName, propVal);
                            continue;
                        }
                        String existing = cn1SettingsProps.getProperty(propName);
                        if (existing.contains((CharSequence)propVal)) continue;
                        cn1SettingsProps.setProperty(propName, existing + (String)propVal);
                    }
                }
            }
            if ((requiredPropsFiles = jarFile.findFiles((FileSelector)new PatternFileSelector(".*\\/codenameone_library_required.properties"))) != null) {
                for (FileObject requiredPropsFile : requiredPropsFiles) {
                    SortedProperties requiredProps = new SortedProperties();
                    InputStream appendedPropsIn = requiredPropsFile.getContent().getInputStream();
                    propVal = null;
                    try {
                        requiredProps.load(appendedPropsIn);
                    }
                    catch (Throwable existing) {
                        propVal = existing;
                        throw existing;
                    }
                    finally {
                        if (appendedPropsIn != null) {
                            if (propVal != null) {
                                try {
                                    appendedPropsIn.close();
                                }
                                catch (Throwable existing) {
                                    ((Throwable)propVal).addSuppressed(existing);
                                }
                            } else {
                                appendedPropsIn.close();
                            }
                        }
                    }
                    String artifactId = requiredPropsFile.getParent().getName().getBaseName();
                    String groupId = requiredPropsFile.getParent().getParent().getName().getBaseName();
                    String libraryName = groupId + ":" + artifactId;
                    cn1SettingsProps = this.mergeRequiredProperties(libraryName, requiredProps, cn1SettingsProps);
                }
            }
        }
        cn1SettingsProps.setProperty("codename1.arg.hyp.beamId", logPasskey);
        cn1SettingsProps.setProperty("codename1.arg.maven.codenameone-core.version", this.cn1MavenVersion);
        cn1SettingsProps.setProperty("codename1.arg.maven.codenameone-maven-plugin", this.cn1MavenPluginVersion);
        FileOutputStream fos = new FileOutputStream(codenameOneSettingsCopy);
        requiredPropsFiles = null;
        try {
            cn1SettingsProps.store(fos, "");
        }
        catch (Throwable throwable) {
            requiredPropsFiles = throwable;
            throw throwable;
        }
        finally {
            if (fos != null) {
                if (requiredPropsFiles != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)requiredPropsFiles).addSuppressed(throwable);
                    }
                } else {
                    fos.close();
                }
            }
        }
        Process[] proc = new Process[1];
        boolean[] closingHypLog = new boolean[1];
        Thread hyperBeamThread = new Thread(() -> {
            block6: {
                ProcessBuilder pb = new ProcessBuilder("hyp", "beam", logPasskey);
                pb.redirectErrorStream(true);
                try {
                    proc[0] = pb.start();
                    InputStream out = proc[0].getInputStream();
                    byte[] buffer = new byte[4000];
                    while (CN1BuildMojo.isAlive(proc[0])) {
                        int no = out.available();
                        if (no > 0) {
                            int n = out.read(buffer, 0, Math.min(no, buffer.length));
                            this.getLog().info((CharSequence)new String(buffer, 0, n));
                        }
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                catch (Exception ex) {
                    if (closingHypLog[0]) break block6;
                    this.getLog().warn((CharSequence)"Failed to start hyperlog.  The build log will not stream to your console.  If the build fails, you can download the error log at https://cloud.codenameone.com/secure/index.html");
                    this.getLog().debug((Throwable)ex);
                }
            }
        });
        try {
            if (this.isLocalBuildTarget(this.buildTarget)) {
                this.automated = false;
                if (this.buildTarget.contains("android") || BUILD_TARGET_ANDROID_PROJECT.equals(this.buildTarget)) {
                    this.doAndroidLocalBuild(antProject, cn1SettingsProps, antDistJar);
                } else {
                    if (!this.buildTarget.contains("ios") && !BUILD_TARGET_XCODE_PROJECT.equals(this.buildTarget)) throw new MojoExecutionException("Build target not supported " + this.buildTarget);
                    this.doIOSLocalBuild(antProject, cn1SettingsProps, antDistJar);
                }
            } else {
                if (this.automated) {
                    this.getLog().debug((CharSequence)"Attempting to start hyper beam stream the build log to the console");
                    hyperBeamThread.start();
                }
                AntExecutor.executeAntTask(new File(antProject, "build.xml").getAbsolutePath(), this.buildTarget, p);
            }
        }
        finally {
            if (this.automated) {
                try {
                    closingHypLog[0] = true;
                    proc[0].destroyForcibly();
                }
                catch (Exception exception) {}
            }
        }
        if (!this.automated) return;
        this.getLog().info((CharSequence)"Extracting server result");
        File result = new File(antDistDir, "result.zip");
        if (!result.exists()) {
            throw new IOException("Failed to find result.zip after automated build");
        }
        Expand unzip = (Expand)this.antProject.createTask("unzip");
        unzip.setSrc(result);
        File resultDir = new File(antDistDir, "result");
        resultDir.mkdir();
        unzip.setDest(resultDir);
        unzip.execute();
        for (File child : resultDir.listFiles()) {
            String name = child.getName();
            int dotpos = name.lastIndexOf(".");
            if (dotpos < 0) continue;
            String extension = name.substring(dotpos);
            String base = name.substring(0, dotpos);
            File copyTo = new File(this.project.getBuild().getDirectory() + File.separator + this.project.getBuild().getFinalName() + extension);
            FileUtils.copyFile((File)child, (File)copyTo);
            if (".war".equals(extension)) {
                this.projectHelper.attachArtifact(this.project, "war", copyTo);
                continue;
            }
            if (".zip".equals(extension) && "javascript".equals(this.buildTarget)) {
                this.projectHelper.attachArtifact(this.project, "zip", "webapp", copyTo);
                continue;
            }
            if (".dmg".equals(extension) && "mac-os-x-desktop".equals(this.buildTarget)) {
                this.projectHelper.attachArtifact(this.project, "dmg", "mac-app", copyTo);
                continue;
            }
            if (!".pkg".equals(extension) || !"mac-os-x-desktop".equals(this.buildTarget)) continue;
            this.projectHelper.attachArtifact(this.project, "pkg", "mac-app-installer", copyTo);
        }
        FileUtils.deleteDirectory((File)resultDir);
        result.delete();
        this.afterBuild();
    }

    private static boolean isAlive(Process proc) {
        try {
            proc.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    private String generateCertificate(String password, String alias, String fullName, String orgName, String company, String city, String state, String twoLetterCountryCode, boolean sha512) throws Exception {
        Process p;
        int res;
        File keyTool = new File(System.getProperty("java.home") + File.separator + "bin" + File.separator + "keytool");
        if (!keyTool.exists()) {
            keyTool = new File(System.getProperty("java.home") + File.separator + "bin" + File.separator + "keytool.exe");
        }
        File keyfileLocation = new File(System.getProperty("user.home") + File.separator + "Keychain.ks");
        int counter = 1;
        while (keyfileLocation.exists()) {
            keyfileLocation = new File(System.getProperty("user.home") + File.separator + "Keychain_" + counter + ".ks");
            ++counter;
        }
        ProcessBuilder pb = new ProcessBuilder(keyTool.getAbsolutePath(), "-genkey", "-keystore", keyfileLocation.getAbsolutePath(), "-storetype", "jks", "-alias", alias, "-keyalg", "RSA", "-keysize", "2048", "-validity", "15000", "-dname", "CN=" + fullName.replace(",", "\\,") + ", OU=" + orgName.replace(",", "\\,") + ", O=" + company.replace(",", "\\,") + ", L=" + city.replace(",", "\\,") + ", S=" + state.replace(",", "\\,") + ", C=" + twoLetterCountryCode, "-storepass", password, "-keypass", password, "-v");
        if (sha512) {
            pb.command().add("-sigalg");
            pb.command().add("SHA512withRSA");
        }
        if ((res = (p = pb.start()).waitFor()) > 0) {
            String str;
            StringBuilder msg = new StringBuilder();
            InputStream input = p.getInputStream();
            InputStream stream = p.getErrorStream();
            byte[] buffer = new byte[8192];
            int i = input.read(buffer);
            while (i > -1) {
                str = new String(buffer, 0, i);
                System.out.print(str);
                msg.append(str);
                i = stream.read(buffer);
            }
            i = stream.read(buffer);
            while (i > -1) {
                str = new String(buffer, 0, i);
                System.out.print(str);
                msg.append(str);
                i = stream.read(buffer);
            }
            return null;
        }
        return keyfileLocation.getAbsolutePath();
    }

    private File getGeneratedAndroidProjectSourceDirectory() {
        return new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "-android-source");
    }

    private File getGeneratedIOSProjectSourceDirectory() {
        return new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "-ios-source");
    }

    private void doAndroidLocalBuild(File tmpProjectDir, Properties props, File distJar) throws MojoExecutionException {
        if (BUILD_TARGET_ANDROID_PROJECT.equals(this.buildTarget)) {
            File generatedProject = this.getGeneratedAndroidProjectSourceDirectory();
            this.getLog().info((CharSequence)("Generating android gradle Project to " + generatedProject + "..."));
            try {
                if (generatedProject.exists()) {
                    this.getLog().info((CharSequence)"Android gradle project already exists.  Checking to see if it needs updating...");
                    if (this.getSourcesModificationTime() <= CN1BuildMojo.lastModifiedRecursive(generatedProject)) {
                        this.getLog().info((CharSequence)"Sources have not changed.  Skipping android gradle project generation");
                        if (this.open) {
                            this.openAndroidStudioProject(generatedProject);
                        }
                        return;
                    }
                }
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to find last modification time of " + generatedProject);
            }
        }
        File codenameOneJar = this.getJar("com.codenameone", "codenameone-core");
        AndroidGradleBuilder e = new AndroidGradleBuilder();
        e.setBuildTarget(this.buildTarget);
        e.setLogger(this.getLog());
        File buildDirectory = new File(tmpProjectDir, "dist" + File.separator + "android-build");
        e.setBuildDirectory(buildDirectory);
        e.setCodenameOneJar(codenameOneJar);
        e.setPlatform("android");
        BuildRequest r = new BuildRequest();
        r.setDisplayName(props.getProperty("codename1.displayName"));
        r.setPackageName(props.getProperty("codename1.packageName"));
        r.setMainClass(props.getProperty("codename1.mainName"));
        r.setVersion(props.getProperty("codename1.version"));
        String iconPath = props.getProperty("codename1.icon");
        File iconFile = new File(iconPath);
        if (!iconFile.isAbsolute()) {
            iconFile = new File(this.getCN1ProjectDir(), iconPath);
        }
        try {
            BufferedImage bi = ImageIO.read(iconFile);
            if (bi.getWidth() != 512 || bi.getHeight() != 512) {
                throw new MojoExecutionException("The icon must be a 512x512 pixel PNG image. It will be scaled to the proper sizes for devices");
            }
            r.setIcon(iconFile.getAbsolutePath());
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error reading the icon: the icon must be a 512x512 pixel PNG image. It will be scaled to the proper sizes for devices");
        }
        r.setVendor(props.getProperty("codename1.vendor"));
        r.setSubTitle(props.getProperty("codename1.secondaryTitle"));
        r.setType("android");
        r.setKeystoreAlias(props.getProperty("codename1.android.keystoreAlias"));
        String keystorePath = props.getProperty("codename1.android.keystore");
        if (keystorePath != null) {
            Object keystoreFile = new File(keystorePath);
            if (!((File)keystoreFile).isAbsolute()) {
                keystoreFile = new File(this.getCN1ProjectDir(), keystorePath);
            }
            if (((File)keystoreFile).exists() && ((File)keystoreFile).isFile()) {
                try {
                    r.setCertificate(((File)keystoreFile).getAbsolutePath());
                }
                catch (IOException iOException) {
                    throw new MojoExecutionException("Failed to load keystore file. ", (Exception)iOException);
                }
            }
            File file = new File(this.getCN1ProjectDir(), "androidCerts");
            file.mkdirs();
            keystoreFile = new File(file, "KeyChain.ks");
            if (!((File)keystoreFile).exists()) {
                try {
                    String password;
                    String alias = r.getKeystoreAlias();
                    if (alias == null || alias.isEmpty()) {
                        alias = "androidKey";
                        r.setKeystoreAlias(alias);
                        props.setProperty("codename1.android.keystoreAlias", alias);
                    }
                    if ((password = props.getProperty("codename1.android.keystorePassword")) == null || password.isEmpty()) {
                        password = "password";
                        props.setProperty("codename1.android.keystorePassword", password);
                    }
                    this.getLog().info((CharSequence)"No Keystore found.  Generating one now");
                    String keyPath = this.generateCertificate(password, alias, r.getVendor(), "", r.getVendor(), "Vancouver", "BC", "CA", false);
                    FileUtils.copyFile((File)new File(keyPath), (File)keystoreFile);
                    r.setCertificate(((File)keystoreFile).getAbsolutePath());
                    this.getLog().info((CharSequence)("Generated keystore with password 'password' at " + keystoreFile + ". alias=androidKey"));
                    new File(keyPath).delete();
                    SortedProperties sp = new SortedProperties();
                    try (FileInputStream fis = new FileInputStream(new File(this.getCN1ProjectDir(), "codenameone_settings.properties"));){
                        sp.load(fis);
                    }
                    sp.setProperty("codename1.android.keystore", ((File)keystoreFile).getAbsolutePath());
                    sp.setProperty("codename1.android.keystorePassword", password);
                    sp.setProperty("codename1.android.keystoreAlias", alias);
                    var18_28 = null;
                    try (FileOutputStream fos = new FileOutputStream(new File(this.getCN1ProjectDir(), "codenameone_settings.properties"));){
                        sp.store(fos, "Updated keystore");
                    }
                    catch (Throwable throwable) {
                        var18_28 = throwable;
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    this.getLog().error((CharSequence)"Failed to generate keystore", (Throwable)ex);
                    throw new MojoExecutionException("Failed to generate keystore", ex);
                }
            }
        }
        r.setCertificatePassword(props.getProperty("codename1.android.keystorePassword"));
        for (Object e2 : props.keySet()) {
            String key = (String)e2;
            if (!key.startsWith("codename1.arg.")) continue;
            String value = props.getProperty(key);
            String currentKey = key.substring(14);
            if (currentKey.indexOf(32) > -1) {
                throw new MojoExecutionException("The build argument contains a space in the key: '" + currentKey + "'");
            }
            r.putArgument(currentKey, value);
        }
        BuildRequest request = r;
        request.setIncludeSource(true);
        String string = request.getArg("build.unitTest", null);
        if (string != null && string.equals("1")) {
            e.setUnitTestMode(true);
        }
        try {
            this.getLog().info((CharSequence)"Starting android project builder...");
            boolean result = e.build(distJar, request);
            this.getLog().info((CharSequence)("Android project builder completed with result " + result));
            if (!result) {
                this.getLog().error((CharSequence)"Received false return value from build()");
                throw new MojoExecutionException("Android build failed.  Received false return value for build");
            }
            if (BUILD_TARGET_ANDROID_PROJECT.equals(this.buildTarget) && e.getGradleProjectDirectory() != null) {
                File gradleProject = e.getGradleProjectDirectory();
                File output = this.getGeneratedAndroidProjectSourceDirectory();
                output.getParentFile().mkdirs();
                try {
                    this.getLog().info((CharSequence)("Copying Gradle Project to " + output));
                    FileUtils.copyDirectory((File)gradleProject, (File)output);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Failed to copy gradle project at " + gradleProject + " to " + output, (Exception)ex);
                }
            }
            if (this.open) {
                this.openAndroidStudioProject(this.getGeneratedAndroidProjectSourceDirectory());
            }
        }
        catch (BuildException ex) {
            this.getLog().error((CharSequence)("Failed to build Android project with error: " + ex.getMessage()), (Throwable)ex);
            this.getLog().error((CharSequence)e.getErrorMessage());
            throw new MojoExecutionException("Failed to build android app", (Exception)ex);
        }
        finally {
            e.cleanup();
        }
    }

    private void openAndroidStudioProject(File generatedProject) {
        if (isMac) {
            this.getLog().info((CharSequence)"Trying to open project in Android studio");
            ProcessBuilder pb = new ProcessBuilder("open", "-a", "/Applications/Android Studio.app", generatedProject.getAbsolutePath());
            try {
                pb.start();
            }
            catch (Exception ex) {
                this.getLog().warn((CharSequence)"Failed to open project in Android studio", (Throwable)ex);
                this.getLog().warn((CharSequence)"Please open the project in Android studio manually.");
                this.getLog().warn((CharSequence)("The project is located at " + generatedProject.getAbsolutePath()));
            }
        } else if (isWindows) {
            this.getLog().info((CharSequence)"Trying to open project in Android studio");
            ProcessBuilder pb = new ProcessBuilder("C:\\Program Files\\Android\\Android Studio\\bin\\studio.bat", generatedProject.getAbsolutePath());
            try {
                pb.start();
            }
            catch (Exception ex) {
                this.getLog().warn((CharSequence)"Failed to open project in Android studio", (Throwable)ex);
                this.getLog().warn((CharSequence)"Please open the project in Android studio manually.");
                this.getLog().warn((CharSequence)("The project is located at " + generatedProject.getAbsolutePath()));
            }
        } else {
            this.getLog().warn((CharSequence)"Opening automatically in Android studio not supported on this platform.");
            this.getLog().warn((CharSequence)"Please open the project in Android studio manually.");
            this.getLog().warn((CharSequence)("The project is located at " + generatedProject.getAbsolutePath()));
        }
    }

    private File getWorkspace(Properties props, File xcprojectRoot) {
        return new File(xcprojectRoot, props.getProperty("codename1.mainName") + ".xcworkspace");
    }

    private void openWorkspace(File workspace) throws MojoExecutionException {
        try {
            ProcessBuilder pb = new ProcessBuilder("open", workspace.getAbsolutePath());
            Process p = pb.start();
            int result = p.waitFor();
            if (result != 0) {
                throw new MojoExecutionException("Failed to open project at " + workspace + ".  Result code: " + result);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Failed to open project at " + workspace, ex);
        }
    }

    private void doIOSLocalBuild(File tmpProjectDir, Properties props, File distJar) throws MojoExecutionException {
        block22: {
            if (BUILD_TARGET_XCODE_PROJECT.equals(this.buildTarget)) {
                File generatedProject = this.getGeneratedIOSProjectSourceDirectory();
                this.getLog().info((CharSequence)("Generating Xcode Project to " + generatedProject + "..."));
                try {
                    if (generatedProject.exists()) {
                        this.getLog().info((CharSequence)"Xcode project already exists.  Checking to see if it needs updating...");
                        if (this.getSourcesModificationTime() <= CN1BuildMojo.lastModifiedRecursive(generatedProject)) {
                            this.getLog().info((CharSequence)"Sources have not changed.  Skipping Xcode project generation");
                            if (this.open) {
                                this.getLog().info((CharSequence)("Opening workspace project " + this.getWorkspace(props, generatedProject)));
                                this.openWorkspace(this.getWorkspace(props, generatedProject));
                            }
                            return;
                        }
                    }
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Failed to find last modification time of " + generatedProject);
                }
            }
            File codenameOneJar = this.getJar("com.codenameone", "codenameone-core");
            IPhoneBuilder e = new IPhoneBuilder();
            e.setLogger(this.getLog());
            File buildDirectory = new File(tmpProjectDir, "dist" + File.separator + "ios-build");
            e.setBuildDirectory(buildDirectory);
            e.setCodenameOneJar(codenameOneJar);
            e.setPlatform("ios");
            BuildRequest r = new BuildRequest();
            r.setAppid(props.getProperty("codename1.ios.appid"));
            r.setDisplayName(props.getProperty("codename1.displayName"));
            r.setPackageName(props.getProperty("codename1.packageName"));
            r.setMainClass(props.getProperty("codename1.mainName"));
            r.setVersion(props.getProperty("codename1.version"));
            String iconPath = props.getProperty("codename1.icon");
            File iconFile = new File(iconPath);
            if (!iconFile.isAbsolute()) {
                iconFile = new File(this.getCN1ProjectDir(), iconPath);
            }
            try {
                BufferedImage bi = ImageIO.read(iconFile);
                if (bi.getWidth() != 512 || bi.getHeight() != 512) {
                    throw new MojoExecutionException("The icon must be a 512x512 pixel PNG image. It will be scaled to the proper sizes for devices");
                }
                r.setIcon(iconFile.getAbsolutePath());
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error reading the icon: the icon must be a 512x512 pixel PNG image. It will be scaled to the proper sizes for devices");
            }
            r.setVendor(props.getProperty("codename1.vendor"));
            r.setSubTitle(props.getProperty("codename1.secondaryTitle"));
            r.setType("ios");
            for (Object k : props.keySet()) {
                String key = (String)k;
                if (!key.startsWith("codename1.arg.")) continue;
                String value = props.getProperty(key);
                String currentKey = key.substring(14);
                if (currentKey.indexOf(32) > -1) {
                    throw new MojoExecutionException("The build argument contains a space in the key: '" + currentKey + "'");
                }
                r.putArgument(currentKey, value);
            }
            BuildRequest request = r;
            String incSources = request.getArg("build.incSources", null);
            request.setIncludeSource(true);
            String testBuild = request.getArg("build.unitTest", null);
            if (testBuild != null && testBuild.equals("1")) {
                e.setUnitTestMode(true);
            }
            try {
                boolean result = e.build(distJar, request);
                if (!result) {
                    throw new MojoExecutionException("iOS build failed");
                }
                if (!BUILD_TARGET_XCODE_PROJECT.equals(this.buildTarget) || e.getXcodeProjectDir() == null) break block22;
                File xcodeProject = e.getXcodeProjectDir();
                File output = this.getGeneratedIOSProjectSourceDirectory();
                output.getParentFile().mkdirs();
                try {
                    this.getLog().info((CharSequence)("Copying Xcode Project to " + output));
                    FileUtils.copyDirectory((File)xcodeProject, (File)output);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Failed to copy xcode project at " + xcodeProject + " to " + output, (Exception)ex);
                }
                if (this.open) {
                    this.getLog().info((CharSequence)("Opening workspace project " + this.getWorkspace(props, output)));
                    this.openWorkspace(this.getWorkspace(props, output));
                }
            }
            catch (BuildException ex) {
                throw new MojoExecutionException("Failed to build ios app", (Exception)ex);
            }
            finally {
                e.cleanup();
            }
        }
    }

    protected void afterBuild() {
    }

    private SortedProperties mergeRequiredProperties(String libraryName, Properties libProps, Properties projectProps) throws LibraryPropertiesException {
        String javaVersion = projectProps.getProperty("codename1.arg.java.version", "8");
        String javaVersionLib = (String)libProps.get("codename1.arg.java.version");
        if (javaVersionLib != null) {
            int v2;
            int v1 = 5;
            if (javaVersion != null) {
                v1 = Integer.parseInt(javaVersion);
            }
            if (v1 < (v2 = Integer.parseInt(javaVersionLib))) {
                throw new VersionMismatchException(libraryName, "Cannot use a cn1lib with java version greater then the project java version");
            }
        }
        SortedProperties merged = new SortedProperties();
        merged.putAll((Map<?, ?>)projectProps);
        Enumeration<?> keys = libProps.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!merged.containsKey(key)) {
                merged.put(key, libProps.getProperty(key));
                continue;
            }
            if (merged.get(key).equals(libProps.getProperty(key))) continue;
            throw new PropertyConflictException(libraryName, "Property " + key + " has a conflict");
        }
        return merged;
    }

    private static class PropertyConflictException
    extends LibraryPropertiesException {
        PropertyConflictException(String libName, String message) {
            super(libName, message);
        }
    }

    private static class VersionMismatchException
    extends LibraryPropertiesException {
        VersionMismatchException(String libName, String message) {
            super(libName, message);
        }
    }

    private static class LibraryPropertiesException
    extends Exception {
        private String libName;

        LibraryPropertiesException(String libName, String message) {
            super(message);
            this.libName = libName;
        }
    }
}

