/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.AbstractCN1Mojo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;

@Mojo(name="clone")
public class CloneProjectMojo
extends AbstractCN1Mojo {
    @Parameter(property="artifactId", required=false, defaultValue="")
    private String artifactId;
    @Parameter(property="groupId", required=false, defaultValue="")
    private String groupId;
    @Parameter(property="version", defaultValue="1.0-SNAPSHOT")
    private String version;
    @Parameter(property="gui", defaultValue="false")
    private boolean gui;
    @Parameter(property="destination", defaultValue="${project.build.directory}/generated-sources/cn1-cloned-projects")
    private File destination;

    private String artifactIdToMainName(String artifactId) {
        StringBuilder sb = new StringBuilder();
        boolean nextUpper = false;
        for (char c : artifactId.toCharArray()) {
            if (sb.length() == 0) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            if (!Character.isLetterOrDigit(c)) {
                nextUpper = true;
                continue;
            }
            if (nextUpper) {
                sb.append(Character.toUpperCase(c));
                nextUpper = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private JPanel wrapLeft(Component cmp) {
        JPanel panel = new JPanel();
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(0);
        panel.setLayout(layout);
        panel.add(cmp);
        return panel;
    }

    private boolean showGUIPrompt() {
        if (!EventQueue.isDispatchThread()) {
            try {
                boolean[] result = new boolean[1];
                EventQueue.invokeAndWait(() -> {
                    result[0] = this.showGUIPrompt();
                });
                return result[0];
            }
            catch (Exception ex) {
                return false;
            }
        }
        JTextField tfArtifactId = new JTextField();
        JTextField tfGroupId = new JTextField();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        tfArtifactId.setText(this.artifactId);
        if (this.artifactId == null || this.artifactId.isEmpty()) {
            tfArtifactId.setText(this.project.getParent().getArtifactId());
        }
        tfArtifactId.setToolTipText("Enter artifact ID for cloned project");
        tfArtifactId.setColumns(30);
        tfGroupId.setText(this.groupId);
        if (this.groupId == null || this.groupId.isEmpty()) {
            tfGroupId.setText(this.project.getGroupId());
        }
        tfGroupId.setColumns(30);
        tfGroupId.setToolTipText("Enter Group ID for cloned project");
        panel.add(this.wrapLeft(new JLabel("Group ID: ", 2)));
        panel.add(tfGroupId);
        panel.add(this.wrapLeft(new JLabel("Artifact ID:", 2)));
        panel.add(tfArtifactId);
        JTextField tfDestination = new JTextField();
        tfDestination.setColumns(30);
        if (this.destination != null) {
            tfDestination.setText(this.destination.getAbsolutePath());
        }
        panel.add(this.wrapLeft(new JLabel("Destination:", 2)));
        JButton browse = new JButton("Browse...");
        browse.addActionListener(evt -> {
            File selectedFile;
            JFileChooser chooser = new JFileChooser();
            if (this.destination != null) {
                chooser.setCurrentDirectory(this.destination);
            }
            chooser.setDialogTitle("Select Destination Directory");
            chooser.setFileSelectionMode(1);
            int result = chooser.showOpenDialog(SwingUtilities.getWindowAncestor(browse));
            if (result == 0 && (selectedFile = chooser.getSelectedFile()) != null && selectedFile.isDirectory()) {
                tfDestination.setText(selectedFile.getAbsolutePath());
            }
        });
        JPanel destinationPanel = new JPanel();
        destinationPanel.setLayout(new BorderLayout());
        destinationPanel.add((Component)tfDestination, "Center");
        destinationPanel.add((Component)browse, "East");
        panel.add(destinationPanel);
        int result = JOptionPane.showOptionDialog(null, panel, "Enter New Project Details", 2, 1, null, null, null);
        if (result == 0) {
            this.artifactId = tfArtifactId.getText();
            this.groupId = tfGroupId.getText();
            this.destination = new File(tfDestination.getText());
            return true;
        }
        return false;
    }

    @Override
    protected void executeImpl() throws MojoExecutionException, MojoFailureException {
        if (!this.isCN1ProjectDir()) {
            return;
        }
        if (this.gui) {
            this.showGUIPrompt();
        }
        if (this.artifactId == null || this.artifactId.isEmpty()) {
            throw new MojoFailureException("artifactId is a required parameter.");
        }
        if (this.groupId == null || this.groupId.isEmpty()) {
            throw new MojoFailureException("groupId is a required parameter.");
        }
        File generateAppProjectProps = new File(this.getCN1ProjectDir().getParentFile(), "generate-app-project.rpf");
        if (!generateAppProjectProps.exists()) {
            Properties cn1Props = new Properties();
            try (FileInputStream fis = new FileInputStream(new File(this.getCN1ProjectDir(), "codenameone_settings.properties"));){
                cn1Props.load(fis);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to load codenameone_settings.properties.", (Exception)ex);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("template.type=maven\n");
            sb.append("template.mainName=").append(cn1Props.getProperty("codename1.mainName")).append("\n");
            sb.append("template.packageName=").append(cn1Props.getProperty("codename1.packageName")).append("\n");
            sb.append("\n");
            if (new File(this.getCN1ProjectDir(), "pom.xml").exists()) {
                sb.append("[dependencies]\n");
                sb.append("====\n");
                try {
                    this.writeDependencies(sb, new File(this.getCN1ProjectDir(), "pom.xml"));
                }
                catch (IOException ex) {
                    throw new MojoFailureException("Failed to write generate-app-project.rpf while extracting depencies from common pom.xml file", (Throwable)ex);
                }
            } else {
                throw new MojoFailureException("Cannot find common pom.xml file");
            }
            sb.append("====\n\n");
            if (new File(this.getCN1ProjectDir().getParentFile(), "pom.xml").exists()) {
                sb.append("[parentDependencies]\n");
                sb.append("====\n");
                try {
                    this.writeDependencies(sb, new File(this.getCN1ProjectDir().getParentFile(), "pom.xml"));
                }
                catch (IOException ex) {
                    throw new MojoFailureException("Failed to write generate-app-project.rpf while extracting depencies from root pom.xml file", (Throwable)ex);
                }
                sb.append("====\n");
            }
            try {
                FileUtils.writeStringToFile((File)generateAppProjectProps, (String)sb.toString(), (String)"UTF-8");
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to write " + generateAppProjectProps + ".", (Exception)ex);
            }
        }
        String mainName = this.artifactIdToMainName(this.artifactId);
        File outputDirectory = this.destination;
        outputDirectory.mkdirs();
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        String pluginVersion = "LATEST";
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read(((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/com.codenameone/codenameone-maven-plugin/pom.xml"));
            pluginVersion = model.getVersion();
        }
        catch (Exception ex) {
            this.getLog().warn((CharSequence)"Attempted to read archetype version from embedded pom.xml file but failed", (Throwable)ex);
        }
        request.setGoals(Collections.singletonList("com.codenameone:codenameone-maven-plugin:" + pluginVersion + ":generate-app-project"));
        Properties props = new Properties();
        props.setProperty("archetypeGroupId", "com.codenameone");
        props.setProperty("archetypeArtifactId", "cn1app-archetype");
        props.setProperty("archetypeVersion", pluginVersion);
        props.setProperty("artifactId", this.artifactId);
        props.setProperty("groupId", this.groupId);
        props.setProperty("version", this.version);
        props.setProperty("mainName", mainName);
        props.setProperty("interactiveMode", "false");
        props.setProperty("sourceProject", this.getCN1ProjectDir().getParentFile().getAbsolutePath());
        props.setProperty("cn1Version", pluginVersion);
        request.setProperties(props);
        if (this.getLog().isErrorEnabled()) {
            request.setShowErrors(true);
        }
        if (this.getLog().isDebugEnabled()) {
            request.setDebug(true);
        }
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setWorkingDirectory(outputDirectory);
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() != 0) {
                throw new MojoFailureException("Failed to generate project.  Exit code " + result.getExitCode());
            }
        }
        catch (MavenInvocationException ex) {
            this.getLog().error((CharSequence)"Failed to clone project");
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
        this.getLog().info((CharSequence)("Project created at " + outputDirectory + File.separator + this.artifactId));
    }

    private void writeDependencies(StringBuilder sb, File pom) throws IOException {
        Model dummyModel;
        Model model;
        MavenXpp3Reader reader;
        if (!pom.exists()) {
            throw new IOException("Cannot write dependencies because " + pom + " does not exist");
        }
        try (FileInputStream fis = new FileInputStream(pom);){
            reader = new MavenXpp3Reader();
            model = reader.read((InputStream)fis);
        }
        catch (Exception ex) {
            throw new IOException("Failed to read dummy pom.xml file while injecting dependencies into " + pom, ex);
        }
        String dummyModelStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n    <groupId>link.sharpe</groupId>\n    <artifactId>mavenproject1</artifactId>\n    <version>1.0-SNAPSHOT</version>\n    <dependencies>\n    </dependencies>\n</project>";
        try {
            reader = new MavenXpp3Reader();
            dummyModel = reader.read((Reader)new CharArrayReader(dummyModelStr.toCharArray()));
        }
        catch (Exception ex) {
            throw new IOException("Failed to read dummy pom.xml", ex);
        }
        for (Dependency dep : model.getDependencies()) {
            if (dep.getArtifactId().equals("codenameone-core") && dep.getGroupId().equals("com.codenameone")) continue;
            dummyModel.addDependency(dep);
        }
        MavenXpp3Writer writer = new MavenXpp3Writer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writer.write((OutputStream)baos, dummyModel);
        String dummyPomStr = new String(baos.toByteArray(), "UTF-8");
        int startPos = dummyPomStr.indexOf("<dependencies>");
        if (startPos >= 0) {
            startPos += "<dependencies>".length();
        }
        if (startPos >= 0) {
            int endPos = dummyPomStr.indexOf("</dependencies>");
            if (endPos < 0) {
                throw new IOException("Malformed pom.xml generated for dependencies.  Could not find closing dependencies tag.");
            }
            sb.append(dummyPomStr.substring(startPos, endPos)).append("\n");
        }
    }
}

