/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Zip;

public class Cn1libInstaller {
    private File cn1libsDirectory;
    private File file;
    private String groupId;
    private String artifactId;
    private String version;
    private boolean updatePom;
    private boolean overwrite;
    private MavenProject _project;
    private Project antProject;
    private Log log;
    private File basedir;
    private String baseGroupId;
    private String baseArtifactId;
    private String baseVersion;

    private Log getLog() {
        return this.log;
    }

    private void setupAntProject() {
        this.antProject = new Project();
        if (this.getProjectBasedir() != null) {
            this.antProject.setBaseDir(this.getProjectBasedir());
        } else {
            this.antProject.setBaseDir(new File("."));
        }
        this.antProject.setDefaultInputStream(System.in);
        DefaultInputHandler handler = new DefaultInputHandler();
        this.antProject.setProjectReference((Object)handler);
        this.antProject.setInputHandler((InputHandler)handler);
        this.antProject.init();
    }

    public Cn1libInstaller(MavenProject project, Log log) {
        Properties props = project.getProperties();
        this.file = props.containsKey("file") ? new File(project.getProperties().getProperty("file")) : null;
        this.groupId = props.getProperty("groupId");
        this.artifactId = props.getProperty("artifactId");
        this.version = props.getProperty("version");
        this.updatePom = !"false".equals(props.getProperty("updatePom"));
        this.overwrite = "true".equals(props.getProperty("overwrite"));
        this._project = project;
        this.log = log;
        this.setupAntProject();
    }

    public Cn1libInstaller(File basedir, String baseGroupId, String baseArtifactId, String baseVersion, Log log) {
        this.log = log;
        this.basedir = basedir;
        this.baseGroupId = baseGroupId;
        this.baseArtifactId = baseArtifactId;
        this.baseVersion = baseVersion;
        this.setupAntProject();
    }

    private File getProjectBasedir() {
        if (this._project != null) {
            return this._project.getBasedir();
        }
        return this.basedir;
    }

    public void setProjectBasedir(File basedir) {
        this.basedir = basedir;
    }

    private String getProjectBuildDirectory() {
        if (this._project != null) {
            return this._project.getBuild().getDirectory();
        }
        return new File(this.getProjectBasedir(), "target").getAbsolutePath();
    }

    private String getBaseGroupId() {
        if (this._project != null) {
            return this._project.getParent().getGroupId();
        }
        return this.baseGroupId;
    }

    public void setBaseGroupId(String groupId) {
        this.baseGroupId = groupId;
    }

    private String getBaseArtifactId() {
        if (this._project != null) {
            return this._project.getParent().getArtifactId();
        }
        return this.baseArtifactId;
    }

    public void setBaseArtifactId(String artifactId) {
        this.baseArtifactId = artifactId;
    }

    private String getBaseVersion() {
        if (this._project != null) {
            return this._project.getParent().getVersion();
        }
        return this.baseVersion;
    }

    public void setBaseVersion(String baseVersion) {
        this.baseVersion = baseVersion;
    }

    private void checkProps() {
        if (this._project != null) {
            return;
        }
        if (this.baseVersion == null) {
            throw new IllegalStateException("baseVersion not set.  Should be set to the version of the parent app project.");
        }
        if (this.baseArtifactId == null) {
            throw new IllegalStateException("baseArtifactId not set.  Should be set to the aftifactId of the parent app project");
        }
        if (this.baseGroupId == null) {
            throw new IllegalStateException("baseGroupId not set.  Should be set to the groupId of the parent app project");
        }
        if (this.basedir == null) {
            throw new IllegalStateException("basedir is not set.  Should be set to the common project directory");
        }
    }

    protected void executeImpl() throws MojoExecutionException, MojoFailureException {
        File cssJar;
        File winJar;
        File jsJar;
        File iosJar;
        File androidJar;
        File seJar;
        String version;
        String artifactId;
        File canonicalFile;
        this.checkProps();
        try {
            canonicalFile = this.getProjectBasedir().getCanonicalFile();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to get canonical file for project basedir", (Exception)ex);
        }
        if (!canonicalFile.getName().equals("common")) {
            throw new MojoFailureException("install-cn1lib goal can only be run from the standard maven project format.  The project directory name is expected to be 'common' but found '" + canonicalFile.getName() + "'");
        }
        if (canonicalFile.getParentFile() == null) {
            throw new MojoFailureException("Cannot run install-cn1lib goal because the project structure is invalid. Cannot find parent directory of project");
        }
        File parentPom = new File(canonicalFile.getParentFile(), "pom.xml");
        if (!parentPom.exists()) {
            throw new MojoFailureException("Cannot run install-cn1lib goal because the project structure is invalid. Cannot find file " + parentPom);
        }
        if (!this.file.exists()) {
            throw new MojoExecutionException("The file " + this.file + " cannot be found.");
        }
        if (!this.file.getName().endsWith(".cn1lib")) {
            throw new MojoExecutionException("File must have .cn1lib extension");
        }
        File cn1libsDirectory = new File(canonicalFile.getParentFile(), "cn1libs");
        if (!cn1libsDirectory.exists()) {
            cn1libsDirectory.mkdirs();
        }
        this.cn1libsDirectory = cn1libsDirectory;
        String libName = this.file.getName().substring(0, this.file.getName().lastIndexOf("."));
        File cn1libDirectory = new File(cn1libsDirectory, libName);
        if (cn1libDirectory.exists()) {
            if (this.overwrite) {
                try {
                    FileUtils.deleteDirectory((File)cn1libDirectory);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Failed to delete existing " + cn1libDirectory, (Exception)ex);
                }
            } else {
                throw new MojoFailureException("Directory " + cn1libDirectory + " already exists.  Add the -Doverwrite=true or delete this directory and try again.");
            }
        }
        cn1libDirectory.mkdir();
        File cn1libJars = new File(cn1libDirectory, "jars");
        File generatedSources = new File(this.getProjectBuildDirectory() + File.separator + "generated-sources");
        generatedSources.mkdirs();
        File libOutputDir = new File(generatedSources, libName);
        if (libOutputDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)libOutputDir);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to delete directory.", (Exception)ex);
            }
        }
        libOutputDir.mkdirs();
        File libOutputJars = new File(libOutputDir, "jars");
        Expand unzip = (Expand)this.antProject.createTask("unzip");
        unzip.setSrc(this.file);
        unzip.setDest(libOutputJars);
        unzip.execute();
        String groupId = this.groupId;
        if (groupId == null) {
            groupId = this.getBaseGroupId();
        }
        if ((artifactId = this.artifactId) == null) {
            artifactId = this.getBaseArtifactId() + "-" + libName;
        }
        if ((version = this.version) == null) {
            version = this.getBaseVersion();
        }
        if ((seJar = new File(libOutputJars, "nativese.zip")).exists()) {
            try {
                FileUtils.copyFile((File)seJar, (File)new File(cn1libJars, seJar.getName()));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to copy " + seJar + " to " + cn1libJars, (Exception)ex);
            }
        }
        if ((androidJar = new File(libOutputJars, "nativeand.zip")).exists()) {
            try {
                FileUtils.copyFile((File)androidJar, (File)new File(cn1libJars, androidJar.getName()));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to copy " + androidJar + " to " + cn1libJars, (Exception)ex);
            }
        }
        if ((iosJar = new File(libOutputJars, "nativeios.zip")).exists()) {
            try {
                FileUtils.copyFile((File)iosJar, (File)new File(cn1libJars, iosJar.getName()));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to copy " + iosJar + " to " + cn1libJars, (Exception)ex);
            }
        }
        if ((jsJar = new File(libOutputJars, "nativejavascript.zip")).exists()) {
            try {
                FileUtils.copyFile((File)jsJar, (File)new File(cn1libJars, jsJar.getName()));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to copy " + jsJar + " to " + cn1libJars, (Exception)ex);
            }
        }
        File mainJar = new File(libOutputJars, "main.zip");
        File mainTmp = new File(libOutputJars, "main");
        mainTmp.mkdir();
        File metaDir = new File(mainTmp, PathUtil.path("META-INF", "codenameone", groupId, artifactId));
        metaDir.mkdirs();
        File appendedProps = new File(libOutputJars, "codenameone_library_appended.properties");
        File requiredProps = new File(libOutputJars, "codenameone_library_required.properties");
        if (appendedProps.exists()) {
            try {
                FileUtils.copyFile((File)appendedProps, (File)new File(metaDir, appendedProps.getName()));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to copy " + appendedProps, (Exception)ex);
            }
        }
        if (requiredProps.exists()) {
            try {
                FileUtils.copyFile((File)requiredProps, (File)new File(metaDir, requiredProps.getName()));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to copy " + requiredProps, (Exception)ex);
            }
        }
        Zip zip = (Zip)this.antProject.createTask("zip");
        zip.setBasedir(mainTmp);
        zip.setDestFile(mainJar);
        zip.setCompress(true);
        zip.setUpdate(mainJar.exists());
        zip.execute();
        if (mainJar.exists()) {
            try {
                FileUtils.copyFile((File)mainJar, (File)new File(cn1libJars, mainJar.getName()));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to copy " + mainJar + " to " + cn1libJars, (Exception)ex);
            }
        }
        if ((winJar = new File(libOutputJars, "nativewin.zip")).exists()) {
            try {
                FileUtils.copyFile((File)winJar, (File)new File(cn1libJars, winJar.getName()));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to copy " + winJar + " to " + cn1libJars, (Exception)ex);
            }
        }
        if ((cssJar = new File(libOutputJars, "css.zip")).exists()) {
            File cssTmp = new File(libOutputJars, PathUtil.path("META-INF", "codenameone", groupId, artifactId, "css"));
            cssTmp.getParentFile().mkdirs();
            Expand unzipCss = (Expand)this.antProject.createTask("unzip");
            unzipCss.setSrc(cssJar);
            unzipCss.setDest(cssTmp);
            unzipCss.execute();
            Zip zipCss = (Zip)this.antProject.createTask("zip");
            zipCss.setBasedir(cssTmp);
            File rebasedCssJar = new File(cssJar.getParentFile(), "css-rebased.zip");
            zipCss.setDestFile(rebasedCssJar);
            zipCss.execute();
            cssJar = rebasedCssJar;
            try {
                FileUtils.copyFile((File)cssJar, (File)new File(cn1libJars, "css.zip"));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to copy " + cssJar + " to " + cn1libJars, (Exception)ex);
            }
        }
        String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n<parent>  <artifactId>" + this.getBaseArtifactId() + "-cn1libs</artifactId>\n  <groupId>" + this.getBaseGroupId() + "</groupId>\n  <version>" + this.getBaseVersion() + "</version>\n</parent>\n\n  <groupId>" + groupId + "</groupId>\n  <artifactId>" + artifactId + "</artifactId>\n  <version>" + version + "</version>\n  <packaging>pom</packaging>\n  <name>" + libName + "</name>\n  <dependencies>\n" + (mainJar.exists() ? "<dependency>\n     <groupId>" + groupId + "</groupId>\n     <artifactId>" + artifactId + "</artifactId>\n     <version>" + version + "</version>\n     <classifier>common</classifier>\n     <type>jar</type>\n</dependency>\n" : "") + (cssJar.exists() ? "<dependency>\n  <groupId>" + groupId + "</groupId>\n  <artifactId>" + artifactId + "</artifactId>\n  <version>" + version + "</version>\n  <classifier>cn1css</classifier>\n  <type>zip</type>\n</dependency>\n" : "") + "</dependencies>\n<profiles>\n" + (seJar.exists() ? this.profileXml("javase", groupId, artifactId, version) : "") + (androidJar.exists() ? this.profileXml("android", groupId, artifactId, version) : "") + (iosJar.exists() ? this.profileXml("ios", groupId, artifactId, version) : "") + (jsJar.exists() ? this.profileXml("javascript", groupId, artifactId, version) : "") + (winJar.exists() ? this.profileXml("win", groupId, artifactId, version) : "") + "</profiles>\n<build>\n  <plugins>\n    <plugin>\n      <groupId>org.codehaus.mojo</groupId>\n      <artifactId>build-helper-maven-plugin</artifactId>\n      <version>1.7</version>\n      <executions>\n          <execution>\n            <id>attach-artifacts</id>\n            <phase>package</phase>\n            <goals>\n              <goal>attach-artifact</goal>\n            </goals>\n            <configuration>\n              <artifacts>\n" + (mainJar.exists() ? "<artifact>\n<file>${basedir}/jars/" + mainJar.getName() + "</file>\n<type>jar</type>\n<classifier>common</classifier>\n</artifact>\n" : "") + (seJar.exists() ? "<artifact>\n<file>${basedir}/jars/" + seJar.getName() + "</file>\n<type>jar</type>\n<classifier>javase</classifier>\n</artifact>\n" : "") + (androidJar.exists() ? "<artifact>\n<file>${basedir}/jars/" + androidJar.getName() + "</file>\n<type>jar</type>\n<classifier>android</classifier>\n</artifact>\n" : "") + (iosJar.exists() ? "<artifact>\n<file>${basedir}/jars/" + iosJar.getName() + "</file>\n<type>jar</type>\n<classifier>ios</classifier>\n</artifact>\n" : "") + (jsJar.exists() ? "<artifact>\n<file>${basedir}/jars/" + jsJar.getName() + "</file>\n<type>jar</type>\n<classifier>javascript</classifier>\n</artifact>\n" : "") + (winJar.exists() ? "<artifact>\n<file>${basedir}/jars/" + winJar.getName() + "</file>\n<type>jar</type>\n<classifier>win</classifier>\n</artifact>\n" : "") + (cssJar.exists() ? "<artifact>\n<file>${basedir}/jars/css.zip</file>\n<type>zip</type>\n<classifier>cn1css</classifier>\n</artifact>\n" : "") + "              </artifacts>\n            </configuration>\n          </execution>\n        </executions>\n      </plugin>\n    </plugins>\n   </build>\n</project>";
        File pomFile = new File(cn1libDirectory, "pom.xml");
        try {
            FileUtils.writeStringToFile((File)pomFile, (String)pomXml, (String)"UTF-8");
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Cannot write pom.xml file", (Exception)ex);
        }
        String dependencyString = "<dependency>\n  <artifactId>" + artifactId + "</artifactId>\n  <groupId>" + groupId + "</groupId>\n  <version>" + version + "</version>\n  <type>pom</type>\n</dependency>\n";
        if (this.updatePom) {
            String parentPomContents;
            String pomContents;
            File projectPom = new File(this.getProjectBasedir(), "pom.xml");
            this.getLog().info((CharSequence)("Attempting to update " + projectPom + " with the the dependency:\n" + dependencyString));
            try {
                pomContents = FileUtils.readFileToString((File)projectPom, (String)"UTF-8");
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to read pom file for updating dependencies", (Exception)ex);
            }
            boolean writeChanges = false;
            if (pomContents.contains("<artifactId>" + artifactId + "</artifactId>")) {
                this.getLog().warn((CharSequence)("The artifact " + artifactId + " is already referenced in the project Pom file at " + projectPom + ". To avoid conflicts we are not adding the dependency.  You should manually update your dependency to the following:\n" + dependencyString));
            } else {
                String marker = "<!-- INJECT DEPENDENCIES -->";
                if (!pomContents.contains(marker)) {
                    this.getLog().warn((CharSequence)("The project pom does not include an dependency injection marker to indicate where dependencies should be added to the pom file.\nNot adding the dependency for the cnlib " + this.file + ".\nPlease add the following dependency to your project pom file at " + projectPom + ":\n" + dependencyString));
                } else {
                    pomContents = pomContents.replace(marker, dependencyString + "\n" + marker);
                    try {
                        FileUtils.writeStringToFile((File)projectPom, (String)pomContents, (String)"UTF-8");
                    }
                    catch (IOException ex) {
                        throw new MojoExecutionException("Failed to write changes to " + projectPom + ".  Please add the dependency manually by adding the following snippet to the build/dependencies section of your pom.xml file: \n" + dependencyString, (Exception)ex);
                    }
                    this.getLog().info((CharSequence)("Successfully injected the dependency into " + projectPom + "\n" + dependencyString));
                }
            }
            File parentPomFile = new File(cn1libsDirectory, "pom.xml");
            String injectedXml = "<!-- Profile injected by install-cn1lib goal for " + libName + " cn1lib -->\n<profile>\n  <id>" + this.file.getName() + "-cn1lib</id>\n  <activation>\n    <file><exists>${basedir}/" + libName + "/pom.xml</exists></file>\n  </activation>  <modules><module>" + libName + "</module></modules>\n</profile>\n<profile>\n  <id>" + this.file.getName() + "-cn1lib-fromroot</id>\n  <activation>\n    <file><exists>${basedir}/cn1libs/" + libName + "/pom.xml</exists></file>\n  </activation>  <modules><module>" + libName + "</module></modules>\n</profile>\n";
            if (parentPomFile.exists()) {
                try {
                    parentPomContents = FileUtils.readFileToString((File)parentPomFile, (String)"UTF-8");
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Failed to read " + parentPomFile + " for injecting the cn1lib profile.  Please insert this profile manually:\n" + injectedXml, (Exception)ex);
                }
            } else {
                parentPomContents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n    <parent>  <artifactId>" + this.getBaseArtifactId() + "</artifactId>\n        <groupId>" + this.getBaseGroupId() + "</groupId>\n        <version>" + this.getBaseVersion() + "</version>\n    </parent>\n\n    <groupId>" + this.getBaseGroupId() + "</groupId>\n    <artifactId>" + this.getBaseArtifactId() + "-cn1libs</artifactId>\n    <version>" + this.getBaseVersion() + "</version>\n    <packaging>pom</packaging>\n    <name>" + this.getBaseArtifactId() + "-cn1libs</name>\n    <profiles>\n    </profiles>\n</project>";
            }
            if (parentPomContents.contains("<module>cn1libs/" + libName + "</module>")) {
                this.getLog().warn((CharSequence)("The module " + libName + " is already referenced inside " + parentPomFile + ".  Please review that pom file and, if necessary, add the following snippet manaullay:\n" + injectedXml));
            } else {
                if (!parentPomContents.contains("</profiles>")) {
                    if (!parentPomContents.contains("</project>")) {
                        throw new MojoExecutionException("During attempt to inject <profiles> section into " + parentPomFile + " could not find a closing </project> tag.");
                    }
                    parentPomContents = parentPomContents.replace("</project>", "<profiles>\n</profiles>\n</project>");
                }
                parentPomContents = parentPomContents.replace("</profiles>", injectedXml + "\n</profiles>");
                this.getLog().info((CharSequence)("Attempting to inject the following snippet into the <profiles> section of your pom.xml file at " + parentPomFile + ":\n" + injectedXml));
                try {
                    FileUtils.writeStringToFile((File)parentPomFile, (String)parentPomContents, (String)"UTF-8");
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Failed to update the pom file " + parentPomFile + ".  Attempting to update with the following content:\n" + parentPomFile);
                }
            }
        }
    }

    private String profileXml(String platform, String groupId, String artifactId, String version) {
        return "  <profile>\n    <id>" + platform + "</id>     <activation>         <property><name>codename1.platform</name><value>" + platform + "</value></property>\n     </activation>     <dependencies>         <dependency>             <groupId>" + groupId + "</groupId>\n             <artifactId>" + artifactId + "</artifactId>\n             <version>" + version + "</version>\n             <type>jar</type>\n             <classifier>" + platform + "</classifier>\n         </dependency>\n     </dependencies>\n  </profile>";
    }

    private void installFile(File file, String groupId, String artifactId, String version, String classifier) throws MojoExecutionException {
        this.installFile(file, groupId, artifactId, version, classifier, "jar");
    }

    private void installFile(File file, String groupId, String artifactId, String version, String classifier, String packaging) throws MojoExecutionException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setGoals(Collections.singletonList("install:install-file"));
        Properties props = new Properties();
        props.setProperty("file", file.getAbsolutePath());
        props.setProperty("groupId", groupId);
        props.setProperty("artifactId", artifactId);
        props.setProperty("packaging", packaging);
        props.setProperty("version", version);
        props.setProperty("interactiveMode", "false");
        if (classifier != null) {
            props.setProperty("classifier", classifier);
        }
        props.setProperty("localRepositoryPath", this.cn1libsDirectory.getAbsolutePath());
        request.setProperties(props);
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            invoker.execute((InvocationRequest)request);
        }
        catch (MavenInvocationException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setUpdatePom(boolean updatePom) {
        this.updatePom = updatePom;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

