/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.AbstractCN1Mojo;
import com.codename1.maven.PathUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.tools.ant.taskdefs.Javadoc;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="cn1lib", defaultPhase=LifecyclePhase.PACKAGE)
public final class Cn1libMojo
extends AbstractCN1Mojo {
    private File getNativeDir() {
        return new File(this.getCN1LibProjectDir(), "native");
    }

    private File getBuildDir() {
        return new File(PathUtil.path(this.project.getBuild().getDirectory(), "codenameone", "cn1lib"));
    }

    private File getFinalCn1lib() {
        String finalName = this.project.getBuild().getFinalName().replace("-common-", "-");
        return new File(PathUtil.path(this.project.getBuild().getDirectory(), finalName + ".cn1lib"));
    }

    @Override
    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        if (!this.isCN1ProjectDir()) {
            return;
        }
        try {
            this.buildCn1lib();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to create CN1lib", (Exception)ex);
        }
        this.projectHelper.attachArtifact(this.project, "cn1lib", "cn1lib", this.getFinalCn1lib());
    }

    private String str(String str) {
        return str == null ? "" : str;
    }

    private boolean isSelf(Plugin plugin) {
        return plugin.getArtifactId().equals("codenameone-maven-plugin") && plugin.getGroupId().equals("com.codenameone");
    }

    private Plugin getSelf() {
        for (Plugin p : this.project.getBuildPlugins()) {
            if (!this.isSelf(p)) continue;
            return p;
        }
        return null;
    }

    private File findStubberJar() {
        File mavenPluginJar = this.getJar("com.codenameone", "codenameone-maven-plugin");
        if (mavenPluginJar == null || !mavenPluginJar.exists()) {
            throw new RuntimeException("Cannot find codenameone-maven-plugin jar");
        }
        File stubberJar = new File(mavenPluginJar.getParentFile(), "Stubber.jar");
        if (!stubberJar.exists() || mavenPluginJar.lastModified() > stubberJar.lastModified()) {
            try {
                FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("/Stubber.jar"), (File)stubberJar);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to copy Stubber.jar from resource stream to file at " + stubberJar);
            }
        }
        return stubberJar;
    }

    private File getStubsBuildDir() {
        return new File(this.getBuildDir(), "stubs");
    }

    private File getStubsZip() {
        return new File(this.getBuildDir(), "stubs.zip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildStubs() throws IOException {
        this.getLog().debug((CharSequence)("Found stubber " + this.findStubberJar()));
        this.getStubsBuildDir().mkdirs();
        File javaSourcesDir = new File(this.project.getBasedir(), PathUtil.path("src", "main", "java"));
        if (this.getStubsZip().exists() && this.getStubsZip().lastModified() >= Cn1libMojo.lastModifiedRecursive(javaSourcesDir)) {
            this.getLog().debug((CharSequence)"Stubs have not changed.  Skipping stubber");
            return;
        }
        FileUtils.deleteDirectory((File)this.getStubsBuildDir());
        this.getStubsBuildDir().mkdir();
        String userDir = System.getProperty("user.dir");
        System.setProperty("user.dir", this.getBuildDir().getAbsolutePath());
        try {
            Javadoc javadoc = (Javadoc)this.antProject.createTask("javadoc");
            Path sourcePath = new Path(this.antProject, javaSourcesDir.getAbsolutePath());
            javadoc.setSourcepath(sourcePath);
            Path classPath = new Path(this.antProject);
            for (Artifact artifact : this.project.getArtifacts()) {
                classPath.add(new Path(this.antProject, artifact.getFile().getAbsolutePath()));
            }
            javadoc.setClasspath(classPath);
            javadoc.setDocletPath(new Path(this.antProject, this.findStubberJar().getAbsolutePath()));
            javadoc.setDoclet("com.codename1.build.client.StubGenerator");
            FileSet fileset = new FileSet();
            fileset.setProject(this.antProject);
            fileset.setDir(javaSourcesDir);
            this.getLog().debug((CharSequence)("includes=" + this.stubberIncludes + "; excludes=" + this.stubberExcludes));
            fileset.setExcludes("*.java," + this.str(this.stubberExcludes));
            fileset.setIncludes(this.str(this.stubberIncludes));
            FilenameSelector javaFiles = new FilenameSelector();
            javaFiles.setName("**/*.java");
            fileset.addFilename(javaFiles);
            javadoc.addFileset(fileset);
            javadoc.execute();
        }
        finally {
            System.setProperty("user.dir", userDir);
        }
        Zip zip = (Zip)this.antProject.createTask("zip");
        zip.setDestFile(this.getStubsZip());
        FileSet files = new FileSet();
        files.setProject(this.antProject);
        files.setDir(this.getStubsBuildDir());
        files.setIncludes("**");
        zip.addFileset(files);
        zip.execute();
        FileUtils.deleteDirectory((File)this.getStubsBuildDir());
    }

    private void buildMainZip() {
        this.getBuildDir().mkdirs();
        Zip zip = (Zip)this.antProject.createTask("zip");
        File mainZip = new File(this.getBuildDir(), "main.zip");
        zip.setDestFile(mainZip);
        FileSet files = new FileSet();
        files.setProject(this.antProject);
        files.setDir(new File(this.project.getBuild().getOutputDirectory()));
        files.setIncludes("**");
        zip.addFileset(files);
        zip.execute();
    }

    private File getModuleProject(String name) {
        return new File(this.project.getParent().getBasedir(), name);
    }

    private File[] getIOSPaths() {
        return new File[]{new File(this.getModuleProject("ios"), PathUtil.path("src", "main", "objectivec")), new File(this.getModuleProject("ios"), PathUtil.path("src", "main", "resources"))};
    }

    private static boolean isDirectoryEmpty(File directory) {
        String[] files = directory.list();
        return files.length == 0;
    }

    private void buildZip(String basename, File[] paths) {
        File zipFile = new File(this.getBuildDir(), basename + ".zip");
        Zip zip = (Zip)this.antProject.createTask("zip");
        zip.setDestFile(zipFile);
        boolean empty = true;
        for (File dir : paths) {
            FileSet fs = new FileSet();
            fs.setProject(this.antProject);
            fs.setDir(dir);
            fs.setIncludes("**");
            if (!dir.exists() || Cn1libMojo.isDirectoryEmpty(dir)) continue;
            empty = false;
            zip.addFileset(fs);
        }
        if (empty) {
            this.getLog().debug((CharSequence)("No directories found for " + basename + " zip file.  Skipping"));
            return;
        }
        zip.execute();
    }

    private void buildIOS() {
        this.buildZip("nativeios", this.getIOSPaths());
    }

    private File[] getAndroidPaths() {
        return new File[]{new File(this.getModuleProject("android"), PathUtil.path("src", "main", "java")), new File(this.getModuleProject("android"), PathUtil.path("src", "main", "resources"))};
    }

    private void buildAndroid() {
        this.buildZip("nativeand", this.getAndroidPaths());
    }

    private File[] getJavascriptPaths() {
        return new File[]{new File(this.getModuleProject("javascript"), PathUtil.path("src", "main", "javascript")), new File(this.getModuleProject("javascript"), PathUtil.path("src", "main", "resources"))};
    }

    private void buildJavascript() {
        this.buildZip("nativejavascript", this.getJavascriptPaths());
    }

    private File[] getJavasePaths() {
        return new File[]{new File(this.getModuleProject("javase"), PathUtil.path("src", "main", "java")), new File(this.getModuleProject("javase"), PathUtil.path("src", "main", "resources"))};
    }

    private void buildJavase() {
        this.buildZip("nativese", this.getJavasePaths());
    }

    private File[] getWinPaths() {
        return new File[]{new File(this.getModuleProject("win"), PathUtil.path("src", "main", "csharp")), new File(this.getModuleProject("win"), PathUtil.path("src", "main", "resources"))};
    }

    private void buildWin() {
        this.buildZip("nativewin", this.getWinPaths());
    }

    private File[] getCSSPaths() {
        return new File[]{new File(this.project.getBasedir(), PathUtil.path("src", "main", "css"))};
    }

    private void buildCSS() {
        this.buildZip("css", this.getCSSPaths());
    }

    private void buildCn1lib() throws IOException {
        this.buildMainZip();
        this.buildCSS();
        this.buildAndroid();
        this.buildIOS();
        this.buildJavascript();
        this.buildJavase();
        this.buildStubs();
        this.buildWin();
        Zip zip = (Zip)this.antProject.createTask("zip");
        zip.setDestFile(this.getFinalCn1lib());
        FileSet files = new FileSet();
        files.setProject(this.antProject);
        files.setDir(this.getBuildDir());
        files.setIncludes("**");
        zip.addFileset(files);
        files = new FileSet();
        files.setProject(this.antProject);
        files.setDir(this.project.getBasedir());
        files.setIncludes("*.properties");
        zip.addFileset(files);
        zip.execute();
    }
}

