/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;

public class Cn1libUtil {
    public static boolean isCN1Lib(File jar) {
        if (!jar.exists()) {
            return false;
        }
        try {
            JarFile jarFile = new JarFile(jar);
            Manifest mf = jarFile.getManifest();
            if (mf == null) {
                return false;
            }
            Attributes atts = mf.getAttributes("cn1lib");
            if (atts == null) {
                return false;
            }
            String version = atts.getValue("Version");
            return version != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static File getLibDirFor(Artifact artifact) {
        File artifactFile = artifact.getFile();
        if (artifactFile == null || !Cn1libUtil.isCN1Lib(artifactFile)) {
            return null;
        }
        File artifactDir = new File(artifactFile.getParentFile(), artifactFile.getName() + "-extracted");
        return artifactDir;
    }

    public static File getNativeSEJar(Artifact artifact) {
        return Cn1libUtil.getNativeJar(artifact, "javase");
    }

    public static File getNativeJar(Artifact artifact, String platform) {
        File libDir = Cn1libUtil.getLibDirFor(artifact);
        if (libDir == null) {
            return null;
        }
        File metaInf = new File(libDir, "META-INF");
        if (!metaInf.exists()) {
            return null;
        }
        File cn1libDir = new File(metaInf, "cn1lib");
        if (!cn1libDir.exists()) {
            return null;
        }
        File nativeSeJar = new File(cn1libDir, "native" + platform + ".zip");
        if (nativeSeJar.exists()) {
            return nativeSeJar;
        }
        return null;
    }

    public static File getNativeIOSJar(Artifact artifact) {
        return Cn1libUtil.getNativeJar(artifact, "ios");
    }

    public static File getNativeAndroidJar(Artifact artifact) {
        return Cn1libUtil.getNativeJar(artifact, "android");
    }

    public static File getNativeJavascriptJar(Artifact artifact) {
        return Cn1libUtil.getNativeJar(artifact, "javascript");
    }

    public static List<File> getNativeSEEmbeddedJars(Artifact artifact) {
        ArrayList<File> out = new ArrayList<File>();
        File nativeSEJar = Cn1libUtil.getNativeSEJar(artifact);
        if (nativeSEJar == null) {
            return out;
        }
        File extracted = new File(nativeSEJar.getParentFile(), nativeSEJar.getName() + "-extracted");
        if (extracted.exists()) {
            for (File child : extracted.listFiles()) {
                if (!child.getName().endsWith(".jar")) continue;
                out.add(child);
            }
        }
        return out;
    }
}

