/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.AbstractCN1Mojo;
import com.codename1.maven.PathUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Java;

@Mojo(name="css", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CompileCSSMojo
extends AbstractCN1Mojo {
    @Override
    protected void executeImpl() throws MojoExecutionException, MojoFailureException {
        File cssDirectory = this.findCSSDirectory();
        int themeCssLen = "theme.css".length();
        if (cssDirectory != null && cssDirectory.isDirectory()) {
            for (File file : cssDirectory.listFiles()) {
                String fileName = file.getName();
                if (!fileName.endsWith("theme.css")) continue;
                this.executeImpl(fileName.substring(0, fileName.length() - themeCssLen));
            }
        }
    }

    protected File findCSSDirectory() {
        for (String dir : this.project.getCompileSourceRoots()) {
            File dirFile = new File(dir);
            File cssSibling = new File(dirFile.getParentFile(), "css");
            File themeCss = new File(cssSibling, "theme.css");
            if (!themeCss.exists()) continue;
            return cssSibling;
        }
        return null;
    }

    protected File findLocalizationDirectory() {
        File cn1ProjectDir;
        if (this.project.getCompileSourceRoots() != null) {
            for (String dir : this.project.getCompileSourceRoots()) {
                File localizationSibling;
                File dirFile = new File(dir);
                File parent = dirFile.getParentFile();
                if (parent == null || !this.hasLocalizationBundles(localizationSibling = new File(parent, "l10n"))) continue;
                return localizationSibling;
            }
        }
        if ((cn1ProjectDir = this.getCN1ProjectDir()) != null) {
            File defaultLocalization = new File(cn1ProjectDir, PathUtil.path("src", "main", "l10n"));
            if (this.hasLocalizationBundles(defaultLocalization)) {
                return defaultLocalization;
            }
            File rootLocalization = new File(cn1ProjectDir, "l10n");
            if (this.hasLocalizationBundles(rootLocalization)) {
                return rootLocalization;
            }
        }
        return null;
    }

    private boolean hasLocalizationBundles(File directory) {
        if (directory == null || !directory.isDirectory()) {
            return false;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (!(file.isDirectory() ? this.hasLocalizationBundles(file) : file.getName().endsWith(".properties"))) continue;
            return true;
        }
        return false;
    }

    private void executeImpl(String themePrefix) throws MojoExecutionException, MojoFailureException {
        int res;
        if (!this.isCN1ProjectDir()) {
            return;
        }
        if (this.properties.getProperty("codename1.cssTheme", null) == null) {
            this.getLog().info((CharSequence)"CSS themes not activated for this project.  Skipping CSS compilation");
            return;
        }
        File cssDirectory = this.findCSSDirectory();
        if (cssDirectory == null || !cssDirectory.exists()) {
            this.getLog().warn((CharSequence)"CSS compilation skipped because no CSS theme was found");
            return;
        }
        File themeResOutput = new File(this.project.getBuild().getOutputDirectory() + File.separator + themePrefix + "theme.res");
        File cssBuildDir = new File(this.project.getBuild().getDirectory() + File.separator + "css");
        cssBuildDir.mkdirs();
        File mergeFile = new File(cssBuildDir, themePrefix + "theme.css");
        mergeFile.getParentFile().mkdirs();
        try {
            if (themeResOutput.exists() && this.getCSSSourcesModificationTime() < themeResOutput.lastModified()) {
                this.getLog().info((CharSequence)"CSS sources unchanged since last compile.  Skipping CSS compilation");
                return;
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to check CSS file modification times", (Exception)ex);
        }
        StringBuilder inputs = new StringBuilder();
        this.project.getArtifacts().forEach(artifact -> {
            if (artifact.hasClassifier() && "cn1css".equals(artifact.getClassifier())) {
                File zip = this.findArtifactFile((Artifact)artifact);
                if (zip == null || !zip.exists()) {
                    return;
                }
                File extracted = new File(zip.getParentFile(), zip.getName() + "-extracted");
                this.getLog().debug((CharSequence)("Checking for extracted CSS bundle " + extracted));
                if (extracted.exists() && artifact.isSnapshot() && this.getLastModified((Artifact)artifact) > extracted.lastModified()) {
                    try {
                        FileUtils.deleteDirectory((File)extracted);
                    }
                    catch (IOException ex) {
                        this.getLog().error((Throwable)ex);
                    }
                }
                if (!extracted.exists()) {
                    this.getLog().debug((CharSequence)("CSS bundle " + zip + " not extracted yet.  Extracting to " + extracted));
                    Expand expand = (Expand)this.antProject.createTask("unzip");
                    expand.setSrc(zip);
                    expand.setDest(extracted);
                    expand.execute();
                }
                if (extracted.exists()) {
                    File theme;
                    File extractedCssDir = new File(extracted, PathUtil.path("META-INF", "codenameone", artifact.getGroupId(), artifact.getArtifactId(), "css"));
                    if (extractedCssDir.exists() && (theme = new File(extractedCssDir, themePrefix + "theme.css")).exists()) {
                        if (inputs.length() > 0) {
                            inputs.append(",");
                        }
                        inputs.append(theme.getAbsolutePath());
                    }
                } else {
                    this.getLog().debug((CharSequence)("CSS bundle extraction must have failed for " + zip + " because after extraction it still doesn't exist at " + extracted));
                }
            }
        });
        File cssTheme = new File(cssDirectory, themePrefix + "theme.css");
        if (cssTheme.exists()) {
            if (inputs.length() > 0) {
                inputs.append(",");
            }
        } else {
            if (themePrefix.isEmpty() && inputs.length() > 0) {
                throw new MojoFailureException("Cannot compile CSS for this project.  The project does not include a " + themePrefix + "-theme.css file in " + cssTheme + ", but it includes dependencies that require CSS.  Please add a CSS file at " + cssTheme);
            }
            this.getLog().info((CharSequence)("Skipping CSS compilation for because " + themePrefix + cssTheme + " does not exist"));
            return;
        }
        inputs.append(cssTheme.getAbsolutePath());
        Java java = this.createJava();
        java.setDir(this.getCN1ProjectDir());
        java.setJar(this.getDesignerJar());
        java.setFork(true);
        java.setFailonerror(true);
        this.setupCef();
        String cefDir = System.getProperty("cef.dir", System.getProperty("user.home") + File.separator + ".codenameone" + File.separator + "cef");
        java.createJvmarg().setValue("-Dcli=true");
        java.createJvmarg().setValue("-Dcef.dir=" + cefDir);
        java.createArg().setValue("-css");
        java.createArg().setValue("-input");
        java.createArg().setValue(inputs.toString());
        java.createArg().setValue("-output");
        java.createArg().setFile(themeResOutput);
        java.createArg().setValue("-merge");
        java.createArg().setFile(mergeFile);
        File localizationDir = this.findLocalizationDirectory();
        if (localizationDir != null) {
            java.createArg().setValue("-l");
            java.createArg().setFile(localizationDir);
        }
        if ((res = java.executeJava()) != 0) {
            throw new MojoExecutionException("An error occurred while compiling the CSS files.  Inputs: " + inputs + ", output: " + new File(this.project.getBuild().getOutputDirectory() + File.separator + themePrefix + "theme.res") + ", merge file: " + mergeFile);
        }
    }
}

