/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.AbstractCN1Mojo;
import com.codename1.maven.PathUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;

@Mojo(name="compliance-check", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.TEST)
public class ComplianceCheckMojo
extends AbstractCN1Mojo {
    private File complianceOutputFile;
    private String proguardMainClass = "proguard.ProGuard";

    @Override
    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        if ("true".equals(System.getProperty("skipComplianceCheck", "false"))) {
            return;
        }
        if ("true".equals(this.project.getProperties().getProperty("skipComplianceCheck", "false"))) {
            return;
        }
        if ("true".equals(System.getProperty("reloadClasses", "false"))) {
            return;
        }
        if ("true".equals(this.project.getProperties().getProperty("reloadClasses", "false"))) {
            return;
        }
        if (!this.isCN1ProjectDir()) {
            return;
        }
        this.complianceOutputFile = new File(PathUtil.path(this.project.getBuild().getDirectory(), "codenameone", "compliance_check.txt"));
        this.getLog().info((CharSequence)"Running compliance check against Codename One Java Runtime API");
        this.getLog().info((CharSequence)"See https://www.codenameone.com/javadoc/ for supported Classes and Methods");
        if (!this.hasChangedSinceLastCheck()) {
            this.getLog().info((CharSequence)"Sources haven't changed since the last compliance check. Skipping check");
            return;
        }
        this.copyKotlinIncrementalCompileOutputToOutputDir();
        this.runProguard();
        this.complianceOutputFile.getParentFile().mkdirs();
        try {
            FileUtils.writeStringToFile((File)this.complianceOutputFile, (String)("Completed compliance check on " + this.project.getName()), (String)"UTF-8");
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to write compliance file");
        }
    }

    private boolean hasChangedSinceLastCheck() {
        if (!this.complianceOutputFile.exists()) {
            return true;
        }
        try {
            if (this.getSourcesModificationTime(true) > this.complianceOutputFile.lastModified()) {
                return true;
            }
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"Failed to check sources modification time for compliance check", (Throwable)ex);
        }
        return false;
    }

    private void runProguard() throws MojoExecutionException {
        this.runProguard(0);
        this.runProguard(1);
    }

    private void runProguard(int passNum) throws MojoExecutionException {
        int result;
        Java java = this.createJava();
        Path classPath = java.createClasspath();
        classPath.setProject(this.antProject);
        for (File jar : this.getProguardJars()) {
            classPath.add(new Path(this.antProject, jar.getAbsolutePath()));
        }
        this.getLog().info((CharSequence)("Proguard classpath: " + classPath));
        java.setClasspath(classPath);
        java.setClassname(this.proguardMainClass);
        java.setFailonerror(true);
        java.setFork(true);
        java.createArg().setValue("-dontobfuscate");
        if (passNum == 1) {
            java.createArg().setValue("-dontnote");
        } else {
            java.createArg().setValue("-dontnote");
            java.createArg().setValue("-dontwarn");
        }
        java.createArg().setValue("-libraryjars");
        Path libraryJarsPath = new Path(this.antProject, this.getJavaRuntimeJar().getAbsolutePath());
        libraryJarsPath.add(new Path(this.antProject, this.getCodenameOneJar().getAbsolutePath()));
        java.createArg().setPath(libraryJarsPath);
        this.getLog().debug((CharSequence)("Compliance check -libraryjars=" + libraryJarsPath));
        File complianceCheckJar = new File(this.project.getBuild().getDirectory() + File.separator + "compliance-check.jar");
        java.createArg().setValue("-keepattributes");
        java.createArg().setValue("Signature");
        java.createArg().setValue("-dontskipnonpubliclibraryclasses");
        java.createArg().setValue("-dontskipnonpubliclibraryclassmembers");
        java.createArg().setValue("-dontoptimize");
        if (passNum == 0) {
            Path inJars = new Path(this.antProject, this.project.getBuild().getOutputDirectory());
            this.project.getArtifacts().forEach(artifact -> {
                this.getLog().info((CharSequence)("artifact " + artifact));
                if (artifact.getGroupId().equals("com.codenameone") && artifact.getArtifactId().equals("codenameone-core")) {
                    return;
                }
                if (artifact.getGroupId().equals("com.codenameone") && artifact.getArtifactId().equals("java-runtime")) {
                    return;
                }
                if (artifact.getScope().equals("compile") || artifact.getScope().equals("system") || artifact.getScope().equals("test")) {
                    File jar = this.getJar((Artifact)artifact);
                    if (jar != null) {
                        this.getLog().info((CharSequence)("Adding to injars: " + jar));
                        inJars.add(new Path(this.antProject, this.getJar((Artifact)artifact).getAbsolutePath() + "(!META-INF/**)"));
                    } else {
                        this.getLog().warn((CharSequence)("No jar found for artifact " + artifact + ".  This might cause problems for the compliance check"));
                    }
                }
            });
            this.getLog().info((CharSequence)("injars = " + inJars));
            java.createArg().setValue("-injars");
            java.createArg().setPath(inJars);
            java.createArg().setValue("-outjars");
            java.createArg().setPath(new Path(this.antProject, complianceCheckJar.getAbsolutePath()));
        } else if (passNum == 1) {
            java.createArg().setValue("-injars");
            java.createArg().setPath(new Path(this.antProject, complianceCheckJar.getAbsolutePath()));
        }
        if (this.properties != null && this.properties.getProperty("codename1.mainName") != null && !this.properties.getProperty("codename1.mainName").isEmpty()) {
            String keep = "class " + this.properties.getProperty("codename1.packageName") + "." + this.properties.getProperty("codename1.mainName") + " {\n            *;\n            }";
            java.createArg().setValue("-keep");
            java.createArg().setValue(keep);
            this.getLog().info((CharSequence)("Keeping " + keep));
        } else {
            ArrayList<String> keeps = new ArrayList<String>();
            for (String sourceRoot : this.project.getCompileSourceRoots()) {
                File sourceRootFile = new File(sourceRoot);
                this.findClassesInDirectory(sourceRootFile.getAbsolutePath(), sourceRootFile, keeps);
            }
            this.getLog().info((CharSequence)("Keep classes: " + keeps));
            for (String keepClass : keeps) {
                String keep = "class " + keepClass + " {\n            *;\n            }";
                java.createArg().setValue("-keep");
                java.createArg().setValue(keep);
            }
        }
        if (passNum == 0) {
            this.getLog().debug((CharSequence)"Compliance check pass 0");
            java.createArg().setValue("-dontwarn **");
            java.createArg().setValue("-ignorewarnings");
        }
        if (this.getLog().isDebugEnabled()) {
            java.createArg().setValue("-verbose");
        }
        if ((result = java.executeJava()) != 0) {
            throw new MojoExecutionException("Compliance check failed");
        }
    }

    private void findClassesInDirectory(String sourceRootAbsolutePath, File file, List<String> out) {
        String fileName = file.getAbsolutePath();
        if (fileName.endsWith(".java") || fileName.endsWith(".kt")) {
            String className = fileName.substring(0, fileName.lastIndexOf(".")).substring(sourceRootAbsolutePath.length()).replace('/', '.').replace('\\', '.');
            if (className.startsWith(".")) {
                className = className.substring(1);
            }
            out.add(className);
        } else if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.findClassesInDirectory(sourceRootAbsolutePath, child, out);
            }
        }
    }

    private File getJavaRuntimeJar() {
        for (Artifact artifact : this.project.getArtifacts()) {
            if (!"java-runtime".equals(artifact.getArtifactId()) || !"com.codenameone".equals(artifact.getGroupId())) continue;
            return this.getJar(artifact);
        }
        for (Artifact artifact : this.pluginArtifacts) {
            if (!"java-runtime".equals(artifact.getArtifactId()) || !"com.codenameone".equals(artifact.getGroupId())) continue;
            return this.getJar(artifact);
        }
        throw new RuntimeException("java-runtime not found in dependencies");
    }

    private File getCodenameOneJar() {
        String codenameOneCoreId = "codenameone-core";
        for (Artifact artifact : this.project.getArtifacts()) {
            if (!codenameOneCoreId.equals(artifact.getArtifactId()) || !"com.codenameone".equals(artifact.getGroupId())) continue;
            return this.getJar(artifact);
        }
        for (Artifact artifact : this.pluginArtifacts) {
            if (!codenameOneCoreId.equals(artifact.getArtifactId()) || !"com.codenameone".equals(artifact.getGroupId())) continue;
            return this.getJar(artifact);
        }
        throw new RuntimeException(codenameOneCoreId + " not found in dependencies");
    }

    private List<File> getProguardJars() throws MojoExecutionException {
        ArrayList<Object> proguardArtifacts = new ArrayList<Object>();
        int proguardArtifactDistance = -1;
        Artifact proguardBase = null;
        for (Object artifact : this.pluginArtifacts) {
            if (!artifact.getArtifactId().equals("proguard-base")) continue;
            proguardBase = artifact;
            break;
        }
        for (Object artifact : this.pluginArtifacts) {
            this.getLog().debug((CharSequence)("pluginArtifact: " + artifact.getFile()));
            String string = artifact.getArtifactId();
            if (string.equals("java-runtime") && artifact.getGroupId().equals("com.codenameone")) continue;
            int distance = artifact.getDependencyTrail().size();
            this.getLog().debug((CharSequence)("proguard DependencyTrail: " + distance));
            for (Artifact artifact2 : proguardArtifacts) {
                if (!artifact2.getArtifactId().equals(string)) continue;
                this.getLog().warn((CharSequence)("Dependency for proguard defined twice! This may lead to unexpected results: " + artifact2.getArtifactId() + ":" + artifact2.getVersion() + " | " + string + ":" + artifact.getVersion()));
                break;
            }
            proguardArtifacts.add(artifact);
        }
        if (!proguardArtifacts.isEmpty()) {
            ArrayList<File> resList = new ArrayList<File>(proguardArtifacts.size());
            for (Artifact artifact : proguardArtifacts) {
                this.getLog().debug((CharSequence)("proguardArtifact: " + artifact.getFile()));
                resList.add(artifact.getFile().getAbsoluteFile());
            }
            return resList;
        }
        this.getLog().info((CharSequence)"proguard jar not found in pluginArtifacts");
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        String classResource = "/" + this.proguardMainClass.replace('.', '/') + ".class";
        URL uRL = cl.getResource(classResource);
        if (uRL == null) {
            throw new MojoExecutionException("Obfuscation failed ProGuard (" + this.proguardMainClass + ") not found in classpath");
        }
        String proguardJar = uRL.toExternalForm();
        if (!proguardJar.startsWith("jar:file:")) {
            throw new MojoExecutionException("Unrecognized location (" + proguardJar + ") in classpath");
        }
        proguardJar = proguardJar.substring("jar:file:".length());
        proguardJar = proguardJar.substring(0, proguardJar.indexOf(33));
        return Collections.singletonList(new File(proguardJar));
    }
}

