/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.AbstractCN1Mojo;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-gui-form")
public class CreateGuiFormMojo
extends AbstractCN1Mojo {
    @Parameter(property="className", required=true)
    private String className;
    @Parameter(property="autoLayout", required=false, defaultValue="true")
    private boolean autoLayout;
    @Parameter(property="guiType", required=true, defaultValue="Form")
    private String guiType;

    private void validateClassName(String className) throws MojoExecutionException {
        String[] classNameParts = className.split("\\.");
        int len = classNameParts.length;
        if (len < 2) {
            throw new MojoExecutionException("GUIBuilder Forms cannot be in the root namespace.  Specify a package.  E.g. -DclassName=com.example.MyForm");
        }
        Pattern p = Pattern.compile("^[a-z][a-z0-9A-Z]*$");
        for (int i = 0; i < len - 1; ++i) {
            if (classNameParts[i].matches("^[a-z][a-z0-9A-Z]*$")) continue;
            throw new MojoExecutionException("className package component " + classNameParts[i] + " does not match the required regular expression ^[a-z][a-z0-9A-Z]*$");
        }
        if (!classNameParts[len - 1].matches("^[A-Z][a-z0-9A-Z]*$")) {
            throw new MojoExecutionException("className validation failed.  Name must conform to regular expression ^[A-Z][a-z0-9A-Z]*$");
        }
    }

    @Override
    protected void executeImpl() throws MojoExecutionException, MojoFailureException {
        if (this.getCN1ProjectDir() == null) {
            this.getLog().debug((CharSequence)"Skipping create-gui-form because this is not a CN1 project");
            return;
        }
        try {
            if (!this.getCN1ProjectDir().getCanonicalFile().equals(this.project.getBasedir().getCanonicalFile())) {
                this.getLog().debug((CharSequence)"Skipping create-gui-form because this is not a CN1 project");
                return;
            }
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"Error trying to convert to canonical paths", (Throwable)ex);
            return;
        }
        this.validateClassName(this.className);
        File guibuilderDir = new File(this.getCN1ProjectDir(), "src" + File.separator + "main" + File.separator + "guibuilder");
        String path = this.className.replace(".", File.separator);
        File guiFile = new File(guibuilderDir, path + ".gui");
        if (guiFile.exists()) {
            throw new MojoExecutionException("GUI File already exists at " + guiFile);
        }
        File guiFileDir = guiFile.getParentFile();
        guiFileDir.mkdirs();
        File javaSrcRoot = new File(this.getCN1ProjectDir(), "src" + File.separator + "main" + File.separator + "java");
        File javaFile = new File(javaSrcRoot, path + ".java");
        if (javaFile.exists()) {
            throw new MojoExecutionException("Java source file already exists at " + javaFile);
        }
        File javaFileDir = javaFile.getParentFile();
        javaFileDir.mkdirs();
        String fileName = this.className.contains(".") ? this.className.substring(this.className.lastIndexOf(".") + 1) : this.className;
        String javaSource = "package " + this.className.substring(0, this.className.lastIndexOf(".")) + ";\npublic class " + fileName + " extends com.codename1.ui." + this.getGUIType() + " {\n    public " + fileName + "() {\n        this(com.codename1.ui.util.Resources.getGlobalResources());\n    }\n    \n    public " + fileName + "(com.codename1.ui.util.Resources resourceObjectInstance) {\n        initGuiBuilderComponents(resourceObjectInstance);\n    }\n    \n//-- DON'T EDIT BELOW THIS LINE!!!\n    private void initGuiBuilderComponents(com.codename1.ui.util.Resources resourceObjectInstance) {\n    }\n//-- DON'T EDIT ABOVE THIS LINE!!!\n}\n";
        String xmlGUISource = this.getGUIType().equalsIgnoreCase("Container") ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<component type=\"Container\" layout=\"" + this.getLayout() + "\" name=\"" + fileName + "\"" + this.getAutoLayout() + "></component>" : "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<component type=\"" + this.getGUIType() + "\" layout=\"" + this.getLayout() + "\" title=\"" + fileName + "\" name=\"" + fileName + "\"" + this.getAutoLayout() + "></component>";
        try {
            this.getLog().info((CharSequence)("Writing " + guiFile));
            FileUtils.writeStringToFile((File)guiFile, (String)xmlGUISource);
            this.getLog().info((CharSequence)("Writing " + javaFile));
            FileUtils.writeStringToFile((File)javaFile, (String)javaSource);
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"Failed to write source files");
            throw new MojoExecutionException("Failed to write source files", (Exception)ex);
        }
        this.getLog().info((CharSequence)("2 files created successfully.  Open the gui file in the gui builder using \nmvn cn1:guibuilder -DclassName=" + this.className));
    }

    protected String getGUIType() {
        return this.guiType;
    }

    protected String getAutoLayout() {
        if (this.isAutoLayout()) {
            return " autoLayout=\"true\"";
        }
        return "";
    }

    protected String getLayout() {
        return this.isAutoLayout() ? "LayeredLayout" : "FlowLayout";
    }

    private boolean isAutoLayout() {
        return this.autoLayout;
    }
}

