/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.ant.SortedProperties;
import com.codename1.maven.Cn1libInstaller;
import com.codename1.maven.PathUtil;
import com.codename1.maven.ProjectTemplate;
import com.codename1.util.RichPropertiesReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.jdom.etl.JDomModelETL;
import org.apache.maven.model.jdom.etl.JDomModelETLFactory;
import org.apache.maven.model.jdom.etl.ModelETLRequest;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;

@Mojo(name="generate-app-project", requiresProject=false)
public class GenerateAppProjectMojo
extends AbstractMojo {
    @Parameter(property="sourceProject")
    private File sourceProject;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="version", defaultValue="1.0-SNAPSHOT")
    private String version;
    private Properties sourceProperties;
    private Properties generateAppProjectProperties;
    private Project antProject;

    private Properties loadSourceProjectProperties() throws IOException {
        File propsFile;
        Properties props = new Properties();
        if (this.sourceProject.isDirectory() && (propsFile = new File(this.sourceProject, "codenameone_settings.properties")).exists()) {
            try (FileInputStream fis = new FileInputStream(propsFile);){
                props.load(fis);
            }
        }
        return props;
    }

    private void generateProject() throws MojoExecutionException {
        String archetypeVersion = "LATEST";
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read(((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/com.codenameone/codenameone-maven-plugin/pom.xml"));
            archetypeVersion = model.getVersion();
        }
        catch (Exception ex) {
            this.getLog().warn((CharSequence)"Attempted to read archetype version from embedded pom.xml file but failed", (Throwable)ex);
        }
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setGoals(Collections.singletonList("archetype:generate"));
        request.setBatchMode(true);
        String[] propsArr = new String[]{"interactiveMode=false", "archetypeArtifactId=cn1app-archetype", "archetypeGroupId=com.codenameone", "archetypeVersion=" + archetypeVersion, "artifactId=" + this.artifactId, "groupId=" + this.groupId, "version=" + this.version, "mainName=" + this.mainName(), "package=" + this.packageName()};
        Properties props = new Properties();
        for (String prop : propsArr) {
            int eqpos = prop.indexOf("=");
            if (eqpos > 0) {
                props.setProperty(prop.substring(0, eqpos), prop.substring(eqpos + 1));
                continue;
            }
            if (eqpos >= 0) continue;
            props.setProperty(prop, "true");
        }
        if (this.getLog().isDebugEnabled()) {
            request.setDebug(true);
        }
        request.setShowErrors(true);
        request.setProperties(props);
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() != 0) {
                throw new MojoExecutionException("Failed to generate project using cn1app-archetype.  Exit code " + result.getExitCode());
            }
        }
        catch (MavenInvocationException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    private File targetProjectDir() {
        return new File(this.artifactId);
    }

    private File targetCommonDir() {
        return new File(this.targetProjectDir(), "common");
    }

    private File targetIosDir() {
        return new File(this.targetProjectDir(), "ios");
    }

    private File targetAndroidDir() {
        return new File(this.targetProjectDir(), "android");
    }

    private File targetJavascriptDir() {
        return new File(this.targetProjectDir(), "javascript");
    }

    private File targetJavaseDir() {
        return new File(this.targetProjectDir(), "javase");
    }

    private File targetWinDir() {
        return new File(this.targetProjectDir(), "win");
    }

    private File targetSrcDir() {
        return new File(this.targetCommonDir(), "src");
    }

    private File targetSrcDir(String type) {
        return new File(this.targetSrcDir(), PathUtil.path("main", type));
    }

    private File targetTestSrcDir(String type) {
        return new File(this.targetSrcDir(), PathUtil.path("test", type));
    }

    private File sourceSrcDir() {
        return new File(this.sourceProject, "src");
    }

    private File sourceTestsDir() {
        return new File(this.sourceProject, "test");
    }

    private File sourceNativeDir() {
        return new File(this.sourceProject, "native");
    }

    private File sourceNativeDir(String type) {
        return new File(this.sourceNativeDir(), type);
    }

    private void copyPropertiesFiles() throws IOException {
        for (File child : this.sourceProject.listFiles()) {
            if (!child.getName().endsWith(".properties")) continue;
            FileUtils.copyFile((File)child, (File)new File(this.targetCommonDir(), child.getName()));
        }
    }

    private Properties sourceProperties() throws IOException {
        if (this.sourceProperties == null) {
            this.sourceProperties = this.loadSourceProjectProperties();
        }
        return this.sourceProperties;
    }

    private File sourceIconFile() throws IOException {
        File iconFile;
        Properties props = this.sourceProperties();
        String icon = props.getProperty("codename1.icon");
        if (icon == null || icon.isEmpty()) {
            icon = "icon.png";
        }
        if (!(iconFile = new File(icon)).isAbsolute() && (iconFile = new File(this.sourceProject, icon)).isFile()) {
            return iconFile;
        }
        return new File(this.sourceProject, "icon.png");
    }

    private File destIconFile() throws IOException {
        return new File(this.targetCommonDir(), this.sourceIconFile().getName());
    }

    private void copyIcon() throws IOException {
        File sourceIconFile = this.sourceIconFile();
        if (sourceIconFile.exists() && sourceIconFile.isFile()) {
            FileUtils.copyFile((File)this.sourceIconFile(), (File)this.destIconFile());
        } else {
            try (InputStream iconStream = ((Object)((Object)this)).getClass().getResourceAsStream("codenameone-icon.png");){
                FileUtils.copyInputStreamToFile((InputStream)iconStream, (File)this.destIconFile());
            }
        }
        SortedProperties props = new SortedProperties();
        File propertiesFile = new File(this.targetCommonDir(), "codenameone_settings.properties");
        try (FileInputStream input = new FileInputStream(propertiesFile);){
            props.load(input);
        }
        if (!this.destIconFile().getName().equals(props.getProperty("codename1.icon"))) {
            props.setProperty("codename1.icon", this.destIconFile().getName());
            var5_8 = null;
            try (FileOutputStream output = new FileOutputStream(propertiesFile);){
                props.store(output, "Updated icon");
            }
            catch (Throwable throwable) {
                var5_8 = throwable;
                throw throwable;
            }
        }
    }

    private boolean hasFilesWithSuffix(File root, String suffix) {
        if (root.isDirectory()) {
            for (File child : root.listFiles()) {
                if (!child.getName().endsWith(suffix)) continue;
                return true;
            }
            for (File child : root.listFiles()) {
                if (!child.isDirectory() || !this.hasFilesWithSuffix(child, suffix)) continue;
                return true;
            }
        }
        return false;
    }

    private void copyIosFiles() {
        if (this.sourceNativeDir("ios").exists()) {
            File srcDir = new File(this.targetIosDir(), PathUtil.path("src", "main", "objectivec"));
            File resDir = new File(this.targetIosDir(), PathUtil.path("src", "main", "resources"));
            Copy copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(srcDir);
            copy.setOverwrite(true);
            FileSet files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("ios"));
            files.setIncludes("**/*.m, **/*.c, **/*.h, *.m, *.c, *.h");
            copy.addFileset(files);
            copy.execute();
            copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(resDir);
            copy.setOverwrite(true);
            files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("ios"));
            files.setExcludes("**/*.m, **/*.c, **/*.h, *.m, *.c, *.h");
            copy.addFileset(files);
            copy.execute();
        }
    }

    private void copyAndroidFiles() {
        if (this.sourceNativeDir("android").exists()) {
            File srcDir = new File(this.targetAndroidDir(), PathUtil.path("src", "main", "java"));
            File resDir = new File(this.targetAndroidDir(), PathUtil.path("src", "main", "resources"));
            Copy copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(srcDir);
            copy.setOverwrite(true);
            FileSet files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("android"));
            files.setIncludes("**/*.java, *.java");
            copy.addFileset(files);
            copy.execute();
            copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(resDir);
            copy.setOverwrite(true);
            files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("android"));
            files.setExcludes("**/*.java, *.java");
            copy.addFileset(files);
            copy.execute();
        }
    }

    private void copyJavascriptFiles() {
        if (this.sourceNativeDir("javascript").exists()) {
            File srcDir = new File(this.targetJavascriptDir(), PathUtil.path("src", "main", "javascript"));
            File resDir = new File(this.targetJavascriptDir(), PathUtil.path("src", "main", "resources"));
            Copy copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(srcDir);
            copy.setOverwrite(true);
            FileSet files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("javascript"));
            files.setIncludes("**/*.js, *.js");
            copy.addFileset(files);
            copy.execute();
            copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(resDir);
            copy.setOverwrite(true);
            files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("javascript"));
            files.setExcludes("**/*.js, *.js");
            copy.addFileset(files);
            copy.execute();
        }
    }

    private void copyWinFiles() {
        if (this.sourceNativeDir("win").exists()) {
            File srcDir = new File(this.targetWinDir(), PathUtil.path("src", "main", "csharp"));
            File resDir = new File(this.targetWinDir(), PathUtil.path("src", "main", "resources"));
            Copy copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(srcDir);
            copy.setOverwrite(true);
            FileSet files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("win"));
            files.setIncludes("**/*.cs, *.cs");
            copy.addFileset(files);
            copy.execute();
            copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(resDir);
            copy.setOverwrite(true);
            files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("win"));
            files.setExcludes("**/*.cs, *.cs");
            copy.addFileset(files);
            copy.execute();
        }
    }

    private File sourceLibDir() {
        return new File(this.sourceProject, "lib");
    }

    private File sourceCSSDir() {
        return new File(this.sourceProject, "css");
    }

    private void fixCSS(File cssFile) throws IOException {
        int closingQuote;
        File targetFile;
        File referencedFile;
        String path;
        int closingParen;
        String contents = FileUtils.readFileToString((File)cssFile, (String)"UTF-8");
        int pos = 0;
        int matchPos = -1;
        boolean changed = false;
        while ((matchPos = contents.indexOf("url(../", pos)) >= 0 && (closingParen = contents.indexOf(")", matchPos + 4)) >= 0) {
            path = contents.substring(matchPos + 4, closingParen);
            if (path.contains("(") || path.contains("{") || path.contains("}") || path.contains("\n")) {
                pos = matchPos + 4;
                continue;
            }
            referencedFile = new File(this.sourceCSSDir(), path.replace("/", File.separator));
            if (referencedFile.exists()) {
                targetFile = new File(this.targetSrcDir("css"), referencedFile.getName());
                if (targetFile.exists()) {
                    pos = closingParen + 1;
                    continue;
                }
                FileUtils.copyFile((File)referencedFile, (File)targetFile);
                contents = contents.substring(0, matchPos) + "url(\"" + targetFile.getName() + "\")" + contents.substring(closingParen + 1);
                closingParen = contents.indexOf(")", matchPos + 4);
                changed = true;
            }
            pos = closingParen + 1;
        }
        while ((matchPos = contents.indexOf("url(\"../", pos)) >= 0 && (closingQuote = contents.indexOf("\"", matchPos + 5)) >= 0) {
            path = contents.substring(matchPos + 5, closingQuote);
            if (path.contains("(") || path.contains("{") || path.contains("}") || path.contains("\n")) {
                pos = matchPos + 5;
                continue;
            }
            referencedFile = new File(this.sourceCSSDir(), path.replace("/", File.separator));
            if (referencedFile.exists()) {
                targetFile = new File(this.targetSrcDir("css"), referencedFile.getName());
                if (targetFile.exists()) {
                    pos = closingQuote + 1;
                    continue;
                }
                FileUtils.copyFile((File)referencedFile, (File)targetFile);
                contents = contents.substring(0, matchPos) + "url(\"" + targetFile.getName() + "\"" + contents.substring(closingQuote + 1);
                closingQuote = contents.indexOf("\"", matchPos + 5);
                changed = true;
            }
            pos = closingQuote + 1;
        }
        while ((matchPos = contents.indexOf("url('../", pos)) >= 0 && (closingQuote = contents.indexOf("'", matchPos + 5)) >= 0) {
            path = contents.substring(matchPos + 5, closingQuote);
            if (path.contains("(") || path.contains("{") || path.contains("}") || path.contains("\n")) {
                pos = matchPos + 5;
                continue;
            }
            referencedFile = new File(this.sourceCSSDir(), path.replace("/", File.separator));
            if (referencedFile.exists()) {
                targetFile = new File(this.targetSrcDir("css"), referencedFile.getName());
                if (targetFile.exists()) {
                    pos = closingQuote + 1;
                    continue;
                }
                FileUtils.copyFile((File)referencedFile, (File)targetFile);
                contents = contents.substring(0, matchPos) + "url(\"" + targetFile.getName() + "\"" + contents.substring(closingQuote + 1);
                closingQuote = contents.indexOf("\"", matchPos + 5);
                changed = true;
            }
            pos = closingQuote + 1;
        }
        if (changed) {
            FileUtils.writeStringToFile((File)cssFile, (String)contents, (String)"UTF-8");
        }
    }

    private void copyCSSFiles() throws IOException {
        File srcDir = this.targetSrcDir("css");
        if (this.sourceCSSDir().exists()) {
            File backups;
            Copy copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(srcDir);
            copy.setOverwrite(true);
            FileSet files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceCSSDir());
            files.setIncludes("**");
            copy.addFileset(files);
            copy.execute();
            if (srcDir.isDirectory()) {
                for (File child : srcDir.listFiles()) {
                    if (child.getName().endsWith(".css")) {
                        this.fixCSS(child);
                        continue;
                    }
                    if (!child.getName().endsWith(".checksums")) continue;
                    child.delete();
                }
            }
            if ((backups = new File(srcDir, ".backups")).isDirectory()) {
                FileUtils.deleteDirectory((File)backups);
            }
        } else if (srcDir.exists()) {
            FileUtils.deleteDirectory((File)srcDir);
        }
    }

    private void copyJavaseFiles() {
        if (this.sourceNativeDir("javase").exists()) {
            File srcDir = new File(this.targetJavaseDir(), PathUtil.path("src", "main", "java"));
            File resDir = new File(this.targetJavaseDir(), PathUtil.path("src", "main", "resources"));
            Copy copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(srcDir);
            copy.setOverwrite(true);
            FileSet files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("javase"));
            files.setIncludes("**/*.java, *.java");
            copy.addFileset(files);
            copy.execute();
            copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(resDir);
            copy.setOverwrite(true);
            files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("javase"));
            files.setExcludes("**/*.java, *.java");
            copy.addFileset(files);
            copy.execute();
            if (resDir.isDirectory()) {
                for (File child : resDir.listFiles()) {
                    if (!child.getName().endsWith(".jar")) continue;
                    this.getLog().warn((CharSequence)("Found jar file '" + child.getName() + "' in the native/javase directory.  This has been copied to " + child + ", but you should remove this file and replace it with the equivalent Maven dependency inside your " + new File(this.targetJavaseDir(), "pom.xml") + " file."));
                }
            }
        }
    }

    private void copyTestSourceFiles() {
        if (!this.sourceTestsDir().exists()) {
            this.getLog().debug((CharSequence)"Source project does not include a test directory.  Skipping copying test source files");
            return;
        }
        this.getLog().debug((CharSequence)("Copying test source files from " + this.sourceTestsDir()));
        Copy copy = (Copy)this.antProject().createTask("copy");
        copy.setTodir(this.targetTestSrcDir("java"));
        copy.setOverwrite(true);
        FileSet files = new FileSet();
        files.setProject(this.antProject());
        files.setDir(this.sourceTestsDir());
        files.setIncludes("**/*.java, *.java");
        copy.addFileset(files);
        copy.execute();
        copy = (Copy)this.antProject().createTask("copy");
        copy.setTodir(this.targetTestSrcDir("resources"));
        copy.setOverwrite(true);
        files = new FileSet();
        files.setProject(this.antProject());
        files.setDir(this.sourceTestsDir());
        files.setExcludes("**/*.kt, **/*.java, **/*.mirah, *.kt, *.java, *.mirah");
        copy.addFileset(files);
        copy.execute();
        if (this.hasFilesWithSuffix(this.sourceSrcDir(), ".kt")) {
            this.targetSrcDir("kotlin").mkdirs();
            copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(this.targetTestSrcDir("kotlin"));
            copy.setOverwrite(true);
            files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceTestsDir());
            files.setIncludes("**/*.kt, *.kt");
            copy.addFileset(files);
            copy.execute();
        }
        if (this.hasFilesWithSuffix(this.sourceSrcDir(), ".mirah")) {
            this.targetSrcDir("mirah").mkdirs();
            copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(this.targetTestSrcDir("mirah"));
            copy.setOverwrite(true);
            files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceTestsDir());
            files.setIncludes("**/*.mirah, *.mirah");
            copy.addFileset(files);
            copy.execute();
        }
    }

    private void copySourceFiles() {
        Copy copy = (Copy)this.antProject().createTask("copy");
        copy.setTodir(this.targetSrcDir("java"));
        copy.setOverwrite(true);
        FileSet files = new FileSet();
        files.setProject(this.antProject());
        files.setDir(this.sourceSrcDir());
        files.setIncludes("**/*.java, *.java");
        copy.addFileset(files);
        copy.execute();
        copy = (Copy)this.antProject().createTask("copy");
        copy.setTodir(this.targetSrcDir("resources"));
        copy.setOverwrite(true);
        files = new FileSet();
        files.setProject(this.antProject());
        files.setDir(this.sourceSrcDir());
        files.setExcludes("**/*.kt, **/*.java, **/*.mirah, *.kt, *.java, *.mirah");
        copy.addFileset(files);
        copy.execute();
        File cn1PropertiesFile = new File(this.sourceProject, "codenameone_settings.properties");
        if (cn1PropertiesFile.exists()) {
            File themeRes;
            SortedProperties cn1Properties = new SortedProperties();
            try (FileInputStream input = new FileInputStream(cn1PropertiesFile);){
                cn1Properties.load(input);
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)("Failed to open " + cn1Properties + " while checking or cssTheme property"), (Throwable)ex);
            }
            if ("true".equals(cn1Properties.getProperty("codename1.cssTheme", "false")) && (themeRes = new File(this.targetSrcDir("resources"), "theme.res")).exists()) {
                this.getLog().debug((CharSequence)("Deleting " + themeRes + " because this project uses CSS themes.  In maven the theme.res is generated at build time, and is never saved in the source directory."));
                themeRes.delete();
            }
        }
        if (this.hasFilesWithSuffix(this.sourceSrcDir(), ".kt")) {
            this.targetSrcDir("kotlin").mkdirs();
            copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(this.targetSrcDir("kotlin"));
            copy.setOverwrite(true);
            files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceSrcDir());
            files.setIncludes("**/*.kt, *.kt");
            copy.addFileset(files);
            copy.execute();
        }
        if (this.hasFilesWithSuffix(this.sourceSrcDir(), ".mirah")) {
            this.targetSrcDir("mirah").mkdirs();
            copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(this.targetSrcDir("mirah"));
            copy.setOverwrite(true);
            files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceSrcDir());
            files.setIncludes("**/*.mirah, *.mirah");
            copy.addFileset(files);
            copy.execute();
        }
    }

    private Properties generateAppProjectProperties() throws IOException, RichPropertiesReader.ConfigSyntaxException {
        if (this.generateAppProjectProperties == null) {
            this.generateAppProjectProperties = new Properties();
            if (this.generateAppProjectConfigFile().exists()) {
                new RichPropertiesReader().load(this.generateAppProjectConfigFile(), this.generateAppProjectProperties);
            }
        }
        return this.generateAppProjectProperties;
    }

    private String packageName() {
        if (System.getProperty("packageName") != null) {
            return System.getProperty("packageName");
        }
        if (System.getProperty("package") != null) {
            return System.getProperty("package");
        }
        return this.groupId;
    }

    private String mainName() {
        if (System.getProperty("mainName") != null) {
            return System.getProperty("mainName");
        }
        StringBuilder sb = new StringBuilder();
        int len = this.artifactId.length();
        boolean firstChar = true;
        boolean capNext = false;
        for (int i = 0; i < len; ++i) {
            char ch = this.artifactId.charAt(i);
            if (firstChar) {
                if (!Character.isLetter(ch)) continue;
                sb.append(Character.toUpperCase(ch));
                firstChar = false;
                continue;
            }
            if (Character.isLetterOrDigit(ch)) {
                if (capNext) {
                    sb.append(Character.toUpperCase(ch));
                    capNext = false;
                    continue;
                }
                sb.append(ch);
                continue;
            }
            capNext = true;
        }
        return sb.toString();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Properties props;
            try {
                props = this.generateAppProjectProperties();
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Failed to load " + this.generateAppProjectConfigFile(), ex);
            }
            String templateType = props.getProperty("template.type");
            if (templateType == null) {
                Properties sourceAntProjectCn1Properties = this.loadSourceProjectProperties();
                if (sourceAntProjectCn1Properties.getProperty("codename1.mainName") != null) {
                    System.setProperty("mainName", sourceAntProjectCn1Properties.getProperty("codename1.mainName"));
                }
                if (sourceAntProjectCn1Properties.getProperty("codename1.packageName") != null) {
                    System.setProperty("packageName", sourceAntProjectCn1Properties.getProperty("codename1.packageName"));
                }
            }
            this.generateProject();
            if (templateType != null) {
                File dest = new File(this.targetProjectDir(), PathUtil.path("target", "codenameone", "tmpProject"));
                dest.getParentFile().mkdirs();
                FileUtils.copyDirectory((File)this.sourceProject, (File)dest);
                File origSource = this.sourceProject;
                this.sourceProject = dest;
                Properties renderProperties = new Properties();
                renderProperties.put("packageName", this.packageName());
                renderProperties.put("mainName", this.mainName());
                renderProperties.putAll((Map<?, ?>)System.getProperties());
                ProjectTemplate tpl = new ProjectTemplate(this.sourceProject, renderProperties);
                if (props.getProperty("template.mainName") != null && props.getProperty("template.packageName") != null) {
                    tpl.convertToTemplate(props.getProperty("template.packageName"), props.getProperty("template.mainName"));
                }
                tpl.processFiles();
            }
            if (templateType == null || "ant".equalsIgnoreCase(templateType)) {
                this.copyPropertiesFiles();
                this.copyIcon();
                this.copySourceFiles();
                this.copyTestSourceFiles();
                this.copyAndroidFiles();
                this.copyIosFiles();
                this.copyJavascriptFiles();
                this.copyWinFiles();
                this.copyJavaseFiles();
                this.copyCSSFiles();
                this.copyCn1libs();
                this.injectDependencies();
            } else if ("maven".equalsIgnoreCase(templateType)) {
                File src = new File(this.sourceProject, PathUtil.path("common", "src"));
                File destSrc = new File(this.targetProjectDir(), PathUtil.path("common", "src"));
                if (src.exists()) {
                    FileUtils.deleteDirectory((File)destSrc);
                    FileUtils.copyDirectory((File)src, (File)destSrc);
                }
                File cn1Settings = new File(this.sourceProject, PathUtil.path("common", "codenameone_settings.properties"));
                File destCn1Settings = new File(this.targetProjectDir(), PathUtil.path("common", "codenameone_settings.properties"));
                if (cn1Settings.exists()) {
                    FileUtils.copyFile((File)cn1Settings, (File)destCn1Settings);
                }
                for (File child : new File(this.sourceProject, "common").listFiles()) {
                    if (!child.getName().endsWith(".png")) continue;
                    FileUtils.copyFile((File)child, (File)new File(this.targetProjectDir(), PathUtil.path("common", child.getName())));
                }
                this.injectDependencies();
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to copy files", (Exception)ex);
        }
    }

    private Project antProject() {
        if (this.antProject == null) {
            this.antProject = new Project();
            this.antProject.setBaseDir(this.sourceProject);
            this.antProject.setDefaultInputStream(System.in);
            DefaultInputHandler handler = new DefaultInputHandler();
            this.antProject.setProjectReference((Object)handler);
            this.antProject.setInputHandler((InputHandler)handler);
            this.antProject.init();
        }
        return this.antProject;
    }

    private void copyCn1libs() throws MojoExecutionException, MojoFailureException {
        if (this.sourceLibDir() == null || !this.sourceLibDir().exists() || !this.sourceLibDir().isDirectory()) {
            return;
        }
        for (File cn1lib : this.sourceLibDir().listFiles()) {
            if (cn1lib.getName().startsWith("kotlin-runtime")) {
                this.getLog().debug((CharSequence)("Skipping " + cn1lib + " because kotlin no longer requires a cn1lib."));
                continue;
            }
            if (!cn1lib.getName().endsWith(".cn1lib")) continue;
            this.installLegacyCn1lib(cn1lib);
        }
    }

    private static String getBaseName(File file) {
        return file.getName().substring(0, file.getName().indexOf("."));
    }

    private void installLegacyCn1lib(File cn1lib) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Installing cn1lib " + cn1lib));
        Cn1libInstaller installer = new Cn1libInstaller(new File(this.targetProjectDir(), "common"), this.groupId, this.artifactId, this.version, this.getLog());
        installer.setFile(cn1lib);
        installer.setOverwrite(false);
        installer.setUpdatePom(true);
        installer.executeImpl();
    }

    private File generateAppProjectConfigFile() {
        return new File(this.sourceProject, "generate-app-project.rpf");
    }

    private File targetCommonPomXml() {
        return new File(this.targetCommonDir(), "pom.xml");
    }

    private File targetRootPomXml() {
        return new File(this.targetProjectDir(), "pom.xml");
    }

    private void injectDependencies() throws MojoExecutionException {
        block16: {
            if (!this.generateAppProjectConfigFile().exists()) {
                return;
            }
            try {
                Model dummyModel;
                MavenXpp3Reader reader;
                String dummyModelStr;
                Model model;
                JDomModelETL modelETL;
                ModelETLRequest modelETLRequest;
                Properties props = new Properties();
                new RichPropertiesReader().load(this.generateAppProjectConfigFile(), props);
                String dependencies = props.getProperty("dependencies");
                String parentDependencies = props.getProperty("parentDependencies");
                if (this.targetCommonPomXml().exists()) {
                    try {
                        modelETLRequest = new ModelETLRequest();
                        modelETL = new JDomModelETLFactory().newInstance(modelETLRequest);
                        modelETL.extract(this.targetCommonPomXml());
                        model = modelETL.getModel();
                    }
                    catch (Exception ex) {
                        throw new MojoExecutionException("Failed to read pom.xml file from " + this.targetCommonPomXml(), ex);
                    }
                    if (dependencies != null) {
                        dummyModelStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n    <groupId>link.sharpe</groupId>\n    <artifactId>mavenproject1</artifactId>\n    <version>1.0-SNAPSHOT</version>\n    <dependencies>\n" + dependencies + "    </dependencies>\n</project>";
                        try {
                            reader = new MavenXpp3Reader();
                            dummyModel = reader.read((Reader)new CharArrayReader(dummyModelStr.toCharArray()));
                        }
                        catch (Exception ex) {
                            throw new MojoExecutionException("Failed to read dummy pom.xml file while injecting dependencies into " + this.targetCommonPomXml(), ex);
                        }
                        for (Dependency dep : dummyModel.getDependencies()) {
                            model.addDependency(dep);
                        }
                        modelETL.load(this.targetCommonPomXml());
                    }
                }
                if (!this.targetRootPomXml().exists()) break block16;
                try {
                    modelETLRequest = new ModelETLRequest();
                    modelETL = new JDomModelETLFactory().newInstance(modelETLRequest);
                    modelETL.extract(this.targetRootPomXml());
                    model = modelETL.getModel();
                }
                catch (Exception ex) {
                    throw new MojoExecutionException("Failed to read pom.xml file from " + this.targetRootPomXml(), ex);
                }
                if (parentDependencies == null) break block16;
                dummyModelStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n    <groupId>link.sharpe</groupId>\n    <artifactId>mavenproject1</artifactId>\n    <version>1.0-SNAPSHOT</version>\n    <dependencies>\n" + parentDependencies + "    </dependencies>\n</project>";
                try {
                    reader = new MavenXpp3Reader();
                    dummyModel = reader.read((Reader)new CharArrayReader(dummyModelStr.toCharArray()));
                }
                catch (Exception ex) {
                    throw new MojoExecutionException("Failed to read dummy pom.xml file while injecting dependencies into " + this.targetRootPomXml(), ex);
                }
                for (Dependency dep : dummyModel.getDependencies()) {
                    model.addDependency(dep);
                }
                modelETL.load(this.targetRootPomXml());
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to process configuration for generateAppProjectConfigFile " + this.generateAppProjectConfigFile(), (Exception)ex);
            }
            catch (RichPropertiesReader.ConfigSyntaxException ex) {
                throw new MojoExecutionException("Failed to process configuration for generateAppProjectConfigFile " + this.generateAppProjectConfigFile(), (Exception)ex);
            }
        }
    }
}

